// SPDX-License-Identifier: GPL-2.0+
/*
 *  comedi/drivers/ni_routing/ni_device_routes/pxie-6738.c
 *  List of valid routes for specific NI boards.
 *
 *  COMEDI - Linux Control and Measurement Device Interface
 *  Copyright (C) 2016 Spencer E. Olson <olsonse@umich.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

/*
 * The contents of this file are generated using the tools in
 * comedi/drivers/ni_routing/tools
 *
 * Please use those tools to help maintain the contents of this file.
 */

#include "../ni_device_routes.h"
#include "all.h"

struct ni_device_routes ni_pxie_6738_device_routes = {
	.device = "pxie-6738",
	.routes = (struct ni_route_set[]){
		{
			.dest = NI_PFI(0),
			.src = (int[]){
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(1),
			.src = (int[]){
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(2),
			.src = (int[]){
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(3),
			.src = (int[]){
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(4),
			.src = (int[]){
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(5),
			.src = (int[]){
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(6),
			.src = (int[]){
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(7),
			.src = (int[]){
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrZ(0),
				NI_CtrZ(1),
				NI_CtrZ(2),
				NI_CtrZ(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrZ(0),
				NI_CtrZ(1),
				NI_CtrZ(2),
				NI_CtrZ(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrZ(0),
				NI_CtrZ(1),
				NI_CtrZ(2),
				NI_CtrZ(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrZ(0),
				NI_CtrZ(1),
				NI_CtrZ(2),
				NI_CtrZ(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(4),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrZ(0),
				NI_CtrZ(1),
				NI_CtrZ(2),
				NI_CtrZ(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(5),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrZ(0),
				NI_CtrZ(1),
				NI_CtrZ(2),
				NI_CtrZ(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(6),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrZ(0),
				NI_CtrZ(1),
				NI_CtrZ(2),
				NI_CtrZ(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(7),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrZ(0),
				NI_CtrZ(1),
				NI_CtrZ(2),
				NI_CtrZ(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				PXI_Clk10,
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_20MHzTimebase,
				NI_100MHzTimebase,
				NI_100kHzTimebase,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				PXI_Clk10,
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_20MHzTimebase,
				NI_100MHzTimebase,
				NI_100kHzTimebase,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(3),
				PXI_Clk10,
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_20MHzTimebase,
				NI_100MHzTimebase,
				NI_100kHzTimebase,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				PXI_Clk10,
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_20MHzTimebase,
				NI_100MHzTimebase,
				NI_100kHzTimebase,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrA(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrA(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrA(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrA(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrB(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrB(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrB(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrB(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrZ(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrZ(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrZ(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrZ(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSampleClock(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSampleClock(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSampleClock(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSampleClock(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_AO_SampleClock,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClockTimebase,
				NI_DI_SampleClock,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_AO_SampleClockTimebase,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				PXI_Clk10,
				NI_20MHzTimebase,
				NI_100MHzTimebase,
				NI_100kHzTimebase,
				0, /* Termination */
			}
		},
		{
			.dest = NI_AO_StartTrigger,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_AO_PauseTrigger,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_DI_SampleClock,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_DI_SampleClockTimebase,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				PXI_Clk10,
				NI_DI_SampleClockTimebase,
				NI_20MHzTimebase,
				NI_100MHzTimebase,
				NI_100kHzTimebase,
				0, /* Termination */
			}
		},
		{
			.dest = NI_DI_StartTrigger,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_DI_ReferenceTrigger,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_DI_PauseTrigger,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DO_SampleClock,
				NI_DO_StartTrigger,
				NI_DO_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_DO_SampleClock,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_DO_SampleClockTimebase,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_DO_SampleClockTimebase,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				PXI_Clk10,
				NI_20MHzTimebase,
				NI_100MHzTimebase,
				NI_100kHzTimebase,
				0, /* Termination */
			}
		},
		{
			.dest = NI_DO_StartTrigger,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_DO_PauseTrigger,
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrArmStartTrigger(0),
				NI_CtrArmStartTrigger(1),
				NI_CtrArmStartTrigger(2),
				NI_CtrArmStartTrigger(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrSampleClock(0),
				NI_CtrSampleClock(1),
				NI_CtrSampleClock(2),
				NI_CtrSampleClock(3),
				NI_AO_SampleClock,
				NI_AO_StartTrigger,
				NI_AO_PauseTrigger,
				NI_DI_SampleClock,
				NI_DI_StartTrigger,
				NI_DI_ReferenceTrigger,
				NI_DI_PauseTrigger,
				NI_10MHzRefClock,
				NI_ChangeDetectionEvent,
				NI_WatchdogExpiredEvent,
				0, /* Termination */
			}
		},
		{
			.dest = NI_WatchdogExpirationTrigger,
			.src = (int[]){
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				0, /* Termination */
			}
		},
		{ /* Termination of list */
			.dest = 0,
		},
	},
};
