/*
 * Copyright 2022 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _vcn_4_0_3_OFFSET_HEADER
#define _vcn_4_0_3_OFFSET_HEADER



// addressBlock: aid_uvd0_uvddec
// base address: 0x1fb00
#define regUVD_TOP_CTRL                                                                                 0x00c0
#define regUVD_TOP_CTRL_BASE_IDX                                                                        1
#define regUVD_CGC_GATE                                                                                 0x00c1
#define regUVD_CGC_GATE_BASE_IDX                                                                        1
#define regUVD_CGC_CTRL                                                                                 0x00c2
#define regUVD_CGC_CTRL_BASE_IDX                                                                        1
#define regAVM_SUVD_CGC_GATE                                                                            0x00c4
#define regAVM_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regCDEFE_SUVD_CGC_GATE                                                                          0x00c4
#define regCDEFE_SUVD_CGC_GATE_BASE_IDX                                                                 1
#define regEFC_SUVD_CGC_GATE                                                                            0x00c4
#define regEFC_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regENT_SUVD_CGC_GATE                                                                            0x00c4
#define regENT_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regIME_SUVD_CGC_GATE                                                                            0x00c4
#define regIME_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regPPU_SUVD_CGC_GATE                                                                            0x00c4
#define regPPU_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regSAOE_SUVD_CGC_GATE                                                                           0x00c4
#define regSAOE_SUVD_CGC_GATE_BASE_IDX                                                                  1
#define regSCM_SUVD_CGC_GATE                                                                            0x00c4
#define regSCM_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regSDB_SUVD_CGC_GATE                                                                            0x00c4
#define regSDB_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regSIT0_NXT_SUVD_CGC_GATE                                                                       0x00c4
#define regSIT0_NXT_SUVD_CGC_GATE_BASE_IDX                                                              1
#define regSIT1_NXT_SUVD_CGC_GATE                                                                       0x00c4
#define regSIT1_NXT_SUVD_CGC_GATE_BASE_IDX                                                              1
#define regSIT2_NXT_SUVD_CGC_GATE                                                                       0x00c4
#define regSIT2_NXT_SUVD_CGC_GATE_BASE_IDX                                                              1
#define regSIT_SUVD_CGC_GATE                                                                            0x00c4
#define regSIT_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regSMPA_SUVD_CGC_GATE                                                                           0x00c4
#define regSMPA_SUVD_CGC_GATE_BASE_IDX                                                                  1
#define regSMP_SUVD_CGC_GATE                                                                            0x00c4
#define regSMP_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regSRE_SUVD_CGC_GATE                                                                            0x00c4
#define regSRE_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regUVD_MPBE0_SUVD_CGC_GATE                                                                      0x00c4
#define regUVD_MPBE0_SUVD_CGC_GATE_BASE_IDX                                                             1
#define regUVD_MPBE1_SUVD_CGC_GATE                                                                      0x00c4
#define regUVD_MPBE1_SUVD_CGC_GATE_BASE_IDX                                                             1
#define regUVD_SUVD_CGC_GATE                                                                            0x00c4
#define regUVD_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regAVM_SUVD_CGC_GATE2                                                                           0x00c5
#define regAVM_SUVD_CGC_GATE2_BASE_IDX                                                                  1
#define regCDEFE_SUVD_CGC_GATE2                                                                         0x00c5
#define regCDEFE_SUVD_CGC_GATE2_BASE_IDX                                                                1
#define regDBR_SUVD_CGC_GATE2                                                                           0x00c5
#define regDBR_SUVD_CGC_GATE2_BASE_IDX                                                                  1
#define regENT_SUVD_CGC_GATE2                                                                           0x00c5
#define regENT_SUVD_CGC_GATE2_BASE_IDX                                                                  1
#define regIME_SUVD_CGC_GATE2                                                                           0x00c5
#define regIME_SUVD_CGC_GATE2_BASE_IDX                                                                  1
#define regMPC1_SUVD_CGC_GATE2                                                                          0x00c5
#define regMPC1_SUVD_CGC_GATE2_BASE_IDX                                                                 1
#define regSAOE_SUVD_CGC_GATE2                                                                          0x00c5
#define regSAOE_SUVD_CGC_GATE2_BASE_IDX                                                                 1
#define regSDB_SUVD_CGC_GATE2                                                                           0x00c5
#define regSDB_SUVD_CGC_GATE2_BASE_IDX                                                                  1
#define regSIT0_NXT_SUVD_CGC_GATE2                                                                      0x00c5
#define regSIT0_NXT_SUVD_CGC_GATE2_BASE_IDX                                                             1
#define regSIT1_NXT_SUVD_CGC_GATE2                                                                      0x00c5
#define regSIT1_NXT_SUVD_CGC_GATE2_BASE_IDX                                                             1
#define regSIT2_NXT_SUVD_CGC_GATE2                                                                      0x00c5
#define regSIT2_NXT_SUVD_CGC_GATE2_BASE_IDX                                                             1
#define regSIT_SUVD_CGC_GATE2                                                                           0x00c5
#define regSIT_SUVD_CGC_GATE2_BASE_IDX                                                                  1
#define regSMPA_SUVD_CGC_GATE2                                                                          0x00c5
#define regSMPA_SUVD_CGC_GATE2_BASE_IDX                                                                 1
#define regSMP_SUVD_CGC_GATE2                                                                           0x00c5
#define regSMP_SUVD_CGC_GATE2_BASE_IDX                                                                  1
#define regSRE_SUVD_CGC_GATE2                                                                           0x00c5
#define regSRE_SUVD_CGC_GATE2_BASE_IDX                                                                  1
#define regUVD_MPBE0_SUVD_CGC_GATE2                                                                     0x00c5
#define regUVD_MPBE0_SUVD_CGC_GATE2_BASE_IDX                                                            1
#define regUVD_MPBE1_SUVD_CGC_GATE2                                                                     0x00c5
#define regUVD_MPBE1_SUVD_CGC_GATE2_BASE_IDX                                                            1
#define regUVD_SUVD_CGC_GATE2                                                                           0x00c5
#define regUVD_SUVD_CGC_GATE2_BASE_IDX                                                                  1
#define regAVM_SUVD_CGC_CTRL                                                                            0x00c6
#define regAVM_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regCDEFE_SUVD_CGC_CTRL                                                                          0x00c6
#define regCDEFE_SUVD_CGC_CTRL_BASE_IDX                                                                 1
#define regDBR_SUVD_CGC_CTRL                                                                            0x00c6
#define regDBR_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regEFC_SUVD_CGC_CTRL                                                                            0x00c6
#define regEFC_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regENT_SUVD_CGC_CTRL                                                                            0x00c6
#define regENT_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regIME_SUVD_CGC_CTRL                                                                            0x00c6
#define regIME_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regMPC1_SUVD_CGC_CTRL                                                                           0x00c6
#define regMPC1_SUVD_CGC_CTRL_BASE_IDX                                                                  1
#define regPPU_SUVD_CGC_CTRL                                                                            0x00c6
#define regPPU_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regSAOE_SUVD_CGC_CTRL                                                                           0x00c6
#define regSAOE_SUVD_CGC_CTRL_BASE_IDX                                                                  1
#define regSCM_SUVD_CGC_CTRL                                                                            0x00c6
#define regSCM_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regSDB_SUVD_CGC_CTRL                                                                            0x00c6
#define regSDB_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regSIT0_NXT_SUVD_CGC_CTRL                                                                       0x00c6
#define regSIT0_NXT_SUVD_CGC_CTRL_BASE_IDX                                                              1
#define regSIT1_NXT_SUVD_CGC_CTRL                                                                       0x00c6
#define regSIT1_NXT_SUVD_CGC_CTRL_BASE_IDX                                                              1
#define regSIT2_NXT_SUVD_CGC_CTRL                                                                       0x00c6
#define regSIT2_NXT_SUVD_CGC_CTRL_BASE_IDX                                                              1
#define regSIT_SUVD_CGC_CTRL                                                                            0x00c6
#define regSIT_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regSMPA_SUVD_CGC_CTRL                                                                           0x00c6
#define regSMPA_SUVD_CGC_CTRL_BASE_IDX                                                                  1
#define regSMP_SUVD_CGC_CTRL                                                                            0x00c6
#define regSMP_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regSRE_SUVD_CGC_CTRL                                                                            0x00c6
#define regSRE_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regUVD_MPBE0_SUVD_CGC_CTRL                                                                      0x00c6
#define regUVD_MPBE0_SUVD_CGC_CTRL_BASE_IDX                                                             1
#define regUVD_MPBE1_SUVD_CGC_CTRL                                                                      0x00c6
#define regUVD_MPBE1_SUVD_CGC_CTRL_BASE_IDX                                                             1
#define regUVD_SUVD_CGC_CTRL                                                                            0x00c6
#define regUVD_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regUVD_CGC_CTRL3                                                                                0x00ca
#define regUVD_CGC_CTRL3_BASE_IDX                                                                       1
#define regUVD_GPCOM_VCPU_DATA0                                                                         0x00d0
#define regUVD_GPCOM_VCPU_DATA0_BASE_IDX                                                                1
#define regUVD_GPCOM_VCPU_DATA1                                                                         0x00d1
#define regUVD_GPCOM_VCPU_DATA1_BASE_IDX                                                                1
#define regUVD_GPCOM_SYS_CMD                                                                            0x00d2
#define regUVD_GPCOM_SYS_CMD_BASE_IDX                                                                   1
#define regUVD_GPCOM_SYS_DATA0                                                                          0x00d3
#define regUVD_GPCOM_SYS_DATA0_BASE_IDX                                                                 1
#define regUVD_GPCOM_SYS_DATA1                                                                          0x00d4
#define regUVD_GPCOM_SYS_DATA1_BASE_IDX                                                                 1
#define regUVD_VCPU_INT_EN                                                                              0x00d5
#define regUVD_VCPU_INT_EN_BASE_IDX                                                                     1
#define regUVD_VCPU_INT_STATUS                                                                          0x00d6
#define regUVD_VCPU_INT_STATUS_BASE_IDX                                                                 1
#define regUVD_VCPU_INT_ACK                                                                             0x00d7
#define regUVD_VCPU_INT_ACK_BASE_IDX                                                                    1
#define regUVD_VCPU_INT_ROUTE                                                                           0x00d8
#define regUVD_VCPU_INT_ROUTE_BASE_IDX                                                                  1
#define regUVD_DRV_FW_MSG                                                                               0x00d9
#define regUVD_DRV_FW_MSG_BASE_IDX                                                                      1
#define regUVD_FW_DRV_MSG_ACK                                                                           0x00da
#define regUVD_FW_DRV_MSG_ACK_BASE_IDX                                                                  1
#define regUVD_SUVD_INT_EN                                                                              0x00db
#define regUVD_SUVD_INT_EN_BASE_IDX                                                                     1
#define regUVD_SUVD_INT_STATUS                                                                          0x00dc
#define regUVD_SUVD_INT_STATUS_BASE_IDX                                                                 1
#define regUVD_SUVD_INT_ACK                                                                             0x00dd
#define regUVD_SUVD_INT_ACK_BASE_IDX                                                                    1
#define regUVD_ENC_VCPU_INT_EN                                                                          0x00de
#define regUVD_ENC_VCPU_INT_EN_BASE_IDX                                                                 1
#define regUVD_ENC_VCPU_INT_STATUS                                                                      0x00df
#define regUVD_ENC_VCPU_INT_STATUS_BASE_IDX                                                             1
#define regUVD_ENC_VCPU_INT_ACK                                                                         0x00e0
#define regUVD_ENC_VCPU_INT_ACK_BASE_IDX                                                                1
#define regUVD_MASTINT_EN                                                                               0x00e1
#define regUVD_MASTINT_EN_BASE_IDX                                                                      1
#define regUVD_SYS_INT_EN                                                                               0x00e2
#define regUVD_SYS_INT_EN_BASE_IDX                                                                      1
#define regUVD_SYS_INT_STATUS                                                                           0x00e3
#define regUVD_SYS_INT_STATUS_BASE_IDX                                                                  1
#define regUVD_SYS_INT_ACK                                                                              0x00e4
#define regUVD_SYS_INT_ACK_BASE_IDX                                                                     1
#define regUVD_JOB_DONE                                                                                 0x00e5
#define regUVD_JOB_DONE_BASE_IDX                                                                        1
#define regUVD_CBUF_ID                                                                                  0x00e6
#define regUVD_CBUF_ID_BASE_IDX                                                                         1
#define regUVD_CONTEXT_ID                                                                               0x00e7
#define regUVD_CONTEXT_ID_BASE_IDX                                                                      1
#define regUVD_CONTEXT_ID2                                                                              0x00e8
#define regUVD_CONTEXT_ID2_BASE_IDX                                                                     1
#define regUVD_NO_OP                                                                                    0x00e9
#define regUVD_NO_OP_BASE_IDX                                                                           1
#define regUVD_RB_BASE_LO                                                                               0x00ea
#define regUVD_RB_BASE_LO_BASE_IDX                                                                      1
#define regUVD_RB_BASE_HI                                                                               0x00eb
#define regUVD_RB_BASE_HI_BASE_IDX                                                                      1
#define regUVD_RB_SIZE                                                                                  0x00ec
#define regUVD_RB_SIZE_BASE_IDX                                                                         1
#define regUVD_RB_BASE_LO2                                                                              0x00ef
#define regUVD_RB_BASE_LO2_BASE_IDX                                                                     1
#define regUVD_RB_BASE_HI2                                                                              0x00f0
#define regUVD_RB_BASE_HI2_BASE_IDX                                                                     1
#define regUVD_RB_SIZE2                                                                                 0x00f1
#define regUVD_RB_SIZE2_BASE_IDX                                                                        1
#define regUVD_RB_BASE_LO3                                                                              0x00f4
#define regUVD_RB_BASE_LO3_BASE_IDX                                                                     1
#define regUVD_RB_BASE_HI3                                                                              0x00f5
#define regUVD_RB_BASE_HI3_BASE_IDX                                                                     1
#define regUVD_RB_SIZE3                                                                                 0x00f6
#define regUVD_RB_SIZE3_BASE_IDX                                                                        1
#define regUVD_RB_BASE_LO4                                                                              0x00f9
#define regUVD_RB_BASE_LO4_BASE_IDX                                                                     1
#define regUVD_RB_BASE_HI4                                                                              0x00fa
#define regUVD_RB_BASE_HI4_BASE_IDX                                                                     1
#define regUVD_RB_SIZE4                                                                                 0x00fb
#define regUVD_RB_SIZE4_BASE_IDX                                                                        1
#define regUVD_OUT_RB_BASE_LO                                                                           0x00fe
#define regUVD_OUT_RB_BASE_LO_BASE_IDX                                                                  1
#define regUVD_OUT_RB_BASE_HI                                                                           0x00ff
#define regUVD_OUT_RB_BASE_HI_BASE_IDX                                                                  1
#define regUVD_OUT_RB_SIZE                                                                              0x0100
#define regUVD_OUT_RB_SIZE_BASE_IDX                                                                     1
#define regUVD_IOV_ACTIVE_FCN_ID                                                                        0x0103
#define regUVD_IOV_ACTIVE_FCN_ID_BASE_IDX                                                               1
#define regUVD_IOV_MAILBOX                                                                              0x0104
#define regUVD_IOV_MAILBOX_BASE_IDX                                                                     1
#define regUVD_IOV_MAILBOX_RESP                                                                         0x0105
#define regUVD_IOV_MAILBOX_RESP_BASE_IDX                                                                1
#define regUVD_RB_ARB_CTRL                                                                              0x0106
#define regUVD_RB_ARB_CTRL_BASE_IDX                                                                     1
#define regUVD_CTX_INDEX                                                                                0x0107
#define regUVD_CTX_INDEX_BASE_IDX                                                                       1
#define regUVD_CTX_DATA                                                                                 0x0108
#define regUVD_CTX_DATA_BASE_IDX                                                                        1
#define regUVD_CXW_WR                                                                                   0x0109
#define regUVD_CXW_WR_BASE_IDX                                                                          1
#define regUVD_CXW_WR_INT_ID                                                                            0x010a
#define regUVD_CXW_WR_INT_ID_BASE_IDX                                                                   1
#define regUVD_CXW_WR_INT_CTX_ID                                                                        0x010b
#define regUVD_CXW_WR_INT_CTX_ID_BASE_IDX                                                               1
#define regUVD_CXW_INT_ID                                                                               0x010c
#define regUVD_CXW_INT_ID_BASE_IDX                                                                      1
#define regUVD_MPEG2_ERROR                                                                              0x010d
#define regUVD_MPEG2_ERROR_BASE_IDX                                                                     1
#define regUVD_YBASE                                                                                    0x0110
#define regUVD_YBASE_BASE_IDX                                                                           1
#define regUVD_UVBASE                                                                                   0x0111
#define regUVD_UVBASE_BASE_IDX                                                                          1
#define regUVD_PITCH                                                                                    0x0112
#define regUVD_PITCH_BASE_IDX                                                                           1
#define regUVD_WIDTH                                                                                    0x0113
#define regUVD_WIDTH_BASE_IDX                                                                           1
#define regUVD_HEIGHT                                                                                   0x0114
#define regUVD_HEIGHT_BASE_IDX                                                                          1
#define regUVD_PICCOUNT                                                                                 0x0115
#define regUVD_PICCOUNT_BASE_IDX                                                                        1
#define regUVD_MPRD_INITIAL_XY                                                                          0x0116
#define regUVD_MPRD_INITIAL_XY_BASE_IDX                                                                 1
#define regUVD_MPEG2_CTRL                                                                               0x0117
#define regUVD_MPEG2_CTRL_BASE_IDX                                                                      1
#define regUVD_MB_CTL_BUF_BASE                                                                          0x0118
#define regUVD_MB_CTL_BUF_BASE_BASE_IDX                                                                 1
#define regUVD_PIC_CTL_BUF_BASE                                                                         0x0119
#define regUVD_PIC_CTL_BUF_BASE_BASE_IDX                                                                1
#define regUVD_DXVA_BUF_SIZE                                                                            0x011a
#define regUVD_DXVA_BUF_SIZE_BASE_IDX                                                                   1
#define regUVD_SCRATCH_NP                                                                               0x011b
#define regUVD_SCRATCH_NP_BASE_IDX                                                                      1
#define regUVD_CLK_SWT_HANDSHAKE                                                                        0x011c
#define regUVD_CLK_SWT_HANDSHAKE_BASE_IDX                                                               1
#define regUVD_GP_SCRATCH0                                                                              0x011e
#define regUVD_GP_SCRATCH0_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH1                                                                              0x011f
#define regUVD_GP_SCRATCH1_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH2                                                                              0x0120
#define regUVD_GP_SCRATCH2_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH3                                                                              0x0121
#define regUVD_GP_SCRATCH3_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH4                                                                              0x0122
#define regUVD_GP_SCRATCH4_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH5                                                                              0x0123
#define regUVD_GP_SCRATCH5_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH6                                                                              0x0124
#define regUVD_GP_SCRATCH6_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH7                                                                              0x0125
#define regUVD_GP_SCRATCH7_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH8                                                                              0x0126
#define regUVD_GP_SCRATCH8_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH9                                                                              0x0127
#define regUVD_GP_SCRATCH9_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH10                                                                             0x0128
#define regUVD_GP_SCRATCH10_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH11                                                                             0x0129
#define regUVD_GP_SCRATCH11_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH12                                                                             0x012a
#define regUVD_GP_SCRATCH12_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH13                                                                             0x012b
#define regUVD_GP_SCRATCH13_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH14                                                                             0x012c
#define regUVD_GP_SCRATCH14_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH15                                                                             0x012d
#define regUVD_GP_SCRATCH15_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH16                                                                             0x012e
#define regUVD_GP_SCRATCH16_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH17                                                                             0x012f
#define regUVD_GP_SCRATCH17_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH18                                                                             0x0130
#define regUVD_GP_SCRATCH18_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH19                                                                             0x0131
#define regUVD_GP_SCRATCH19_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH20                                                                             0x0132
#define regUVD_GP_SCRATCH20_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH21                                                                             0x0133
#define regUVD_GP_SCRATCH21_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH22                                                                             0x0134
#define regUVD_GP_SCRATCH22_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH23                                                                             0x0135
#define regUVD_GP_SCRATCH23_BASE_IDX                                                                    1
#define regUVD_AUDIO_RB_BASE_LO                                                                         0x0136
#define regUVD_AUDIO_RB_BASE_LO_BASE_IDX                                                                1
#define regUVD_AUDIO_RB_BASE_HI                                                                         0x0137
#define regUVD_AUDIO_RB_BASE_HI_BASE_IDX                                                                1
#define regUVD_AUDIO_RB_SIZE                                                                            0x0138
#define regUVD_AUDIO_RB_SIZE_BASE_IDX                                                                   1
#define regUVD_VCPU_INT_STATUS2                                                                         0x013b
#define regUVD_VCPU_INT_STATUS2_BASE_IDX                                                                1
#define regUVD_VCPU_INT_ACK2                                                                            0x013c
#define regUVD_VCPU_INT_ACK2_BASE_IDX                                                                   1
#define regUVD_VCPU_INT_EN2                                                                             0x013d
#define regUVD_VCPU_INT_EN2_BASE_IDX                                                                    1
#define regUVD_SUVD_CGC_STATUS2                                                                         0x013e
#define regUVD_SUVD_CGC_STATUS2_BASE_IDX                                                                1
#define regUVD_SUVD_INT_STATUS2                                                                         0x0140
#define regUVD_SUVD_INT_STATUS2_BASE_IDX                                                                1
#define regUVD_SUVD_INT_EN2                                                                             0x0141
#define regUVD_SUVD_INT_EN2_BASE_IDX                                                                    1
#define regUVD_SUVD_INT_ACK2                                                                            0x0142
#define regUVD_SUVD_INT_ACK2_BASE_IDX                                                                   1
#define regUVD_STATUS                                                                                   0x0143
#define regUVD_STATUS_BASE_IDX                                                                          1
#define regUVD_ENC_PIPE_BUSY                                                                            0x0144
#define regUVD_ENC_PIPE_BUSY_BASE_IDX                                                                   1
#define regUVD_FW_POWER_STATUS                                                                          0x0145
#define regUVD_FW_POWER_STATUS_BASE_IDX                                                                 1
#define regUVD_CNTL                                                                                     0x0146
#define regUVD_CNTL_BASE_IDX                                                                            1
#define regUVD_SOFT_RESET                                                                               0x0147
#define regUVD_SOFT_RESET_BASE_IDX                                                                      1
#define regUVD_SOFT_RESET2                                                                              0x0148
#define regUVD_SOFT_RESET2_BASE_IDX                                                                     1
#define regUVD_MMSCH_SOFT_RESET                                                                         0x0149
#define regUVD_MMSCH_SOFT_RESET_BASE_IDX                                                                1
#define regUVD_WIG_CTRL                                                                                 0x014a
#define regUVD_WIG_CTRL_BASE_IDX                                                                        1
#define regUVD_CGC_STATUS                                                                               0x014c
#define regUVD_CGC_STATUS_BASE_IDX                                                                      1
#define regUVD_CGC_UDEC_STATUS                                                                          0x014e
#define regUVD_CGC_UDEC_STATUS_BASE_IDX                                                                 1
#define regUVD_SUVD_CGC_STATUS                                                                          0x0150
#define regUVD_SUVD_CGC_STATUS_BASE_IDX                                                                 1
#define regUVD_GPCOM_VCPU_CMD                                                                           0x0152
#define regUVD_GPCOM_VCPU_CMD_BASE_IDX                                                                  1


// addressBlock: aid_uvd0_ecpudec
// base address: 0x1fe00
#define regUVD_VCPU_CACHE_OFFSET0                                                                       0x0180
#define regUVD_VCPU_CACHE_OFFSET0_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE0                                                                         0x0181
#define regUVD_VCPU_CACHE_SIZE0_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET1                                                                       0x0182
#define regUVD_VCPU_CACHE_OFFSET1_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE1                                                                         0x0183
#define regUVD_VCPU_CACHE_SIZE1_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET2                                                                       0x0184
#define regUVD_VCPU_CACHE_OFFSET2_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE2                                                                         0x0185
#define regUVD_VCPU_CACHE_SIZE2_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET3                                                                       0x0186
#define regUVD_VCPU_CACHE_OFFSET3_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE3                                                                         0x0187
#define regUVD_VCPU_CACHE_SIZE3_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET4                                                                       0x0188
#define regUVD_VCPU_CACHE_OFFSET4_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE4                                                                         0x0189
#define regUVD_VCPU_CACHE_SIZE4_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET5                                                                       0x018a
#define regUVD_VCPU_CACHE_OFFSET5_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE5                                                                         0x018b
#define regUVD_VCPU_CACHE_SIZE5_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET6                                                                       0x018c
#define regUVD_VCPU_CACHE_OFFSET6_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE6                                                                         0x018d
#define regUVD_VCPU_CACHE_SIZE6_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET7                                                                       0x018e
#define regUVD_VCPU_CACHE_OFFSET7_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE7                                                                         0x018f
#define regUVD_VCPU_CACHE_SIZE7_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET8                                                                       0x0190
#define regUVD_VCPU_CACHE_OFFSET8_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE8                                                                         0x0191
#define regUVD_VCPU_CACHE_SIZE8_BASE_IDX                                                                1
#define regUVD_VCPU_NONCACHE_OFFSET0                                                                    0x0192
#define regUVD_VCPU_NONCACHE_OFFSET0_BASE_IDX                                                           1
#define regUVD_VCPU_NONCACHE_SIZE0                                                                      0x0193
#define regUVD_VCPU_NONCACHE_SIZE0_BASE_IDX                                                             1
#define regUVD_VCPU_NONCACHE_OFFSET1                                                                    0x0194
#define regUVD_VCPU_NONCACHE_OFFSET1_BASE_IDX                                                           1
#define regUVD_VCPU_NONCACHE_SIZE1                                                                      0x0195
#define regUVD_VCPU_NONCACHE_SIZE1_BASE_IDX                                                             1
#define regUVD_VCPU_CNTL                                                                                0x0196
#define regUVD_VCPU_CNTL_BASE_IDX                                                                       1
#define regUVD_VCPU_PRID                                                                                0x0197
#define regUVD_VCPU_PRID_BASE_IDX                                                                       1
#define regUVD_VCPU_TRCE                                                                                0x0198
#define regUVD_VCPU_TRCE_BASE_IDX                                                                       1
#define regUVD_VCPU_TRCE_RD                                                                             0x0199
#define regUVD_VCPU_TRCE_RD_BASE_IDX                                                                    1
#define regUVD_VCPU_IND_INDEX                                                                           0x019b
#define regUVD_VCPU_IND_INDEX_BASE_IDX                                                                  1
#define regUVD_VCPU_IND_DATA                                                                            0x019c
#define regUVD_VCPU_IND_DATA_BASE_IDX                                                                   1


// addressBlock: aid_uvd0_uvd_mpcdec
// base address: 0x1ff30
#define regUVD_MP_SWAP_CNTL                                                                             0x01cc
#define regUVD_MP_SWAP_CNTL_BASE_IDX                                                                    1
#define regUVD_MP_SWAP_CNTL2                                                                            0x01cd
#define regUVD_MP_SWAP_CNTL2_BASE_IDX                                                                   1
#define regUVD_MPC_LUMA_SRCH                                                                            0x01ce
#define regUVD_MPC_LUMA_SRCH_BASE_IDX                                                                   1
#define regUVD_MPC_LUMA_HIT                                                                             0x01cf
#define regUVD_MPC_LUMA_HIT_BASE_IDX                                                                    1
#define regUVD_MPC_LUMA_HITPEND                                                                         0x01d0
#define regUVD_MPC_LUMA_HITPEND_BASE_IDX                                                                1
#define regUVD_MPC_CHROMA_SRCH                                                                          0x01d1
#define regUVD_MPC_CHROMA_SRCH_BASE_IDX                                                                 1
#define regUVD_MPC_CHROMA_HIT                                                                           0x01d2
#define regUVD_MPC_CHROMA_HIT_BASE_IDX                                                                  1
#define regUVD_MPC_CHROMA_HITPEND                                                                       0x01d3
#define regUVD_MPC_CHROMA_HITPEND_BASE_IDX                                                              1
#define regUVD_MPC_CNTL                                                                                 0x01d4
#define regUVD_MPC_CNTL_BASE_IDX                                                                        1
#define regUVD_MPC_PITCH                                                                                0x01d5
#define regUVD_MPC_PITCH_BASE_IDX                                                                       1
#define regUVD_MPC_SET_MUXA0                                                                            0x01d6
#define regUVD_MPC_SET_MUXA0_BASE_IDX                                                                   1
#define regUVD_MPC_SET_MUXA1                                                                            0x01d7
#define regUVD_MPC_SET_MUXA1_BASE_IDX                                                                   1
#define regUVD_MPC_SET_MUXB0                                                                            0x01d8
#define regUVD_MPC_SET_MUXB0_BASE_IDX                                                                   1
#define regUVD_MPC_SET_MUXB1                                                                            0x01d9
#define regUVD_MPC_SET_MUXB1_BASE_IDX                                                                   1
#define regUVD_MPC_SET_MUX                                                                              0x01da
#define regUVD_MPC_SET_MUX_BASE_IDX                                                                     1
#define regUVD_MPC_SET_ALU                                                                              0x01db
#define regUVD_MPC_SET_ALU_BASE_IDX                                                                     1
#define regUVD_MPC_PERF0                                                                                0x01dc
#define regUVD_MPC_PERF0_BASE_IDX                                                                       1
#define regUVD_MPC_PERF1                                                                                0x01dd
#define regUVD_MPC_PERF1_BASE_IDX                                                                       1
#define regUVD_MPC_IND_INDEX                                                                            0x01de
#define regUVD_MPC_IND_INDEX_BASE_IDX                                                                   1
#define regUVD_MPC_IND_DATA                                                                             0x01df
#define regUVD_MPC_IND_DATA_BASE_IDX                                                                    1


// addressBlock: aid_uvd0_uvd_rbcdec
// base address: 0x1ff90
#define regUVD_RBC_IB_SIZE                                                                              0x01e4
#define regUVD_RBC_IB_SIZE_BASE_IDX                                                                     1
#define regUVD_RBC_IB_SIZE_UPDATE                                                                       0x01e5
#define regUVD_RBC_IB_SIZE_UPDATE_BASE_IDX                                                              1
#define regUVD_RBC_RB_CNTL                                                                              0x01e6
#define regUVD_RBC_RB_CNTL_BASE_IDX                                                                     1
#define regUVD_RBC_RB_RPTR_ADDR                                                                         0x01e7
#define regUVD_RBC_RB_RPTR_ADDR_BASE_IDX                                                                1
#define regUVD_RBC_VCPU_ACCESS                                                                          0x01ea
#define regUVD_RBC_VCPU_ACCESS_BASE_IDX                                                                 1
#define regUVD_FW_SEMAPHORE_CNTL                                                                        0x01eb
#define regUVD_FW_SEMAPHORE_CNTL_BASE_IDX                                                               1
#define regUVD_RBC_READ_REQ_URGENT_CNTL                                                                 0x01ed
#define regUVD_RBC_READ_REQ_URGENT_CNTL_BASE_IDX                                                        1
#define regUVD_RBC_RB_WPTR_CNTL                                                                         0x01ee
#define regUVD_RBC_RB_WPTR_CNTL_BASE_IDX                                                                1
#define regUVD_RBC_WPTR_STATUS                                                                          0x01ef
#define regUVD_RBC_WPTR_STATUS_BASE_IDX                                                                 1
#define regUVD_RBC_WPTR_POLL_CNTL                                                                       0x01f0
#define regUVD_RBC_WPTR_POLL_CNTL_BASE_IDX                                                              1
#define regUVD_RBC_WPTR_POLL_ADDR                                                                       0x01f1
#define regUVD_RBC_WPTR_POLL_ADDR_BASE_IDX                                                              1
#define regUVD_SEMA_CMD                                                                                 0x01f2
#define regUVD_SEMA_CMD_BASE_IDX                                                                        1
#define regUVD_SEMA_ADDR_LOW                                                                            0x01f3
#define regUVD_SEMA_ADDR_LOW_BASE_IDX                                                                   1
#define regUVD_SEMA_ADDR_HIGH                                                                           0x01f4
#define regUVD_SEMA_ADDR_HIGH_BASE_IDX                                                                  1
#define regUVD_ENGINE_CNTL                                                                              0x01f5
#define regUVD_ENGINE_CNTL_BASE_IDX                                                                     1
#define regUVD_SEMA_TIMEOUT_STATUS                                                                      0x01f6
#define regUVD_SEMA_TIMEOUT_STATUS_BASE_IDX                                                             1
#define regUVD_SEMA_CNTL                                                                                0x01f7
#define regUVD_SEMA_CNTL_BASE_IDX                                                                       1
#define regUVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL                                                      0x01f8
#define regUVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL_BASE_IDX                                             1
#define regUVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL                                                             0x01f9
#define regUVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL_BASE_IDX                                                    1
#define regUVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL                                                        0x01fa
#define regUVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL_BASE_IDX                                               1
#define regUVD_JOB_START                                                                                0x01fb
#define regUVD_JOB_START_BASE_IDX                                                                       1
#define regUVD_RBC_BUF_STATUS                                                                           0x01fc
#define regUVD_RBC_BUF_STATUS_BASE_IDX                                                                  1
#define regUVD_RBC_SWAP_CNTL                                                                            0x01fd
#define regUVD_RBC_SWAP_CNTL_BASE_IDX                                                                   1


// addressBlock: aid_uvd0_lmi_adpdec
// base address: 0x20090
#define regUVD_LMI_RE_64BIT_BAR_LOW                                                                     0x0224
#define regUVD_LMI_RE_64BIT_BAR_LOW_BASE_IDX                                                            1
#define regUVD_LMI_RE_64BIT_BAR_HIGH                                                                    0x0225
#define regUVD_LMI_RE_64BIT_BAR_HIGH_BASE_IDX                                                           1
#define regUVD_LMI_IT_64BIT_BAR_LOW                                                                     0x0226
#define regUVD_LMI_IT_64BIT_BAR_LOW_BASE_IDX                                                            1
#define regUVD_LMI_IT_64BIT_BAR_HIGH                                                                    0x0227
#define regUVD_LMI_IT_64BIT_BAR_HIGH_BASE_IDX                                                           1
#define regUVD_LMI_MP_64BIT_BAR_LOW                                                                     0x0228
#define regUVD_LMI_MP_64BIT_BAR_LOW_BASE_IDX                                                            1
#define regUVD_LMI_MP_64BIT_BAR_HIGH                                                                    0x0229
#define regUVD_LMI_MP_64BIT_BAR_HIGH_BASE_IDX                                                           1
#define regUVD_LMI_CM_64BIT_BAR_LOW                                                                     0x022a
#define regUVD_LMI_CM_64BIT_BAR_LOW_BASE_IDX                                                            1
#define regUVD_LMI_CM_64BIT_BAR_HIGH                                                                    0x022b
#define regUVD_LMI_CM_64BIT_BAR_HIGH_BASE_IDX                                                           1
#define regUVD_LMI_DB_64BIT_BAR_LOW                                                                     0x022c
#define regUVD_LMI_DB_64BIT_BAR_LOW_BASE_IDX                                                            1
#define regUVD_LMI_DB_64BIT_BAR_HIGH                                                                    0x022d
#define regUVD_LMI_DB_64BIT_BAR_HIGH_BASE_IDX                                                           1
#define regUVD_LMI_DBW_64BIT_BAR_LOW                                                                    0x022e
#define regUVD_LMI_DBW_64BIT_BAR_LOW_BASE_IDX                                                           1
#define regUVD_LMI_DBW_64BIT_BAR_HIGH                                                                   0x022f
#define regUVD_LMI_DBW_64BIT_BAR_HIGH_BASE_IDX                                                          1
#define regUVD_LMI_IDCT_64BIT_BAR_LOW                                                                   0x0230
#define regUVD_LMI_IDCT_64BIT_BAR_LOW_BASE_IDX                                                          1
#define regUVD_LMI_IDCT_64BIT_BAR_HIGH                                                                  0x0231
#define regUVD_LMI_IDCT_64BIT_BAR_HIGH_BASE_IDX                                                         1
#define regUVD_LMI_MPRD_S0_64BIT_BAR_LOW                                                                0x0232
#define regUVD_LMI_MPRD_S0_64BIT_BAR_LOW_BASE_IDX                                                       1
#define regUVD_LMI_MPRD_S0_64BIT_BAR_HIGH                                                               0x0233
#define regUVD_LMI_MPRD_S0_64BIT_BAR_HIGH_BASE_IDX                                                      1
#define regUVD_LMI_MPRD_S1_64BIT_BAR_LOW                                                                0x0234
#define regUVD_LMI_MPRD_S1_64BIT_BAR_LOW_BASE_IDX                                                       1
#define regUVD_LMI_MPRD_S1_64BIT_BAR_HIGH                                                               0x0235
#define regUVD_LMI_MPRD_S1_64BIT_BAR_HIGH_BASE_IDX                                                      1
#define regUVD_LMI_MPRD_DBW_64BIT_BAR_LOW                                                               0x0236
#define regUVD_LMI_MPRD_DBW_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MPRD_DBW_64BIT_BAR_HIGH                                                              0x0237
#define regUVD_LMI_MPRD_DBW_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MPC_64BIT_BAR_LOW                                                                    0x0238
#define regUVD_LMI_MPC_64BIT_BAR_LOW_BASE_IDX                                                           1
#define regUVD_LMI_MPC_64BIT_BAR_HIGH                                                                   0x0239
#define regUVD_LMI_MPC_64BIT_BAR_HIGH_BASE_IDX                                                          1
#define regUVD_LMI_RBC_RB_64BIT_BAR_LOW                                                                 0x023a
#define regUVD_LMI_RBC_RB_64BIT_BAR_LOW_BASE_IDX                                                        1
#define regUVD_LMI_RBC_RB_64BIT_BAR_HIGH                                                                0x023b
#define regUVD_LMI_RBC_RB_64BIT_BAR_HIGH_BASE_IDX                                                       1
#define regUVD_LMI_RBC_IB_64BIT_BAR_LOW                                                                 0x023c
#define regUVD_LMI_RBC_IB_64BIT_BAR_LOW_BASE_IDX                                                        1
#define regUVD_LMI_RBC_IB_64BIT_BAR_HIGH                                                                0x023d
#define regUVD_LMI_RBC_IB_64BIT_BAR_HIGH_BASE_IDX                                                       1
#define regUVD_LMI_LBSI_64BIT_BAR_LOW                                                                   0x023e
#define regUVD_LMI_LBSI_64BIT_BAR_LOW_BASE_IDX                                                          1
#define regUVD_LMI_LBSI_64BIT_BAR_HIGH                                                                  0x023f
#define regUVD_LMI_LBSI_64BIT_BAR_HIGH_BASE_IDX                                                         1
#define regUVD_LMI_VCPU_NC0_64BIT_BAR_LOW                                                               0x0240
#define regUVD_LMI_VCPU_NC0_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_VCPU_NC0_64BIT_BAR_HIGH                                                              0x0241
#define regUVD_LMI_VCPU_NC0_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_VCPU_NC1_64BIT_BAR_LOW                                                               0x0242
#define regUVD_LMI_VCPU_NC1_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_VCPU_NC1_64BIT_BAR_HIGH                                                              0x0243
#define regUVD_LMI_VCPU_NC1_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_VCPU_CACHE_64BIT_BAR_LOW                                                             0x0244
#define regUVD_LMI_VCPU_CACHE_64BIT_BAR_LOW_BASE_IDX                                                    1
#define regUVD_LMI_VCPU_CACHE_64BIT_BAR_HIGH                                                            0x0245
#define regUVD_LMI_VCPU_CACHE_64BIT_BAR_HIGH_BASE_IDX                                                   1
#define regUVD_LMI_CENC_64BIT_BAR_LOW                                                                   0x0246
#define regUVD_LMI_CENC_64BIT_BAR_LOW_BASE_IDX                                                          1
#define regUVD_LMI_CENC_64BIT_BAR_HIGH                                                                  0x0247
#define regUVD_LMI_CENC_64BIT_BAR_HIGH_BASE_IDX                                                         1
#define regUVD_LMI_SRE_64BIT_BAR_LOW                                                                    0x0248
#define regUVD_LMI_SRE_64BIT_BAR_LOW_BASE_IDX                                                           1
#define regUVD_LMI_SRE_64BIT_BAR_HIGH                                                                   0x0249
#define regUVD_LMI_SRE_64BIT_BAR_HIGH_BASE_IDX                                                          1
#define regUVD_LMI_MIF_GPGPU_64BIT_BAR_LOW                                                              0x024a
#define regUVD_LMI_MIF_GPGPU_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MIF_GPGPU_64BIT_BAR_HIGH                                                             0x024b
#define regUVD_LMI_MIF_GPGPU_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MIF_CURR_LUMA_64BIT_BAR_LOW                                                          0x024c
#define regUVD_LMI_MIF_CURR_LUMA_64BIT_BAR_LOW_BASE_IDX                                                 1
#define regUVD_LMI_MIF_CURR_LUMA_64BIT_BAR_HIGH                                                         0x024d
#define regUVD_LMI_MIF_CURR_LUMA_64BIT_BAR_HIGH_BASE_IDX                                                1
#define regUVD_LMI_MIF_CURR_CHROMA_64BIT_BAR_LOW                                                        0x024e
#define regUVD_LMI_MIF_CURR_CHROMA_64BIT_BAR_LOW_BASE_IDX                                               1
#define regUVD_LMI_MIF_CURR_CHROMA_64BIT_BAR_HIGH                                                       0x024f
#define regUVD_LMI_MIF_CURR_CHROMA_64BIT_BAR_HIGH_BASE_IDX                                              1
#define regUVD_LMI_MIF_REF_64BIT_BAR_LOW                                                                0x0250
#define regUVD_LMI_MIF_REF_64BIT_BAR_LOW_BASE_IDX                                                       1
#define regUVD_LMI_MIF_REF_64BIT_BAR_HIGH                                                               0x0251
#define regUVD_LMI_MIF_REF_64BIT_BAR_HIGH_BASE_IDX                                                      1
#define regUVD_LMI_MIF_DBW_64BIT_BAR_LOW                                                                0x0252
#define regUVD_LMI_MIF_DBW_64BIT_BAR_LOW_BASE_IDX                                                       1
#define regUVD_LMI_MIF_DBW_64BIT_BAR_HIGH                                                               0x0253
#define regUVD_LMI_MIF_DBW_64BIT_BAR_HIGH_BASE_IDX                                                      1
#define regUVD_LMI_MIF_CM_COLOC_64BIT_BAR_LOW                                                           0x0254
#define regUVD_LMI_MIF_CM_COLOC_64BIT_BAR_LOW_BASE_IDX                                                  1
#define regUVD_LMI_MIF_CM_COLOC_64BIT_BAR_HIGH                                                          0x0255
#define regUVD_LMI_MIF_CM_COLOC_64BIT_BAR_HIGH_BASE_IDX                                                 1
#define regUVD_LMI_MIF_BSP0_64BIT_BAR_LOW                                                               0x0256
#define regUVD_LMI_MIF_BSP0_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSP0_64BIT_BAR_HIGH                                                              0x0257
#define regUVD_LMI_MIF_BSP0_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSP1_64BIT_BAR_LOW                                                               0x0258
#define regUVD_LMI_MIF_BSP1_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSP1_64BIT_BAR_HIGH                                                              0x0259
#define regUVD_LMI_MIF_BSP1_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSP2_64BIT_BAR_LOW                                                               0x025a
#define regUVD_LMI_MIF_BSP2_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSP2_64BIT_BAR_HIGH                                                              0x025b
#define regUVD_LMI_MIF_BSP2_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSP3_64BIT_BAR_LOW                                                               0x025c
#define regUVD_LMI_MIF_BSP3_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSP3_64BIT_BAR_HIGH                                                              0x025d
#define regUVD_LMI_MIF_BSP3_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSD0_64BIT_BAR_LOW                                                               0x025e
#define regUVD_LMI_MIF_BSD0_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSD0_64BIT_BAR_HIGH                                                              0x025f
#define regUVD_LMI_MIF_BSD0_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSD1_64BIT_BAR_LOW                                                               0x0260
#define regUVD_LMI_MIF_BSD1_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSD1_64BIT_BAR_HIGH                                                              0x0261
#define regUVD_LMI_MIF_BSD1_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSD2_64BIT_BAR_LOW                                                               0x0262
#define regUVD_LMI_MIF_BSD2_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSD2_64BIT_BAR_HIGH                                                              0x0263
#define regUVD_LMI_MIF_BSD2_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSD3_64BIT_BAR_LOW                                                               0x0264
#define regUVD_LMI_MIF_BSD3_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSD3_64BIT_BAR_HIGH                                                              0x0265
#define regUVD_LMI_MIF_BSD3_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSD4_64BIT_BAR_LOW                                                               0x0266
#define regUVD_LMI_MIF_BSD4_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSD4_64BIT_BAR_HIGH                                                              0x0267
#define regUVD_LMI_MIF_BSD4_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_VCPU_CACHE1_64BIT_BAR_LOW                                                            0x0270
#define regUVD_LMI_VCPU_CACHE1_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE1_64BIT_BAR_HIGH                                                           0x0271
#define regUVD_LMI_VCPU_CACHE1_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE8_64BIT_BAR_LOW                                                            0x0272
#define regUVD_LMI_VCPU_CACHE8_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE8_64BIT_BAR_HIGH                                                           0x0273
#define regUVD_LMI_VCPU_CACHE8_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE2_64BIT_BAR_LOW                                                            0x0274
#define regUVD_LMI_VCPU_CACHE2_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE2_64BIT_BAR_HIGH                                                           0x0275
#define regUVD_LMI_VCPU_CACHE2_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE3_64BIT_BAR_LOW                                                            0x0276
#define regUVD_LMI_VCPU_CACHE3_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE3_64BIT_BAR_HIGH                                                           0x0277
#define regUVD_LMI_VCPU_CACHE3_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE4_64BIT_BAR_LOW                                                            0x0278
#define regUVD_LMI_VCPU_CACHE4_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE4_64BIT_BAR_HIGH                                                           0x0279
#define regUVD_LMI_VCPU_CACHE4_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE5_64BIT_BAR_LOW                                                            0x027a
#define regUVD_LMI_VCPU_CACHE5_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE5_64BIT_BAR_HIGH                                                           0x027b
#define regUVD_LMI_VCPU_CACHE5_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE6_64BIT_BAR_LOW                                                            0x027c
#define regUVD_LMI_VCPU_CACHE6_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE6_64BIT_BAR_HIGH                                                           0x027d
#define regUVD_LMI_VCPU_CACHE6_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE7_64BIT_BAR_LOW                                                            0x027e
#define regUVD_LMI_VCPU_CACHE7_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE7_64BIT_BAR_HIGH                                                           0x027f
#define regUVD_LMI_VCPU_CACHE7_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_MIF_SCLR_64BIT_BAR_LOW                                                               0x0280
#define regUVD_LMI_MIF_SCLR_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_SCLR_64BIT_BAR_HIGH                                                              0x0281
#define regUVD_LMI_MIF_SCLR_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_SCLR2_64BIT_BAR_LOW                                                              0x0282
#define regUVD_LMI_MIF_SCLR2_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MIF_SCLR2_64BIT_BAR_HIGH                                                             0x0283
#define regUVD_LMI_MIF_SCLR2_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_SPH_64BIT_BAR_HIGH                                                                   0x0284
#define regUVD_LMI_SPH_64BIT_BAR_HIGH_BASE_IDX                                                          1
#define regUVD_LMI_MIF_IMAGEPASTE_LUMA_64BIT_BAR_LOW                                                    0x0298
#define regUVD_LMI_MIF_IMAGEPASTE_LUMA_64BIT_BAR_LOW_BASE_IDX                                           1
#define regUVD_LMI_MIF_IMAGEPASTE_LUMA_64BIT_BAR_HIGH                                                   0x0299
#define regUVD_LMI_MIF_IMAGEPASTE_LUMA_64BIT_BAR_HIGH_BASE_IDX                                          1
#define regUVD_LMI_MIF_IMAGEPASTE_CHROMA_64BIT_BAR_LOW                                                  0x029a
#define regUVD_LMI_MIF_IMAGEPASTE_CHROMA_64BIT_BAR_LOW_BASE_IDX                                         1
#define regUVD_LMI_MIF_IMAGEPASTE_CHROMA_64BIT_BAR_HIGH                                                 0x029b
#define regUVD_LMI_MIF_IMAGEPASTE_CHROMA_64BIT_BAR_HIGH_BASE_IDX                                        1
#define regUVD_LMI_MIF_PRIVACY_LUMA_64BIT_BAR_LOW                                                       0x029c
#define regUVD_LMI_MIF_PRIVACY_LUMA_64BIT_BAR_LOW_BASE_IDX                                              1
#define regUVD_LMI_MIF_PRIVACY_LUMA_64BIT_BAR_HIGH                                                      0x029d
#define regUVD_LMI_MIF_PRIVACY_LUMA_64BIT_BAR_HIGH_BASE_IDX                                             1
#define regUVD_LMI_MIF_PRIVACY_CHROMA_64BIT_BAR_LOW                                                     0x029e
#define regUVD_LMI_MIF_PRIVACY_CHROMA_64BIT_BAR_LOW_BASE_IDX                                            1
#define regUVD_LMI_MIF_PRIVACY_CHROMA_64BIT_BAR_HIGH                                                    0x029f
#define regUVD_LMI_MIF_PRIVACY_CHROMA_64BIT_BAR_HIGH_BASE_IDX                                           1
#define regUVD_ADP_ATOMIC_CONFIG                                                                        0x02a1
#define regUVD_ADP_ATOMIC_CONFIG_BASE_IDX                                                               1
#define regUVD_LMI_ARB_CTRL2                                                                            0x02a2
#define regUVD_LMI_ARB_CTRL2_BASE_IDX                                                                   1
#define regUVD_LMI_VCPU_CACHE_VMIDS_MULTI                                                               0x02a7
#define regUVD_LMI_VCPU_CACHE_VMIDS_MULTI_BASE_IDX                                                      1
#define regUVD_LMI_VCPU_NC_VMIDS_MULTI                                                                  0x02a8
#define regUVD_LMI_VCPU_NC_VMIDS_MULTI_BASE_IDX                                                         1
#define regUVD_LMI_LAT_CTRL                                                                             0x02a9
#define regUVD_LMI_LAT_CTRL_BASE_IDX                                                                    1
#define regUVD_LMI_LAT_CNTR                                                                             0x02aa
#define regUVD_LMI_LAT_CNTR_BASE_IDX                                                                    1
#define regUVD_LMI_AVG_LAT_CNTR                                                                         0x02ab
#define regUVD_LMI_AVG_LAT_CNTR_BASE_IDX                                                                1
#define regUVD_LMI_SPH                                                                                  0x02ac
#define regUVD_LMI_SPH_BASE_IDX                                                                         1
#define regUVD_LMI_VCPU_CACHE_VMID                                                                      0x02ad
#define regUVD_LMI_VCPU_CACHE_VMID_BASE_IDX                                                             1
#define regUVD_LMI_CTRL2                                                                                0x02ae
#define regUVD_LMI_CTRL2_BASE_IDX                                                                       1
#define regUVD_LMI_URGENT_CTRL                                                                          0x02af
#define regUVD_LMI_URGENT_CTRL_BASE_IDX                                                                 1
#define regUVD_LMI_CTRL                                                                                 0x02b0
#define regUVD_LMI_CTRL_BASE_IDX                                                                        1
#define regUVD_LMI_STATUS                                                                               0x02b1
#define regUVD_LMI_STATUS_BASE_IDX                                                                      1
#define regUVD_LMI_PERFMON_CTRL                                                                         0x02b4
#define regUVD_LMI_PERFMON_CTRL_BASE_IDX                                                                1
#define regUVD_LMI_PERFMON_COUNT_LO                                                                     0x02b5
#define regUVD_LMI_PERFMON_COUNT_LO_BASE_IDX                                                            1
#define regUVD_LMI_PERFMON_COUNT_HI                                                                     0x02b6
#define regUVD_LMI_PERFMON_COUNT_HI_BASE_IDX                                                            1
#define regUVD_LMI_ADP_SWAP_CNTL                                                                        0x02b7
#define regUVD_LMI_ADP_SWAP_CNTL_BASE_IDX                                                               1
#define regUVD_LMI_RBC_RB_VMID                                                                          0x02b8
#define regUVD_LMI_RBC_RB_VMID_BASE_IDX                                                                 1
#define regUVD_LMI_RBC_IB_VMID                                                                          0x02b9
#define regUVD_LMI_RBC_IB_VMID_BASE_IDX                                                                 1
#define regUVD_LMI_MC_CREDITS                                                                           0x02ba
#define regUVD_LMI_MC_CREDITS_BASE_IDX                                                                  1
#define regUVD_LMI_ADP_IND_INDEX                                                                        0x02be
#define regUVD_LMI_ADP_IND_INDEX_BASE_IDX                                                               1
#define regUVD_LMI_ADP_IND_DATA                                                                         0x02bf
#define regUVD_LMI_ADP_IND_DATA_BASE_IDX                                                                1
#define regUVD_LMI_ADP_PF_EN                                                                            0x02c0
#define regUVD_LMI_ADP_PF_EN_BASE_IDX                                                                   1
#define regUVD_LMI_PREF_CTRL                                                                            0x02c2
#define regUVD_LMI_PREF_CTRL_BASE_IDX                                                                   1
#define regUVD_LMI_MIF_REF_LUMA_64BIT_BAR_LOW                                                           0x02dd
#define regUVD_LMI_MIF_REF_LUMA_64BIT_BAR_LOW_BASE_IDX                                                  1
#define regUVD_LMI_MIF_REF_LUMA_64BIT_BAR_HIGH                                                          0x02de
#define regUVD_LMI_MIF_REF_LUMA_64BIT_BAR_HIGH_BASE_IDX                                                 1
#define regVCN_RAS_CNTL                                                                                 0x02df
#define regVCN_RAS_CNTL_BASE_IDX                                                                        1


// addressBlock: aid_uvd0_uvd_jpeg0_jpegnpdec
// base address: 0x20f00
#define regUVD_JPEG_CNTL                                                                                0x05c0
#define regUVD_JPEG_CNTL_BASE_IDX                                                                       1
#define regUVD_JPEG_RB_BASE                                                                             0x05c1
#define regUVD_JPEG_RB_BASE_BASE_IDX                                                                    1
#define regUVD_JPEG_RB_WPTR                                                                             0x05c2
#define regUVD_JPEG_RB_WPTR_BASE_IDX                                                                    1
#define regUVD_JPEG_RB_RPTR                                                                             0x05c3
#define regUVD_JPEG_RB_RPTR_BASE_IDX                                                                    1
#define regUVD_JPEG_RB_SIZE                                                                             0x05c4
#define regUVD_JPEG_RB_SIZE_BASE_IDX                                                                    1
#define regUVD_JPEG_DEC_CNT                                                                             0x05c5
#define regUVD_JPEG_DEC_CNT_BASE_IDX                                                                    1
#define regUVD_JPEG_SPS_INFO                                                                            0x05c6
#define regUVD_JPEG_SPS_INFO_BASE_IDX                                                                   1
#define regUVD_JPEG_SPS1_INFO                                                                           0x05c7
#define regUVD_JPEG_SPS1_INFO_BASE_IDX                                                                  1
#define regUVD_JPEG_RE_TIMER                                                                            0x05c8
#define regUVD_JPEG_RE_TIMER_BASE_IDX                                                                   1
#define regUVD_JPEG_DEC_SCRATCH0                                                                        0x05c9
#define regUVD_JPEG_DEC_SCRATCH0_BASE_IDX                                                               1
#define regUVD_JPEG_INT_EN                                                                              0x05ca
#define regUVD_JPEG_INT_EN_BASE_IDX                                                                     1
#define regUVD_JPEG_INT_STAT                                                                            0x05cb
#define regUVD_JPEG_INT_STAT_BASE_IDX                                                                   1
#define regUVD_JPEG_TIER_CNTL0                                                                          0x05cc
#define regUVD_JPEG_TIER_CNTL0_BASE_IDX                                                                 1
#define regUVD_JPEG_TIER_CNTL1                                                                          0x05cd
#define regUVD_JPEG_TIER_CNTL1_BASE_IDX                                                                 1
#define regUVD_JPEG_TIER_CNTL2                                                                          0x05ce
#define regUVD_JPEG_TIER_CNTL2_BASE_IDX                                                                 1
#define regUVD_JPEG_TIER_STATUS                                                                         0x05cf
#define regUVD_JPEG_TIER_STATUS_BASE_IDX                                                                1


// addressBlock: aid_uvd0_uvd_jpeg_sclk0_jpegnpsclkdec
// base address: 0x21000
#define regUVD_JPEG_OUTBUF_CNTL                                                                         0x0600
#define regUVD_JPEG_OUTBUF_CNTL_BASE_IDX                                                                1
#define regUVD_JPEG_OUTBUF_WPTR                                                                         0x0601
#define regUVD_JPEG_OUTBUF_WPTR_BASE_IDX                                                                1
#define regUVD_JPEG_OUTBUF_RPTR                                                                         0x0602
#define regUVD_JPEG_OUTBUF_RPTR_BASE_IDX                                                                1
#define regUVD_JPEG_PITCH                                                                               0x0603
#define regUVD_JPEG_PITCH_BASE_IDX                                                                      1
#define regUVD_JPEG_UV_PITCH                                                                            0x0604
#define regUVD_JPEG_UV_PITCH_BASE_IDX                                                                   1
#define regJPEG_DEC_Y_GFX8_TILING_SURFACE                                                               0x0605
#define regJPEG_DEC_Y_GFX8_TILING_SURFACE_BASE_IDX                                                      1
#define regJPEG_DEC_UV_GFX8_TILING_SURFACE                                                              0x0606
#define regJPEG_DEC_UV_GFX8_TILING_SURFACE_BASE_IDX                                                     1
#define regJPEG_DEC_GFX8_ADDR_CONFIG                                                                    0x0607
#define regJPEG_DEC_GFX8_ADDR_CONFIG_BASE_IDX                                                           1
#define regJPEG_DEC_Y_GFX10_TILING_SURFACE                                                              0x0608
#define regJPEG_DEC_Y_GFX10_TILING_SURFACE_BASE_IDX                                                     1
#define regJPEG_DEC_UV_GFX10_TILING_SURFACE                                                             0x0609
#define regJPEG_DEC_UV_GFX10_TILING_SURFACE_BASE_IDX                                                    1
#define regJPEG_DEC_GFX10_ADDR_CONFIG                                                                   0x060a
#define regJPEG_DEC_GFX10_ADDR_CONFIG_BASE_IDX                                                          1
#define regJPEG_DEC_ADDR_MODE                                                                           0x060b
#define regJPEG_DEC_ADDR_MODE_BASE_IDX                                                                  1
#define regUVD_JPEG_OUTPUT_XY                                                                           0x060c
#define regUVD_JPEG_OUTPUT_XY_BASE_IDX                                                                  1
#define regUVD_JPEG_GPCOM_CMD                                                                           0x060d
#define regUVD_JPEG_GPCOM_CMD_BASE_IDX                                                                  1
#define regUVD_JPEG_GPCOM_DATA0                                                                         0x060e
#define regUVD_JPEG_GPCOM_DATA0_BASE_IDX                                                                1
#define regUVD_JPEG_GPCOM_DATA1                                                                         0x060f
#define regUVD_JPEG_GPCOM_DATA1_BASE_IDX                                                                1
#define regUVD_JPEG_SCRATCH1                                                                            0x0610
#define regUVD_JPEG_SCRATCH1_BASE_IDX                                                                   1
#define regUVD_JPEG_DEC_SOFT_RST                                                                        0x0611
#define regUVD_JPEG_DEC_SOFT_RST_BASE_IDX                                                               1


// addressBlock: aid_uvd0_uvd_jrbc0_uvd_jrbc_dec
// base address: 0x21100
#define regUVD_JRBC0_UVD_JRBC_RB_WPTR                                                                   0x0640
#define regUVD_JRBC0_UVD_JRBC_RB_WPTR_BASE_IDX                                                          1
#define regUVD_JRBC0_UVD_JRBC_RB_CNTL                                                                   0x0641
#define regUVD_JRBC0_UVD_JRBC_RB_CNTL_BASE_IDX                                                          1
#define regUVD_JRBC0_UVD_JRBC_IB_SIZE                                                                   0x0642
#define regUVD_JRBC0_UVD_JRBC_IB_SIZE_BASE_IDX                                                          1
#define regUVD_JRBC0_UVD_JRBC_URGENT_CNTL                                                               0x0643
#define regUVD_JRBC0_UVD_JRBC_URGENT_CNTL_BASE_IDX                                                      1
#define regUVD_JRBC0_UVD_JRBC_RB_REF_DATA                                                               0x0644
#define regUVD_JRBC0_UVD_JRBC_RB_REF_DATA_BASE_IDX                                                      1
#define regUVD_JRBC0_UVD_JRBC_RB_COND_RD_TIMER                                                          0x0645
#define regUVD_JRBC0_UVD_JRBC_RB_COND_RD_TIMER_BASE_IDX                                                 1
#define regUVD_JRBC0_UVD_JRBC_SOFT_RESET                                                                0x0648
#define regUVD_JRBC0_UVD_JRBC_SOFT_RESET_BASE_IDX                                                       1
#define regUVD_JRBC0_UVD_JRBC_STATUS                                                                    0x0649
#define regUVD_JRBC0_UVD_JRBC_STATUS_BASE_IDX                                                           1
#define regUVD_JRBC0_UVD_JRBC_RB_RPTR                                                                   0x064a
#define regUVD_JRBC0_UVD_JRBC_RB_RPTR_BASE_IDX                                                          1
#define regUVD_JRBC0_UVD_JRBC_RB_BUF_STATUS                                                             0x064b
#define regUVD_JRBC0_UVD_JRBC_RB_BUF_STATUS_BASE_IDX                                                    1
#define regUVD_JRBC0_UVD_JRBC_IB_BUF_STATUS                                                             0x064c
#define regUVD_JRBC0_UVD_JRBC_IB_BUF_STATUS_BASE_IDX                                                    1
#define regUVD_JRBC0_UVD_JRBC_IB_SIZE_UPDATE                                                            0x064d
#define regUVD_JRBC0_UVD_JRBC_IB_SIZE_UPDATE_BASE_IDX                                                   1
#define regUVD_JRBC0_UVD_JRBC_IB_COND_RD_TIMER                                                          0x064e
#define regUVD_JRBC0_UVD_JRBC_IB_COND_RD_TIMER_BASE_IDX                                                 1
#define regUVD_JRBC0_UVD_JRBC_IB_REF_DATA                                                               0x064f
#define regUVD_JRBC0_UVD_JRBC_IB_REF_DATA_BASE_IDX                                                      1
#define regUVD_JRBC0_UVD_JPEG_PREEMPT_CMD                                                               0x0650
#define regUVD_JRBC0_UVD_JPEG_PREEMPT_CMD_BASE_IDX                                                      1
#define regUVD_JRBC0_UVD_JPEG_PREEMPT_FENCE_DATA0                                                       0x0651
#define regUVD_JRBC0_UVD_JPEG_PREEMPT_FENCE_DATA0_BASE_IDX                                              1
#define regUVD_JRBC0_UVD_JPEG_PREEMPT_FENCE_DATA1                                                       0x0652
#define regUVD_JRBC0_UVD_JPEG_PREEMPT_FENCE_DATA1_BASE_IDX                                              1
#define regUVD_JRBC0_UVD_JRBC_RB_SIZE                                                                   0x0653
#define regUVD_JRBC0_UVD_JRBC_RB_SIZE_BASE_IDX                                                          1
#define regUVD_JRBC0_UVD_JRBC_SCRATCH0                                                                  0x0654
#define regUVD_JRBC0_UVD_JRBC_SCRATCH0_BASE_IDX                                                         1


// addressBlock: aid_uvd0_uvd_jmi0_uvd_jmi_dec
// base address: 0x21180
#define regUVD_JMI0_UVD_JPEG_DEC_PF_CTRL                                                                0x0660
#define regUVD_JMI0_UVD_JPEG_DEC_PF_CTRL_BASE_IDX                                                       1
#define regUVD_JMI0_UVD_LMI_JRBC_CTRL                                                                   0x0661
#define regUVD_JMI0_UVD_LMI_JRBC_CTRL_BASE_IDX                                                          1
#define regUVD_JMI0_UVD_LMI_JPEG_CTRL                                                                   0x0662
#define regUVD_JMI0_UVD_LMI_JPEG_CTRL_BASE_IDX                                                          1
#define regUVD_JMI0_JPEG_LMI_DROP                                                                       0x0663
#define regUVD_JMI0_JPEG_LMI_DROP_BASE_IDX                                                              1
#define regUVD_JMI0_UVD_LMI_JRBC_IB_VMID                                                                0x0664
#define regUVD_JMI0_UVD_LMI_JRBC_IB_VMID_BASE_IDX                                                       1
#define regUVD_JMI0_UVD_LMI_JRBC_RB_VMID                                                                0x0665
#define regUVD_JMI0_UVD_LMI_JRBC_RB_VMID_BASE_IDX                                                       1
#define regUVD_JMI0_UVD_LMI_JPEG_VMID                                                                   0x0666
#define regUVD_JMI0_UVD_LMI_JPEG_VMID_BASE_IDX                                                          1
#define regUVD_JMI0_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                            0x0667
#define regUVD_JMI0_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                   1
#define regUVD_JMI0_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                           0x0668
#define regUVD_JMI0_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                  1
#define regUVD_JMI0_UVD_LMI_JRBC_RB_64BIT_BAR_LOW                                                       0x0669
#define regUVD_JMI0_UVD_LMI_JRBC_RB_64BIT_BAR_LOW_BASE_IDX                                              1
#define regUVD_JMI0_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH                                                      0x066a
#define regUVD_JMI0_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                             1
#define regUVD_JMI0_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW                                                0x066b
#define regUVD_JMI0_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       1
#define regUVD_JMI0_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH                                               0x066c
#define regUVD_JMI0_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      1
#define regUVD_JMI0_UVD_LMI_JPEG_PREEMPT_VMID                                                           0x066d
#define regUVD_JMI0_UVD_LMI_JPEG_PREEMPT_VMID_BASE_IDX                                                  1
#define regUVD_JMI0_UVD_JMI_DEC_SWAP_CNTL                                                               0x066e
#define regUVD_JMI0_UVD_JMI_DEC_SWAP_CNTL_BASE_IDX                                                      1
#define regUVD_JMI0_UVD_JMI_ATOMIC_CNTL                                                                 0x066f
#define regUVD_JMI0_UVD_JMI_ATOMIC_CNTL_BASE_IDX                                                        1
#define regUVD_JMI0_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW                                            0x0670
#define regUVD_JMI0_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW_BASE_IDX                                   1
#define regUVD_JMI0_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH                                           0x0671
#define regUVD_JMI0_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH_BASE_IDX                                  1
#define regUVD_JMI0_UVD_LMI_JPEG_READ_64BIT_BAR_LOW                                                     0x0672
#define regUVD_JMI0_UVD_LMI_JPEG_READ_64BIT_BAR_LOW_BASE_IDX                                            1
#define regUVD_JMI0_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH                                                    0x0673
#define regUVD_JMI0_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH_BASE_IDX                                           1
#define regUVD_JMI0_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW                                                    0x0674
#define regUVD_JMI0_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW_BASE_IDX                                           1
#define regUVD_JMI0_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH                                                   0x0675
#define regUVD_JMI0_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH_BASE_IDX                                          1
#define regUVD_JMI0_UVD_LMI_JRBC_IB_64BIT_BAR_LOW                                                       0x0676
#define regUVD_JMI0_UVD_LMI_JRBC_IB_64BIT_BAR_LOW_BASE_IDX                                              1
#define regUVD_JMI0_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH                                                      0x0677
#define regUVD_JMI0_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                             1
#define regUVD_JMI0_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW                                                0x0678
#define regUVD_JMI0_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       1
#define regUVD_JMI0_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH                                               0x0679
#define regUVD_JMI0_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      1
#define regUVD_JMI0_UVD_JMI_ATOMIC_CNTL2                                                                0x067d
#define regUVD_JMI0_UVD_JMI_ATOMIC_CNTL2_BASE_IDX                                                       1


// addressBlock: aid_uvd0_uvd_jmi_common_dec
// base address: 0x21300
#define regUVD_JADP_MCIF_URGENT_CTRL                                                                    0x06c1
#define regUVD_JADP_MCIF_URGENT_CTRL_BASE_IDX                                                           1
#define regUVD_JMI_URGENT_CTRL                                                                          0x06c2
#define regUVD_JMI_URGENT_CTRL_BASE_IDX                                                                 1
#define regUVD_JMI_CTRL                                                                                 0x06c3
#define regUVD_JMI_CTRL_BASE_IDX                                                                        1
#define regJPEG_MEMCHECK_CLAMPING_CNTL                                                                  0x06c4
#define regJPEG_MEMCHECK_CLAMPING_CNTL_BASE_IDX                                                         1
#define regJPEG_MEMCHECK_SAFE_ADDR                                                                      0x06c5
#define regJPEG_MEMCHECK_SAFE_ADDR_BASE_IDX                                                             1
#define regJPEG_MEMCHECK_SAFE_ADDR_64BIT                                                                0x06c6
#define regJPEG_MEMCHECK_SAFE_ADDR_64BIT_BASE_IDX                                                       1
#define regUVD_JMI_LAT_CTRL                                                                             0x06c7
#define regUVD_JMI_LAT_CTRL_BASE_IDX                                                                    1
#define regUVD_JMI_LAT_CNTR                                                                             0x06c8
#define regUVD_JMI_LAT_CNTR_BASE_IDX                                                                    1
#define regUVD_JMI_AVG_LAT_CNTR                                                                         0x06c9
#define regUVD_JMI_AVG_LAT_CNTR_BASE_IDX                                                                1
#define regUVD_JMI_PERFMON_CTRL                                                                         0x06ca
#define regUVD_JMI_PERFMON_CTRL_BASE_IDX                                                                1
#define regUVD_JMI_PERFMON_COUNT_LO                                                                     0x06cb
#define regUVD_JMI_PERFMON_COUNT_LO_BASE_IDX                                                            1
#define regUVD_JMI_PERFMON_COUNT_HI                                                                     0x06cc
#define regUVD_JMI_PERFMON_COUNT_HI_BASE_IDX                                                            1
#define regUVD_JMI_CLEAN_STATUS                                                                         0x06cd
#define regUVD_JMI_CLEAN_STATUS_BASE_IDX                                                                1
#define regUVD_JMI_CNTL                                                                                 0x06ce
#define regUVD_JMI_CNTL_BASE_IDX                                                                        1


// addressBlock: aid_uvd0_uvd_jpeg_common_dec
// base address: 0x21400
#define regJPEG_SOFT_RESET_STATUS                                                                       0x0700
#define regJPEG_SOFT_RESET_STATUS_BASE_IDX                                                              1
#define regJPEG_SYS_INT_EN                                                                              0x0701
#define regJPEG_SYS_INT_EN_BASE_IDX                                                                     1
#define regJPEG_SYS_INT_EN1                                                                             0x0702
#define regJPEG_SYS_INT_EN1_BASE_IDX                                                                    1
#define regJPEG_SYS_INT_STATUS                                                                          0x0703
#define regJPEG_SYS_INT_STATUS_BASE_IDX                                                                 1
#define regJPEG_SYS_INT_STATUS1                                                                         0x0704
#define regJPEG_SYS_INT_STATUS1_BASE_IDX                                                                1
#define regJPEG_SYS_INT_ACK                                                                             0x0705
#define regJPEG_SYS_INT_ACK_BASE_IDX                                                                    1
#define regJPEG_SYS_INT_ACK1                                                                            0x0706
#define regJPEG_SYS_INT_ACK1_BASE_IDX                                                                   1
#define regJPEG_MEMCHECK_SYS_INT_EN                                                                     0x0707
#define regJPEG_MEMCHECK_SYS_INT_EN_BASE_IDX                                                            1
#define regJPEG_MEMCHECK_SYS_INT_EN1                                                                    0x0708
#define regJPEG_MEMCHECK_SYS_INT_EN1_BASE_IDX                                                           1
#define regJPEG_MEMCHECK_SYS_INT_STAT                                                                   0x0709
#define regJPEG_MEMCHECK_SYS_INT_STAT_BASE_IDX                                                          1
#define regJPEG_MEMCHECK_SYS_INT_STAT1                                                                  0x070a
#define regJPEG_MEMCHECK_SYS_INT_STAT1_BASE_IDX                                                         1
#define regJPEG_MEMCHECK_SYS_INT_STAT2                                                                  0x070b
#define regJPEG_MEMCHECK_SYS_INT_STAT2_BASE_IDX                                                         1
#define regJPEG_MEMCHECK_SYS_INT_ACK                                                                    0x070c
#define regJPEG_MEMCHECK_SYS_INT_ACK_BASE_IDX                                                           1
#define regJPEG_MEMCHECK_SYS_INT_ACK1                                                                   0x070d
#define regJPEG_MEMCHECK_SYS_INT_ACK1_BASE_IDX                                                          1
#define regJPEG_MEMCHECK_SYS_INT_ACK2                                                                   0x070e
#define regJPEG_MEMCHECK_SYS_INT_ACK2_BASE_IDX                                                          1
#define regJPEG_MASTINT_EN                                                                              0x0710
#define regJPEG_MASTINT_EN_BASE_IDX                                                                     1
#define regJPEG_IH_CTRL                                                                                 0x0711
#define regJPEG_IH_CTRL_BASE_IDX                                                                        1
#define regJRBBM_ARB_CTRL                                                                               0x0713
#define regJRBBM_ARB_CTRL_BASE_IDX                                                                      1


// addressBlock: aid_uvd0_uvd_jpeg_common_sclk_dec
// base address: 0x21480
#define regJPEG_CGC_GATE                                                                                0x0720
#define regJPEG_CGC_GATE_BASE_IDX                                                                       1
#define regJPEG_CGC_CTRL                                                                                0x0721
#define regJPEG_CGC_CTRL_BASE_IDX                                                                       1
#define regJPEG_CGC_STATUS                                                                              0x0722
#define regJPEG_CGC_STATUS_BASE_IDX                                                                     1
#define regJPEG_COMN_CGC_MEM_CTRL                                                                       0x0723
#define regJPEG_COMN_CGC_MEM_CTRL_BASE_IDX                                                              1
#define regJPEG_DEC_CGC_MEM_CTRL                                                                        0x0724
#define regJPEG_DEC_CGC_MEM_CTRL_BASE_IDX                                                               1
#define regJPEG_ENC_CGC_MEM_CTRL                                                                        0x0726
#define regJPEG_ENC_CGC_MEM_CTRL_BASE_IDX                                                               1
#define regJPEG_PERF_BANK_CONF                                                                          0x0727
#define regJPEG_PERF_BANK_CONF_BASE_IDX                                                                 1
#define regJPEG_PERF_BANK_EVENT_SEL                                                                     0x0728
#define regJPEG_PERF_BANK_EVENT_SEL_BASE_IDX                                                            1
#define regJPEG_PERF_BANK_COUNT0                                                                        0x0729
#define regJPEG_PERF_BANK_COUNT0_BASE_IDX                                                               1
#define regJPEG_PERF_BANK_COUNT1                                                                        0x072a
#define regJPEG_PERF_BANK_COUNT1_BASE_IDX                                                               1
#define regJPEG_PERF_BANK_COUNT2                                                                        0x072b
#define regJPEG_PERF_BANK_COUNT2_BASE_IDX                                                               1
#define regJPEG_PERF_BANK_COUNT3                                                                        0x072c
#define regJPEG_PERF_BANK_COUNT3_BASE_IDX                                                               1


// addressBlock: aid_uvd0_uvd_pg_dec
// base address: 0x1f800
#define regUVD_PGFSM_CONFIG                                                                             0x0000
#define regUVD_PGFSM_CONFIG_BASE_IDX                                                                    1
#define regUVD_PGFSM_STATUS                                                                             0x0001
#define regUVD_PGFSM_STATUS_BASE_IDX                                                                    1
#define regUVD_POWER_STATUS                                                                             0x0002
#define regUVD_POWER_STATUS_BASE_IDX                                                                    1
#define regUVD_JPEG_POWER_STATUS                                                                        0x0003
#define regUVD_JPEG_POWER_STATUS_BASE_IDX                                                               1
#define regUVD_MC_DJPEG_RD_SPACE                                                                        0x0006
#define regUVD_MC_DJPEG_RD_SPACE_BASE_IDX                                                               1
#define regUVD_MC_DJPEG_WR_SPACE                                                                        0x0007
#define regUVD_MC_DJPEG_WR_SPACE_BASE_IDX                                                               1
#define regUVD_MC_EJPEG_RD_SPACE                                                                        0x0008
#define regUVD_MC_EJPEG_RD_SPACE_BASE_IDX                                                               1
#define regUVD_MC_EJPEG_WR_SPACE                                                                        0x0009
#define regUVD_MC_EJPEG_WR_SPACE_BASE_IDX                                                               1
#define regUVD_PG_IND_INDEX                                                                             0x000c
#define regUVD_PG_IND_INDEX_BASE_IDX                                                                    1
#define regUVD_PG_IND_DATA                                                                              0x000e
#define regUVD_PG_IND_DATA_BASE_IDX                                                                     1
#define regCC_UVD_HARVESTING                                                                            0x000f
#define regCC_UVD_HARVESTING_BASE_IDX                                                                   1
#define regUVD_DPG_LMA_CTL                                                                              0x0011
#define regUVD_DPG_LMA_CTL_BASE_IDX                                                                     1
#define regUVD_DPG_LMA_DATA                                                                             0x0012
#define regUVD_DPG_LMA_DATA_BASE_IDX                                                                    1
#define regUVD_DPG_LMA_MASK                                                                             0x0013
#define regUVD_DPG_LMA_MASK_BASE_IDX                                                                    1
#define regUVD_DPG_PAUSE                                                                                0x0014
#define regUVD_DPG_PAUSE_BASE_IDX                                                                       1
#define regUVD_SCRATCH1                                                                                 0x0015
#define regUVD_SCRATCH1_BASE_IDX                                                                        1
#define regUVD_SCRATCH2                                                                                 0x0016
#define regUVD_SCRATCH2_BASE_IDX                                                                        1
#define regUVD_SCRATCH3                                                                                 0x0017
#define regUVD_SCRATCH3_BASE_IDX                                                                        1
#define regUVD_SCRATCH4                                                                                 0x0018
#define regUVD_SCRATCH4_BASE_IDX                                                                        1
#define regUVD_SCRATCH5                                                                                 0x0019
#define regUVD_SCRATCH5_BASE_IDX                                                                        1
#define regUVD_SCRATCH6                                                                                 0x001a
#define regUVD_SCRATCH6_BASE_IDX                                                                        1
#define regUVD_SCRATCH7                                                                                 0x001b
#define regUVD_SCRATCH7_BASE_IDX                                                                        1
#define regUVD_SCRATCH8                                                                                 0x001c
#define regUVD_SCRATCH8_BASE_IDX                                                                        1
#define regUVD_SCRATCH9                                                                                 0x001d
#define regUVD_SCRATCH9_BASE_IDX                                                                        1
#define regUVD_SCRATCH10                                                                                0x001e
#define regUVD_SCRATCH10_BASE_IDX                                                                       1
#define regUVD_SCRATCH11                                                                                0x001f
#define regUVD_SCRATCH11_BASE_IDX                                                                       1
#define regUVD_SCRATCH12                                                                                0x0020
#define regUVD_SCRATCH12_BASE_IDX                                                                       1
#define regUVD_SCRATCH13                                                                                0x0021
#define regUVD_SCRATCH13_BASE_IDX                                                                       1
#define regUVD_SCRATCH14                                                                                0x0022
#define regUVD_SCRATCH14_BASE_IDX                                                                       1
#define regUVD_FREE_COUNTER_REG                                                                         0x0023
#define regUVD_FREE_COUNTER_REG_BASE_IDX                                                                1
#define regUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_LOW                                                         0x0024
#define regUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_LOW_BASE_IDX                                                1
#define regUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_HIGH                                                        0x0025
#define regUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_HIGH_BASE_IDX                                               1
#define regUVD_DPG_VCPU_CACHE_OFFSET0                                                                   0x0026
#define regUVD_DPG_VCPU_CACHE_OFFSET0_BASE_IDX                                                          1
#define regUVD_DPG_LMI_VCPU_CACHE_VMID                                                                  0x0027
#define regUVD_DPG_LMI_VCPU_CACHE_VMID_BASE_IDX                                                         1
#define regUVD_REG_FILTER_EN                                                                            0x0028
#define regUVD_REG_FILTER_EN_BASE_IDX                                                                   1
#define regUVD_SECURITY_REG_VIO_REPORT                                                                  0x0029
#define regUVD_SECURITY_REG_VIO_REPORT_BASE_IDX                                                         1
#define regUVD_FW_VERSION                                                                               0x002a
#define regUVD_FW_VERSION_BASE_IDX                                                                      1
#define regUVD_PF_STATUS                                                                                0x002c
#define regUVD_PF_STATUS_BASE_IDX                                                                       1
#define regUVD_DPG_CLK_EN_VCPU_REPORT                                                                   0x002e
#define regUVD_DPG_CLK_EN_VCPU_REPORT_BASE_IDX                                                          1
#define regCC_UVD_VCPU_ERR_DETECT_BOT_LO                                                                0x002f
#define regCC_UVD_VCPU_ERR_DETECT_BOT_LO_BASE_IDX                                                       1
#define regCC_UVD_VCPU_ERR_DETECT_BOT_HI                                                                0x0030
#define regCC_UVD_VCPU_ERR_DETECT_BOT_HI_BASE_IDX                                                       1
#define regCC_UVD_VCPU_ERR_DETECT_TOP_LO                                                                0x0031
#define regCC_UVD_VCPU_ERR_DETECT_TOP_LO_BASE_IDX                                                       1
#define regCC_UVD_VCPU_ERR_DETECT_TOP_HI                                                                0x0032
#define regCC_UVD_VCPU_ERR_DETECT_TOP_HI_BASE_IDX                                                       1
#define regCC_UVD_VCPU_ERR                                                                              0x0033
#define regCC_UVD_VCPU_ERR_BASE_IDX                                                                     1
#define regCC_UVD_VCPU_ERR_INST_ADDR_LO                                                                 0x0034
#define regCC_UVD_VCPU_ERR_INST_ADDR_LO_BASE_IDX                                                        1
#define regCC_UVD_VCPU_ERR_INST_ADDR_HI                                                                 0x0035
#define regCC_UVD_VCPU_ERR_INST_ADDR_HI_BASE_IDX                                                        1
#define regUVD_LMI_MMSCH_NC_SPACE                                                                       0x003d
#define regUVD_LMI_MMSCH_NC_SPACE_BASE_IDX                                                              1
#define regUVD_LMI_ATOMIC_SPACE                                                                         0x003e
#define regUVD_LMI_ATOMIC_SPACE_BASE_IDX                                                                1
#define regUVD_GFX8_ADDR_CONFIG                                                                         0x0041
#define regUVD_GFX8_ADDR_CONFIG_BASE_IDX                                                                1
#define regUVD_GFX10_ADDR_CONFIG                                                                        0x0042
#define regUVD_GFX10_ADDR_CONFIG_BASE_IDX                                                               1
#define regUVD_GPCNT2_CNTL                                                                              0x0043
#define regUVD_GPCNT2_CNTL_BASE_IDX                                                                     1
#define regUVD_GPCNT2_TARGET_LOWER                                                                      0x0044
#define regUVD_GPCNT2_TARGET_LOWER_BASE_IDX                                                             1
#define regUVD_GPCNT2_STATUS_LOWER                                                                      0x0045
#define regUVD_GPCNT2_STATUS_LOWER_BASE_IDX                                                             1
#define regUVD_GPCNT2_TARGET_UPPER                                                                      0x0046
#define regUVD_GPCNT2_TARGET_UPPER_BASE_IDX                                                             1
#define regUVD_GPCNT2_STATUS_UPPER                                                                      0x0047
#define regUVD_GPCNT2_STATUS_UPPER_BASE_IDX                                                             1
#define regUVD_GPCNT3_CNTL                                                                              0x0048
#define regUVD_GPCNT3_CNTL_BASE_IDX                                                                     1
#define regUVD_GPCNT3_TARGET_LOWER                                                                      0x0049
#define regUVD_GPCNT3_TARGET_LOWER_BASE_IDX                                                             1
#define regUVD_GPCNT3_STATUS_LOWER                                                                      0x004a
#define regUVD_GPCNT3_STATUS_LOWER_BASE_IDX                                                             1
#define regUVD_GPCNT3_TARGET_UPPER                                                                      0x004b
#define regUVD_GPCNT3_TARGET_UPPER_BASE_IDX                                                             1
#define regUVD_GPCNT3_STATUS_UPPER                                                                      0x004c
#define regUVD_GPCNT3_STATUS_UPPER_BASE_IDX                                                             1
#define regUVD_VCLK_DS_CNTL                                                                             0x004d
#define regUVD_VCLK_DS_CNTL_BASE_IDX                                                                    1
#define regUVD_DCLK_DS_CNTL                                                                             0x004e
#define regUVD_DCLK_DS_CNTL_BASE_IDX                                                                    1
#define regUVD_TSC_LOWER                                                                                0x004f
#define regUVD_TSC_LOWER_BASE_IDX                                                                       1
#define regUVD_TSC_UPPER                                                                                0x0050
#define regUVD_TSC_UPPER_BASE_IDX                                                                       1
#define regVCN_FEATURES                                                                                 0x0051
#define regVCN_FEATURES_BASE_IDX                                                                        1
#define regUVD_GPUIOV_STATUS                                                                            0x0055
#define regUVD_GPUIOV_STATUS_BASE_IDX                                                                   1
#define regUVD_RAS_VCPU_VCODEC_STATUS                                                                   0x0057
#define regUVD_RAS_VCPU_VCODEC_STATUS_BASE_IDX                                                          1
#define regUVD_RAS_MMSCH_FATAL_ERROR                                                                    0x0058
#define regUVD_RAS_MMSCH_FATAL_ERROR_BASE_IDX                                                           1
#define regUVD_RAS_JPEG0_STATUS                                                                         0x0059
#define regUVD_RAS_JPEG0_STATUS_BASE_IDX                                                                1
#define regUVD_RAS_JPEG1_STATUS                                                                         0x005a
#define regUVD_RAS_JPEG1_STATUS_BASE_IDX                                                                1
#define regUVD_RAS_CNTL_PMI_ARB                                                                         0x005b
#define regUVD_RAS_CNTL_PMI_ARB_BASE_IDX                                                                1
#define regUVD_SCRATCH15                                                                                0x005c
#define regUVD_SCRATCH15_BASE_IDX                                                                       1
#define regVCN_JPEG_DB_CTRL1                                                                            0x005d
#define regVCN_JPEG_DB_CTRL1_BASE_IDX                                                                   1
#define regVCN_JPEG_DB_CTRL2                                                                            0x005e
#define regVCN_JPEG_DB_CTRL2_BASE_IDX                                                                   1
#define regVCN_JPEG_DB_CTRL3                                                                            0x005f
#define regVCN_JPEG_DB_CTRL3_BASE_IDX                                                                   1
#define regVCN_JPEG_DB_CTRL4                                                                            0x0060
#define regVCN_JPEG_DB_CTRL4_BASE_IDX                                                                   1
#define regVCN_JPEG_DB_CTRL5                                                                            0x0061
#define regVCN_JPEG_DB_CTRL5_BASE_IDX                                                                   1
#define regVCN_JPEG_DB_CTRL6                                                                            0x0062
#define regVCN_JPEG_DB_CTRL6_BASE_IDX                                                                   1
#define regVCN_JPEG_DB_CTRL7                                                                            0x0063
#define regVCN_JPEG_DB_CTRL7_BASE_IDX                                                                   1
#define regUVD_SCRATCH32                                                                                0x006d
#define regUVD_SCRATCH32_BASE_IDX                                                                       1
#define regUVD_VERSION                                                                                  0x006e
#define regUVD_VERSION_BASE_IDX                                                                         1
#define regVCN_RB_DB_CTRL                                                                               0x0070
#define regVCN_RB_DB_CTRL_BASE_IDX                                                                      1
#define regVCN_JPEG_DB_CTRL                                                                             0x0071
#define regVCN_JPEG_DB_CTRL_BASE_IDX                                                                    1
#define regVCN_RB1_DB_CTRL                                                                              0x0072
#define regVCN_RB1_DB_CTRL_BASE_IDX                                                                     1
#define regVCN_RB2_DB_CTRL                                                                              0x0073
#define regVCN_RB2_DB_CTRL_BASE_IDX                                                                     1
#define regVCN_RB3_DB_CTRL                                                                              0x0074
#define regVCN_RB3_DB_CTRL_BASE_IDX                                                                     1
#define regVCN_RB4_DB_CTRL                                                                              0x0075
#define regVCN_RB4_DB_CTRL_BASE_IDX                                                                     1
#define regVCN_RB_ENABLE                                                                                0x0085
#define regVCN_RB_ENABLE_BASE_IDX                                                                       1
#define regVCN_RB_WPTR_CTRL                                                                             0x0086
#define regVCN_RB_WPTR_CTRL_BASE_IDX                                                                    1
#define regUVD_RB_RPTR                                                                                  0x00ac
#define regUVD_RB_RPTR_BASE_IDX                                                                         1
#define regUVD_RB_WPTR                                                                                  0x00ad
#define regUVD_RB_WPTR_BASE_IDX                                                                         1
#define regUVD_RB_RPTR2                                                                                 0x00ae
#define regUVD_RB_RPTR2_BASE_IDX                                                                        1
#define regUVD_RB_WPTR2                                                                                 0x00af
#define regUVD_RB_WPTR2_BASE_IDX                                                                        1
#define regUVD_RB_RPTR3                                                                                 0x00b0
#define regUVD_RB_RPTR3_BASE_IDX                                                                        1
#define regUVD_RB_WPTR3                                                                                 0x00b1
#define regUVD_RB_WPTR3_BASE_IDX                                                                        1
#define regUVD_RB_RPTR4                                                                                 0x00b2
#define regUVD_RB_RPTR4_BASE_IDX                                                                        1
#define regUVD_RB_WPTR4                                                                                 0x00b3
#define regUVD_RB_WPTR4_BASE_IDX                                                                        1
#define regUVD_OUT_RB_RPTR                                                                              0x00b4
#define regUVD_OUT_RB_RPTR_BASE_IDX                                                                     1
#define regUVD_OUT_RB_WPTR                                                                              0x00b5
#define regUVD_OUT_RB_WPTR_BASE_IDX                                                                     1
#define regUVD_AUDIO_RB_RPTR                                                                            0x00b6
#define regUVD_AUDIO_RB_RPTR_BASE_IDX                                                                   1
#define regUVD_AUDIO_RB_WPTR                                                                            0x00b7
#define regUVD_AUDIO_RB_WPTR_BASE_IDX                                                                   1
#define regUVD_RBC_RB_RPTR                                                                              0x00b8
#define regUVD_RBC_RB_RPTR_BASE_IDX                                                                     1
#define regUVD_RBC_RB_WPTR                                                                              0x00b9
#define regUVD_RBC_RB_WPTR_BASE_IDX                                                                     1
#define regUVD_DPG_LMA_CTL2                                                                             0x00bb
#define regUVD_DPG_LMA_CTL2_BASE_IDX                                                                    1


// addressBlock: aid_uvd0_mmsch_dec
// base address: 0x20d00
#define regMMSCH_UCODE_ADDR                                                                             0x0540
#define regMMSCH_UCODE_ADDR_BASE_IDX                                                                    1
#define regMMSCH_UCODE_DATA                                                                             0x0541
#define regMMSCH_UCODE_DATA_BASE_IDX                                                                    1
#define regMMSCH_SRAM_ADDR                                                                              0x0542
#define regMMSCH_SRAM_ADDR_BASE_IDX                                                                     1
#define regMMSCH_SRAM_DATA                                                                              0x0543
#define regMMSCH_SRAM_DATA_BASE_IDX                                                                     1
#define regMMSCH_VF_SRAM_OFFSET                                                                         0x0544
#define regMMSCH_VF_SRAM_OFFSET_BASE_IDX                                                                1
#define regMMSCH_DB_SRAM_OFFSET                                                                         0x0545
#define regMMSCH_DB_SRAM_OFFSET_BASE_IDX                                                                1
#define regMMSCH_CTX_SRAM_OFFSET                                                                        0x0546
#define regMMSCH_CTX_SRAM_OFFSET_BASE_IDX                                                               1
#define regMMSCH_CTL                                                                                    0x0547
#define regMMSCH_CTL_BASE_IDX                                                                           1
#define regMMSCH_INTR                                                                                   0x0548
#define regMMSCH_INTR_BASE_IDX                                                                          1
#define regMMSCH_INTR_ACK                                                                               0x0549
#define regMMSCH_INTR_ACK_BASE_IDX                                                                      1
#define regMMSCH_INTR_STATUS                                                                            0x054a
#define regMMSCH_INTR_STATUS_BASE_IDX                                                                   1
#define regMMSCH_VF_VMID                                                                                0x054b
#define regMMSCH_VF_VMID_BASE_IDX                                                                       1
#define regMMSCH_VF_CTX_ADDR_LO                                                                         0x054c
#define regMMSCH_VF_CTX_ADDR_LO_BASE_IDX                                                                1
#define regMMSCH_VF_CTX_ADDR_HI                                                                         0x054d
#define regMMSCH_VF_CTX_ADDR_HI_BASE_IDX                                                                1
#define regMMSCH_VF_CTX_SIZE                                                                            0x054e
#define regMMSCH_VF_CTX_SIZE_BASE_IDX                                                                   1
#define regMMSCH_VF_GPCOM_ADDR_LO                                                                       0x054f
#define regMMSCH_VF_GPCOM_ADDR_LO_BASE_IDX                                                              1
#define regMMSCH_VF_GPCOM_ADDR_HI                                                                       0x0550
#define regMMSCH_VF_GPCOM_ADDR_HI_BASE_IDX                                                              1
#define regMMSCH_VF_GPCOM_SIZE                                                                          0x0551
#define regMMSCH_VF_GPCOM_SIZE_BASE_IDX                                                                 1
#define regMMSCH_VF_MAILBOX_HOST                                                                        0x0552
#define regMMSCH_VF_MAILBOX_HOST_BASE_IDX                                                               1
#define regMMSCH_VF_MAILBOX_RESP                                                                        0x0553
#define regMMSCH_VF_MAILBOX_RESP_BASE_IDX                                                               1
#define regMMSCH_VF_MAILBOX_0                                                                           0x0554
#define regMMSCH_VF_MAILBOX_0_BASE_IDX                                                                  1
#define regMMSCH_VF_MAILBOX_0_RESP                                                                      0x0555
#define regMMSCH_VF_MAILBOX_0_RESP_BASE_IDX                                                             1
#define regMMSCH_VF_MAILBOX_1                                                                           0x0556
#define regMMSCH_VF_MAILBOX_1_BASE_IDX                                                                  1
#define regMMSCH_VF_MAILBOX_1_RESP                                                                      0x0557
#define regMMSCH_VF_MAILBOX_1_RESP_BASE_IDX                                                             1
#define regMMSCH_CNTL                                                                                   0x055c
#define regMMSCH_CNTL_BASE_IDX                                                                          1
#define regMMSCH_NONCACHE_OFFSET0                                                                       0x055d
#define regMMSCH_NONCACHE_OFFSET0_BASE_IDX                                                              1
#define regMMSCH_NONCACHE_SIZE0                                                                         0x055e
#define regMMSCH_NONCACHE_SIZE0_BASE_IDX                                                                1
#define regMMSCH_NONCACHE_OFFSET1                                                                       0x055f
#define regMMSCH_NONCACHE_OFFSET1_BASE_IDX                                                              1
#define regMMSCH_NONCACHE_SIZE1                                                                         0x0560
#define regMMSCH_NONCACHE_SIZE1_BASE_IDX                                                                1
#define regMMSCH_PROC_STATE1                                                                            0x0566
#define regMMSCH_PROC_STATE1_BASE_IDX                                                                   1
#define regMMSCH_LAST_MC_ADDR                                                                           0x0567
#define regMMSCH_LAST_MC_ADDR_BASE_IDX                                                                  1
#define regMMSCH_LAST_MEM_ACCESS_HI                                                                     0x0568
#define regMMSCH_LAST_MEM_ACCESS_HI_BASE_IDX                                                            1
#define regMMSCH_LAST_MEM_ACCESS_LO                                                                     0x0569
#define regMMSCH_LAST_MEM_ACCESS_LO_BASE_IDX                                                            1
#define regMMSCH_IOV_ACTIVE_FCN_ID                                                                      0x056a
#define regMMSCH_IOV_ACTIVE_FCN_ID_BASE_IDX                                                             1
#define regMMSCH_SCRATCH_0                                                                              0x056b
#define regMMSCH_SCRATCH_0_BASE_IDX                                                                     1
#define regMMSCH_SCRATCH_1                                                                              0x056c
#define regMMSCH_SCRATCH_1_BASE_IDX                                                                     1
#define regMMSCH_GPUIOV_SCH_BLOCK_0                                                                     0x056d
#define regMMSCH_GPUIOV_SCH_BLOCK_0_BASE_IDX                                                            1
#define regMMSCH_GPUIOV_CMD_CONTROL_0                                                                   0x056e
#define regMMSCH_GPUIOV_CMD_CONTROL_0_BASE_IDX                                                          1
#define regMMSCH_GPUIOV_CMD_STATUS_0                                                                    0x056f
#define regMMSCH_GPUIOV_CMD_STATUS_0_BASE_IDX                                                           1
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_0                                                                0x0570
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_0_BASE_IDX                                                       1
#define regMMSCH_GPUIOV_ACTIVE_FCNS_0                                                                   0x0571
#define regMMSCH_GPUIOV_ACTIVE_FCNS_0_BASE_IDX                                                          1
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_0                                                                 0x0572
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_0_BASE_IDX                                                        1
#define regMMSCH_GPUIOV_DW6_0                                                                           0x0573
#define regMMSCH_GPUIOV_DW6_0_BASE_IDX                                                                  1
#define regMMSCH_GPUIOV_DW7_0                                                                           0x0574
#define regMMSCH_GPUIOV_DW7_0_BASE_IDX                                                                  1
#define regMMSCH_GPUIOV_DW8_0                                                                           0x0575
#define regMMSCH_GPUIOV_DW8_0_BASE_IDX                                                                  1
#define regMMSCH_GPUIOV_SCH_BLOCK_1                                                                     0x0576
#define regMMSCH_GPUIOV_SCH_BLOCK_1_BASE_IDX                                                            1
#define regMMSCH_GPUIOV_CMD_CONTROL_1                                                                   0x0577
#define regMMSCH_GPUIOV_CMD_CONTROL_1_BASE_IDX                                                          1
#define regMMSCH_GPUIOV_CMD_STATUS_1                                                                    0x0578
#define regMMSCH_GPUIOV_CMD_STATUS_1_BASE_IDX                                                           1
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_1                                                                0x0579
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_1_BASE_IDX                                                       1
#define regMMSCH_GPUIOV_ACTIVE_FCNS_1                                                                   0x057a
#define regMMSCH_GPUIOV_ACTIVE_FCNS_1_BASE_IDX                                                          1
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_1                                                                 0x057b
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_1_BASE_IDX                                                        1
#define regMMSCH_GPUIOV_DW6_1                                                                           0x057c
#define regMMSCH_GPUIOV_DW6_1_BASE_IDX                                                                  1
#define regMMSCH_GPUIOV_DW7_1                                                                           0x057d
#define regMMSCH_GPUIOV_DW7_1_BASE_IDX                                                                  1
#define regMMSCH_GPUIOV_DW8_1                                                                           0x057e
#define regMMSCH_GPUIOV_DW8_1_BASE_IDX                                                                  1
#define regMMSCH_GPUIOV_CNTXT                                                                           0x057f
#define regMMSCH_GPUIOV_CNTXT_BASE_IDX                                                                  1
#define regMMSCH_SCRATCH_2                                                                              0x0580
#define regMMSCH_SCRATCH_2_BASE_IDX                                                                     1
#define regMMSCH_SCRATCH_3                                                                              0x0581
#define regMMSCH_SCRATCH_3_BASE_IDX                                                                     1
#define regMMSCH_SCRATCH_4                                                                              0x0582
#define regMMSCH_SCRATCH_4_BASE_IDX                                                                     1
#define regMMSCH_SCRATCH_5                                                                              0x0583
#define regMMSCH_SCRATCH_5_BASE_IDX                                                                     1
#define regMMSCH_SCRATCH_6                                                                              0x0584
#define regMMSCH_SCRATCH_6_BASE_IDX                                                                     1
#define regMMSCH_SCRATCH_7                                                                              0x0585
#define regMMSCH_SCRATCH_7_BASE_IDX                                                                     1
#define regMMSCH_VFID_FIFO_HEAD_0                                                                       0x0586
#define regMMSCH_VFID_FIFO_HEAD_0_BASE_IDX                                                              1
#define regMMSCH_VFID_FIFO_TAIL_0                                                                       0x0587
#define regMMSCH_VFID_FIFO_TAIL_0_BASE_IDX                                                              1
#define regMMSCH_VFID_FIFO_HEAD_1                                                                       0x0588
#define regMMSCH_VFID_FIFO_HEAD_1_BASE_IDX                                                              1
#define regMMSCH_VFID_FIFO_TAIL_1                                                                       0x0589
#define regMMSCH_VFID_FIFO_TAIL_1_BASE_IDX                                                              1
#define regMMSCH_NACK_STATUS                                                                            0x058a
#define regMMSCH_NACK_STATUS_BASE_IDX                                                                   1
#define regMMSCH_VF_MAILBOX0_DATA                                                                       0x058b
#define regMMSCH_VF_MAILBOX0_DATA_BASE_IDX                                                              1
#define regMMSCH_VF_MAILBOX1_DATA                                                                       0x058c
#define regMMSCH_VF_MAILBOX1_DATA_BASE_IDX                                                              1
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_0                                                                  0x058d
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_0_BASE_IDX                                                         1
#define regMMSCH_GPUIOV_CMD_STATUS_IP_0                                                                 0x058e
#define regMMSCH_GPUIOV_CMD_STATUS_IP_0_BASE_IDX                                                        1
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_0                                                              0x058f
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_0_BASE_IDX                                                     1
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_1                                                                  0x0590
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_1_BASE_IDX                                                         1
#define regMMSCH_GPUIOV_CMD_STATUS_IP_1                                                                 0x0591
#define regMMSCH_GPUIOV_CMD_STATUS_IP_1_BASE_IDX                                                        1
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_1                                                              0x0592
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_1_BASE_IDX                                                     1
#define regMMSCH_GPUIOV_CNTXT_IP                                                                        0x0593
#define regMMSCH_GPUIOV_CNTXT_IP_BASE_IDX                                                               1
#define regMMSCH_GPUIOV_SCH_BLOCK_2                                                                     0x0594
#define regMMSCH_GPUIOV_SCH_BLOCK_2_BASE_IDX                                                            1
#define regMMSCH_GPUIOV_CMD_CONTROL_2                                                                   0x0595
#define regMMSCH_GPUIOV_CMD_CONTROL_2_BASE_IDX                                                          1
#define regMMSCH_GPUIOV_CMD_STATUS_2                                                                    0x0596
#define regMMSCH_GPUIOV_CMD_STATUS_2_BASE_IDX                                                           1
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_2                                                                0x0597
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_2_BASE_IDX                                                       1
#define regMMSCH_GPUIOV_ACTIVE_FCNS_2                                                                   0x0598
#define regMMSCH_GPUIOV_ACTIVE_FCNS_2_BASE_IDX                                                          1
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_2                                                                 0x0599
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_2_BASE_IDX                                                        1
#define regMMSCH_GPUIOV_DW6_2                                                                           0x059a
#define regMMSCH_GPUIOV_DW6_2_BASE_IDX                                                                  1
#define regMMSCH_GPUIOV_DW7_2                                                                           0x059b
#define regMMSCH_GPUIOV_DW7_2_BASE_IDX                                                                  1
#define regMMSCH_GPUIOV_DW8_2                                                                           0x059c
#define regMMSCH_GPUIOV_DW8_2_BASE_IDX                                                                  1
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_2                                                                  0x059d
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_2_BASE_IDX                                                         1
#define regMMSCH_GPUIOV_CMD_STATUS_IP_2                                                                 0x059e
#define regMMSCH_GPUIOV_CMD_STATUS_IP_2_BASE_IDX                                                        1
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_2                                                              0x059f
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_2_BASE_IDX                                                     1
#define regMMSCH_VFID_FIFO_HEAD_2                                                                       0x05a0
#define regMMSCH_VFID_FIFO_HEAD_2_BASE_IDX                                                              1
#define regMMSCH_VFID_FIFO_TAIL_2                                                                       0x05a1
#define regMMSCH_VFID_FIFO_TAIL_2_BASE_IDX                                                              1
#define regMMSCH_VM_BUSY_STATUS_0                                                                       0x05a2
#define regMMSCH_VM_BUSY_STATUS_0_BASE_IDX                                                              1
#define regMMSCH_VM_BUSY_STATUS_1                                                                       0x05a3
#define regMMSCH_VM_BUSY_STATUS_1_BASE_IDX                                                              1
#define regMMSCH_VM_BUSY_STATUS_2                                                                       0x05a4
#define regMMSCH_VM_BUSY_STATUS_2_BASE_IDX                                                              1


// addressBlock: aid_uvd0_slmi_adpdec
// base address: 0x21c00
#define regUVD_LMI_MMSCH_NC0_64BIT_BAR_LOW                                                              0x0900
#define regUVD_LMI_MMSCH_NC0_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC0_64BIT_BAR_HIGH                                                             0x0901
#define regUVD_LMI_MMSCH_NC0_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC1_64BIT_BAR_LOW                                                              0x0902
#define regUVD_LMI_MMSCH_NC1_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC1_64BIT_BAR_HIGH                                                             0x0903
#define regUVD_LMI_MMSCH_NC1_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC2_64BIT_BAR_LOW                                                              0x0904
#define regUVD_LMI_MMSCH_NC2_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC2_64BIT_BAR_HIGH                                                             0x0905
#define regUVD_LMI_MMSCH_NC2_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC3_64BIT_BAR_LOW                                                              0x0906
#define regUVD_LMI_MMSCH_NC3_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC3_64BIT_BAR_HIGH                                                             0x0907
#define regUVD_LMI_MMSCH_NC3_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC4_64BIT_BAR_LOW                                                              0x0908
#define regUVD_LMI_MMSCH_NC4_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC4_64BIT_BAR_HIGH                                                             0x0909
#define regUVD_LMI_MMSCH_NC4_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC5_64BIT_BAR_LOW                                                              0x090a
#define regUVD_LMI_MMSCH_NC5_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC5_64BIT_BAR_HIGH                                                             0x090b
#define regUVD_LMI_MMSCH_NC5_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC6_64BIT_BAR_LOW                                                              0x090c
#define regUVD_LMI_MMSCH_NC6_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC6_64BIT_BAR_HIGH                                                             0x090d
#define regUVD_LMI_MMSCH_NC6_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC7_64BIT_BAR_LOW                                                              0x090e
#define regUVD_LMI_MMSCH_NC7_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC7_64BIT_BAR_HIGH                                                             0x090f
#define regUVD_LMI_MMSCH_NC7_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC_VMID                                                                        0x0910
#define regUVD_LMI_MMSCH_NC_VMID_BASE_IDX                                                               1
#define regUVD_LMI_MMSCH_CTRL                                                                           0x0911
#define regUVD_LMI_MMSCH_CTRL_BASE_IDX                                                                  1
#define regUVD_MMSCH_LMI_STATUS                                                                         0x0912
#define regUVD_MMSCH_LMI_STATUS_BASE_IDX                                                                1
#define regVCN_RAS_CNTL_MMSCH                                                                           0x0914
#define regVCN_RAS_CNTL_MMSCH_BASE_IDX                                                                  1

// addressBlock: aid_uvd0_vcn_edcc_dec
// base address: 0x21d20
#define regVCN_UE_ERR_STATUS_LO_VIDD                                                                    0x094c
#define regVCN_UE_ERR_STATUS_LO_VIDD_BASE_IDX                                                           1
#define regVCN_UE_ERR_STATUS_HI_VIDD                                                                    0x094d
#define regVCN_UE_ERR_STATUS_HI_VIDD_BASE_IDX                                                           1
#define regVCN_UE_ERR_STATUS_LO_VIDV                                                                    0x094e
#define regVCN_UE_ERR_STATUS_LO_VIDV_BASE_IDX                                                           1
#define regVCN_UE_ERR_STATUS_HI_VIDV                                                                    0x094f
#define regVCN_UE_ERR_STATUS_HI_VIDV_BASE_IDX                                                           1
#define regVCN_CE_ERR_STATUS_LO_MMSCHD                                                                  0x0950
#define regVCN_CE_ERR_STATUS_LO_MMSCHD_BASE_IDX                                                         1
#define regVCN_CE_ERR_STATUS_HI_MMSCHD                                                                  0x0951
#define regVCN_CE_ERR_STATUS_HI_MMSCHD_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG0S                                                                  0x0952
#define regVCN_UE_ERR_STATUS_LO_JPEG0S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG0S                                                                  0x0953
#define regVCN_UE_ERR_STATUS_HI_JPEG0S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG0D                                                                  0x0954
#define regVCN_UE_ERR_STATUS_LO_JPEG0D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG0D                                                                  0x0955
#define regVCN_UE_ERR_STATUS_HI_JPEG0D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG1S                                                                  0x0956
#define regVCN_UE_ERR_STATUS_LO_JPEG1S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG1S                                                                  0x0957
#define regVCN_UE_ERR_STATUS_HI_JPEG1S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG1D                                                                  0x0958
#define regVCN_UE_ERR_STATUS_LO_JPEG1D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG1D                                                                  0x0959
#define regVCN_UE_ERR_STATUS_HI_JPEG1D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG2S                                                                  0x095a
#define regVCN_UE_ERR_STATUS_LO_JPEG2S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG2S                                                                  0x095b
#define regVCN_UE_ERR_STATUS_HI_JPEG2S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG2D                                                                  0x095c
#define regVCN_UE_ERR_STATUS_LO_JPEG2D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG2D                                                                  0x095d
#define regVCN_UE_ERR_STATUS_HI_JPEG2D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG3S                                                                  0x095e
#define regVCN_UE_ERR_STATUS_LO_JPEG3S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG3S                                                                  0x095f
#define regVCN_UE_ERR_STATUS_HI_JPEG3S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG3D                                                                  0x0960
#define regVCN_UE_ERR_STATUS_LO_JPEG3D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG3D                                                                  0x0961
#define regVCN_UE_ERR_STATUS_HI_JPEG3D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG4S                                                                  0x0962
#define regVCN_UE_ERR_STATUS_LO_JPEG4S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG4S                                                                  0x0963
#define regVCN_UE_ERR_STATUS_HI_JPEG4S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG4D                                                                  0x0964
#define regVCN_UE_ERR_STATUS_LO_JPEG4D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG4D                                                                  0x0965
#define regVCN_UE_ERR_STATUS_HI_JPEG4D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG5S                                                                  0x0966
#define regVCN_UE_ERR_STATUS_LO_JPEG5S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG5S                                                                  0x0967
#define regVCN_UE_ERR_STATUS_HI_JPEG5S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG5D                                                                  0x0968
#define regVCN_UE_ERR_STATUS_LO_JPEG5D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG5D                                                                  0x0969
#define regVCN_UE_ERR_STATUS_HI_JPEG5D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG6S                                                                  0x096a
#define regVCN_UE_ERR_STATUS_LO_JPEG6S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG6S                                                                  0x096b
#define regVCN_UE_ERR_STATUS_HI_JPEG6S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG6D                                                                  0x096c
#define regVCN_UE_ERR_STATUS_LO_JPEG6D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG6D                                                                  0x096d
#define regVCN_UE_ERR_STATUS_HI_JPEG6D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG7S                                                                  0x096e
#define regVCN_UE_ERR_STATUS_LO_JPEG7S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG7S                                                                  0x096f
#define regVCN_UE_ERR_STATUS_HI_JPEG7S_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_LO_JPEG7D                                                                  0x0970
#define regVCN_UE_ERR_STATUS_LO_JPEG7D_BASE_IDX                                                         1
#define regVCN_UE_ERR_STATUS_HI_JPEG7D                                                                  0x0971
#define regVCN_UE_ERR_STATUS_HI_JPEG7D_BASE_IDX                                                         1

// addressBlock: aid_uvd0_uvd_jrbc1_uvd_jrbc_dec
// base address: 0x1e000
#define regUVD_JRBC1_UVD_JRBC_RB_WPTR                                                                   0x0000
#define regUVD_JRBC1_UVD_JRBC_RB_WPTR_BASE_IDX                                                          0
#define regUVD_JRBC1_UVD_JRBC_RB_CNTL                                                                   0x0001
#define regUVD_JRBC1_UVD_JRBC_RB_CNTL_BASE_IDX                                                          0
#define regUVD_JRBC1_UVD_JRBC_IB_SIZE                                                                   0x0002
#define regUVD_JRBC1_UVD_JRBC_IB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC1_UVD_JRBC_URGENT_CNTL                                                               0x0003
#define regUVD_JRBC1_UVD_JRBC_URGENT_CNTL_BASE_IDX                                                      0
#define regUVD_JRBC1_UVD_JRBC_RB_REF_DATA                                                               0x0004
#define regUVD_JRBC1_UVD_JRBC_RB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC1_UVD_JRBC_RB_COND_RD_TIMER                                                          0x0005
#define regUVD_JRBC1_UVD_JRBC_RB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC1_UVD_JRBC_SOFT_RESET                                                                0x0008
#define regUVD_JRBC1_UVD_JRBC_SOFT_RESET_BASE_IDX                                                       0
#define regUVD_JRBC1_UVD_JRBC_STATUS                                                                    0x0009
#define regUVD_JRBC1_UVD_JRBC_STATUS_BASE_IDX                                                           0
#define regUVD_JRBC1_UVD_JRBC_RB_RPTR                                                                   0x000a
#define regUVD_JRBC1_UVD_JRBC_RB_RPTR_BASE_IDX                                                          0
#define regUVD_JRBC1_UVD_JRBC_RB_BUF_STATUS                                                             0x000b
#define regUVD_JRBC1_UVD_JRBC_RB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC1_UVD_JRBC_IB_BUF_STATUS                                                             0x000c
#define regUVD_JRBC1_UVD_JRBC_IB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC1_UVD_JRBC_IB_SIZE_UPDATE                                                            0x000d
#define regUVD_JRBC1_UVD_JRBC_IB_SIZE_UPDATE_BASE_IDX                                                   0
#define regUVD_JRBC1_UVD_JRBC_IB_COND_RD_TIMER                                                          0x000e
#define regUVD_JRBC1_UVD_JRBC_IB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC1_UVD_JRBC_IB_REF_DATA                                                               0x000f
#define regUVD_JRBC1_UVD_JRBC_IB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC1_UVD_JPEG_PREEMPT_CMD                                                               0x0010
#define regUVD_JRBC1_UVD_JPEG_PREEMPT_CMD_BASE_IDX                                                      0
#define regUVD_JRBC1_UVD_JPEG_PREEMPT_FENCE_DATA0                                                       0x0011
#define regUVD_JRBC1_UVD_JPEG_PREEMPT_FENCE_DATA0_BASE_IDX                                              0
#define regUVD_JRBC1_UVD_JPEG_PREEMPT_FENCE_DATA1                                                       0x0012
#define regUVD_JRBC1_UVD_JPEG_PREEMPT_FENCE_DATA1_BASE_IDX                                              0
#define regUVD_JRBC1_UVD_JRBC_RB_SIZE                                                                   0x0013
#define regUVD_JRBC1_UVD_JRBC_RB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC1_UVD_JRBC_SCRATCH0                                                                  0x0014
#define regUVD_JRBC1_UVD_JRBC_SCRATCH0_BASE_IDX                                                         0


// addressBlock: aid_uvd0_uvd_jrbc2_uvd_jrbc_dec
// base address: 0x1e100
#define regUVD_JRBC2_UVD_JRBC_RB_WPTR                                                                   0x0040
#define regUVD_JRBC2_UVD_JRBC_RB_WPTR_BASE_IDX                                                          0
#define regUVD_JRBC2_UVD_JRBC_RB_CNTL                                                                   0x0041
#define regUVD_JRBC2_UVD_JRBC_RB_CNTL_BASE_IDX                                                          0
#define regUVD_JRBC2_UVD_JRBC_IB_SIZE                                                                   0x0042
#define regUVD_JRBC2_UVD_JRBC_IB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC2_UVD_JRBC_URGENT_CNTL                                                               0x0043
#define regUVD_JRBC2_UVD_JRBC_URGENT_CNTL_BASE_IDX                                                      0
#define regUVD_JRBC2_UVD_JRBC_RB_REF_DATA                                                               0x0044
#define regUVD_JRBC2_UVD_JRBC_RB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC2_UVD_JRBC_RB_COND_RD_TIMER                                                          0x0045
#define regUVD_JRBC2_UVD_JRBC_RB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC2_UVD_JRBC_SOFT_RESET                                                                0x0048
#define regUVD_JRBC2_UVD_JRBC_SOFT_RESET_BASE_IDX                                                       0
#define regUVD_JRBC2_UVD_JRBC_STATUS                                                                    0x0049
#define regUVD_JRBC2_UVD_JRBC_STATUS_BASE_IDX                                                           0
#define regUVD_JRBC2_UVD_JRBC_RB_RPTR                                                                   0x004a
#define regUVD_JRBC2_UVD_JRBC_RB_RPTR_BASE_IDX                                                          0
#define regUVD_JRBC2_UVD_JRBC_RB_BUF_STATUS                                                             0x004b
#define regUVD_JRBC2_UVD_JRBC_RB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC2_UVD_JRBC_IB_BUF_STATUS                                                             0x004c
#define regUVD_JRBC2_UVD_JRBC_IB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC2_UVD_JRBC_IB_SIZE_UPDATE                                                            0x004d
#define regUVD_JRBC2_UVD_JRBC_IB_SIZE_UPDATE_BASE_IDX                                                   0
#define regUVD_JRBC2_UVD_JRBC_IB_COND_RD_TIMER                                                          0x004e
#define regUVD_JRBC2_UVD_JRBC_IB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC2_UVD_JRBC_IB_REF_DATA                                                               0x004f
#define regUVD_JRBC2_UVD_JRBC_IB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC2_UVD_JPEG_PREEMPT_CMD                                                               0x0050
#define regUVD_JRBC2_UVD_JPEG_PREEMPT_CMD_BASE_IDX                                                      0
#define regUVD_JRBC2_UVD_JPEG_PREEMPT_FENCE_DATA0                                                       0x0051
#define regUVD_JRBC2_UVD_JPEG_PREEMPT_FENCE_DATA0_BASE_IDX                                              0
#define regUVD_JRBC2_UVD_JPEG_PREEMPT_FENCE_DATA1                                                       0x0052
#define regUVD_JRBC2_UVD_JPEG_PREEMPT_FENCE_DATA1_BASE_IDX                                              0
#define regUVD_JRBC2_UVD_JRBC_RB_SIZE                                                                   0x0053
#define regUVD_JRBC2_UVD_JRBC_RB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC2_UVD_JRBC_SCRATCH0                                                                  0x0054
#define regUVD_JRBC2_UVD_JRBC_SCRATCH0_BASE_IDX                                                         0


// addressBlock: aid_uvd0_uvd_jrbc3_uvd_jrbc_dec
// base address: 0x1e200
#define regUVD_JRBC3_UVD_JRBC_RB_WPTR                                                                   0x0080
#define regUVD_JRBC3_UVD_JRBC_RB_WPTR_BASE_IDX                                                          0
#define regUVD_JRBC3_UVD_JRBC_RB_CNTL                                                                   0x0081
#define regUVD_JRBC3_UVD_JRBC_RB_CNTL_BASE_IDX                                                          0
#define regUVD_JRBC3_UVD_JRBC_IB_SIZE                                                                   0x0082
#define regUVD_JRBC3_UVD_JRBC_IB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC3_UVD_JRBC_URGENT_CNTL                                                               0x0083
#define regUVD_JRBC3_UVD_JRBC_URGENT_CNTL_BASE_IDX                                                      0
#define regUVD_JRBC3_UVD_JRBC_RB_REF_DATA                                                               0x0084
#define regUVD_JRBC3_UVD_JRBC_RB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC3_UVD_JRBC_RB_COND_RD_TIMER                                                          0x0085
#define regUVD_JRBC3_UVD_JRBC_RB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC3_UVD_JRBC_SOFT_RESET                                                                0x0088
#define regUVD_JRBC3_UVD_JRBC_SOFT_RESET_BASE_IDX                                                       0
#define regUVD_JRBC3_UVD_JRBC_STATUS                                                                    0x0089
#define regUVD_JRBC3_UVD_JRBC_STATUS_BASE_IDX                                                           0
#define regUVD_JRBC3_UVD_JRBC_RB_RPTR                                                                   0x008a
#define regUVD_JRBC3_UVD_JRBC_RB_RPTR_BASE_IDX                                                          0
#define regUVD_JRBC3_UVD_JRBC_RB_BUF_STATUS                                                             0x008b
#define regUVD_JRBC3_UVD_JRBC_RB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC3_UVD_JRBC_IB_BUF_STATUS                                                             0x008c
#define regUVD_JRBC3_UVD_JRBC_IB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC3_UVD_JRBC_IB_SIZE_UPDATE                                                            0x008d
#define regUVD_JRBC3_UVD_JRBC_IB_SIZE_UPDATE_BASE_IDX                                                   0
#define regUVD_JRBC3_UVD_JRBC_IB_COND_RD_TIMER                                                          0x008e
#define regUVD_JRBC3_UVD_JRBC_IB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC3_UVD_JRBC_IB_REF_DATA                                                               0x008f
#define regUVD_JRBC3_UVD_JRBC_IB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC3_UVD_JPEG_PREEMPT_CMD                                                               0x0090
#define regUVD_JRBC3_UVD_JPEG_PREEMPT_CMD_BASE_IDX                                                      0
#define regUVD_JRBC3_UVD_JPEG_PREEMPT_FENCE_DATA0                                                       0x0091
#define regUVD_JRBC3_UVD_JPEG_PREEMPT_FENCE_DATA0_BASE_IDX                                              0
#define regUVD_JRBC3_UVD_JPEG_PREEMPT_FENCE_DATA1                                                       0x0092
#define regUVD_JRBC3_UVD_JPEG_PREEMPT_FENCE_DATA1_BASE_IDX                                              0
#define regUVD_JRBC3_UVD_JRBC_RB_SIZE                                                                   0x0093
#define regUVD_JRBC3_UVD_JRBC_RB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC3_UVD_JRBC_SCRATCH0                                                                  0x0094
#define regUVD_JRBC3_UVD_JRBC_SCRATCH0_BASE_IDX                                                         0


// addressBlock: aid_uvd0_uvd_jrbc4_uvd_jrbc_dec
// base address: 0x1e300
#define regUVD_JRBC4_UVD_JRBC_RB_WPTR                                                                   0x00c0
#define regUVD_JRBC4_UVD_JRBC_RB_WPTR_BASE_IDX                                                          0
#define regUVD_JRBC4_UVD_JRBC_RB_CNTL                                                                   0x00c1
#define regUVD_JRBC4_UVD_JRBC_RB_CNTL_BASE_IDX                                                          0
#define regUVD_JRBC4_UVD_JRBC_IB_SIZE                                                                   0x00c2
#define regUVD_JRBC4_UVD_JRBC_IB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC4_UVD_JRBC_URGENT_CNTL                                                               0x00c3
#define regUVD_JRBC4_UVD_JRBC_URGENT_CNTL_BASE_IDX                                                      0
#define regUVD_JRBC4_UVD_JRBC_RB_REF_DATA                                                               0x00c4
#define regUVD_JRBC4_UVD_JRBC_RB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC4_UVD_JRBC_RB_COND_RD_TIMER                                                          0x00c5
#define regUVD_JRBC4_UVD_JRBC_RB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC4_UVD_JRBC_SOFT_RESET                                                                0x00c8
#define regUVD_JRBC4_UVD_JRBC_SOFT_RESET_BASE_IDX                                                       0
#define regUVD_JRBC4_UVD_JRBC_STATUS                                                                    0x00c9
#define regUVD_JRBC4_UVD_JRBC_STATUS_BASE_IDX                                                           0
#define regUVD_JRBC4_UVD_JRBC_RB_RPTR                                                                   0x00ca
#define regUVD_JRBC4_UVD_JRBC_RB_RPTR_BASE_IDX                                                          0
#define regUVD_JRBC4_UVD_JRBC_RB_BUF_STATUS                                                             0x00cb
#define regUVD_JRBC4_UVD_JRBC_RB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC4_UVD_JRBC_IB_BUF_STATUS                                                             0x00cc
#define regUVD_JRBC4_UVD_JRBC_IB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC4_UVD_JRBC_IB_SIZE_UPDATE                                                            0x00cd
#define regUVD_JRBC4_UVD_JRBC_IB_SIZE_UPDATE_BASE_IDX                                                   0
#define regUVD_JRBC4_UVD_JRBC_IB_COND_RD_TIMER                                                          0x00ce
#define regUVD_JRBC4_UVD_JRBC_IB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC4_UVD_JRBC_IB_REF_DATA                                                               0x00cf
#define regUVD_JRBC4_UVD_JRBC_IB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC4_UVD_JPEG_PREEMPT_CMD                                                               0x00d0
#define regUVD_JRBC4_UVD_JPEG_PREEMPT_CMD_BASE_IDX                                                      0
#define regUVD_JRBC4_UVD_JPEG_PREEMPT_FENCE_DATA0                                                       0x00d1
#define regUVD_JRBC4_UVD_JPEG_PREEMPT_FENCE_DATA0_BASE_IDX                                              0
#define regUVD_JRBC4_UVD_JPEG_PREEMPT_FENCE_DATA1                                                       0x00d2
#define regUVD_JRBC4_UVD_JPEG_PREEMPT_FENCE_DATA1_BASE_IDX                                              0
#define regUVD_JRBC4_UVD_JRBC_RB_SIZE                                                                   0x00d3
#define regUVD_JRBC4_UVD_JRBC_RB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC4_UVD_JRBC_SCRATCH0                                                                  0x00d4
#define regUVD_JRBC4_UVD_JRBC_SCRATCH0_BASE_IDX                                                         0


// addressBlock: aid_uvd0_uvd_jrbc5_uvd_jrbc_dec
// base address: 0x1e400
#define regUVD_JRBC5_UVD_JRBC_RB_WPTR                                                                   0x0100
#define regUVD_JRBC5_UVD_JRBC_RB_WPTR_BASE_IDX                                                          0
#define regUVD_JRBC5_UVD_JRBC_RB_CNTL                                                                   0x0101
#define regUVD_JRBC5_UVD_JRBC_RB_CNTL_BASE_IDX                                                          0
#define regUVD_JRBC5_UVD_JRBC_IB_SIZE                                                                   0x0102
#define regUVD_JRBC5_UVD_JRBC_IB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC5_UVD_JRBC_URGENT_CNTL                                                               0x0103
#define regUVD_JRBC5_UVD_JRBC_URGENT_CNTL_BASE_IDX                                                      0
#define regUVD_JRBC5_UVD_JRBC_RB_REF_DATA                                                               0x0104
#define regUVD_JRBC5_UVD_JRBC_RB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC5_UVD_JRBC_RB_COND_RD_TIMER                                                          0x0105
#define regUVD_JRBC5_UVD_JRBC_RB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC5_UVD_JRBC_SOFT_RESET                                                                0x0108
#define regUVD_JRBC5_UVD_JRBC_SOFT_RESET_BASE_IDX                                                       0
#define regUVD_JRBC5_UVD_JRBC_STATUS                                                                    0x0109
#define regUVD_JRBC5_UVD_JRBC_STATUS_BASE_IDX                                                           0
#define regUVD_JRBC5_UVD_JRBC_RB_RPTR                                                                   0x010a
#define regUVD_JRBC5_UVD_JRBC_RB_RPTR_BASE_IDX                                                          0
#define regUVD_JRBC5_UVD_JRBC_RB_BUF_STATUS                                                             0x010b
#define regUVD_JRBC5_UVD_JRBC_RB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC5_UVD_JRBC_IB_BUF_STATUS                                                             0x010c
#define regUVD_JRBC5_UVD_JRBC_IB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC5_UVD_JRBC_IB_SIZE_UPDATE                                                            0x010d
#define regUVD_JRBC5_UVD_JRBC_IB_SIZE_UPDATE_BASE_IDX                                                   0
#define regUVD_JRBC5_UVD_JRBC_IB_COND_RD_TIMER                                                          0x010e
#define regUVD_JRBC5_UVD_JRBC_IB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC5_UVD_JRBC_IB_REF_DATA                                                               0x010f
#define regUVD_JRBC5_UVD_JRBC_IB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC5_UVD_JPEG_PREEMPT_CMD                                                               0x0110
#define regUVD_JRBC5_UVD_JPEG_PREEMPT_CMD_BASE_IDX                                                      0
#define regUVD_JRBC5_UVD_JPEG_PREEMPT_FENCE_DATA0                                                       0x0111
#define regUVD_JRBC5_UVD_JPEG_PREEMPT_FENCE_DATA0_BASE_IDX                                              0
#define regUVD_JRBC5_UVD_JPEG_PREEMPT_FENCE_DATA1                                                       0x0112
#define regUVD_JRBC5_UVD_JPEG_PREEMPT_FENCE_DATA1_BASE_IDX                                              0
#define regUVD_JRBC5_UVD_JRBC_RB_SIZE                                                                   0x0113
#define regUVD_JRBC5_UVD_JRBC_RB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC5_UVD_JRBC_SCRATCH0                                                                  0x0114
#define regUVD_JRBC5_UVD_JRBC_SCRATCH0_BASE_IDX                                                         0


// addressBlock: aid_uvd0_uvd_jrbc6_uvd_jrbc_dec
// base address: 0x1e500
#define regUVD_JRBC6_UVD_JRBC_RB_WPTR                                                                   0x0140
#define regUVD_JRBC6_UVD_JRBC_RB_WPTR_BASE_IDX                                                          0
#define regUVD_JRBC6_UVD_JRBC_RB_CNTL                                                                   0x0141
#define regUVD_JRBC6_UVD_JRBC_RB_CNTL_BASE_IDX                                                          0
#define regUVD_JRBC6_UVD_JRBC_IB_SIZE                                                                   0x0142
#define regUVD_JRBC6_UVD_JRBC_IB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC6_UVD_JRBC_URGENT_CNTL                                                               0x0143
#define regUVD_JRBC6_UVD_JRBC_URGENT_CNTL_BASE_IDX                                                      0
#define regUVD_JRBC6_UVD_JRBC_RB_REF_DATA                                                               0x0144
#define regUVD_JRBC6_UVD_JRBC_RB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC6_UVD_JRBC_RB_COND_RD_TIMER                                                          0x0145
#define regUVD_JRBC6_UVD_JRBC_RB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC6_UVD_JRBC_SOFT_RESET                                                                0x0148
#define regUVD_JRBC6_UVD_JRBC_SOFT_RESET_BASE_IDX                                                       0
#define regUVD_JRBC6_UVD_JRBC_STATUS                                                                    0x0149
#define regUVD_JRBC6_UVD_JRBC_STATUS_BASE_IDX                                                           0
#define regUVD_JRBC6_UVD_JRBC_RB_RPTR                                                                   0x014a
#define regUVD_JRBC6_UVD_JRBC_RB_RPTR_BASE_IDX                                                          0
#define regUVD_JRBC6_UVD_JRBC_RB_BUF_STATUS                                                             0x014b
#define regUVD_JRBC6_UVD_JRBC_RB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC6_UVD_JRBC_IB_BUF_STATUS                                                             0x014c
#define regUVD_JRBC6_UVD_JRBC_IB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC6_UVD_JRBC_IB_SIZE_UPDATE                                                            0x014d
#define regUVD_JRBC6_UVD_JRBC_IB_SIZE_UPDATE_BASE_IDX                                                   0
#define regUVD_JRBC6_UVD_JRBC_IB_COND_RD_TIMER                                                          0x014e
#define regUVD_JRBC6_UVD_JRBC_IB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC6_UVD_JRBC_IB_REF_DATA                                                               0x014f
#define regUVD_JRBC6_UVD_JRBC_IB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC6_UVD_JPEG_PREEMPT_CMD                                                               0x0150
#define regUVD_JRBC6_UVD_JPEG_PREEMPT_CMD_BASE_IDX                                                      0
#define regUVD_JRBC6_UVD_JPEG_PREEMPT_FENCE_DATA0                                                       0x0151
#define regUVD_JRBC6_UVD_JPEG_PREEMPT_FENCE_DATA0_BASE_IDX                                              0
#define regUVD_JRBC6_UVD_JPEG_PREEMPT_FENCE_DATA1                                                       0x0152
#define regUVD_JRBC6_UVD_JPEG_PREEMPT_FENCE_DATA1_BASE_IDX                                              0
#define regUVD_JRBC6_UVD_JRBC_RB_SIZE                                                                   0x0153
#define regUVD_JRBC6_UVD_JRBC_RB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC6_UVD_JRBC_SCRATCH0                                                                  0x0154
#define regUVD_JRBC6_UVD_JRBC_SCRATCH0_BASE_IDX                                                         0


// addressBlock: aid_uvd0_uvd_jrbc7_uvd_jrbc_dec
// base address: 0x1e600
#define regUVD_JRBC7_UVD_JRBC_RB_WPTR                                                                   0x0180
#define regUVD_JRBC7_UVD_JRBC_RB_WPTR_BASE_IDX                                                          0
#define regUVD_JRBC7_UVD_JRBC_RB_CNTL                                                                   0x0181
#define regUVD_JRBC7_UVD_JRBC_RB_CNTL_BASE_IDX                                                          0
#define regUVD_JRBC7_UVD_JRBC_IB_SIZE                                                                   0x0182
#define regUVD_JRBC7_UVD_JRBC_IB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC7_UVD_JRBC_URGENT_CNTL                                                               0x0183
#define regUVD_JRBC7_UVD_JRBC_URGENT_CNTL_BASE_IDX                                                      0
#define regUVD_JRBC7_UVD_JRBC_RB_REF_DATA                                                               0x0184
#define regUVD_JRBC7_UVD_JRBC_RB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC7_UVD_JRBC_RB_COND_RD_TIMER                                                          0x0185
#define regUVD_JRBC7_UVD_JRBC_RB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC7_UVD_JRBC_SOFT_RESET                                                                0x0188
#define regUVD_JRBC7_UVD_JRBC_SOFT_RESET_BASE_IDX                                                       0
#define regUVD_JRBC7_UVD_JRBC_STATUS                                                                    0x0189
#define regUVD_JRBC7_UVD_JRBC_STATUS_BASE_IDX                                                           0
#define regUVD_JRBC7_UVD_JRBC_RB_RPTR                                                                   0x018a
#define regUVD_JRBC7_UVD_JRBC_RB_RPTR_BASE_IDX                                                          0
#define regUVD_JRBC7_UVD_JRBC_RB_BUF_STATUS                                                             0x018b
#define regUVD_JRBC7_UVD_JRBC_RB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC7_UVD_JRBC_IB_BUF_STATUS                                                             0x018c
#define regUVD_JRBC7_UVD_JRBC_IB_BUF_STATUS_BASE_IDX                                                    0
#define regUVD_JRBC7_UVD_JRBC_IB_SIZE_UPDATE                                                            0x018d
#define regUVD_JRBC7_UVD_JRBC_IB_SIZE_UPDATE_BASE_IDX                                                   0
#define regUVD_JRBC7_UVD_JRBC_IB_COND_RD_TIMER                                                          0x018e
#define regUVD_JRBC7_UVD_JRBC_IB_COND_RD_TIMER_BASE_IDX                                                 0
#define regUVD_JRBC7_UVD_JRBC_IB_REF_DATA                                                               0x018f
#define regUVD_JRBC7_UVD_JRBC_IB_REF_DATA_BASE_IDX                                                      0
#define regUVD_JRBC7_UVD_JPEG_PREEMPT_CMD                                                               0x0190
#define regUVD_JRBC7_UVD_JPEG_PREEMPT_CMD_BASE_IDX                                                      0
#define regUVD_JRBC7_UVD_JPEG_PREEMPT_FENCE_DATA0                                                       0x0191
#define regUVD_JRBC7_UVD_JPEG_PREEMPT_FENCE_DATA0_BASE_IDX                                              0
#define regUVD_JRBC7_UVD_JPEG_PREEMPT_FENCE_DATA1                                                       0x0192
#define regUVD_JRBC7_UVD_JPEG_PREEMPT_FENCE_DATA1_BASE_IDX                                              0
#define regUVD_JRBC7_UVD_JRBC_RB_SIZE                                                                   0x0193
#define regUVD_JRBC7_UVD_JRBC_RB_SIZE_BASE_IDX                                                          0
#define regUVD_JRBC7_UVD_JRBC_SCRATCH0                                                                  0x0194
#define regUVD_JRBC7_UVD_JRBC_SCRATCH0_BASE_IDX                                                         0


// addressBlock: aid_uvd0_uvd_jmi1_uvd_jmi_dec
// base address: 0x1e080
#define regUVD_JMI1_UVD_JPEG_DEC_PF_CTRL                                                                0x0020
#define regUVD_JMI1_UVD_JPEG_DEC_PF_CTRL_BASE_IDX                                                       0
#define regUVD_JMI1_UVD_LMI_JRBC_CTRL                                                                   0x0021
#define regUVD_JMI1_UVD_LMI_JRBC_CTRL_BASE_IDX                                                          0
#define regUVD_JMI1_UVD_LMI_JPEG_CTRL                                                                   0x0022
#define regUVD_JMI1_UVD_LMI_JPEG_CTRL_BASE_IDX                                                          0
#define regUVD_JMI1_JPEG_LMI_DROP                                                                       0x0023
#define regUVD_JMI1_JPEG_LMI_DROP_BASE_IDX                                                              0
#define regUVD_JMI1_UVD_LMI_JRBC_IB_VMID                                                                0x0024
#define regUVD_JMI1_UVD_LMI_JRBC_IB_VMID_BASE_IDX                                                       0
#define regUVD_JMI1_UVD_LMI_JRBC_RB_VMID                                                                0x0025
#define regUVD_JMI1_UVD_LMI_JRBC_RB_VMID_BASE_IDX                                                       0
#define regUVD_JMI1_UVD_LMI_JPEG_VMID                                                                   0x0026
#define regUVD_JMI1_UVD_LMI_JPEG_VMID_BASE_IDX                                                          0
#define regUVD_JMI1_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                            0x0027
#define regUVD_JMI1_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI1_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                           0x0028
#define regUVD_JMI1_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI1_UVD_LMI_JRBC_RB_64BIT_BAR_LOW                                                       0x0029
#define regUVD_JMI1_UVD_LMI_JRBC_RB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI1_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH                                                      0x002a
#define regUVD_JMI1_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI1_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW                                                0x002b
#define regUVD_JMI1_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI1_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH                                               0x002c
#define regUVD_JMI1_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI1_UVD_LMI_JPEG_PREEMPT_VMID                                                           0x002d
#define regUVD_JMI1_UVD_LMI_JPEG_PREEMPT_VMID_BASE_IDX                                                  0
#define regUVD_JMI1_UVD_JMI_DEC_SWAP_CNTL                                                               0x002e
#define regUVD_JMI1_UVD_JMI_DEC_SWAP_CNTL_BASE_IDX                                                      0
#define regUVD_JMI1_UVD_JMI_ATOMIC_CNTL                                                                 0x002f
#define regUVD_JMI1_UVD_JMI_ATOMIC_CNTL_BASE_IDX                                                        0
#define regUVD_JMI1_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW                                            0x0030
#define regUVD_JMI1_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI1_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH                                           0x0031
#define regUVD_JMI1_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI1_UVD_LMI_JPEG_READ_64BIT_BAR_LOW                                                     0x0032
#define regUVD_JMI1_UVD_LMI_JPEG_READ_64BIT_BAR_LOW_BASE_IDX                                            0
#define regUVD_JMI1_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH                                                    0x0033
#define regUVD_JMI1_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH_BASE_IDX                                           0
#define regUVD_JMI1_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW                                                    0x0034
#define regUVD_JMI1_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW_BASE_IDX                                           0
#define regUVD_JMI1_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH                                                   0x0035
#define regUVD_JMI1_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH_BASE_IDX                                          0
#define regUVD_JMI1_UVD_LMI_JRBC_IB_64BIT_BAR_LOW                                                       0x0036
#define regUVD_JMI1_UVD_LMI_JRBC_IB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI1_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH                                                      0x0037
#define regUVD_JMI1_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI1_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW                                                0x0038
#define regUVD_JMI1_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI1_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH                                               0x0039
#define regUVD_JMI1_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI1_UVD_JMI_ATOMIC_CNTL2                                                                0x003d
#define regUVD_JMI1_UVD_JMI_ATOMIC_CNTL2_BASE_IDX                                                       0


// addressBlock: aid_uvd0_uvd_jmi2_uvd_jmi_dec
// base address: 0x1e180
#define regUVD_JMI2_UVD_JPEG_DEC_PF_CTRL                                                                0x0060
#define regUVD_JMI2_UVD_JPEG_DEC_PF_CTRL_BASE_IDX                                                       0
#define regUVD_JMI2_UVD_LMI_JRBC_CTRL                                                                   0x0061
#define regUVD_JMI2_UVD_LMI_JRBC_CTRL_BASE_IDX                                                          0
#define regUVD_JMI2_UVD_LMI_JPEG_CTRL                                                                   0x0062
#define regUVD_JMI2_UVD_LMI_JPEG_CTRL_BASE_IDX                                                          0
#define regUVD_JMI2_JPEG_LMI_DROP                                                                       0x0063
#define regUVD_JMI2_JPEG_LMI_DROP_BASE_IDX                                                              0
#define regUVD_JMI2_UVD_LMI_JRBC_IB_VMID                                                                0x0064
#define regUVD_JMI2_UVD_LMI_JRBC_IB_VMID_BASE_IDX                                                       0
#define regUVD_JMI2_UVD_LMI_JRBC_RB_VMID                                                                0x0065
#define regUVD_JMI2_UVD_LMI_JRBC_RB_VMID_BASE_IDX                                                       0
#define regUVD_JMI2_UVD_LMI_JPEG_VMID                                                                   0x0066
#define regUVD_JMI2_UVD_LMI_JPEG_VMID_BASE_IDX                                                          0
#define regUVD_JMI2_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                            0x0067
#define regUVD_JMI2_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI2_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                           0x0068
#define regUVD_JMI2_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI2_UVD_LMI_JRBC_RB_64BIT_BAR_LOW                                                       0x0069
#define regUVD_JMI2_UVD_LMI_JRBC_RB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI2_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH                                                      0x006a
#define regUVD_JMI2_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI2_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW                                                0x006b
#define regUVD_JMI2_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI2_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH                                               0x006c
#define regUVD_JMI2_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI2_UVD_LMI_JPEG_PREEMPT_VMID                                                           0x006d
#define regUVD_JMI2_UVD_LMI_JPEG_PREEMPT_VMID_BASE_IDX                                                  0
#define regUVD_JMI2_UVD_JMI_DEC_SWAP_CNTL                                                               0x006e
#define regUVD_JMI2_UVD_JMI_DEC_SWAP_CNTL_BASE_IDX                                                      0
#define regUVD_JMI2_UVD_JMI_ATOMIC_CNTL                                                                 0x006f
#define regUVD_JMI2_UVD_JMI_ATOMIC_CNTL_BASE_IDX                                                        0
#define regUVD_JMI2_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW                                            0x0070
#define regUVD_JMI2_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI2_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH                                           0x0071
#define regUVD_JMI2_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI2_UVD_LMI_JPEG_READ_64BIT_BAR_LOW                                                     0x0072
#define regUVD_JMI2_UVD_LMI_JPEG_READ_64BIT_BAR_LOW_BASE_IDX                                            0
#define regUVD_JMI2_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH                                                    0x0073
#define regUVD_JMI2_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH_BASE_IDX                                           0
#define regUVD_JMI2_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW                                                    0x0074
#define regUVD_JMI2_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW_BASE_IDX                                           0
#define regUVD_JMI2_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH                                                   0x0075
#define regUVD_JMI2_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH_BASE_IDX                                          0
#define regUVD_JMI2_UVD_LMI_JRBC_IB_64BIT_BAR_LOW                                                       0x0076
#define regUVD_JMI2_UVD_LMI_JRBC_IB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI2_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH                                                      0x0077
#define regUVD_JMI2_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI2_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW                                                0x0078
#define regUVD_JMI2_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI2_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH                                               0x0079
#define regUVD_JMI2_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI2_UVD_JMI_ATOMIC_CNTL2                                                                0x007d
#define regUVD_JMI2_UVD_JMI_ATOMIC_CNTL2_BASE_IDX                                                       0


// addressBlock: aid_uvd0_uvd_jmi3_uvd_jmi_dec
// base address: 0x1e280
#define regUVD_JMI3_UVD_JPEG_DEC_PF_CTRL                                                                0x00a0
#define regUVD_JMI3_UVD_JPEG_DEC_PF_CTRL_BASE_IDX                                                       0
#define regUVD_JMI3_UVD_LMI_JRBC_CTRL                                                                   0x00a1
#define regUVD_JMI3_UVD_LMI_JRBC_CTRL_BASE_IDX                                                          0
#define regUVD_JMI3_UVD_LMI_JPEG_CTRL                                                                   0x00a2
#define regUVD_JMI3_UVD_LMI_JPEG_CTRL_BASE_IDX                                                          0
#define regUVD_JMI3_JPEG_LMI_DROP                                                                       0x00a3
#define regUVD_JMI3_JPEG_LMI_DROP_BASE_IDX                                                              0
#define regUVD_JMI3_UVD_LMI_JRBC_IB_VMID                                                                0x00a4
#define regUVD_JMI3_UVD_LMI_JRBC_IB_VMID_BASE_IDX                                                       0
#define regUVD_JMI3_UVD_LMI_JRBC_RB_VMID                                                                0x00a5
#define regUVD_JMI3_UVD_LMI_JRBC_RB_VMID_BASE_IDX                                                       0
#define regUVD_JMI3_UVD_LMI_JPEG_VMID                                                                   0x00a6
#define regUVD_JMI3_UVD_LMI_JPEG_VMID_BASE_IDX                                                          0
#define regUVD_JMI3_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                            0x00a7
#define regUVD_JMI3_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI3_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                           0x00a8
#define regUVD_JMI3_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI3_UVD_LMI_JRBC_RB_64BIT_BAR_LOW                                                       0x00a9
#define regUVD_JMI3_UVD_LMI_JRBC_RB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI3_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH                                                      0x00aa
#define regUVD_JMI3_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI3_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW                                                0x00ab
#define regUVD_JMI3_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI3_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH                                               0x00ac
#define regUVD_JMI3_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI3_UVD_LMI_JPEG_PREEMPT_VMID                                                           0x00ad
#define regUVD_JMI3_UVD_LMI_JPEG_PREEMPT_VMID_BASE_IDX                                                  0
#define regUVD_JMI3_UVD_JMI_DEC_SWAP_CNTL                                                               0x00ae
#define regUVD_JMI3_UVD_JMI_DEC_SWAP_CNTL_BASE_IDX                                                      0
#define regUVD_JMI3_UVD_JMI_ATOMIC_CNTL                                                                 0x00af
#define regUVD_JMI3_UVD_JMI_ATOMIC_CNTL_BASE_IDX                                                        0
#define regUVD_JMI3_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW                                            0x00b0
#define regUVD_JMI3_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI3_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH                                           0x00b1
#define regUVD_JMI3_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI3_UVD_LMI_JPEG_READ_64BIT_BAR_LOW                                                     0x00b2
#define regUVD_JMI3_UVD_LMI_JPEG_READ_64BIT_BAR_LOW_BASE_IDX                                            0
#define regUVD_JMI3_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH                                                    0x00b3
#define regUVD_JMI3_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH_BASE_IDX                                           0
#define regUVD_JMI3_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW                                                    0x00b4
#define regUVD_JMI3_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW_BASE_IDX                                           0
#define regUVD_JMI3_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH                                                   0x00b5
#define regUVD_JMI3_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH_BASE_IDX                                          0
#define regUVD_JMI3_UVD_LMI_JRBC_IB_64BIT_BAR_LOW                                                       0x00b6
#define regUVD_JMI3_UVD_LMI_JRBC_IB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI3_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH                                                      0x00b7
#define regUVD_JMI3_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI3_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW                                                0x00b8
#define regUVD_JMI3_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI3_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH                                               0x00b9
#define regUVD_JMI3_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI3_UVD_JMI_ATOMIC_CNTL2                                                                0x00bd
#define regUVD_JMI3_UVD_JMI_ATOMIC_CNTL2_BASE_IDX                                                       0


// addressBlock: aid_uvd0_uvd_jmi4_uvd_jmi_dec
// base address: 0x1e380
#define regUVD_JMI4_UVD_JPEG_DEC_PF_CTRL                                                                0x00e0
#define regUVD_JMI4_UVD_JPEG_DEC_PF_CTRL_BASE_IDX                                                       0
#define regUVD_JMI4_UVD_LMI_JRBC_CTRL                                                                   0x00e1
#define regUVD_JMI4_UVD_LMI_JRBC_CTRL_BASE_IDX                                                          0
#define regUVD_JMI4_UVD_LMI_JPEG_CTRL                                                                   0x00e2
#define regUVD_JMI4_UVD_LMI_JPEG_CTRL_BASE_IDX                                                          0
#define regUVD_JMI4_JPEG_LMI_DROP                                                                       0x00e3
#define regUVD_JMI4_JPEG_LMI_DROP_BASE_IDX                                                              0
#define regUVD_JMI4_UVD_LMI_JRBC_IB_VMID                                                                0x00e4
#define regUVD_JMI4_UVD_LMI_JRBC_IB_VMID_BASE_IDX                                                       0
#define regUVD_JMI4_UVD_LMI_JRBC_RB_VMID                                                                0x00e5
#define regUVD_JMI4_UVD_LMI_JRBC_RB_VMID_BASE_IDX                                                       0
#define regUVD_JMI4_UVD_LMI_JPEG_VMID                                                                   0x00e6
#define regUVD_JMI4_UVD_LMI_JPEG_VMID_BASE_IDX                                                          0
#define regUVD_JMI4_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                            0x00e7
#define regUVD_JMI4_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI4_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                           0x00e8
#define regUVD_JMI4_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI4_UVD_LMI_JRBC_RB_64BIT_BAR_LOW                                                       0x00e9
#define regUVD_JMI4_UVD_LMI_JRBC_RB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI4_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH                                                      0x00ea
#define regUVD_JMI4_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI4_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW                                                0x00eb
#define regUVD_JMI4_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI4_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH                                               0x00ec
#define regUVD_JMI4_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI4_UVD_LMI_JPEG_PREEMPT_VMID                                                           0x00ed
#define regUVD_JMI4_UVD_LMI_JPEG_PREEMPT_VMID_BASE_IDX                                                  0
#define regUVD_JMI4_UVD_JMI_DEC_SWAP_CNTL                                                               0x00ee
#define regUVD_JMI4_UVD_JMI_DEC_SWAP_CNTL_BASE_IDX                                                      0
#define regUVD_JMI4_UVD_JMI_ATOMIC_CNTL                                                                 0x00ef
#define regUVD_JMI4_UVD_JMI_ATOMIC_CNTL_BASE_IDX                                                        0
#define regUVD_JMI4_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW                                            0x00f0
#define regUVD_JMI4_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI4_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH                                           0x00f1
#define regUVD_JMI4_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI4_UVD_LMI_JPEG_READ_64BIT_BAR_LOW                                                     0x00f2
#define regUVD_JMI4_UVD_LMI_JPEG_READ_64BIT_BAR_LOW_BASE_IDX                                            0
#define regUVD_JMI4_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH                                                    0x00f3
#define regUVD_JMI4_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH_BASE_IDX                                           0
#define regUVD_JMI4_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW                                                    0x00f4
#define regUVD_JMI4_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW_BASE_IDX                                           0
#define regUVD_JMI4_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH                                                   0x00f5
#define regUVD_JMI4_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH_BASE_IDX                                          0
#define regUVD_JMI4_UVD_LMI_JRBC_IB_64BIT_BAR_LOW                                                       0x00f6
#define regUVD_JMI4_UVD_LMI_JRBC_IB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI4_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH                                                      0x00f7
#define regUVD_JMI4_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI4_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW                                                0x00f8
#define regUVD_JMI4_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI4_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH                                               0x00f9
#define regUVD_JMI4_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI4_UVD_JMI_ATOMIC_CNTL2                                                                0x00fd
#define regUVD_JMI4_UVD_JMI_ATOMIC_CNTL2_BASE_IDX                                                       0


// addressBlock: aid_uvd0_uvd_jmi5_uvd_jmi_dec
// base address: 0x1e480
#define regUVD_JMI5_UVD_JPEG_DEC_PF_CTRL                                                                0x0120
#define regUVD_JMI5_UVD_JPEG_DEC_PF_CTRL_BASE_IDX                                                       0
#define regUVD_JMI5_UVD_LMI_JRBC_CTRL                                                                   0x0121
#define regUVD_JMI5_UVD_LMI_JRBC_CTRL_BASE_IDX                                                          0
#define regUVD_JMI5_UVD_LMI_JPEG_CTRL                                                                   0x0122
#define regUVD_JMI5_UVD_LMI_JPEG_CTRL_BASE_IDX                                                          0
#define regUVD_JMI5_JPEG_LMI_DROP                                                                       0x0123
#define regUVD_JMI5_JPEG_LMI_DROP_BASE_IDX                                                              0
#define regUVD_JMI5_UVD_LMI_JRBC_IB_VMID                                                                0x0124
#define regUVD_JMI5_UVD_LMI_JRBC_IB_VMID_BASE_IDX                                                       0
#define regUVD_JMI5_UVD_LMI_JRBC_RB_VMID                                                                0x0125
#define regUVD_JMI5_UVD_LMI_JRBC_RB_VMID_BASE_IDX                                                       0
#define regUVD_JMI5_UVD_LMI_JPEG_VMID                                                                   0x0126
#define regUVD_JMI5_UVD_LMI_JPEG_VMID_BASE_IDX                                                          0
#define regUVD_JMI5_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                            0x0127
#define regUVD_JMI5_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI5_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                           0x0128
#define regUVD_JMI5_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI5_UVD_LMI_JRBC_RB_64BIT_BAR_LOW                                                       0x0129
#define regUVD_JMI5_UVD_LMI_JRBC_RB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI5_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH                                                      0x012a
#define regUVD_JMI5_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI5_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW                                                0x012b
#define regUVD_JMI5_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI5_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH                                               0x012c
#define regUVD_JMI5_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI5_UVD_LMI_JPEG_PREEMPT_VMID                                                           0x012d
#define regUVD_JMI5_UVD_LMI_JPEG_PREEMPT_VMID_BASE_IDX                                                  0
#define regUVD_JMI5_UVD_JMI_DEC_SWAP_CNTL                                                               0x012e
#define regUVD_JMI5_UVD_JMI_DEC_SWAP_CNTL_BASE_IDX                                                      0
#define regUVD_JMI5_UVD_JMI_ATOMIC_CNTL                                                                 0x012f
#define regUVD_JMI5_UVD_JMI_ATOMIC_CNTL_BASE_IDX                                                        0
#define regUVD_JMI5_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW                                            0x0130
#define regUVD_JMI5_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI5_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH                                           0x0131
#define regUVD_JMI5_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI5_UVD_LMI_JPEG_READ_64BIT_BAR_LOW                                                     0x0132
#define regUVD_JMI5_UVD_LMI_JPEG_READ_64BIT_BAR_LOW_BASE_IDX                                            0
#define regUVD_JMI5_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH                                                    0x0133
#define regUVD_JMI5_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH_BASE_IDX                                           0
#define regUVD_JMI5_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW                                                    0x0134
#define regUVD_JMI5_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW_BASE_IDX                                           0
#define regUVD_JMI5_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH                                                   0x0135
#define regUVD_JMI5_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH_BASE_IDX                                          0
#define regUVD_JMI5_UVD_LMI_JRBC_IB_64BIT_BAR_LOW                                                       0x0136
#define regUVD_JMI5_UVD_LMI_JRBC_IB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI5_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH                                                      0x0137
#define regUVD_JMI5_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI5_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW                                                0x0138
#define regUVD_JMI5_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI5_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH                                               0x0139
#define regUVD_JMI5_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI5_UVD_JMI_ATOMIC_CNTL2                                                                0x013d
#define regUVD_JMI5_UVD_JMI_ATOMIC_CNTL2_BASE_IDX                                                       0


// addressBlock: aid_uvd0_uvd_jmi6_uvd_jmi_dec
// base address: 0x1e580
#define regUVD_JMI6_UVD_JPEG_DEC_PF_CTRL                                                                0x0160
#define regUVD_JMI6_UVD_JPEG_DEC_PF_CTRL_BASE_IDX                                                       0
#define regUVD_JMI6_UVD_LMI_JRBC_CTRL                                                                   0x0161
#define regUVD_JMI6_UVD_LMI_JRBC_CTRL_BASE_IDX                                                          0
#define regUVD_JMI6_UVD_LMI_JPEG_CTRL                                                                   0x0162
#define regUVD_JMI6_UVD_LMI_JPEG_CTRL_BASE_IDX                                                          0
#define regUVD_JMI6_JPEG_LMI_DROP                                                                       0x0163
#define regUVD_JMI6_JPEG_LMI_DROP_BASE_IDX                                                              0
#define regUVD_JMI6_UVD_LMI_JRBC_IB_VMID                                                                0x0164
#define regUVD_JMI6_UVD_LMI_JRBC_IB_VMID_BASE_IDX                                                       0
#define regUVD_JMI6_UVD_LMI_JRBC_RB_VMID                                                                0x0165
#define regUVD_JMI6_UVD_LMI_JRBC_RB_VMID_BASE_IDX                                                       0
#define regUVD_JMI6_UVD_LMI_JPEG_VMID                                                                   0x0166
#define regUVD_JMI6_UVD_LMI_JPEG_VMID_BASE_IDX                                                          0
#define regUVD_JMI6_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                            0x0167
#define regUVD_JMI6_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI6_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                           0x0168
#define regUVD_JMI6_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI6_UVD_LMI_JRBC_RB_64BIT_BAR_LOW                                                       0x0169
#define regUVD_JMI6_UVD_LMI_JRBC_RB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI6_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH                                                      0x016a
#define regUVD_JMI6_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI6_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW                                                0x016b
#define regUVD_JMI6_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI6_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH                                               0x016c
#define regUVD_JMI6_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI6_UVD_LMI_JPEG_PREEMPT_VMID                                                           0x016d
#define regUVD_JMI6_UVD_LMI_JPEG_PREEMPT_VMID_BASE_IDX                                                  0
#define regUVD_JMI6_UVD_JMI_DEC_SWAP_CNTL                                                               0x016e
#define regUVD_JMI6_UVD_JMI_DEC_SWAP_CNTL_BASE_IDX                                                      0
#define regUVD_JMI6_UVD_JMI_ATOMIC_CNTL                                                                 0x016f
#define regUVD_JMI6_UVD_JMI_ATOMIC_CNTL_BASE_IDX                                                        0
#define regUVD_JMI6_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW                                            0x0170
#define regUVD_JMI6_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI6_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH                                           0x0171
#define regUVD_JMI6_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI6_UVD_LMI_JPEG_READ_64BIT_BAR_LOW                                                     0x0172
#define regUVD_JMI6_UVD_LMI_JPEG_READ_64BIT_BAR_LOW_BASE_IDX                                            0
#define regUVD_JMI6_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH                                                    0x0173
#define regUVD_JMI6_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH_BASE_IDX                                           0
#define regUVD_JMI6_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW                                                    0x0174
#define regUVD_JMI6_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW_BASE_IDX                                           0
#define regUVD_JMI6_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH                                                   0x0175
#define regUVD_JMI6_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH_BASE_IDX                                          0
#define regUVD_JMI6_UVD_LMI_JRBC_IB_64BIT_BAR_LOW                                                       0x0176
#define regUVD_JMI6_UVD_LMI_JRBC_IB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI6_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH                                                      0x0177
#define regUVD_JMI6_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI6_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW                                                0x0178
#define regUVD_JMI6_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI6_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH                                               0x0179
#define regUVD_JMI6_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI6_UVD_JMI_ATOMIC_CNTL2                                                                0x017d
#define regUVD_JMI6_UVD_JMI_ATOMIC_CNTL2_BASE_IDX                                                       0


// addressBlock: aid_uvd0_uvd_jmi7_uvd_jmi_dec
// base address: 0x1e680
#define regUVD_JMI7_UVD_JPEG_DEC_PF_CTRL                                                                0x01a0
#define regUVD_JMI7_UVD_JPEG_DEC_PF_CTRL_BASE_IDX                                                       0
#define regUVD_JMI7_UVD_LMI_JRBC_CTRL                                                                   0x01a1
#define regUVD_JMI7_UVD_LMI_JRBC_CTRL_BASE_IDX                                                          0
#define regUVD_JMI7_UVD_LMI_JPEG_CTRL                                                                   0x01a2
#define regUVD_JMI7_UVD_LMI_JPEG_CTRL_BASE_IDX                                                          0
#define regUVD_JMI7_JPEG_LMI_DROP                                                                       0x01a3
#define regUVD_JMI7_JPEG_LMI_DROP_BASE_IDX                                                              0
#define regUVD_JMI7_UVD_LMI_JRBC_IB_VMID                                                                0x01a4
#define regUVD_JMI7_UVD_LMI_JRBC_IB_VMID_BASE_IDX                                                       0
#define regUVD_JMI7_UVD_LMI_JRBC_RB_VMID                                                                0x01a5
#define regUVD_JMI7_UVD_LMI_JRBC_RB_VMID_BASE_IDX                                                       0
#define regUVD_JMI7_UVD_LMI_JPEG_VMID                                                                   0x01a6
#define regUVD_JMI7_UVD_LMI_JPEG_VMID_BASE_IDX                                                          0
#define regUVD_JMI7_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                            0x01a7
#define regUVD_JMI7_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI7_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                           0x01a8
#define regUVD_JMI7_UVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI7_UVD_LMI_JRBC_RB_64BIT_BAR_LOW                                                       0x01a9
#define regUVD_JMI7_UVD_LMI_JRBC_RB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI7_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH                                                      0x01aa
#define regUVD_JMI7_UVD_LMI_JRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI7_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW                                                0x01ab
#define regUVD_JMI7_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI7_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH                                               0x01ac
#define regUVD_JMI7_UVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI7_UVD_LMI_JPEG_PREEMPT_VMID                                                           0x01ad
#define regUVD_JMI7_UVD_LMI_JPEG_PREEMPT_VMID_BASE_IDX                                                  0
#define regUVD_JMI7_UVD_JMI_DEC_SWAP_CNTL                                                               0x01ae
#define regUVD_JMI7_UVD_JMI_DEC_SWAP_CNTL_BASE_IDX                                                      0
#define regUVD_JMI7_UVD_JMI_ATOMIC_CNTL                                                                 0x01af
#define regUVD_JMI7_UVD_JMI_ATOMIC_CNTL_BASE_IDX                                                        0
#define regUVD_JMI7_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW                                            0x01b0
#define regUVD_JMI7_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW_BASE_IDX                                   0
#define regUVD_JMI7_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH                                           0x01b1
#define regUVD_JMI7_UVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH_BASE_IDX                                  0
#define regUVD_JMI7_UVD_LMI_JPEG_READ_64BIT_BAR_LOW                                                     0x01b2
#define regUVD_JMI7_UVD_LMI_JPEG_READ_64BIT_BAR_LOW_BASE_IDX                                            0
#define regUVD_JMI7_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH                                                    0x01b3
#define regUVD_JMI7_UVD_LMI_JPEG_READ_64BIT_BAR_HIGH_BASE_IDX                                           0
#define regUVD_JMI7_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW                                                    0x01b4
#define regUVD_JMI7_UVD_LMI_JPEG_WRITE_64BIT_BAR_LOW_BASE_IDX                                           0
#define regUVD_JMI7_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH                                                   0x01b5
#define regUVD_JMI7_UVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH_BASE_IDX                                          0
#define regUVD_JMI7_UVD_LMI_JRBC_IB_64BIT_BAR_LOW                                                       0x01b6
#define regUVD_JMI7_UVD_LMI_JRBC_IB_64BIT_BAR_LOW_BASE_IDX                                              0
#define regUVD_JMI7_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH                                                      0x01b7
#define regUVD_JMI7_UVD_LMI_JRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                             0
#define regUVD_JMI7_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW                                                0x01b8
#define regUVD_JMI7_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                       0
#define regUVD_JMI7_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH                                               0x01b9
#define regUVD_JMI7_UVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                      0
#define regUVD_JMI7_UVD_JMI_ATOMIC_CNTL2                                                                0x01bd
#define regUVD_JMI7_UVD_JMI_ATOMIC_CNTL2_BASE_IDX                                                       0


// addressBlock: uvdctxind
// base address: 0x0
#define ixUVD_CGC_MEM_CTRL                                                                             0x0000
#define ixUVD_CGC_CTRL2                                                                                0x0001
#define ixUVD_CGC_MEM_DS_CTRL                                                                          0x0002
#define ixUVD_CGC_MEM_SD_CTRL                                                                          0x0003
#define ixUVD_SW_SCRATCH_00                                                                            0x0004
#define ixUVD_SW_SCRATCH_01                                                                            0x0005
#define ixUVD_SW_SCRATCH_02                                                                            0x0006
#define ixUVD_SW_SCRATCH_03                                                                            0x0007
#define ixUVD_SW_SCRATCH_04                                                                            0x0008
#define ixUVD_SW_SCRATCH_05                                                                            0x0009
#define ixUVD_SW_SCRATCH_06                                                                            0x000a
#define ixUVD_SW_SCRATCH_07                                                                            0x000b
#define ixUVD_SW_SCRATCH_08                                                                            0x000c
#define ixUVD_SW_SCRATCH_09                                                                            0x000d
#define ixUVD_SW_SCRATCH_10                                                                            0x000e
#define ixUVD_SW_SCRATCH_11                                                                            0x000f
#define ixUVD_SW_SCRATCH_12                                                                            0x0010
#define ixUVD_SW_SCRATCH_13                                                                            0x0011
#define ixUVD_SW_SCRATCH_14                                                                            0x0012
#define ixUVD_SW_SCRATCH_15                                                                            0x0013
#define ixUVD_IH_SEM_CTRL                                                                              0x001e


// addressBlock: lmi_adp_indirect
// base address: 0x0
#define ixUVD_LMI_CRC0                                                                                 0x0000
#define ixUVD_LMI_CRC1                                                                                 0x0001
#define ixUVD_LMI_CRC2                                                                                 0x0002
#define ixUVD_LMI_CRC3                                                                                 0x0003
#define ixUVD_LMI_CRC10                                                                                0x000a
#define ixUVD_LMI_CRC11                                                                                0x000b
#define ixUVD_LMI_CRC12                                                                                0x000c
#define ixUVD_LMI_CRC13                                                                                0x000d
#define ixUVD_LMI_CRC14                                                                                0x000e
#define ixUVD_LMI_CRC15                                                                                0x000f
#define ixUVD_LMI_SWAP_CNTL2                                                                           0x0029
#define ixUVD_MEMCHECK_SYS_INT_EN                                                                      0x0134
#define ixUVD_MEMCHECK_SYS_INT_STAT                                                                    0x0135
#define ixUVD_MEMCHECK_SYS_INT_ACK                                                                     0x0136
#define ixUVD_MEMCHECK_VCPU_INT_EN                                                                     0x0137
#define ixUVD_MEMCHECK_VCPU_INT_STAT                                                                   0x0138
#define ixUVD_MEMCHECK_VCPU_INT_ACK                                                                    0x0139
#define ixUVD_MEMCHECK2_SYS_INT_STAT                                                                   0x0140
#define ixUVD_MEMCHECK2_SYS_INT_ACK                                                                    0x0141
#define ixUVD_MEMCHECK2_VCPU_INT_STAT                                                                  0x0142
#define ixUVD_MEMCHECK2_VCPU_INT_ACK                                                                   0x0143


#endif
