/* SPDX-License-Identifier: MIT */
/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _dcn_3_5_0_OFFSET_HEADER
#define _dcn_3_5_0_OFFSET_HEADER

// addressBlock: dce_dc_hda_azcontroller_azdec
// base address: 0x1300000
#define regGLOBAL_CAPABILITIES                                                                          0x4b7000
#define regGLOBAL_CAPABILITIES_BASE_IDX                                                                 3
#define regMINOR_VERSION                                                                                0x4b7000
#define regMINOR_VERSION_BASE_IDX                                                                       3
#define regMAJOR_VERSION                                                                                0x4b7000
#define regMAJOR_VERSION_BASE_IDX                                                                       3
#define regOUTPUT_PAYLOAD_CAPABILITY                                                                    0x4b7001
#define regOUTPUT_PAYLOAD_CAPABILITY_BASE_IDX                                                           3
#define regINPUT_PAYLOAD_CAPABILITY                                                                     0x4b7001
#define regINPUT_PAYLOAD_CAPABILITY_BASE_IDX                                                            3
#define regGLOBAL_CONTROL                                                                               0x4b7002
#define regGLOBAL_CONTROL_BASE_IDX                                                                      3
#define regWAKE_ENABLE                                                                                  0x4b7003
#define regWAKE_ENABLE_BASE_IDX                                                                         3
#define regSTATE_CHANGE_STATUS                                                                          0x4b7003
#define regSTATE_CHANGE_STATUS_BASE_IDX                                                                 3
#define regGLOBAL_STATUS                                                                                0x4b7004
#define regGLOBAL_STATUS_BASE_IDX                                                                       3
#define regOUTPUT_STREAM_PAYLOAD_CAPABILITY                                                             0x4b7006
#define regOUTPUT_STREAM_PAYLOAD_CAPABILITY_BASE_IDX                                                    3
#define regINPUT_STREAM_PAYLOAD_CAPABILITY                                                              0x4b7006
#define regINPUT_STREAM_PAYLOAD_CAPABILITY_BASE_IDX                                                     3
#define regINTERRUPT_CONTROL                                                                            0x4b7008
#define regINTERRUPT_CONTROL_BASE_IDX                                                                   3
#define regINTERRUPT_STATUS                                                                             0x4b7009
#define regINTERRUPT_STATUS_BASE_IDX                                                                    3
#define regWALL_CLOCK_COUNTER                                                                           0x4b700c
#define regWALL_CLOCK_COUNTER_BASE_IDX                                                                  3
#define regSTREAM_SYNCHRONIZATION                                                                       0x4b700e
#define regSTREAM_SYNCHRONIZATION_BASE_IDX                                                              3
#define regCORB_LOWER_BASE_ADDRESS                                                                      0x4b7010
#define regCORB_LOWER_BASE_ADDRESS_BASE_IDX                                                             3
#define regCORB_UPPER_BASE_ADDRESS                                                                      0x4b7011
#define regCORB_UPPER_BASE_ADDRESS_BASE_IDX                                                             3
#define regAZCONTROLLER0_CORB_WRITE_POINTER                                                             0x4b7012
#define regAZCONTROLLER0_CORB_WRITE_POINTER_BASE_IDX                                                    3
#define regAZCONTROLLER0_CORB_READ_POINTER                                                              0x4b7012
#define regAZCONTROLLER0_CORB_READ_POINTER_BASE_IDX                                                     3
#define regAZCONTROLLER0_CORB_CONTROL                                                                   0x4b7013
#define regAZCONTROLLER0_CORB_CONTROL_BASE_IDX                                                          3
#define regAZCONTROLLER0_CORB_STATUS                                                                    0x4b7013
#define regAZCONTROLLER0_CORB_STATUS_BASE_IDX                                                           3
#define regAZCONTROLLER0_CORB_SIZE                                                                      0x4b7013
#define regAZCONTROLLER0_CORB_SIZE_BASE_IDX                                                             3
#define regAZCONTROLLER0_RIRB_LOWER_BASE_ADDRESS                                                        0x4b7014
#define regAZCONTROLLER0_RIRB_LOWER_BASE_ADDRESS_BASE_IDX                                               3
#define regAZCONTROLLER0_RIRB_UPPER_BASE_ADDRESS                                                        0x4b7015
#define regAZCONTROLLER0_RIRB_UPPER_BASE_ADDRESS_BASE_IDX                                               3
#define regAZCONTROLLER0_RIRB_WRITE_POINTER                                                             0x4b7016
#define regAZCONTROLLER0_RIRB_WRITE_POINTER_BASE_IDX                                                    3
#define regAZCONTROLLER0_RESPONSE_INTERRUPT_COUNT                                                       0x4b7016
#define regAZCONTROLLER0_RESPONSE_INTERRUPT_COUNT_BASE_IDX                                              3
#define regAZCONTROLLER0_RIRB_CONTROL                                                                   0x4b7017
#define regAZCONTROLLER0_RIRB_CONTROL_BASE_IDX                                                          3
#define regAZCONTROLLER0_RIRB_STATUS                                                                    0x4b7017
#define regAZCONTROLLER0_RIRB_STATUS_BASE_IDX                                                           3
#define regAZCONTROLLER0_RIRB_SIZE                                                                      0x4b7017
#define regAZCONTROLLER0_RIRB_SIZE_BASE_IDX                                                             3
#define regAZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE                                             0x4b7018
#define regAZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_BASE_IDX                                    3
#define regAZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA                                        0x4b7018
#define regAZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA_BASE_IDX                               3
#define regAZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX                                       0x4b7018
#define regAZCONTROLLER0_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX_BASE_IDX                              3
#define regAZCONTROLLER0_IMMEDIATE_RESPONSE_INPUT_INTERFACE                                             0x4b7019
#define regAZCONTROLLER0_IMMEDIATE_RESPONSE_INPUT_INTERFACE_BASE_IDX                                    3
#define regAZCONTROLLER0_IMMEDIATE_COMMAND_STATUS                                                       0x4b701a
#define regAZCONTROLLER0_IMMEDIATE_COMMAND_STATUS_BASE_IDX                                              3
#define regAZCONTROLLER0_DMA_POSITION_LOWER_BASE_ADDRESS                                                0x4b701c
#define regAZCONTROLLER0_DMA_POSITION_LOWER_BASE_ADDRESS_BASE_IDX                                       3
#define regAZCONTROLLER0_DMA_POSITION_UPPER_BASE_ADDRESS                                                0x4b701d
#define regAZCONTROLLER0_DMA_POSITION_UPPER_BASE_ADDRESS_BASE_IDX                                       3
#define regAZCONTROLLER0_WALL_CLOCK_COUNTER_ALIAS                                                       0x4b780c
#define regAZCONTROLLER0_WALL_CLOCK_COUNTER_ALIAS_BASE_IDX                                              3

// addressBlock: azendpoint_sinkinfoind
// base address: 0x0
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MANUFACTURER_ID                                                  0x0000
#define ixAZALIA_F2_CODEC_PIN_CONTROL_PRODUCT_ID                                                       0x0001
#define ixAZALIA_F2_CODEC_PIN_CONTROL_SINK_DESCRIPTION_LEN                                             0x0002
#define ixAZALIA_F2_CODEC_PIN_CONTROL_PORTID0                                                          0x0003
#define ixAZALIA_F2_CODEC_PIN_CONTROL_PORTID1                                                          0x0004
#define ixSINK_DESCRIPTION0                                                                            0x0005
#define ixSINK_DESCRIPTION1                                                                            0x0006
#define ixSINK_DESCRIPTION2                                                                            0x0007
#define ixSINK_DESCRIPTION3                                                                            0x0008
#define ixSINK_DESCRIPTION4                                                                            0x0009
#define ixSINK_DESCRIPTION5                                                                            0x000a
#define ixSINK_DESCRIPTION6                                                                            0x000b
#define ixSINK_DESCRIPTION7                                                                            0x000c
#define ixSINK_DESCRIPTION8                                                                            0x000d
#define ixSINK_DESCRIPTION9                                                                            0x000e
#define ixSINK_DESCRIPTION10                                                                           0x000f
#define ixSINK_DESCRIPTION11                                                                           0x0010
#define ixSINK_DESCRIPTION12                                                                           0x0011
#define ixSINK_DESCRIPTION13                                                                           0x0012
#define ixSINK_DESCRIPTION14                                                                           0x0013
#define ixSINK_DESCRIPTION15                                                                           0x0014
#define ixSINK_DESCRIPTION16                                                                           0x0015
#define ixSINK_DESCRIPTION17                                                                           0x0016


// addressBlock: azf0controller_azinputcrc0resultind
// base address: 0x0
#define ixAZALIA_INPUT_CRC0_CHANNEL0                                                                   0x0000
#define ixAZALIA_INPUT_CRC0_CHANNEL1                                                                   0x0001
#define ixAZALIA_INPUT_CRC0_CHANNEL2                                                                   0x0002
#define ixAZALIA_INPUT_CRC0_CHANNEL3                                                                   0x0003
#define ixAZALIA_INPUT_CRC0_CHANNEL4                                                                   0x0004
#define ixAZALIA_INPUT_CRC0_CHANNEL5                                                                   0x0005
#define ixAZALIA_INPUT_CRC0_CHANNEL6                                                                   0x0006
#define ixAZALIA_INPUT_CRC0_CHANNEL7                                                                   0x0007


// addressBlock: azf0controller_azinputcrc1resultind
// base address: 0x0
#define ixAZALIA_INPUT_CRC1_CHANNEL0                                                                   0x0000
#define ixAZALIA_INPUT_CRC1_CHANNEL1                                                                   0x0001
#define ixAZALIA_INPUT_CRC1_CHANNEL2                                                                   0x0002
#define ixAZALIA_INPUT_CRC1_CHANNEL3                                                                   0x0003
#define ixAZALIA_INPUT_CRC1_CHANNEL4                                                                   0x0004
#define ixAZALIA_INPUT_CRC1_CHANNEL5                                                                   0x0005
#define ixAZALIA_INPUT_CRC1_CHANNEL6                                                                   0x0006
#define ixAZALIA_INPUT_CRC1_CHANNEL7                                                                   0x0007


// addressBlock: azf0controller_azcrc0resultind
// base address: 0x0
#define ixAZALIA_CRC0_CHANNEL0                                                                         0x0000
#define ixAZALIA_CRC0_CHANNEL1                                                                         0x0001
#define ixAZALIA_CRC0_CHANNEL2                                                                         0x0002
#define ixAZALIA_CRC0_CHANNEL3                                                                         0x0003
#define ixAZALIA_CRC0_CHANNEL4                                                                         0x0004
#define ixAZALIA_CRC0_CHANNEL5                                                                         0x0005
#define ixAZALIA_CRC0_CHANNEL6                                                                         0x0006
#define ixAZALIA_CRC0_CHANNEL7                                                                         0x0007


// addressBlock: azf0controller_azcrc1resultind
// base address: 0x0
#define ixAZALIA_CRC1_CHANNEL0                                                                         0x0000
#define ixAZALIA_CRC1_CHANNEL1                                                                         0x0001
#define ixAZALIA_CRC1_CHANNEL2                                                                         0x0002
#define ixAZALIA_CRC1_CHANNEL3                                                                         0x0003
#define ixAZALIA_CRC1_CHANNEL4                                                                         0x0004
#define ixAZALIA_CRC1_CHANNEL5                                                                         0x0005
#define ixAZALIA_CRC1_CHANNEL6                                                                         0x0006
#define ixAZALIA_CRC1_CHANNEL7                                                                         0x0007


// addressBlock: azf0stream0_streamind
// base address: 0x0
#define ixAZF0STREAM0_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM0_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM0_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM0_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM0_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream1_streamind
// base address: 0x0
#define ixAZF0STREAM1_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM1_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM1_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM1_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM1_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream2_streamind
// base address: 0x0
#define ixAZF0STREAM2_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM2_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM2_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM2_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM2_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream3_streamind
// base address: 0x0
#define ixAZF0STREAM3_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM3_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM3_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM3_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM3_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream4_streamind
// base address: 0x0
#define ixAZF0STREAM4_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM4_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM4_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM4_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM4_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream5_streamind
// base address: 0x0
#define ixAZF0STREAM5_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM5_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM5_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM5_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM5_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream6_streamind
// base address: 0x0
#define ixAZF0STREAM6_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM6_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM6_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM6_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM6_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream7_streamind
// base address: 0x0
#define ixAZF0STREAM7_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM7_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM7_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM7_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM7_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream8_streamind
// base address: 0x0
#define ixAZF0STREAM8_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM8_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM8_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM8_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM8_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream9_streamind
// base address: 0x0
#define ixAZF0STREAM9_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM9_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM9_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM9_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM9_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream10_streamind
// base address: 0x0
#define ixAZF0STREAM10_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM10_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM10_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM10_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM10_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0stream11_streamind
// base address: 0x0
#define ixAZF0STREAM11_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM11_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM11_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM11_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM11_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0stream12_streamind
// base address: 0x0
#define ixAZF0STREAM12_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM12_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM12_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM12_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM12_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0stream13_streamind
// base address: 0x0
#define ixAZF0STREAM13_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM13_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM13_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM13_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM13_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0stream14_streamind
// base address: 0x0
#define ixAZF0STREAM14_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM14_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM14_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM14_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM14_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0stream15_streamind
// base address: 0x0
#define ixAZF0STREAM15_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM15_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM15_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM15_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM15_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0endpoint0_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT0_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT0_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT0_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT0_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e
#define ixAZF0ENDPOINT0_AZALIA_F0_ENDPOINT_FGCG_REP_DIS                                                0x0070


// addressBlock: azf0endpoint1_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT1_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT1_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT1_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT1_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e
#define ixAZF0ENDPOINT1_AZALIA_F0_ENDPOINT_FGCG_REP_DIS                                                0x0070


// addressBlock: azf0endpoint2_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT2_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT2_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT2_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT2_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e
#define ixAZF0ENDPOINT2_AZALIA_F0_ENDPOINT_FGCG_REP_DIS                                                0x0070


// addressBlock: azf0endpoint3_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT3_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT3_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT3_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT3_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e
#define ixAZF0ENDPOINT3_AZALIA_F0_ENDPOINT_FGCG_REP_DIS                                                0x0070


// addressBlock: azf0endpoint4_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT4_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT4_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT4_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT4_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e
#define ixAZF0ENDPOINT4_AZALIA_F0_ENDPOINT_FGCG_REP_DIS                                                0x0070


// addressBlock: azf0endpoint5_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT5_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT5_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT5_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT5_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e
#define ixAZF0ENDPOINT5_AZALIA_F0_ENDPOINT_FGCG_REP_DIS                                                0x0070


// addressBlock: azf0endpoint6_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT6_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT6_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT6_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT6_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e
#define ixAZF0ENDPOINT6_AZALIA_F0_ENDPOINT_FGCG_REP_DIS                                                0x0070


// addressBlock: azf0endpoint7_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT7_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT7_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT7_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT7_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e
#define ixAZF0ENDPOINT7_AZALIA_F0_ENDPOINT_FGCG_REP_DIS                                                0x0070


// addressBlock: azf0inputendpoint0_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint1_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint2_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint3_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint4_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint5_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint6_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint7_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azendpoint_descriptorind
// base address: 0x0
#define ixAUDIO_DESCRIPTOR0                                                                            0x0001
#define ixAUDIO_DESCRIPTOR1                                                                            0x0002
#define ixAUDIO_DESCRIPTOR2                                                                            0x0003
#define ixAUDIO_DESCRIPTOR3                                                                            0x0004
#define ixAUDIO_DESCRIPTOR4                                                                            0x0005
#define ixAUDIO_DESCRIPTOR5                                                                            0x0006
#define ixAUDIO_DESCRIPTOR6                                                                            0x0007
#define ixAUDIO_DESCRIPTOR7                                                                            0x0008
#define ixAUDIO_DESCRIPTOR8                                                                            0x0009
#define ixAUDIO_DESCRIPTOR9                                                                            0x000a
#define ixAUDIO_DESCRIPTOR10                                                                           0x000b
#define ixAUDIO_DESCRIPTOR11                                                                           0x000c
#define ixAUDIO_DESCRIPTOR12                                                                           0x000d
#define ixAUDIO_DESCRIPTOR13                                                                           0x000e

// addressBlock: dce_dc_hda_azendpoint_azdec
// base address: 0x1300000
#define regAZENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA                               0x4b7018
#define regAZENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA_BASE_IDX                      3
#define regAZENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX                              0x4b7018
#define regAZENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX_BASE_IDX                     3


// addressBlock: dce_dc_hda_azinputendpoint_azdec
// base address: 0x1300000
#define regAZINPUTENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_DATA                           0x4b7018
#define regAZINPUTENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_DATA_BASE_IDX                  3
#define regAZINPUTENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_INDEX                          0x4b7018
#define regAZINPUTENDPOINT0_AZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_INDEX_BASE_IDX                 3


// addressBlock: dce_dc_dccg_dccg_dispdec
// base address: 0x0
#define regPHYPLLA_PIXCLK_RESYNC_CNTL                                                                   0x0040
#define regPHYPLLA_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define regPHYPLLB_PIXCLK_RESYNC_CNTL                                                                   0x0041
#define regPHYPLLB_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define regPHYPLLC_PIXCLK_RESYNC_CNTL                                                                   0x0042
#define regPHYPLLC_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define regPHYPLLD_PIXCLK_RESYNC_CNTL                                                                   0x0043
#define regPHYPLLD_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define regDP_DTO_DBUF_EN                                                                               0x0044
#define regDP_DTO_DBUF_EN_BASE_IDX                                                                      1
#define regDSCCLK3_DTO_PARAM                                                                            0x0045
#define regDSCCLK3_DTO_PARAM_BASE_IDX                                                                   1
#define regDPREFCLK_CGTT_BLK_CTRL_REG                                                                   0x0048
#define regDPREFCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                          1
#define regDCCG_GATE_DISABLE_CNTL4                                                                      0x0049
#define regDCCG_GATE_DISABLE_CNTL4_BASE_IDX                                                             1
#define regDPSTREAMCLK_CNTL                                                                             0x004a
#define regDPSTREAMCLK_CNTL_BASE_IDX                                                                    1
#define regREFCLK_CGTT_BLK_CTRL_REG                                                                     0x004b
#define regREFCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define regPHYPLLE_PIXCLK_RESYNC_CNTL                                                                   0x004c
#define regPHYPLLE_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define regDCCG_PERFMON_CNTL2                                                                           0x004e
#define regDCCG_PERFMON_CNTL2_BASE_IDX                                                                  1
#define regDCCG_GLOBAL_FGCG_REP_CNTL                                                                    0x0050
#define regDCCG_GLOBAL_FGCG_REP_CNTL_BASE_IDX                                                           1
#define regDCCG_DS_DTO_INCR                                                                             0x0053
#define regDCCG_DS_DTO_INCR_BASE_IDX                                                                    1
#define regDCCG_DS_DTO_MODULO                                                                           0x0054
#define regDCCG_DS_DTO_MODULO_BASE_IDX                                                                  1
#define regDCCG_DS_CNTL                                                                                 0x0055
#define regDCCG_DS_CNTL_BASE_IDX                                                                        1
#define regDCCG_DS_HW_CAL_INTERVAL                                                                      0x0056
#define regDCCG_DS_HW_CAL_INTERVAL_BASE_IDX                                                             1
#define regDPREFCLK_CNTL                                                                                0x0058
#define regDPREFCLK_CNTL_BASE_IDX                                                                       1
#define regDCE_VERSION                                                                                  0x005e
#define regDCE_VERSION_BASE_IDX                                                                         1
#define regDCCG_GTC_CNTL                                                                                0x0060
#define regDCCG_GTC_CNTL_BASE_IDX                                                                       1
#define regDCCG_GTC_DTO_INCR                                                                            0x0061
#define regDCCG_GTC_DTO_INCR_BASE_IDX                                                                   1
#define regDCCG_GTC_DTO_MODULO                                                                          0x0062
#define regDCCG_GTC_DTO_MODULO_BASE_IDX                                                                 1
#define regDCCG_GTC_CURRENT                                                                             0x0063
#define regDCCG_GTC_CURRENT_BASE_IDX                                                                    1
#define regSYMCLK32_SE_CNTL                                                                             0x0065
#define regSYMCLK32_SE_CNTL_BASE_IDX                                                                    1
#define regSYMCLK32_LE_CNTL                                                                             0x0066
#define regSYMCLK32_LE_CNTL_BASE_IDX                                                                    1
#define regDTBCLK_P_CNTL                                                                                0x0068
#define regDTBCLK_P_CNTL_BASE_IDX                                                                       1
#define regDCCG_GATE_DISABLE_CNTL5                                                                      0x0069
#define regDCCG_GATE_DISABLE_CNTL5_BASE_IDX                                                             1
#define regDSCCLK0_DTO_PARAM                                                                            0x006c
#define regDSCCLK0_DTO_PARAM_BASE_IDX                                                                   1
#define regDSCCLK1_DTO_PARAM                                                                            0x006d
#define regDSCCLK1_DTO_PARAM_BASE_IDX                                                                   1
#define regDSCCLK2_DTO_PARAM                                                                            0x006e
#define regDSCCLK2_DTO_PARAM_BASE_IDX                                                                   1
#define regOTG_PIXEL_RATE_DIV                                                                           0x006f
#define regOTG_PIXEL_RATE_DIV_BASE_IDX                                                                  1
#define regMILLISECOND_TIME_BASE_DIV                                                                    0x0070
#define regMILLISECOND_TIME_BASE_DIV_BASE_IDX                                                           1
#define regDISPCLK_FREQ_CHANGE_CNTL                                                                     0x0071
#define regDISPCLK_FREQ_CHANGE_CNTL_BASE_IDX                                                            1
#define regDC_MEM_GLOBAL_PWR_REQ_CNTL                                                                   0x0072
#define regDC_MEM_GLOBAL_PWR_REQ_CNTL_BASE_IDX                                                          1
#define regDCCG_PERFMON_CNTL                                                                            0x0073
#define regDCCG_PERFMON_CNTL_BASE_IDX                                                                   1
#define regDCCG_GATE_DISABLE_CNTL                                                                       0x0074
#define regDCCG_GATE_DISABLE_CNTL_BASE_IDX                                                              1
#define regDISPCLK_CGTT_BLK_CTRL_REG                                                                    0x0075
#define regDISPCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                           1
#define regSOCCLK_CGTT_BLK_CTRL_REG                                                                     0x0076
#define regSOCCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define regDCCG_CAC_STATUS                                                                              0x0077
#define regDCCG_CAC_STATUS_BASE_IDX                                                                     1
#define regMICROSECOND_TIME_BASE_DIV                                                                    0x007b
#define regMICROSECOND_TIME_BASE_DIV_BASE_IDX                                                           1
#define regDCCG_GATE_DISABLE_CNTL2                                                                      0x007c
#define regDCCG_GATE_DISABLE_CNTL2_BASE_IDX                                                             1
#define regSYMCLK_CGTT_BLK_CTRL_REG                                                                     0x007d
#define regSYMCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define regDCCG_DISP_CNTL_REG                                                                           0x007f
#define regDCCG_DISP_CNTL_REG_BASE_IDX                                                                  1
#define regOTG0_PIXEL_RATE_CNTL                                                                         0x0080
#define regOTG0_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define regDP_DTO0_PHASE                                                                                0x0081
#define regDP_DTO0_PHASE_BASE_IDX                                                                       1
#define regDP_DTO0_MODULO                                                                               0x0082
#define regDP_DTO0_MODULO_BASE_IDX                                                                      1
#define regOTG0_PHYPLL_PIXEL_RATE_CNTL                                                                  0x0083
#define regOTG0_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define regOTG1_PIXEL_RATE_CNTL                                                                         0x0084
#define regOTG1_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define regDP_DTO1_PHASE                                                                                0x0085
#define regDP_DTO1_PHASE_BASE_IDX                                                                       1
#define regDP_DTO1_MODULO                                                                               0x0086
#define regDP_DTO1_MODULO_BASE_IDX                                                                      1
#define regOTG1_PHYPLL_PIXEL_RATE_CNTL                                                                  0x0087
#define regOTG1_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define regOTG2_PIXEL_RATE_CNTL                                                                         0x0088
#define regOTG2_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define regDP_DTO2_PHASE                                                                                0x0089
#define regDP_DTO2_PHASE_BASE_IDX                                                                       1
#define regDP_DTO2_MODULO                                                                               0x008a
#define regDP_DTO2_MODULO_BASE_IDX                                                                      1
#define regOTG2_PHYPLL_PIXEL_RATE_CNTL                                                                  0x008b
#define regOTG2_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define regOTG3_PIXEL_RATE_CNTL                                                                         0x008c
#define regOTG3_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define regDP_DTO3_PHASE                                                                                0x008d
#define regDP_DTO3_PHASE_BASE_IDX                                                                       1
#define regDP_DTO3_MODULO                                                                               0x008e
#define regDP_DTO3_MODULO_BASE_IDX                                                                      1
#define regOTG3_PHYPLL_PIXEL_RATE_CNTL                                                                  0x008f
#define regOTG3_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define regDPPCLK_CGTT_BLK_CTRL_REG                                                                     0x0098
#define regDPPCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define regDPPCLK0_DTO_PARAM                                                                            0x0099
#define regDPPCLK0_DTO_PARAM_BASE_IDX                                                                   1
#define regDPPCLK1_DTO_PARAM                                                                            0x009a
#define regDPPCLK1_DTO_PARAM_BASE_IDX                                                                   1
#define regDPPCLK2_DTO_PARAM                                                                            0x009b
#define regDPPCLK2_DTO_PARAM_BASE_IDX                                                                   1
#define regDPPCLK3_DTO_PARAM                                                                            0x009c
#define regDPPCLK3_DTO_PARAM_BASE_IDX                                                                   1
#define regDCCG_CAC_STATUS2                                                                             0x009f
#define regDCCG_CAC_STATUS2_BASE_IDX                                                                    1
#define regSYMCLKA_CLOCK_ENABLE                                                                         0x00a0
#define regSYMCLKA_CLOCK_ENABLE_BASE_IDX                                                                1
#define regSYMCLKB_CLOCK_ENABLE                                                                         0x00a1
#define regSYMCLKB_CLOCK_ENABLE_BASE_IDX                                                                1
#define regSYMCLKC_CLOCK_ENABLE                                                                         0x00a2
#define regSYMCLKC_CLOCK_ENABLE_BASE_IDX                                                                1
#define regSYMCLKD_CLOCK_ENABLE                                                                         0x00a3
#define regSYMCLKD_CLOCK_ENABLE_BASE_IDX                                                                1
#define regSYMCLKE_CLOCK_ENABLE                                                                         0x00a4
#define regSYMCLKE_CLOCK_ENABLE_BASE_IDX                                                                1
#define regDCCG_SOFT_RESET                                                                              0x00a6
#define regDCCG_SOFT_RESET_BASE_IDX                                                                     1
#define regDSCCLK_DTO_CTRL                                                                              0x00a7
#define regDSCCLK_DTO_CTRL_BASE_IDX                                                                     1
#define regDPPCLK_CTRL                                                                                  0x00a8
#define regDPPCLK_CTRL_BASE_IDX                                                                         1
#define regDCCG_GATE_DISABLE_CNTL6                                                                      0x00a9
#define regDCCG_GATE_DISABLE_CNTL6_BASE_IDX                                                             1
#define regSYMCLK_PSP_CNTL                                                                              0x00aa
#define regSYMCLK_PSP_CNTL_BASE_IDX                                                                     1
#define regDCCG_AUDIO_DTO_SOURCE                                                                        0x00ab
#define regDCCG_AUDIO_DTO_SOURCE_BASE_IDX                                                               1
#define regDCCG_AUDIO_DTO0_PHASE                                                                        0x00ac
#define regDCCG_AUDIO_DTO0_PHASE_BASE_IDX                                                               1
#define regDCCG_AUDIO_DTO0_MODULE                                                                       0x00ad
#define regDCCG_AUDIO_DTO0_MODULE_BASE_IDX                                                              1
#define regDCCG_AUDIO_DTO1_PHASE                                                                        0x00ae
#define regDCCG_AUDIO_DTO1_PHASE_BASE_IDX                                                               1
#define regDCCG_AUDIO_DTO1_MODULE                                                                       0x00af
#define regDCCG_AUDIO_DTO1_MODULE_BASE_IDX                                                              1
#define regDCCG_VSYNC_OTG0_LATCH_VALUE                                                                  0x00b0
#define regDCCG_VSYNC_OTG0_LATCH_VALUE_BASE_IDX                                                         1
#define regDCCG_VSYNC_OTG1_LATCH_VALUE                                                                  0x00b1
#define regDCCG_VSYNC_OTG1_LATCH_VALUE_BASE_IDX                                                         1
#define regDCCG_VSYNC_OTG2_LATCH_VALUE                                                                  0x00b2
#define regDCCG_VSYNC_OTG2_LATCH_VALUE_BASE_IDX                                                         1
#define regDCCG_VSYNC_OTG3_LATCH_VALUE                                                                  0x00b3
#define regDCCG_VSYNC_OTG3_LATCH_VALUE_BASE_IDX                                                         1
#define regDCCG_VSYNC_OTG4_LATCH_VALUE                                                                  0x00b4
#define regDCCG_VSYNC_OTG4_LATCH_VALUE_BASE_IDX                                                         1
#define regDCCG_VSYNC_OTG5_LATCH_VALUE                                                                  0x00b5
#define regDCCG_VSYNC_OTG5_LATCH_VALUE_BASE_IDX                                                         1
#define regDPPCLK_DTO_CTRL                                                                              0x00b6
#define regDPPCLK_DTO_CTRL_BASE_IDX                                                                     1
#define regDCCG_VSYNC_CNT_CTRL                                                                          0x00b8
#define regDCCG_VSYNC_CNT_CTRL_BASE_IDX                                                                 1
#define regDCCG_VSYNC_CNT_INT_CTRL                                                                      0x00b9
#define regDCCG_VSYNC_CNT_INT_CTRL_BASE_IDX                                                             1
#define regFORCE_SYMCLK_DISABLE                                                                         0x00ba
#define regFORCE_SYMCLK_DISABLE_BASE_IDX                                                                1
#define regDTBCLK_DTO0_PHASE                                                                            0x0018
#define regDTBCLK_DTO0_PHASE_BASE_IDX                                                                   2
#define regDTBCLK_DTO1_PHASE                                                                            0x0019
#define regDTBCLK_DTO1_PHASE_BASE_IDX                                                                   2
#define regDTBCLK_DTO2_PHASE                                                                            0x001a
#define regDTBCLK_DTO2_PHASE_BASE_IDX                                                                   2
#define regDTBCLK_DTO3_PHASE                                                                            0x001b
#define regDTBCLK_DTO3_PHASE_BASE_IDX                                                                   2
#define regDTBCLK_DTO0_MODULO                                                                           0x001f
#define regDTBCLK_DTO0_MODULO_BASE_IDX                                                                  2
#define regDTBCLK_DTO1_MODULO                                                                           0x0020
#define regDTBCLK_DTO1_MODULO_BASE_IDX                                                                  2
#define regDTBCLK_DTO2_MODULO                                                                           0x0021
#define regDTBCLK_DTO2_MODULO_BASE_IDX                                                                  2
#define regDTBCLK_DTO3_MODULO                                                                           0x0022
#define regDTBCLK_DTO3_MODULO_BASE_IDX                                                                  2
#define regHDMICHARCLK0_CLOCK_CNTL                                                                      0x004a
#define regHDMICHARCLK0_CLOCK_CNTL_BASE_IDX                                                             2
#define regPHYASYMCLK_CLOCK_CNTL                                                                        0x0052
#define regPHYASYMCLK_CLOCK_CNTL_BASE_IDX                                                               2
#define regPHYBSYMCLK_CLOCK_CNTL                                                                        0x0053
#define regPHYBSYMCLK_CLOCK_CNTL_BASE_IDX                                                               2
#define regPHYCSYMCLK_CLOCK_CNTL                                                                        0x0054
#define regPHYCSYMCLK_CLOCK_CNTL_BASE_IDX                                                               2
#define regPHYDSYMCLK_CLOCK_CNTL                                                                        0x0055
#define regPHYDSYMCLK_CLOCK_CNTL_BASE_IDX                                                               2
#define regPHYESYMCLK_CLOCK_CNTL                                                                        0x0056
#define regPHYESYMCLK_CLOCK_CNTL_BASE_IDX                                                               2
#define regHDMISTREAMCLK_CNTL                                                                           0x0059
#define regHDMISTREAMCLK_CNTL_BASE_IDX                                                                  2
#define regDCCG_GATE_DISABLE_CNTL3                                                                      0x005a
#define regDCCG_GATE_DISABLE_CNTL3_BASE_IDX                                                             2
#define regHDMISTREAMCLK0_DTO_PARAM                                                                     0x005b
#define regHDMISTREAMCLK0_DTO_PARAM_BASE_IDX                                                            2
#define regDCCG_AUDIO_DTBCLK_DTO_PHASE                                                                  0x0061
#define regDCCG_AUDIO_DTBCLK_DTO_PHASE_BASE_IDX                                                         2
#define regDCCG_AUDIO_DTBCLK_DTO_MODULO                                                                 0x0062
#define regDCCG_AUDIO_DTBCLK_DTO_MODULO_BASE_IDX                                                        2
#define regDTBCLK_DTO_DBUF_EN                                                                           0x0063
#define regDTBCLK_DTO_DBUF_EN_BASE_IDX                                                                  2

// addressBlock: dce_dc_dccg_dccg_dfs_dispdec
// base address: 0x0
#define regDENTIST_DISPCLK_CNTL                                                                         0x0064
#define regDENTIST_DISPCLK_CNTL_BASE_IDX                                                                1


// addressBlock: azroot_f2codecind
// base address: 0x0
#define ixAZALIA_F2_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID                                          0x0f00
#define ixAZALIA_F2_CODEC_ROOT_PARAMETER_REVISION_ID                                                   0x0f02
#define ixAZALIA_F2_CODEC_ROOT_PARAMETER_SUBORDINATE_NODE_COUNT                                        0x0f04
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_POWER_STATE                                                 0x1705
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID                                       0x1720
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_2                                     0x1721
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_3                                     0x1722
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_4                                     0x1723
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION                                   0x1770
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESET                                                       0x17ff
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_SUBORDINATE_NODE_COUNT                                    0x1f04
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_GROUP_TYPE                                                0x1f05
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES                                      0x1f0a
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS                                            0x1f0b
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_POWER_STATES                                              0x1f0f


// addressBlock: azendpoint_f2codecind
// base address: 0x0
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                                           0x2200
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                                          0x2706
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                                          0x270d
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_2                                        0x270e
#define ixAZALIA_F2_CODEC_CONVERTER_STRIPE_CONTROL                                                     0x2724
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_3                                        0x273e
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_RAMP_RATE                                                  0x2770
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                              0x2771
#define ixAZALIA_F2_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                                0x2f09
#define ixAZALIA_F2_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                                     0x2f0a
#define ixAZALIA_F2_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                                           0x2f0b
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONNECTION_LIST_ENTRY                                   0x3702
#define ixAZALIA_F2_CODEC_PIN_CONTROL_WIDGET_CONTROL                                                   0x3707
#define ixAZALIA_F2_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                                             0x3708
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                               0x3709
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                                   0x371c
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_2                                 0x371d
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_3                                 0x371e
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_4                                 0x371f
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_SPEAKER_ALLOCATION                                      0x3770
#define ixAZALIA_F2_CODEC_PIN_CONTROL_CHANNEL_ALLOCATION                                               0x3771
#define ixAZALIA_F2_CODEC_PIN_CONTROL_DOWN_MIX_INFO                                                    0x3772
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR                                                 0x3776
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR_DATA                                            0x3776
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL01_ENABLE                                            0x3777
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL23_ENABLE                                            0x3778
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL45_ENABLE                                            0x3779
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL67_ENABLE                                            0x377a
#define ixAZALIA_F2_CODEC_PIN_CONTROL_LIPSYNC                                                          0x377b
#define ixAZALIA_F2_CODEC_PIN_CONTROL_HBR                                                              0x377c
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_SINK_INFO_INDEX                                            0x3780
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_SINK_INFO_DATA                                             0x3781
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL1_ENABLE                                             0x3785
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL3_ENABLE                                             0x3786
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL5_ENABLE                                             0x3787
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL7_ENABLE                                             0x3788
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                                0x3789
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                                    0x378a
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                                    0x378b
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                                    0x378c
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                                    0x378d
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                                    0x378e
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                                    0x378f
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                                    0x3790
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                                    0x3791
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                                    0x3792
#define ixAZALIA_F2_CODEC_PIN_ASSOCIATION_INFO                                                         0x3793
#define ixAZALIA_F2_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                                            0x3797
#define ixAZALIA_F2_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                                            0x3798
#define ixAZALIA_F2_CODEC_PIN_CONTROL_LPIB                                                             0x3799
#define ixAZALIA_F2_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                              0x379a
#define ixAZALIA_F2_CODEC_PIN_CONTROL_CODING_TYPE                                                      0x379b
#define ixAZALIA_F2_CODEC_PIN_CONTROL_FORMAT_CHANGED                                                   0x379c
#define ixAZALIA_F2_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                                  0x379d
#define ixAZALIA_F2_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                                 0x379e
#define ixAZALIA_F2_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                                      0x3f09
#define ixAZALIA_F2_CODEC_PIN_PARAMETER_CAPABILITIES                                                   0x3f0c
#define ixAZALIA_F2_CODEC_PIN_PARAMETER_CONNECTION_LIST_LENGTH                                         0x3f0e


// addressBlock: azinputendpoint_f2codecind
// base address: 0x0
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                                     0x6200
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                                    0x6706
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                                    0x670d
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                          0x6f09
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                               0x6f0a
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                                     0x6f0b
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                                             0x7707
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                                       0x7708
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_RESPONSE_PIN_SENSE                                         0x7709
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                             0x771c
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_2                           0x771d
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_3                           0x771e
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_4                           0x771f
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                                         0x7771
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL0_ENABLE                                       0x7777
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL2_ENABLE                                       0x7778
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL4_ENABLE                                       0x7779
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL6_ENABLE                                       0x777a
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_HBR                                                        0x777c
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL1_ENABLE                                       0x7785
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL3_ENABLE                                       0x7786
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL5_ENABLE                                       0x7787
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL7_ENABLE                                       0x7788
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                                      0x7798
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_LPIB                                                       0x7799
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                        0x779a
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                                       0x779b
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_INFOFRAME                                                  0x779c
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_CHANNEL_STATUS_L                                           0x779d
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_CHANNEL_STATUS_H                                           0x779e
#define ixAZALIA_F2_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                                0x7f09
#define ixAZALIA_F2_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                                             0x7f0c


// addressBlock: dce_dc_dccg_dccg_dcperfmon0_dc_perfmon_dispdec
// base address: 0x0
#define regDC_PERFMON0_PERFCOUNTER_CNTL                                                                 0x0000
#define regDC_PERFMON0_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define regDC_PERFMON0_PERFCOUNTER_CNTL2                                                                0x0001
#define regDC_PERFMON0_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define regDC_PERFMON0_PERFCOUNTER_STATE                                                                0x0002
#define regDC_PERFMON0_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define regDC_PERFMON0_PERFMON_CNTL                                                                     0x0003
#define regDC_PERFMON0_PERFMON_CNTL_BASE_IDX                                                            2
#define regDC_PERFMON0_PERFMON_CNTL2                                                                    0x0004
#define regDC_PERFMON0_PERFMON_CNTL2_BASE_IDX                                                           2
#define regDC_PERFMON0_PERFMON_CVALUE_INT_MISC                                                          0x0005
#define regDC_PERFMON0_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define regDC_PERFMON0_PERFMON_CVALUE_LOW                                                               0x0006
#define regDC_PERFMON0_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define regDC_PERFMON0_PERFMON_HI                                                                       0x0007
#define regDC_PERFMON0_PERFMON_HI_BASE_IDX                                                              2
#define regDC_PERFMON0_PERFMON_LOW                                                                      0x0008
#define regDC_PERFMON0_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dccg_dccg_dcperfmon1_dc_perfmon_dispdec
// base address: 0x30
#define regDC_PERFMON1_PERFCOUNTER_CNTL                                                                 0x000c
#define regDC_PERFMON1_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define regDC_PERFMON1_PERFCOUNTER_CNTL2                                                                0x000d
#define regDC_PERFMON1_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define regDC_PERFMON1_PERFCOUNTER_STATE                                                                0x000e
#define regDC_PERFMON1_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define regDC_PERFMON1_PERFMON_CNTL                                                                     0x000f
#define regDC_PERFMON1_PERFMON_CNTL_BASE_IDX                                                            2
#define regDC_PERFMON1_PERFMON_CNTL2                                                                    0x0010
#define regDC_PERFMON1_PERFMON_CNTL2_BASE_IDX                                                           2
#define regDC_PERFMON1_PERFMON_CVALUE_INT_MISC                                                          0x0011
#define regDC_PERFMON1_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define regDC_PERFMON1_PERFMON_CVALUE_LOW                                                               0x0012
#define regDC_PERFMON1_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define regDC_PERFMON1_PERFMON_HI                                                                       0x0013
#define regDC_PERFMON1_PERFMON_HI_BASE_IDX                                                              2
#define regDC_PERFMON1_PERFMON_LOW                                                                      0x0014
#define regDC_PERFMON1_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmu_dc_pg_dispdec
// base address: 0x0
#define regDOMAIN0_PG_CONFIG                                                                            0x0080
#define regDOMAIN0_PG_CONFIG_BASE_IDX                                                                   2
#define regDOMAIN0_PG_STATUS                                                                            0x0081
#define regDOMAIN0_PG_STATUS_BASE_IDX                                                                   2
#define regDOMAIN1_PG_CONFIG                                                                            0x0082
#define regDOMAIN1_PG_CONFIG_BASE_IDX                                                                   2
#define regDOMAIN1_PG_STATUS                                                                            0x0083
#define regDOMAIN1_PG_STATUS_BASE_IDX                                                                   2
#define regDOMAIN2_PG_CONFIG                                                                            0x0084
#define regDOMAIN2_PG_CONFIG_BASE_IDX                                                                   2
#define regDOMAIN2_PG_STATUS                                                                            0x0085
#define regDOMAIN2_PG_STATUS_BASE_IDX                                                                   2
#define regDOMAIN3_PG_CONFIG                                                                            0x0086
#define regDOMAIN3_PG_CONFIG_BASE_IDX                                                                   2
#define regDOMAIN3_PG_STATUS                                                                            0x0087
#define regDOMAIN3_PG_STATUS_BASE_IDX                                                                   2
#define regDOMAIN16_PG_CONFIG                                                                           0x0089
#define regDOMAIN16_PG_CONFIG_BASE_IDX                                                                  2
#define regDOMAIN16_PG_STATUS                                                                           0x008a
#define regDOMAIN16_PG_STATUS_BASE_IDX                                                                  2
#define regDOMAIN17_PG_CONFIG                                                                           0x008b
#define regDOMAIN17_PG_CONFIG_BASE_IDX                                                                  2
#define regDOMAIN17_PG_STATUS                                                                           0x008c
#define regDOMAIN17_PG_STATUS_BASE_IDX                                                                  2
#define regDOMAIN18_PG_CONFIG                                                                           0x008d
#define regDOMAIN18_PG_CONFIG_BASE_IDX                                                                  2
#define regDOMAIN18_PG_STATUS                                                                           0x008e
#define regDOMAIN18_PG_STATUS_BASE_IDX                                                                  2
#define regDOMAIN19_PG_CONFIG                                                                           0x008f
#define regDOMAIN19_PG_CONFIG_BASE_IDX                                                                  2
#define regDOMAIN19_PG_STATUS                                                                           0x0090
#define regDOMAIN19_PG_STATUS_BASE_IDX                                                                  2
#define regDOMAIN22_PG_CONFIG                                                                           0x0092
#define regDOMAIN22_PG_CONFIG_BASE_IDX                                                                  2
#define regDOMAIN22_PG_STATUS                                                                           0x0093
#define regDOMAIN22_PG_STATUS_BASE_IDX                                                                  2
#define regDOMAIN23_PG_CONFIG                                                                           0x0094
#define regDOMAIN23_PG_CONFIG_BASE_IDX                                                                  2
#define regDOMAIN23_PG_STATUS                                                                           0x0095
#define regDOMAIN23_PG_STATUS_BASE_IDX                                                                  2
#define regDOMAIN24_PG_CONFIG                                                                           0x0096
#define regDOMAIN24_PG_CONFIG_BASE_IDX                                                                  2
#define regDOMAIN24_PG_STATUS                                                                           0x0097
#define regDOMAIN24_PG_STATUS_BASE_IDX                                                                  2
#define regDOMAIN25_PG_CONFIG                                                                           0x0098
#define regDOMAIN25_PG_CONFIG_BASE_IDX                                                                  2
#define regDOMAIN25_PG_STATUS                                                                           0x0099
#define regDOMAIN25_PG_STATUS_BASE_IDX                                                                  2
#define regDCPG_INTERRUPT_STATUS                                                                        0x009a
#define regDCPG_INTERRUPT_STATUS_BASE_IDX                                                               2
#define regDCPG_INTERRUPT_STATUS_2                                                                      0x009b
#define regDCPG_INTERRUPT_STATUS_2_BASE_IDX                                                             2
#define regDCPG_INTERRUPT_STATUS_3                                                                      0x009c
#define regDCPG_INTERRUPT_STATUS_3_BASE_IDX                                                             2
#define regDCPG_INTERRUPT_CONTROL_1                                                                     0x009d
#define regDCPG_INTERRUPT_CONTROL_1_BASE_IDX                                                            2
#define regDCPG_INTERRUPT_CONTROL_2                                                                     0x009e
#define regDCPG_INTERRUPT_CONTROL_2_BASE_IDX                                                            2
#define regDCPG_INTERRUPT_CONTROL_3                                                                     0x009f
#define regDCPG_INTERRUPT_CONTROL_3_BASE_IDX                                                            2
#define regDC_IP_REQUEST_CNTL                                                                           0x00a0
#define regDC_IP_REQUEST_CNTL_BASE_IDX                                                                  2
#define regLONO_MEM_PWR_REQ_CNTL                                                                        0x00a4
#define regLONO_MEM_PWR_REQ_CNTL_BASE_IDX                                                               2


// addressBlock: dce_dc_dmu_dmu_dcperfmon_dc_perfmon_dispdec
// base address: 0x2f8
#define regDC_PERFMON2_PERFCOUNTER_CNTL                                                                 0x00be
#define regDC_PERFMON2_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define regDC_PERFMON2_PERFCOUNTER_CNTL2                                                                0x00bf
#define regDC_PERFMON2_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define regDC_PERFMON2_PERFCOUNTER_STATE                                                                0x00c0
#define regDC_PERFMON2_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define regDC_PERFMON2_PERFMON_CNTL                                                                     0x00c1
#define regDC_PERFMON2_PERFMON_CNTL_BASE_IDX                                                            2
#define regDC_PERFMON2_PERFMON_CNTL2                                                                    0x00c2
#define regDC_PERFMON2_PERFMON_CNTL2_BASE_IDX                                                           2
#define regDC_PERFMON2_PERFMON_CVALUE_INT_MISC                                                          0x00c3
#define regDC_PERFMON2_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define regDC_PERFMON2_PERFMON_CVALUE_LOW                                                               0x00c4
#define regDC_PERFMON2_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define regDC_PERFMON2_PERFMON_HI                                                                       0x00c5
#define regDC_PERFMON2_PERFMON_HI_BASE_IDX                                                              2
#define regDC_PERFMON2_PERFMON_LOW                                                                      0x00c6
#define regDC_PERFMON2_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmu_dmu_misc_dispdec
// base address: 0x0
#define regCC_DC_PIPE_DIS                                                                               0x00ca
#define regCC_DC_PIPE_DIS_BASE_IDX                                                                      2
#define regDMU_CLK_CNTL                                                                                 0x00cb
#define regDMU_CLK_CNTL_BASE_IDX                                                                        2
#define regDMCUB_SMU_INTERRUPT_CNTL                                                                     0x00cd
#define regDMCUB_SMU_INTERRUPT_CNTL_BASE_IDX                                                            2
#define regSMU_INTERRUPT_CONTROL                                                                        0x00ce
#define regSMU_INTERRUPT_CONTROL_BASE_IDX                                                               2
#define regZSC_CNTL                                                                                     0x00cf
#define regZSC_CNTL_BASE_IDX                                                                            2
#define regZSC_CNTL2                                                                                    0x00d0
#define regZSC_CNTL2_BASE_IDX                                                                           2
#define regDMU_MISC_ALLOW_DS_FORCE                                                                      0x00d6
#define regDMU_MISC_ALLOW_DS_FORCE_BASE_IDX                                                             2
#define regZSC_STATUS                                                                                   0x00d7
#define regZSC_STATUS_BASE_IDX                                                                          2
#define regDMU_DISPCLK_CGTT_BLK_CTRL_REG                                                                0x00d8
#define regDMU_DISPCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                       2
#define regDMU_SOCCLK_CGTT_BLK_CTRL_REG                                                                 0x00d9
#define regDMU_SOCCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                        2
#define regZPR_CLK_UNGATE_DELAY                                                                         0x00da
#define regZPR_CLK_UNGATE_DELAY_BASE_IDX                                                                2



// addressBlock: dce_dc_dmu_ihc_dispdec
// base address: 0x0
#define regDC_GPU_TIMER_START_POSITION_V_UPDATE                                                         0x0126
#define regDC_GPU_TIMER_START_POSITION_V_UPDATE_BASE_IDX                                                2
#define regDC_GPU_TIMER_START_POSITION_VSTARTUP                                                         0x0127
#define regDC_GPU_TIMER_START_POSITION_VSTARTUP_BASE_IDX                                                2
#define regDC_GPU_TIMER_READ                                                                            0x0128
#define regDC_GPU_TIMER_READ_BASE_IDX                                                                   2
#define regDC_GPU_TIMER_READ_CNTL                                                                       0x0129
#define regDC_GPU_TIMER_READ_CNTL_BASE_IDX                                                              2
#define regDISP_INTERRUPT_STATUS                                                                        0x012a
#define regDISP_INTERRUPT_STATUS_BASE_IDX                                                               2
#define regDISP_INTERRUPT_STATUS_CONTINUE                                                               0x012b
#define regDISP_INTERRUPT_STATUS_CONTINUE_BASE_IDX                                                      2
#define regDISP_INTERRUPT_STATUS_CONTINUE2                                                              0x012c
#define regDISP_INTERRUPT_STATUS_CONTINUE2_BASE_IDX                                                     2
#define regDISP_INTERRUPT_STATUS_CONTINUE3                                                              0x012d
#define regDISP_INTERRUPT_STATUS_CONTINUE3_BASE_IDX                                                     2
#define regDISP_INTERRUPT_STATUS_CONTINUE4                                                              0x012e
#define regDISP_INTERRUPT_STATUS_CONTINUE4_BASE_IDX                                                     2
#define regDISP_INTERRUPT_STATUS_CONTINUE5                                                              0x012f
#define regDISP_INTERRUPT_STATUS_CONTINUE5_BASE_IDX                                                     2
#define regDISP_INTERRUPT_STATUS_CONTINUE6                                                              0x0130
#define regDISP_INTERRUPT_STATUS_CONTINUE6_BASE_IDX                                                     2
#define regDISP_INTERRUPT_STATUS_CONTINUE7                                                              0x0131
#define regDISP_INTERRUPT_STATUS_CONTINUE7_BASE_IDX                                                     2
#define regDISP_INTERRUPT_STATUS_CONTINUE8                                                              0x0132
#define regDISP_INTERRUPT_STATUS_CONTINUE8_BASE_IDX                                                     2
#define regDISP_INTERRUPT_STATUS_CONTINUE9                                                              0x0133
#define regDISP_INTERRUPT_STATUS_CONTINUE9_BASE_IDX                                                     2
#define regDISP_INTERRUPT_STATUS_CONTINUE10                                                             0x0134
#define regDISP_INTERRUPT_STATUS_CONTINUE10_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE11                                                             0x0135
#define regDISP_INTERRUPT_STATUS_CONTINUE11_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE12                                                             0x0136
#define regDISP_INTERRUPT_STATUS_CONTINUE12_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE13                                                             0x0137
#define regDISP_INTERRUPT_STATUS_CONTINUE13_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE14                                                             0x0138
#define regDISP_INTERRUPT_STATUS_CONTINUE14_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE15                                                             0x0139
#define regDISP_INTERRUPT_STATUS_CONTINUE15_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE16                                                             0x013a
#define regDISP_INTERRUPT_STATUS_CONTINUE16_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE17                                                             0x013b
#define regDISP_INTERRUPT_STATUS_CONTINUE17_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE18                                                             0x013c
#define regDISP_INTERRUPT_STATUS_CONTINUE18_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE19                                                             0x013d
#define regDISP_INTERRUPT_STATUS_CONTINUE19_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE20                                                             0x013e
#define regDISP_INTERRUPT_STATUS_CONTINUE20_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE21                                                             0x013f
#define regDISP_INTERRUPT_STATUS_CONTINUE21_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE22                                                             0x0140
#define regDISP_INTERRUPT_STATUS_CONTINUE22_BASE_IDX                                                    2
#define regDC_GPU_TIMER_START_POSITION_VREADY                                                           0x0141
#define regDC_GPU_TIMER_START_POSITION_VREADY_BASE_IDX                                                  2
#define regDC_GPU_TIMER_START_POSITION_FLIP                                                             0x0142
#define regDC_GPU_TIMER_START_POSITION_FLIP_BASE_IDX                                                    2
#define regDC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK                                                 0x0143
#define regDC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK_BASE_IDX                                        2
#define regDC_GPU_TIMER_START_POSITION_FLIP_AWAY                                                        0x0144
#define regDC_GPU_TIMER_START_POSITION_FLIP_AWAY_BASE_IDX                                               2
#define regDISP_INTERRUPT_STATUS_CONTINUE23                                                             0x0145
#define regDISP_INTERRUPT_STATUS_CONTINUE23_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE24                                                             0x0146
#define regDISP_INTERRUPT_STATUS_CONTINUE24_BASE_IDX                                                    2
#define regDISP_INTERRUPT_STATUS_CONTINUE25                                                             0x0147
#define regDISP_INTERRUPT_STATUS_CONTINUE25_BASE_IDX                                                    2
#define regDCCG_INTERRUPT_DEST                                                                          0x0148
#define regDCCG_INTERRUPT_DEST_BASE_IDX                                                                 2
#define regDMU_INTERRUPT_DEST                                                                           0x0149
#define regDMU_INTERRUPT_DEST_BASE_IDX                                                                  2
#define regDMU_INTERRUPT_DEST2                                                                          0x014a
#define regDMU_INTERRUPT_DEST2_BASE_IDX                                                                 2
#define regDCPG_INTERRUPT_DEST                                                                          0x014b
#define regDCPG_INTERRUPT_DEST_BASE_IDX                                                                 2
#define regDCPG_INTERRUPT_DEST2                                                                         0x014c
#define regDCPG_INTERRUPT_DEST2_BASE_IDX                                                                2
#define regMMHUBBUB_INTERRUPT_DEST                                                                      0x014d
#define regMMHUBBUB_INTERRUPT_DEST_BASE_IDX                                                             2
#define regWB_INTERRUPT_DEST                                                                            0x014e
#define regWB_INTERRUPT_DEST_BASE_IDX                                                                   2
#define regDCHUB_INTERRUPT_DEST                                                                         0x014f
#define regDCHUB_INTERRUPT_DEST_BASE_IDX                                                                2
#define regDCHUB_PERFCOUNTER_INTERRUPT_DEST                                                             0x0150
#define regDCHUB_PERFCOUNTER_INTERRUPT_DEST_BASE_IDX                                                    2
#define regDCHUB_INTERRUPT_DEST2                                                                        0x0151
#define regDCHUB_INTERRUPT_DEST2_BASE_IDX                                                               2
#define regDPP_PERFCOUNTER_INTERRUPT_DEST                                                               0x0152
#define regDPP_PERFCOUNTER_INTERRUPT_DEST_BASE_IDX                                                      2
#define regMPC_INTERRUPT_DEST                                                                           0x0153
#define regMPC_INTERRUPT_DEST_BASE_IDX                                                                  2
#define regOPP_INTERRUPT_DEST                                                                           0x0154
#define regOPP_INTERRUPT_DEST_BASE_IDX                                                                  2
#define regOPTC_INTERRUPT_DEST                                                                          0x0155
#define regOPTC_INTERRUPT_DEST_BASE_IDX                                                                 2
#define regOTG0_INTERRUPT_DEST                                                                          0x0156
#define regOTG0_INTERRUPT_DEST_BASE_IDX                                                                 2
#define regOTG1_INTERRUPT_DEST                                                                          0x0157
#define regOTG1_INTERRUPT_DEST_BASE_IDX                                                                 2
#define regOTG2_INTERRUPT_DEST                                                                          0x0158
#define regOTG2_INTERRUPT_DEST_BASE_IDX                                                                 2
#define regOTG3_INTERRUPT_DEST                                                                          0x0159
#define regOTG3_INTERRUPT_DEST_BASE_IDX                                                                 2
#define regOTG4_INTERRUPT_DEST                                                                          0x015a
#define regOTG4_INTERRUPT_DEST_BASE_IDX                                                                 2
#define regOTG5_INTERRUPT_DEST                                                                          0x015b
#define regOTG5_INTERRUPT_DEST_BASE_IDX                                                                 2
#define regDIG_INTERRUPT_DEST                                                                           0x015c
#define regDIG_INTERRUPT_DEST_BASE_IDX                                                                  2
#define regI2C_DDC_HPD_INTERRUPT_DEST                                                                   0x015d
#define regI2C_DDC_HPD_INTERRUPT_DEST_BASE_IDX                                                          2
#define regDIO_INTERRUPT_DEST                                                                           0x015f
#define regDIO_INTERRUPT_DEST_BASE_IDX                                                                  2
#define regDCIO_INTERRUPT_DEST                                                                          0x0160
#define regDCIO_INTERRUPT_DEST_BASE_IDX                                                                 2
#define regHPD_INTERRUPT_DEST                                                                           0x0161
#define regHPD_INTERRUPT_DEST_BASE_IDX                                                                  2
#define regAZ_INTERRUPT_DEST                                                                            0x0162
#define regAZ_INTERRUPT_DEST_BASE_IDX                                                                   2
#define regAUX_INTERRUPT_DEST                                                                           0x0163
#define regAUX_INTERRUPT_DEST_BASE_IDX                                                                  2
#define regDSC_INTERRUPT_DEST                                                                           0x0164
#define regDSC_INTERRUPT_DEST_BASE_IDX                                                                  2
#define regHPO_INTERRUPT_DEST                                                                           0x0165
#define regHPO_INTERRUPT_DEST_BASE_IDX                                                                  2


// addressBlock: dce_dc_dmu_fgsec_dispdec
// base address: 0x0
#define regDMCUB_RBBMIF_SEC_CNTL                                                                        0x017a
#define regDMCUB_RBBMIF_SEC_CNTL_BASE_IDX                                                               2


// addressBlock: dce_dc_dmu_rbbmif_dispdec
// base address: 0x0
#define regRBBMIF_TIMEOUT                                                                               0x017f
#define regRBBMIF_TIMEOUT_BASE_IDX                                                                      2
#define regRBBMIF_STATUS                                                                                0x0180
#define regRBBMIF_STATUS_BASE_IDX                                                                       2
#define regRBBMIF_STATUS_2                                                                              0x0181
#define regRBBMIF_STATUS_2_BASE_IDX                                                                     2
#define regRBBMIF_INT_STATUS                                                                            0x0182
#define regRBBMIF_INT_STATUS_BASE_IDX                                                                   2
#define regRBBMIF_TIMEOUT_DIS                                                                           0x0183
#define regRBBMIF_TIMEOUT_DIS_BASE_IDX                                                                  2
#define regRBBMIF_TIMEOUT_DIS_2                                                                         0x0184
#define regRBBMIF_TIMEOUT_DIS_2_BASE_IDX                                                                2
#define regRBBMIF_STATUS_FLAG                                                                           0x0185
#define regRBBMIF_STATUS_FLAG_BASE_IDX                                                                  2


// addressBlock: dce_dc_dmu_dmcub_dispdec
// base address: 0x0
#define regDMCUB_REGION0_OFFSET                                                                         0x018e
#define regDMCUB_REGION0_OFFSET_BASE_IDX                                                                2
#define regDMCUB_REGION0_OFFSET_HIGH                                                                    0x018f
#define regDMCUB_REGION0_OFFSET_HIGH_BASE_IDX                                                           2
#define regDMCUB_REGION1_OFFSET                                                                         0x0190
#define regDMCUB_REGION1_OFFSET_BASE_IDX                                                                2
#define regDMCUB_REGION1_OFFSET_HIGH                                                                    0x0191
#define regDMCUB_REGION1_OFFSET_HIGH_BASE_IDX                                                           2
#define regDMCUB_REGION2_OFFSET                                                                         0x0192
#define regDMCUB_REGION2_OFFSET_BASE_IDX                                                                2
#define regDMCUB_REGION2_OFFSET_HIGH                                                                    0x0193
#define regDMCUB_REGION2_OFFSET_HIGH_BASE_IDX                                                           2
#define regDMCUB_REGION4_OFFSET                                                                         0x0196
#define regDMCUB_REGION4_OFFSET_BASE_IDX                                                                2
#define regDMCUB_REGION4_OFFSET_HIGH                                                                    0x0197
#define regDMCUB_REGION4_OFFSET_HIGH_BASE_IDX                                                           2
#define regDMCUB_REGION5_OFFSET                                                                         0x0198
#define regDMCUB_REGION5_OFFSET_BASE_IDX                                                                2
#define regDMCUB_REGION5_OFFSET_HIGH                                                                    0x0199
#define regDMCUB_REGION5_OFFSET_HIGH_BASE_IDX                                                           2
#define regDMCUB_REGION6_OFFSET                                                                         0x019a
#define regDMCUB_REGION6_OFFSET_BASE_IDX                                                                2
#define regDMCUB_REGION6_OFFSET_HIGH                                                                    0x019b
#define regDMCUB_REGION6_OFFSET_HIGH_BASE_IDX                                                           2
#define regDMCUB_REGION7_OFFSET                                                                         0x019c
#define regDMCUB_REGION7_OFFSET_BASE_IDX                                                                2
#define regDMCUB_REGION7_OFFSET_HIGH                                                                    0x019d
#define regDMCUB_REGION7_OFFSET_HIGH_BASE_IDX                                                           2
#define regDMCUB_REGION0_TOP_ADDRESS                                                                    0x019e
#define regDMCUB_REGION0_TOP_ADDRESS_BASE_IDX                                                           2
#define regDMCUB_REGION1_TOP_ADDRESS                                                                    0x019f
#define regDMCUB_REGION1_TOP_ADDRESS_BASE_IDX                                                           2
#define regDMCUB_REGION2_TOP_ADDRESS                                                                    0x01a0
#define regDMCUB_REGION2_TOP_ADDRESS_BASE_IDX                                                           2
#define regDMCUB_REGION4_TOP_ADDRESS                                                                    0x01a1
#define regDMCUB_REGION4_TOP_ADDRESS_BASE_IDX                                                           2
#define regDMCUB_REGION5_TOP_ADDRESS                                                                    0x01a2
#define regDMCUB_REGION5_TOP_ADDRESS_BASE_IDX                                                           2
#define regDMCUB_REGION6_TOP_ADDRESS                                                                    0x01a3
#define regDMCUB_REGION6_TOP_ADDRESS_BASE_IDX                                                           2
#define regDMCUB_REGION7_TOP_ADDRESS                                                                    0x01a4
#define regDMCUB_REGION7_TOP_ADDRESS_BASE_IDX                                                           2
#define regDMCUB_REGION3_CW0_BASE_ADDRESS                                                               0x01a5
#define regDMCUB_REGION3_CW0_BASE_ADDRESS_BASE_IDX                                                      2
#define regDMCUB_REGION3_CW1_BASE_ADDRESS                                                               0x01a6
#define regDMCUB_REGION3_CW1_BASE_ADDRESS_BASE_IDX                                                      2
#define regDMCUB_REGION3_CW2_BASE_ADDRESS                                                               0x01a7
#define regDMCUB_REGION3_CW2_BASE_ADDRESS_BASE_IDX                                                      2
#define regDMCUB_REGION3_CW3_BASE_ADDRESS                                                               0x01a8
#define regDMCUB_REGION3_CW3_BASE_ADDRESS_BASE_IDX                                                      2
#define regDMCUB_REGION3_CW4_BASE_ADDRESS                                                               0x01a9
#define regDMCUB_REGION3_CW4_BASE_ADDRESS_BASE_IDX                                                      2
#define regDMCUB_REGION3_CW5_BASE_ADDRESS                                                               0x01aa
#define regDMCUB_REGION3_CW5_BASE_ADDRESS_BASE_IDX                                                      2
#define regDMCUB_REGION3_CW6_BASE_ADDRESS                                                               0x01ab
#define regDMCUB_REGION3_CW6_BASE_ADDRESS_BASE_IDX                                                      2
#define regDMCUB_REGION3_CW7_BASE_ADDRESS                                                               0x01ac
#define regDMCUB_REGION3_CW7_BASE_ADDRESS_BASE_IDX                                                      2
#define regDMCUB_REGION3_CW0_TOP_ADDRESS                                                                0x01ad
#define regDMCUB_REGION3_CW0_TOP_ADDRESS_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW1_TOP_ADDRESS                                                                0x01ae
#define regDMCUB_REGION3_CW1_TOP_ADDRESS_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW2_TOP_ADDRESS                                                                0x01af
#define regDMCUB_REGION3_CW2_TOP_ADDRESS_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW3_TOP_ADDRESS                                                                0x01b0
#define regDMCUB_REGION3_CW3_TOP_ADDRESS_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW4_TOP_ADDRESS                                                                0x01b1
#define regDMCUB_REGION3_CW4_TOP_ADDRESS_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW5_TOP_ADDRESS                                                                0x01b2
#define regDMCUB_REGION3_CW5_TOP_ADDRESS_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW6_TOP_ADDRESS                                                                0x01b3
#define regDMCUB_REGION3_CW6_TOP_ADDRESS_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW7_TOP_ADDRESS                                                                0x01b4
#define regDMCUB_REGION3_CW7_TOP_ADDRESS_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW0_OFFSET                                                                     0x01b5
#define regDMCUB_REGION3_CW0_OFFSET_BASE_IDX                                                            2
#define regDMCUB_REGION3_CW0_OFFSET_HIGH                                                                0x01b6
#define regDMCUB_REGION3_CW0_OFFSET_HIGH_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW1_OFFSET                                                                     0x01b7
#define regDMCUB_REGION3_CW1_OFFSET_BASE_IDX                                                            2
#define regDMCUB_REGION3_CW1_OFFSET_HIGH                                                                0x01b8
#define regDMCUB_REGION3_CW1_OFFSET_HIGH_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW2_OFFSET                                                                     0x01b9
#define regDMCUB_REGION3_CW2_OFFSET_BASE_IDX                                                            2
#define regDMCUB_REGION3_CW2_OFFSET_HIGH                                                                0x01ba
#define regDMCUB_REGION3_CW2_OFFSET_HIGH_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW3_OFFSET                                                                     0x01bb
#define regDMCUB_REGION3_CW3_OFFSET_BASE_IDX                                                            2
#define regDMCUB_REGION3_CW3_OFFSET_HIGH                                                                0x01bc
#define regDMCUB_REGION3_CW3_OFFSET_HIGH_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW4_OFFSET                                                                     0x01bd
#define regDMCUB_REGION3_CW4_OFFSET_BASE_IDX                                                            2
#define regDMCUB_REGION3_CW4_OFFSET_HIGH                                                                0x01be
#define regDMCUB_REGION3_CW4_OFFSET_HIGH_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW5_OFFSET                                                                     0x01bf
#define regDMCUB_REGION3_CW5_OFFSET_BASE_IDX                                                            2
#define regDMCUB_REGION3_CW5_OFFSET_HIGH                                                                0x01c0
#define regDMCUB_REGION3_CW5_OFFSET_HIGH_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW6_OFFSET                                                                     0x01c1
#define regDMCUB_REGION3_CW6_OFFSET_BASE_IDX                                                            2
#define regDMCUB_REGION3_CW6_OFFSET_HIGH                                                                0x01c2
#define regDMCUB_REGION3_CW6_OFFSET_HIGH_BASE_IDX                                                       2
#define regDMCUB_REGION3_CW7_OFFSET                                                                     0x01c3
#define regDMCUB_REGION3_CW7_OFFSET_BASE_IDX                                                            2
#define regDMCUB_REGION3_CW7_OFFSET_HIGH                                                                0x01c4
#define regDMCUB_REGION3_CW7_OFFSET_HIGH_BASE_IDX                                                       2
#define regDMCUB_INTERRUPT_ENABLE                                                                       0x01c5
#define regDMCUB_INTERRUPT_ENABLE_BASE_IDX                                                              2
#define regDMCUB_INTERRUPT_ACK                                                                          0x01c6
#define regDMCUB_INTERRUPT_ACK_BASE_IDX                                                                 2
#define regDMCUB_INTERRUPT_STATUS                                                                       0x01c7
#define regDMCUB_INTERRUPT_STATUS_BASE_IDX                                                              2
#define regDMCUB_INTERRUPT_TYPE                                                                         0x01c8
#define regDMCUB_INTERRUPT_TYPE_BASE_IDX                                                                2
#define regDMCUB_EXT_INTERRUPT_STATUS                                                                   0x01c9
#define regDMCUB_EXT_INTERRUPT_STATUS_BASE_IDX                                                          2
#define regDMCUB_EXT_INTERRUPT_CTXID                                                                    0x01ca
#define regDMCUB_EXT_INTERRUPT_CTXID_BASE_IDX                                                           2
#define regDMCUB_EXT_INTERRUPT_ACK                                                                      0x01cb
#define regDMCUB_EXT_INTERRUPT_ACK_BASE_IDX                                                             2
#define regDMCUB_INST_FETCH_FAULT_ADDR                                                                  0x01cc
#define regDMCUB_INST_FETCH_FAULT_ADDR_BASE_IDX                                                         2
#define regDMCUB_DATA_WRITE_FAULT_ADDR                                                                  0x01cd
#define regDMCUB_DATA_WRITE_FAULT_ADDR_BASE_IDX                                                         2
#define regDMCUB_SEC_CNTL                                                                               0x01ce
#define regDMCUB_SEC_CNTL_BASE_IDX                                                                      2
#define regDMCUB_MEM_CNTL                                                                               0x01cf
#define regDMCUB_MEM_CNTL_BASE_IDX                                                                      2
#define regDMCUB_INBOX0_BASE_ADDRESS                                                                    0x01d0
#define regDMCUB_INBOX0_BASE_ADDRESS_BASE_IDX                                                           2
#define regDMCUB_INBOX0_SIZE                                                                            0x01d1
#define regDMCUB_INBOX0_SIZE_BASE_IDX                                                                   2
#define regDMCUB_INBOX0_WPTR                                                                            0x01d2
#define regDMCUB_INBOX0_WPTR_BASE_IDX                                                                   2
#define regDMCUB_INBOX0_RPTR                                                                            0x01d3
#define regDMCUB_INBOX0_RPTR_BASE_IDX                                                                   2
#define regDMCUB_INBOX1_BASE_ADDRESS                                                                    0x01d4
#define regDMCUB_INBOX1_BASE_ADDRESS_BASE_IDX                                                           2
#define regDMCUB_INBOX1_SIZE                                                                            0x01d5
#define regDMCUB_INBOX1_SIZE_BASE_IDX                                                                   2
#define regDMCUB_INBOX1_WPTR                                                                            0x01d6
#define regDMCUB_INBOX1_WPTR_BASE_IDX                                                                   2
#define regDMCUB_INBOX1_RPTR                                                                            0x01d7
#define regDMCUB_INBOX1_RPTR_BASE_IDX                                                                   2
#define regDMCUB_OUTBOX0_BASE_ADDRESS                                                                   0x01d8
#define regDMCUB_OUTBOX0_BASE_ADDRESS_BASE_IDX                                                          2
#define regDMCUB_OUTBOX0_SIZE                                                                           0x01d9
#define regDMCUB_OUTBOX0_SIZE_BASE_IDX                                                                  2
#define regDMCUB_OUTBOX0_WPTR                                                                           0x01da
#define regDMCUB_OUTBOX0_WPTR_BASE_IDX                                                                  2
#define regDMCUB_OUTBOX0_RPTR                                                                           0x01db
#define regDMCUB_OUTBOX0_RPTR_BASE_IDX                                                                  2
#define regDMCUB_OUTBOX1_BASE_ADDRESS                                                                   0x01dc
#define regDMCUB_OUTBOX1_BASE_ADDRESS_BASE_IDX                                                          2
#define regDMCUB_OUTBOX1_SIZE                                                                           0x01dd
#define regDMCUB_OUTBOX1_SIZE_BASE_IDX                                                                  2
#define regDMCUB_OUTBOX1_WPTR                                                                           0x01de
#define regDMCUB_OUTBOX1_WPTR_BASE_IDX                                                                  2
#define regDMCUB_OUTBOX1_RPTR                                                                           0x01df
#define regDMCUB_OUTBOX1_RPTR_BASE_IDX                                                                  2
#define regDMCUB_TIMER_TRIGGER0                                                                         0x01e0
#define regDMCUB_TIMER_TRIGGER0_BASE_IDX                                                                2
#define regDMCUB_TIMER_TRIGGER1                                                                         0x01e1
#define regDMCUB_TIMER_TRIGGER1_BASE_IDX                                                                2
#define regDMCUB_TIMER_WINDOW                                                                           0x01e2
#define regDMCUB_TIMER_WINDOW_BASE_IDX                                                                  2
#define regDMCUB_SCRATCH0                                                                               0x01e3
#define regDMCUB_SCRATCH0_BASE_IDX                                                                      2
#define regDMCUB_SCRATCH1                                                                               0x01e4
#define regDMCUB_SCRATCH1_BASE_IDX                                                                      2
#define regDMCUB_SCRATCH2                                                                               0x01e5
#define regDMCUB_SCRATCH2_BASE_IDX                                                                      2
#define regDMCUB_SCRATCH3                                                                               0x01e6
#define regDMCUB_SCRATCH3_BASE_IDX                                                                      2
#define regDMCUB_SCRATCH4                                                                               0x01e7
#define regDMCUB_SCRATCH4_BASE_IDX                                                                      2
#define regDMCUB_SCRATCH5                                                                               0x01e8
#define regDMCUB_SCRATCH5_BASE_IDX                                                                      2
#define regDMCUB_SCRATCH6                                                                               0x01e9
#define regDMCUB_SCRATCH6_BASE_IDX                                                                      2
#define regDMCUB_SCRATCH7                                                                               0x01ea
#define regDMCUB_SCRATCH7_BASE_IDX                                                                      2
#define regDMCUB_SCRATCH8                                                                               0x01eb
#define regDMCUB_SCRATCH8_BASE_IDX                                                                      2
#define regDMCUB_SCRATCH9                                                                               0x01ec
#define regDMCUB_SCRATCH9_BASE_IDX                                                                      2
#define regDMCUB_SCRATCH10                                                                              0x01ed
#define regDMCUB_SCRATCH10_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH11                                                                              0x01ee
#define regDMCUB_SCRATCH11_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH12                                                                              0x01ef
#define regDMCUB_SCRATCH12_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH13                                                                              0x01f0
#define regDMCUB_SCRATCH13_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH14                                                                              0x01f1
#define regDMCUB_SCRATCH14_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH15                                                                              0x01f2
#define regDMCUB_SCRATCH15_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH16                                                                              0x01f3
#define regDMCUB_SCRATCH16_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH17                                                                              0x01f4
#define regDMCUB_SCRATCH17_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH18                                                                              0x01f5
#define regDMCUB_SCRATCH18_BASE_IDX                                                                     2
#define regDMCUB_CNTL                                                                                   0x01f6
#define regDMCUB_CNTL_BASE_IDX                                                                          2
#define regDMCUB_GPINT_DATAIN0                                                                          0x01f7
#define regDMCUB_GPINT_DATAIN0_BASE_IDX                                                                 2
#define regDMCUB_GPINT_DATAIN1                                                                          0x01f8
#define regDMCUB_GPINT_DATAIN1_BASE_IDX                                                                 2
#define regDMCUB_GPINT_DATAOUT                                                                          0x01f9
#define regDMCUB_GPINT_DATAOUT_BASE_IDX                                                                 2
#define regDMCUB_UNDEFINED_ADDRESS_FAULT_ADDR                                                           0x01fa
#define regDMCUB_UNDEFINED_ADDRESS_FAULT_ADDR_BASE_IDX                                                  2
#define regDMCUB_LS_WAKE_INT_ENABLE                                                                     0x01fb
#define regDMCUB_LS_WAKE_INT_ENABLE_BASE_IDX                                                            2
#define regDMCUB_MEM_PWR_CNTL                                                                           0x01fc
#define regDMCUB_MEM_PWR_CNTL_BASE_IDX                                                                  2
#define regDMCUB_TIMER_CURRENT                                                                          0x01fd
#define regDMCUB_TIMER_CURRENT_BASE_IDX                                                                 2
#define regDMCUB_PROC_ID                                                                                0x01ff
#define regDMCUB_PROC_ID_BASE_IDX                                                                       2
#define regDMCUB_CNTL2                                                                                  0x0200
#define regDMCUB_CNTL2_BASE_IDX                                                                         2
#define regDMCUB_GPINT_DATAIN2                                                                          0x0215
#define regDMCUB_GPINT_DATAIN2_BASE_IDX                                                                 2
#define regDMCUB_GPINT_DATAIN3                                                                          0x0216
#define regDMCUB_GPINT_DATAIN3_BASE_IDX                                                                 2
#define regDMCUB_GPINT_DATAIN4                                                                          0x0217
#define regDMCUB_GPINT_DATAIN4_BASE_IDX                                                                 2
#define regDMCUB_GPINT_DATAIN5                                                                          0x0218
#define regDMCUB_GPINT_DATAIN5_BASE_IDX                                                                 2
#define regDMCUB_GPINT_DATAIN6                                                                          0x0219
#define regDMCUB_GPINT_DATAIN6_BASE_IDX                                                                 2
#define regDMCUB_REGION3_TMR_AXI_SPACE                                                                  0x021a
#define regDMCUB_REGION3_TMR_AXI_SPACE_BASE_IDX                                                         2
#define regDMCUB_SCRATCH19                                                                              0x022e
#define regDMCUB_SCRATCH19_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH20                                                                              0x022f
#define regDMCUB_SCRATCH20_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH21                                                                              0x0230
#define regDMCUB_SCRATCH21_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH22                                                                              0x0231
#define regDMCUB_SCRATCH22_BASE_IDX                                                                     2
#define regDMCUB_SCRATCH23                                                                              0x0232
#define regDMCUB_SCRATCH23_BASE_IDX                                                                     2


// addressBlock: dce_dc_mmhubbub_mcif_wb0_dispdec
// base address: 0x0
#define regMCIF_WB_BUFMGR_SW_CONTROL                                                                    0x0272
#define regMCIF_WB_BUFMGR_SW_CONTROL_BASE_IDX                                                           2
#define regMCIF_WB_BUFMGR_STATUS                                                                        0x0274
#define regMCIF_WB_BUFMGR_STATUS_BASE_IDX                                                               2
#define regMCIF_WB_BUF_PITCH                                                                            0x0275
#define regMCIF_WB_BUF_PITCH_BASE_IDX                                                                   2
#define regMCIF_WB_BUF_1_STATUS                                                                         0x0276
#define regMCIF_WB_BUF_1_STATUS_BASE_IDX                                                                2
#define regMCIF_WB_BUF_1_STATUS2                                                                        0x0277
#define regMCIF_WB_BUF_1_STATUS2_BASE_IDX                                                               2
#define regMCIF_WB_BUF_2_STATUS                                                                         0x0278
#define regMCIF_WB_BUF_2_STATUS_BASE_IDX                                                                2
#define regMCIF_WB_BUF_2_STATUS2                                                                        0x0279
#define regMCIF_WB_BUF_2_STATUS2_BASE_IDX                                                               2
#define regMCIF_WB_BUF_3_STATUS                                                                         0x027a
#define regMCIF_WB_BUF_3_STATUS_BASE_IDX                                                                2
#define regMCIF_WB_BUF_3_STATUS2                                                                        0x027b
#define regMCIF_WB_BUF_3_STATUS2_BASE_IDX                                                               2
#define regMCIF_WB_BUF_4_STATUS                                                                         0x027c
#define regMCIF_WB_BUF_4_STATUS_BASE_IDX                                                                2
#define regMCIF_WB_BUF_4_STATUS2                                                                        0x027d
#define regMCIF_WB_BUF_4_STATUS2_BASE_IDX                                                               2
#define regMCIF_WB_ARBITRATION_CONTROL                                                                  0x027e
#define regMCIF_WB_ARBITRATION_CONTROL_BASE_IDX                                                         2
#define regMCIF_WB_SCLK_CHANGE                                                                          0x027f
#define regMCIF_WB_SCLK_CHANGE_BASE_IDX                                                                 2
#define regMCIF_WB_BUF_1_ADDR_Y                                                                         0x0282
#define regMCIF_WB_BUF_1_ADDR_Y_BASE_IDX                                                                2
#define regMCIF_WB_BUF_1_ADDR_C                                                                         0x0284
#define regMCIF_WB_BUF_1_ADDR_C_BASE_IDX                                                                2
#define regMCIF_WB_BUF_2_ADDR_Y                                                                         0x0286
#define regMCIF_WB_BUF_2_ADDR_Y_BASE_IDX                                                                2
#define regMCIF_WB_BUF_2_ADDR_C                                                                         0x0288
#define regMCIF_WB_BUF_2_ADDR_C_BASE_IDX                                                                2
#define regMCIF_WB_BUF_3_ADDR_Y                                                                         0x028a
#define regMCIF_WB_BUF_3_ADDR_Y_BASE_IDX                                                                2
#define regMCIF_WB_BUF_3_ADDR_C                                                                         0x028c
#define regMCIF_WB_BUF_3_ADDR_C_BASE_IDX                                                                2
#define regMCIF_WB_BUF_4_ADDR_Y                                                                         0x028e
#define regMCIF_WB_BUF_4_ADDR_Y_BASE_IDX                                                                2
#define regMCIF_WB_BUF_4_ADDR_C                                                                         0x0290
#define regMCIF_WB_BUF_4_ADDR_C_BASE_IDX                                                                2
#define regMCIF_WB_BUFMGR_VCE_CONTROL                                                                   0x0292
#define regMCIF_WB_BUFMGR_VCE_CONTROL_BASE_IDX                                                          2
#define regMCIF_WB_NB_PSTATE_CONTROL                                                                    0x0293
#define regMCIF_WB_NB_PSTATE_CONTROL_BASE_IDX                                                           2
#define regMCIF_WB_CLOCK_GATER_CONTROL                                                                  0x0294
#define regMCIF_WB_CLOCK_GATER_CONTROL_BASE_IDX                                                         2
#define regMCIF_WB_SELF_REFRESH_CONTROL                                                                 0x0296
#define regMCIF_WB_SELF_REFRESH_CONTROL_BASE_IDX                                                        2
#define regMULTI_LEVEL_QOS_CTRL                                                                         0x0297
#define regMULTI_LEVEL_QOS_CTRL_BASE_IDX                                                                2
#define regMCIF_WB_SECURITY_LEVEL                                                                       0x0298
#define regMCIF_WB_SECURITY_LEVEL_BASE_IDX                                                              2
#define regMCIF_WB_BUF_LUMA_SIZE                                                                        0x0299
#define regMCIF_WB_BUF_LUMA_SIZE_BASE_IDX                                                               2
#define regMCIF_WB_BUF_CHROMA_SIZE                                                                      0x029a
#define regMCIF_WB_BUF_CHROMA_SIZE_BASE_IDX                                                             2
#define regMCIF_WB_BUF_1_ADDR_Y_HIGH                                                                    0x029b
#define regMCIF_WB_BUF_1_ADDR_Y_HIGH_BASE_IDX                                                           2
#define regMCIF_WB_BUF_1_ADDR_C_HIGH                                                                    0x029c
#define regMCIF_WB_BUF_1_ADDR_C_HIGH_BASE_IDX                                                           2
#define regMCIF_WB_BUF_2_ADDR_Y_HIGH                                                                    0x029d
#define regMCIF_WB_BUF_2_ADDR_Y_HIGH_BASE_IDX                                                           2
#define regMCIF_WB_BUF_2_ADDR_C_HIGH                                                                    0x029e
#define regMCIF_WB_BUF_2_ADDR_C_HIGH_BASE_IDX                                                           2
#define regMCIF_WB_BUF_3_ADDR_Y_HIGH                                                                    0x029f
#define regMCIF_WB_BUF_3_ADDR_Y_HIGH_BASE_IDX                                                           2
#define regMCIF_WB_BUF_3_ADDR_C_HIGH                                                                    0x02a0
#define regMCIF_WB_BUF_3_ADDR_C_HIGH_BASE_IDX                                                           2
#define regMCIF_WB_BUF_4_ADDR_Y_HIGH                                                                    0x02a1
#define regMCIF_WB_BUF_4_ADDR_Y_HIGH_BASE_IDX                                                           2
#define regMCIF_WB_BUF_4_ADDR_C_HIGH                                                                    0x02a2
#define regMCIF_WB_BUF_4_ADDR_C_HIGH_BASE_IDX                                                           2
#define regMCIF_WB_BUF_1_RESOLUTION                                                                     0x02a3
#define regMCIF_WB_BUF_1_RESOLUTION_BASE_IDX                                                            2
#define regMCIF_WB_BUF_2_RESOLUTION                                                                     0x02a4
#define regMCIF_WB_BUF_2_RESOLUTION_BASE_IDX                                                            2
#define regMCIF_WB_BUF_3_RESOLUTION                                                                     0x02a5
#define regMCIF_WB_BUF_3_RESOLUTION_BASE_IDX                                                            2
#define regMCIF_WB_BUF_4_RESOLUTION                                                                     0x02a6
#define regMCIF_WB_BUF_4_RESOLUTION_BASE_IDX                                                            2
#define regMCIF_WB_PSTATE_CHANGE_DURATION_VBI                                                           0x02a7
#define regMCIF_WB_PSTATE_CHANGE_DURATION_VBI_BASE_IDX                                                  2
#define regMCIF_WB_VMID_CONTROL                                                                         0x02a8
#define regMCIF_WB_VMID_CONTROL_BASE_IDX                                                                2
#define regMCIF_WB_MIN_TTO                                                                              0x02a9
#define regMCIF_WB_MIN_TTO_BASE_IDX                                                                     2


// addressBlock: dce_dc_mmhubbub_mmhubbub_dispdec
// base address: 0x0
#define regMCIF_WB_NB_PSTATE_LATENCY_WATERMARK                                                          0x02aa
#define regMCIF_WB_NB_PSTATE_LATENCY_WATERMARK_BASE_IDX                                                 2
#define regMCIF_WB_WATERMARK                                                                            0x02ab
#define regMCIF_WB_WATERMARK_BASE_IDX                                                                   2
#define regMMHUBBUB_WARMUP_CONFIG                                                                       0x02ac
#define regMMHUBBUB_WARMUP_CONFIG_BASE_IDX                                                              2
#define regMMHUBBUB_WARMUP_CONTROL_STATUS                                                               0x02ad
#define regMMHUBBUB_WARMUP_CONTROL_STATUS_BASE_IDX                                                      2
#define regMMHUBBUB_WARMUP_BASE_ADDR_LOW                                                                0x02ae
#define regMMHUBBUB_WARMUP_BASE_ADDR_LOW_BASE_IDX                                                       2
#define regMMHUBBUB_WARMUP_BASE_ADDR_HIGH                                                               0x02af
#define regMMHUBBUB_WARMUP_BASE_ADDR_HIGH_BASE_IDX                                                      2
#define regMMHUBBUB_WARMUP_ADDR_REGION                                                                  0x02b0
#define regMMHUBBUB_WARMUP_ADDR_REGION_BASE_IDX                                                         2
#define regMMHUBBUB_MIN_TTO                                                                             0x02b1
#define regMMHUBBUB_MIN_TTO_BASE_IDX                                                                    2
#define regMMHUBBUB_CTRL                                                                                0x0333
#define regMMHUBBUB_CTRL_BASE_IDX                                                                       2
#define regWBIF_SMU_WM_CONTROL                                                                          0x0334
#define regWBIF_SMU_WM_CONTROL_BASE_IDX                                                                 2
#define regWBIF0_MISC_CTRL                                                                              0x0335
#define regWBIF0_MISC_CTRL_BASE_IDX                                                                     2
#define regWBIF0_PHASE0_OUTSTANDING_COUNTER                                                             0x0336
#define regWBIF0_PHASE0_OUTSTANDING_COUNTER_BASE_IDX                                                    2
#define regWBIF0_PHASE1_OUTSTANDING_COUNTER                                                             0x0337
#define regWBIF0_PHASE1_OUTSTANDING_COUNTER_BASE_IDX                                                    2
#define regMMHUBBUB_MEM_PWR_STATUS                                                                      0x033e
#define regMMHUBBUB_MEM_PWR_STATUS_BASE_IDX                                                             2
#define regMMHUBBUB_MEM_PWR_CNTL                                                                        0x033f
#define regMMHUBBUB_MEM_PWR_CNTL_BASE_IDX                                                               2
#define regMMHUBBUB_CLOCK_CNTL                                                                          0x0340
#define regMMHUBBUB_CLOCK_CNTL_BASE_IDX                                                                 2
#define regMMHUBBUB_SOFT_RESET                                                                          0x0341
#define regMMHUBBUB_SOFT_RESET_BASE_IDX                                                                 2
#define regDMU_IF_ERR_STATUS                                                                            0x0345
#define regDMU_IF_ERR_STATUS_BASE_IDX                                                                   2
#define regMMHUBBUB_CLIENT_UNIT_ID                                                                      0x0346
#define regMMHUBBUB_CLIENT_UNIT_ID_BASE_IDX                                                             2
#define regMMHUBBUB_WARMUP_VMID_CONTROL                                                                 0x0348
#define regMMHUBBUB_WARMUP_VMID_CONTROL_BASE_IDX                                                        2


// addressBlock: dce_dc_mmhubbub_mmhubbub_dcperfmon_dc_perfmon_dispdec
// base address: 0xd48
#define regDC_PERFMON4_PERFCOUNTER_CNTL                                                                 0x0352
#define regDC_PERFMON4_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define regDC_PERFMON4_PERFCOUNTER_CNTL2                                                                0x0353
#define regDC_PERFMON4_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define regDC_PERFMON4_PERFCOUNTER_STATE                                                                0x0354
#define regDC_PERFMON4_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define regDC_PERFMON4_PERFMON_CNTL                                                                     0x0355
#define regDC_PERFMON4_PERFMON_CNTL_BASE_IDX                                                            2
#define regDC_PERFMON4_PERFMON_CNTL2                                                                    0x0356
#define regDC_PERFMON4_PERFMON_CNTL2_BASE_IDX                                                           2
#define regDC_PERFMON4_PERFMON_CVALUE_INT_MISC                                                          0x0357
#define regDC_PERFMON4_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define regDC_PERFMON4_PERFMON_CVALUE_LOW                                                               0x0358
#define regDC_PERFMON4_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define regDC_PERFMON4_PERFMON_HI                                                                       0x0359
#define regDC_PERFMON4_PERFMON_HI_BASE_IDX                                                              2
#define regDC_PERFMON4_PERFMON_LOW                                                                      0x035a
#define regDC_PERFMON4_PERFMON_LOW_BASE_IDX                                                             2




// addressBlock: dce_dc_hda_azf0stream0_dispdec
// base address: 0x0
#define regAZF0STREAM0_AZALIA_STREAM_INDEX                                                              0x035e
#define regAZF0STREAM0_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define regAZF0STREAM0_AZALIA_STREAM_DATA                                                               0x035f
#define regAZF0STREAM0_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream1_dispdec
// base address: 0x8
#define regAZF0STREAM1_AZALIA_STREAM_INDEX                                                              0x0360
#define regAZF0STREAM1_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define regAZF0STREAM1_AZALIA_STREAM_DATA                                                               0x0361
#define regAZF0STREAM1_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream2_dispdec
// base address: 0x10
#define regAZF0STREAM2_AZALIA_STREAM_INDEX                                                              0x0362
#define regAZF0STREAM2_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define regAZF0STREAM2_AZALIA_STREAM_DATA                                                               0x0363
#define regAZF0STREAM2_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream3_dispdec
// base address: 0x18
#define regAZF0STREAM3_AZALIA_STREAM_INDEX                                                              0x0364
#define regAZF0STREAM3_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define regAZF0STREAM3_AZALIA_STREAM_DATA                                                               0x0365
#define regAZF0STREAM3_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream4_dispdec
// base address: 0x20
#define regAZF0STREAM4_AZALIA_STREAM_INDEX                                                              0x0366
#define regAZF0STREAM4_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define regAZF0STREAM4_AZALIA_STREAM_DATA                                                               0x0367
#define regAZF0STREAM4_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream5_dispdec
// base address: 0x28
#define regAZF0STREAM5_AZALIA_STREAM_INDEX                                                              0x0368
#define regAZF0STREAM5_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define regAZF0STREAM5_AZALIA_STREAM_DATA                                                               0x0369
#define regAZF0STREAM5_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream6_dispdec
// base address: 0x30
#define regAZF0STREAM6_AZALIA_STREAM_INDEX                                                              0x036a
#define regAZF0STREAM6_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define regAZF0STREAM6_AZALIA_STREAM_DATA                                                               0x036b
#define regAZF0STREAM6_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream7_dispdec
// base address: 0x38
#define regAZF0STREAM7_AZALIA_STREAM_INDEX                                                              0x036c
#define regAZF0STREAM7_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define regAZF0STREAM7_AZALIA_STREAM_DATA                                                               0x036d
#define regAZF0STREAM7_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_az_misc_dispdec
// base address: 0x0
#define regAZ_CLOCK_CNTL                                                                                0x0372
#define regAZ_CLOCK_CNTL_BASE_IDX                                                                       2
#define regAZ_MEM_GLOBAL_PWR_REQ_CNTL                                                                   0x0373
#define regAZ_MEM_GLOBAL_PWR_REQ_CNTL_BASE_IDX                                                          2

// addressBlock: dce_dc_hda_az_dcperfmon_dc_perfmon_dispdec
// base address: 0xde8
#define regDC_PERFMON5_PERFCOUNTER_CNTL                                                                 0x037a
#define regDC_PERFMON5_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define regDC_PERFMON5_PERFCOUNTER_CNTL2                                                                0x037b
#define regDC_PERFMON5_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define regDC_PERFMON5_PERFCOUNTER_STATE                                                                0x037c
#define regDC_PERFMON5_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define regDC_PERFMON5_PERFMON_CNTL                                                                     0x037d
#define regDC_PERFMON5_PERFMON_CNTL_BASE_IDX                                                            2
#define regDC_PERFMON5_PERFMON_CNTL2                                                                    0x037e
#define regDC_PERFMON5_PERFMON_CNTL2_BASE_IDX                                                           2
#define regDC_PERFMON5_PERFMON_CVALUE_INT_MISC                                                          0x037f
#define regDC_PERFMON5_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define regDC_PERFMON5_PERFMON_CVALUE_LOW                                                               0x0380
#define regDC_PERFMON5_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define regDC_PERFMON5_PERFMON_HI                                                                       0x0381
#define regDC_PERFMON5_PERFMON_HI_BASE_IDX                                                              2
#define regDC_PERFMON5_PERFMON_LOW                                                                      0x0382
#define regDC_PERFMON5_PERFMON_LOW_BASE_IDX                                                             2



// addressBlock: dce_dc_hda_azf0endpoint0_dispdec
// base address: 0x0
#define regAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0386
#define regAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define regAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0387
#define regAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint1_dispdec
// base address: 0x18
#define regAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x038c
#define regAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define regAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x038d
#define regAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint2_dispdec
// base address: 0x30
#define regAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0392
#define regAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define regAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0393
#define regAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint3_dispdec
// base address: 0x48
#define regAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0398
#define regAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define regAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0399
#define regAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint4_dispdec
// base address: 0x60
#define regAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x039e
#define regAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define regAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x039f
#define regAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint5_dispdec
// base address: 0x78
#define regAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x03a4
#define regAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define regAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x03a5
#define regAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint6_dispdec
// base address: 0x90
#define regAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x03aa
#define regAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define regAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x03ab
#define regAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint7_dispdec
// base address: 0xa8
#define regAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x03b0
#define regAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define regAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x03b1
#define regAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0controller_dispdec
// base address: 0x0
#define regAZALIA_CONTROLLER_CLOCK_GATING                                                               0x03c2
#define regAZALIA_CONTROLLER_CLOCK_GATING_BASE_IDX                                                      2
#define regAZALIA_AUDIO_DTO                                                                             0x03c3
#define regAZALIA_AUDIO_DTO_BASE_IDX                                                                    2
#define regAZALIA_AUDIO_DTO_CONTROL                                                                     0x03c4
#define regAZALIA_AUDIO_DTO_CONTROL_BASE_IDX                                                            2
#define regAZALIA_SOCCLK_CONTROL                                                                        0x03c5
#define regAZALIA_SOCCLK_CONTROL_BASE_IDX                                                               2
#define regAZALIA_UNDERFLOW_FILLER_SAMPLE                                                               0x03c6
#define regAZALIA_UNDERFLOW_FILLER_SAMPLE_BASE_IDX                                                      2
#define regAZALIA_DATA_DMA_CONTROL                                                                      0x03c7
#define regAZALIA_DATA_DMA_CONTROL_BASE_IDX                                                             2
#define regAZALIA_BDL_DMA_CONTROL                                                                       0x03c8
#define regAZALIA_BDL_DMA_CONTROL_BASE_IDX                                                              2
#define regAZALIA_RIRB_AND_DP_CONTROL                                                                   0x03c9
#define regAZALIA_RIRB_AND_DP_CONTROL_BASE_IDX                                                          2
#define regAZALIA_CORB_DMA_CONTROL                                                                      0x03ca
#define regAZALIA_CORB_DMA_CONTROL_BASE_IDX                                                             2
#define regAZALIA_GLOBAL_CAPABILITIES                                                                   0x03d3
#define regAZALIA_GLOBAL_CAPABILITIES_BASE_IDX                                                          2
#define regAZALIA_OUTPUT_PAYLOAD_CAPABILITY                                                             0x03d4
#define regAZALIA_OUTPUT_PAYLOAD_CAPABILITY_BASE_IDX                                                    2
#define regAZALIA_OUTPUT_STREAM_ARBITER_CONTROL                                                         0x03d5
#define regAZALIA_OUTPUT_STREAM_ARBITER_CONTROL_BASE_IDX                                                2
#define regAZALIA_INPUT_PAYLOAD_CAPABILITY                                                              0x03d6
#define regAZALIA_INPUT_PAYLOAD_CAPABILITY_BASE_IDX                                                     2
#define regAZALIA_INPUT_CRC0_CONTROL0                                                                   0x03d9
#define regAZALIA_INPUT_CRC0_CONTROL0_BASE_IDX                                                          2
#define regAZALIA_INPUT_CRC0_CONTROL1                                                                   0x03da
#define regAZALIA_INPUT_CRC0_CONTROL1_BASE_IDX                                                          2
#define regAZALIA_INPUT_CRC0_CONTROL2                                                                   0x03db
#define regAZALIA_INPUT_CRC0_CONTROL2_BASE_IDX                                                          2
#define regAZALIA_INPUT_CRC0_CONTROL3                                                                   0x03dc
#define regAZALIA_INPUT_CRC0_CONTROL3_BASE_IDX                                                          2
#define regAZALIA_INPUT_CRC0_RESULT                                                                     0x03dd
#define regAZALIA_INPUT_CRC0_RESULT_BASE_IDX                                                            2
#define regAZALIA_INPUT_CRC1_CONTROL0                                                                   0x03de
#define regAZALIA_INPUT_CRC1_CONTROL0_BASE_IDX                                                          2
#define regAZALIA_INPUT_CRC1_CONTROL1                                                                   0x03df
#define regAZALIA_INPUT_CRC1_CONTROL1_BASE_IDX                                                          2
#define regAZALIA_INPUT_CRC1_CONTROL2                                                                   0x03e0
#define regAZALIA_INPUT_CRC1_CONTROL2_BASE_IDX                                                          2
#define regAZALIA_INPUT_CRC1_CONTROL3                                                                   0x03e1
#define regAZALIA_INPUT_CRC1_CONTROL3_BASE_IDX                                                          2
#define regAZALIA_INPUT_CRC1_RESULT                                                                     0x03e2
#define regAZALIA_INPUT_CRC1_RESULT_BASE_IDX                                                            2
#define regAZALIA_CRC0_CONTROL0                                                                         0x03e3
#define regAZALIA_CRC0_CONTROL0_BASE_IDX                                                                2
#define regAZALIA_CRC0_CONTROL1                                                                         0x03e4
#define regAZALIA_CRC0_CONTROL1_BASE_IDX                                                                2
#define regAZALIA_CRC0_CONTROL2                                                                         0x03e5
#define regAZALIA_CRC0_CONTROL2_BASE_IDX                                                                2
#define regAZALIA_CRC0_CONTROL3                                                                         0x03e6
#define regAZALIA_CRC0_CONTROL3_BASE_IDX                                                                2
#define regAZALIA_CRC0_RESULT                                                                           0x03e7
#define regAZALIA_CRC0_RESULT_BASE_IDX                                                                  2
#define regAZALIA_CRC1_CONTROL0                                                                         0x03e8
#define regAZALIA_CRC1_CONTROL0_BASE_IDX                                                                2
#define regAZALIA_CRC1_CONTROL1                                                                         0x03e9
#define regAZALIA_CRC1_CONTROL1_BASE_IDX                                                                2
#define regAZALIA_CRC1_CONTROL2                                                                         0x03ea
#define regAZALIA_CRC1_CONTROL2_BASE_IDX                                                                2
#define regAZALIA_CRC1_CONTROL3                                                                         0x03eb
#define regAZALIA_CRC1_CONTROL3_BASE_IDX                                                                2
#define regAZALIA_CRC1_RESULT                                                                           0x03ec
#define regAZALIA_CRC1_RESULT_BASE_IDX                                                                  2
#define regAZALIA_MEM_PWR_CTRL                                                                          0x03ee
#define regAZALIA_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define regAZALIA_MEM_PWR_STATUS                                                                        0x03ef
#define regAZALIA_MEM_PWR_STATUS_BASE_IDX                                                               2



// addressBlock: dce_dc_hda_azf0root_dispdec
// base address: 0x0
#define regAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID                                          0x0406
#define regAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID_BASE_IDX                                 2
#define regAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID                                                   0x0407
#define regAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID_BASE_IDX                                          2
#define regAZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL                                                        0x0408
#define regAZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL_BASE_IDX                                               2
#define regAZALIA_F0_CODEC_RESYNC_FIFO_CONTROL                                                          0x0409
#define regAZALIA_F0_CODEC_RESYNC_FIFO_CONTROL_BASE_IDX                                                 2
#define regAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE                                                0x040a
#define regAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE_BASE_IDX                                       2
#define regAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES                                      0x040b
#define regAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES_BASE_IDX                             2
#define regAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS                                            0x040c
#define regAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS_BASE_IDX                                   2
#define regAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES                                              0x040d
#define regAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES_BASE_IDX                                     2
#define regAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE                                                 0x040e
#define regAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE_BASE_IDX                                        2
#define regAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET                                                       0x040f
#define regAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET_BASE_IDX                                              2
#define regAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID                                       0x0410
#define regAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_BASE_IDX                              2
#define regAZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION                                   0x0411
#define regAZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION_BASE_IDX                          2
#define regCC_RCU_DC_AUDIO_PORT_CONNECTIVITY                                                            0x0412
#define regCC_RCU_DC_AUDIO_PORT_CONNECTIVITY_BASE_IDX                                                   2
#define regCC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY                                                      0x0413
#define regCC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_BASE_IDX                                             2
#define regAZALIA_F0_GTC_GROUP_OFFSET0                                                                  0x0415
#define regAZALIA_F0_GTC_GROUP_OFFSET0_BASE_IDX                                                         2
#define regAZALIA_F0_GTC_GROUP_OFFSET1                                                                  0x0416
#define regAZALIA_F0_GTC_GROUP_OFFSET1_BASE_IDX                                                         2
#define regAZALIA_F0_GTC_GROUP_OFFSET2                                                                  0x0417
#define regAZALIA_F0_GTC_GROUP_OFFSET2_BASE_IDX                                                         2
#define regAZALIA_F0_GTC_GROUP_OFFSET3                                                                  0x0418
#define regAZALIA_F0_GTC_GROUP_OFFSET3_BASE_IDX                                                         2
#define regAZALIA_F0_GTC_GROUP_OFFSET4                                                                  0x0419
#define regAZALIA_F0_GTC_GROUP_OFFSET4_BASE_IDX                                                         2
#define regAZALIA_F0_GTC_GROUP_OFFSET5                                                                  0x041a
#define regAZALIA_F0_GTC_GROUP_OFFSET5_BASE_IDX                                                         2
#define regAZALIA_F0_GTC_GROUP_OFFSET6                                                                  0x041b
#define regAZALIA_F0_GTC_GROUP_OFFSET6_BASE_IDX                                                         2
#define regREG_DC_AUDIO_PORT_CONNECTIVITY                                                               0x041c
#define regREG_DC_AUDIO_PORT_CONNECTIVITY_BASE_IDX                                                      2
#define regREG_DC_AUDIO_INPUT_PORT_CONNECTIVITY                                                         0x041d
#define regREG_DC_AUDIO_INPUT_PORT_CONNECTIVITY_BASE_IDX                                                2



// addressBlock: dce_dc_hda_azf0stream8_dispdec
// base address: 0x320
#define regAZF0STREAM8_AZALIA_STREAM_INDEX                                                              0x0426
#define regAZF0STREAM8_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define regAZF0STREAM8_AZALIA_STREAM_DATA                                                               0x0427
#define regAZF0STREAM8_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream9_dispdec
// base address: 0x328
#define regAZF0STREAM9_AZALIA_STREAM_INDEX                                                              0x0428
#define regAZF0STREAM9_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define regAZF0STREAM9_AZALIA_STREAM_DATA                                                               0x0429
#define regAZF0STREAM9_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream10_dispdec
// base address: 0x330
#define regAZF0STREAM10_AZALIA_STREAM_INDEX                                                             0x042a
#define regAZF0STREAM10_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define regAZF0STREAM10_AZALIA_STREAM_DATA                                                              0x042b
#define regAZF0STREAM10_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream11_dispdec
// base address: 0x338
#define regAZF0STREAM11_AZALIA_STREAM_INDEX                                                             0x042c
#define regAZF0STREAM11_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define regAZF0STREAM11_AZALIA_STREAM_DATA                                                              0x042d
#define regAZF0STREAM11_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream12_dispdec
// base address: 0x340
#define regAZF0STREAM12_AZALIA_STREAM_INDEX                                                             0x042e
#define regAZF0STREAM12_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define regAZF0STREAM12_AZALIA_STREAM_DATA                                                              0x042f
#define regAZF0STREAM12_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream13_dispdec
// base address: 0x348
#define regAZF0STREAM13_AZALIA_STREAM_INDEX                                                             0x0430
#define regAZF0STREAM13_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define regAZF0STREAM13_AZALIA_STREAM_DATA                                                              0x0431
#define regAZF0STREAM13_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream14_dispdec
// base address: 0x350
#define regAZF0STREAM14_AZALIA_STREAM_INDEX                                                             0x0432
#define regAZF0STREAM14_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define regAZF0STREAM14_AZALIA_STREAM_DATA                                                              0x0433
#define regAZF0STREAM14_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream15_dispdec
// base address: 0x358
#define regAZF0STREAM15_AZALIA_STREAM_INDEX                                                             0x0434
#define regAZF0STREAM15_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define regAZF0STREAM15_AZALIA_STREAM_DATA                                                              0x0435
#define regAZF0STREAM15_AZALIA_STREAM_DATA_BASE_IDX                                                     2



// addressBlock: dce_dc_hda_azf0inputendpoint0_dispdec
// base address: 0x0
#define regAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x043a
#define regAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define regAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x043b
#define regAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint1_dispdec
// base address: 0x10
#define regAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x043e
#define regAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define regAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x043f
#define regAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint2_dispdec
// base address: 0x20
#define regAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0442
#define regAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define regAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0443
#define regAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint3_dispdec
// base address: 0x30
#define regAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0446
#define regAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define regAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0447
#define regAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint4_dispdec
// base address: 0x40
#define regAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x044a
#define regAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define regAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x044b
#define regAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint5_dispdec
// base address: 0x50
#define regAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x044e
#define regAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define regAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x044f
#define regAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint6_dispdec
// base address: 0x60
#define regAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0452
#define regAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define regAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0453
#define regAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint7_dispdec
// base address: 0x70
#define regAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0456
#define regAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define regAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0457
#define regAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2



// addressBlock: dce_dc_dchubbubl_hubbub_sdpif_dispdec
// base address: 0x0
#define regDCHUBBUB_SDPIF_CFG0                                                                          0x046f
#define regDCHUBBUB_SDPIF_CFG0_BASE_IDX                                                                 2
#define regDCHUBBUB_SDPIF_CFG1                                                                          0x0470
#define regDCHUBBUB_SDPIF_CFG1_BASE_IDX                                                                 2
#define regDCHUBBUB_SDPIF_CFG2                                                                          0x0471
#define regDCHUBBUB_SDPIF_CFG2_BASE_IDX                                                                 2
#define regVM_REQUEST_PHYSICAL                                                                          0x0472
#define regVM_REQUEST_PHYSICAL_BASE_IDX                                                                 2
#define regDCHUBBUB_FORCE_IO_STATUS_0                                                                   0x0473
#define regDCHUBBUB_FORCE_IO_STATUS_0_BASE_IDX                                                          2
#define regDCHUBBUB_FORCE_IO_STATUS_1                                                                   0x0474
#define regDCHUBBUB_FORCE_IO_STATUS_1_BASE_IDX                                                          2
#define regDCN_VM_FB_LOCATION_BASE                                                                      0x0475
#define regDCN_VM_FB_LOCATION_BASE_BASE_IDX                                                             2
#define regDCN_VM_FB_LOCATION_TOP                                                                       0x0476
#define regDCN_VM_FB_LOCATION_TOP_BASE_IDX                                                              2
#define regDCN_VM_FB_OFFSET                                                                             0x0477
#define regDCN_VM_FB_OFFSET_BASE_IDX                                                                    2
#define regDCN_VM_AGP_BOT                                                                               0x0478
#define regDCN_VM_AGP_BOT_BASE_IDX                                                                      2
#define regDCN_VM_AGP_TOP                                                                               0x0479
#define regDCN_VM_AGP_TOP_BASE_IDX                                                                      2
#define regDCN_VM_AGP_BASE                                                                              0x047a
#define regDCN_VM_AGP_BASE_BASE_IDX                                                                     2
#define regDCN_VM_LOCAL_HBM_ADDRESS_START                                                               0x047b
#define regDCN_VM_LOCAL_HBM_ADDRESS_START_BASE_IDX                                                      2
#define regDCN_VM_LOCAL_HBM_ADDRESS_END                                                                 0x047c
#define regDCN_VM_LOCAL_HBM_ADDRESS_END_BASE_IDX                                                        2
#define regDCN_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL                                                           0x047d
#define regDCN_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL_BASE_IDX                                                  2
#define regDCHUBBUB_SDPIF_PIPE_SEC_LVL                                                                  0x047e
#define regDCHUBBUB_SDPIF_PIPE_SEC_LVL_BASE_IDX                                                         2
#define regDCHUBBUB_SDPIF_PIPE_NOALLOC                                                                  0x047f
#define regDCHUBBUB_SDPIF_PIPE_NOALLOC_BASE_IDX                                                         2
#define regDCHUBBUB_SDPIF_PIPE_DMDATA_SEC_LVL                                                           0x0480
#define regDCHUBBUB_SDPIF_PIPE_DMDATA_SEC_LVL_BASE_IDX                                                  2
#define regDCHUBBUB_SDPIF_PIPE_DCCMETA_SEC_LVL                                                          0x0481
#define regDCHUBBUB_SDPIF_PIPE_DCCMETA_SEC_LVL_BASE_IDX                                                 2
#define regDCHUBBUB_SDPIF_PIPE_CURSOR0_SEC_LVL                                                          0x0482
#define regDCHUBBUB_SDPIF_PIPE_CURSOR0_SEC_LVL_BASE_IDX                                                 2
#define regDCHUBBUB_SDPIF_PIPE_GPUVM_SEC_LVL                                                            0x0483
#define regDCHUBBUB_SDPIF_PIPE_GPUVM_SEC_LVL_BASE_IDX                                                   2
#define regSDPIF_REQUEST_RATE_LIMIT                                                                     0x0484
#define regSDPIF_REQUEST_RATE_LIMIT_BASE_IDX                                                            2
#define regDCHUBBUB_SDPIF_MEM_PWR_CTRL                                                                  0x0485
#define regDCHUBBUB_SDPIF_MEM_PWR_CTRL_BASE_IDX                                                         2
#define regDCHUBBUB_SDPIF_MEM_PWR_STATUS                                                                0x0486
#define regDCHUBBUB_SDPIF_MEM_PWR_STATUS_BASE_IDX                                                       2


// addressBlock: dce_dc_dchubbubl_hubbub_ret_path_dispdec
// base address: 0x0
#define regDCHUBBUB_RET_PATH_MEM_PWR_CTRL                                                               0x04af
#define regDCHUBBUB_RET_PATH_MEM_PWR_CTRL_BASE_IDX                                                      2
#define regDCHUBBUB_RET_PATH_MEM_PWR_STATUS                                                             0x04b0
#define regDCHUBBUB_RET_PATH_MEM_PWR_STATUS_BASE_IDX                                                    2
#define regDCHUBBUB_CRC_CTRL                                                                            0x04b1
#define regDCHUBBUB_CRC_CTRL_BASE_IDX                                                                   2
#define regDCHUBBUB_CRC0_VAL_R_G                                                                        0x04b2
#define regDCHUBBUB_CRC0_VAL_R_G_BASE_IDX                                                               2
#define regDCHUBBUB_CRC0_VAL_B_A                                                                        0x04b3
#define regDCHUBBUB_CRC0_VAL_B_A_BASE_IDX                                                               2
#define regDCHUBBUB_CRC1_VAL_R_G                                                                        0x04b4
#define regDCHUBBUB_CRC1_VAL_R_G_BASE_IDX                                                               2
#define regDCHUBBUB_CRC1_VAL_B_A                                                                        0x04b5
#define regDCHUBBUB_CRC1_VAL_B_A_BASE_IDX                                                               2
#define regDCHUBBUB_DCC_STAT_CNTL                                                                       0x04b6
#define regDCHUBBUB_DCC_STAT_CNTL_BASE_IDX                                                              2
#define regDCHUBBUB_DCC_STAT0                                                                           0x04b7
#define regDCHUBBUB_DCC_STAT0_BASE_IDX                                                                  2
#define regDCHUBBUB_DCC_STAT1                                                                           0x04b8
#define regDCHUBBUB_DCC_STAT1_BASE_IDX                                                                  2
#define regDCHUBBUB_DCC_STAT2                                                                           0x04b9
#define regDCHUBBUB_DCC_STAT2_BASE_IDX                                                                  2
#define regDCHUBBUB_COMPBUF_CTRL                                                                        0x04ba
#define regDCHUBBUB_COMPBUF_CTRL_BASE_IDX                                                               2
#define regDCHUBBUB_DET0_CTRL                                                                           0x04bb
#define regDCHUBBUB_DET0_CTRL_BASE_IDX                                                                  2
#define regDCHUBBUB_DET1_CTRL                                                                           0x04bc
#define regDCHUBBUB_DET1_CTRL_BASE_IDX                                                                  2
#define regDCHUBBUB_DET2_CTRL                                                                           0x04bd
#define regDCHUBBUB_DET2_CTRL_BASE_IDX                                                                  2
#define regDCHUBBUB_DET3_CTRL                                                                           0x04be
#define regDCHUBBUB_DET3_CTRL_BASE_IDX                                                                  2
#define regDCHUBBUB_MEM_PWR_MODE_CTRL                                                                   0x04c0
#define regDCHUBBUB_MEM_PWR_MODE_CTRL_BASE_IDX                                                          2
#define regCOMPBUF_MEM_PWR_CTRL_1                                                                       0x04c1
#define regCOMPBUF_MEM_PWR_CTRL_1_BASE_IDX                                                              2
#define regCOMPBUF_MEM_PWR_CTRL_2                                                                       0x04c2
#define regCOMPBUF_MEM_PWR_CTRL_2_BASE_IDX                                                              2
#define regDCHUBBUB_MEM_PWR_STATUS                                                                      0x04c3
#define regDCHUBBUB_MEM_PWR_STATUS_BASE_IDX                                                             2
#define regCOMPBUF_RESERVED_SPACE                                                                       0x04c4
#define regCOMPBUF_RESERVED_SPACE_BASE_IDX                                                              2
#define regDCHUBBUB_DEBUG_CTRL_0                                                                        0x04c5
#define regDCHUBBUB_DEBUG_CTRL_0_BASE_IDX                                                               2


// addressBlock: dce_dc_dchubbubl_hubbub_dispdec
// base address: 0x0
#define regDCHUBBUB_ARB_DF_REQ_OUTSTAND                                                                 0x04f9
#define regDCHUBBUB_ARB_DF_REQ_OUTSTAND_BASE_IDX                                                        2
#define regDCHUBBUB_ARB_SAT_LEVEL                                                                       0x04fa
#define regDCHUBBUB_ARB_SAT_LEVEL_BASE_IDX                                                              2
#define regDCHUBBUB_ARB_QOS_FORCE                                                                       0x04fb
#define regDCHUBBUB_ARB_QOS_FORCE_BASE_IDX                                                              2
#define regDCHUBBUB_ARB_DRAM_STATE_CNTL                                                                 0x04fc
#define regDCHUBBUB_ARB_DRAM_STATE_CNTL_BASE_IDX                                                        2
#define regDCHUBBUB_ARB_USR_RETRAINING_CNTL                                                             0x04fd
#define regDCHUBBUB_ARB_USR_RETRAINING_CNTL_BASE_IDX                                                    2
#define regDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A                                                        0x04fe
#define regDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A_BASE_IDX                                               2
#define regDCHUBBUB_ARB_USR_RETRAINING_WATERMARK_A                                                      0x04ff
#define regDCHUBBUB_ARB_USR_RETRAINING_WATERMARK_A_BASE_IDX                                             2
#define regDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_A                                                     0x0500
#define regDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_A_BASE_IDX                                            2
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A                                                      0x0501
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A_BASE_IDX                                             2
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_Z8_A                                                   0x0502
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_Z8_A_BASE_IDX                                          2
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A                                                       0x0503
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A_BASE_IDX                                              2
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_Z8_A                                                    0x0504
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_Z8_A_BASE_IDX                                           2
#define regDCHUBBUB_ARB_UCLK_PSTATE_CHANGE_WATERMARK_A                                                  0x0505
#define regDCHUBBUB_ARB_UCLK_PSTATE_CHANGE_WATERMARK_A_BASE_IDX                                         2
#define regDCHUBBUB_ARB_FCLK_PSTATE_CHANGE_WATERMARK_A                                                  0x0506
#define regDCHUBBUB_ARB_FCLK_PSTATE_CHANGE_WATERMARK_A_BASE_IDX                                         2
#define regDCHUBBUB_ARB_FRAC_URG_BW_NOM_A                                                               0x0507
#define regDCHUBBUB_ARB_FRAC_URG_BW_NOM_A_BASE_IDX                                                      2
#define regDCHUBBUB_ARB_FRAC_URG_BW_FLIP_A                                                              0x0508
#define regDCHUBBUB_ARB_FRAC_URG_BW_FLIP_A_BASE_IDX                                                     2
#define regDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B                                                        0x0509
#define regDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B_BASE_IDX                                               2
#define regDCHUBBUB_ARB_USR_RETRAINING_WATERMARK_B                                                      0x050a
#define regDCHUBBUB_ARB_USR_RETRAINING_WATERMARK_B_BASE_IDX                                             2
#define regDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_B                                                     0x050b
#define regDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_B_BASE_IDX                                            2
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B                                                      0x050c
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B_BASE_IDX                                             2
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_Z8_B                                                   0x050d
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_Z8_B_BASE_IDX                                          2
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B                                                       0x050e
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B_BASE_IDX                                              2
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_Z8_B                                                    0x050f
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_Z8_B_BASE_IDX                                           2
#define regDCHUBBUB_ARB_UCLK_PSTATE_CHANGE_WATERMARK_B                                                  0x0510
#define regDCHUBBUB_ARB_UCLK_PSTATE_CHANGE_WATERMARK_B_BASE_IDX                                         2
#define regDCHUBBUB_ARB_FCLK_PSTATE_CHANGE_WATERMARK_B                                                  0x0511
#define regDCHUBBUB_ARB_FCLK_PSTATE_CHANGE_WATERMARK_B_BASE_IDX                                         2
#define regDCHUBBUB_ARB_FRAC_URG_BW_NOM_B                                                               0x0512
#define regDCHUBBUB_ARB_FRAC_URG_BW_NOM_B_BASE_IDX                                                      2
#define regDCHUBBUB_ARB_FRAC_URG_BW_FLIP_B                                                              0x0513
#define regDCHUBBUB_ARB_FRAC_URG_BW_FLIP_B_BASE_IDX                                                     2
#define regDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C                                                        0x0514
#define regDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C_BASE_IDX                                               2
#define regDCHUBBUB_ARB_USR_RETRAINING_WATERMARK_C                                                      0x0515
#define regDCHUBBUB_ARB_USR_RETRAINING_WATERMARK_C_BASE_IDX                                             2
#define regDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_C                                                     0x0516
#define regDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_C_BASE_IDX                                            2
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C                                                      0x0517
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C_BASE_IDX                                             2
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_Z8_C                                                   0x0518
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_Z8_C_BASE_IDX                                          2
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C                                                       0x0519
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C_BASE_IDX                                              2
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_Z8_C                                                    0x051a
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_Z8_C_BASE_IDX                                           2
#define regDCHUBBUB_ARB_UCLK_PSTATE_CHANGE_WATERMARK_C                                                  0x051b
#define regDCHUBBUB_ARB_UCLK_PSTATE_CHANGE_WATERMARK_C_BASE_IDX                                         2
#define regDCHUBBUB_ARB_FCLK_PSTATE_CHANGE_WATERMARK_C                                                  0x051c
#define regDCHUBBUB_ARB_FCLK_PSTATE_CHANGE_WATERMARK_C_BASE_IDX                                         2
#define regDCHUBBUB_ARB_FRAC_URG_BW_NOM_C                                                               0x051d
#define regDCHUBBUB_ARB_FRAC_URG_BW_NOM_C_BASE_IDX                                                      2
#define regDCHUBBUB_ARB_FRAC_URG_BW_FLIP_C                                                              0x051e
#define regDCHUBBUB_ARB_FRAC_URG_BW_FLIP_C_BASE_IDX                                                     2
#define regDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D                                                        0x051f
#define regDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D_BASE_IDX                                               2
#define regDCHUBBUB_ARB_USR_RETRAINING_WATERMARK_D                                                      0x0520
#define regDCHUBBUB_ARB_USR_RETRAINING_WATERMARK_D_BASE_IDX                                             2
#define regDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_D                                                     0x0521
#define regDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_D_BASE_IDX                                            2
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D                                                      0x0522
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D_BASE_IDX                                             2
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_Z8_D                                                   0x0523
#define regDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_Z8_D_BASE_IDX                                          2
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D                                                       0x0524
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D_BASE_IDX                                              2
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_Z8_D                                                    0x0525
#define regDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_Z8_D_BASE_IDX                                           2
#define regDCHUBBUB_ARB_UCLK_PSTATE_CHANGE_WATERMARK_D                                                  0x0526
#define regDCHUBBUB_ARB_UCLK_PSTATE_CHANGE_WATERMARK_D_BASE_IDX                                         2
#define regDCHUBBUB_ARB_FCLK_PSTATE_CHANGE_WATERMARK_D                                                  0x0527
#define regDCHUBBUB_ARB_FCLK_PSTATE_CHANGE_WATERMARK_D_BASE_IDX                                         2
#define regDCHUBBUB_ARB_FRAC_URG_BW_NOM_D                                                               0x0528
#define regDCHUBBUB_ARB_FRAC_URG_BW_NOM_D_BASE_IDX                                                      2
#define regDCHUBBUB_ARB_FRAC_URG_BW_FLIP_D                                                              0x0529
#define regDCHUBBUB_ARB_FRAC_URG_BW_FLIP_D_BASE_IDX                                                     2
#define regDCHUBBUB_ARB_HOSTVM_CNTL                                                                     0x052a
#define regDCHUBBUB_ARB_HOSTVM_CNTL_BASE_IDX                                                            2
#define regDCHUBBUB_ARB_WATERMARK_CHANGE_CNTL                                                           0x052b
#define regDCHUBBUB_ARB_WATERMARK_CHANGE_CNTL_BASE_IDX                                                  2
#define regDCHUBBUB_ARB_MALL_CNTL                                                                       0x052c
#define regDCHUBBUB_ARB_MALL_CNTL_BASE_IDX                                                              2
#define regDCHUBBUB_ARB_TIMEOUT_ENABLE                                                                  0x052d
#define regDCHUBBUB_ARB_TIMEOUT_ENABLE_BASE_IDX                                                         2
#define regDCHUBBUB_GLOBAL_TIMER_CNTL                                                                   0x052e
#define regDCHUBBUB_GLOBAL_TIMER_CNTL_BASE_IDX                                                          2
#define regSURFACE_CHECK0_ADDRESS_LSB                                                                   0x052f
#define regSURFACE_CHECK0_ADDRESS_LSB_BASE_IDX                                                          2
#define regSURFACE_CHECK0_ADDRESS_MSB                                                                   0x0530
#define regSURFACE_CHECK0_ADDRESS_MSB_BASE_IDX                                                          2
#define regSURFACE_CHECK1_ADDRESS_LSB                                                                   0x0531
#define regSURFACE_CHECK1_ADDRESS_LSB_BASE_IDX                                                          2
#define regSURFACE_CHECK1_ADDRESS_MSB                                                                   0x0532
#define regSURFACE_CHECK1_ADDRESS_MSB_BASE_IDX                                                          2
#define regSURFACE_CHECK2_ADDRESS_LSB                                                                   0x0533
#define regSURFACE_CHECK2_ADDRESS_LSB_BASE_IDX                                                          2
#define regSURFACE_CHECK2_ADDRESS_MSB                                                                   0x0534
#define regSURFACE_CHECK2_ADDRESS_MSB_BASE_IDX                                                          2
#define regSURFACE_CHECK3_ADDRESS_LSB                                                                   0x0535
#define regSURFACE_CHECK3_ADDRESS_LSB_BASE_IDX                                                          2
#define regSURFACE_CHECK3_ADDRESS_MSB                                                                   0x0536
#define regSURFACE_CHECK3_ADDRESS_MSB_BASE_IDX                                                          2
#define regVTG0_CONTROL                                                                                 0x0537
#define regVTG0_CONTROL_BASE_IDX                                                                        2
#define regVTG1_CONTROL                                                                                 0x0538
#define regVTG1_CONTROL_BASE_IDX                                                                        2
#define regVTG2_CONTROL                                                                                 0x0539
#define regVTG2_CONTROL_BASE_IDX                                                                        2
#define regVTG3_CONTROL                                                                                 0x053a
#define regVTG3_CONTROL_BASE_IDX                                                                        2
#define regDCHUBBUB_SOFT_RESET                                                                          0x053b
#define regDCHUBBUB_SOFT_RESET_BASE_IDX                                                                 2
#define regDCHUBBUB_CLOCK_CNTL                                                                          0x053c
#define regDCHUBBUB_CLOCK_CNTL_BASE_IDX                                                                 2
#define regDCFCLK_CNTL                                                                                  0x053d
#define regDCFCLK_CNTL_BASE_IDX                                                                         2
#define regDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL                                                        0x053e
#define regDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL_BASE_IDX                                               2
#define regDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2                                                       0x053f
#define regDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2_BASE_IDX                                              2
#define regDCHUBBUB_VLINE_SNAPSHOT                                                                      0x0540
#define regDCHUBBUB_VLINE_SNAPSHOT_BASE_IDX                                                             2
#define regDCHUBBUB_CTRL_STATUS                                                                         0x0541
#define regDCHUBBUB_CTRL_STATUS_BASE_IDX                                                                2
#define regDCHUBBUB_TIMEOUT_DETECTION_CTRL1                                                             0x0547
#define regDCHUBBUB_TIMEOUT_DETECTION_CTRL1_BASE_IDX                                                    2
#define regDCHUBBUB_TIMEOUT_DETECTION_CTRL2                                                             0x0548
#define regDCHUBBUB_TIMEOUT_DETECTION_CTRL2_BASE_IDX                                                    2
#define regDCHUBBUB_TIMEOUT_INTERRUPT_STATUS                                                            0x0549
#define regDCHUBBUB_TIMEOUT_INTERRUPT_STATUS_BASE_IDX                                                   2
#define regFMON_CTRL                                                                                    0x054a
#define regFMON_CTRL_BASE_IDX                                                                           2
#define regDCHUBBUB_TEST_DEBUG_INDEX                                                                    0x054b
#define regDCHUBBUB_TEST_DEBUG_INDEX_BASE_IDX                                                           2
#define regDCHUBBUB_TEST_DEBUG_DATA                                                                     0x054c
#define regDCHUBBUB_TEST_DEBUG_DATA_BASE_IDX                                                            2

// addressBlock: dce_dc_dchubbubl_dchubbub_dcperfmon_dc_perfmon_dispdec
// base address: 0x1534
#define regDC_PERFMON6_PERFCOUNTER_CNTL                                                                 0x054d
#define regDC_PERFMON6_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define regDC_PERFMON6_PERFCOUNTER_CNTL2                                                                0x054e
#define regDC_PERFMON6_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define regDC_PERFMON6_PERFCOUNTER_STATE                                                                0x054f
#define regDC_PERFMON6_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define regDC_PERFMON6_PERFMON_CNTL                                                                     0x0550
#define regDC_PERFMON6_PERFMON_CNTL_BASE_IDX                                                            2
#define regDC_PERFMON6_PERFMON_CNTL2                                                                    0x0551
#define regDC_PERFMON6_PERFMON_CNTL2_BASE_IDX                                                           2
#define regDC_PERFMON6_PERFMON_CVALUE_INT_MISC                                                          0x0552
#define regDC_PERFMON6_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define regDC_PERFMON6_PERFMON_CVALUE_LOW                                                               0x0553
#define regDC_PERFMON6_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define regDC_PERFMON6_PERFMON_HI                                                                       0x0554
#define regDC_PERFMON6_PERFMON_HI_BASE_IDX                                                              2
#define regDC_PERFMON6_PERFMON_LOW                                                                      0x0555
#define regDC_PERFMON6_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dchubbubl_hubbub_vmrq_if_dispdec
// base address: 0x0
#define regDCN_VM_CONTEXT0_CNTL                                                                         0x0559
#define regDCN_VM_CONTEXT0_CNTL_BASE_IDX                                                                2
#define regDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32                                                    0x055a
#define regDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32                                                    0x055b
#define regDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32                                                   0x055c
#define regDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32                                                   0x055d
#define regDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32                                                     0x055e
#define regDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32                                                     0x055f
#define regDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT1_CNTL                                                                         0x0560
#define regDCN_VM_CONTEXT1_CNTL_BASE_IDX                                                                2
#define regDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0561
#define regDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0562
#define regDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32                                                   0x0563
#define regDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32                                                   0x0564
#define regDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32                                                     0x0565
#define regDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32                                                     0x0566
#define regDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT2_CNTL                                                                         0x0567
#define regDCN_VM_CONTEXT2_CNTL_BASE_IDX                                                                2
#define regDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0568
#define regDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0569
#define regDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32                                                   0x056a
#define regDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32                                                   0x056b
#define regDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32                                                     0x056c
#define regDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32                                                     0x056d
#define regDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT3_CNTL                                                                         0x056e
#define regDCN_VM_CONTEXT3_CNTL_BASE_IDX                                                                2
#define regDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32                                                    0x056f
#define regDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0570
#define regDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32                                                   0x0571
#define regDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32                                                   0x0572
#define regDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32                                                     0x0573
#define regDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32                                                     0x0574
#define regDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT4_CNTL                                                                         0x0575
#define regDCN_VM_CONTEXT4_CNTL_BASE_IDX                                                                2
#define regDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0576
#define regDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0577
#define regDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32                                                   0x0578
#define regDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32                                                   0x0579
#define regDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32                                                     0x057a
#define regDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32                                                     0x057b
#define regDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT5_CNTL                                                                         0x057c
#define regDCN_VM_CONTEXT5_CNTL_BASE_IDX                                                                2
#define regDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32                                                    0x057d
#define regDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32                                                    0x057e
#define regDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32                                                   0x057f
#define regDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32                                                   0x0580
#define regDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32                                                     0x0581
#define regDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32                                                     0x0582
#define regDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT6_CNTL                                                                         0x0583
#define regDCN_VM_CONTEXT6_CNTL_BASE_IDX                                                                2
#define regDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0584
#define regDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0585
#define regDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32                                                   0x0586
#define regDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32                                                   0x0587
#define regDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32                                                     0x0588
#define regDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32                                                     0x0589
#define regDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT7_CNTL                                                                         0x058a
#define regDCN_VM_CONTEXT7_CNTL_BASE_IDX                                                                2
#define regDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32                                                    0x058b
#define regDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32                                                    0x058c
#define regDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32                                                   0x058d
#define regDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32                                                   0x058e
#define regDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32                                                     0x058f
#define regDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32                                                     0x0590
#define regDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT8_CNTL                                                                         0x0591
#define regDCN_VM_CONTEXT8_CNTL_BASE_IDX                                                                2
#define regDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0592
#define regDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0593
#define regDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32                                                   0x0594
#define regDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32                                                   0x0595
#define regDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32                                                     0x0596
#define regDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32                                                     0x0597
#define regDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT9_CNTL                                                                         0x0598
#define regDCN_VM_CONTEXT9_CNTL_BASE_IDX                                                                2
#define regDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0599
#define regDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32                                                    0x059a
#define regDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32                                                   0x059b
#define regDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32                                                   0x059c
#define regDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32                                                     0x059d
#define regDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32                                                     0x059e
#define regDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define regDCN_VM_CONTEXT10_CNTL                                                                        0x059f
#define regDCN_VM_CONTEXT10_CNTL_BASE_IDX                                                               2
#define regDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05a0
#define regDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05a1
#define regDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32                                                  0x05a2
#define regDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32                                                  0x05a3
#define regDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32                                                    0x05a4
#define regDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32                                                    0x05a5
#define regDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT11_CNTL                                                                        0x05a6
#define regDCN_VM_CONTEXT11_CNTL_BASE_IDX                                                               2
#define regDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05a7
#define regDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05a8
#define regDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32                                                  0x05a9
#define regDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32                                                  0x05aa
#define regDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32                                                    0x05ab
#define regDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32                                                    0x05ac
#define regDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT12_CNTL                                                                        0x05ad
#define regDCN_VM_CONTEXT12_CNTL_BASE_IDX                                                               2
#define regDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05ae
#define regDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05af
#define regDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32                                                  0x05b0
#define regDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32                                                  0x05b1
#define regDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32                                                    0x05b2
#define regDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32                                                    0x05b3
#define regDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT13_CNTL                                                                        0x05b4
#define regDCN_VM_CONTEXT13_CNTL_BASE_IDX                                                               2
#define regDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05b5
#define regDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05b6
#define regDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32                                                  0x05b7
#define regDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32                                                  0x05b8
#define regDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32                                                    0x05b9
#define regDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32                                                    0x05ba
#define regDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT14_CNTL                                                                        0x05bb
#define regDCN_VM_CONTEXT14_CNTL_BASE_IDX                                                               2
#define regDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05bc
#define regDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05bd
#define regDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32                                                  0x05be
#define regDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32                                                  0x05bf
#define regDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32                                                    0x05c0
#define regDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32                                                    0x05c1
#define regDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT15_CNTL                                                                        0x05c2
#define regDCN_VM_CONTEXT15_CNTL_BASE_IDX                                                               2
#define regDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05c3
#define regDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05c4
#define regDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define regDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32                                                  0x05c5
#define regDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32                                                  0x05c6
#define regDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define regDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32                                                    0x05c7
#define regDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define regDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32                                                    0x05c8
#define regDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define regDCN_VM_DEFAULT_ADDR_MSB                                                                      0x05c9
#define regDCN_VM_DEFAULT_ADDR_MSB_BASE_IDX                                                             2
#define regDCN_VM_DEFAULT_ADDR_LSB                                                                      0x05ca
#define regDCN_VM_DEFAULT_ADDR_LSB_BASE_IDX                                                             2
#define regDCN_VM_FAULT_CNTL                                                                            0x05cb
#define regDCN_VM_FAULT_CNTL_BASE_IDX                                                                   2
#define regDCN_VM_FAULT_STATUS                                                                          0x05cc
#define regDCN_VM_FAULT_STATUS_BASE_IDX                                                                 2
#define regDCN_VM_FAULT_ADDR_MSB                                                                        0x05cd
#define regDCN_VM_FAULT_ADDR_MSB_BASE_IDX                                                               2
#define regDCN_VM_FAULT_ADDR_LSB                                                                        0x05ce
#define regDCN_VM_FAULT_ADDR_LSB_BASE_IDX                                                               2



// addressBlock: dce_dc_dcbubp0_dispdec_hubp_dispdec
// base address: 0x0
#define regHUBP0_DCSURF_SURFACE_CONFIG                                                                  0x05e5
#define regHUBP0_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define regHUBP0_DCSURF_ADDR_CONFIG                                                                     0x05e6
#define regHUBP0_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define regHUBP0_DCSURF_TILING_CONFIG                                                                   0x05e7
#define regHUBP0_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define regHUBP0_DCSURF_PRI_VIEWPORT_START                                                              0x05e9
#define regHUBP0_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define regHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x05ea
#define regHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define regHUBP0_DCSURF_PRI_VIEWPORT_START_C                                                            0x05eb
#define regHUBP0_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define regHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x05ec
#define regHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define regHUBP0_DCSURF_SEC_VIEWPORT_START                                                              0x05ed
#define regHUBP0_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define regHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x05ee
#define regHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define regHUBP0_DCSURF_SEC_VIEWPORT_START_C                                                            0x05ef
#define regHUBP0_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define regHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x05f0
#define regHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define regHUBP0_DCHUBP_REQ_SIZE_CONFIG                                                                 0x05f1
#define regHUBP0_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define regHUBP0_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x05f2
#define regHUBP0_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define regHUBP0_DCHUBP_CNTL                                                                            0x05f3
#define regHUBP0_DCHUBP_CNTL_BASE_IDX                                                                   2
#define regHUBP0_HUBP_CLK_CNTL                                                                          0x05f4
#define regHUBP0_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define regHUBP0_DCHUBP_VMPG_CONFIG                                                                     0x05f5
#define regHUBP0_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define regHUBP0_DCHUBP_MALL_CONFIG                                                                     0x05f6
#define regHUBP0_DCHUBP_MALL_CONFIG_BASE_IDX                                                            2
#define regHUBP0_DCHUBP_MALL_SUB_VP                                                                     0x05f7
#define regHUBP0_DCHUBP_MALL_SUB_VP_BASE_IDX                                                            2
#define regHUBP0_HUBPREQ_DEBUG_DB                                                                       0x05f8
#define regHUBP0_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define regHUBP0_HUBPREQ_DEBUG                                                                          0x05f9
#define regHUBP0_HUBPREQ_DEBUG_BASE_IDX                                                                 2
#define regHUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x05fd
#define regHUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define regHUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x05fe
#define regHUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2
#define regHUBP0_HUBP_MALL_STATUS                                                                       0x05ff
#define regHUBP0_HUBP_MALL_STATUS_BASE_IDX                                                              2


// addressBlock: dce_dc_dcbubp0_dispdec_hubpreq_dispdec
// base address: 0x0
#define regHUBPREQ0_DCSURF_SURFACE_PITCH                                                                0x0607
#define regHUBPREQ0_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define regHUBPREQ0_DCSURF_SURFACE_PITCH_C                                                              0x0608
#define regHUBPREQ0_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define regHUBPREQ0_VMID_SETTINGS_0                                                                     0x0609
#define regHUBPREQ0_VMID_SETTINGS_0_BASE_IDX                                                            2
#define regHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x060a
#define regHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define regHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x060b
#define regHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define regHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x060c
#define regHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define regHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x060d
#define regHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define regHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x060e
#define regHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define regHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x060f
#define regHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define regHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x0610
#define regHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define regHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x0611
#define regHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define regHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x0612
#define regHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define regHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x0613
#define regHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define regHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x0614
#define regHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define regHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x0615
#define regHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define regHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x0616
#define regHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define regHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x0617
#define regHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define regHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x0618
#define regHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define regHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x0619
#define regHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define regHUBPREQ0_DCSURF_SURFACE_CONTROL                                                              0x061a
#define regHUBPREQ0_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define regHUBPREQ0_DCSURF_FLIP_CONTROL                                                                 0x061b
#define regHUBPREQ0_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define regHUBPREQ0_DCSURF_FLIP_CONTROL2                                                                0x061c
#define regHUBPREQ0_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define regHUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x061f
#define regHUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define regHUBPREQ0_DCSURF_SURFACE_INUSE                                                                0x0620
#define regHUBPREQ0_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define regHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH                                                           0x0621
#define regHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define regHUBPREQ0_DCSURF_SURFACE_INUSE_C                                                              0x0622
#define regHUBPREQ0_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define regHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x0623
#define regHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define regHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x0624
#define regHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define regHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x0625
#define regHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define regHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x0626
#define regHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define regHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x0627
#define regHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define regHUBPREQ0_DCN_EXPANSION_MODE                                                                  0x0628
#define regHUBPREQ0_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define regHUBPREQ0_DCN_TTU_QOS_WM                                                                      0x0629
#define regHUBPREQ0_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define regHUBPREQ0_DCN_GLOBAL_TTU_CNTL                                                                 0x062a
#define regHUBPREQ0_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define regHUBPREQ0_DCN_SURF0_TTU_CNTL0                                                                 0x062b
#define regHUBPREQ0_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define regHUBPREQ0_DCN_SURF0_TTU_CNTL1                                                                 0x062c
#define regHUBPREQ0_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define regHUBPREQ0_DCN_SURF1_TTU_CNTL0                                                                 0x062d
#define regHUBPREQ0_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define regHUBPREQ0_DCN_SURF1_TTU_CNTL1                                                                 0x062e
#define regHUBPREQ0_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define regHUBPREQ0_DCN_CUR0_TTU_CNTL0                                                                  0x062f
#define regHUBPREQ0_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define regHUBPREQ0_DCN_CUR0_TTU_CNTL1                                                                  0x0630
#define regHUBPREQ0_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define regHUBPREQ0_DCN_CUR1_TTU_CNTL0                                                                  0x0631
#define regHUBPREQ0_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define regHUBPREQ0_DCN_CUR1_TTU_CNTL1                                                                  0x0632
#define regHUBPREQ0_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define regHUBPREQ0_DCN_DMDATA_VM_CNTL                                                                  0x0633
#define regHUBPREQ0_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define regHUBPREQ0_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x0634
#define regHUBPREQ0_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define regHUBPREQ0_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x0635
#define regHUBPREQ0_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define regHUBPREQ0_DCN_VM_MX_L1_TLB_CNTL                                                               0x0642
#define regHUBPREQ0_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define regHUBPREQ0_BLANK_OFFSET_0                                                                      0x0643
#define regHUBPREQ0_BLANK_OFFSET_0_BASE_IDX                                                             2
#define regHUBPREQ0_BLANK_OFFSET_1                                                                      0x0644
#define regHUBPREQ0_BLANK_OFFSET_1_BASE_IDX                                                             2
#define regHUBPREQ0_DST_DIMENSIONS                                                                      0x0645
#define regHUBPREQ0_DST_DIMENSIONS_BASE_IDX                                                             2
#define regHUBPREQ0_DST_AFTER_SCALER                                                                    0x0646
#define regHUBPREQ0_DST_AFTER_SCALER_BASE_IDX                                                           2
#define regHUBPREQ0_PREFETCH_SETTINGS                                                                   0x0647
#define regHUBPREQ0_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define regHUBPREQ0_PREFETCH_SETTINGS_C                                                                 0x0648
#define regHUBPREQ0_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define regHUBPREQ0_VBLANK_PARAMETERS_0                                                                 0x0649
#define regHUBPREQ0_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define regHUBPREQ0_VBLANK_PARAMETERS_1                                                                 0x064a
#define regHUBPREQ0_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define regHUBPREQ0_VBLANK_PARAMETERS_2                                                                 0x064b
#define regHUBPREQ0_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define regHUBPREQ0_VBLANK_PARAMETERS_3                                                                 0x064c
#define regHUBPREQ0_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define regHUBPREQ0_VBLANK_PARAMETERS_4                                                                 0x064d
#define regHUBPREQ0_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define regHUBPREQ0_FLIP_PARAMETERS_0                                                                   0x064e
#define regHUBPREQ0_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define regHUBPREQ0_FLIP_PARAMETERS_1                                                                   0x064f
#define regHUBPREQ0_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define regHUBPREQ0_FLIP_PARAMETERS_2                                                                   0x0650
#define regHUBPREQ0_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define regHUBPREQ0_NOM_PARAMETERS_0                                                                    0x0651
#define regHUBPREQ0_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define regHUBPREQ0_NOM_PARAMETERS_1                                                                    0x0652
#define regHUBPREQ0_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define regHUBPREQ0_NOM_PARAMETERS_2                                                                    0x0653
#define regHUBPREQ0_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define regHUBPREQ0_NOM_PARAMETERS_3                                                                    0x0654
#define regHUBPREQ0_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define regHUBPREQ0_NOM_PARAMETERS_4                                                                    0x0655
#define regHUBPREQ0_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define regHUBPREQ0_NOM_PARAMETERS_5                                                                    0x0656
#define regHUBPREQ0_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define regHUBPREQ0_NOM_PARAMETERS_6                                                                    0x0657
#define regHUBPREQ0_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define regHUBPREQ0_NOM_PARAMETERS_7                                                                    0x0658
#define regHUBPREQ0_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define regHUBPREQ0_PER_LINE_DELIVERY_PRE                                                               0x0659
#define regHUBPREQ0_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define regHUBPREQ0_PER_LINE_DELIVERY                                                                   0x065a
#define regHUBPREQ0_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define regHUBPREQ0_CURSOR_SETTINGS                                                                     0x065b
#define regHUBPREQ0_CURSOR_SETTINGS_BASE_IDX                                                            2
#define regHUBPREQ0_REF_FREQ_TO_PIX_FREQ                                                                0x065c
#define regHUBPREQ0_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define regHUBPREQ0_DST_Y_DELTA_DRQ_LIMIT                                                               0x065d
#define regHUBPREQ0_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define regHUBPREQ0_HUBPREQ_MEM_PWR_CTRL                                                                0x065e
#define regHUBPREQ0_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regHUBPREQ0_HUBPREQ_MEM_PWR_STATUS                                                              0x065f
#define regHUBPREQ0_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regHUBPREQ0_VBLANK_PARAMETERS_5                                                                 0x0662
#define regHUBPREQ0_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define regHUBPREQ0_VBLANK_PARAMETERS_6                                                                 0x0663
#define regHUBPREQ0_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define regHUBPREQ0_FLIP_PARAMETERS_3                                                                   0x0664
#define regHUBPREQ0_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define regHUBPREQ0_FLIP_PARAMETERS_4                                                                   0x0665
#define regHUBPREQ0_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define regHUBPREQ0_FLIP_PARAMETERS_5                                                                   0x0666
#define regHUBPREQ0_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define regHUBPREQ0_FLIP_PARAMETERS_6                                                                   0x0667
#define regHUBPREQ0_FLIP_PARAMETERS_6_BASE_IDX                                                          2
#define regHUBPREQ0_UCLK_PSTATE_FORCE                                                                   0x0668
#define regHUBPREQ0_UCLK_PSTATE_FORCE_BASE_IDX                                                          2
#define regHUBPREQ0_HUBPREQ_STATUS_REG0                                                                 0x0669
#define regHUBPREQ0_HUBPREQ_STATUS_REG0_BASE_IDX                                                        2
#define regHUBPREQ0_HUBPREQ_STATUS_REG1                                                                 0x066a
#define regHUBPREQ0_HUBPREQ_STATUS_REG1_BASE_IDX                                                        2
#define regHUBPREQ0_HUBPREQ_STATUS_REG2                                                                 0x066b
#define regHUBPREQ0_HUBPREQ_STATUS_REG2_BASE_IDX                                                        2


// addressBlock: dce_dc_dcbubp0_dispdec_hubpret_dispdec
// base address: 0x0
#define regHUBPRET0_HUBPRET_CONTROL                                                                     0x066c
#define regHUBPRET0_HUBPRET_CONTROL_BASE_IDX                                                            2
#define regHUBPRET0_HUBPRET_MEM_PWR_CTRL                                                                0x066d
#define regHUBPRET0_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regHUBPRET0_HUBPRET_MEM_PWR_STATUS                                                              0x066e
#define regHUBPRET0_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regHUBPRET0_HUBPRET_READ_LINE_CTRL0                                                             0x066f
#define regHUBPRET0_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define regHUBPRET0_HUBPRET_READ_LINE_CTRL1                                                             0x0670
#define regHUBPRET0_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define regHUBPRET0_HUBPRET_READ_LINE0                                                                  0x0671
#define regHUBPRET0_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define regHUBPRET0_HUBPRET_READ_LINE1                                                                  0x0672
#define regHUBPRET0_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define regHUBPRET0_HUBPRET_INTERRUPT                                                                   0x0673
#define regHUBPRET0_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define regHUBPRET0_HUBPRET_READ_LINE_VALUE                                                             0x0674
#define regHUBPRET0_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define regHUBPRET0_HUBPRET_READ_LINE_STATUS                                                            0x0675
#define regHUBPRET0_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp0_dispdec_cursor0_dispdec
// base address: 0x0
#define regCURSOR0_0_CURSOR_CONTROL                                                                     0x0678
#define regCURSOR0_0_CURSOR_CONTROL_BASE_IDX                                                            2
#define regCURSOR0_0_CURSOR_SURFACE_ADDRESS                                                             0x0679
#define regCURSOR0_0_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define regCURSOR0_0_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x067a
#define regCURSOR0_0_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define regCURSOR0_0_CURSOR_SIZE                                                                        0x067b
#define regCURSOR0_0_CURSOR_SIZE_BASE_IDX                                                               2
#define regCURSOR0_0_CURSOR_POSITION                                                                    0x067c
#define regCURSOR0_0_CURSOR_POSITION_BASE_IDX                                                           2
#define regCURSOR0_0_CURSOR_HOT_SPOT                                                                    0x067d
#define regCURSOR0_0_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define regCURSOR0_0_CURSOR_STEREO_CONTROL                                                              0x067e
#define regCURSOR0_0_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define regCURSOR0_0_CURSOR_DST_OFFSET                                                                  0x067f
#define regCURSOR0_0_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define regCURSOR0_0_CURSOR_MEM_PWR_CTRL                                                                0x0680
#define regCURSOR0_0_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regCURSOR0_0_CURSOR_MEM_PWR_STATUS                                                              0x0681
#define regCURSOR0_0_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regCURSOR0_0_DMDATA_ADDRESS_HIGH                                                                0x0682
#define regCURSOR0_0_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define regCURSOR0_0_DMDATA_ADDRESS_LOW                                                                 0x0683
#define regCURSOR0_0_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define regCURSOR0_0_DMDATA_CNTL                                                                        0x0684
#define regCURSOR0_0_DMDATA_CNTL_BASE_IDX                                                               2
#define regCURSOR0_0_DMDATA_QOS_CNTL                                                                    0x0685
#define regCURSOR0_0_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define regCURSOR0_0_DMDATA_STATUS                                                                      0x0686
#define regCURSOR0_0_DMDATA_STATUS_BASE_IDX                                                             2
#define regCURSOR0_0_DMDATA_SW_CNTL                                                                     0x0687
#define regCURSOR0_0_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define regCURSOR0_0_DMDATA_SW_DATA                                                                     0x0688
#define regCURSOR0_0_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp0_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x1a74
#define regDC_PERFMON7_PERFCOUNTER_CNTL                                                                 0x069d
#define regDC_PERFMON7_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define regDC_PERFMON7_PERFCOUNTER_CNTL2                                                                0x069e
#define regDC_PERFMON7_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define regDC_PERFMON7_PERFCOUNTER_STATE                                                                0x069f
#define regDC_PERFMON7_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define regDC_PERFMON7_PERFMON_CNTL                                                                     0x06a0
#define regDC_PERFMON7_PERFMON_CNTL_BASE_IDX                                                            2
#define regDC_PERFMON7_PERFMON_CNTL2                                                                    0x06a1
#define regDC_PERFMON7_PERFMON_CNTL2_BASE_IDX                                                           2
#define regDC_PERFMON7_PERFMON_CVALUE_INT_MISC                                                          0x06a2
#define regDC_PERFMON7_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define regDC_PERFMON7_PERFMON_CVALUE_LOW                                                               0x06a3
#define regDC_PERFMON7_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define regDC_PERFMON7_PERFMON_HI                                                                       0x06a4
#define regDC_PERFMON7_PERFMON_HI_BASE_IDX                                                              2
#define regDC_PERFMON7_PERFMON_LOW                                                                      0x06a5
#define regDC_PERFMON7_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dcbubp1_dispdec_hubp_dispdec
// base address: 0x370
#define regHUBP1_DCSURF_SURFACE_CONFIG                                                                  0x06c1
#define regHUBP1_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define regHUBP1_DCSURF_ADDR_CONFIG                                                                     0x06c2
#define regHUBP1_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define regHUBP1_DCSURF_TILING_CONFIG                                                                   0x06c3
#define regHUBP1_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define regHUBP1_DCSURF_PRI_VIEWPORT_START                                                              0x06c5
#define regHUBP1_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define regHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x06c6
#define regHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define regHUBP1_DCSURF_PRI_VIEWPORT_START_C                                                            0x06c7
#define regHUBP1_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define regHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x06c8
#define regHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define regHUBP1_DCSURF_SEC_VIEWPORT_START                                                              0x06c9
#define regHUBP1_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define regHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x06ca
#define regHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define regHUBP1_DCSURF_SEC_VIEWPORT_START_C                                                            0x06cb
#define regHUBP1_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define regHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x06cc
#define regHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define regHUBP1_DCHUBP_REQ_SIZE_CONFIG                                                                 0x06cd
#define regHUBP1_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define regHUBP1_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x06ce
#define regHUBP1_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define regHUBP1_DCHUBP_CNTL                                                                            0x06cf
#define regHUBP1_DCHUBP_CNTL_BASE_IDX                                                                   2
#define regHUBP1_HUBP_CLK_CNTL                                                                          0x06d0
#define regHUBP1_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define regHUBP1_DCHUBP_VMPG_CONFIG                                                                     0x06d1
#define regHUBP1_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define regHUBP1_DCHUBP_MALL_CONFIG                                                                     0x06d2
#define regHUBP1_DCHUBP_MALL_CONFIG_BASE_IDX                                                            2
#define regHUBP1_DCHUBP_MALL_SUB_VP                                                                     0x06d3
#define regHUBP1_DCHUBP_MALL_SUB_VP_BASE_IDX                                                            2
#define regHUBP1_HUBPREQ_DEBUG_DB                                                                       0x06d4
#define regHUBP1_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define regHUBP1_HUBPREQ_DEBUG                                                                          0x06d5
#define regHUBP1_HUBPREQ_DEBUG_BASE_IDX                                                                 2
#define regHUBP1_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x06d9
#define regHUBP1_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define regHUBP1_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x06da
#define regHUBP1_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2
#define regHUBP1_HUBP_MALL_STATUS                                                                       0x06db
#define regHUBP1_HUBP_MALL_STATUS_BASE_IDX                                                              2


// addressBlock: dce_dc_dcbubp1_dispdec_hubpreq_dispdec
// base address: 0x370
#define regHUBPREQ1_DCSURF_SURFACE_PITCH                                                                0x06e3
#define regHUBPREQ1_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define regHUBPREQ1_DCSURF_SURFACE_PITCH_C                                                              0x06e4
#define regHUBPREQ1_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define regHUBPREQ1_VMID_SETTINGS_0                                                                     0x06e5
#define regHUBPREQ1_VMID_SETTINGS_0_BASE_IDX                                                            2
#define regHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x06e6
#define regHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define regHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x06e7
#define regHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define regHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x06e8
#define regHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define regHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x06e9
#define regHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define regHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x06ea
#define regHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define regHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x06eb
#define regHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define regHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x06ec
#define regHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define regHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x06ed
#define regHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define regHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x06ee
#define regHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define regHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x06ef
#define regHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define regHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x06f0
#define regHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define regHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x06f1
#define regHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define regHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x06f2
#define regHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define regHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x06f3
#define regHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define regHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x06f4
#define regHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define regHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x06f5
#define regHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define regHUBPREQ1_DCSURF_SURFACE_CONTROL                                                              0x06f6
#define regHUBPREQ1_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define regHUBPREQ1_DCSURF_FLIP_CONTROL                                                                 0x06f7
#define regHUBPREQ1_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define regHUBPREQ1_DCSURF_FLIP_CONTROL2                                                                0x06f8
#define regHUBPREQ1_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define regHUBPREQ1_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x06fb
#define regHUBPREQ1_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define regHUBPREQ1_DCSURF_SURFACE_INUSE                                                                0x06fc
#define regHUBPREQ1_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define regHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH                                                           0x06fd
#define regHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define regHUBPREQ1_DCSURF_SURFACE_INUSE_C                                                              0x06fe
#define regHUBPREQ1_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define regHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x06ff
#define regHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define regHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x0700
#define regHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define regHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x0701
#define regHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define regHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x0702
#define regHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define regHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x0703
#define regHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define regHUBPREQ1_DCN_EXPANSION_MODE                                                                  0x0704
#define regHUBPREQ1_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define regHUBPREQ1_DCN_TTU_QOS_WM                                                                      0x0705
#define regHUBPREQ1_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define regHUBPREQ1_DCN_GLOBAL_TTU_CNTL                                                                 0x0706
#define regHUBPREQ1_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define regHUBPREQ1_DCN_SURF0_TTU_CNTL0                                                                 0x0707
#define regHUBPREQ1_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define regHUBPREQ1_DCN_SURF0_TTU_CNTL1                                                                 0x0708
#define regHUBPREQ1_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define regHUBPREQ1_DCN_SURF1_TTU_CNTL0                                                                 0x0709
#define regHUBPREQ1_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define regHUBPREQ1_DCN_SURF1_TTU_CNTL1                                                                 0x070a
#define regHUBPREQ1_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define regHUBPREQ1_DCN_CUR0_TTU_CNTL0                                                                  0x070b
#define regHUBPREQ1_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define regHUBPREQ1_DCN_CUR0_TTU_CNTL1                                                                  0x070c
#define regHUBPREQ1_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define regHUBPREQ1_DCN_CUR1_TTU_CNTL0                                                                  0x070d
#define regHUBPREQ1_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define regHUBPREQ1_DCN_CUR1_TTU_CNTL1                                                                  0x070e
#define regHUBPREQ1_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define regHUBPREQ1_DCN_DMDATA_VM_CNTL                                                                  0x070f
#define regHUBPREQ1_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define regHUBPREQ1_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x0710
#define regHUBPREQ1_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define regHUBPREQ1_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x0711
#define regHUBPREQ1_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define regHUBPREQ1_DCN_VM_MX_L1_TLB_CNTL                                                               0x071e
#define regHUBPREQ1_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define regHUBPREQ1_BLANK_OFFSET_0                                                                      0x071f
#define regHUBPREQ1_BLANK_OFFSET_0_BASE_IDX                                                             2
#define regHUBPREQ1_BLANK_OFFSET_1                                                                      0x0720
#define regHUBPREQ1_BLANK_OFFSET_1_BASE_IDX                                                             2
#define regHUBPREQ1_DST_DIMENSIONS                                                                      0x0721
#define regHUBPREQ1_DST_DIMENSIONS_BASE_IDX                                                             2
#define regHUBPREQ1_DST_AFTER_SCALER                                                                    0x0722
#define regHUBPREQ1_DST_AFTER_SCALER_BASE_IDX                                                           2
#define regHUBPREQ1_PREFETCH_SETTINGS                                                                   0x0723
#define regHUBPREQ1_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define regHUBPREQ1_PREFETCH_SETTINGS_C                                                                 0x0724
#define regHUBPREQ1_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define regHUBPREQ1_VBLANK_PARAMETERS_0                                                                 0x0725
#define regHUBPREQ1_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define regHUBPREQ1_VBLANK_PARAMETERS_1                                                                 0x0726
#define regHUBPREQ1_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define regHUBPREQ1_VBLANK_PARAMETERS_2                                                                 0x0727
#define regHUBPREQ1_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define regHUBPREQ1_VBLANK_PARAMETERS_3                                                                 0x0728
#define regHUBPREQ1_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define regHUBPREQ1_VBLANK_PARAMETERS_4                                                                 0x0729
#define regHUBPREQ1_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define regHUBPREQ1_FLIP_PARAMETERS_0                                                                   0x072a
#define regHUBPREQ1_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define regHUBPREQ1_FLIP_PARAMETERS_1                                                                   0x072b
#define regHUBPREQ1_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define regHUBPREQ1_FLIP_PARAMETERS_2                                                                   0x072c
#define regHUBPREQ1_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define regHUBPREQ1_NOM_PARAMETERS_0                                                                    0x072d
#define regHUBPREQ1_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define regHUBPREQ1_NOM_PARAMETERS_1                                                                    0x072e
#define regHUBPREQ1_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define regHUBPREQ1_NOM_PARAMETERS_2                                                                    0x072f
#define regHUBPREQ1_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define regHUBPREQ1_NOM_PARAMETERS_3                                                                    0x0730
#define regHUBPREQ1_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define regHUBPREQ1_NOM_PARAMETERS_4                                                                    0x0731
#define regHUBPREQ1_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define regHUBPREQ1_NOM_PARAMETERS_5                                                                    0x0732
#define regHUBPREQ1_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define regHUBPREQ1_NOM_PARAMETERS_6                                                                    0x0733
#define regHUBPREQ1_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define regHUBPREQ1_NOM_PARAMETERS_7                                                                    0x0734
#define regHUBPREQ1_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define regHUBPREQ1_PER_LINE_DELIVERY_PRE                                                               0x0735
#define regHUBPREQ1_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define regHUBPREQ1_PER_LINE_DELIVERY                                                                   0x0736
#define regHUBPREQ1_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define regHUBPREQ1_CURSOR_SETTINGS                                                                     0x0737
#define regHUBPREQ1_CURSOR_SETTINGS_BASE_IDX                                                            2
#define regHUBPREQ1_REF_FREQ_TO_PIX_FREQ                                                                0x0738
#define regHUBPREQ1_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define regHUBPREQ1_DST_Y_DELTA_DRQ_LIMIT                                                               0x0739
#define regHUBPREQ1_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define regHUBPREQ1_HUBPREQ_MEM_PWR_CTRL                                                                0x073a
#define regHUBPREQ1_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regHUBPREQ1_HUBPREQ_MEM_PWR_STATUS                                                              0x073b
#define regHUBPREQ1_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regHUBPREQ1_VBLANK_PARAMETERS_5                                                                 0x073e
#define regHUBPREQ1_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define regHUBPREQ1_VBLANK_PARAMETERS_6                                                                 0x073f
#define regHUBPREQ1_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define regHUBPREQ1_FLIP_PARAMETERS_3                                                                   0x0740
#define regHUBPREQ1_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define regHUBPREQ1_FLIP_PARAMETERS_4                                                                   0x0741
#define regHUBPREQ1_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define regHUBPREQ1_FLIP_PARAMETERS_5                                                                   0x0742
#define regHUBPREQ1_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define regHUBPREQ1_FLIP_PARAMETERS_6                                                                   0x0743
#define regHUBPREQ1_FLIP_PARAMETERS_6_BASE_IDX                                                          2
#define regHUBPREQ1_UCLK_PSTATE_FORCE                                                                   0x0744
#define regHUBPREQ1_UCLK_PSTATE_FORCE_BASE_IDX                                                          2
#define regHUBPREQ1_HUBPREQ_STATUS_REG0                                                                 0x0745
#define regHUBPREQ1_HUBPREQ_STATUS_REG0_BASE_IDX                                                        2
#define regHUBPREQ1_HUBPREQ_STATUS_REG1                                                                 0x0746
#define regHUBPREQ1_HUBPREQ_STATUS_REG1_BASE_IDX                                                        2
#define regHUBPREQ1_HUBPREQ_STATUS_REG2                                                                 0x0747
#define regHUBPREQ1_HUBPREQ_STATUS_REG2_BASE_IDX                                                        2


// addressBlock: dce_dc_dcbubp1_dispdec_hubpret_dispdec
// base address: 0x370
#define regHUBPRET1_HUBPRET_CONTROL                                                                     0x0748
#define regHUBPRET1_HUBPRET_CONTROL_BASE_IDX                                                            2
#define regHUBPRET1_HUBPRET_MEM_PWR_CTRL                                                                0x0749
#define regHUBPRET1_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regHUBPRET1_HUBPRET_MEM_PWR_STATUS                                                              0x074a
#define regHUBPRET1_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regHUBPRET1_HUBPRET_READ_LINE_CTRL0                                                             0x074b
#define regHUBPRET1_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define regHUBPRET1_HUBPRET_READ_LINE_CTRL1                                                             0x074c
#define regHUBPRET1_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define regHUBPRET1_HUBPRET_READ_LINE0                                                                  0x074d
#define regHUBPRET1_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define regHUBPRET1_HUBPRET_READ_LINE1                                                                  0x074e
#define regHUBPRET1_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define regHUBPRET1_HUBPRET_INTERRUPT                                                                   0x074f
#define regHUBPRET1_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define regHUBPRET1_HUBPRET_READ_LINE_VALUE                                                             0x0750
#define regHUBPRET1_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define regHUBPRET1_HUBPRET_READ_LINE_STATUS                                                            0x0751
#define regHUBPRET1_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp1_dispdec_cursor0_dispdec
// base address: 0x370
#define regCURSOR0_1_CURSOR_CONTROL                                                                     0x0754
#define regCURSOR0_1_CURSOR_CONTROL_BASE_IDX                                                            2
#define regCURSOR0_1_CURSOR_SURFACE_ADDRESS                                                             0x0755
#define regCURSOR0_1_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define regCURSOR0_1_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x0756
#define regCURSOR0_1_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define regCURSOR0_1_CURSOR_SIZE                                                                        0x0757
#define regCURSOR0_1_CURSOR_SIZE_BASE_IDX                                                               2
#define regCURSOR0_1_CURSOR_POSITION                                                                    0x0758
#define regCURSOR0_1_CURSOR_POSITION_BASE_IDX                                                           2
#define regCURSOR0_1_CURSOR_HOT_SPOT                                                                    0x0759
#define regCURSOR0_1_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define regCURSOR0_1_CURSOR_STEREO_CONTROL                                                              0x075a
#define regCURSOR0_1_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define regCURSOR0_1_CURSOR_DST_OFFSET                                                                  0x075b
#define regCURSOR0_1_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define regCURSOR0_1_CURSOR_MEM_PWR_CTRL                                                                0x075c
#define regCURSOR0_1_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regCURSOR0_1_CURSOR_MEM_PWR_STATUS                                                              0x075d
#define regCURSOR0_1_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regCURSOR0_1_DMDATA_ADDRESS_HIGH                                                                0x075e
#define regCURSOR0_1_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define regCURSOR0_1_DMDATA_ADDRESS_LOW                                                                 0x075f
#define regCURSOR0_1_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define regCURSOR0_1_DMDATA_CNTL                                                                        0x0760
#define regCURSOR0_1_DMDATA_CNTL_BASE_IDX                                                               2
#define regCURSOR0_1_DMDATA_QOS_CNTL                                                                    0x0761
#define regCURSOR0_1_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define regCURSOR0_1_DMDATA_STATUS                                                                      0x0762
#define regCURSOR0_1_DMDATA_STATUS_BASE_IDX                                                             2
#define regCURSOR0_1_DMDATA_SW_CNTL                                                                     0x0763
#define regCURSOR0_1_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define regCURSOR0_1_DMDATA_SW_DATA                                                                     0x0764
#define regCURSOR0_1_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp1_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x1de4
#define regDC_PERFMON8_PERFCOUNTER_CNTL                                                                 0x0779
#define regDC_PERFMON8_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define regDC_PERFMON8_PERFCOUNTER_CNTL2                                                                0x077a
#define regDC_PERFMON8_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define regDC_PERFMON8_PERFCOUNTER_STATE                                                                0x077b
#define regDC_PERFMON8_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define regDC_PERFMON8_PERFMON_CNTL                                                                     0x077c
#define regDC_PERFMON8_PERFMON_CNTL_BASE_IDX                                                            2
#define regDC_PERFMON8_PERFMON_CNTL2                                                                    0x077d
#define regDC_PERFMON8_PERFMON_CNTL2_BASE_IDX                                                           2
#define regDC_PERFMON8_PERFMON_CVALUE_INT_MISC                                                          0x077e
#define regDC_PERFMON8_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define regDC_PERFMON8_PERFMON_CVALUE_LOW                                                               0x077f
#define regDC_PERFMON8_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define regDC_PERFMON8_PERFMON_HI                                                                       0x0780
#define regDC_PERFMON8_PERFMON_HI_BASE_IDX                                                              2
#define regDC_PERFMON8_PERFMON_LOW                                                                      0x0781
#define regDC_PERFMON8_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dcbubp2_dispdec_hubp_dispdec
// base address: 0x6e0
#define regHUBP2_DCSURF_SURFACE_CONFIG                                                                  0x079d
#define regHUBP2_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define regHUBP2_DCSURF_ADDR_CONFIG                                                                     0x079e
#define regHUBP2_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define regHUBP2_DCSURF_TILING_CONFIG                                                                   0x079f
#define regHUBP2_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define regHUBP2_DCSURF_PRI_VIEWPORT_START                                                              0x07a1
#define regHUBP2_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define regHUBP2_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x07a2
#define regHUBP2_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define regHUBP2_DCSURF_PRI_VIEWPORT_START_C                                                            0x07a3
#define regHUBP2_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define regHUBP2_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x07a4
#define regHUBP2_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define regHUBP2_DCSURF_SEC_VIEWPORT_START                                                              0x07a5
#define regHUBP2_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define regHUBP2_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x07a6
#define regHUBP2_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define regHUBP2_DCSURF_SEC_VIEWPORT_START_C                                                            0x07a7
#define regHUBP2_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define regHUBP2_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x07a8
#define regHUBP2_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define regHUBP2_DCHUBP_REQ_SIZE_CONFIG                                                                 0x07a9
#define regHUBP2_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define regHUBP2_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x07aa
#define regHUBP2_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define regHUBP2_DCHUBP_CNTL                                                                            0x07ab
#define regHUBP2_DCHUBP_CNTL_BASE_IDX                                                                   2
#define regHUBP2_HUBP_CLK_CNTL                                                                          0x07ac
#define regHUBP2_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define regHUBP2_DCHUBP_VMPG_CONFIG                                                                     0x07ad
#define regHUBP2_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define regHUBP2_DCHUBP_MALL_CONFIG                                                                     0x07ae
#define regHUBP2_DCHUBP_MALL_CONFIG_BASE_IDX                                                            2
#define regHUBP2_DCHUBP_MALL_SUB_VP                                                                     0x07af
#define regHUBP2_DCHUBP_MALL_SUB_VP_BASE_IDX                                                            2
#define regHUBP2_HUBPREQ_DEBUG_DB                                                                       0x07b0
#define regHUBP2_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define regHUBP2_HUBPREQ_DEBUG                                                                          0x07b1
#define regHUBP2_HUBPREQ_DEBUG_BASE_IDX                                                                 2
#define regHUBP2_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x07b5
#define regHUBP2_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define regHUBP2_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x07b6
#define regHUBP2_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2
#define regHUBP2_HUBP_MALL_STATUS                                                                       0x07b7
#define regHUBP2_HUBP_MALL_STATUS_BASE_IDX                                                              2


// addressBlock: dce_dc_dcbubp2_dispdec_hubpreq_dispdec
// base address: 0x6e0
#define regHUBPREQ2_DCSURF_SURFACE_PITCH                                                                0x07bf
#define regHUBPREQ2_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define regHUBPREQ2_DCSURF_SURFACE_PITCH_C                                                              0x07c0
#define regHUBPREQ2_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define regHUBPREQ2_VMID_SETTINGS_0                                                                     0x07c1
#define regHUBPREQ2_VMID_SETTINGS_0_BASE_IDX                                                            2
#define regHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x07c2
#define regHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define regHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x07c3
#define regHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define regHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x07c4
#define regHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define regHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x07c5
#define regHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define regHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x07c6
#define regHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define regHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x07c7
#define regHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define regHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x07c8
#define regHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define regHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x07c9
#define regHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define regHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x07ca
#define regHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define regHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x07cb
#define regHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define regHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x07cc
#define regHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define regHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x07cd
#define regHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define regHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x07ce
#define regHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define regHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x07cf
#define regHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define regHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x07d0
#define regHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define regHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x07d1
#define regHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define regHUBPREQ2_DCSURF_SURFACE_CONTROL                                                              0x07d2
#define regHUBPREQ2_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define regHUBPREQ2_DCSURF_FLIP_CONTROL                                                                 0x07d3
#define regHUBPREQ2_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define regHUBPREQ2_DCSURF_FLIP_CONTROL2                                                                0x07d4
#define regHUBPREQ2_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define regHUBPREQ2_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x07d7
#define regHUBPREQ2_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define regHUBPREQ2_DCSURF_SURFACE_INUSE                                                                0x07d8
#define regHUBPREQ2_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define regHUBPREQ2_DCSURF_SURFACE_INUSE_HIGH                                                           0x07d9
#define regHUBPREQ2_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define regHUBPREQ2_DCSURF_SURFACE_INUSE_C                                                              0x07da
#define regHUBPREQ2_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define regHUBPREQ2_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x07db
#define regHUBPREQ2_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define regHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x07dc
#define regHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define regHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x07dd
#define regHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define regHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x07de
#define regHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define regHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x07df
#define regHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define regHUBPREQ2_DCN_EXPANSION_MODE                                                                  0x07e0
#define regHUBPREQ2_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define regHUBPREQ2_DCN_TTU_QOS_WM                                                                      0x07e1
#define regHUBPREQ2_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define regHUBPREQ2_DCN_GLOBAL_TTU_CNTL                                                                 0x07e2
#define regHUBPREQ2_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define regHUBPREQ2_DCN_SURF0_TTU_CNTL0                                                                 0x07e3
#define regHUBPREQ2_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define regHUBPREQ2_DCN_SURF0_TTU_CNTL1                                                                 0x07e4
#define regHUBPREQ2_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define regHUBPREQ2_DCN_SURF1_TTU_CNTL0                                                                 0x07e5
#define regHUBPREQ2_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define regHUBPREQ2_DCN_SURF1_TTU_CNTL1                                                                 0x07e6
#define regHUBPREQ2_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define regHUBPREQ2_DCN_CUR0_TTU_CNTL0                                                                  0x07e7
#define regHUBPREQ2_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define regHUBPREQ2_DCN_CUR0_TTU_CNTL1                                                                  0x07e8
#define regHUBPREQ2_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define regHUBPREQ2_DCN_CUR1_TTU_CNTL0                                                                  0x07e9
#define regHUBPREQ2_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define regHUBPREQ2_DCN_CUR1_TTU_CNTL1                                                                  0x07ea
#define regHUBPREQ2_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define regHUBPREQ2_DCN_DMDATA_VM_CNTL                                                                  0x07eb
#define regHUBPREQ2_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define regHUBPREQ2_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x07ec
#define regHUBPREQ2_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define regHUBPREQ2_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x07ed
#define regHUBPREQ2_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define regHUBPREQ2_DCN_VM_MX_L1_TLB_CNTL                                                               0x07fa
#define regHUBPREQ2_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define regHUBPREQ2_BLANK_OFFSET_0                                                                      0x07fb
#define regHUBPREQ2_BLANK_OFFSET_0_BASE_IDX                                                             2
#define regHUBPREQ2_BLANK_OFFSET_1                                                                      0x07fc
#define regHUBPREQ2_BLANK_OFFSET_1_BASE_IDX                                                             2
#define regHUBPREQ2_DST_DIMENSIONS                                                                      0x07fd
#define regHUBPREQ2_DST_DIMENSIONS_BASE_IDX                                                             2
#define regHUBPREQ2_DST_AFTER_SCALER                                                                    0x07fe
#define regHUBPREQ2_DST_AFTER_SCALER_BASE_IDX                                                           2
#define regHUBPREQ2_PREFETCH_SETTINGS                                                                   0x07ff
#define regHUBPREQ2_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define regHUBPREQ2_PREFETCH_SETTINGS_C                                                                 0x0800
#define regHUBPREQ2_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define regHUBPREQ2_VBLANK_PARAMETERS_0                                                                 0x0801
#define regHUBPREQ2_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define regHUBPREQ2_VBLANK_PARAMETERS_1                                                                 0x0802
#define regHUBPREQ2_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define regHUBPREQ2_VBLANK_PARAMETERS_2                                                                 0x0803
#define regHUBPREQ2_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define regHUBPREQ2_VBLANK_PARAMETERS_3                                                                 0x0804
#define regHUBPREQ2_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define regHUBPREQ2_VBLANK_PARAMETERS_4                                                                 0x0805
#define regHUBPREQ2_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define regHUBPREQ2_FLIP_PARAMETERS_0                                                                   0x0806
#define regHUBPREQ2_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define regHUBPREQ2_FLIP_PARAMETERS_1                                                                   0x0807
#define regHUBPREQ2_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define regHUBPREQ2_FLIP_PARAMETERS_2                                                                   0x0808
#define regHUBPREQ2_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define regHUBPREQ2_NOM_PARAMETERS_0                                                                    0x0809
#define regHUBPREQ2_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define regHUBPREQ2_NOM_PARAMETERS_1                                                                    0x080a
#define regHUBPREQ2_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define regHUBPREQ2_NOM_PARAMETERS_2                                                                    0x080b
#define regHUBPREQ2_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define regHUBPREQ2_NOM_PARAMETERS_3                                                                    0x080c
#define regHUBPREQ2_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define regHUBPREQ2_NOM_PARAMETERS_4                                                                    0x080d
#define regHUBPREQ2_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define regHUBPREQ2_NOM_PARAMETERS_5                                                                    0x080e
#define regHUBPREQ2_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define regHUBPREQ2_NOM_PARAMETERS_6                                                                    0x080f
#define regHUBPREQ2_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define regHUBPREQ2_NOM_PARAMETERS_7                                                                    0x0810
#define regHUBPREQ2_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define regHUBPREQ2_PER_LINE_DELIVERY_PRE                                                               0x0811
#define regHUBPREQ2_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define regHUBPREQ2_PER_LINE_DELIVERY                                                                   0x0812
#define regHUBPREQ2_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define regHUBPREQ2_CURSOR_SETTINGS                                                                     0x0813
#define regHUBPREQ2_CURSOR_SETTINGS_BASE_IDX                                                            2
#define regHUBPREQ2_REF_FREQ_TO_PIX_FREQ                                                                0x0814
#define regHUBPREQ2_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define regHUBPREQ2_DST_Y_DELTA_DRQ_LIMIT                                                               0x0815
#define regHUBPREQ2_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define regHUBPREQ2_HUBPREQ_MEM_PWR_CTRL                                                                0x0816
#define regHUBPREQ2_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regHUBPREQ2_HUBPREQ_MEM_PWR_STATUS                                                              0x0817
#define regHUBPREQ2_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regHUBPREQ2_VBLANK_PARAMETERS_5                                                                 0x081a
#define regHUBPREQ2_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define regHUBPREQ2_VBLANK_PARAMETERS_6                                                                 0x081b
#define regHUBPREQ2_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define regHUBPREQ2_FLIP_PARAMETERS_3                                                                   0x081c
#define regHUBPREQ2_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define regHUBPREQ2_FLIP_PARAMETERS_4                                                                   0x081d
#define regHUBPREQ2_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define regHUBPREQ2_FLIP_PARAMETERS_5                                                                   0x081e
#define regHUBPREQ2_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define regHUBPREQ2_FLIP_PARAMETERS_6                                                                   0x081f
#define regHUBPREQ2_FLIP_PARAMETERS_6_BASE_IDX                                                          2
#define regHUBPREQ2_UCLK_PSTATE_FORCE                                                                   0x0820
#define regHUBPREQ2_UCLK_PSTATE_FORCE_BASE_IDX                                                          2
#define regHUBPREQ2_HUBPREQ_STATUS_REG0                                                                 0x0821
#define regHUBPREQ2_HUBPREQ_STATUS_REG0_BASE_IDX                                                        2
#define regHUBPREQ2_HUBPREQ_STATUS_REG1                                                                 0x0822
#define regHUBPREQ2_HUBPREQ_STATUS_REG1_BASE_IDX                                                        2
#define regHUBPREQ2_HUBPREQ_STATUS_REG2                                                                 0x0823
#define regHUBPREQ2_HUBPREQ_STATUS_REG2_BASE_IDX                                                        2


// addressBlock: dce_dc_dcbubp2_dispdec_hubpret_dispdec
// base address: 0x6e0
#define regHUBPRET2_HUBPRET_CONTROL                                                                     0x0824
#define regHUBPRET2_HUBPRET_CONTROL_BASE_IDX                                                            2
#define regHUBPRET2_HUBPRET_MEM_PWR_CTRL                                                                0x0825
#define regHUBPRET2_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regHUBPRET2_HUBPRET_MEM_PWR_STATUS                                                              0x0826
#define regHUBPRET2_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regHUBPRET2_HUBPRET_READ_LINE_CTRL0                                                             0x0827
#define regHUBPRET2_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define regHUBPRET2_HUBPRET_READ_LINE_CTRL1                                                             0x0828
#define regHUBPRET2_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define regHUBPRET2_HUBPRET_READ_LINE0                                                                  0x0829
#define regHUBPRET2_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define regHUBPRET2_HUBPRET_READ_LINE1                                                                  0x082a
#define regHUBPRET2_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define regHUBPRET2_HUBPRET_INTERRUPT                                                                   0x082b
#define regHUBPRET2_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define regHUBPRET2_HUBPRET_READ_LINE_VALUE                                                             0x082c
#define regHUBPRET2_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define regHUBPRET2_HUBPRET_READ_LINE_STATUS                                                            0x082d
#define regHUBPRET2_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp2_dispdec_cursor0_dispdec
// base address: 0x6e0
#define regCURSOR0_2_CURSOR_CONTROL                                                                     0x0830
#define regCURSOR0_2_CURSOR_CONTROL_BASE_IDX                                                            2
#define regCURSOR0_2_CURSOR_SURFACE_ADDRESS                                                             0x0831
#define regCURSOR0_2_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define regCURSOR0_2_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x0832
#define regCURSOR0_2_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define regCURSOR0_2_CURSOR_SIZE                                                                        0x0833
#define regCURSOR0_2_CURSOR_SIZE_BASE_IDX                                                               2
#define regCURSOR0_2_CURSOR_POSITION                                                                    0x0834
#define regCURSOR0_2_CURSOR_POSITION_BASE_IDX                                                           2
#define regCURSOR0_2_CURSOR_HOT_SPOT                                                                    0x0835
#define regCURSOR0_2_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define regCURSOR0_2_CURSOR_STEREO_CONTROL                                                              0x0836
#define regCURSOR0_2_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define regCURSOR0_2_CURSOR_DST_OFFSET                                                                  0x0837
#define regCURSOR0_2_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define regCURSOR0_2_CURSOR_MEM_PWR_CTRL                                                                0x0838
#define regCURSOR0_2_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regCURSOR0_2_CURSOR_MEM_PWR_STATUS                                                              0x0839
#define regCURSOR0_2_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regCURSOR0_2_DMDATA_ADDRESS_HIGH                                                                0x083a
#define regCURSOR0_2_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define regCURSOR0_2_DMDATA_ADDRESS_LOW                                                                 0x083b
#define regCURSOR0_2_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define regCURSOR0_2_DMDATA_CNTL                                                                        0x083c
#define regCURSOR0_2_DMDATA_CNTL_BASE_IDX                                                               2
#define regCURSOR0_2_DMDATA_QOS_CNTL                                                                    0x083d
#define regCURSOR0_2_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define regCURSOR0_2_DMDATA_STATUS                                                                      0x083e
#define regCURSOR0_2_DMDATA_STATUS_BASE_IDX                                                             2
#define regCURSOR0_2_DMDATA_SW_CNTL                                                                     0x083f
#define regCURSOR0_2_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define regCURSOR0_2_DMDATA_SW_DATA                                                                     0x0840
#define regCURSOR0_2_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp2_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x2154
#define regDC_PERFMON9_PERFCOUNTER_CNTL                                                                 0x0855
#define regDC_PERFMON9_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define regDC_PERFMON9_PERFCOUNTER_CNTL2                                                                0x0856
#define regDC_PERFMON9_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define regDC_PERFMON9_PERFCOUNTER_STATE                                                                0x0857
#define regDC_PERFMON9_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define regDC_PERFMON9_PERFMON_CNTL                                                                     0x0858
#define regDC_PERFMON9_PERFMON_CNTL_BASE_IDX                                                            2
#define regDC_PERFMON9_PERFMON_CNTL2                                                                    0x0859
#define regDC_PERFMON9_PERFMON_CNTL2_BASE_IDX                                                           2
#define regDC_PERFMON9_PERFMON_CVALUE_INT_MISC                                                          0x085a
#define regDC_PERFMON9_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define regDC_PERFMON9_PERFMON_CVALUE_LOW                                                               0x085b
#define regDC_PERFMON9_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define regDC_PERFMON9_PERFMON_HI                                                                       0x085c
#define regDC_PERFMON9_PERFMON_HI_BASE_IDX                                                              2
#define regDC_PERFMON9_PERFMON_LOW                                                                      0x085d
#define regDC_PERFMON9_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dcbubp3_dispdec_hubp_dispdec
// base address: 0xa50
#define regHUBP3_DCSURF_SURFACE_CONFIG                                                                  0x0879
#define regHUBP3_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define regHUBP3_DCSURF_ADDR_CONFIG                                                                     0x087a
#define regHUBP3_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define regHUBP3_DCSURF_TILING_CONFIG                                                                   0x087b
#define regHUBP3_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define regHUBP3_DCSURF_PRI_VIEWPORT_START                                                              0x087d
#define regHUBP3_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define regHUBP3_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x087e
#define regHUBP3_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define regHUBP3_DCSURF_PRI_VIEWPORT_START_C                                                            0x087f
#define regHUBP3_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define regHUBP3_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x0880
#define regHUBP3_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define regHUBP3_DCSURF_SEC_VIEWPORT_START                                                              0x0881
#define regHUBP3_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define regHUBP3_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x0882
#define regHUBP3_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define regHUBP3_DCSURF_SEC_VIEWPORT_START_C                                                            0x0883
#define regHUBP3_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define regHUBP3_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x0884
#define regHUBP3_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define regHUBP3_DCHUBP_REQ_SIZE_CONFIG                                                                 0x0885
#define regHUBP3_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define regHUBP3_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x0886
#define regHUBP3_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define regHUBP3_DCHUBP_CNTL                                                                            0x0887
#define regHUBP3_DCHUBP_CNTL_BASE_IDX                                                                   2
#define regHUBP3_HUBP_CLK_CNTL                                                                          0x0888
#define regHUBP3_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define regHUBP3_DCHUBP_VMPG_CONFIG                                                                     0x0889
#define regHUBP3_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define regHUBP3_DCHUBP_MALL_CONFIG                                                                     0x088a
#define regHUBP3_DCHUBP_MALL_CONFIG_BASE_IDX                                                            2
#define regHUBP3_DCHUBP_MALL_SUB_VP                                                                     0x088b
#define regHUBP3_DCHUBP_MALL_SUB_VP_BASE_IDX                                                            2
#define regHUBP3_HUBPREQ_DEBUG_DB                                                                       0x088c
#define regHUBP3_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define regHUBP3_HUBPREQ_DEBUG                                                                          0x088d
#define regHUBP3_HUBPREQ_DEBUG_BASE_IDX                                                                 2
#define regHUBP3_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x0891
#define regHUBP3_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define regHUBP3_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x0892
#define regHUBP3_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2
#define regHUBP3_HUBP_MALL_STATUS                                                                       0x0893
#define regHUBP3_HUBP_MALL_STATUS_BASE_IDX                                                              2


// addressBlock: dce_dc_dcbubp3_dispdec_hubpreq_dispdec
// base address: 0xa50
#define regHUBPREQ3_DCSURF_SURFACE_PITCH                                                                0x089b
#define regHUBPREQ3_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define regHUBPREQ3_DCSURF_SURFACE_PITCH_C                                                              0x089c
#define regHUBPREQ3_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define regHUBPREQ3_VMID_SETTINGS_0                                                                     0x089d
#define regHUBPREQ3_VMID_SETTINGS_0_BASE_IDX                                                            2
#define regHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x089e
#define regHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define regHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x089f
#define regHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define regHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x08a0
#define regHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define regHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x08a1
#define regHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define regHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x08a2
#define regHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define regHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x08a3
#define regHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define regHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x08a4
#define regHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define regHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x08a5
#define regHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define regHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x08a6
#define regHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define regHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x08a7
#define regHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define regHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x08a8
#define regHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define regHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x08a9
#define regHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define regHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x08aa
#define regHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define regHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x08ab
#define regHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define regHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x08ac
#define regHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define regHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x08ad
#define regHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define regHUBPREQ3_DCSURF_SURFACE_CONTROL                                                              0x08ae
#define regHUBPREQ3_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define regHUBPREQ3_DCSURF_FLIP_CONTROL                                                                 0x08af
#define regHUBPREQ3_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define regHUBPREQ3_DCSURF_FLIP_CONTROL2                                                                0x08b0
#define regHUBPREQ3_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define regHUBPREQ3_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x08b3
#define regHUBPREQ3_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define regHUBPREQ3_DCSURF_SURFACE_INUSE                                                                0x08b4
#define regHUBPREQ3_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define regHUBPREQ3_DCSURF_SURFACE_INUSE_HIGH                                                           0x08b5
#define regHUBPREQ3_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define regHUBPREQ3_DCSURF_SURFACE_INUSE_C                                                              0x08b6
#define regHUBPREQ3_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define regHUBPREQ3_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x08b7
#define regHUBPREQ3_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define regHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x08b8
#define regHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define regHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x08b9
#define regHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define regHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x08ba
#define regHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define regHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x08bb
#define regHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define regHUBPREQ3_DCN_EXPANSION_MODE                                                                  0x08bc
#define regHUBPREQ3_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define regHUBPREQ3_DCN_TTU_QOS_WM                                                                      0x08bd
#define regHUBPREQ3_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define regHUBPREQ3_DCN_GLOBAL_TTU_CNTL                                                                 0x08be
#define regHUBPREQ3_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define regHUBPREQ3_DCN_SURF0_TTU_CNTL0                                                                 0x08bf
#define regHUBPREQ3_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define regHUBPREQ3_DCN_SURF0_TTU_CNTL1                                                                 0x08c0
#define regHUBPREQ3_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define regHUBPREQ3_DCN_SURF1_TTU_CNTL0                                                                 0x08c1
#define regHUBPREQ3_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define regHUBPREQ3_DCN_SURF1_TTU_CNTL1                                                                 0x08c2
#define regHUBPREQ3_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define regHUBPREQ3_DCN_CUR0_TTU_CNTL0                                                                  0x08c3
#define regHUBPREQ3_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define regHUBPREQ3_DCN_CUR0_TTU_CNTL1                                                                  0x08c4
#define regHUBPREQ3_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define regHUBPREQ3_DCN_CUR1_TTU_CNTL0                                                                  0x08c5
#define regHUBPREQ3_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define regHUBPREQ3_DCN_CUR1_TTU_CNTL1                                                                  0x08c6
#define regHUBPREQ3_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define regHUBPREQ3_DCN_DMDATA_VM_CNTL                                                                  0x08c7
#define regHUBPREQ3_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define regHUBPREQ3_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x08c8
#define regHUBPREQ3_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define regHUBPREQ3_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x08c9
#define regHUBPREQ3_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define regHUBPREQ3_DCN_VM_MX_L1_TLB_CNTL                                                               0x08d6
#define regHUBPREQ3_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define regHUBPREQ3_BLANK_OFFSET_0                                                                      0x08d7
#define regHUBPREQ3_BLANK_OFFSET_0_BASE_IDX                                                             2
#define regHUBPREQ3_BLANK_OFFSET_1                                                                      0x08d8
#define regHUBPREQ3_BLANK_OFFSET_1_BASE_IDX                                                             2
#define regHUBPREQ3_DST_DIMENSIONS                                                                      0x08d9
#define regHUBPREQ3_DST_DIMENSIONS_BASE_IDX                                                             2
#define regHUBPREQ3_DST_AFTER_SCALER                                                                    0x08da
#define regHUBPREQ3_DST_AFTER_SCALER_BASE_IDX                                                           2
#define regHUBPREQ3_PREFETCH_SETTINGS                                                                   0x08db
#define regHUBPREQ3_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define regHUBPREQ3_PREFETCH_SETTINGS_C                                                                 0x08dc
#define regHUBPREQ3_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define regHUBPREQ3_VBLANK_PARAMETERS_0                                                                 0x08dd
#define regHUBPREQ3_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define regHUBPREQ3_VBLANK_PARAMETERS_1                                                                 0x08de
#define regHUBPREQ3_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define regHUBPREQ3_VBLANK_PARAMETERS_2                                                                 0x08df
#define regHUBPREQ3_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define regHUBPREQ3_VBLANK_PARAMETERS_3                                                                 0x08e0
#define regHUBPREQ3_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define regHUBPREQ3_VBLANK_PARAMETERS_4                                                                 0x08e1
#define regHUBPREQ3_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define regHUBPREQ3_FLIP_PARAMETERS_0                                                                   0x08e2
#define regHUBPREQ3_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define regHUBPREQ3_FLIP_PARAMETERS_1                                                                   0x08e3
#define regHUBPREQ3_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define regHUBPREQ3_FLIP_PARAMETERS_2                                                                   0x08e4
#define regHUBPREQ3_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define regHUBPREQ3_NOM_PARAMETERS_0                                                                    0x08e5
#define regHUBPREQ3_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define regHUBPREQ3_NOM_PARAMETERS_1                                                                    0x08e6
#define regHUBPREQ3_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define regHUBPREQ3_NOM_PARAMETERS_2                                                                    0x08e7
#define regHUBPREQ3_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define regHUBPREQ3_NOM_PARAMETERS_3                                                                    0x08e8
#define regHUBPREQ3_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define regHUBPREQ3_NOM_PARAMETERS_4                                                                    0x08e9
#define regHUBPREQ3_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define regHUBPREQ3_NOM_PARAMETERS_5                                                                    0x08ea
#define regHUBPREQ3_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define regHUBPREQ3_NOM_PARAMETERS_6                                                                    0x08eb
#define regHUBPREQ3_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define regHUBPREQ3_NOM_PARAMETERS_7                                                                    0x08ec
#define regHUBPREQ3_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define regHUBPREQ3_PER_LINE_DELIVERY_PRE                                                               0x08ed
#define regHUBPREQ3_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define regHUBPREQ3_PER_LINE_DELIVERY                                                                   0x08ee
#define regHUBPREQ3_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define regHUBPREQ3_CURSOR_SETTINGS                                                                     0x08ef
#define regHUBPREQ3_CURSOR_SETTINGS_BASE_IDX                                                            2
#define regHUBPREQ3_REF_FREQ_TO_PIX_FREQ                                                                0x08f0
#define regHUBPREQ3_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define regHUBPREQ3_DST_Y_DELTA_DRQ_LIMIT                                                               0x08f1
#define regHUBPREQ3_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define regHUBPREQ3_HUBPREQ_MEM_PWR_CTRL                                                                0x08f2
#define regHUBPREQ3_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regHUBPREQ3_HUBPREQ_MEM_PWR_STATUS                                                              0x08f3
#define regHUBPREQ3_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regHUBPREQ3_VBLANK_PARAMETERS_5                                                                 0x08f6
#define regHUBPREQ3_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define regHUBPREQ3_VBLANK_PARAMETERS_6                                                                 0x08f7
#define regHUBPREQ3_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define regHUBPREQ3_FLIP_PARAMETERS_3                                                                   0x08f8
#define regHUBPREQ3_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define regHUBPREQ3_FLIP_PARAMETERS_4                                                                   0x08f9
#define regHUBPREQ3_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define regHUBPREQ3_FLIP_PARAMETERS_5                                                                   0x08fa
#define regHUBPREQ3_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define regHUBPREQ3_FLIP_PARAMETERS_6                                                                   0x08fb
#define regHUBPREQ3_FLIP_PARAMETERS_6_BASE_IDX                                                          2
#define regHUBPREQ3_UCLK_PSTATE_FORCE                                                                   0x08fc
#define regHUBPREQ3_UCLK_PSTATE_FORCE_BASE_IDX                                                          2
#define regHUBPREQ3_HUBPREQ_STATUS_REG0                                                                 0x08fd
#define regHUBPREQ3_HUBPREQ_STATUS_REG0_BASE_IDX                                                        2
#define regHUBPREQ3_HUBPREQ_STATUS_REG1                                                                 0x08fe
#define regHUBPREQ3_HUBPREQ_STATUS_REG1_BASE_IDX                                                        2
#define regHUBPREQ3_HUBPREQ_STATUS_REG2                                                                 0x08ff
#define regHUBPREQ3_HUBPREQ_STATUS_REG2_BASE_IDX                                                        2


// addressBlock: dce_dc_dcbubp3_dispdec_hubpret_dispdec
// base address: 0xa50
#define regHUBPRET3_HUBPRET_CONTROL                                                                     0x0900
#define regHUBPRET3_HUBPRET_CONTROL_BASE_IDX                                                            2
#define regHUBPRET3_HUBPRET_MEM_PWR_CTRL                                                                0x0901
#define regHUBPRET3_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regHUBPRET3_HUBPRET_MEM_PWR_STATUS                                                              0x0902
#define regHUBPRET3_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regHUBPRET3_HUBPRET_READ_LINE_CTRL0                                                             0x0903
#define regHUBPRET3_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define regHUBPRET3_HUBPRET_READ_LINE_CTRL1                                                             0x0904
#define regHUBPRET3_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define regHUBPRET3_HUBPRET_READ_LINE0                                                                  0x0905
#define regHUBPRET3_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define regHUBPRET3_HUBPRET_READ_LINE1                                                                  0x0906
#define regHUBPRET3_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define regHUBPRET3_HUBPRET_INTERRUPT                                                                   0x0907
#define regHUBPRET3_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define regHUBPRET3_HUBPRET_READ_LINE_VALUE                                                             0x0908
#define regHUBPRET3_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define regHUBPRET3_HUBPRET_READ_LINE_STATUS                                                            0x0909
#define regHUBPRET3_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp3_dispdec_cursor0_dispdec
// base address: 0xa50
#define regCURSOR0_3_CURSOR_CONTROL                                                                     0x090c
#define regCURSOR0_3_CURSOR_CONTROL_BASE_IDX                                                            2
#define regCURSOR0_3_CURSOR_SURFACE_ADDRESS                                                             0x090d
#define regCURSOR0_3_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define regCURSOR0_3_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x090e
#define regCURSOR0_3_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define regCURSOR0_3_CURSOR_SIZE                                                                        0x090f
#define regCURSOR0_3_CURSOR_SIZE_BASE_IDX                                                               2
#define regCURSOR0_3_CURSOR_POSITION                                                                    0x0910
#define regCURSOR0_3_CURSOR_POSITION_BASE_IDX                                                           2
#define regCURSOR0_3_CURSOR_HOT_SPOT                                                                    0x0911
#define regCURSOR0_3_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define regCURSOR0_3_CURSOR_STEREO_CONTROL                                                              0x0912
#define regCURSOR0_3_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define regCURSOR0_3_CURSOR_DST_OFFSET                                                                  0x0913
#define regCURSOR0_3_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define regCURSOR0_3_CURSOR_MEM_PWR_CTRL                                                                0x0914
#define regCURSOR0_3_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define regCURSOR0_3_CURSOR_MEM_PWR_STATUS                                                              0x0915
#define regCURSOR0_3_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define regCURSOR0_3_DMDATA_ADDRESS_HIGH                                                                0x0916
#define regCURSOR0_3_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define regCURSOR0_3_DMDATA_ADDRESS_LOW                                                                 0x0917
#define regCURSOR0_3_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define regCURSOR0_3_DMDATA_CNTL                                                                        0x0918
#define regCURSOR0_3_DMDATA_CNTL_BASE_IDX                                                               2
#define regCURSOR0_3_DMDATA_QOS_CNTL                                                                    0x0919
#define regCURSOR0_3_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define regCURSOR0_3_DMDATA_STATUS                                                                      0x091a
#define regCURSOR0_3_DMDATA_STATUS_BASE_IDX                                                             2
#define regCURSOR0_3_DMDATA_SW_CNTL                                                                     0x091b
#define regCURSOR0_3_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define regCURSOR0_3_DMDATA_SW_DATA                                                                     0x091c
#define regCURSOR0_3_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp3_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x24c4
#define regDC_PERFMON10_PERFCOUNTER_CNTL                                                                0x0931
#define regDC_PERFMON10_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define regDC_PERFMON10_PERFCOUNTER_CNTL2                                                               0x0932
#define regDC_PERFMON10_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define regDC_PERFMON10_PERFCOUNTER_STATE                                                               0x0933
#define regDC_PERFMON10_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define regDC_PERFMON10_PERFMON_CNTL                                                                    0x0934
#define regDC_PERFMON10_PERFMON_CNTL_BASE_IDX                                                           2
#define regDC_PERFMON10_PERFMON_CNTL2                                                                   0x0935
#define regDC_PERFMON10_PERFMON_CNTL2_BASE_IDX                                                          2
#define regDC_PERFMON10_PERFMON_CVALUE_INT_MISC                                                         0x0936
#define regDC_PERFMON10_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define regDC_PERFMON10_PERFMON_CVALUE_LOW                                                              0x0937
#define regDC_PERFMON10_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define regDC_PERFMON10_PERFMON_HI                                                                      0x0938
#define regDC_PERFMON10_PERFMON_HI_BASE_IDX                                                             2
#define regDC_PERFMON10_PERFMON_LOW                                                                     0x0939
#define regDC_PERFMON10_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dpp0_dispdec_dpp_top_dispdec
// base address: 0x0
#define regDPP_TOP0_DPP_CONTROL                                                                         0x0cc5
#define regDPP_TOP0_DPP_CONTROL_BASE_IDX                                                                2
#define regDPP_TOP0_DPP_SOFT_RESET                                                                      0x0cc6
#define regDPP_TOP0_DPP_SOFT_RESET_BASE_IDX                                                             2
#define regDPP_TOP0_DPP_CRC_VAL_R_G                                                                     0x0cc7
#define regDPP_TOP0_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define regDPP_TOP0_DPP_CRC_VAL_B_A                                                                     0x0cc8
#define regDPP_TOP0_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define regDPP_TOP0_DPP_CRC_CTRL                                                                        0x0cc9
#define regDPP_TOP0_DPP_CRC_CTRL_BASE_IDX                                                               2
#define regDPP_TOP0_HOST_READ_CONTROL                                                                   0x0cca
#define regDPP_TOP0_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp0_dispdec_cnvc_cfg_dispdec
// base address: 0x0
#define regCNVC_CFG0_CNVC_SURFACE_PIXEL_FORMAT                                                          0x0ccf
#define regCNVC_CFG0_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define regCNVC_CFG0_FORMAT_CONTROL                                                                     0x0cd0
#define regCNVC_CFG0_FORMAT_CONTROL_BASE_IDX                                                            2
#define regCNVC_CFG0_FCNV_FP_BIAS_R                                                                     0x0cd1
#define regCNVC_CFG0_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define regCNVC_CFG0_FCNV_FP_BIAS_G                                                                     0x0cd2
#define regCNVC_CFG0_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define regCNVC_CFG0_FCNV_FP_BIAS_B                                                                     0x0cd3
#define regCNVC_CFG0_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define regCNVC_CFG0_FCNV_FP_SCALE_R                                                                    0x0cd4
#define regCNVC_CFG0_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define regCNVC_CFG0_FCNV_FP_SCALE_G                                                                    0x0cd5
#define regCNVC_CFG0_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define regCNVC_CFG0_FCNV_FP_SCALE_B                                                                    0x0cd6
#define regCNVC_CFG0_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define regCNVC_CFG0_COLOR_KEYER_CONTROL                                                                0x0cd7
#define regCNVC_CFG0_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define regCNVC_CFG0_COLOR_KEYER_ALPHA                                                                  0x0cd8
#define regCNVC_CFG0_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define regCNVC_CFG0_COLOR_KEYER_RED                                                                    0x0cd9
#define regCNVC_CFG0_COLOR_KEYER_RED_BASE_IDX                                                           2
#define regCNVC_CFG0_COLOR_KEYER_GREEN                                                                  0x0cda
#define regCNVC_CFG0_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define regCNVC_CFG0_COLOR_KEYER_BLUE                                                                   0x0cdb
#define regCNVC_CFG0_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define regCNVC_CFG0_ALPHA_2BIT_LUT                                                                     0x0cdd
#define regCNVC_CFG0_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define regCNVC_CFG0_PRE_DEALPHA                                                                        0x0cde
#define regCNVC_CFG0_PRE_DEALPHA_BASE_IDX                                                               2
#define regCNVC_CFG0_PRE_CSC_MODE                                                                       0x0cdf
#define regCNVC_CFG0_PRE_CSC_MODE_BASE_IDX                                                              2
#define regCNVC_CFG0_PRE_CSC_C11_C12                                                                    0x0ce0
#define regCNVC_CFG0_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define regCNVC_CFG0_PRE_CSC_C13_C14                                                                    0x0ce1
#define regCNVC_CFG0_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define regCNVC_CFG0_PRE_CSC_C21_C22                                                                    0x0ce2
#define regCNVC_CFG0_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define regCNVC_CFG0_PRE_CSC_C23_C24                                                                    0x0ce3
#define regCNVC_CFG0_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define regCNVC_CFG0_PRE_CSC_C31_C32                                                                    0x0ce4
#define regCNVC_CFG0_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define regCNVC_CFG0_PRE_CSC_C33_C34                                                                    0x0ce5
#define regCNVC_CFG0_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define regCNVC_CFG0_PRE_CSC_B_C11_C12                                                                  0x0ce6
#define regCNVC_CFG0_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define regCNVC_CFG0_PRE_CSC_B_C13_C14                                                                  0x0ce7
#define regCNVC_CFG0_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define regCNVC_CFG0_PRE_CSC_B_C21_C22                                                                  0x0ce8
#define regCNVC_CFG0_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define regCNVC_CFG0_PRE_CSC_B_C23_C24                                                                  0x0ce9
#define regCNVC_CFG0_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define regCNVC_CFG0_PRE_CSC_B_C31_C32                                                                  0x0cea
#define regCNVC_CFG0_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define regCNVC_CFG0_PRE_CSC_B_C33_C34                                                                  0x0ceb
#define regCNVC_CFG0_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define regCNVC_CFG0_CNVC_COEF_FORMAT                                                                   0x0cec
#define regCNVC_CFG0_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define regCNVC_CFG0_PRE_DEGAM                                                                          0x0ced
#define regCNVC_CFG0_PRE_DEGAM_BASE_IDX                                                                 2
#define regCNVC_CFG0_PRE_REALPHA                                                                        0x0cee
#define regCNVC_CFG0_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp0_dispdec_cnvc_cur_dispdec
// base address: 0x0
#define regCNVC_CUR0_CURSOR0_CONTROL                                                                    0x0cf1
#define regCNVC_CUR0_CURSOR0_CONTROL_BASE_IDX                                                           2
#define regCNVC_CUR0_CURSOR0_COLOR0                                                                     0x0cf2
#define regCNVC_CUR0_CURSOR0_COLOR0_BASE_IDX                                                            2
#define regCNVC_CUR0_CURSOR0_COLOR1                                                                     0x0cf3
#define regCNVC_CUR0_CURSOR0_COLOR1_BASE_IDX                                                            2
#define regCNVC_CUR0_CURSOR0_FP_SCALE_BIAS                                                              0x0cf4
#define regCNVC_CUR0_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2


// addressBlock: dce_dc_dpp0_dispdec_dscl_dispdec
// base address: 0x0
#define regDSCL0_SCL_COEF_RAM_TAP_SELECT                                                                0x0cf9
#define regDSCL0_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define regDSCL0_SCL_COEF_RAM_TAP_DATA                                                                  0x0cfa
#define regDSCL0_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define regDSCL0_SCL_MODE                                                                               0x0cfb
#define regDSCL0_SCL_MODE_BASE_IDX                                                                      2
#define regDSCL0_SCL_TAP_CONTROL                                                                        0x0cfc
#define regDSCL0_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define regDSCL0_DSCL_CONTROL                                                                           0x0cfd
#define regDSCL0_DSCL_CONTROL_BASE_IDX                                                                  2
#define regDSCL0_DSCL_2TAP_CONTROL                                                                      0x0cfe
#define regDSCL0_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define regDSCL0_SCL_MANUAL_REPLICATE_CONTROL                                                           0x0cff
#define regDSCL0_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define regDSCL0_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x0d00
#define regDSCL0_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define regDSCL0_SCL_HORZ_FILTER_INIT                                                                   0x0d01
#define regDSCL0_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define regDSCL0_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x0d02
#define regDSCL0_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define regDSCL0_SCL_HORZ_FILTER_INIT_C                                                                 0x0d03
#define regDSCL0_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define regDSCL0_SCL_VERT_FILTER_SCALE_RATIO                                                            0x0d04
#define regDSCL0_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define regDSCL0_SCL_VERT_FILTER_INIT                                                                   0x0d05
#define regDSCL0_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define regDSCL0_SCL_VERT_FILTER_INIT_BOT                                                               0x0d06
#define regDSCL0_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define regDSCL0_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x0d07
#define regDSCL0_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define regDSCL0_SCL_VERT_FILTER_INIT_C                                                                 0x0d08
#define regDSCL0_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define regDSCL0_SCL_VERT_FILTER_INIT_BOT_C                                                             0x0d09
#define regDSCL0_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define regDSCL0_SCL_BLACK_COLOR                                                                        0x0d0a
#define regDSCL0_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define regDSCL0_DSCL_UPDATE                                                                            0x0d0b
#define regDSCL0_DSCL_UPDATE_BASE_IDX                                                                   2
#define regDSCL0_DSCL_AUTOCAL                                                                           0x0d0c
#define regDSCL0_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define regDSCL0_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x0d0d
#define regDSCL0_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define regDSCL0_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x0d0e
#define regDSCL0_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define regDSCL0_OTG_H_BLANK                                                                            0x0d0f
#define regDSCL0_OTG_H_BLANK_BASE_IDX                                                                   2
#define regDSCL0_OTG_V_BLANK                                                                            0x0d10
#define regDSCL0_OTG_V_BLANK_BASE_IDX                                                                   2
#define regDSCL0_RECOUT_START                                                                           0x0d11
#define regDSCL0_RECOUT_START_BASE_IDX                                                                  2
#define regDSCL0_RECOUT_SIZE                                                                            0x0d12
#define regDSCL0_RECOUT_SIZE_BASE_IDX                                                                   2
#define regDSCL0_MPC_SIZE                                                                               0x0d13
#define regDSCL0_MPC_SIZE_BASE_IDX                                                                      2
#define regDSCL0_LB_DATA_FORMAT                                                                         0x0d14
#define regDSCL0_LB_DATA_FORMAT_BASE_IDX                                                                2
#define regDSCL0_LB_MEMORY_CTRL                                                                         0x0d15
#define regDSCL0_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define regDSCL0_LB_V_COUNTER                                                                           0x0d16
#define regDSCL0_LB_V_COUNTER_BASE_IDX                                                                  2
#define regDSCL0_DSCL_MEM_PWR_CTRL                                                                      0x0d17
#define regDSCL0_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define regDSCL0_DSCL_MEM_PWR_STATUS                                                                    0x0d18
#define regDSCL0_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define regDSCL0_OBUF_CONTROL                                                                           0x0d19
#define regDSCL0_OBUF_CONTROL_BASE_IDX                                                                  2
#define regDSCL0_OBUF_MEM_PWR_CTRL                                                                      0x0d1a
#define regDSCL0_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp0_dispdec_cm_dispdec
// base address: 0x0
#define regCM0_CM_CONTROL                                                                               0x0d20
#define regCM0_CM_CONTROL_BASE_IDX                                                                      2
#define regCM0_CM_POST_CSC_CONTROL                                                                      0x0d21
#define regCM0_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define regCM0_CM_POST_CSC_C11_C12                                                                      0x0d22
#define regCM0_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define regCM0_CM_POST_CSC_C13_C14                                                                      0x0d23
#define regCM0_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define regCM0_CM_POST_CSC_C21_C22                                                                      0x0d24
#define regCM0_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define regCM0_CM_POST_CSC_C23_C24                                                                      0x0d25
#define regCM0_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define regCM0_CM_POST_CSC_C31_C32                                                                      0x0d26
#define regCM0_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define regCM0_CM_POST_CSC_C33_C34                                                                      0x0d27
#define regCM0_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define regCM0_CM_POST_CSC_B_C11_C12                                                                    0x0d28
#define regCM0_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define regCM0_CM_POST_CSC_B_C13_C14                                                                    0x0d29
#define regCM0_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define regCM0_CM_POST_CSC_B_C21_C22                                                                    0x0d2a
#define regCM0_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define regCM0_CM_POST_CSC_B_C23_C24                                                                    0x0d2b
#define regCM0_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define regCM0_CM_POST_CSC_B_C31_C32                                                                    0x0d2c
#define regCM0_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define regCM0_CM_POST_CSC_B_C33_C34                                                                    0x0d2d
#define regCM0_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define regCM0_CM_GAMUT_REMAP_CONTROL                                                                   0x0d2e
#define regCM0_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define regCM0_CM_GAMUT_REMAP_C11_C12                                                                   0x0d2f
#define regCM0_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define regCM0_CM_GAMUT_REMAP_C13_C14                                                                   0x0d30
#define regCM0_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define regCM0_CM_GAMUT_REMAP_C21_C22                                                                   0x0d31
#define regCM0_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define regCM0_CM_GAMUT_REMAP_C23_C24                                                                   0x0d32
#define regCM0_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define regCM0_CM_GAMUT_REMAP_C31_C32                                                                   0x0d33
#define regCM0_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define regCM0_CM_GAMUT_REMAP_C33_C34                                                                   0x0d34
#define regCM0_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define regCM0_CM_GAMUT_REMAP_B_C11_C12                                                                 0x0d35
#define regCM0_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define regCM0_CM_GAMUT_REMAP_B_C13_C14                                                                 0x0d36
#define regCM0_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define regCM0_CM_GAMUT_REMAP_B_C21_C22                                                                 0x0d37
#define regCM0_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define regCM0_CM_GAMUT_REMAP_B_C23_C24                                                                 0x0d38
#define regCM0_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define regCM0_CM_GAMUT_REMAP_B_C31_C32                                                                 0x0d39
#define regCM0_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define regCM0_CM_GAMUT_REMAP_B_C33_C34                                                                 0x0d3a
#define regCM0_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define regCM0_CM_BIAS_CR_R                                                                             0x0d3b
#define regCM0_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define regCM0_CM_BIAS_Y_G_CB_B                                                                         0x0d3c
#define regCM0_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define regCM0_CM_GAMCOR_CONTROL                                                                        0x0d3d
#define regCM0_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define regCM0_CM_GAMCOR_LUT_INDEX                                                                      0x0d3e
#define regCM0_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define regCM0_CM_GAMCOR_LUT_DATA                                                                       0x0d3f
#define regCM0_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define regCM0_CM_GAMCOR_LUT_CONTROL                                                                    0x0d40
#define regCM0_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define regCM0_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x0d41
#define regCM0_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x0d42
#define regCM0_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x0d43
#define regCM0_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x0d44
#define regCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define regCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x0d45
#define regCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define regCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x0d46
#define regCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define regCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x0d47
#define regCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define regCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x0d48
#define regCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define regCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x0d49
#define regCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define regCM0_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x0d4a
#define regCM0_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x0d4b
#define regCM0_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x0d4c
#define regCM0_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x0d4d
#define regCM0_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x0d4e
#define regCM0_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x0d4f
#define regCM0_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x0d50
#define regCM0_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define regCM0_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x0d51
#define regCM0_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define regCM0_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x0d52
#define regCM0_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define regCM0_CM_GAMCOR_RAMA_REGION_0_1                                                                0x0d53
#define regCM0_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define regCM0_CM_GAMCOR_RAMA_REGION_2_3                                                                0x0d54
#define regCM0_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define regCM0_CM_GAMCOR_RAMA_REGION_4_5                                                                0x0d55
#define regCM0_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define regCM0_CM_GAMCOR_RAMA_REGION_6_7                                                                0x0d56
#define regCM0_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define regCM0_CM_GAMCOR_RAMA_REGION_8_9                                                                0x0d57
#define regCM0_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define regCM0_CM_GAMCOR_RAMA_REGION_10_11                                                              0x0d58
#define regCM0_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_12_13                                                              0x0d59
#define regCM0_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_14_15                                                              0x0d5a
#define regCM0_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_16_17                                                              0x0d5b
#define regCM0_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_18_19                                                              0x0d5c
#define regCM0_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_20_21                                                              0x0d5d
#define regCM0_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_22_23                                                              0x0d5e
#define regCM0_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_24_25                                                              0x0d5f
#define regCM0_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_26_27                                                              0x0d60
#define regCM0_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_28_29                                                              0x0d61
#define regCM0_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_30_31                                                              0x0d62
#define regCM0_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMA_REGION_32_33                                                              0x0d63
#define regCM0_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x0d64
#define regCM0_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x0d65
#define regCM0_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x0d66
#define regCM0_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x0d67
#define regCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define regCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x0d68
#define regCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define regCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x0d69
#define regCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define regCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x0d6a
#define regCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define regCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x0d6b
#define regCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define regCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x0d6c
#define regCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define regCM0_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x0d6d
#define regCM0_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x0d6e
#define regCM0_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x0d6f
#define regCM0_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x0d70
#define regCM0_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x0d71
#define regCM0_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x0d72
#define regCM0_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define regCM0_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x0d73
#define regCM0_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define regCM0_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x0d74
#define regCM0_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define regCM0_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x0d75
#define regCM0_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define regCM0_CM_GAMCOR_RAMB_REGION_0_1                                                                0x0d76
#define regCM0_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define regCM0_CM_GAMCOR_RAMB_REGION_2_3                                                                0x0d77
#define regCM0_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define regCM0_CM_GAMCOR_RAMB_REGION_4_5                                                                0x0d78
#define regCM0_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define regCM0_CM_GAMCOR_RAMB_REGION_6_7                                                                0x0d79
#define regCM0_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define regCM0_CM_GAMCOR_RAMB_REGION_8_9                                                                0x0d7a
#define regCM0_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define regCM0_CM_GAMCOR_RAMB_REGION_10_11                                                              0x0d7b
#define regCM0_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_12_13                                                              0x0d7c
#define regCM0_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_14_15                                                              0x0d7d
#define regCM0_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_16_17                                                              0x0d7e
#define regCM0_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_18_19                                                              0x0d7f
#define regCM0_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_20_21                                                              0x0d80
#define regCM0_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_22_23                                                              0x0d81
#define regCM0_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_24_25                                                              0x0d82
#define regCM0_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_26_27                                                              0x0d83
#define regCM0_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_28_29                                                              0x0d84
#define regCM0_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_30_31                                                              0x0d85
#define regCM0_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define regCM0_CM_GAMCOR_RAMB_REGION_32_33                                                              0x0d86
#define regCM0_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define regCM0_CM_HDR_MULT_COEF                                                                         0x0d87
#define regCM0_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define regCM0_CM_MEM_PWR_CTRL                                                                          0x0d88
#define regCM0_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define regCM0_CM_MEM_PWR_STATUS                                                                        0x0d89
#define regCM0_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define regCM0_CM_DEALPHA                                                                               0x0d8b
#define regCM0_CM_DEALPHA_BASE_IDX                                                                      2
#define regCM0_CM_COEF_FORMAT                                                                           0x0d8c
#define regCM0_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define regCM0_CM_TEST_DEBUG_INDEX                                                                      0x0d8d
#define regCM0_CM_TEST_DEBUG_INDEX_BASE_IDX                                                             2
#define regCM0_CM_TEST_DEBUG_DATA                                                                       0x0d8e
#define regCM0_CM_TEST_DEBUG_DATA_BASE_IDX                                                              2


// addressBlock: dce_dc_dpp0_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x3890
#define regDC_PERFMON11_PERFCOUNTER_CNTL                                                                0x0e24
#define regDC_PERFMON11_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define regDC_PERFMON11_PERFCOUNTER_CNTL2                                                               0x0e25
#define regDC_PERFMON11_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define regDC_PERFMON11_PERFCOUNTER_STATE                                                               0x0e26
#define regDC_PERFMON11_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define regDC_PERFMON11_PERFMON_CNTL                                                                    0x0e27
#define regDC_PERFMON11_PERFMON_CNTL_BASE_IDX                                                           2
#define regDC_PERFMON11_PERFMON_CNTL2                                                                   0x0e28
#define regDC_PERFMON11_PERFMON_CNTL2_BASE_IDX                                                          2
#define regDC_PERFMON11_PERFMON_CVALUE_INT_MISC                                                         0x0e29
#define regDC_PERFMON11_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define regDC_PERFMON11_PERFMON_CVALUE_LOW                                                              0x0e2a
#define regDC_PERFMON11_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define regDC_PERFMON11_PERFMON_HI                                                                      0x0e2b
#define regDC_PERFMON11_PERFMON_HI_BASE_IDX                                                             2
#define regDC_PERFMON11_PERFMON_LOW                                                                     0x0e2c
#define regDC_PERFMON11_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dpp1_dispdec_dpp_top_dispdec
// base address: 0x5ac
#define regDPP_TOP1_DPP_CONTROL                                                                         0x0e30
#define regDPP_TOP1_DPP_CONTROL_BASE_IDX                                                                2
#define regDPP_TOP1_DPP_SOFT_RESET                                                                      0x0e31
#define regDPP_TOP1_DPP_SOFT_RESET_BASE_IDX                                                             2
#define regDPP_TOP1_DPP_CRC_VAL_R_G                                                                     0x0e32
#define regDPP_TOP1_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define regDPP_TOP1_DPP_CRC_VAL_B_A                                                                     0x0e33
#define regDPP_TOP1_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define regDPP_TOP1_DPP_CRC_CTRL                                                                        0x0e34
#define regDPP_TOP1_DPP_CRC_CTRL_BASE_IDX                                                               2
#define regDPP_TOP1_HOST_READ_CONTROL                                                                   0x0e35
#define regDPP_TOP1_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp1_dispdec_cnvc_cfg_dispdec
// base address: 0x5ac
#define regCNVC_CFG1_CNVC_SURFACE_PIXEL_FORMAT                                                          0x0e3a
#define regCNVC_CFG1_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define regCNVC_CFG1_FORMAT_CONTROL                                                                     0x0e3b
#define regCNVC_CFG1_FORMAT_CONTROL_BASE_IDX                                                            2
#define regCNVC_CFG1_FCNV_FP_BIAS_R                                                                     0x0e3c
#define regCNVC_CFG1_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define regCNVC_CFG1_FCNV_FP_BIAS_G                                                                     0x0e3d
#define regCNVC_CFG1_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define regCNVC_CFG1_FCNV_FP_BIAS_B                                                                     0x0e3e
#define regCNVC_CFG1_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define regCNVC_CFG1_FCNV_FP_SCALE_R                                                                    0x0e3f
#define regCNVC_CFG1_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define regCNVC_CFG1_FCNV_FP_SCALE_G                                                                    0x0e40
#define regCNVC_CFG1_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define regCNVC_CFG1_FCNV_FP_SCALE_B                                                                    0x0e41
#define regCNVC_CFG1_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define regCNVC_CFG1_COLOR_KEYER_CONTROL                                                                0x0e42
#define regCNVC_CFG1_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define regCNVC_CFG1_COLOR_KEYER_ALPHA                                                                  0x0e43
#define regCNVC_CFG1_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define regCNVC_CFG1_COLOR_KEYER_RED                                                                    0x0e44
#define regCNVC_CFG1_COLOR_KEYER_RED_BASE_IDX                                                           2
#define regCNVC_CFG1_COLOR_KEYER_GREEN                                                                  0x0e45
#define regCNVC_CFG1_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define regCNVC_CFG1_COLOR_KEYER_BLUE                                                                   0x0e46
#define regCNVC_CFG1_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define regCNVC_CFG1_ALPHA_2BIT_LUT                                                                     0x0e48
#define regCNVC_CFG1_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define regCNVC_CFG1_PRE_DEALPHA                                                                        0x0e49
#define regCNVC_CFG1_PRE_DEALPHA_BASE_IDX                                                               2
#define regCNVC_CFG1_PRE_CSC_MODE                                                                       0x0e4a
#define regCNVC_CFG1_PRE_CSC_MODE_BASE_IDX                                                              2
#define regCNVC_CFG1_PRE_CSC_C11_C12                                                                    0x0e4b
#define regCNVC_CFG1_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define regCNVC_CFG1_PRE_CSC_C13_C14                                                                    0x0e4c
#define regCNVC_CFG1_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define regCNVC_CFG1_PRE_CSC_C21_C22                                                                    0x0e4d
#define regCNVC_CFG1_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define regCNVC_CFG1_PRE_CSC_C23_C24                                                                    0x0e4e
#define regCNVC_CFG1_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define regCNVC_CFG1_PRE_CSC_C31_C32                                                                    0x0e4f
#define regCNVC_CFG1_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define regCNVC_CFG1_PRE_CSC_C33_C34                                                                    0x0e50
#define regCNVC_CFG1_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define regCNVC_CFG1_PRE_CSC_B_C11_C12                                                                  0x0e51
#define regCNVC_CFG1_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define regCNVC_CFG1_PRE_CSC_B_C13_C14                                                                  0x0e52
#define regCNVC_CFG1_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define regCNVC_CFG1_PRE_CSC_B_C21_C22                                                                  0x0e53
#define regCNVC_CFG1_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define regCNVC_CFG1_PRE_CSC_B_C23_C24                                                                  0x0e54
#define regCNVC_CFG1_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define regCNVC_CFG1_PRE_CSC_B_C31_C32                                                                  0x0e55
#define regCNVC_CFG1_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define regCNVC_CFG1_PRE_CSC_B_C33_C34                                                                  0x0e56
#define regCNVC_CFG1_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define regCNVC_CFG1_CNVC_COEF_FORMAT                                                                   0x0e57
#define regCNVC_CFG1_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define regCNVC_CFG1_PRE_DEGAM                                                                          0x0e58
#define regCNVC_CFG1_PRE_DEGAM_BASE_IDX                                                                 2
#define regCNVC_CFG1_PRE_REALPHA                                                                        0x0e59
#define regCNVC_CFG1_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp1_dispdec_cnvc_cur_dispdec
// base address: 0x5ac
#define regCNVC_CUR1_CURSOR0_CONTROL                                                                    0x0e5c
#define regCNVC_CUR1_CURSOR0_CONTROL_BASE_IDX                                                           2
#define regCNVC_CUR1_CURSOR0_COLOR0                                                                     0x0e5d
#define regCNVC_CUR1_CURSOR0_COLOR0_BASE_IDX                                                            2
#define regCNVC_CUR1_CURSOR0_COLOR1                                                                     0x0e5e
#define regCNVC_CUR1_CURSOR0_COLOR1_BASE_IDX                                                            2
#define regCNVC_CUR1_CURSOR0_FP_SCALE_BIAS                                                              0x0e5f
#define regCNVC_CUR1_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2


// addressBlock: dce_dc_dpp1_dispdec_dscl_dispdec
// base address: 0x5ac
#define regDSCL1_SCL_COEF_RAM_TAP_SELECT                                                                0x0e64
#define regDSCL1_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define regDSCL1_SCL_COEF_RAM_TAP_DATA                                                                  0x0e65
#define regDSCL1_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define regDSCL1_SCL_MODE                                                                               0x0e66
#define regDSCL1_SCL_MODE_BASE_IDX                                                                      2
#define regDSCL1_SCL_TAP_CONTROL                                                                        0x0e67
#define regDSCL1_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define regDSCL1_DSCL_CONTROL                                                                           0x0e68
#define regDSCL1_DSCL_CONTROL_BASE_IDX                                                                  2
#define regDSCL1_DSCL_2TAP_CONTROL                                                                      0x0e69
#define regDSCL1_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define regDSCL1_SCL_MANUAL_REPLICATE_CONTROL                                                           0x0e6a
#define regDSCL1_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define regDSCL1_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x0e6b
#define regDSCL1_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define regDSCL1_SCL_HORZ_FILTER_INIT                                                                   0x0e6c
#define regDSCL1_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define regDSCL1_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x0e6d
#define regDSCL1_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define regDSCL1_SCL_HORZ_FILTER_INIT_C                                                                 0x0e6e
#define regDSCL1_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define regDSCL1_SCL_VERT_FILTER_SCALE_RATIO                                                            0x0e6f
#define regDSCL1_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define regDSCL1_SCL_VERT_FILTER_INIT                                                                   0x0e70
#define regDSCL1_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define regDSCL1_SCL_VERT_FILTER_INIT_BOT                                                               0x0e71
#define regDSCL1_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define regDSCL1_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x0e72
#define regDSCL1_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define regDSCL1_SCL_VERT_FILTER_INIT_C                                                                 0x0e73
#define regDSCL1_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define regDSCL1_SCL_VERT_FILTER_INIT_BOT_C                                                             0x0e74
#define regDSCL1_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define regDSCL1_SCL_BLACK_COLOR                                                                        0x0e75
#define regDSCL1_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define regDSCL1_DSCL_UPDATE                                                                            0x0e76
#define regDSCL1_DSCL_UPDATE_BASE_IDX                                                                   2
#define regDSCL1_DSCL_AUTOCAL                                                                           0x0e77
#define regDSCL1_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define regDSCL1_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x0e78
#define regDSCL1_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define regDSCL1_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x0e79
#define regDSCL1_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define regDSCL1_OTG_H_BLANK                                                                            0x0e7a
#define regDSCL1_OTG_H_BLANK_BASE_IDX                                                                   2
#define regDSCL1_OTG_V_BLANK                                                                            0x0e7b
#define regDSCL1_OTG_V_BLANK_BASE_IDX                                                                   2
#define regDSCL1_RECOUT_START                                                                           0x0e7c
#define regDSCL1_RECOUT_START_BASE_IDX                                                                  2
#define regDSCL1_RECOUT_SIZE                                                                            0x0e7d
#define regDSCL1_RECOUT_SIZE_BASE_IDX                                                                   2
#define regDSCL1_MPC_SIZE                                                                               0x0e7e
#define regDSCL1_MPC_SIZE_BASE_IDX                                                                      2
#define regDSCL1_LB_DATA_FORMAT                                                                         0x0e7f
#define regDSCL1_LB_DATA_FORMAT_BASE_IDX                                                                2
#define regDSCL1_LB_MEMORY_CTRL                                                                         0x0e80
#define regDSCL1_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define regDSCL1_LB_V_COUNTER                                                                           0x0e81
#define regDSCL1_LB_V_COUNTER_BASE_IDX                                                                  2
#define regDSCL1_DSCL_MEM_PWR_CTRL                                                                      0x0e82
#define regDSCL1_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define regDSCL1_DSCL_MEM_PWR_STATUS                                                                    0x0e83
#define regDSCL1_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define regDSCL1_OBUF_CONTROL                                                                           0x0e84
#define regDSCL1_OBUF_CONTROL_BASE_IDX                                                                  2
#define regDSCL1_OBUF_MEM_PWR_CTRL                                                                      0x0e85
#define regDSCL1_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp1_dispdec_cm_dispdec
// base address: 0x5ac
#define regCM1_CM_CONTROL                                                                               0x0e8b
#define regCM1_CM_CONTROL_BASE_IDX                                                                      2
#define regCM1_CM_POST_CSC_CONTROL                                                                      0x0e8c
#define regCM1_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define regCM1_CM_POST_CSC_C11_C12                                                                      0x0e8d
#define regCM1_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define regCM1_CM_POST_CSC_C13_C14                                                                      0x0e8e
#define regCM1_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define regCM1_CM_POST_CSC_C21_C22                                                                      0x0e8f
#define regCM1_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define regCM1_CM_POST_CSC_C23_C24                                                                      0x0e90
#define regCM1_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define regCM1_CM_POST_CSC_C31_C32                                                                      0x0e91
#define regCM1_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define regCM1_CM_POST_CSC_C33_C34                                                                      0x0e92
#define regCM1_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define regCM1_CM_POST_CSC_B_C11_C12                                                                    0x0e93
#define regCM1_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define regCM1_CM_POST_CSC_B_C13_C14                                                                    0x0e94
#define regCM1_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define regCM1_CM_POST_CSC_B_C21_C22                                                                    0x0e95
#define regCM1_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define regCM1_CM_POST_CSC_B_C23_C24                                                                    0x0e96
#define regCM1_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define regCM1_CM_POST_CSC_B_C31_C32                                                                    0x0e97
#define regCM1_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define regCM1_CM_POST_CSC_B_C33_C34                                                                    0x0e98
#define regCM1_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define regCM1_CM_GAMUT_REMAP_CONTROL                                                                   0x0e99
#define regCM1_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define regCM1_CM_GAMUT_REMAP_C11_C12                                                                   0x0e9a
#define regCM1_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define regCM1_CM_GAMUT_REMAP_C13_C14                                                                   0x0e9b
#define regCM1_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define regCM1_CM_GAMUT_REMAP_C21_C22                                                                   0x0e9c
#define regCM1_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define regCM1_CM_GAMUT_REMAP_C23_C24                                                                   0x0e9d
#define regCM1_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define regCM1_CM_GAMUT_REMAP_C31_C32                                                                   0x0e9e
#define regCM1_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define regCM1_CM_GAMUT_REMAP_C33_C34                                                                   0x0e9f
#define regCM1_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define regCM1_CM_GAMUT_REMAP_B_C11_C12                                                                 0x0ea0
#define regCM1_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define regCM1_CM_GAMUT_REMAP_B_C13_C14                                                                 0x0ea1
#define regCM1_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define regCM1_CM_GAMUT_REMAP_B_C21_C22                                                                 0x0ea2
#define regCM1_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define regCM1_CM_GAMUT_REMAP_B_C23_C24                                                                 0x0ea3
#define regCM1_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define regCM1_CM_GAMUT_REMAP_B_C31_C32                                                                 0x0ea4
#define regCM1_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define regCM1_CM_GAMUT_REMAP_B_C33_C34                                                                 0x0ea5
#define regCM1_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define regCM1_CM_BIAS_CR_R                                                                             0x0ea6
#define regCM1_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define regCM1_CM_BIAS_Y_G_CB_B                                                                         0x0ea7
#define regCM1_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define regCM1_CM_GAMCOR_CONTROL                                                                        0x0ea8
#define regCM1_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define regCM1_CM_GAMCOR_LUT_INDEX                                                                      0x0ea9
#define regCM1_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define regCM1_CM_GAMCOR_LUT_DATA                                                                       0x0eaa
#define regCM1_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define regCM1_CM_GAMCOR_LUT_CONTROL                                                                    0x0eab
#define regCM1_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define regCM1_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x0eac
#define regCM1_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x0ead
#define regCM1_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x0eae
#define regCM1_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x0eaf
#define regCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define regCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x0eb0
#define regCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define regCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x0eb1
#define regCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define regCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x0eb2
#define regCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define regCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x0eb3
#define regCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define regCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x0eb4
#define regCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define regCM1_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x0eb5
#define regCM1_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x0eb6
#define regCM1_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x0eb7
#define regCM1_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x0eb8
#define regCM1_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x0eb9
#define regCM1_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x0eba
#define regCM1_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x0ebb
#define regCM1_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define regCM1_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x0ebc
#define regCM1_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define regCM1_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x0ebd
#define regCM1_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define regCM1_CM_GAMCOR_RAMA_REGION_0_1                                                                0x0ebe
#define regCM1_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define regCM1_CM_GAMCOR_RAMA_REGION_2_3                                                                0x0ebf
#define regCM1_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define regCM1_CM_GAMCOR_RAMA_REGION_4_5                                                                0x0ec0
#define regCM1_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define regCM1_CM_GAMCOR_RAMA_REGION_6_7                                                                0x0ec1
#define regCM1_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define regCM1_CM_GAMCOR_RAMA_REGION_8_9                                                                0x0ec2
#define regCM1_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define regCM1_CM_GAMCOR_RAMA_REGION_10_11                                                              0x0ec3
#define regCM1_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_12_13                                                              0x0ec4
#define regCM1_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_14_15                                                              0x0ec5
#define regCM1_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_16_17                                                              0x0ec6
#define regCM1_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_18_19                                                              0x0ec7
#define regCM1_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_20_21                                                              0x0ec8
#define regCM1_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_22_23                                                              0x0ec9
#define regCM1_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_24_25                                                              0x0eca
#define regCM1_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_26_27                                                              0x0ecb
#define regCM1_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_28_29                                                              0x0ecc
#define regCM1_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_30_31                                                              0x0ecd
#define regCM1_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMA_REGION_32_33                                                              0x0ece
#define regCM1_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x0ecf
#define regCM1_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x0ed0
#define regCM1_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x0ed1
#define regCM1_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x0ed2
#define regCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define regCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x0ed3
#define regCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define regCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x0ed4
#define regCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define regCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x0ed5
#define regCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define regCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x0ed6
#define regCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define regCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x0ed7
#define regCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define regCM1_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x0ed8
#define regCM1_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x0ed9
#define regCM1_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x0eda
#define regCM1_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x0edb
#define regCM1_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x0edc
#define regCM1_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x0edd
#define regCM1_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define regCM1_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x0ede
#define regCM1_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define regCM1_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x0edf
#define regCM1_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define regCM1_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x0ee0
#define regCM1_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define regCM1_CM_GAMCOR_RAMB_REGION_0_1                                                                0x0ee1
#define regCM1_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define regCM1_CM_GAMCOR_RAMB_REGION_2_3                                                                0x0ee2
#define regCM1_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define regCM1_CM_GAMCOR_RAMB_REGION_4_5                                                                0x0ee3
#define regCM1_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define regCM1_CM_GAMCOR_RAMB_REGION_6_7                                                                0x0ee4
#define regCM1_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define regCM1_CM_GAMCOR_RAMB_REGION_8_9                                                                0x0ee5
#define regCM1_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define regCM1_CM_GAMCOR_RAMB_REGION_10_11                                                              0x0ee6
#define regCM1_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_12_13                                                              0x0ee7
#define regCM1_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_14_15                                                              0x0ee8
#define regCM1_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_16_17                                                              0x0ee9
#define regCM1_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_18_19                                                              0x0eea
#define regCM1_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_20_21                                                              0x0eeb
#define regCM1_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_22_23                                                              0x0eec
#define regCM1_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_24_25                                                              0x0eed
#define regCM1_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_26_27                                                              0x0eee
#define regCM1_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_28_29                                                              0x0eef
#define regCM1_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_30_31                                                              0x0ef0
#define regCM1_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define regCM1_CM_GAMCOR_RAMB_REGION_32_33                                                              0x0ef1
#define regCM1_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define regCM1_CM_HDR_MULT_COEF                                                                         0x0ef2
#define regCM1_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define regCM1_CM_MEM_PWR_CTRL                                                                          0x0ef3
#define regCM1_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define regCM1_CM_MEM_PWR_STATUS                                                                        0x0ef4
#define regCM1_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define regCM1_CM_DEALPHA                                                                               0x0ef6
#define regCM1_CM_DEALPHA_BASE_IDX                                                                      2
#define regCM1_CM_COEF_FORMAT                                                                           0x0ef7
#define regCM1_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define regCM1_CM_TEST_DEBUG_INDEX                                                                      0x0ef8
#define regCM1_CM_TEST_DEBUG_INDEX_BASE_IDX                                                             2
#define regCM1_CM_TEST_DEBUG_DATA                                                                       0x0ef9
#define regCM1_CM_TEST_DEBUG_DATA_BASE_IDX                                                              2


// addressBlock: dce_dc_dpp1_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x3e3c
#define regDC_PERFMON12_PERFCOUNTER_CNTL                                                                0x0f8f
#define regDC_PERFMON12_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define regDC_PERFMON12_PERFCOUNTER_CNTL2                                                               0x0f90
#define regDC_PERFMON12_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define regDC_PERFMON12_PERFCOUNTER_STATE                                                               0x0f91
#define regDC_PERFMON12_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define regDC_PERFMON12_PERFMON_CNTL                                                                    0x0f92
#define regDC_PERFMON12_PERFMON_CNTL_BASE_IDX                                                           2
#define regDC_PERFMON12_PERFMON_CNTL2                                                                   0x0f93
#define regDC_PERFMON12_PERFMON_CNTL2_BASE_IDX                                                          2
#define regDC_PERFMON12_PERFMON_CVALUE_INT_MISC                                                         0x0f94
#define regDC_PERFMON12_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define regDC_PERFMON12_PERFMON_CVALUE_LOW                                                              0x0f95
#define regDC_PERFMON12_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define regDC_PERFMON12_PERFMON_HI                                                                      0x0f96
#define regDC_PERFMON12_PERFMON_HI_BASE_IDX                                                             2
#define regDC_PERFMON12_PERFMON_LOW                                                                     0x0f97
#define regDC_PERFMON12_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dpp2_dispdec_dpp_top_dispdec
// base address: 0xb58
#define regDPP_TOP2_DPP_CONTROL                                                                         0x0f9b
#define regDPP_TOP2_DPP_CONTROL_BASE_IDX                                                                2
#define regDPP_TOP2_DPP_SOFT_RESET                                                                      0x0f9c
#define regDPP_TOP2_DPP_SOFT_RESET_BASE_IDX                                                             2
#define regDPP_TOP2_DPP_CRC_VAL_R_G                                                                     0x0f9d
#define regDPP_TOP2_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define regDPP_TOP2_DPP_CRC_VAL_B_A                                                                     0x0f9e
#define regDPP_TOP2_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define regDPP_TOP2_DPP_CRC_CTRL                                                                        0x0f9f
#define regDPP_TOP2_DPP_CRC_CTRL_BASE_IDX                                                               2
#define regDPP_TOP2_HOST_READ_CONTROL                                                                   0x0fa0
#define regDPP_TOP2_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp2_dispdec_cnvc_cfg_dispdec
// base address: 0xb58
#define regCNVC_CFG2_CNVC_SURFACE_PIXEL_FORMAT                                                          0x0fa5
#define regCNVC_CFG2_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define regCNVC_CFG2_FORMAT_CONTROL                                                                     0x0fa6
#define regCNVC_CFG2_FORMAT_CONTROL_BASE_IDX                                                            2
#define regCNVC_CFG2_FCNV_FP_BIAS_R                                                                     0x0fa7
#define regCNVC_CFG2_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define regCNVC_CFG2_FCNV_FP_BIAS_G                                                                     0x0fa8
#define regCNVC_CFG2_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define regCNVC_CFG2_FCNV_FP_BIAS_B                                                                     0x0fa9
#define regCNVC_CFG2_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define regCNVC_CFG2_FCNV_FP_SCALE_R                                                                    0x0faa
#define regCNVC_CFG2_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define regCNVC_CFG2_FCNV_FP_SCALE_G                                                                    0x0fab
#define regCNVC_CFG2_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define regCNVC_CFG2_FCNV_FP_SCALE_B                                                                    0x0fac
#define regCNVC_CFG2_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define regCNVC_CFG2_COLOR_KEYER_CONTROL                                                                0x0fad
#define regCNVC_CFG2_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define regCNVC_CFG2_COLOR_KEYER_ALPHA                                                                  0x0fae
#define regCNVC_CFG2_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define regCNVC_CFG2_COLOR_KEYER_RED                                                                    0x0faf
#define regCNVC_CFG2_COLOR_KEYER_RED_BASE_IDX                                                           2
#define regCNVC_CFG2_COLOR_KEYER_GREEN                                                                  0x0fb0
#define regCNVC_CFG2_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define regCNVC_CFG2_COLOR_KEYER_BLUE                                                                   0x0fb1
#define regCNVC_CFG2_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define regCNVC_CFG2_ALPHA_2BIT_LUT                                                                     0x0fb3
#define regCNVC_CFG2_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define regCNVC_CFG2_PRE_DEALPHA                                                                        0x0fb4
#define regCNVC_CFG2_PRE_DEALPHA_BASE_IDX                                                               2
#define regCNVC_CFG2_PRE_CSC_MODE                                                                       0x0fb5
#define regCNVC_CFG2_PRE_CSC_MODE_BASE_IDX                                                              2
#define regCNVC_CFG2_PRE_CSC_C11_C12                                                                    0x0fb6
#define regCNVC_CFG2_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define regCNVC_CFG2_PRE_CSC_C13_C14                                                                    0x0fb7
#define regCNVC_CFG2_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define regCNVC_CFG2_PRE_CSC_C21_C22                                                                    0x0fb8
#define regCNVC_CFG2_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define regCNVC_CFG2_PRE_CSC_C23_C24                                                                    0x0fb9
#define regCNVC_CFG2_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define regCNVC_CFG2_PRE_CSC_C31_C32                                                                    0x0fba
#define regCNVC_CFG2_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define regCNVC_CFG2_PRE_CSC_C33_C34                                                                    0x0fbb
#define regCNVC_CFG2_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define regCNVC_CFG2_PRE_CSC_B_C11_C12                                                                  0x0fbc
#define regCNVC_CFG2_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define regCNVC_CFG2_PRE_CSC_B_C13_C14                                                                  0x0fbd
#define regCNVC_CFG2_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define regCNVC_CFG2_PRE_CSC_B_C21_C22                                                                  0x0fbe
#define regCNVC_CFG2_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define regCNVC_CFG2_PRE_CSC_B_C23_C24                                                                  0x0fbf
#define regCNVC_CFG2_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define regCNVC_CFG2_PRE_CSC_B_C31_C32                                                                  0x0fc0
#define regCNVC_CFG2_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define regCNVC_CFG2_PRE_CSC_B_C33_C34                                                                  0x0fc1
#define regCNVC_CFG2_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define regCNVC_CFG2_CNVC_COEF_FORMAT                                                                   0x0fc2
#define regCNVC_CFG2_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define regCNVC_CFG2_PRE_DEGAM                                                                          0x0fc3
#define regCNVC_CFG2_PRE_DEGAM_BASE_IDX                                                                 2
#define regCNVC_CFG2_PRE_REALPHA                                                                        0x0fc4
#define regCNVC_CFG2_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp2_dispdec_cnvc_cur_dispdec
// base address: 0xb58
#define regCNVC_CUR2_CURSOR0_CONTROL                                                                    0x0fc7
#define regCNVC_CUR2_CURSOR0_CONTROL_BASE_IDX                                                           2
#define regCNVC_CUR2_CURSOR0_COLOR0                                                                     0x0fc8
#define regCNVC_CUR2_CURSOR0_COLOR0_BASE_IDX                                                            2
#define regCNVC_CUR2_CURSOR0_COLOR1                                                                     0x0fc9
#define regCNVC_CUR2_CURSOR0_COLOR1_BASE_IDX                                                            2
#define regCNVC_CUR2_CURSOR0_FP_SCALE_BIAS                                                              0x0fca
#define regCNVC_CUR2_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2


// addressBlock: dce_dc_dpp2_dispdec_dscl_dispdec
// base address: 0xb58
#define regDSCL2_SCL_COEF_RAM_TAP_SELECT                                                                0x0fcf
#define regDSCL2_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define regDSCL2_SCL_COEF_RAM_TAP_DATA                                                                  0x0fd0
#define regDSCL2_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define regDSCL2_SCL_MODE                                                                               0x0fd1
#define regDSCL2_SCL_MODE_BASE_IDX                                                                      2
#define regDSCL2_SCL_TAP_CONTROL                                                                        0x0fd2
#define regDSCL2_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define regDSCL2_DSCL_CONTROL                                                                           0x0fd3
#define regDSCL2_DSCL_CONTROL_BASE_IDX                                                                  2
#define regDSCL2_DSCL_2TAP_CONTROL                                                                      0x0fd4
#define regDSCL2_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define regDSCL2_SCL_MANUAL_REPLICATE_CONTROL                                                           0x0fd5
#define regDSCL2_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define regDSCL2_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x0fd6
#define regDSCL2_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define regDSCL2_SCL_HORZ_FILTER_INIT                                                                   0x0fd7
#define regDSCL2_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define regDSCL2_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x0fd8
#define regDSCL2_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define regDSCL2_SCL_HORZ_FILTER_INIT_C                                                                 0x0fd9
#define regDSCL2_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define regDSCL2_SCL_VERT_FILTER_SCALE_RATIO                                                            0x0fda
#define regDSCL2_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define regDSCL2_SCL_VERT_FILTER_INIT                                                                   0x0fdb
#define regDSCL2_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define regDSCL2_SCL_VERT_FILTER_INIT_BOT                                                               0x0fdc
#define regDSCL2_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define regDSCL2_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x0fdd
#define regDSCL2_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define regDSCL2_SCL_VERT_FILTER_INIT_C                                                                 0x0fde
#define regDSCL2_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define regDSCL2_SCL_VERT_FILTER_INIT_BOT_C                                                             0x0fdf
#define regDSCL2_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define regDSCL2_SCL_BLACK_COLOR                                                                        0x0fe0
#define regDSCL2_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define regDSCL2_DSCL_UPDATE                                                                            0x0fe1
#define regDSCL2_DSCL_UPDATE_BASE_IDX                                                                   2
#define regDSCL2_DSCL_AUTOCAL                                                                           0x0fe2
#define regDSCL2_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define regDSCL2_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x0fe3
#define regDSCL2_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define regDSCL2_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x0fe4
#define regDSCL2_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define regDSCL2_OTG_H_BLANK                                                                            0x0fe5
#define regDSCL2_OTG_H_BLANK_BASE_IDX                                                                   2
#define regDSCL2_OTG_V_BLANK                                                                            0x0fe6
#define regDSCL2_OTG_V_BLANK_BASE_IDX                                                                   2
#define regDSCL2_RECOUT_START                                                                           0x0fe7
#define regDSCL2_RECOUT_START_BASE_IDX                                                                  2
#define regDSCL2_RECOUT_SIZE                                                                            0x0fe8
#define regDSCL2_RECOUT_SIZE_BASE_IDX                                                                   2
#define regDSCL2_MPC_SIZE                                                                               0x0fe9
#define regDSCL2_MPC_SIZE_BASE_IDX                                                                      2
#define regDSCL2_LB_DATA_FORMAT                                                                         0x0fea
#define regDSCL2_LB_DATA_FORMAT_BASE_IDX                                                                2
#define regDSCL2_LB_MEMORY_CTRL                                                                         0x0feb
#define regDSCL2_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define regDSCL2_LB_V_COUNTER                                                                           0x0fec
#define regDSCL2_LB_V_COUNTER_BASE_IDX                                                                  2
#define regDSCL2_DSCL_MEM_PWR_CTRL                                                                      0x0fed
#define regDSCL2_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define regDSCL2_DSCL_MEM_PWR_STATUS                                                                    0x0fee
#define regDSCL2_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define regDSCL2_OBUF_CONTROL                                                                           0x0fef
#define regDSCL2_OBUF_CONTROL_BASE_IDX                                                                  2
#define regDSCL2_OBUF_MEM_PWR_CTRL                                                                      0x0ff0
#define regDSCL2_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp2_dispdec_cm_dispdec
// base address: 0xb58
#define regCM2_CM_CONTROL                                                                               0x0ff6
#define regCM2_CM_CONTROL_BASE_IDX                                                                      2
#define regCM2_CM_POST_CSC_CONTROL                                                                      0x0ff7
#define regCM2_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define regCM2_CM_POST_CSC_C11_C12                                                                      0x0ff8
#define regCM2_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define regCM2_CM_POST_CSC_C13_C14                                                                      0x0ff9
#define regCM2_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define regCM2_CM_POST_CSC_C21_C22                                                                      0x0ffa
#define regCM2_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define regCM2_CM_POST_CSC_C23_C24                                                                      0x0ffb
#define regCM2_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define regCM2_CM_POST_CSC_C31_C32                                                                      0x0ffc
#define regCM2_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define regCM2_CM_POST_CSC_C33_C34                                                                      0x0ffd
#define regCM2_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define regCM2_CM_POST_CSC_B_C11_C12                                                                    0x0ffe
#define regCM2_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define regCM2_CM_POST_CSC_B_C13_C14                                                                    0x0fff
#define regCM2_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define regCM2_CM_POST_CSC_B_C21_C22                                                                    0x1000
#define regCM2_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define regCM2_CM_POST_CSC_B_C23_C24                                                                    0x1001
#define regCM2_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define regCM2_CM_POST_CSC_B_C31_C32                                                                    0x1002
#define regCM2_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define regCM2_CM_POST_CSC_B_C33_C34                                                                    0x1003
#define regCM2_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define regCM2_CM_GAMUT_REMAP_CONTROL                                                                   0x1004
#define regCM2_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define regCM2_CM_GAMUT_REMAP_C11_C12                                                                   0x1005
#define regCM2_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define regCM2_CM_GAMUT_REMAP_C13_C14                                                                   0x1006
#define regCM2_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define regCM2_CM_GAMUT_REMAP_C21_C22                                                                   0x1007
#define regCM2_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define regCM2_CM_GAMUT_REMAP_C23_C24                                                                   0x1008
#define regCM2_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define regCM2_CM_GAMUT_REMAP_C31_C32                                                                   0x1009
#define regCM2_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define regCM2_CM_GAMUT_REMAP_C33_C34                                                                   0x100a
#define regCM2_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define regCM2_CM_GAMUT_REMAP_B_C11_C12                                                                 0x100b
#define regCM2_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define regCM2_CM_GAMUT_REMAP_B_C13_C14                                                                 0x100c
#define regCM2_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define regCM2_CM_GAMUT_REMAP_B_C21_C22                                                                 0x100d
#define regCM2_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define regCM2_CM_GAMUT_REMAP_B_C23_C24                                                                 0x100e
#define regCM2_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define regCM2_CM_GAMUT_REMAP_B_C31_C32                                                                 0x100f
#define regCM2_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define regCM2_CM_GAMUT_REMAP_B_C33_C34                                                                 0x1010
#define regCM2_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define regCM2_CM_BIAS_CR_R                                                                             0x1011
#define regCM2_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define regCM2_CM_BIAS_Y_G_CB_B                                                                         0x1012
#define regCM2_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define regCM2_CM_GAMCOR_CONTROL                                                                        0x1013
#define regCM2_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define regCM2_CM_GAMCOR_LUT_INDEX                                                                      0x1014
#define regCM2_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define regCM2_CM_GAMCOR_LUT_DATA                                                                       0x1015
#define regCM2_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define regCM2_CM_GAMCOR_LUT_CONTROL                                                                    0x1016
#define regCM2_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define regCM2_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x1017
#define regCM2_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x1018
#define regCM2_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x1019
#define regCM2_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x101a
#define regCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define regCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x101b
#define regCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define regCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x101c
#define regCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define regCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x101d
#define regCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define regCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x101e
#define regCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define regCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x101f
#define regCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define regCM2_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x1020
#define regCM2_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x1021
#define regCM2_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x1022
#define regCM2_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x1023
#define regCM2_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x1024
#define regCM2_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x1025
#define regCM2_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x1026
#define regCM2_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define regCM2_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x1027
#define regCM2_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define regCM2_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x1028
#define regCM2_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define regCM2_CM_GAMCOR_RAMA_REGION_0_1                                                                0x1029
#define regCM2_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define regCM2_CM_GAMCOR_RAMA_REGION_2_3                                                                0x102a
#define regCM2_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define regCM2_CM_GAMCOR_RAMA_REGION_4_5                                                                0x102b
#define regCM2_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define regCM2_CM_GAMCOR_RAMA_REGION_6_7                                                                0x102c
#define regCM2_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define regCM2_CM_GAMCOR_RAMA_REGION_8_9                                                                0x102d
#define regCM2_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define regCM2_CM_GAMCOR_RAMA_REGION_10_11                                                              0x102e
#define regCM2_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_12_13                                                              0x102f
#define regCM2_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_14_15                                                              0x1030
#define regCM2_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_16_17                                                              0x1031
#define regCM2_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_18_19                                                              0x1032
#define regCM2_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_20_21                                                              0x1033
#define regCM2_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_22_23                                                              0x1034
#define regCM2_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_24_25                                                              0x1035
#define regCM2_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_26_27                                                              0x1036
#define regCM2_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_28_29                                                              0x1037
#define regCM2_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_30_31                                                              0x1038
#define regCM2_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMA_REGION_32_33                                                              0x1039
#define regCM2_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x103a
#define regCM2_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x103b
#define regCM2_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x103c
#define regCM2_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x103d
#define regCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define regCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x103e
#define regCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define regCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x103f
#define regCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define regCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x1040
#define regCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define regCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x1041
#define regCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define regCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x1042
#define regCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define regCM2_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x1043
#define regCM2_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x1044
#define regCM2_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x1045
#define regCM2_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x1046
#define regCM2_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x1047
#define regCM2_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x1048
#define regCM2_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define regCM2_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x1049
#define regCM2_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define regCM2_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x104a
#define regCM2_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define regCM2_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x104b
#define regCM2_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define regCM2_CM_GAMCOR_RAMB_REGION_0_1                                                                0x104c
#define regCM2_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define regCM2_CM_GAMCOR_RAMB_REGION_2_3                                                                0x104d
#define regCM2_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define regCM2_CM_GAMCOR_RAMB_REGION_4_5                                                                0x104e
#define regCM2_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define regCM2_CM_GAMCOR_RAMB_REGION_6_7                                                                0x104f
#define regCM2_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define regCM2_CM_GAMCOR_RAMB_REGION_8_9                                                                0x1050
#define regCM2_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define regCM2_CM_GAMCOR_RAMB_REGION_10_11                                                              0x1051
#define regCM2_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_12_13                                                              0x1052
#define regCM2_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_14_15                                                              0x1053
#define regCM2_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_16_17                                                              0x1054
#define regCM2_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_18_19                                                              0x1055
#define regCM2_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_20_21                                                              0x1056
#define regCM2_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_22_23                                                              0x1057
#define regCM2_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_24_25                                                              0x1058
#define regCM2_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_26_27                                                              0x1059
#define regCM2_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_28_29                                                              0x105a
#define regCM2_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_30_31                                                              0x105b
#define regCM2_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define regCM2_CM_GAMCOR_RAMB_REGION_32_33                                                              0x105c
#define regCM2_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define regCM2_CM_HDR_MULT_COEF                                                                         0x105d
#define regCM2_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define regCM2_CM_MEM_PWR_CTRL                                                                          0x105e
#define regCM2_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define regCM2_CM_MEM_PWR_STATUS                                                                        0x105f
#define regCM2_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define regCM2_CM_DEALPHA                                                                               0x1061
#define regCM2_CM_DEALPHA_BASE_IDX                                                                      2
#define regCM2_CM_COEF_FORMAT                                                                           0x1062
#define regCM2_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define regCM2_CM_TEST_DEBUG_INDEX                                                                      0x1063
#define regCM2_CM_TEST_DEBUG_INDEX_BASE_IDX                                                             2
#define regCM2_CM_TEST_DEBUG_DATA                                                                       0x1064
#define regCM2_CM_TEST_DEBUG_DATA_BASE_IDX                                                              2


// addressBlock: dce_dc_dpp2_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x43e8
#define regDC_PERFMON13_PERFCOUNTER_CNTL                                                                0x10fa
#define regDC_PERFMON13_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define regDC_PERFMON13_PERFCOUNTER_CNTL2                                                               0x10fb
#define regDC_PERFMON13_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define regDC_PERFMON13_PERFCOUNTER_STATE                                                               0x10fc
#define regDC_PERFMON13_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define regDC_PERFMON13_PERFMON_CNTL                                                                    0x10fd
#define regDC_PERFMON13_PERFMON_CNTL_BASE_IDX                                                           2
#define regDC_PERFMON13_PERFMON_CNTL2                                                                   0x10fe
#define regDC_PERFMON13_PERFMON_CNTL2_BASE_IDX                                                          2
#define regDC_PERFMON13_PERFMON_CVALUE_INT_MISC                                                         0x10ff
#define regDC_PERFMON13_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define regDC_PERFMON13_PERFMON_CVALUE_LOW                                                              0x1100
#define regDC_PERFMON13_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define regDC_PERFMON13_PERFMON_HI                                                                      0x1101
#define regDC_PERFMON13_PERFMON_HI_BASE_IDX                                                             2
#define regDC_PERFMON13_PERFMON_LOW                                                                     0x1102
#define regDC_PERFMON13_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dpp3_dispdec_dpp_top_dispdec
// base address: 0x1104
#define regDPP_TOP3_DPP_CONTROL                                                                         0x1106
#define regDPP_TOP3_DPP_CONTROL_BASE_IDX                                                                2
#define regDPP_TOP3_DPP_SOFT_RESET                                                                      0x1107
#define regDPP_TOP3_DPP_SOFT_RESET_BASE_IDX                                                             2
#define regDPP_TOP3_DPP_CRC_VAL_R_G                                                                     0x1108
#define regDPP_TOP3_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define regDPP_TOP3_DPP_CRC_VAL_B_A                                                                     0x1109
#define regDPP_TOP3_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define regDPP_TOP3_DPP_CRC_CTRL                                                                        0x110a
#define regDPP_TOP3_DPP_CRC_CTRL_BASE_IDX                                                               2
#define regDPP_TOP3_HOST_READ_CONTROL                                                                   0x110b
#define regDPP_TOP3_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp3_dispdec_cnvc_cfg_dispdec
// base address: 0x1104
#define regCNVC_CFG3_CNVC_SURFACE_PIXEL_FORMAT                                                          0x1110
#define regCNVC_CFG3_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define regCNVC_CFG3_FORMAT_CONTROL                                                                     0x1111
#define regCNVC_CFG3_FORMAT_CONTROL_BASE_IDX                                                            2
#define regCNVC_CFG3_FCNV_FP_BIAS_R                                                                     0x1112
#define regCNVC_CFG3_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define regCNVC_CFG3_FCNV_FP_BIAS_G                                                                     0x1113
#define regCNVC_CFG3_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define regCNVC_CFG3_FCNV_FP_BIAS_B                                                                     0x1114
#define regCNVC_CFG3_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define regCNVC_CFG3_FCNV_FP_SCALE_R                                                                    0x1115
#define regCNVC_CFG3_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define regCNVC_CFG3_FCNV_FP_SCALE_G                                                                    0x1116
#define regCNVC_CFG3_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define regCNVC_CFG3_FCNV_FP_SCALE_B                                                                    0x1117
#define regCNVC_CFG3_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define regCNVC_CFG3_COLOR_KEYER_CONTROL                                                                0x1118
#define regCNVC_CFG3_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define regCNVC_CFG3_COLOR_KEYER_ALPHA                                                                  0x1119
#define regCNVC_CFG3_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define regCNVC_CFG3_COLOR_KEYER_RED                                                                    0x111a
#define regCNVC_CFG3_COLOR_KEYER_RED_BASE_IDX                                                           2
#define regCNVC_CFG3_COLOR_KEYER_GREEN                                                                  0x111b
#define regCNVC_CFG3_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define regCNVC_CFG3_COLOR_KEYER_BLUE                                                                   0x111c
#define regCNVC_CFG3_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define regCNVC_CFG3_ALPHA_2BIT_LUT                                                                     0x111e
#define regCNVC_CFG3_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define regCNVC_CFG3_PRE_DEALPHA                                                                        0x111f
#define regCNVC_CFG3_PRE_DEALPHA_BASE_IDX                                                               2
#define regCNVC_CFG3_PRE_CSC_MODE                                                                       0x1120
#define regCNVC_CFG3_PRE_CSC_MODE_BASE_IDX                                                              2
#define regCNVC_CFG3_PRE_CSC_C11_C12                                                                    0x1121
#define regCNVC_CFG3_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define regCNVC_CFG3_PRE_CSC_C13_C14                                                                    0x1122
#define regCNVC_CFG3_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define regCNVC_CFG3_PRE_CSC_C21_C22                                                                    0x1123
#define regCNVC_CFG3_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define regCNVC_CFG3_PRE_CSC_C23_C24                                                                    0x1124
#define regCNVC_CFG3_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define regCNVC_CFG3_PRE_CSC_C31_C32                                                                    0x1125
#define regCNVC_CFG3_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define regCNVC_CFG3_PRE_CSC_C33_C34                                                                    0x1126
#define regCNVC_CFG3_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define regCNVC_CFG3_PRE_CSC_B_C11_C12                                                                  0x1127
#define regCNVC_CFG3_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define regCNVC_CFG3_PRE_CSC_B_C13_C14                                                                  0x1128
#define regCNVC_CFG3_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define regCNVC_CFG3_PRE_CSC_B_C21_C22                                                                  0x1129
#define regCNVC_CFG3_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define regCNVC_CFG3_PRE_CSC_B_C23_C24                                                                  0x112a
#define regCNVC_CFG3_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define regCNVC_CFG3_PRE_CSC_B_C31_C32                                                                  0x112b
#define regCNVC_CFG3_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define regCNVC_CFG3_PRE_CSC_B_C33_C34                                                                  0x112c
#define regCNVC_CFG3_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define regCNVC_CFG3_CNVC_COEF_FORMAT                                                                   0x112d
#define regCNVC_CFG3_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define regCNVC_CFG3_PRE_DEGAM                                                                          0x112e
#define regCNVC_CFG3_PRE_DEGAM_BASE_IDX                                                                 2
#define regCNVC_CFG3_PRE_REALPHA                                                                        0x112f
#define regCNVC_CFG3_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp3_dispdec_cnvc_cur_dispdec
// base address: 0x1104
#define regCNVC_CUR3_CURSOR0_CONTROL                                                                    0x1132
#define regCNVC_CUR3_CURSOR0_CONTROL_BASE_IDX                                                           2
#define regCNVC_CUR3_CURSOR0_COLOR0                                                                     0x1133
#define regCNVC_CUR3_CURSOR0_COLOR0_BASE_IDX                                                            2
#define regCNVC_CUR3_CURSOR0_COLOR1                                                                     0x1134
#define regCNVC_CUR3_CURSOR0_COLOR1_BASE_IDX                                                            2
#define regCNVC_CUR3_CURSOR0_FP_SCALE_BIAS                                                              0x1135
#define regCNVC_CUR3_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2


// addressBlock: dce_dc_dpp3_dispdec_dscl_dispdec
// base address: 0x1104
#define regDSCL3_SCL_COEF_RAM_TAP_SELECT                                                                0x113a
#define regDSCL3_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define regDSCL3_SCL_COEF_RAM_TAP_DATA                                                                  0x113b
#define regDSCL3_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define regDSCL3_SCL_MODE                                                                               0x113c
#define regDSCL3_SCL_MODE_BASE_IDX                                                                      2
#define regDSCL3_SCL_TAP_CONTROL                                                                        0x113d
#define regDSCL3_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define regDSCL3_DSCL_CONTROL                                                                           0x113e
#define regDSCL3_DSCL_CONTROL_BASE_IDX                                                                  2
#define regDSCL3_DSCL_2TAP_CONTROL                                                                      0x113f
#define regDSCL3_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define regDSCL3_SCL_MANUAL_REPLICATE_CONTROL                                                           0x1140
#define regDSCL3_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define regDSCL3_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x1141
#define regDSCL3_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define regDSCL3_SCL_HORZ_FILTER_INIT                                                                   0x1142
#define regDSCL3_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define regDSCL3_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x1143
#define regDSCL3_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define regDSCL3_SCL_HORZ_FILTER_INIT_C                                                                 0x1144
#define regDSCL3_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define regDSCL3_SCL_VERT_FILTER_SCALE_RATIO                                                            0x1145
#define regDSCL3_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define regDSCL3_SCL_VERT_FILTER_INIT                                                                   0x1146
#define regDSCL3_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define regDSCL3_SCL_VERT_FILTER_INIT_BOT                                                               0x1147
#define regDSCL3_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define regDSCL3_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x1148
#define regDSCL3_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define regDSCL3_SCL_VERT_FILTER_INIT_C                                                                 0x1149
#define regDSCL3_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define regDSCL3_SCL_VERT_FILTER_INIT_BOT_C                                                             0x114a
#define regDSCL3_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define regDSCL3_SCL_BLACK_COLOR                                                                        0x114b
#define regDSCL3_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define regDSCL3_DSCL_UPDATE                                                                            0x114c
#define regDSCL3_DSCL_UPDATE_BASE_IDX                                                                   2
#define regDSCL3_DSCL_AUTOCAL                                                                           0x114d
#define regDSCL3_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define regDSCL3_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x114e
#define regDSCL3_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define regDSCL3_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x114f
#define regDSCL3_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define regDSCL3_OTG_H_BLANK                                                                            0x1150
#define regDSCL3_OTG_H_BLANK_BASE_IDX                                                                   2
#define regDSCL3_OTG_V_BLANK                                                                            0x1151
#define regDSCL3_OTG_V_BLANK_BASE_IDX                                                                   2
#define regDSCL3_RECOUT_START                                                                           0x1152
#define regDSCL3_RECOUT_START_BASE_IDX                                                                  2
#define regDSCL3_RECOUT_SIZE                                                                            0x1153
#define regDSCL3_RECOUT_SIZE_BASE_IDX                                                                   2
#define regDSCL3_MPC_SIZE                                                                               0x1154
#define regDSCL3_MPC_SIZE_BASE_IDX                                                                      2
#define regDSCL3_LB_DATA_FORMAT                                                                         0x1155
#define regDSCL3_LB_DATA_FORMAT_BASE_IDX                                                                2
#define regDSCL3_LB_MEMORY_CTRL                                                                         0x1156
#define regDSCL3_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define regDSCL3_LB_V_COUNTER                                                                           0x1157
#define regDSCL3_LB_V_COUNTER_BASE_IDX                                                                  2
#define regDSCL3_DSCL_MEM_PWR_CTRL                                                                      0x1158
#define regDSCL3_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define regDSCL3_DSCL_MEM_PWR_STATUS                                                                    0x1159
#define regDSCL3_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define regDSCL3_OBUF_CONTROL                                                                           0x115a
#define regDSCL3_OBUF_CONTROL_BASE_IDX                                                                  2
#define regDSCL3_OBUF_MEM_PWR_CTRL                                                                      0x115b
#define regDSCL3_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp3_dispdec_cm_dispdec
// base address: 0x1104
#define regCM3_CM_CONTROL                                                                               0x1161
#define regCM3_CM_CONTROL_BASE_IDX                                                                      2
#define regCM3_CM_POST_CSC_CONTROL                                                                      0x1162
#define regCM3_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define regCM3_CM_POST_CSC_C11_C12                                                                      0x1163
#define regCM3_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define regCM3_CM_POST_CSC_C13_C14                                                                      0x1164
#define regCM3_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define regCM3_CM_POST_CSC_C21_C22                                                                      0x1165
#define regCM3_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define regCM3_CM_POST_CSC_C23_C24                                                                      0x1166
#define regCM3_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define regCM3_CM_POST_CSC_C31_C32                                                                      0x1167
#define regCM3_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define regCM3_CM_POST_CSC_C33_C34                                                                      0x1168
#define regCM3_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define regCM3_CM_POST_CSC_B_C11_C12                                                                    0x1169
#define regCM3_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define regCM3_CM_POST_CSC_B_C13_C14                                                                    0x116a
#define regCM3_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define regCM3_CM_POST_CSC_B_C21_C22                                                                    0x116b
#define regCM3_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define regCM3_CM_POST_CSC_B_C23_C24                                                                    0x116c
#define regCM3_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define regCM3_CM_POST_CSC_B_C31_C32                                                                    0x116d
#define regCM3_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define regCM3_CM_POST_CSC_B_C33_C34                                                                    0x116e
#define regCM3_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define regCM3_CM_GAMUT_REMAP_CONTROL                                                                   0x116f
#define regCM3_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define regCM3_CM_GAMUT_REMAP_C11_C12                                                                   0x1170
#define regCM3_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define regCM3_CM_GAMUT_REMAP_C13_C14                                                                   0x1171
#define regCM3_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define regCM3_CM_GAMUT_REMAP_C21_C22                                                                   0x1172
#define regCM3_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define regCM3_CM_GAMUT_REMAP_C23_C24                                                                   0x1173
#define regCM3_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define regCM3_CM_GAMUT_REMAP_C31_C32                                                                   0x1174
#define regCM3_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define regCM3_CM_GAMUT_REMAP_C33_C34                                                                   0x1175
#define regCM3_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define regCM3_CM_GAMUT_REMAP_B_C11_C12                                                                 0x1176
#define regCM3_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define regCM3_CM_GAMUT_REMAP_B_C13_C14                                                                 0x1177
#define regCM3_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define regCM3_CM_GAMUT_REMAP_B_C21_C22                                                                 0x1178
#define regCM3_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define regCM3_CM_GAMUT_REMAP_B_C23_C24                                                                 0x1179
#define regCM3_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define regCM3_CM_GAMUT_REMAP_B_C31_C32                                                                 0x117a
#define regCM3_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define regCM3_CM_GAMUT_REMAP_B_C33_C34                                                                 0x117b
#define regCM3_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define regCM3_CM_BIAS_CR_R                                                                             0x117c
#define regCM3_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define regCM3_CM_BIAS_Y_G_CB_B                                                                         0x117d
#define regCM3_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define regCM3_CM_GAMCOR_CONTROL                                                                        0x117e
#define regCM3_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define regCM3_CM_GAMCOR_LUT_INDEX                                                                      0x117f
#define regCM3_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define regCM3_CM_GAMCOR_LUT_DATA                                                                       0x1180
#define regCM3_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define regCM3_CM_GAMCOR_LUT_CONTROL                                                                    0x1181
#define regCM3_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define regCM3_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x1182
#define regCM3_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x1183
#define regCM3_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x1184
#define regCM3_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x1185
#define regCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define regCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x1186
#define regCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define regCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x1187
#define regCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define regCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x1188
#define regCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define regCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x1189
#define regCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define regCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x118a
#define regCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define regCM3_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x118b
#define regCM3_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x118c
#define regCM3_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x118d
#define regCM3_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x118e
#define regCM3_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x118f
#define regCM3_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x1190
#define regCM3_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x1191
#define regCM3_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define regCM3_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x1192
#define regCM3_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define regCM3_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x1193
#define regCM3_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define regCM3_CM_GAMCOR_RAMA_REGION_0_1                                                                0x1194
#define regCM3_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define regCM3_CM_GAMCOR_RAMA_REGION_2_3                                                                0x1195
#define regCM3_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define regCM3_CM_GAMCOR_RAMA_REGION_4_5                                                                0x1196
#define regCM3_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define regCM3_CM_GAMCOR_RAMA_REGION_6_7                                                                0x1197
#define regCM3_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define regCM3_CM_GAMCOR_RAMA_REGION_8_9                                                                0x1198
#define regCM3_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define regCM3_CM_GAMCOR_RAMA_REGION_10_11                                                              0x1199
#define regCM3_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_12_13                                                              0x119a
#define regCM3_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_14_15                                                              0x119b
#define regCM3_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_16_17                                                              0x119c
#define regCM3_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_18_19                                                              0x119d
#define regCM3_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_20_21                                                              0x119e
#define regCM3_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_22_23                                                              0x119f
#define regCM3_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_24_25                                                              0x11a0
#define regCM3_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_26_27                                                              0x11a1
#define regCM3_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_28_29                                                              0x11a2
#define regCM3_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_30_31                                                              0x11a3
#define regCM3_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMA_REGION_32_33                                                              0x11a4
#define regCM3_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x11a5
#define regCM3_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x11a6
#define regCM3_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x11a7
#define regCM3_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x11a8
#define regCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define regCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x11a9
#define regCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define regCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x11aa
#define regCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define regCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x11ab
#define regCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define regCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x11ac
#define regCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define regCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x11ad
#define regCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define regCM3_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x11ae
#define regCM3_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x11af
#define regCM3_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x11b0
#define regCM3_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x11b1
#define regCM3_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x11b2
#define regCM3_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x11b3
#define regCM3_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define regCM3_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x11b4
#define regCM3_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define regCM3_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x11b5
#define regCM3_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define regCM3_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x11b6
#define regCM3_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define regCM3_CM_GAMCOR_RAMB_REGION_0_1                                                                0x11b7
#define regCM3_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define regCM3_CM_GAMCOR_RAMB_REGION_2_3                                                                0x11b8
#define regCM3_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define regCM3_CM_GAMCOR_RAMB_REGION_4_5                                                                0x11b9
#define regCM3_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define regCM3_CM_GAMCOR_RAMB_REGION_6_7                                                                0x11ba
#define regCM3_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define regCM3_CM_GAMCOR_RAMB_REGION_8_9                                                                0x11bb
#define regCM3_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define regCM3_CM_GAMCOR_RAMB_REGION_10_11                                                              0x11bc
#define regCM3_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_12_13                                                              0x11bd
#define regCM3_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_14_15                                                              0x11be
#define regCM3_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_16_17                                                              0x11bf
#define regCM3_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_18_19                                                              0x11c0
#define regCM3_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_20_21                                                              0x11c1
#define regCM3_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_22_23                                                              0x11c2
#define regCM3_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_24_25                                                              0x11c3
#define regCM3_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_26_27                                                              0x11c4
#define regCM3_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_28_29                                                              0x11c5
#define regCM3_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_30_31                                                              0x11c6
#define regCM3_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define regCM3_CM_GAMCOR_RAMB_REGION_32_33                                                              0x11c7
#define regCM3_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define regCM3_CM_HDR_MULT_COEF                                                                         0x11c8
#define regCM3_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define regCM3_CM_MEM_PWR_CTRL                                                                          0x11c9
#define regCM3_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define regCM3_CM_MEM_PWR_STATUS                                                                        0x11ca
#define regCM3_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define regCM3_CM_DEALPHA                                                                               0x11cc
#define regCM3_CM_DEALPHA_BASE_IDX                                                                      2
#define regCM3_CM_COEF_FORMAT                                                                           0x11cd
#define regCM3_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define regCM3_CM_TEST_DEBUG_INDEX                                                                      0x11ce
#define regCM3_CM_TEST_DEBUG_INDEX_BASE_IDX                                                             2
#define regCM3_CM_TEST_DEBUG_DATA                                                                       0x11cf
#define regCM3_CM_TEST_DEBUG_DATA_BASE_IDX                                                              2


// addressBlock: dce_dc_dpp3_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x4994
#define regDC_PERFMON14_PERFCOUNTER_CNTL                                                                0x1265
#define regDC_PERFMON14_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define regDC_PERFMON14_PERFCOUNTER_CNTL2                                                               0x1266
#define regDC_PERFMON14_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define regDC_PERFMON14_PERFCOUNTER_STATE                                                               0x1267
#define regDC_PERFMON14_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define regDC_PERFMON14_PERFMON_CNTL                                                                    0x1268
#define regDC_PERFMON14_PERFMON_CNTL_BASE_IDX                                                           2
#define regDC_PERFMON14_PERFMON_CNTL2                                                                   0x1269
#define regDC_PERFMON14_PERFMON_CNTL2_BASE_IDX                                                          2
#define regDC_PERFMON14_PERFMON_CVALUE_INT_MISC                                                         0x126a
#define regDC_PERFMON14_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define regDC_PERFMON14_PERFMON_CVALUE_LOW                                                              0x126b
#define regDC_PERFMON14_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define regDC_PERFMON14_PERFMON_HI                                                                      0x126c
#define regDC_PERFMON14_PERFMON_HI_BASE_IDX                                                             2
#define regDC_PERFMON14_PERFMON_LOW                                                                     0x126d
#define regDC_PERFMON14_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_opp_fmt0_dispdec
// base address: 0x0
#define regFMT0_FMT_CLAMP_COMPONENT_R                                                                   0x183c
#define regFMT0_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define regFMT0_FMT_CLAMP_COMPONENT_G                                                                   0x183d
#define regFMT0_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define regFMT0_FMT_CLAMP_COMPONENT_B                                                                   0x183e
#define regFMT0_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define regFMT0_FMT_DYNAMIC_EXP_CNTL                                                                    0x183f
#define regFMT0_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define regFMT0_FMT_CONTROL                                                                             0x1840
#define regFMT0_FMT_CONTROL_BASE_IDX                                                                    2
#define regFMT0_FMT_BIT_DEPTH_CONTROL                                                                   0x1841
#define regFMT0_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define regFMT0_FMT_DITHER_RAND_R_SEED                                                                  0x1842
#define regFMT0_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define regFMT0_FMT_DITHER_RAND_G_SEED                                                                  0x1843
#define regFMT0_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define regFMT0_FMT_DITHER_RAND_B_SEED                                                                  0x1844
#define regFMT0_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define regFMT0_FMT_CLAMP_CNTL                                                                          0x1845
#define regFMT0_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define regFMT0_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x1846
#define regFMT0_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define regFMT0_FMT_MAP420_MEMORY_CONTROL                                                               0x1847
#define regFMT0_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define regFMT0_FMT_422_CONTROL                                                                         0x1849
#define regFMT0_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg0_dispdec
// base address: 0x0
#define regDPG0_DPG_CONTROL                                                                             0x1854
#define regDPG0_DPG_CONTROL_BASE_IDX                                                                    2
#define regDPG0_DPG_RAMP_CONTROL                                                                        0x1855
#define regDPG0_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define regDPG0_DPG_DIMENSIONS                                                                          0x1856
#define regDPG0_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define regDPG0_DPG_COLOUR_R_CR                                                                         0x1857
#define regDPG0_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define regDPG0_DPG_COLOUR_G_Y                                                                          0x1858
#define regDPG0_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define regDPG0_DPG_COLOUR_B_CB                                                                         0x1859
#define regDPG0_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define regDPG0_DPG_OFFSET_SEGMENT                                                                      0x185a
#define regDPG0_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define regDPG0_DPG_STATUS                                                                              0x185b
#define regDPG0_DPG_STATUS_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_oppbuf0_dispdec
// base address: 0x0
#define regOPPBUF0_OPPBUF_CONTROL                                                                       0x1884
#define regOPPBUF0_OPPBUF_CONTROL_BASE_IDX                                                              2
#define regOPPBUF0_OPPBUF_3D_PARAMETERS_0                                                               0x1885
#define regOPPBUF0_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define regOPPBUF0_OPPBUF_3D_PARAMETERS_1                                                               0x1886
#define regOPPBUF0_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define regOPPBUF0_OPPBUF_CONTROL1                                                                      0x1889
#define regOPPBUF0_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe0_dispdec
// base address: 0x0
#define regOPP_PIPE0_OPP_PIPE_CONTROL                                                                   0x188c
#define regOPP_PIPE0_OPP_PIPE_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_opp_opp_pipe_crc0_dispdec
// base address: 0x0
#define regOPP_PIPE_CRC0_OPP_PIPE_CRC_CONTROL                                                           0x1891
#define regOPP_PIPE_CRC0_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define regOPP_PIPE_CRC0_OPP_PIPE_CRC_MASK                                                              0x1892
#define regOPP_PIPE_CRC0_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define regOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT0                                                           0x1893
#define regOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define regOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT1                                                           0x1894
#define regOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define regOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT2                                                           0x1895
#define regOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_fmt1_dispdec
// base address: 0x168
#define regFMT1_FMT_CLAMP_COMPONENT_R                                                                   0x1896
#define regFMT1_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define regFMT1_FMT_CLAMP_COMPONENT_G                                                                   0x1897
#define regFMT1_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define regFMT1_FMT_CLAMP_COMPONENT_B                                                                   0x1898
#define regFMT1_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define regFMT1_FMT_DYNAMIC_EXP_CNTL                                                                    0x1899
#define regFMT1_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define regFMT1_FMT_CONTROL                                                                             0x189a
#define regFMT1_FMT_CONTROL_BASE_IDX                                                                    2
#define regFMT1_FMT_BIT_DEPTH_CONTROL                                                                   0x189b
#define regFMT1_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define regFMT1_FMT_DITHER_RAND_R_SEED                                                                  0x189c
#define regFMT1_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define regFMT1_FMT_DITHER_RAND_G_SEED                                                                  0x189d
#define regFMT1_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define regFMT1_FMT_DITHER_RAND_B_SEED                                                                  0x189e
#define regFMT1_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define regFMT1_FMT_CLAMP_CNTL                                                                          0x189f
#define regFMT1_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define regFMT1_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x18a0
#define regFMT1_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define regFMT1_FMT_MAP420_MEMORY_CONTROL                                                               0x18a1
#define regFMT1_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define regFMT1_FMT_422_CONTROL                                                                         0x18a3
#define regFMT1_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg1_dispdec
// base address: 0x168
#define regDPG1_DPG_CONTROL                                                                             0x18ae
#define regDPG1_DPG_CONTROL_BASE_IDX                                                                    2
#define regDPG1_DPG_RAMP_CONTROL                                                                        0x18af
#define regDPG1_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define regDPG1_DPG_DIMENSIONS                                                                          0x18b0
#define regDPG1_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define regDPG1_DPG_COLOUR_R_CR                                                                         0x18b1
#define regDPG1_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define regDPG1_DPG_COLOUR_G_Y                                                                          0x18b2
#define regDPG1_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define regDPG1_DPG_COLOUR_B_CB                                                                         0x18b3
#define regDPG1_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define regDPG1_DPG_OFFSET_SEGMENT                                                                      0x18b4
#define regDPG1_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define regDPG1_DPG_STATUS                                                                              0x18b5
#define regDPG1_DPG_STATUS_BASE_IDX                                                                     2

// addressBlock: dce_dc_opp_oppbuf1_dispdec
// base address: 0x168
#define regOPPBUF1_OPPBUF_CONTROL                                                                       0x18de
#define regOPPBUF1_OPPBUF_CONTROL_BASE_IDX                                                              2
#define regOPPBUF1_OPPBUF_3D_PARAMETERS_0                                                               0x18df
#define regOPPBUF1_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define regOPPBUF1_OPPBUF_3D_PARAMETERS_1                                                               0x18e0
#define regOPPBUF1_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define regOPPBUF1_OPPBUF_CONTROL1                                                                      0x18e3
#define regOPPBUF1_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe1_dispdec
// base address: 0x168
#define regOPP_PIPE1_OPP_PIPE_CONTROL                                                                   0x18e6
#define regOPP_PIPE1_OPP_PIPE_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_opp_opp_pipe_crc1_dispdec
// base address: 0x168
#define regOPP_PIPE_CRC1_OPP_PIPE_CRC_CONTROL                                                           0x18eb
#define regOPP_PIPE_CRC1_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define regOPP_PIPE_CRC1_OPP_PIPE_CRC_MASK                                                              0x18ec
#define regOPP_PIPE_CRC1_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define regOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT0                                                           0x18ed
#define regOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define regOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT1                                                           0x18ee
#define regOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define regOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT2                                                           0x18ef
#define regOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_fmt2_dispdec
// base address: 0x2d0
#define regFMT2_FMT_CLAMP_COMPONENT_R                                                                   0x18f0
#define regFMT2_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define regFMT2_FMT_CLAMP_COMPONENT_G                                                                   0x18f1
#define regFMT2_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define regFMT2_FMT_CLAMP_COMPONENT_B                                                                   0x18f2
#define regFMT2_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define regFMT2_FMT_DYNAMIC_EXP_CNTL                                                                    0x18f3
#define regFMT2_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define regFMT2_FMT_CONTROL                                                                             0x18f4
#define regFMT2_FMT_CONTROL_BASE_IDX                                                                    2
#define regFMT2_FMT_BIT_DEPTH_CONTROL                                                                   0x18f5
#define regFMT2_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define regFMT2_FMT_DITHER_RAND_R_SEED                                                                  0x18f6
#define regFMT2_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define regFMT2_FMT_DITHER_RAND_G_SEED                                                                  0x18f7
#define regFMT2_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define regFMT2_FMT_DITHER_RAND_B_SEED                                                                  0x18f8
#define regFMT2_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define regFMT2_FMT_CLAMP_CNTL                                                                          0x18f9
#define regFMT2_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define regFMT2_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x18fa
#define regFMT2_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define regFMT2_FMT_MAP420_MEMORY_CONTROL                                                               0x18fb
#define regFMT2_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define regFMT2_FMT_422_CONTROL                                                                         0x18fd
#define regFMT2_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg2_dispdec
// base address: 0x2d0
#define regDPG2_DPG_CONTROL                                                                             0x1908
#define regDPG2_DPG_CONTROL_BASE_IDX                                                                    2
#define regDPG2_DPG_RAMP_CONTROL                                                                        0x1909
#define regDPG2_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define regDPG2_DPG_DIMENSIONS                                                                          0x190a
#define regDPG2_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define regDPG2_DPG_COLOUR_R_CR                                                                         0x190b
#define regDPG2_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define regDPG2_DPG_COLOUR_G_Y                                                                          0x190c
#define regDPG2_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define regDPG2_DPG_COLOUR_B_CB                                                                         0x190d
#define regDPG2_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define regDPG2_DPG_OFFSET_SEGMENT                                                                      0x190e
#define regDPG2_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define regDPG2_DPG_STATUS                                                                              0x190f
#define regDPG2_DPG_STATUS_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_oppbuf2_dispdec
// base address: 0x2d0
#define regOPPBUF2_OPPBUF_CONTROL                                                                       0x1938
#define regOPPBUF2_OPPBUF_CONTROL_BASE_IDX                                                              2
#define regOPPBUF2_OPPBUF_3D_PARAMETERS_0                                                               0x1939
#define regOPPBUF2_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define regOPPBUF2_OPPBUF_3D_PARAMETERS_1                                                               0x193a
#define regOPPBUF2_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define regOPPBUF2_OPPBUF_CONTROL1                                                                      0x193d
#define regOPPBUF2_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe2_dispdec
// base address: 0x2d0
#define regOPP_PIPE2_OPP_PIPE_CONTROL                                                                   0x1940
#define regOPP_PIPE2_OPP_PIPE_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_opp_opp_pipe_crc2_dispdec
// base address: 0x2d0
#define regOPP_PIPE_CRC2_OPP_PIPE_CRC_CONTROL                                                           0x1945
#define regOPP_PIPE_CRC2_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define regOPP_PIPE_CRC2_OPP_PIPE_CRC_MASK                                                              0x1946
#define regOPP_PIPE_CRC2_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define regOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT0                                                           0x1947
#define regOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define regOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT1                                                           0x1948
#define regOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define regOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT2                                                           0x1949
#define regOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_fmt3_dispdec
// base address: 0x438
#define regFMT3_FMT_CLAMP_COMPONENT_R                                                                   0x194a
#define regFMT3_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define regFMT3_FMT_CLAMP_COMPONENT_G                                                                   0x194b
#define regFMT3_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define regFMT3_FMT_CLAMP_COMPONENT_B                                                                   0x194c
#define regFMT3_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define regFMT3_FMT_DYNAMIC_EXP_CNTL                                                                    0x194d
#define regFMT3_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define regFMT3_FMT_CONTROL                                                                             0x194e
#define regFMT3_FMT_CONTROL_BASE_IDX                                                                    2
#define regFMT3_FMT_BIT_DEPTH_CONTROL                                                                   0x194f
#define regFMT3_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define regFMT3_FMT_DITHER_RAND_R_SEED                                                                  0x1950
#define regFMT3_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define regFMT3_FMT_DITHER_RAND_G_SEED                                                                  0x1951
#define regFMT3_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define regFMT3_FMT_DITHER_RAND_B_SEED                                                                  0x1952
#define regFMT3_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define regFMT3_FMT_CLAMP_CNTL                                                                          0x1953
#define regFMT3_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define regFMT3_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x1954
#define regFMT3_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define regFMT3_FMT_MAP420_MEMORY_CONTROL                                                               0x1955
#define regFMT3_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define regFMT3_FMT_422_CONTROL                                                                         0x1957
#define regFMT3_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg3_dispdec
// base address: 0x438
#define regDPG3_DPG_CONTROL                                                                             0x1962
#define regDPG3_DPG_CONTROL_BASE_IDX                                                                    2
#define regDPG3_DPG_RAMP_CONTROL                                                                        0x1963
#define regDPG3_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define regDPG3_DPG_DIMENSIONS                                                                          0x1964
#define regDPG3_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define regDPG3_DPG_COLOUR_R_CR                                                                         0x1965
#define regDPG3_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define regDPG3_DPG_COLOUR_G_Y                                                                          0x1966
#define regDPG3_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define regDPG3_DPG_COLOUR_B_CB                                                                         0x1967
#define regDPG3_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define regDPG3_DPG_OFFSET_SEGMENT                                                                      0x1968
#define regDPG3_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define regDPG3_DPG_STATUS                                                                              0x1969
#define regDPG3_DPG_STATUS_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_oppbuf3_dispdec
// base address: 0x438
#define regOPPBUF3_OPPBUF_CONTROL                                                                       0x1992
#define regOPPBUF3_OPPBUF_CONTROL_BASE_IDX                                                              2
#define regOPPBUF3_OPPBUF_3D_PARAMETERS_0                                                               0x1993
#define regOPPBUF3_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define regOPPBUF3_OPPBUF_3D_PARAMETERS_1                                                               0x1994
#define regOPPBUF3_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define regOPPBUF3_OPPBUF_CONTROL1                                                                      0x1997
#define regOPPBUF3_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe3_dispdec
// base address: 0x438
#define regOPP_PIPE3_OPP_PIPE_CONTROL                                                                   0x199a
#define regOPP_PIPE3_OPP_PIPE_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_opp_opp_pipe_crc3_dispdec
// base address: 0x438
#define regOPP_PIPE_CRC3_OPP_PIPE_CRC_CONTROL                                                           0x199f
#define regOPP_PIPE_CRC3_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define regOPP_PIPE_CRC3_OPP_PIPE_CRC_MASK                                                              0x19a0
#define regOPP_PIPE_CRC3_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define regOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT0                                                           0x19a1
#define regOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define regOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT1                                                           0x19a2
#define regOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define regOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT2                                                           0x19a3
#define regOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_opp_top_dispdec
// base address: 0x0
#define regOPP_TOP_CLK_CONTROL                                                                          0x1a5e
#define regOPP_TOP_CLK_CONTROL_BASE_IDX                                                                 2
#define regOPP_ABM_CONTROL                                                                              0x1a60
#define regOPP_ABM_CONTROL_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_dscrm0_dispdec
// base address: 0x0
#define regDSCRM0_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a64
#define regDSCRM0_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_dscrm1_dispdec
// base address: 0x4
#define regDSCRM1_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a65
#define regDSCRM1_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_dscrm2_dispdec
// base address: 0x8
#define regDSCRM2_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a66
#define regDSCRM2_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_dscrm3_dispdec
// base address: 0xc
#define regDSCRM3_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a67
#define regDSCRM3_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_opp_dcperfmon_dc_perfmon_dispdec
// base address: 0x6af8
#define regDC_PERFMON16_PERFCOUNTER_CNTL                                                                0x1abe
#define regDC_PERFMON16_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define regDC_PERFMON16_PERFCOUNTER_CNTL2                                                               0x1abf
#define regDC_PERFMON16_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define regDC_PERFMON16_PERFCOUNTER_STATE                                                               0x1ac0
#define regDC_PERFMON16_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define regDC_PERFMON16_PERFMON_CNTL                                                                    0x1ac1
#define regDC_PERFMON16_PERFMON_CNTL_BASE_IDX                                                           2
#define regDC_PERFMON16_PERFMON_CNTL2                                                                   0x1ac2
#define regDC_PERFMON16_PERFMON_CNTL2_BASE_IDX                                                          2
#define regDC_PERFMON16_PERFMON_CVALUE_INT_MISC                                                         0x1ac3
#define regDC_PERFMON16_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define regDC_PERFMON16_PERFMON_CVALUE_LOW                                                              0x1ac4
#define regDC_PERFMON16_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define regDC_PERFMON16_PERFMON_HI                                                                      0x1ac5
#define regDC_PERFMON16_PERFMON_HI_BASE_IDX                                                             2
#define regDC_PERFMON16_PERFMON_LOW                                                                     0x1ac6
#define regDC_PERFMON16_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_optc_odm0_dispdec
// base address: 0x0
#define regODM0_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1aca
#define regODM0_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define regODM0_OPTC_DATA_SOURCE_SELECT                                                                 0x1acb
#define regODM0_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define regODM0_OPTC_DATA_FORMAT_CONTROL                                                                0x1acc
#define regODM0_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define regODM0_OPTC_BYTES_PER_PIXEL                                                                    0x1acd
#define regODM0_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define regODM0_OPTC_WIDTH_CONTROL                                                                      0x1ace
#define regODM0_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define regODM0_OPTC_INPUT_CLOCK_CONTROL                                                                0x1acf
#define regODM0_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define regODM0_OPTC_MEMORY_CONFIG                                                                      0x1ad0
#define regODM0_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define regODM0_OPTC_INPUT_SPARE_REGISTER                                                               0x1ad1
#define regODM0_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_odm1_dispdec
// base address: 0x40
#define regODM1_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1ada
#define regODM1_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define regODM1_OPTC_DATA_SOURCE_SELECT                                                                 0x1adb
#define regODM1_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define regODM1_OPTC_DATA_FORMAT_CONTROL                                                                0x1adc
#define regODM1_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define regODM1_OPTC_BYTES_PER_PIXEL                                                                    0x1add
#define regODM1_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define regODM1_OPTC_WIDTH_CONTROL                                                                      0x1ade
#define regODM1_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define regODM1_OPTC_INPUT_CLOCK_CONTROL                                                                0x1adf
#define regODM1_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define regODM1_OPTC_MEMORY_CONFIG                                                                      0x1ae0
#define regODM1_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define regODM1_OPTC_INPUT_SPARE_REGISTER                                                               0x1ae1
#define regODM1_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_odm2_dispdec
// base address: 0x80
#define regODM2_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1aea
#define regODM2_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define regODM2_OPTC_DATA_SOURCE_SELECT                                                                 0x1aeb
#define regODM2_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define regODM2_OPTC_DATA_FORMAT_CONTROL                                                                0x1aec
#define regODM2_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define regODM2_OPTC_BYTES_PER_PIXEL                                                                    0x1aed
#define regODM2_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define regODM2_OPTC_WIDTH_CONTROL                                                                      0x1aee
#define regODM2_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define regODM2_OPTC_INPUT_CLOCK_CONTROL                                                                0x1aef
#define regODM2_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define regODM2_OPTC_MEMORY_CONFIG                                                                      0x1af0
#define regODM2_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define regODM2_OPTC_INPUT_SPARE_REGISTER                                                               0x1af1
#define regODM2_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_odm3_dispdec
// base address: 0xc0
#define regODM3_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1afa
#define regODM3_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define regODM3_OPTC_DATA_SOURCE_SELECT                                                                 0x1afb
#define regODM3_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define regODM3_OPTC_DATA_FORMAT_CONTROL                                                                0x1afc
#define regODM3_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define regODM3_OPTC_BYTES_PER_PIXEL                                                                    0x1afd
#define regODM3_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define regODM3_OPTC_WIDTH_CONTROL                                                                      0x1afe
#define regODM3_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define regODM3_OPTC_INPUT_CLOCK_CONTROL                                                                0x1aff
#define regODM3_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define regODM3_OPTC_MEMORY_CONFIG                                                                      0x1b00
#define regODM3_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define regODM3_OPTC_INPUT_SPARE_REGISTER                                                               0x1b01
#define regODM3_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_otg0_dispdec
// base address: 0x0
#define regOTG0_OTG_H_TOTAL                                                                             0x1b2a
#define regOTG0_OTG_H_TOTAL_BASE_IDX                                                                    2
#define regOTG0_OTG_H_BLANK_START_END                                                                   0x1b2b
#define regOTG0_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define regOTG0_OTG_H_SYNC_A                                                                            0x1b2c
#define regOTG0_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define regOTG0_OTG_H_SYNC_A_CNTL                                                                       0x1b2d
#define regOTG0_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define regOTG0_OTG_H_TIMING_CNTL                                                                       0x1b2e
#define regOTG0_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define regOTG0_OTG_V_TOTAL                                                                             0x1b2f
#define regOTG0_OTG_V_TOTAL_BASE_IDX                                                                    2
#define regOTG0_OTG_V_TOTAL_MIN                                                                         0x1b30
#define regOTG0_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define regOTG0_OTG_V_TOTAL_MAX                                                                         0x1b31
#define regOTG0_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define regOTG0_OTG_V_TOTAL_MID                                                                         0x1b32
#define regOTG0_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define regOTG0_OTG_V_TOTAL_CONTROL                                                                     0x1b33
#define regOTG0_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define regOTG0_OTG_V_COUNT_STOP_CONTROL                                                                0x1b34
#define regOTG0_OTG_V_COUNT_STOP_CONTROL_BASE_IDX                                                       2
#define regOTG0_OTG_V_COUNT_STOP_CONTROL2                                                               0x1b35
#define regOTG0_OTG_V_COUNT_STOP_CONTROL2_BASE_IDX                                                      2
#define regOTG0_OTG_V_TOTAL_INT_STATUS                                                                  0x1b36
#define regOTG0_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define regOTG0_OTG_VSYNC_NOM_INT_STATUS                                                                0x1b37
#define regOTG0_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define regOTG0_OTG_V_BLANK_START_END                                                                   0x1b38
#define regOTG0_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define regOTG0_OTG_V_SYNC_A                                                                            0x1b39
#define regOTG0_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define regOTG0_OTG_V_SYNC_A_CNTL                                                                       0x1b3a
#define regOTG0_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define regOTG0_OTG_TRIGA_CNTL                                                                          0x1b3b
#define regOTG0_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define regOTG0_OTG_TRIGA_MANUAL_TRIG                                                                   0x1b3c
#define regOTG0_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define regOTG0_OTG_TRIGB_CNTL                                                                          0x1b3d
#define regOTG0_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define regOTG0_OTG_TRIGB_MANUAL_TRIG                                                                   0x1b3e
#define regOTG0_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define regOTG0_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1b3f
#define regOTG0_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define regOTG0_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1b41
#define regOTG0_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define regOTG0_OTG_CONTROL                                                                             0x1b43
#define regOTG0_OTG_CONTROL_BASE_IDX                                                                    2
#define regOTG0_OTG_DLPC_CONTROL                                                                        0x1b44
#define regOTG0_OTG_DLPC_CONTROL_BASE_IDX                                                               2
#define regOTG0_OTG_INTERLACE_CONTROL                                                                   0x1b45
#define regOTG0_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define regOTG0_OTG_INTERLACE_STATUS                                                                    0x1b46
#define regOTG0_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define regOTG0_OTG_PIXEL_DATA_READBACK0                                                                0x1b47
#define regOTG0_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define regOTG0_OTG_PIXEL_DATA_READBACK1                                                                0x1b48
#define regOTG0_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define regOTG0_OTG_STATUS                                                                              0x1b49
#define regOTG0_OTG_STATUS_BASE_IDX                                                                     2
#define regOTG0_OTG_STATUS_POSITION                                                                     0x1b4a
#define regOTG0_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define regOTG0_OTG_LONG_VBLANK_STATUS                                                                  0x1b4b
#define regOTG0_OTG_LONG_VBLANK_STATUS_BASE_IDX                                                         2
#define regOTG0_OTG_NOM_VERT_POSITION                                                                   0x1b4c
#define regOTG0_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define regOTG0_OTG_STATUS_FRAME_COUNT                                                                  0x1b4d
#define regOTG0_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define regOTG0_OTG_STATUS_VF_COUNT                                                                     0x1b4e
#define regOTG0_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define regOTG0_OTG_STATUS_HV_COUNT                                                                     0x1b4f
#define regOTG0_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define regOTG0_OTG_COUNT_CONTROL                                                                       0x1b50
#define regOTG0_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define regOTG0_OTG_COUNT_RESET                                                                         0x1b51
#define regOTG0_OTG_COUNT_RESET_BASE_IDX                                                                2
#define regOTG0_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1b52
#define regOTG0_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define regOTG0_OTG_VERT_SYNC_CONTROL                                                                   0x1b53
#define regOTG0_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define regOTG0_OTG_STEREO_STATUS                                                                       0x1b54
#define regOTG0_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define regOTG0_OTG_STEREO_CONTROL                                                                      0x1b55
#define regOTG0_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define regOTG0_OTG_SNAPSHOT_STATUS                                                                     0x1b56
#define regOTG0_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define regOTG0_OTG_SNAPSHOT_CONTROL                                                                    0x1b57
#define regOTG0_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define regOTG0_OTG_SNAPSHOT_POSITION                                                                   0x1b58
#define regOTG0_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define regOTG0_OTG_SNAPSHOT_FRAME                                                                      0x1b59
#define regOTG0_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define regOTG0_OTG_INTERRUPT_CONTROL                                                                   0x1b5a
#define regOTG0_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define regOTG0_OTG_UPDATE_LOCK                                                                         0x1b5b
#define regOTG0_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define regOTG0_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1b5c
#define regOTG0_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define regOTG0_OTG_MASTER_EN                                                                           0x1b5d
#define regOTG0_OTG_MASTER_EN_BASE_IDX                                                                  2
#define regOTG0_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1b5f
#define regOTG0_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define regOTG0_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1b60
#define regOTG0_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define regOTG0_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1b61
#define regOTG0_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define regOTG0_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1b62
#define regOTG0_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define regOTG0_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1b63
#define regOTG0_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define regOTG0_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1b64
#define regOTG0_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define regOTG0_OTG_CRC_CNTL                                                                            0x1b65
#define regOTG0_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define regOTG0_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1b66
#define regOTG0_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define regOTG0_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1b67
#define regOTG0_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define regOTG0_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1b68
#define regOTG0_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define regOTG0_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1b69
#define regOTG0_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define regOTG0_OTG_CRC0_DATA_RG                                                                        0x1b6a
#define regOTG0_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define regOTG0_OTG_CRC0_DATA_B                                                                         0x1b6b
#define regOTG0_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define regOTG0_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1b6c
#define regOTG0_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define regOTG0_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1b6d
#define regOTG0_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define regOTG0_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1b6e
#define regOTG0_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define regOTG0_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1b6f
#define regOTG0_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define regOTG0_OTG_CRC1_DATA_RG                                                                        0x1b70
#define regOTG0_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define regOTG0_OTG_CRC1_DATA_B                                                                         0x1b71
#define regOTG0_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define regOTG0_OTG_CRC2_DATA_RG                                                                        0x1b72
#define regOTG0_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define regOTG0_OTG_CRC2_DATA_B                                                                         0x1b73
#define regOTG0_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define regOTG0_OTG_CRC3_DATA_RG                                                                        0x1b74
#define regOTG0_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define regOTG0_OTG_CRC3_DATA_B                                                                         0x1b75
#define regOTG0_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define regOTG0_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1b76
#define regOTG0_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define regOTG0_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1b77
#define regOTG0_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define regOTG0_OTG_CRC0_WINDOWA_X_CONTROL_READBACK                                                     0x1b78
#define regOTG0_OTG_CRC0_WINDOWA_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG0_OTG_CRC0_WINDOWA_Y_CONTROL_READBACK                                                     0x1b79
#define regOTG0_OTG_CRC0_WINDOWA_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG0_OTG_CRC0_WINDOWB_X_CONTROL_READBACK                                                     0x1b7a
#define regOTG0_OTG_CRC0_WINDOWB_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG0_OTG_CRC0_WINDOWB_Y_CONTROL_READBACK                                                     0x1b7b
#define regOTG0_OTG_CRC0_WINDOWB_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG0_OTG_CRC1_WINDOWA_X_CONTROL_READBACK                                                     0x1b7c
#define regOTG0_OTG_CRC1_WINDOWA_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG0_OTG_CRC1_WINDOWA_Y_CONTROL_READBACK                                                     0x1b7d
#define regOTG0_OTG_CRC1_WINDOWA_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG0_OTG_CRC1_WINDOWB_X_CONTROL_READBACK                                                     0x1b7e
#define regOTG0_OTG_CRC1_WINDOWB_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG0_OTG_CRC1_WINDOWB_Y_CONTROL_READBACK                                                     0x1b7f
#define regOTG0_OTG_CRC1_WINDOWB_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG0_OTG_STATIC_SCREEN_CONTROL                                                               0x1b80
#define regOTG0_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define regOTG0_OTG_3D_STRUCTURE_CONTROL                                                                0x1b81
#define regOTG0_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define regOTG0_OTG_GSL_VSYNC_GAP                                                                       0x1b82
#define regOTG0_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define regOTG0_OTG_MASTER_UPDATE_MODE                                                                  0x1b83
#define regOTG0_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define regOTG0_OTG_CLOCK_CONTROL                                                                       0x1b84
#define regOTG0_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define regOTG0_OTG_VSTARTUP_PARAM                                                                      0x1b85
#define regOTG0_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define regOTG0_OTG_VUPDATE_PARAM                                                                       0x1b86
#define regOTG0_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define regOTG0_OTG_VREADY_PARAM                                                                        0x1b87
#define regOTG0_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define regOTG0_OTG_GLOBAL_SYNC_STATUS                                                                  0x1b88
#define regOTG0_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define regOTG0_OTG_MASTER_UPDATE_LOCK                                                                  0x1b89
#define regOTG0_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define regOTG0_OTG_GSL_CONTROL                                                                         0x1b8a
#define regOTG0_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define regOTG0_OTG_GSL_WINDOW_X                                                                        0x1b8b
#define regOTG0_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define regOTG0_OTG_GSL_WINDOW_Y                                                                        0x1b8c
#define regOTG0_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define regOTG0_OTG_VUPDATE_KEEPOUT                                                                     0x1b8d
#define regOTG0_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define regOTG0_OTG_GLOBAL_CONTROL0                                                                     0x1b8e
#define regOTG0_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define regOTG0_OTG_GLOBAL_CONTROL1                                                                     0x1b8f
#define regOTG0_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define regOTG0_OTG_GLOBAL_CONTROL2                                                                     0x1b90
#define regOTG0_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define regOTG0_OTG_GLOBAL_CONTROL3                                                                     0x1b91
#define regOTG0_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define regOTG0_OTG_GLOBAL_CONTROL4                                                                     0x1b92
#define regOTG0_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define regOTG0_OTG_TRIG_MANUAL_CONTROL                                                                 0x1b93
#define regOTG0_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define regOTG0_OTG_DRR_TIMING_INT_STATUS                                                               0x1b95
#define regOTG0_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define regOTG0_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1b96
#define regOTG0_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define regOTG0_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1b97
#define regOTG0_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define regOTG0_OTG_DRR_TRIGGER_WINDOW                                                                  0x1b98
#define regOTG0_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define regOTG0_OTG_DRR_CONTROL                                                                         0x1b99
#define regOTG0_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define regOTG0_OTG_DRR_CONTOL2                                                                         0x1b9a
#define regOTG0_OTG_DRR_CONTOL2_BASE_IDX                                                                2
#define regOTG0_OTG_M_CONST_DTO0                                                                        0x1b9b
#define regOTG0_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define regOTG0_OTG_M_CONST_DTO1                                                                        0x1b9c
#define regOTG0_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define regOTG0_OTG_REQUEST_CONTROL                                                                     0x1b9d
#define regOTG0_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define regOTG0_OTG_DSC_START_POSITION                                                                  0x1b9e
#define regOTG0_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define regOTG0_OTG_PIPE_UPDATE_STATUS                                                                  0x1b9f
#define regOTG0_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define regOTG0_OTG_SPARE_REGISTER                                                                      0x1ba0
#define regOTG0_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_otg1_dispdec
// base address: 0x200
#define regOTG1_OTG_H_TOTAL                                                                             0x1baa
#define regOTG1_OTG_H_TOTAL_BASE_IDX                                                                    2
#define regOTG1_OTG_H_BLANK_START_END                                                                   0x1bab
#define regOTG1_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define regOTG1_OTG_H_SYNC_A                                                                            0x1bac
#define regOTG1_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define regOTG1_OTG_H_SYNC_A_CNTL                                                                       0x1bad
#define regOTG1_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define regOTG1_OTG_H_TIMING_CNTL                                                                       0x1bae
#define regOTG1_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define regOTG1_OTG_V_TOTAL                                                                             0x1baf
#define regOTG1_OTG_V_TOTAL_BASE_IDX                                                                    2
#define regOTG1_OTG_V_TOTAL_MIN                                                                         0x1bb0
#define regOTG1_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define regOTG1_OTG_V_TOTAL_MAX                                                                         0x1bb1
#define regOTG1_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define regOTG1_OTG_V_TOTAL_MID                                                                         0x1bb2
#define regOTG1_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define regOTG1_OTG_V_TOTAL_CONTROL                                                                     0x1bb3
#define regOTG1_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define regOTG1_OTG_V_COUNT_STOP_CONTROL                                                                0x1bb4
#define regOTG1_OTG_V_COUNT_STOP_CONTROL_BASE_IDX                                                       2
#define regOTG1_OTG_V_COUNT_STOP_CONTROL2                                                               0x1bb5
#define regOTG1_OTG_V_COUNT_STOP_CONTROL2_BASE_IDX                                                      2
#define regOTG1_OTG_V_TOTAL_INT_STATUS                                                                  0x1bb6
#define regOTG1_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define regOTG1_OTG_VSYNC_NOM_INT_STATUS                                                                0x1bb7
#define regOTG1_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define regOTG1_OTG_V_BLANK_START_END                                                                   0x1bb8
#define regOTG1_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define regOTG1_OTG_V_SYNC_A                                                                            0x1bb9
#define regOTG1_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define regOTG1_OTG_V_SYNC_A_CNTL                                                                       0x1bba
#define regOTG1_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define regOTG1_OTG_TRIGA_CNTL                                                                          0x1bbb
#define regOTG1_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define regOTG1_OTG_TRIGA_MANUAL_TRIG                                                                   0x1bbc
#define regOTG1_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define regOTG1_OTG_TRIGB_CNTL                                                                          0x1bbd
#define regOTG1_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define regOTG1_OTG_TRIGB_MANUAL_TRIG                                                                   0x1bbe
#define regOTG1_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define regOTG1_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1bbf
#define regOTG1_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define regOTG1_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1bc1
#define regOTG1_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define regOTG1_OTG_CONTROL                                                                             0x1bc3
#define regOTG1_OTG_CONTROL_BASE_IDX                                                                    2
#define regOTG1_OTG_DLPC_CONTROL                                                                        0x1bc4
#define regOTG1_OTG_DLPC_CONTROL_BASE_IDX                                                               2
#define regOTG1_OTG_INTERLACE_CONTROL                                                                   0x1bc5
#define regOTG1_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define regOTG1_OTG_INTERLACE_STATUS                                                                    0x1bc6
#define regOTG1_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define regOTG1_OTG_PIXEL_DATA_READBACK0                                                                0x1bc7
#define regOTG1_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define regOTG1_OTG_PIXEL_DATA_READBACK1                                                                0x1bc8
#define regOTG1_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define regOTG1_OTG_STATUS                                                                              0x1bc9
#define regOTG1_OTG_STATUS_BASE_IDX                                                                     2
#define regOTG1_OTG_STATUS_POSITION                                                                     0x1bca
#define regOTG1_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define regOTG1_OTG_LONG_VBLANK_STATUS                                                                  0x1bcb
#define regOTG1_OTG_LONG_VBLANK_STATUS_BASE_IDX                                                         2
#define regOTG1_OTG_NOM_VERT_POSITION                                                                   0x1bcc
#define regOTG1_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define regOTG1_OTG_STATUS_FRAME_COUNT                                                                  0x1bcd
#define regOTG1_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define regOTG1_OTG_STATUS_VF_COUNT                                                                     0x1bce
#define regOTG1_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define regOTG1_OTG_STATUS_HV_COUNT                                                                     0x1bcf
#define regOTG1_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define regOTG1_OTG_COUNT_CONTROL                                                                       0x1bd0
#define regOTG1_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define regOTG1_OTG_COUNT_RESET                                                                         0x1bd1
#define regOTG1_OTG_COUNT_RESET_BASE_IDX                                                                2
#define regOTG1_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1bd2
#define regOTG1_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define regOTG1_OTG_VERT_SYNC_CONTROL                                                                   0x1bd3
#define regOTG1_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define regOTG1_OTG_STEREO_STATUS                                                                       0x1bd4
#define regOTG1_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define regOTG1_OTG_STEREO_CONTROL                                                                      0x1bd5
#define regOTG1_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define regOTG1_OTG_SNAPSHOT_STATUS                                                                     0x1bd6
#define regOTG1_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define regOTG1_OTG_SNAPSHOT_CONTROL                                                                    0x1bd7
#define regOTG1_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define regOTG1_OTG_SNAPSHOT_POSITION                                                                   0x1bd8
#define regOTG1_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define regOTG1_OTG_SNAPSHOT_FRAME                                                                      0x1bd9
#define regOTG1_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define regOTG1_OTG_INTERRUPT_CONTROL                                                                   0x1bda
#define regOTG1_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define regOTG1_OTG_UPDATE_LOCK                                                                         0x1bdb
#define regOTG1_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define regOTG1_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1bdc
#define regOTG1_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define regOTG1_OTG_MASTER_EN                                                                           0x1bdd
#define regOTG1_OTG_MASTER_EN_BASE_IDX                                                                  2
#define regOTG1_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1bdf
#define regOTG1_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define regOTG1_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1be0
#define regOTG1_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define regOTG1_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1be1
#define regOTG1_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define regOTG1_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1be2
#define regOTG1_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define regOTG1_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1be3
#define regOTG1_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define regOTG1_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1be4
#define regOTG1_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define regOTG1_OTG_CRC_CNTL                                                                            0x1be5
#define regOTG1_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define regOTG1_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1be6
#define regOTG1_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define regOTG1_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1be7
#define regOTG1_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define regOTG1_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1be8
#define regOTG1_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define regOTG1_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1be9
#define regOTG1_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define regOTG1_OTG_CRC0_DATA_RG                                                                        0x1bea
#define regOTG1_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define regOTG1_OTG_CRC0_DATA_B                                                                         0x1beb
#define regOTG1_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define regOTG1_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1bec
#define regOTG1_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define regOTG1_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1bed
#define regOTG1_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define regOTG1_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1bee
#define regOTG1_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define regOTG1_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1bef
#define regOTG1_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define regOTG1_OTG_CRC1_DATA_RG                                                                        0x1bf0
#define regOTG1_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define regOTG1_OTG_CRC1_DATA_B                                                                         0x1bf1
#define regOTG1_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define regOTG1_OTG_CRC2_DATA_RG                                                                        0x1bf2
#define regOTG1_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define regOTG1_OTG_CRC2_DATA_B                                                                         0x1bf3
#define regOTG1_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define regOTG1_OTG_CRC3_DATA_RG                                                                        0x1bf4
#define regOTG1_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define regOTG1_OTG_CRC3_DATA_B                                                                         0x1bf5
#define regOTG1_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define regOTG1_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1bf6
#define regOTG1_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define regOTG1_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1bf7
#define regOTG1_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define regOTG1_OTG_CRC0_WINDOWA_X_CONTROL_READBACK                                                     0x1bf8
#define regOTG1_OTG_CRC0_WINDOWA_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG1_OTG_CRC0_WINDOWA_Y_CONTROL_READBACK                                                     0x1bf9
#define regOTG1_OTG_CRC0_WINDOWA_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG1_OTG_CRC0_WINDOWB_X_CONTROL_READBACK                                                     0x1bfa
#define regOTG1_OTG_CRC0_WINDOWB_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG1_OTG_CRC0_WINDOWB_Y_CONTROL_READBACK                                                     0x1bfb
#define regOTG1_OTG_CRC0_WINDOWB_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG1_OTG_CRC1_WINDOWA_X_CONTROL_READBACK                                                     0x1bfc
#define regOTG1_OTG_CRC1_WINDOWA_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG1_OTG_CRC1_WINDOWA_Y_CONTROL_READBACK                                                     0x1bfd
#define regOTG1_OTG_CRC1_WINDOWA_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG1_OTG_CRC1_WINDOWB_X_CONTROL_READBACK                                                     0x1bfe
#define regOTG1_OTG_CRC1_WINDOWB_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG1_OTG_CRC1_WINDOWB_Y_CONTROL_READBACK                                                     0x1bff
#define regOTG1_OTG_CRC1_WINDOWB_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG1_OTG_STATIC_SCREEN_CONTROL                                                               0x1c00
#define regOTG1_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define regOTG1_OTG_3D_STRUCTURE_CONTROL                                                                0x1c01
#define regOTG1_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define regOTG1_OTG_GSL_VSYNC_GAP                                                                       0x1c02
#define regOTG1_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define regOTG1_OTG_MASTER_UPDATE_MODE                                                                  0x1c03
#define regOTG1_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define regOTG1_OTG_CLOCK_CONTROL                                                                       0x1c04
#define regOTG1_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define regOTG1_OTG_VSTARTUP_PARAM                                                                      0x1c05
#define regOTG1_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define regOTG1_OTG_VUPDATE_PARAM                                                                       0x1c06
#define regOTG1_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define regOTG1_OTG_VREADY_PARAM                                                                        0x1c07
#define regOTG1_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define regOTG1_OTG_GLOBAL_SYNC_STATUS                                                                  0x1c08
#define regOTG1_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define regOTG1_OTG_MASTER_UPDATE_LOCK                                                                  0x1c09
#define regOTG1_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define regOTG1_OTG_GSL_CONTROL                                                                         0x1c0a
#define regOTG1_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define regOTG1_OTG_GSL_WINDOW_X                                                                        0x1c0b
#define regOTG1_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define regOTG1_OTG_GSL_WINDOW_Y                                                                        0x1c0c
#define regOTG1_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define regOTG1_OTG_VUPDATE_KEEPOUT                                                                     0x1c0d
#define regOTG1_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define regOTG1_OTG_GLOBAL_CONTROL0                                                                     0x1c0e
#define regOTG1_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define regOTG1_OTG_GLOBAL_CONTROL1                                                                     0x1c0f
#define regOTG1_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define regOTG1_OTG_GLOBAL_CONTROL2                                                                     0x1c10
#define regOTG1_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define regOTG1_OTG_GLOBAL_CONTROL3                                                                     0x1c11
#define regOTG1_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define regOTG1_OTG_GLOBAL_CONTROL4                                                                     0x1c12
#define regOTG1_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define regOTG1_OTG_TRIG_MANUAL_CONTROL                                                                 0x1c13
#define regOTG1_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define regOTG1_OTG_DRR_TIMING_INT_STATUS                                                               0x1c15
#define regOTG1_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define regOTG1_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1c16
#define regOTG1_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define regOTG1_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1c17
#define regOTG1_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define regOTG1_OTG_DRR_TRIGGER_WINDOW                                                                  0x1c18
#define regOTG1_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define regOTG1_OTG_DRR_CONTROL                                                                         0x1c19
#define regOTG1_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define regOTG1_OTG_DRR_CONTOL2                                                                         0x1c1a
#define regOTG1_OTG_DRR_CONTOL2_BASE_IDX                                                                2
#define regOTG1_OTG_M_CONST_DTO0                                                                        0x1c1b
#define regOTG1_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define regOTG1_OTG_M_CONST_DTO1                                                                        0x1c1c
#define regOTG1_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define regOTG1_OTG_REQUEST_CONTROL                                                                     0x1c1d
#define regOTG1_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define regOTG1_OTG_DSC_START_POSITION                                                                  0x1c1e
#define regOTG1_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define regOTG1_OTG_PIPE_UPDATE_STATUS                                                                  0x1c1f
#define regOTG1_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define regOTG1_OTG_SPARE_REGISTER                                                                      0x1c20
#define regOTG1_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_otg2_dispdec
// base address: 0x400
#define regOTG2_OTG_H_TOTAL                                                                             0x1c2a
#define regOTG2_OTG_H_TOTAL_BASE_IDX                                                                    2
#define regOTG2_OTG_H_BLANK_START_END                                                                   0x1c2b
#define regOTG2_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define regOTG2_OTG_H_SYNC_A                                                                            0x1c2c
#define regOTG2_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define regOTG2_OTG_H_SYNC_A_CNTL                                                                       0x1c2d
#define regOTG2_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define regOTG2_OTG_H_TIMING_CNTL                                                                       0x1c2e
#define regOTG2_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define regOTG2_OTG_V_TOTAL                                                                             0x1c2f
#define regOTG2_OTG_V_TOTAL_BASE_IDX                                                                    2
#define regOTG2_OTG_V_TOTAL_MIN                                                                         0x1c30
#define regOTG2_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define regOTG2_OTG_V_TOTAL_MAX                                                                         0x1c31
#define regOTG2_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define regOTG2_OTG_V_TOTAL_MID                                                                         0x1c32
#define regOTG2_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define regOTG2_OTG_V_TOTAL_CONTROL                                                                     0x1c33
#define regOTG2_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define regOTG2_OTG_V_COUNT_STOP_CONTROL                                                                0x1c34
#define regOTG2_OTG_V_COUNT_STOP_CONTROL_BASE_IDX                                                       2
#define regOTG2_OTG_V_COUNT_STOP_CONTROL2                                                               0x1c35
#define regOTG2_OTG_V_COUNT_STOP_CONTROL2_BASE_IDX                                                      2
#define regOTG2_OTG_V_TOTAL_INT_STATUS                                                                  0x1c36
#define regOTG2_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define regOTG2_OTG_VSYNC_NOM_INT_STATUS                                                                0x1c37
#define regOTG2_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define regOTG2_OTG_V_BLANK_START_END                                                                   0x1c38
#define regOTG2_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define regOTG2_OTG_V_SYNC_A                                                                            0x1c39
#define regOTG2_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define regOTG2_OTG_V_SYNC_A_CNTL                                                                       0x1c3a
#define regOTG2_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define regOTG2_OTG_TRIGA_CNTL                                                                          0x1c3b
#define regOTG2_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define regOTG2_OTG_TRIGA_MANUAL_TRIG                                                                   0x1c3c
#define regOTG2_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define regOTG2_OTG_TRIGB_CNTL                                                                          0x1c3d
#define regOTG2_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define regOTG2_OTG_TRIGB_MANUAL_TRIG                                                                   0x1c3e
#define regOTG2_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define regOTG2_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1c3f
#define regOTG2_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define regOTG2_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1c41
#define regOTG2_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define regOTG2_OTG_CONTROL                                                                             0x1c43
#define regOTG2_OTG_CONTROL_BASE_IDX                                                                    2
#define regOTG2_OTG_DLPC_CONTROL                                                                        0x1c44
#define regOTG2_OTG_DLPC_CONTROL_BASE_IDX                                                               2
#define regOTG2_OTG_INTERLACE_CONTROL                                                                   0x1c45
#define regOTG2_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define regOTG2_OTG_INTERLACE_STATUS                                                                    0x1c46
#define regOTG2_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define regOTG2_OTG_PIXEL_DATA_READBACK0                                                                0x1c47
#define regOTG2_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define regOTG2_OTG_PIXEL_DATA_READBACK1                                                                0x1c48
#define regOTG2_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define regOTG2_OTG_STATUS                                                                              0x1c49
#define regOTG2_OTG_STATUS_BASE_IDX                                                                     2
#define regOTG2_OTG_STATUS_POSITION                                                                     0x1c4a
#define regOTG2_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define regOTG2_OTG_LONG_VBLANK_STATUS                                                                  0x1c4b
#define regOTG2_OTG_LONG_VBLANK_STATUS_BASE_IDX                                                         2
#define regOTG2_OTG_NOM_VERT_POSITION                                                                   0x1c4c
#define regOTG2_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define regOTG2_OTG_STATUS_FRAME_COUNT                                                                  0x1c4d
#define regOTG2_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define regOTG2_OTG_STATUS_VF_COUNT                                                                     0x1c4e
#define regOTG2_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define regOTG2_OTG_STATUS_HV_COUNT                                                                     0x1c4f
#define regOTG2_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define regOTG2_OTG_COUNT_CONTROL                                                                       0x1c50
#define regOTG2_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define regOTG2_OTG_COUNT_RESET                                                                         0x1c51
#define regOTG2_OTG_COUNT_RESET_BASE_IDX                                                                2
#define regOTG2_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1c52
#define regOTG2_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define regOTG2_OTG_VERT_SYNC_CONTROL                                                                   0x1c53
#define regOTG2_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define regOTG2_OTG_STEREO_STATUS                                                                       0x1c54
#define regOTG2_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define regOTG2_OTG_STEREO_CONTROL                                                                      0x1c55
#define regOTG2_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define regOTG2_OTG_SNAPSHOT_STATUS                                                                     0x1c56
#define regOTG2_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define regOTG2_OTG_SNAPSHOT_CONTROL                                                                    0x1c57
#define regOTG2_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define regOTG2_OTG_SNAPSHOT_POSITION                                                                   0x1c58
#define regOTG2_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define regOTG2_OTG_SNAPSHOT_FRAME                                                                      0x1c59
#define regOTG2_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define regOTG2_OTG_INTERRUPT_CONTROL                                                                   0x1c5a
#define regOTG2_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define regOTG2_OTG_UPDATE_LOCK                                                                         0x1c5b
#define regOTG2_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define regOTG2_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1c5c
#define regOTG2_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define regOTG2_OTG_MASTER_EN                                                                           0x1c5d
#define regOTG2_OTG_MASTER_EN_BASE_IDX                                                                  2
#define regOTG2_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1c5f
#define regOTG2_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define regOTG2_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1c60
#define regOTG2_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define regOTG2_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1c61
#define regOTG2_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define regOTG2_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1c62
#define regOTG2_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define regOTG2_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1c63
#define regOTG2_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define regOTG2_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1c64
#define regOTG2_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define regOTG2_OTG_CRC_CNTL                                                                            0x1c65
#define regOTG2_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define regOTG2_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1c66
#define regOTG2_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define regOTG2_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1c67
#define regOTG2_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define regOTG2_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1c68
#define regOTG2_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define regOTG2_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1c69
#define regOTG2_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define regOTG2_OTG_CRC0_DATA_RG                                                                        0x1c6a
#define regOTG2_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define regOTG2_OTG_CRC0_DATA_B                                                                         0x1c6b
#define regOTG2_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define regOTG2_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1c6c
#define regOTG2_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define regOTG2_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1c6d
#define regOTG2_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define regOTG2_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1c6e
#define regOTG2_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define regOTG2_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1c6f
#define regOTG2_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define regOTG2_OTG_CRC1_DATA_RG                                                                        0x1c70
#define regOTG2_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define regOTG2_OTG_CRC1_DATA_B                                                                         0x1c71
#define regOTG2_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define regOTG2_OTG_CRC2_DATA_RG                                                                        0x1c72
#define regOTG2_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define regOTG2_OTG_CRC2_DATA_B                                                                         0x1c73
#define regOTG2_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define regOTG2_OTG_CRC3_DATA_RG                                                                        0x1c74
#define regOTG2_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define regOTG2_OTG_CRC3_DATA_B                                                                         0x1c75
#define regOTG2_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define regOTG2_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1c76
#define regOTG2_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define regOTG2_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1c77
#define regOTG2_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define regOTG2_OTG_CRC0_WINDOWA_X_CONTROL_READBACK                                                     0x1c78
#define regOTG2_OTG_CRC0_WINDOWA_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG2_OTG_CRC0_WINDOWA_Y_CONTROL_READBACK                                                     0x1c79
#define regOTG2_OTG_CRC0_WINDOWA_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG2_OTG_CRC0_WINDOWB_X_CONTROL_READBACK                                                     0x1c7a
#define regOTG2_OTG_CRC0_WINDOWB_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG2_OTG_CRC0_WINDOWB_Y_CONTROL_READBACK                                                     0x1c7b
#define regOTG2_OTG_CRC0_WINDOWB_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG2_OTG_CRC1_WINDOWA_X_CONTROL_READBACK                                                     0x1c7c
#define regOTG2_OTG_CRC1_WINDOWA_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG2_OTG_CRC1_WINDOWA_Y_CONTROL_READBACK                                                     0x1c7d
#define regOTG2_OTG_CRC1_WINDOWA_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG2_OTG_CRC1_WINDOWB_X_CONTROL_READBACK                                                     0x1c7e
#define regOTG2_OTG_CRC1_WINDOWB_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG2_OTG_CRC1_WINDOWB_Y_CONTROL_READBACK                                                     0x1c7f
#define regOTG2_OTG_CRC1_WINDOWB_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG2_OTG_STATIC_SCREEN_CONTROL                                                               0x1c80
#define regOTG2_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define regOTG2_OTG_3D_STRUCTURE_CONTROL                                                                0x1c81
#define regOTG2_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define regOTG2_OTG_GSL_VSYNC_GAP                                                                       0x1c82
#define regOTG2_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define regOTG2_OTG_MASTER_UPDATE_MODE                                                                  0x1c83
#define regOTG2_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define regOTG2_OTG_CLOCK_CONTROL                                                                       0x1c84
#define regOTG2_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define regOTG2_OTG_VSTARTUP_PARAM                                                                      0x1c85
#define regOTG2_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define regOTG2_OTG_VUPDATE_PARAM                                                                       0x1c86
#define regOTG2_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define regOTG2_OTG_VREADY_PARAM                                                                        0x1c87
#define regOTG2_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define regOTG2_OTG_GLOBAL_SYNC_STATUS                                                                  0x1c88
#define regOTG2_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define regOTG2_OTG_MASTER_UPDATE_LOCK                                                                  0x1c89
#define regOTG2_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define regOTG2_OTG_GSL_CONTROL                                                                         0x1c8a
#define regOTG2_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define regOTG2_OTG_GSL_WINDOW_X                                                                        0x1c8b
#define regOTG2_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define regOTG2_OTG_GSL_WINDOW_Y                                                                        0x1c8c
#define regOTG2_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define regOTG2_OTG_VUPDATE_KEEPOUT                                                                     0x1c8d
#define regOTG2_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define regOTG2_OTG_GLOBAL_CONTROL0                                                                     0x1c8e
#define regOTG2_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define regOTG2_OTG_GLOBAL_CONTROL1                                                                     0x1c8f
#define regOTG2_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define regOTG2_OTG_GLOBAL_CONTROL2                                                                     0x1c90
#define regOTG2_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define regOTG2_OTG_GLOBAL_CONTROL3                                                                     0x1c91
#define regOTG2_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define regOTG2_OTG_GLOBAL_CONTROL4                                                                     0x1c92
#define regOTG2_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define regOTG2_OTG_TRIG_MANUAL_CONTROL                                                                 0x1c93
#define regOTG2_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define regOTG2_OTG_DRR_TIMING_INT_STATUS                                                               0x1c95
#define regOTG2_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define regOTG2_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1c96
#define regOTG2_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define regOTG2_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1c97
#define regOTG2_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define regOTG2_OTG_DRR_TRIGGER_WINDOW                                                                  0x1c98
#define regOTG2_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define regOTG2_OTG_DRR_CONTROL                                                                         0x1c99
#define regOTG2_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define regOTG2_OTG_DRR_CONTOL2                                                                         0x1c9a
#define regOTG2_OTG_DRR_CONTOL2_BASE_IDX                                                                2
#define regOTG2_OTG_M_CONST_DTO0                                                                        0x1c9b
#define regOTG2_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define regOTG2_OTG_M_CONST_DTO1                                                                        0x1c9c
#define regOTG2_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define regOTG2_OTG_REQUEST_CONTROL                                                                     0x1c9d
#define regOTG2_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define regOTG2_OTG_DSC_START_POSITION                                                                  0x1c9e
#define regOTG2_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define regOTG2_OTG_PIPE_UPDATE_STATUS                                                                  0x1c9f
#define regOTG2_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define regOTG2_OTG_SPARE_REGISTER                                                                      0x1ca0
#define regOTG2_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_otg3_dispdec
// base address: 0x600
#define regOTG3_OTG_H_TOTAL                                                                             0x1caa
#define regOTG3_OTG_H_TOTAL_BASE_IDX                                                                    2
#define regOTG3_OTG_H_BLANK_START_END                                                                   0x1cab
#define regOTG3_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define regOTG3_OTG_H_SYNC_A                                                                            0x1cac
#define regOTG3_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define regOTG3_OTG_H_SYNC_A_CNTL                                                                       0x1cad
#define regOTG3_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define regOTG3_OTG_H_TIMING_CNTL                                                                       0x1cae
#define regOTG3_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define regOTG3_OTG_V_TOTAL                                                                             0x1caf
#define regOTG3_OTG_V_TOTAL_BASE_IDX                                                                    2
#define regOTG3_OTG_V_TOTAL_MIN                                                                         0x1cb0
#define regOTG3_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define regOTG3_OTG_V_TOTAL_MAX                                                                         0x1cb1
#define regOTG3_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define regOTG3_OTG_V_TOTAL_MID                                                                         0x1cb2
#define regOTG3_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define regOTG3_OTG_V_TOTAL_CONTROL                                                                     0x1cb3
#define regOTG3_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define regOTG3_OTG_V_COUNT_STOP_CONTROL                                                                0x1cb4
#define regOTG3_OTG_V_COUNT_STOP_CONTROL_BASE_IDX                                                       2
#define regOTG3_OTG_V_COUNT_STOP_CONTROL2                                                               0x1cb5
#define regOTG3_OTG_V_COUNT_STOP_CONTROL2_BASE_IDX                                                      2
#define regOTG3_OTG_V_TOTAL_INT_STATUS                                                                  0x1cb6
#define regOTG3_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define regOTG3_OTG_VSYNC_NOM_INT_STATUS                                                                0x1cb7
#define regOTG3_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define regOTG3_OTG_V_BLANK_START_END                                                                   0x1cb8
#define regOTG3_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define regOTG3_OTG_V_SYNC_A                                                                            0x1cb9
#define regOTG3_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define regOTG3_OTG_V_SYNC_A_CNTL                                                                       0x1cba
#define regOTG3_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define regOTG3_OTG_TRIGA_CNTL                                                                          0x1cbb
#define regOTG3_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define regOTG3_OTG_TRIGA_MANUAL_TRIG                                                                   0x1cbc
#define regOTG3_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define regOTG3_OTG_TRIGB_CNTL                                                                          0x1cbd
#define regOTG3_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define regOTG3_OTG_TRIGB_MANUAL_TRIG                                                                   0x1cbe
#define regOTG3_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define regOTG3_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1cbf
#define regOTG3_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define regOTG3_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1cc1
#define regOTG3_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define regOTG3_OTG_CONTROL                                                                             0x1cc3
#define regOTG3_OTG_CONTROL_BASE_IDX                                                                    2
#define regOTG3_OTG_DLPC_CONTROL                                                                        0x1cc4
#define regOTG3_OTG_DLPC_CONTROL_BASE_IDX                                                               2
#define regOTG3_OTG_INTERLACE_CONTROL                                                                   0x1cc5
#define regOTG3_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define regOTG3_OTG_INTERLACE_STATUS                                                                    0x1cc6
#define regOTG3_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define regOTG3_OTG_PIXEL_DATA_READBACK0                                                                0x1cc7
#define regOTG3_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define regOTG3_OTG_PIXEL_DATA_READBACK1                                                                0x1cc8
#define regOTG3_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define regOTG3_OTG_STATUS                                                                              0x1cc9
#define regOTG3_OTG_STATUS_BASE_IDX                                                                     2
#define regOTG3_OTG_STATUS_POSITION                                                                     0x1cca
#define regOTG3_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define regOTG3_OTG_LONG_VBLANK_STATUS                                                                  0x1ccb
#define regOTG3_OTG_LONG_VBLANK_STATUS_BASE_IDX                                                         2
#define regOTG3_OTG_NOM_VERT_POSITION                                                                   0x1ccc
#define regOTG3_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define regOTG3_OTG_STATUS_FRAME_COUNT                                                                  0x1ccd
#define regOTG3_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define regOTG3_OTG_STATUS_VF_COUNT                                                                     0x1cce
#define regOTG3_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define regOTG3_OTG_STATUS_HV_COUNT                                                                     0x1ccf
#define regOTG3_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define regOTG3_OTG_COUNT_CONTROL                                                                       0x1cd0
#define regOTG3_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define regOTG3_OTG_COUNT_RESET                                                                         0x1cd1
#define regOTG3_OTG_COUNT_RESET_BASE_IDX                                                                2
#define regOTG3_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1cd2
#define regOTG3_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define regOTG3_OTG_VERT_SYNC_CONTROL                                                                   0x1cd3
#define regOTG3_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define regOTG3_OTG_STEREO_STATUS                                                                       0x1cd4
#define regOTG3_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define regOTG3_OTG_STEREO_CONTROL                                                                      0x1cd5
#define regOTG3_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define regOTG3_OTG_SNAPSHOT_STATUS                                                                     0x1cd6
#define regOTG3_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define regOTG3_OTG_SNAPSHOT_CONTROL                                                                    0x1cd7
#define regOTG3_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define regOTG3_OTG_SNAPSHOT_POSITION                                                                   0x1cd8
#define regOTG3_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define regOTG3_OTG_SNAPSHOT_FRAME                                                                      0x1cd9
#define regOTG3_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define regOTG3_OTG_INTERRUPT_CONTROL                                                                   0x1cda
#define regOTG3_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define regOTG3_OTG_UPDATE_LOCK                                                                         0x1cdb
#define regOTG3_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define regOTG3_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1cdc
#define regOTG3_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define regOTG3_OTG_MASTER_EN                                                                           0x1cdd
#define regOTG3_OTG_MASTER_EN_BASE_IDX                                                                  2
#define regOTG3_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1cdf
#define regOTG3_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define regOTG3_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1ce0
#define regOTG3_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define regOTG3_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1ce1
#define regOTG3_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define regOTG3_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1ce2
#define regOTG3_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define regOTG3_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1ce3
#define regOTG3_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define regOTG3_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1ce4
#define regOTG3_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define regOTG3_OTG_CRC_CNTL                                                                            0x1ce5
#define regOTG3_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define regOTG3_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1ce6
#define regOTG3_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define regOTG3_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1ce7
#define regOTG3_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define regOTG3_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1ce8
#define regOTG3_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define regOTG3_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1ce9
#define regOTG3_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define regOTG3_OTG_CRC0_DATA_RG                                                                        0x1cea
#define regOTG3_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define regOTG3_OTG_CRC0_DATA_B                                                                         0x1ceb
#define regOTG3_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define regOTG3_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1cec
#define regOTG3_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define regOTG3_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1ced
#define regOTG3_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define regOTG3_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1cee
#define regOTG3_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define regOTG3_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1cef
#define regOTG3_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define regOTG3_OTG_CRC1_DATA_RG                                                                        0x1cf0
#define regOTG3_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define regOTG3_OTG_CRC1_DATA_B                                                                         0x1cf1
#define regOTG3_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define regOTG3_OTG_CRC2_DATA_RG                                                                        0x1cf2
#define regOTG3_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define regOTG3_OTG_CRC2_DATA_B                                                                         0x1cf3
#define regOTG3_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define regOTG3_OTG_CRC3_DATA_RG                                                                        0x1cf4
#define regOTG3_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define regOTG3_OTG_CRC3_DATA_B                                                                         0x1cf5
#define regOTG3_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define regOTG3_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1cf6
#define regOTG3_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define regOTG3_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1cf7
#define regOTG3_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define regOTG3_OTG_CRC0_WINDOWA_X_CONTROL_READBACK                                                     0x1cf8
#define regOTG3_OTG_CRC0_WINDOWA_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG3_OTG_CRC0_WINDOWA_Y_CONTROL_READBACK                                                     0x1cf9
#define regOTG3_OTG_CRC0_WINDOWA_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG3_OTG_CRC0_WINDOWB_X_CONTROL_READBACK                                                     0x1cfa
#define regOTG3_OTG_CRC0_WINDOWB_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG3_OTG_CRC0_WINDOWB_Y_CONTROL_READBACK                                                     0x1cfb
#define regOTG3_OTG_CRC0_WINDOWB_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG3_OTG_CRC1_WINDOWA_X_CONTROL_READBACK                                                     0x1cfc
#define regOTG3_OTG_CRC1_WINDOWA_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG3_OTG_CRC1_WINDOWA_Y_CONTROL_READBACK                                                     0x1cfd
#define regOTG3_OTG_CRC1_WINDOWA_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG3_OTG_CRC1_WINDOWB_X_CONTROL_READBACK                                                     0x1cfe
#define regOTG3_OTG_CRC1_WINDOWB_X_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG3_OTG_CRC1_WINDOWB_Y_CONTROL_READBACK                                                     0x1cff
#define regOTG3_OTG_CRC1_WINDOWB_Y_CONTROL_READBACK_BASE_IDX                                            2
#define regOTG3_OTG_STATIC_SCREEN_CONTROL                                                               0x1d00
#define regOTG3_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define regOTG3_OTG_3D_STRUCTURE_CONTROL                                                                0x1d01
#define regOTG3_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define regOTG3_OTG_GSL_VSYNC_GAP                                                                       0x1d02
#define regOTG3_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define regOTG3_OTG_MASTER_UPDATE_MODE                                                                  0x1d03
#define regOTG3_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define regOTG3_OTG_CLOCK_CONTROL                                                                       0x1d04
#define regOTG3_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define regOTG3_OTG_VSTARTUP_PARAM                                                                      0x1d05
#define regOTG3_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define regOTG3_OTG_VUPDATE_PARAM                                                                       0x1d06
#define regOTG3_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define regOTG3_OTG_VREADY_PARAM                                                                        0x1d07
#define regOTG3_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define regOTG3_OTG_GLOBAL_SYNC_STATUS                                                                  0x1d08
#define regOTG3_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define regOTG3_OTG_MASTER_UPDATE_LOCK                                                                  0x1d09
#define regOTG3_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define regOTG3_OTG_GSL_CONTROL                                                                         0x1d0a
#define regOTG3_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define regOTG3_OTG_GSL_WINDOW_X                                                                        0x1d0b
#define regOTG3_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define regOTG3_OTG_GSL_WINDOW_Y                                                                        0x1d0c
#define regOTG3_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define regOTG3_OTG_VUPDATE_KEEPOUT                                                                     0x1d0d
#define regOTG3_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define regOTG3_OTG_GLOBAL_CONTROL0                                                                     0x1d0e
#define regOTG3_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define regOTG3_OTG_GLOBAL_CONTROL1                                                                     0x1d0f
#define regOTG3_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define regOTG3_OTG_GLOBAL_CONTROL2                                                                     0x1d10
#define regOTG3_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define regOTG3_OTG_GLOBAL_CONTROL3                                                                     0x1d11
#define regOTG3_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define regOTG3_OTG_GLOBAL_CONTROL4                                                                     0x1d12
#define regOTG3_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define regOTG3_OTG_TRIG_MANUAL_CONTROL                                                                 0x1d13
#define regOTG3_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define regOTG3_OTG_DRR_TIMING_INT_STATUS                                                               0x1d15
#define regOTG3_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define regOTG3_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1d16
#define regOTG3_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define regOTG3_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1d17
#define regOTG3_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define regOTG3_OTG_DRR_TRIGGER_WINDOW                                                                  0x1d18
#define regOTG3_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define regOTG3_OTG_DRR_CONTROL                                                                         0x1d19
#define regOTG3_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define regOTG3_OTG_DRR_CONTOL2                                                                         0x1d1a
#define regOTG3_OTG_DRR_CONTOL2_BASE_IDX                                                                2
#define regOTG3_OTG_M_CONST_DTO0                                                                        0x1d1b
#define regOTG3_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define regOTG3_OTG_M_CONST_DTO1                                                                        0x1d1c
#define regOTG3_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define regOTG3_OTG_REQUEST_CONTROL                                                                     0x1d1d
#define regOTG3_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define regOTG3_OTG_DSC_START_POSITION                                                                  0x1d1e
#define regOTG3_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define regOTG3_OTG_PIPE_UPDATE_STATUS                                                                  0x1d1f
#define regOTG3_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define regOTG3_OTG_SPARE_REGISTER                                                                      0x1d20
#define regOTG3_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_optc_misc_dispdec
// base address: 0x0
#define regGSL_SOURCE_SELECT                                                                            0x1e2b
#define regGSL_SOURCE_SELECT_BASE_IDX                                                                   2
#define regOPTC_DLPC_CONTROL                                                                            0x1e2c
#define regOPTC_DLPC_CONTROL_BASE_IDX                                                                   2
#define regOPTC_CLOCK_CONTROL                                                                           0x1e2d
#define regOPTC_CLOCK_CONTROL_BASE_IDX                                                                  2
#define regODM_MEM_PWR_CTRL                                                                             0x1e2e
#define regODM_MEM_PWR_CTRL_BASE_IDX                                                                    2
#define regODM_MEM_PWR_CTRL3                                                                            0x1e30
#define regODM_MEM_PWR_CTRL3_BASE_IDX                                                                   2
#define regODM_MEM_PWR_STATUS                                                                           0x1e31
#define regODM_MEM_PWR_STATUS_BASE_IDX                                                                  2
#define regOPTC_MISC_SPARE_REGISTER                                                                     0x1e32
#define regOPTC_MISC_SPARE_REGISTER_BASE_IDX                                                            2


// addressBlock: dce_dc_optc_optc_dcperfmon_dc_perfmon_dispdec
// base address: 0x79a8
#define regDC_PERFMON17_PERFCOUNTER_CNTL                                                                0x1e6a
#define regDC_PERFMON17_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define regDC_PERFMON17_PERFCOUNTER_CNTL2                                                               0x1e6b
#define regDC_PERFMON17_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define regDC_PERFMON17_PERFCOUNTER_STATE                                                               0x1e6c
#define regDC_PERFMON17_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define regDC_PERFMON17_PERFMON_CNTL                                                                    0x1e6d
#define regDC_PERFMON17_PERFMON_CNTL_BASE_IDX                                                           2
#define regDC_PERFMON17_PERFMON_CNTL2                                                                   0x1e6e
#define regDC_PERFMON17_PERFMON_CNTL2_BASE_IDX                                                          2
#define regDC_PERFMON17_PERFMON_CVALUE_INT_MISC                                                         0x1e6f
#define regDC_PERFMON17_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define regDC_PERFMON17_PERFMON_CVALUE_LOW                                                              0x1e70
#define regDC_PERFMON17_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define regDC_PERFMON17_PERFMON_HI                                                                      0x1e71
#define regDC_PERFMON17_PERFMON_HI_BASE_IDX                                                             2
#define regDC_PERFMON17_PERFMON_LOW                                                                     0x1e72
#define regDC_PERFMON17_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dio_dout_i2c_dispdec
// base address: 0x0
#define regDC_I2C_CONTROL                                                                               0x1e98
#define regDC_I2C_CONTROL_BASE_IDX                                                                      2
#define regDC_I2C_ARBITRATION                                                                           0x1e99
#define regDC_I2C_ARBITRATION_BASE_IDX                                                                  2
#define regDC_I2C_INTERRUPT_CONTROL                                                                     0x1e9a
#define regDC_I2C_INTERRUPT_CONTROL_BASE_IDX                                                            2
#define regDC_I2C_SW_STATUS                                                                             0x1e9b
#define regDC_I2C_SW_STATUS_BASE_IDX                                                                    2
#define regDC_I2C_DDC1_HW_STATUS                                                                        0x1e9c
#define regDC_I2C_DDC1_HW_STATUS_BASE_IDX                                                               2
#define regDC_I2C_DDC2_HW_STATUS                                                                        0x1e9d
#define regDC_I2C_DDC2_HW_STATUS_BASE_IDX                                                               2
#define regDC_I2C_DDC3_HW_STATUS                                                                        0x1e9e
#define regDC_I2C_DDC3_HW_STATUS_BASE_IDX                                                               2
#define regDC_I2C_DDC4_HW_STATUS                                                                        0x1e9f
#define regDC_I2C_DDC4_HW_STATUS_BASE_IDX                                                               2
#define regDC_I2C_DDC5_HW_STATUS                                                                        0x1ea0
#define regDC_I2C_DDC5_HW_STATUS_BASE_IDX                                                               2
#define regDC_I2C_DDC1_SPEED                                                                            0x1ea2
#define regDC_I2C_DDC1_SPEED_BASE_IDX                                                                   2
#define regDC_I2C_DDC1_SETUP                                                                            0x1ea3
#define regDC_I2C_DDC1_SETUP_BASE_IDX                                                                   2
#define regDC_I2C_DDC2_SPEED                                                                            0x1ea4
#define regDC_I2C_DDC2_SPEED_BASE_IDX                                                                   2
#define regDC_I2C_DDC2_SETUP                                                                            0x1ea5
#define regDC_I2C_DDC2_SETUP_BASE_IDX                                                                   2
#define regDC_I2C_DDC3_SPEED                                                                            0x1ea6
#define regDC_I2C_DDC3_SPEED_BASE_IDX                                                                   2
#define regDC_I2C_DDC3_SETUP                                                                            0x1ea7
#define regDC_I2C_DDC3_SETUP_BASE_IDX                                                                   2
#define regDC_I2C_DDC4_SPEED                                                                            0x1ea8
#define regDC_I2C_DDC4_SPEED_BASE_IDX                                                                   2
#define regDC_I2C_DDC4_SETUP                                                                            0x1ea9
#define regDC_I2C_DDC4_SETUP_BASE_IDX                                                                   2
#define regDC_I2C_DDC5_SPEED                                                                            0x1eaa
#define regDC_I2C_DDC5_SPEED_BASE_IDX                                                                   2
#define regDC_I2C_DDC5_SETUP                                                                            0x1eab
#define regDC_I2C_DDC5_SETUP_BASE_IDX                                                                   2
#define regDC_I2C_TRANSACTION0                                                                          0x1eae
#define regDC_I2C_TRANSACTION0_BASE_IDX                                                                 2
#define regDC_I2C_TRANSACTION1                                                                          0x1eaf
#define regDC_I2C_TRANSACTION1_BASE_IDX                                                                 2
#define regDC_I2C_TRANSACTION2                                                                          0x1eb0
#define regDC_I2C_TRANSACTION2_BASE_IDX                                                                 2
#define regDC_I2C_TRANSACTION3                                                                          0x1eb1
#define regDC_I2C_TRANSACTION3_BASE_IDX                                                                 2
#define regDC_I2C_DATA                                                                                  0x1eb2
#define regDC_I2C_DATA_BASE_IDX                                                                         2
#define regDC_I2C_EDID_DETECT_CTRL                                                                      0x1eb6
#define regDC_I2C_EDID_DETECT_CTRL_BASE_IDX                                                             2
#define regDC_I2C_READ_REQUEST_INTERRUPT                                                                0x1eb7
#define regDC_I2C_READ_REQUEST_INTERRUPT_BASE_IDX                                                       2


// addressBlock: dce_dc_dio_dio_misc_dispdec
// base address: 0x0
#define regDIO_DCN_STATUS                                                                               0x1ec3
#define regDIO_DCN_STATUS_BASE_IDX                                                                      2
#define regDIO_SCRATCH0                                                                                 0x1eca
#define regDIO_SCRATCH0_BASE_IDX                                                                        2
#define regDIO_SCRATCH1                                                                                 0x1ecb
#define regDIO_SCRATCH1_BASE_IDX                                                                        2
#define regDIO_SCRATCH2                                                                                 0x1ecc
#define regDIO_SCRATCH2_BASE_IDX                                                                        2
#define regDIO_SCRATCH3                                                                                 0x1ecd
#define regDIO_SCRATCH3_BASE_IDX                                                                        2
#define regDIO_SCRATCH4                                                                                 0x1ece
#define regDIO_SCRATCH4_BASE_IDX                                                                        2
#define regDIO_SCRATCH5                                                                                 0x1ecf
#define regDIO_SCRATCH5_BASE_IDX                                                                        2
#define regDIO_SCRATCH6                                                                                 0x1ed0
#define regDIO_SCRATCH6_BASE_IDX                                                                        2
#define regDIO_SCRATCH7                                                                                 0x1ed1
#define regDIO_SCRATCH7_BASE_IDX                                                                        2
#define regDIO_DP_ALPM_WAKEUP_INTERRUPT_STATUS                                                          0x1ed3
#define regDIO_DP_ALPM_WAKEUP_INTERRUPT_STATUS_BASE_IDX                                                 2
#define regDIO_MEM_PWR_STATUS                                                                           0x1edd
#define regDIO_MEM_PWR_STATUS_BASE_IDX                                                                  2
#define regDIO_MEM_PWR_CTRL                                                                             0x1ede
#define regDIO_MEM_PWR_CTRL_BASE_IDX                                                                    2
#define regDIO_MEM_PWR_CTRL2                                                                            0x1edf
#define regDIO_MEM_PWR_CTRL2_BASE_IDX                                                                   2
#define regDIO_CLK_CNTL                                                                                 0x1ee0
#define regDIO_CLK_CNTL_BASE_IDX                                                                        2
#define regDIO_POWER_MANAGEMENT_CNTL                                                                    0x1ee4
#define regDIO_POWER_MANAGEMENT_CNTL_BASE_IDX                                                           2
#define regDIO_HDMI_RXSTATUS_TIMER_CONTROL                                                              0x1eff
#define regDIO_HDMI_RXSTATUS_TIMER_CONTROL_BASE_IDX                                                     2
#define regDIO_PSP_INTERRUPT_STATUS                                                                     0x1f00
#define regDIO_PSP_INTERRUPT_STATUS_BASE_IDX                                                            2
#define regDIO_PSP_INTERRUPT_CLEAR                                                                      0x1f01
#define regDIO_PSP_INTERRUPT_CLEAR_BASE_IDX                                                             2
#define regDIO_STATUS                                                                                   0x1f02
#define regDIO_STATUS_BASE_IDX                                                                          2
#define regDIO_LINKA_CNTL                                                                               0x1f04
#define regDIO_LINKA_CNTL_BASE_IDX                                                                      2
#define regDIO_LINKB_CNTL                                                                               0x1f05
#define regDIO_LINKB_CNTL_BASE_IDX                                                                      2
#define regDIO_LINKC_CNTL                                                                               0x1f06
#define regDIO_LINKC_CNTL_BASE_IDX                                                                      2
#define regDIO_LINKD_CNTL                                                                               0x1f07
#define regDIO_LINKD_CNTL_BASE_IDX                                                                      2
#define regDIO_LINKE_CNTL                                                                               0x1f08
#define regDIO_LINKE_CNTL_BASE_IDX                                                                      2
#define regDIO_LINKF_CNTL                                                                               0x1f09
#define regDIO_LINKF_CNTL_BASE_IDX                                                                      2


// addressBlock: dce_dc_dio_hpd0_dispdec
// base address: 0x0
#define regHPD0_DC_HPD_INT_STATUS                                                                       0x1f14
#define regHPD0_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define regHPD0_DC_HPD_INT_CONTROL                                                                      0x1f15
#define regHPD0_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define regHPD0_DC_HPD_CONTROL                                                                          0x1f16
#define regHPD0_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define regHPD0_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f17
#define regHPD0_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define regHPD0_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f18
#define regHPD0_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_hpd1_dispdec
// base address: 0x20
#define regHPD1_DC_HPD_INT_STATUS                                                                       0x1f1c
#define regHPD1_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define regHPD1_DC_HPD_INT_CONTROL                                                                      0x1f1d
#define regHPD1_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define regHPD1_DC_HPD_CONTROL                                                                          0x1f1e
#define regHPD1_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define regHPD1_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f1f
#define regHPD1_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define regHPD1_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f20
#define regHPD1_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_hpd2_dispdec
// base address: 0x40
#define regHPD2_DC_HPD_INT_STATUS                                                                       0x1f24
#define regHPD2_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define regHPD2_DC_HPD_INT_CONTROL                                                                      0x1f25
#define regHPD2_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define regHPD2_DC_HPD_CONTROL                                                                          0x1f26
#define regHPD2_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define regHPD2_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f27
#define regHPD2_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define regHPD2_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f28
#define regHPD2_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_hpd3_dispdec
// base address: 0x60
#define regHPD3_DC_HPD_INT_STATUS                                                                       0x1f2c
#define regHPD3_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define regHPD3_DC_HPD_INT_CONTROL                                                                      0x1f2d
#define regHPD3_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define regHPD3_DC_HPD_CONTROL                                                                          0x1f2e
#define regHPD3_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define regHPD3_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f2f
#define regHPD3_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define regHPD3_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f30
#define regHPD3_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_hpd4_dispdec
// base address: 0x80
#define regHPD4_DC_HPD_INT_STATUS                                                                       0x1f34
#define regHPD4_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define regHPD4_DC_HPD_INT_CONTROL                                                                      0x1f35
#define regHPD4_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define regHPD4_DC_HPD_CONTROL                                                                          0x1f36
#define regHPD4_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define regHPD4_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f37
#define regHPD4_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define regHPD4_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f38
#define regHPD4_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_dio_dcperfmon_dc_perfmon_dispdec
// base address: 0x7d10
#define regDC_PERFMON18_PERFCOUNTER_CNTL                                                                0x1f44
#define regDC_PERFMON18_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define regDC_PERFMON18_PERFCOUNTER_CNTL2                                                               0x1f45
#define regDC_PERFMON18_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define regDC_PERFMON18_PERFCOUNTER_STATE                                                               0x1f46
#define regDC_PERFMON18_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define regDC_PERFMON18_PERFMON_CNTL                                                                    0x1f47
#define regDC_PERFMON18_PERFMON_CNTL_BASE_IDX                                                           2
#define regDC_PERFMON18_PERFMON_CNTL2                                                                   0x1f48
#define regDC_PERFMON18_PERFMON_CNTL2_BASE_IDX                                                          2
#define regDC_PERFMON18_PERFMON_CVALUE_INT_MISC                                                         0x1f49
#define regDC_PERFMON18_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define regDC_PERFMON18_PERFMON_CVALUE_LOW                                                              0x1f4a
#define regDC_PERFMON18_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define regDC_PERFMON18_PERFMON_HI                                                                      0x1f4b
#define regDC_PERFMON18_PERFMON_HI_BASE_IDX                                                             2
#define regDC_PERFMON18_PERFMON_LOW                                                                     0x1f4c
#define regDC_PERFMON18_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dio_dp_aux0_dispdec
// base address: 0x0
#define regDP_AUX0_AUX_CONTROL                                                                          0x1f50
#define regDP_AUX0_AUX_CONTROL_BASE_IDX                                                                 2
#define regDP_AUX0_AUX_SW_CONTROL                                                                       0x1f51
#define regDP_AUX0_AUX_SW_CONTROL_BASE_IDX                                                              2
#define regDP_AUX0_AUX_ARB_CONTROL                                                                      0x1f52
#define regDP_AUX0_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define regDP_AUX0_AUX_INTERRUPT_CONTROL                                                                0x1f53
#define regDP_AUX0_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define regDP_AUX0_AUX_SW_STATUS                                                                        0x1f54
#define regDP_AUX0_AUX_SW_STATUS_BASE_IDX                                                               2
#define regDP_AUX0_AUX_LS_STATUS                                                                        0x1f55
#define regDP_AUX0_AUX_LS_STATUS_BASE_IDX                                                               2
#define regDP_AUX0_AUX_SW_DATA                                                                          0x1f56
#define regDP_AUX0_AUX_SW_DATA_BASE_IDX                                                                 2
#define regDP_AUX0_AUX_LS_DATA                                                                          0x1f57
#define regDP_AUX0_AUX_LS_DATA_BASE_IDX                                                                 2
#define regDP_AUX0_AUX_DPHY_TX_REF_CONTROL                                                              0x1f58
#define regDP_AUX0_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define regDP_AUX0_AUX_DPHY_TX_CONTROL                                                                  0x1f59
#define regDP_AUX0_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define regDP_AUX0_AUX_DPHY_RX_CONTROL0                                                                 0x1f5a
#define regDP_AUX0_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define regDP_AUX0_AUX_DPHY_RX_CONTROL1                                                                 0x1f5b
#define regDP_AUX0_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define regDP_AUX0_AUX_DPHY_TX_STATUS                                                                   0x1f5c
#define regDP_AUX0_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define regDP_AUX0_AUX_DPHY_RX_STATUS                                                                   0x1f5d
#define regDP_AUX0_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define regDP_AUX0_AUX_GTC_SYNC_CONTROL                                                                 0x1f5e
#define regDP_AUX0_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define regDP_AUX0_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1f5f
#define regDP_AUX0_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define regDP_AUX0_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1f60
#define regDP_AUX0_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define regDP_AUX0_AUX_GTC_SYNC_STATUS                                                                  0x1f61
#define regDP_AUX0_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define regDP_AUX0_AUX_PHY_WAKE_CNTL                                                                    0x1f66
#define regDP_AUX0_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dp_aux1_dispdec
// base address: 0x70
#define regDP_AUX1_AUX_CONTROL                                                                          0x1f6c
#define regDP_AUX1_AUX_CONTROL_BASE_IDX                                                                 2
#define regDP_AUX1_AUX_SW_CONTROL                                                                       0x1f6d
#define regDP_AUX1_AUX_SW_CONTROL_BASE_IDX                                                              2
#define regDP_AUX1_AUX_ARB_CONTROL                                                                      0x1f6e
#define regDP_AUX1_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define regDP_AUX1_AUX_INTERRUPT_CONTROL                                                                0x1f6f
#define regDP_AUX1_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define regDP_AUX1_AUX_SW_STATUS                                                                        0x1f70
#define regDP_AUX1_AUX_SW_STATUS_BASE_IDX                                                               2
#define regDP_AUX1_AUX_LS_STATUS                                                                        0x1f71
#define regDP_AUX1_AUX_LS_STATUS_BASE_IDX                                                               2
#define regDP_AUX1_AUX_SW_DATA                                                                          0x1f72
#define regDP_AUX1_AUX_SW_DATA_BASE_IDX                                                                 2
#define regDP_AUX1_AUX_LS_DATA                                                                          0x1f73
#define regDP_AUX1_AUX_LS_DATA_BASE_IDX                                                                 2
#define regDP_AUX1_AUX_DPHY_TX_REF_CONTROL                                                              0x1f74
#define regDP_AUX1_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define regDP_AUX1_AUX_DPHY_TX_CONTROL                                                                  0x1f75
#define regDP_AUX1_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define regDP_AUX1_AUX_DPHY_RX_CONTROL0                                                                 0x1f76
#define regDP_AUX1_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define regDP_AUX1_AUX_DPHY_RX_CONTROL1                                                                 0x1f77
#define regDP_AUX1_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define regDP_AUX1_AUX_DPHY_TX_STATUS                                                                   0x1f78
#define regDP_AUX1_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define regDP_AUX1_AUX_DPHY_RX_STATUS                                                                   0x1f79
#define regDP_AUX1_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define regDP_AUX1_AUX_GTC_SYNC_CONTROL                                                                 0x1f7a
#define regDP_AUX1_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define regDP_AUX1_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1f7b
#define regDP_AUX1_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define regDP_AUX1_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1f7c
#define regDP_AUX1_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define regDP_AUX1_AUX_GTC_SYNC_STATUS                                                                  0x1f7d
#define regDP_AUX1_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define regDP_AUX1_AUX_PHY_WAKE_CNTL                                                                    0x1f82
#define regDP_AUX1_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dp_aux2_dispdec
// base address: 0xe0
#define regDP_AUX2_AUX_CONTROL                                                                          0x1f88
#define regDP_AUX2_AUX_CONTROL_BASE_IDX                                                                 2
#define regDP_AUX2_AUX_SW_CONTROL                                                                       0x1f89
#define regDP_AUX2_AUX_SW_CONTROL_BASE_IDX                                                              2
#define regDP_AUX2_AUX_ARB_CONTROL                                                                      0x1f8a
#define regDP_AUX2_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define regDP_AUX2_AUX_INTERRUPT_CONTROL                                                                0x1f8b
#define regDP_AUX2_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define regDP_AUX2_AUX_SW_STATUS                                                                        0x1f8c
#define regDP_AUX2_AUX_SW_STATUS_BASE_IDX                                                               2
#define regDP_AUX2_AUX_LS_STATUS                                                                        0x1f8d
#define regDP_AUX2_AUX_LS_STATUS_BASE_IDX                                                               2
#define regDP_AUX2_AUX_SW_DATA                                                                          0x1f8e
#define regDP_AUX2_AUX_SW_DATA_BASE_IDX                                                                 2
#define regDP_AUX2_AUX_LS_DATA                                                                          0x1f8f
#define regDP_AUX2_AUX_LS_DATA_BASE_IDX                                                                 2
#define regDP_AUX2_AUX_DPHY_TX_REF_CONTROL                                                              0x1f90
#define regDP_AUX2_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define regDP_AUX2_AUX_DPHY_TX_CONTROL                                                                  0x1f91
#define regDP_AUX2_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define regDP_AUX2_AUX_DPHY_RX_CONTROL0                                                                 0x1f92
#define regDP_AUX2_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define regDP_AUX2_AUX_DPHY_RX_CONTROL1                                                                 0x1f93
#define regDP_AUX2_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define regDP_AUX2_AUX_DPHY_TX_STATUS                                                                   0x1f94
#define regDP_AUX2_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define regDP_AUX2_AUX_DPHY_RX_STATUS                                                                   0x1f95
#define regDP_AUX2_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define regDP_AUX2_AUX_GTC_SYNC_CONTROL                                                                 0x1f96
#define regDP_AUX2_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define regDP_AUX2_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1f97
#define regDP_AUX2_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define regDP_AUX2_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1f98
#define regDP_AUX2_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define regDP_AUX2_AUX_GTC_SYNC_STATUS                                                                  0x1f99
#define regDP_AUX2_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define regDP_AUX2_AUX_PHY_WAKE_CNTL                                                                    0x1f9e
#define regDP_AUX2_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dp_aux3_dispdec
// base address: 0x150
#define regDP_AUX3_AUX_CONTROL                                                                          0x1fa4
#define regDP_AUX3_AUX_CONTROL_BASE_IDX                                                                 2
#define regDP_AUX3_AUX_SW_CONTROL                                                                       0x1fa5
#define regDP_AUX3_AUX_SW_CONTROL_BASE_IDX                                                              2
#define regDP_AUX3_AUX_ARB_CONTROL                                                                      0x1fa6
#define regDP_AUX3_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define regDP_AUX3_AUX_INTERRUPT_CONTROL                                                                0x1fa7
#define regDP_AUX3_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define regDP_AUX3_AUX_SW_STATUS                                                                        0x1fa8
#define regDP_AUX3_AUX_SW_STATUS_BASE_IDX                                                               2
#define regDP_AUX3_AUX_LS_STATUS                                                                        0x1fa9
#define regDP_AUX3_AUX_LS_STATUS_BASE_IDX                                                               2
#define regDP_AUX3_AUX_SW_DATA                                                                          0x1faa
#define regDP_AUX3_AUX_SW_DATA_BASE_IDX                                                                 2
#define regDP_AUX3_AUX_LS_DATA                                                                          0x1fab
#define regDP_AUX3_AUX_LS_DATA_BASE_IDX                                                                 2
#define regDP_AUX3_AUX_DPHY_TX_REF_CONTROL                                                              0x1fac
#define regDP_AUX3_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define regDP_AUX3_AUX_DPHY_TX_CONTROL                                                                  0x1fad
#define regDP_AUX3_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define regDP_AUX3_AUX_DPHY_RX_CONTROL0                                                                 0x1fae
#define regDP_AUX3_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define regDP_AUX3_AUX_DPHY_RX_CONTROL1                                                                 0x1faf
#define regDP_AUX3_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define regDP_AUX3_AUX_DPHY_TX_STATUS                                                                   0x1fb0
#define regDP_AUX3_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define regDP_AUX3_AUX_DPHY_RX_STATUS                                                                   0x1fb1
#define regDP_AUX3_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define regDP_AUX3_AUX_GTC_SYNC_CONTROL                                                                 0x1fb2
#define regDP_AUX3_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define regDP_AUX3_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1fb3
#define regDP_AUX3_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define regDP_AUX3_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1fb4
#define regDP_AUX3_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define regDP_AUX3_AUX_GTC_SYNC_STATUS                                                                  0x1fb5
#define regDP_AUX3_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define regDP_AUX3_AUX_PHY_WAKE_CNTL                                                                    0x1fba
#define regDP_AUX3_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dp_aux4_dispdec
// base address: 0x1c0
#define regDP_AUX4_AUX_CONTROL                                                                          0x1fc0
#define regDP_AUX4_AUX_CONTROL_BASE_IDX                                                                 2
#define regDP_AUX4_AUX_SW_CONTROL                                                                       0x1fc1
#define regDP_AUX4_AUX_SW_CONTROL_BASE_IDX                                                              2
#define regDP_AUX4_AUX_ARB_CONTROL                                                                      0x1fc2
#define regDP_AUX4_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define regDP_AUX4_AUX_INTERRUPT_CONTROL                                                                0x1fc3
#define regDP_AUX4_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define regDP_AUX4_AUX_SW_STATUS                                                                        0x1fc4
#define regDP_AUX4_AUX_SW_STATUS_BASE_IDX                                                               2
#define regDP_AUX4_AUX_LS_STATUS                                                                        0x1fc5
#define regDP_AUX4_AUX_LS_STATUS_BASE_IDX                                                               2
#define regDP_AUX4_AUX_SW_DATA                                                                          0x1fc6
#define regDP_AUX4_AUX_SW_DATA_BASE_IDX                                                                 2
#define regDP_AUX4_AUX_LS_DATA                                                                          0x1fc7
#define regDP_AUX4_AUX_LS_DATA_BASE_IDX                                                                 2
#define regDP_AUX4_AUX_DPHY_TX_REF_CONTROL                                                              0x1fc8
#define regDP_AUX4_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define regDP_AUX4_AUX_DPHY_TX_CONTROL                                                                  0x1fc9
#define regDP_AUX4_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define regDP_AUX4_AUX_DPHY_RX_CONTROL0                                                                 0x1fca
#define regDP_AUX4_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define regDP_AUX4_AUX_DPHY_RX_CONTROL1                                                                 0x1fcb
#define regDP_AUX4_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define regDP_AUX4_AUX_DPHY_TX_STATUS                                                                   0x1fcc
#define regDP_AUX4_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define regDP_AUX4_AUX_DPHY_RX_STATUS                                                                   0x1fcd
#define regDP_AUX4_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define regDP_AUX4_AUX_GTC_SYNC_CONTROL                                                                 0x1fce
#define regDP_AUX4_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define regDP_AUX4_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1fcf
#define regDP_AUX4_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define regDP_AUX4_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1fd0
#define regDP_AUX4_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define regDP_AUX4_AUX_GTC_SYNC_STATUS                                                                  0x1fd1
#define regDP_AUX4_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define regDP_AUX4_AUX_PHY_WAKE_CNTL                                                                    0x1fd6
#define regDP_AUX4_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dig0_vpg_vpg_dispdec
// base address: 0x154a0
#define regVPG0_VPG_GENERIC_PACKET_ACCESS_CTRL                                                          0x2068
#define regVPG0_VPG_GENERIC_PACKET_ACCESS_CTRL_BASE_IDX                                                 2
#define regVPG0_VPG_GENERIC_PACKET_DATA                                                                 0x2069
#define regVPG0_VPG_GENERIC_PACKET_DATA_BASE_IDX                                                        2
#define regVPG0_VPG_GSP_FRAME_UPDATE_CTRL                                                               0x206a
#define regVPG0_VPG_GSP_FRAME_UPDATE_CTRL_BASE_IDX                                                      2
#define regVPG0_VPG_GSP_IMMEDIATE_UPDATE_CTRL                                                           0x206b
#define regVPG0_VPG_GSP_IMMEDIATE_UPDATE_CTRL_BASE_IDX                                                  2
#define regVPG0_VPG_GENERIC_STATUS                                                                      0x206c
#define regVPG0_VPG_GENERIC_STATUS_BASE_IDX                                                             2
#define regVPG0_VPG_MEM_PWR                                                                             0x206d
#define regVPG0_VPG_MEM_PWR_BASE_IDX                                                                    2
#define regVPG0_VPG_ISRC1_2_ACCESS_CTRL                                                                 0x206e
#define regVPG0_VPG_ISRC1_2_ACCESS_CTRL_BASE_IDX                                                        2
#define regVPG0_VPG_ISRC1_2_DATA                                                                        0x206f
#define regVPG0_VPG_ISRC1_2_DATA_BASE_IDX                                                               2
#define regVPG0_VPG_MPEG_INFO0                                                                          0x2070
#define regVPG0_VPG_MPEG_INFO0_BASE_IDX                                                                 2
#define regVPG0_VPG_MPEG_INFO1                                                                          0x2071
#define regVPG0_VPG_MPEG_INFO1_BASE_IDX                                                                 2


// addressBlock: dce_dc_dio_dig0_afmt_afmt_dispdec
// base address: 0x154cc
#define regAFMT0_AFMT_ACP                                                                               0x2073
#define regAFMT0_AFMT_ACP_BASE_IDX                                                                      2
#define regAFMT0_AFMT_VBI_PACKET_CONTROL                                                                0x2074
#define regAFMT0_AFMT_VBI_PACKET_CONTROL_BASE_IDX                                                       2
#define regAFMT0_AFMT_AUDIO_PACKET_CONTROL2                                                             0x2075
#define regAFMT0_AFMT_AUDIO_PACKET_CONTROL2_BASE_IDX                                                    2
#define regAFMT0_AFMT_AUDIO_INFO0                                                                       0x2076
#define regAFMT0_AFMT_AUDIO_INFO0_BASE_IDX                                                              2
#define regAFMT0_AFMT_AUDIO_INFO1                                                                       0x2077
#define regAFMT0_AFMT_AUDIO_INFO1_BASE_IDX                                                              2
#define regAFMT0_AFMT_60958_0                                                                           0x2078
#define regAFMT0_AFMT_60958_0_BASE_IDX                                                                  2
#define regAFMT0_AFMT_60958_1                                                                           0x2079
#define regAFMT0_AFMT_60958_1_BASE_IDX                                                                  2
#define regAFMT0_AFMT_AUDIO_CRC_CONTROL                                                                 0x207a
#define regAFMT0_AFMT_AUDIO_CRC_CONTROL_BASE_IDX                                                        2
#define regAFMT0_AFMT_RAMP_CONTROL0                                                                     0x207b
#define regAFMT0_AFMT_RAMP_CONTROL0_BASE_IDX                                                            2
#define regAFMT0_AFMT_RAMP_CONTROL1                                                                     0x207c
#define regAFMT0_AFMT_RAMP_CONTROL1_BASE_IDX                                                            2
#define regAFMT0_AFMT_RAMP_CONTROL2                                                                     0x207d
#define regAFMT0_AFMT_RAMP_CONTROL2_BASE_IDX                                                            2
#define regAFMT0_AFMT_RAMP_CONTROL3                                                                     0x207e
#define regAFMT0_AFMT_RAMP_CONTROL3_BASE_IDX                                                            2
#define regAFMT0_AFMT_60958_2                                                                           0x207f
#define regAFMT0_AFMT_60958_2_BASE_IDX                                                                  2
#define regAFMT0_AFMT_AUDIO_CRC_RESULT                                                                  0x2080
#define regAFMT0_AFMT_AUDIO_CRC_RESULT_BASE_IDX                                                         2
#define regAFMT0_AFMT_STATUS                                                                            0x2081
#define regAFMT0_AFMT_STATUS_BASE_IDX                                                                   2
#define regAFMT0_AFMT_AUDIO_PACKET_CONTROL                                                              0x2082
#define regAFMT0_AFMT_AUDIO_PACKET_CONTROL_BASE_IDX                                                     2
#define regAFMT0_AFMT_INFOFRAME_CONTROL0                                                                0x2083
#define regAFMT0_AFMT_INFOFRAME_CONTROL0_BASE_IDX                                                       2
#define regAFMT0_AFMT_INTERRUPT_STATUS                                                                  0x2084
#define regAFMT0_AFMT_INTERRUPT_STATUS_BASE_IDX                                                         2
#define regAFMT0_AFMT_AUDIO_SRC_CONTROL                                                                 0x2085
#define regAFMT0_AFMT_AUDIO_SRC_CONTROL_BASE_IDX                                                        2
#define regAFMT0_AFMT_MEM_PWR                                                                           0x2087
#define regAFMT0_AFMT_MEM_PWR_BASE_IDX                                                                  2


// addressBlock: dce_dc_dio_dig0_dme_dme_dispdec
// base address: 0x15544
#define regDME0_DME_CONTROL                                                                             0x2091
#define regDME0_DME_CONTROL_BASE_IDX                                                                    2
#define regDME0_DME_MEMORY_CONTROL                                                                      0x2092
#define regDME0_DME_MEMORY_CONTROL_BASE_IDX                                                             2



// addressBlock: dce_dc_dio_dig0_dispdec
// base address: 0x0
#define regDIG0_DIG_FE_CNTL                                                                             0x2093
#define regDIG0_DIG_FE_CNTL_BASE_IDX                                                                    2
#define regDIG0_DIG_FE_CLK_CNTL                                                                         0x2094
#define regDIG0_DIG_FE_CLK_CNTL_BASE_IDX                                                                2
#define regDIG0_DIG_FE_EN_CNTL                                                                          0x2095
#define regDIG0_DIG_FE_EN_CNTL_BASE_IDX                                                                 2
#define regDIG0_DIG_OUTPUT_CRC_CNTL                                                                     0x2096
#define regDIG0_DIG_OUTPUT_CRC_CNTL_BASE_IDX                                                            2
#define regDIG0_DIG_OUTPUT_CRC_RESULT                                                                   0x2097
#define regDIG0_DIG_OUTPUT_CRC_RESULT_BASE_IDX                                                          2
#define regDIG0_DIG_CLOCK_PATTERN                                                                       0x2098
#define regDIG0_DIG_CLOCK_PATTERN_BASE_IDX                                                              2
#define regDIG0_DIG_TEST_PATTERN                                                                        0x2099
#define regDIG0_DIG_TEST_PATTERN_BASE_IDX                                                               2
#define regDIG0_DIG_RANDOM_PATTERN_SEED                                                                 0x209a
#define regDIG0_DIG_RANDOM_PATTERN_SEED_BASE_IDX                                                        2
#define regDIG0_DIG_FIFO_CTRL0                                                                          0x209b
#define regDIG0_DIG_FIFO_CTRL0_BASE_IDX                                                                 2
#define regDIG0_DIG_FIFO_CTRL1                                                                          0x209c
#define regDIG0_DIG_FIFO_CTRL1_BASE_IDX                                                                 2
#define regDIG0_HDMI_METADATA_PACKET_CONTROL                                                            0x209d
#define regDIG0_HDMI_METADATA_PACKET_CONTROL_BASE_IDX                                                   2
#define regDIG0_HDMI_CONTROL                                                                            0x209e
#define regDIG0_HDMI_CONTROL_BASE_IDX                                                                   2
#define regDIG0_HDMI_STATUS                                                                             0x209f
#define regDIG0_HDMI_STATUS_BASE_IDX                                                                    2
#define regDIG0_HDMI_AUDIO_PACKET_CONTROL                                                               0x20a0
#define regDIG0_HDMI_AUDIO_PACKET_CONTROL_BASE_IDX                                                      2
#define regDIG0_HDMI_ACR_PACKET_CONTROL                                                                 0x20a1
#define regDIG0_HDMI_ACR_PACKET_CONTROL_BASE_IDX                                                        2
#define regDIG0_HDMI_VBI_PACKET_CONTROL                                                                 0x20a2
#define regDIG0_HDMI_VBI_PACKET_CONTROL_BASE_IDX                                                        2
#define regDIG0_HDMI_INFOFRAME_CONTROL0                                                                 0x20a3
#define regDIG0_HDMI_INFOFRAME_CONTROL0_BASE_IDX                                                        2
#define regDIG0_HDMI_INFOFRAME_CONTROL1                                                                 0x20a4
#define regDIG0_HDMI_INFOFRAME_CONTROL1_BASE_IDX                                                        2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL0                                                            0x20a5
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL0_BASE_IDX                                                   2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL6                                                            0x20a6
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL6_BASE_IDX                                                   2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL5                                                            0x20a7
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL5_BASE_IDX                                                   2
#define regDIG0_HDMI_GC                                                                                 0x20a8
#define regDIG0_HDMI_GC_BASE_IDX                                                                        2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL1                                                            0x20a9
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL1_BASE_IDX                                                   2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL2                                                            0x20aa
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL2_BASE_IDX                                                   2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL3                                                            0x20ab
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL3_BASE_IDX                                                   2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL4                                                            0x20ac
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL4_BASE_IDX                                                   2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL7                                                            0x20ad
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL7_BASE_IDX                                                   2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL8                                                            0x20ae
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL8_BASE_IDX                                                   2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL9                                                            0x20af
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL9_BASE_IDX                                                   2
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL10                                                           0x20b0
#define regDIG0_HDMI_GENERIC_PACKET_CONTROL10_BASE_IDX                                                  2
#define regDIG0_HDMI_DB_CONTROL                                                                         0x20b1
#define regDIG0_HDMI_DB_CONTROL_BASE_IDX                                                                2
#define regDIG0_HDMI_ACR_32_0                                                                           0x20b2
#define regDIG0_HDMI_ACR_32_0_BASE_IDX                                                                  2
#define regDIG0_HDMI_ACR_32_1                                                                           0x20b3
#define regDIG0_HDMI_ACR_32_1_BASE_IDX                                                                  2
#define regDIG0_HDMI_ACR_44_0                                                                           0x20b4
#define regDIG0_HDMI_ACR_44_0_BASE_IDX                                                                  2
#define regDIG0_HDMI_ACR_44_1                                                                           0x20b5
#define regDIG0_HDMI_ACR_44_1_BASE_IDX                                                                  2
#define regDIG0_HDMI_ACR_48_0                                                                           0x20b6
#define regDIG0_HDMI_ACR_48_0_BASE_IDX                                                                  2
#define regDIG0_HDMI_ACR_48_1                                                                           0x20b7
#define regDIG0_HDMI_ACR_48_1_BASE_IDX                                                                  2
#define regDIG0_HDMI_ACR_STATUS_0                                                                       0x20b8
#define regDIG0_HDMI_ACR_STATUS_0_BASE_IDX                                                              2
#define regDIG0_HDMI_ACR_STATUS_1                                                                       0x20b9
#define regDIG0_HDMI_ACR_STATUS_1_BASE_IDX                                                              2
#define regDIG0_AFMT_CNTL                                                                               0x20ba
#define regDIG0_AFMT_CNTL_BASE_IDX                                                                      2
#define regDIG0_DIG_BE_CLK_CNTL                                                                         0x20bb
#define regDIG0_DIG_BE_CLK_CNTL_BASE_IDX                                                                2
#define regDIG0_DIG_BE_CNTL                                                                             0x20bc
#define regDIG0_DIG_BE_CNTL_BASE_IDX                                                                    2
#define regDIG0_DIG_BE_EN_CNTL                                                                          0x20bd
#define regDIG0_DIG_BE_EN_CNTL_BASE_IDX                                                                 2
#define regDIG0_TMDS_CNTL                                                                               0x20e4
#define regDIG0_TMDS_CNTL_BASE_IDX                                                                      2
#define regDIG0_TMDS_CONTROL_CHAR                                                                       0x20e5
#define regDIG0_TMDS_CONTROL_CHAR_BASE_IDX                                                              2
#define regDIG0_TMDS_CONTROL0_FEEDBACK                                                                  0x20e6
#define regDIG0_TMDS_CONTROL0_FEEDBACK_BASE_IDX                                                         2
#define regDIG0_TMDS_STEREOSYNC_CTL_SEL                                                                 0x20e7
#define regDIG0_TMDS_STEREOSYNC_CTL_SEL_BASE_IDX                                                        2
#define regDIG0_TMDS_SYNC_CHAR_PATTERN_0_1                                                              0x20e8
#define regDIG0_TMDS_SYNC_CHAR_PATTERN_0_1_BASE_IDX                                                     2
#define regDIG0_TMDS_SYNC_CHAR_PATTERN_2_3                                                              0x20e9
#define regDIG0_TMDS_SYNC_CHAR_PATTERN_2_3_BASE_IDX                                                     2
#define regDIG0_TMDS_CTL_BITS                                                                           0x20eb
#define regDIG0_TMDS_CTL_BITS_BASE_IDX                                                                  2
#define regDIG0_TMDS_DCBALANCER_CONTROL                                                                 0x20ec
#define regDIG0_TMDS_DCBALANCER_CONTROL_BASE_IDX                                                        2
#define regDIG0_TMDS_SYNC_DCBALANCE_CHAR                                                                0x20ed
#define regDIG0_TMDS_SYNC_DCBALANCE_CHAR_BASE_IDX                                                       2
#define regDIG0_TMDS_CTL0_1_GEN_CNTL                                                                    0x20ee
#define regDIG0_TMDS_CTL0_1_GEN_CNTL_BASE_IDX                                                           2
#define regDIG0_TMDS_CTL2_3_GEN_CNTL                                                                    0x20ef
#define regDIG0_TMDS_CTL2_3_GEN_CNTL_BASE_IDX                                                           2
#define regDIG0_DIG_VERSION                                                                             0x20f1
#define regDIG0_DIG_VERSION_BASE_IDX                                                                    2


// addressBlock: dce_dc_dio_dp0_dispdec
// base address: 0x0
#define regDP0_DP_LINK_CNTL                                                                             0x211e
#define regDP0_DP_LINK_CNTL_BASE_IDX                                                                    2
#define regDP0_DP_PIXEL_FORMAT                                                                          0x211f
#define regDP0_DP_PIXEL_FORMAT_BASE_IDX                                                                 2
#define regDP0_DP_MSA_COLORIMETRY                                                                       0x2120
#define regDP0_DP_MSA_COLORIMETRY_BASE_IDX                                                              2
#define regDP0_DP_CONFIG                                                                                0x2121
#define regDP0_DP_CONFIG_BASE_IDX                                                                       2
#define regDP0_DP_VID_STREAM_CNTL                                                                       0x2122
#define regDP0_DP_VID_STREAM_CNTL_BASE_IDX                                                              2
#define regDP0_DP_STEER_FIFO                                                                            0x2123
#define regDP0_DP_STEER_FIFO_BASE_IDX                                                                   2
#define regDP0_DP_MSA_MISC                                                                              0x2124
#define regDP0_DP_MSA_MISC_BASE_IDX                                                                     2
#define regDP0_DP_DPHY_INTERNAL_CTRL                                                                    0x2125
#define regDP0_DP_DPHY_INTERNAL_CTRL_BASE_IDX                                                           2
#define regDP0_DP_VID_TIMING                                                                            0x2126
#define regDP0_DP_VID_TIMING_BASE_IDX                                                                   2
#define regDP0_DP_VID_N                                                                                 0x2127
#define regDP0_DP_VID_N_BASE_IDX                                                                        2
#define regDP0_DP_VID_M                                                                                 0x2128
#define regDP0_DP_VID_M_BASE_IDX                                                                        2
#define regDP0_DP_LINK_FRAMING_CNTL                                                                     0x2129
#define regDP0_DP_LINK_FRAMING_CNTL_BASE_IDX                                                            2
#define regDP0_DP_HBR2_EYE_PATTERN                                                                      0x212a
#define regDP0_DP_HBR2_EYE_PATTERN_BASE_IDX                                                             2
#define regDP0_DP_VID_MSA_VBID                                                                          0x212b
#define regDP0_DP_VID_MSA_VBID_BASE_IDX                                                                 2
#define regDP0_DP_VID_INTERRUPT_CNTL                                                                    0x212c
#define regDP0_DP_VID_INTERRUPT_CNTL_BASE_IDX                                                           2
#define regDP0_DP_DPHY_CNTL                                                                             0x212d
#define regDP0_DP_DPHY_CNTL_BASE_IDX                                                                    2
#define regDP0_DP_DPHY_TRAINING_PATTERN_SEL                                                             0x212e
#define regDP0_DP_DPHY_TRAINING_PATTERN_SEL_BASE_IDX                                                    2
#define regDP0_DP_DPHY_SYM0                                                                             0x212f
#define regDP0_DP_DPHY_SYM0_BASE_IDX                                                                    2
#define regDP0_DP_DPHY_SYM1                                                                             0x2130
#define regDP0_DP_DPHY_SYM1_BASE_IDX                                                                    2
#define regDP0_DP_DPHY_SYM2                                                                             0x2131
#define regDP0_DP_DPHY_SYM2_BASE_IDX                                                                    2
#define regDP0_DP_DPHY_8B10B_CNTL                                                                       0x2132
#define regDP0_DP_DPHY_8B10B_CNTL_BASE_IDX                                                              2
#define regDP0_DP_DPHY_PRBS_CNTL                                                                        0x2133
#define regDP0_DP_DPHY_PRBS_CNTL_BASE_IDX                                                               2
#define regDP0_DP_DPHY_SCRAM_CNTL                                                                       0x2134
#define regDP0_DP_DPHY_SCRAM_CNTL_BASE_IDX                                                              2
#define regDP0_DP_DPHY_CRC_EN                                                                           0x2135
#define regDP0_DP_DPHY_CRC_EN_BASE_IDX                                                                  2
#define regDP0_DP_DPHY_CRC_CNTL                                                                         0x2136
#define regDP0_DP_DPHY_CRC_CNTL_BASE_IDX                                                                2
#define regDP0_DP_DPHY_CRC_RESULT                                                                       0x2137
#define regDP0_DP_DPHY_CRC_RESULT_BASE_IDX                                                              2
#define regDP0_DP_DPHY_CRC_MST_CNTL                                                                     0x2138
#define regDP0_DP_DPHY_CRC_MST_CNTL_BASE_IDX                                                            2
#define regDP0_DP_DPHY_CRC_MST_STATUS                                                                   0x2139
#define regDP0_DP_DPHY_CRC_MST_STATUS_BASE_IDX                                                          2
#define regDP0_DP_DPHY_FAST_TRAINING                                                                    0x213a
#define regDP0_DP_DPHY_FAST_TRAINING_BASE_IDX                                                           2
#define regDP0_DP_DPHY_FAST_TRAINING_STATUS                                                             0x213b
#define regDP0_DP_DPHY_FAST_TRAINING_STATUS_BASE_IDX                                                    2
#define regDP0_DP_SEC_CNTL                                                                              0x2141
#define regDP0_DP_SEC_CNTL_BASE_IDX                                                                     2
#define regDP0_DP_SEC_CNTL1                                                                             0x2142
#define regDP0_DP_SEC_CNTL1_BASE_IDX                                                                    2
#define regDP0_DP_SEC_FRAMING1                                                                          0x2143
#define regDP0_DP_SEC_FRAMING1_BASE_IDX                                                                 2
#define regDP0_DP_SEC_FRAMING2                                                                          0x2144
#define regDP0_DP_SEC_FRAMING2_BASE_IDX                                                                 2
#define regDP0_DP_SEC_FRAMING3                                                                          0x2145
#define regDP0_DP_SEC_FRAMING3_BASE_IDX                                                                 2
#define regDP0_DP_SEC_FRAMING4                                                                          0x2146
#define regDP0_DP_SEC_FRAMING4_BASE_IDX                                                                 2
#define regDP0_DP_SEC_AUD_N                                                                             0x2147
#define regDP0_DP_SEC_AUD_N_BASE_IDX                                                                    2
#define regDP0_DP_SEC_AUD_N_READBACK                                                                    0x2148
#define regDP0_DP_SEC_AUD_N_READBACK_BASE_IDX                                                           2
#define regDP0_DP_SEC_AUD_M                                                                             0x2149
#define regDP0_DP_SEC_AUD_M_BASE_IDX                                                                    2
#define regDP0_DP_SEC_AUD_M_READBACK                                                                    0x214a
#define regDP0_DP_SEC_AUD_M_READBACK_BASE_IDX                                                           2
#define regDP0_DP_SEC_TIMESTAMP                                                                         0x214b
#define regDP0_DP_SEC_TIMESTAMP_BASE_IDX                                                                2
#define regDP0_DP_SEC_PACKET_CNTL                                                                       0x214c
#define regDP0_DP_SEC_PACKET_CNTL_BASE_IDX                                                              2
#define regDP0_DP_MSE_RATE_CNTL                                                                         0x214d
#define regDP0_DP_MSE_RATE_CNTL_BASE_IDX                                                                2
#define regDP0_DP_MSE_RATE_UPDATE                                                                       0x214f
#define regDP0_DP_MSE_RATE_UPDATE_BASE_IDX                                                              2
#define regDP0_DP_MSE_SAT0                                                                              0x2150
#define regDP0_DP_MSE_SAT0_BASE_IDX                                                                     2
#define regDP0_DP_MSE_SAT1                                                                              0x2151
#define regDP0_DP_MSE_SAT1_BASE_IDX                                                                     2
#define regDP0_DP_MSE_SAT2                                                                              0x2152
#define regDP0_DP_MSE_SAT2_BASE_IDX                                                                     2
#define regDP0_DP_MSE_SAT_UPDATE                                                                        0x2153
#define regDP0_DP_MSE_SAT_UPDATE_BASE_IDX                                                               2
#define regDP0_DP_MSE_LINK_TIMING                                                                       0x2154
#define regDP0_DP_MSE_LINK_TIMING_BASE_IDX                                                              2
#define regDP0_DP_MSE_MISC_CNTL                                                                         0x2155
#define regDP0_DP_MSE_MISC_CNTL_BASE_IDX                                                                2
#define regDP0_DP_DPHY_BS_SR_SWAP_CNTL                                                                  0x215a
#define regDP0_DP_DPHY_BS_SR_SWAP_CNTL_BASE_IDX                                                         2
#define regDP0_DP_DPHY_HBR2_PATTERN_CONTROL                                                             0x215b
#define regDP0_DP_DPHY_HBR2_PATTERN_CONTROL_BASE_IDX                                                    2
#define regDP0_DP_MSE_SAT0_STATUS                                                                       0x215d
#define regDP0_DP_MSE_SAT0_STATUS_BASE_IDX                                                              2
#define regDP0_DP_MSE_SAT1_STATUS                                                                       0x215e
#define regDP0_DP_MSE_SAT1_STATUS_BASE_IDX                                                              2
#define regDP0_DP_MSE_SAT2_STATUS                                                                       0x215f
#define regDP0_DP_MSE_SAT2_STATUS_BASE_IDX                                                              2
#define regDP0_DP_DPIA_SPARE                                                                            0x2160
#define regDP0_DP_DPIA_SPARE_BASE_IDX                                                                   2
#define regDP0_DP_MSA_TIMING_PARAM1                                                                     0x2162
#define regDP0_DP_MSA_TIMING_PARAM1_BASE_IDX                                                            2
#define regDP0_DP_MSA_TIMING_PARAM2                                                                     0x2163
#define regDP0_DP_MSA_TIMING_PARAM2_BASE_IDX                                                            2
#define regDP0_DP_MSA_TIMING_PARAM3                                                                     0x2164
#define regDP0_DP_MSA_TIMING_PARAM3_BASE_IDX                                                            2
#define regDP0_DP_MSA_TIMING_PARAM4                                                                     0x2165
#define regDP0_DP_MSA_TIMING_PARAM4_BASE_IDX                                                            2
#define regDP0_DP_MSO_CNTL                                                                              0x2166
#define regDP0_DP_MSO_CNTL_BASE_IDX                                                                     2
#define regDP0_DP_MSO_CNTL1                                                                             0x2167
#define regDP0_DP_MSO_CNTL1_BASE_IDX                                                                    2
#define regDP0_DP_DSC_CNTL                                                                              0x2168
#define regDP0_DP_DSC_CNTL_BASE_IDX                                                                     2
#define regDP0_DP_SEC_CNTL2                                                                             0x2169
#define regDP0_DP_SEC_CNTL2_BASE_IDX                                                                    2
#define regDP0_DP_SEC_CNTL3                                                                             0x216a
#define regDP0_DP_SEC_CNTL3_BASE_IDX                                                                    2
#define regDP0_DP_SEC_CNTL4                                                                             0x216b
#define regDP0_DP_SEC_CNTL4_BASE_IDX                                                                    2
#define regDP0_DP_SEC_CNTL5                                                                             0x216c
#define regDP0_DP_SEC_CNTL5_BASE_IDX                                                                    2
#define regDP0_DP_SEC_CNTL6                                                                             0x216d
#define regDP0_DP_SEC_CNTL6_BASE_IDX                                                                    2
#define regDP0_DP_SEC_CNTL7                                                                             0x216e
#define regDP0_DP_SEC_CNTL7_BASE_IDX                                                                    2
#define regDP0_DP_DB_CNTL                                                                               0x216f
#define regDP0_DP_DB_CNTL_BASE_IDX                                                                      2
#define regDP0_DP_MSA_VBID_MISC                                                                         0x2170
#define regDP0_DP_MSA_VBID_MISC_BASE_IDX                                                                2
#define regDP0_DP_SEC_METADATA_TRANSMISSION                                                             0x2171
#define regDP0_DP_SEC_METADATA_TRANSMISSION_BASE_IDX                                                    2
#define regDP0_DP_ALPM_CNTL                                                                             0x2173
#define regDP0_DP_ALPM_CNTL_BASE_IDX                                                                    2
#define regDP0_DP_GSP8_CNTL                                                                             0x2174
#define regDP0_DP_GSP8_CNTL_BASE_IDX                                                                    2
#define regDP0_DP_GSP9_CNTL                                                                             0x2175
#define regDP0_DP_GSP9_CNTL_BASE_IDX                                                                    2
#define regDP0_DP_GSP10_CNTL                                                                            0x2176
#define regDP0_DP_GSP10_CNTL_BASE_IDX                                                                   2
#define regDP0_DP_GSP11_CNTL                                                                            0x2177
#define regDP0_DP_GSP11_CNTL_BASE_IDX                                                                   2
#define regDP0_DP_GSP_EN_DB_STATUS                                                                      0x2178
#define regDP0_DP_GSP_EN_DB_STATUS_BASE_IDX                                                             2
#define regDP0_DP_AUXLESS_ALPM_CNTL1                                                                    0x2179
#define regDP0_DP_AUXLESS_ALPM_CNTL1_BASE_IDX                                                           2
#define regDP0_DP_AUXLESS_ALPM_CNTL2                                                                    0x217a
#define regDP0_DP_AUXLESS_ALPM_CNTL2_BASE_IDX                                                           2
#define regDP0_DP_AUXLESS_ALPM_CNTL3                                                                    0x217b
#define regDP0_DP_AUXLESS_ALPM_CNTL3_BASE_IDX                                                           2
#define regDP0_DP_AUXLESS_ALPM_CNTL4                                                                    0x217c
#define regDP0_DP_AUXLESS_ALPM_CNTL4_BASE_IDX                                                           2
#define regDP0_DP_AUXLESS_ALPM_CNTL5                                                                    0x217d
#define regDP0_DP_AUXLESS_ALPM_CNTL5_BASE_IDX                                                           2
#define regDP0_DP_STREAM_SYMBOL_COUNT_STATUS                                                            0x217e
#define regDP0_DP_STREAM_SYMBOL_COUNT_STATUS_BASE_IDX                                                   2
#define regDP0_DP_STREAM_SYMBOL_COUNT_CONTROL                                                           0x217f
#define regDP0_DP_STREAM_SYMBOL_COUNT_CONTROL_BASE_IDX                                                  2
#define regDP0_DP_LINK_SYMBOL_COUNT_STATUS0                                                             0x2180
#define regDP0_DP_LINK_SYMBOL_COUNT_STATUS0_BASE_IDX                                                    2
#define regDP0_DP_LINK_SYMBOL_COUNT_STATUS1                                                             0x2181
#define regDP0_DP_LINK_SYMBOL_COUNT_STATUS1_BASE_IDX                                                    2
#define regDP0_DP_LINK_SYMBOL_COUNT_CONTROL                                                             0x2182
#define regDP0_DP_LINK_SYMBOL_COUNT_CONTROL_BASE_IDX                                                    2


// addressBlock: dce_dc_dio_dig1_vpg_vpg_dispdec
// base address: 0x15930
#define regVPG1_VPG_GENERIC_PACKET_ACCESS_CTRL                                                          0x218c
#define regVPG1_VPG_GENERIC_PACKET_ACCESS_CTRL_BASE_IDX                                                 2
#define regVPG1_VPG_GENERIC_PACKET_DATA                                                                 0x218d
#define regVPG1_VPG_GENERIC_PACKET_DATA_BASE_IDX                                                        2
#define regVPG1_VPG_GSP_FRAME_UPDATE_CTRL                                                               0x218e
#define regVPG1_VPG_GSP_FRAME_UPDATE_CTRL_BASE_IDX                                                      2
#define regVPG1_VPG_GSP_IMMEDIATE_UPDATE_CTRL                                                           0x218f
#define regVPG1_VPG_GSP_IMMEDIATE_UPDATE_CTRL_BASE_IDX                                                  2
#define regVPG1_VPG_GENERIC_STATUS                                                                      0x2190
#define regVPG1_VPG_GENERIC_STATUS_BASE_IDX                                                             2
#define regVPG1_VPG_MEM_PWR                                                                             0x2191
#define regVPG1_VPG_MEM_PWR_BASE_IDX                                                                    2
#define regVPG1_VPG_ISRC1_2_ACCESS_CTRL                                                                 0x2192
#define regVPG1_VPG_ISRC1_2_ACCESS_CTRL_BASE_IDX                                                        2
#define regVPG1_VPG_ISRC1_2_DATA                                                                        0x2193
#define regVPG1_VPG_ISRC1_2_DATA_BASE_IDX                                                               2
#define regVPG1_VPG_MPEG_INFO0                                                                          0x2194
#define regVPG1_VPG_MPEG_INFO0_BASE_IDX                                                                 2
#define regVPG1_VPG_MPEG_INFO1                                                                          0x2195
#define regVPG1_VPG_MPEG_INFO1_BASE_IDX                                                                 2


// addressBlock: dce_dc_dio_dig1_afmt_afmt_dispdec
// base address: 0x1595c
#define regAFMT1_AFMT_ACP                                                                               0x2197
#define regAFMT1_AFMT_ACP_BASE_IDX                                                                      2
#define regAFMT1_AFMT_VBI_PACKET_CONTROL                                                                0x2198
#define regAFMT1_AFMT_VBI_PACKET_CONTROL_BASE_IDX                                                       2
#define regAFMT1_AFMT_AUDIO_PACKET_CONTROL2                                                             0x2199
#define regAFMT1_AFMT_AUDIO_PACKET_CONTROL2_BASE_IDX                                                    2
#define regAFMT1_AFMT_AUDIO_INFO0                                                                       0x219a
#define regAFMT1_AFMT_AUDIO_INFO0_BASE_IDX                                                              2
#define regAFMT1_AFMT_AUDIO_INFO1                                                                       0x219b
#define regAFMT1_AFMT_AUDIO_INFO1_BASE_IDX                                                              2
#define regAFMT1_AFMT_60958_0                                                                           0x219c
#define regAFMT1_AFMT_60958_0_BASE_IDX                                                                  2
#define regAFMT1_AFMT_60958_1                                                                           0x219d
#define regAFMT1_AFMT_60958_1_BASE_IDX                                                                  2
#define regAFMT1_AFMT_AUDIO_CRC_CONTROL                                                                 0x219e
#define regAFMT1_AFMT_AUDIO_CRC_CONTROL_BASE_IDX                                                        2
#define regAFMT1_AFMT_RAMP_CONTROL0                                                                     0x219f
#define regAFMT1_AFMT_RAMP_CONTROL0_BASE_IDX                                                            2
#define regAFMT1_AFMT_RAMP_CONTROL1                                                                     0x21a0
#define regAFMT1_AFMT_RAMP_CONTROL1_BASE_IDX                                                            2
#define regAFMT1_AFMT_RAMP_CONTROL2                                                                     0x21a1
#define regAFMT1_AFMT_RAMP_CONTROL2_BASE_IDX                                                            2
#define regAFMT1_AFMT_RAMP_CONTROL3                                                                     0x21a2
#define regAFMT1_AFMT_RAMP_CONTROL3_BASE_IDX                                                            2
#define regAFMT1_AFMT_60958_2                                                                           0x21a3
#define regAFMT1_AFMT_60958_2_BASE_IDX                                                                  2
#define regAFMT1_AFMT_AUDIO_CRC_RESULT                                                                  0x21a4
#define regAFMT1_AFMT_AUDIO_CRC_RESULT_BASE_IDX                                                         2
#define regAFMT1_AFMT_STATUS                                                                            0x21a5
#define regAFMT1_AFMT_STATUS_BASE_IDX                                                                   2
#define regAFMT1_AFMT_AUDIO_PACKET_CONTROL                                                              0x21a6
#define regAFMT1_AFMT_AUDIO_PACKET_CONTROL_BASE_IDX                                                     2
#define regAFMT1_AFMT_INFOFRAME_CONTROL0                                                                0x21a7
#define regAFMT1_AFMT_INFOFRAME_CONTROL0_BASE_IDX                                                       2
#define regAFMT1_AFMT_INTERRUPT_STATUS                                                                  0x21a8
#define regAFMT1_AFMT_INTERRUPT_STATUS_BASE_IDX                                                         2
#define regAFMT1_AFMT_AUDIO_SRC_CONTROL                                                                 0x21a9
#define regAFMT1_AFMT_AUDIO_SRC_CONTROL_BASE_IDX                                                        2
#define regAFMT1_AFMT_MEM_PWR                                                                           0x21ab
#define regAFMT1_AFMT_MEM_PWR_BASE_IDX                                                                  2


// addressBlock: dce_dc_dio_dig1_dme_dme_dispdec
// base address: 0x159d4
#define regDME1_DME_CONTROL                                                                             0x21b5
#define regDME1_DME_CONTROL_BASE_IDX                                                                    2
#define regDME1_DME_MEMORY_CONTROL                                                                      0x21b6
#define regDME1_DME_MEMORY_CONTROL_BASE_IDX                                                             2


// addressBlock: dce_dc_dio_dig1_dispdec
// base address: 0x490
#define regDIG1_DIG_FE_CNTL                                                                             0x21b7
#define regDIG1_DIG_FE_CNTL_BASE_IDX                                                                    2
#define regDIG1_DIG_FE_CLK_CNTL                                                                         0x21b8
#define regDIG1_DIG_FE_CLK_CNTL_BASE_IDX                                                                2
#define regDIG1_DIG_FE_EN_CNTL                                                                          0x21b9
#define regDIG1_DIG_FE_EN_CNTL_BASE_IDX                                                                 2
#define regDIG1_DIG_OUTPUT_CRC_CNTL                                                                     0x21ba
#define regDIG1_DIG_OUTPUT_CRC_CNTL_BASE_IDX                                                            2
#define regDIG1_DIG_OUTPUT_CRC_RESULT                                                                   0x21bb
#define regDIG1_DIG_OUTPUT_CRC_RESULT_BASE_IDX                                                          2
#define regDIG1_DIG_CLOCK_PATTERN                                                                       0x21bc
#define regDIG1_DIG_CLOCK_PATTERN_BASE_IDX                                                              2
#define regDIG1_DIG_TEST_PATTERN                                                                        0x21bd
#define regDIG1_DIG_TEST_PATTERN_BASE_IDX                                                               2
#define regDIG1_DIG_RANDOM_PATTERN_SEED                                                                 0x21be
#define regDIG1_DIG_RANDOM_PATTERN_SEED_BASE_IDX                                                        2
#define regDIG1_DIG_FIFO_CTRL0                                                                          0x21bf
#define regDIG1_DIG_FIFO_CTRL0_BASE_IDX                                                                 2
#define regDIG1_DIG_FIFO_CTRL1                                                                          0x21c0
#define regDIG1_DIG_FIFO_CTRL1_BASE_IDX                                                                 2
#define regDIG1_HDMI_METADATA_PACKET_CONTROL                                                            0x21c1
#define regDIG1_HDMI_METADATA_PACKET_CONTROL_BASE_IDX                                                   2
#define regDIG1_HDMI_CONTROL                                                                            0x21c2
#define regDIG1_HDMI_CONTROL_BASE_IDX                                                                   2
#define regDIG1_HDMI_STATUS                                                                             0x21c3
#define regDIG1_HDMI_STATUS_BASE_IDX                                                                    2
#define regDIG1_HDMI_AUDIO_PACKET_CONTROL                                                               0x21c4
#define regDIG1_HDMI_AUDIO_PACKET_CONTROL_BASE_IDX                                                      2
#define regDIG1_HDMI_ACR_PACKET_CONTROL                                                                 0x21c5
#define regDIG1_HDMI_ACR_PACKET_CONTROL_BASE_IDX                                                        2
#define regDIG1_HDMI_VBI_PACKET_CONTROL                                                                 0x21c6
#define regDIG1_HDMI_VBI_PACKET_CONTROL_BASE_IDX                                                        2
#define regDIG1_HDMI_INFOFRAME_CONTROL0                                                                 0x21c7
#define regDIG1_HDMI_INFOFRAME_CONTROL0_BASE_IDX                                                        2
#define regDIG1_HDMI_INFOFRAME_CONTROL1                                                                 0x21c8
#define regDIG1_HDMI_INFOFRAME_CONTROL1_BASE_IDX                                                        2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL0                                                            0x21c9
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL0_BASE_IDX                                                   2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL6                                                            0x21ca
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL6_BASE_IDX                                                   2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL5                                                            0x21cb
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL5_BASE_IDX                                                   2
#define regDIG1_HDMI_GC                                                                                 0x21cc
#define regDIG1_HDMI_GC_BASE_IDX                                                                        2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL1                                                            0x21cd
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL1_BASE_IDX                                                   2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL2                                                            0x21ce
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL2_BASE_IDX                                                   2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL3                                                            0x21cf
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL3_BASE_IDX                                                   2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL4                                                            0x21d0
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL4_BASE_IDX                                                   2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL7                                                            0x21d1
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL7_BASE_IDX                                                   2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL8                                                            0x21d2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL8_BASE_IDX                                                   2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL9                                                            0x21d3
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL9_BASE_IDX                                                   2
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL10                                                           0x21d4
#define regDIG1_HDMI_GENERIC_PACKET_CONTROL10_BASE_IDX                                                  2
#define regDIG1_HDMI_DB_CONTROL                                                                         0x21d5
#define regDIG1_HDMI_DB_CONTROL_BASE_IDX                                                                2
#define regDIG1_HDMI_ACR_32_0                                                                           0x21d6
#define regDIG1_HDMI_ACR_32_0_BASE_IDX                                                                  2
#define regDIG1_HDMI_ACR_32_1                                                                           0x21d7
#define regDIG1_HDMI_ACR_32_1_BASE_IDX                                                                  2
#define regDIG1_HDMI_ACR_44_0                                                                           0x21d8
#define regDIG1_HDMI_ACR_44_0_BASE_IDX                                                                  2
#define regDIG1_HDMI_ACR_44_1                                                                           0x21d9
#define regDIG1_HDMI_ACR_44_1_BASE_IDX                                                                  2
#define regDIG1_HDMI_ACR_48_0                                                                           0x21da
#define regDIG1_HDMI_ACR_48_0_BASE_IDX                                                                  2
#define regDIG1_HDMI_ACR_48_1                                                                           0x21db
#define regDIG1_HDMI_ACR_48_1_BASE_IDX                                                                  2
#define regDIG1_HDMI_ACR_STATUS_0                                                                       0x21dc
#define regDIG1_HDMI_ACR_STATUS_0_BASE_IDX                                                              2
#define regDIG1_HDMI_ACR_STATUS_1                                                                       0x21dd
#define regDIG1_HDMI_ACR_STATUS_1_BASE_IDX                                                              2
#define regDIG1_AFMT_CNTL                                                                               0x21de
#define regDIG1_AFMT_CNTL_BASE_IDX                                                                      2
#define regDIG1_DIG_BE_CLK_CNTL                                                                         0x21df
#define regDIG1_DIG_BE_CLK_CNTL_BASE_IDX                                                                2
#define regDIG1_DIG_BE_CNTL                                                                             0x21e0
#define regDIG1_DIG_BE_CNTL_BASE_IDX                                                                    2
#define regDIG1_DIG_BE_EN_CNTL                                                                          0x21e1
#define regDIG1_DIG_BE_EN_CNTL_BASE_IDX                                                                 2
#define regDIG1_TMDS_CNTL                                                                               0x2208
#define regDIG1_TMDS_CNTL_BASE_IDX                                                                      2
#define regDIG1_TMDS_CONTROL_CHAR                                                                       0x2209
#define regDIG1_TMDS_CONTROL_CHAR_BASE_IDX                                                              2
#define regDIG1_TMDS_CONTROL0_FEEDBACK                                                                  0x220a
#define regDIG1_TMDS_CONTROL0_FEEDBACK_BASE_IDX                                                         2
#define regDIG1_TMDS_STEREOSYNC_CTL_SEL                                                                 0x220b
#define regDIG1_TMDS_STEREOSYNC_CTL_SEL_BASE_IDX                                                        2
#define regDIG1_TMDS_SYNC_CHAR_PATTERN_0_1                                                              0x220c
#define regDIG1_TMDS_SYNC_CHAR_PATTERN_0_1_BASE_IDX                                                     2
#define regDIG1_TMDS_SYNC_CHAR_PATTERN_2_3                                                              0x220d
#define regDIG1_TMDS_SYNC_CHAR_PATTERN_2_3_BASE_IDX                                                     2
#define regDIG1_TMDS_CTL_BITS                                                                           0x220f
#define regDIG1_TMDS_CTL_BITS_BASE_IDX                                                                  2
#define regDIG1_TMDS_DCBALANCER_CONTROL                                                                 0x2210
#define regDIG1_TMDS_DCBALANCER_CONTROL_BASE_IDX                                                        2
#define regDIG1_TMDS_SYNC_DCBALANCE_CHAR                                                                0x2211
#define regDIG1_TMDS_SYNC_DCBALANCE_CHAR_BASE_IDX                                                       2
#define regDIG1_TMDS_CTL0_1_GEN_CNTL                                                                    0x2212
#define regDIG1_TMDS_CTL0_1_GEN_CNTL_BASE_IDX                                                           2
#define regDIG1_TMDS_CTL2_3_GEN_CNTL                                                                    0x2213
#define regDIG1_TMDS_CTL2_3_GEN_CNTL_BASE_IDX                                                           2
#define regDIG1_DIG_VERSION                                                                             0x2215
#define regDIG1_DIG_VERSION_BASE_IDX                                                                    2


// addressBlock: dce_dc_dio_dp1_dispdec
// base address: 0x490
#define regDP1_DP_LINK_CNTL                                                                             0x2242
#define regDP1_DP_LINK_CNTL_BASE_IDX                                                                    2
#define regDP1_DP_PIXEL_FORMAT                                                                          0x2243
#define regDP1_DP_PIXEL_FORMAT_BASE_IDX                                                                 2
#define regDP1_DP_MSA_COLORIMETRY                                                                       0x2244
#define regDP1_DP_MSA_COLORIMETRY_BASE_IDX                                                              2
#define regDP1_DP_CONFIG                                                                                0x2245
#define regDP1_DP_CONFIG_BASE_IDX                                                                       2
#define regDP1_DP_VID_STREAM_CNTL                                                                       0x2246
#define regDP1_DP_VID_STREAM_CNTL_BASE_IDX                                                              2
#define regDP1_DP_STEER_FIFO                                                                            0x2247
#define regDP1_DP_STEER_FIFO_BASE_IDX                                                                   2
#define regDP1_DP_MSA_MISC                                                                              0x2248
#define regDP1_DP_MSA_MISC_BASE_IDX                                                                     2
#define regDP1_DP_DPHY_INTERNAL_CTRL                                                                    0x2249
#define regDP1_DP_DPHY_INTERNAL_CTRL_BASE_IDX                                                           2
#define regDP1_DP_VID_TIMING                                                                            0x224a
#define regDP1_DP_VID_TIMING_BASE_IDX                                                                   2
#define regDP1_DP_VID_N                                                                                 0x224b
#define regDP1_DP_VID_N_BASE_IDX                                                                        2
#define regDP1_DP_VID_M                                                                                 0x224c
#define regDP1_DP_VID_M_BASE_IDX                                                                        2
#define regDP1_DP_LINK_FRAMING_CNTL                                                                     0x224d
#define regDP1_DP_LINK_FRAMING_CNTL_BASE_IDX                                                            2
#define regDP1_DP_HBR2_EYE_PATTERN                                                                      0x224e
#define regDP1_DP_HBR2_EYE_PATTERN_BASE_IDX                                                             2
#define regDP1_DP_VID_MSA_VBID                                                                          0x224f
#define regDP1_DP_VID_MSA_VBID_BASE_IDX                                                                 2
#define regDP1_DP_VID_INTERRUPT_CNTL                                                                    0x2250
#define regDP1_DP_VID_INTERRUPT_CNTL_BASE_IDX                                                           2
#define regDP1_DP_DPHY_CNTL                                                                             0x2251
#define regDP1_DP_DPHY_CNTL_BASE_IDX                                                                    2
#define regDP1_DP_DPHY_TRAINING_PATTERN_SEL                                                             0x2252
#define regDP1_DP_DPHY_TRAINING_PATTERN_SEL_BASE_IDX                                                    2
#define regDP1_DP_DPHY_SYM0                                                                             0x2253
#define regDP1_DP_DPHY_SYM0_BASE_IDX                                                                    2
#define regDP1_DP_DPHY_SYM1                                                                             0x2254
#define regDP1_DP_DPHY_SYM1_BASE_IDX                                                                    2
#define regDP1_DP_DPHY_SYM2                                                                             0x2255
#define regDP1_DP_DPHY_SYM2_BASE_IDX                                                                    2
#define regDP1_DP_DPHY_8B10B_CNTL                                                                       0x2256
#define regDP1_DP_DPHY_8B10B_CNTL_BASE_IDX                                                              2
#define regDP1_DP_DPHY_PRBS_CNTL                                                                        0x2257
#define regDP1_DP_DPHY_PRBS_CNTL_BASE_IDX                                                               2
#define regDP1_DP_DPHY_SCRAM_CNTL                                                                       0x2258
#define regDP1_DP_DPHY_SCRAM_CNTL_BASE_IDX                                                              2
#define regDP1_DP_DPHY_CRC_EN                                                                           0x2259
#define regDP1_DP_DPHY_CRC_EN_BASE_IDX                                                                  2
#define regDP1_DP_DPHY_CRC_CNTL                                                                         0x225a
#define regDP1_DP_DPHY_CRC_CNTL_BASE_IDX                                                                2
#define regDP1_DP_DPHY_CRC_RESULT                                                                       0x225b
#define regDP1_DP_DPHY_CRC_RESULT_BASE_IDX                                                              2
#define regDP1_DP_DPHY_CRC_MST_CNTL                                                                     0x225c
#define regDP1_DP_DPHY_CRC_MST_CNTL_BASE_IDX                                                            2
#define regDP1_DP_DPHY_CRC_MST_STATUS                                                                   0x225d
#define regDP1_DP_DPHY_CRC_MST_STATUS_BASE_IDX                                                          2
#define regDP1_DP_DPHY_FAST_TRAINING                                                                    0x225e
#define regDP1_DP_DPHY_FAST_TRAINING_BASE_IDX                                                           2
#define regDP1_DP_DPHY_FAST_TRAINING_STATUS                                                             0x225f
#define regDP1_DP_DPHY_FAST_TRAINING_STATUS_BASE_IDX                                                    2
#define regDP1_DP_SEC_CNTL                                                                              0x2265
#define regDP1_DP_SEC_CNTL_BASE_IDX                                                                     2
#define regDP1_DP_SEC_CNTL1                                                                             0x2266
#define regDP1_DP_SEC_CNTL1_BASE_IDX                                                                    2
#define regDP1_DP_SEC_FRAMING1                                                                          0x2267
#define regDP1_DP_SEC_FRAMING1_BASE_IDX                                                                 2
#define regDP1_DP_SEC_FRAMING2                                                                          0x2268
#define regDP1_DP_SEC_FRAMING2_BASE_IDX                                                                 2
#define regDP1_DP_SEC_FRAMING3                                                                          0x2269
#define regDP1_DP_SEC_FRAMING3_BASE_IDX                                                                 2
#define regDP1_DP_SEC_FRAMING4                                                                          0x226a
#define regDP1_DP_SEC_FRAMING4_BASE_IDX                                                                 2
#define regDP1_DP_SEC_AUD_N                                                                             0x226b
#define regDP1_DP_SEC_AUD_N_BASE_IDX                                                                    2
#define regDP1_DP_SEC_AUD_N_READBACK                                                                    0x226c
#define regDP1_DP_SEC_AUD_N_READBACK_BASE_IDX                                                           2
#define regDP1_DP_SEC_AUD_M                                                                             0x226d
#define regDP1_DP_SEC_AUD_M_BASE_IDX                                                                    2
#define regDP1_DP_SEC_AUD_M_READBACK                                                                    0x226e
#define regDP1_DP_SEC_AUD_M_READBACK_BASE_IDX                                                           2
#define regDP1_DP_SEC_TIMESTAMP                                                                         0x226f
#define regDP1_DP_SEC_TIMESTAMP_BASE_IDX                                                                2
#define regDP1_DP_SEC_PACKET_CNTL                                                                       0x2270
#define regDP1_DP_SEC_PACKET_CNTL_BASE_IDX                                                              2
#define regDP1_DP_MSE_RATE_CNTL                                                                         0x2271
#define regDP1_DP_MSE_RATE_CNTL_BASE_IDX                                                                2
#define regDP1_DP_MSE_RATE_UPDATE                                                                       0x2273
#define regDP1_DP_MSE_RATE_UPDATE_BASE_IDX                                                              2
#define regDP1_DP_MSE_SAT0                                                                              0x2274
#define regDP1_DP_MSE_SAT0_BASE_IDX                                                                     2
#define regDP1_DP_MSE_SAT1                                                                              0x2275
#define regDP1_DP_MSE_SAT1_BASE_IDX                                                                     2
#define regDP1_DP_MSE_SAT2                                                                              0x2276
#define regDP1_DP_MSE_SAT2_BASE_IDX                                                                     2
#define regDP1_DP_MSE_SAT_UPDATE                                                                        0x2277
#define regDP1_DP_MSE_SAT_UPDATE_BASE_IDX                                                               2
#define regDP1_DP_MSE_LINK_TIMING                                                                       0x2278
#define regDP1_DP_MSE_LINK_TIMING_BASE_IDX                                                              2
#define regDP1_DP_MSE_MISC_CNTL                                                                         0x2279
#define regDP1_DP_MSE_MISC_CNTL_BASE_IDX                                                                2
#define regDP1_DP_DPHY_BS_SR_SWAP_CNTL                                                                  0x227e
#define regDP1_DP_DPHY_BS_SR_SWAP_CNTL_BASE_IDX                                                         2
#define regDP1_DP_DPHY_HBR2_PATTERN_CONTROL                                                             0x227f
#define regDP1_DP_DPHY_HBR2_PATTERN_CONTROL_BASE_IDX                                                    2
#define regDP1_DP_MSE_SAT0_STATUS                                                                       0x2281
#define regDP1_DP_MSE_SAT0_STATUS_BASE_IDX                                                              2
#define regDP1_DP_MSE_SAT1_STATUS                                                                       0x2282
#define regDP1_DP_MSE_SAT1_STATUS_BASE_IDX                                                              2
#define regDP1_DP_MSE_SAT2_STATUS                                                                       0x2283
#define regDP1_DP_MSE_SAT2_STATUS_BASE_IDX                                                              2
#define regDP1_DP_DPIA_SPARE                                                                            0x2284
#define regDP1_DP_DPIA_SPARE_BASE_IDX                                                                   2
#define regDP1_DP_MSA_TIMING_PARAM1                                                                     0x2286
#define regDP1_DP_MSA_TIMING_PARAM1_BASE_IDX                                                            2
#define regDP1_DP_MSA_TIMING_PARAM2                                                                     0x2287
#define regDP1_DP_MSA_TIMING_PARAM2_BASE_IDX                                                            2
#define regDP1_DP_MSA_TIMING_PARAM3                                                                     0x2288
#define regDP1_DP_MSA_TIMING_PARAM3_BASE_IDX                                                            2
#define regDP1_DP_MSA_TIMING_PARAM4                                                                     0x2289
#define regDP1_DP_MSA_TIMING_PARAM4_BASE_IDX                                                            2
#define regDP1_DP_MSO_CNTL                                                                              0x228a
#define regDP1_DP_MSO_CNTL_BASE_IDX                                                                     2
#define regDP1_DP_MSO_CNTL1                                                                             0x228b
#define regDP1_DP_MSO_CNTL1_BASE_IDX                                                                    2
#define regDP1_DP_DSC_CNTL                                                                              0x228c
#define regDP1_DP_DSC_CNTL_BASE_IDX                                                                     2
#define regDP1_DP_SEC_CNTL2                                                                             0x228d
#define regDP1_DP_SEC_CNTL2_BASE_IDX                                                                    2
#define regDP1_DP_SEC_CNTL3                                                                             0x228e
#define regDP1_DP_SEC_CNTL3_BASE_IDX                                                                    2
#define regDP1_DP_SEC_CNTL4                                                                             0x228f
#define regDP1_DP_SEC_CNTL4_BASE_IDX                                                                    2
#define regDP1_DP_SEC_CNTL5                                                                             0x2290
#define regDP1_DP_SEC_CNTL5_BASE_IDX                                                                    2
#define regDP1_DP_SEC_CNTL6                                                                             0x2291
#define regDP1_DP_SEC_CNTL6_BASE_IDX                                                                    2
#define regDP1_DP_SEC_CNTL7                                                                             0x2292
#define regDP1_DP_SEC_CNTL7_BASE_IDX                                                                    2
#define regDP1_DP_DB_CNTL                                                                               0x2293
#define regDP1_DP_DB_CNTL_BASE_IDX                                                                      2
#define regDP1_DP_MSA_VBID_MISC                                                                         0x2294
#define regDP1_DP_MSA_VBID_MISC_BASE_IDX                                                                2
#define regDP1_DP_SEC_METADATA_TRANSMISSION                                                             0x2295
#define regDP1_DP_SEC_METADATA_TRANSMISSION_BASE_IDX                                                    2
#define regDP1_DP_ALPM_CNTL                                                                             0x2297
#define regDP1_DP_ALPM_CNTL_BASE_IDX                                                                    2
#define regDP1_DP_GSP8_CNTL                                                                             0x2298
#define regDP1_DP_GSP8_CNTL_BASE_IDX                                                                    2
#define regDP1_DP_GSP9_CNTL                                                                             0x2299
#define regDP1_DP_GSP9_CNTL_BASE_IDX                                                                    2
#define regDP1_DP_GSP10_CNTL                                                                            0x229a
#define regDP1_DP_GSP10_CNTL_BASE_IDX                                                                   2
#define regDP1_DP_GSP11_CNTL                                                                            0x229b
#define regDP1_DP_GSP11_CNTL_BASE_IDX                                                                   2
#define regDP1_DP_GSP_EN_DB_STATUS                                                                      0x229c
#define regDP1_DP_GSP_EN_DB_STATUS_BASE_IDX                                                             2
#define regDP1_DP_AUXLESS_ALPM_CNTL1                                                                    0x229d
#define regDP1_DP_AUXLESS_ALPM_CNTL1_BASE_IDX                                                           2
#define regDP1_DP_AUXLESS_ALPM_CNTL2                                                                    0x229e
#define regDP1_DP_AUXLESS_ALPM_CNTL2_BASE_IDX                                                           2
#define regDP1_DP_AUXLESS_ALPM_CNTL3                                                                    0x229f
#define regDP1_DP_AUXLESS_ALPM_CNTL3_BASE_IDX                                                           2
#define regDP1_DP_AUXLESS_ALPM_CNTL4                                                                    0x22a0
#define regDP1_DP_AUXLESS_ALPM_CNTL4_BASE_IDX                                                           2
#define regDP1_DP_AUXLESS_ALPM_CNTL5                                                                    0x22a1
#define regDP1_DP_AUXLESS_ALPM_CNTL5_BASE_IDX                                                           2
#define regDP1_DP_STREAM_SYMBOL_COUNT_STATUS                                                            0x22a2
#define regDP1_DP_STREAM_SYMBOL_COUNT_STATUS_BASE_IDX                                                   2
#define regDP1_DP_STREAM_SYMBOL_COUNT_CONTROL                                                           0x22a3
#define regDP1_DP_STREAM_SYMBOL_COUNT_CONTROL_BASE_IDX                                                  2
#define regDP1_DP_LINK_SYMBOL_COUNT_STATUS0                                                             0x22a4
#define regDP1_DP_LINK_SYMBOL_COUNT_STATUS0_BASE_IDX                                                    2
#define regDP1_DP_LINK_SYMBOL_COUNT_STATUS1                                                             0x22a5
#define regDP1_DP_LINK_SYMBOL_COUNT_STATUS1_BASE_IDX                                                    2
#define regDP1_DP_LINK_SYMBOL_COUNT_CONTROL                                                             0x22a6
#define regDP1_DP_LINK_SYMBOL_COUNT_CONTROL_BASE_IDX                                                    2


// addressBlock: dce_dc_dio_dig2_vpg_vpg_dispdec
// base address: 0x15dc0
#define regVPG2_VPG_GENERIC_PACKET_ACCESS_CTRL                                                          0x22b0
#define regVPG2_VPG_GENERIC_PACKET_ACCESS_CTRL_BASE_IDX                                                 2
#define regVPG2_VPG_GENERIC_PACKET_DATA                                                                 0x22b1
#define regVPG2_VPG_GENERIC_PACKET_DATA_BASE_IDX                                                        2
#define regVPG2_VPG_GSP_FRAME_UPDATE_CTRL                                                               0x22b2
#define regVPG2_VPG_GSP_FRAME_UPDATE_CTRL_BASE_IDX                                                      2
#define regVPG2_VPG_GSP_IMMEDIATE_UPDATE_CTRL                                                           0x22b3
#define regVPG2_VPG_GSP_IMMEDIATE_UPDATE_CTRL_BASE_IDX                                                  2
#define regVPG2_VPG_GENERIC_STATUS                                                                      0x22b4
#define regVPG2_VPG_GENERIC_STATUS_BASE_IDX                                                             2
#define regVPG2_VPG_MEM_PWR                                                                             0x22b5
#define regVPG2_VPG_MEM_PWR_BASE_IDX                                                                    2
#define regVPG2_VPG_ISRC1_2_ACCESS_CTRL                                                                 0x22b6
#define regVPG2_VPG_ISRC1_2_ACCESS_CTRL_BASE_IDX                                                        2
#define regVPG2_VPG_ISRC1_2_DATA                                                                        0x22b7
#define regVPG2_VPG_ISRC1_2_DATA_BASE_IDX                                                               2
#define regVPG2_VPG_MPEG_INFO0                                                                          0x22b8
#define regVPG2_VPG_MPEG_INFO0_BASE_IDX                                                                 2
#define regVPG2_VPG_MPEG_INFO1                                                                          0x22b9
#define regVPG2_VPG_MPEG_INFO1_BASE_IDX                                                                 2


// addressBlock: dce_dc_dio_dig2_afmt_afmt_dispdec
// base address: 0x15dec
#define regAFMT2_AFMT_ACP                                                                               0x22bb
#define regAFMT2_AFMT_ACP_BASE_IDX                                                                      2
#define regAFMT2_AFMT_VBI_PACKET_CONTROL                                                                0x22bc
#define regAFMT2_AFMT_VBI_PACKET_CONTROL_BASE_IDX                                                       2
#define regAFMT2_AFMT_AUDIO_PACKET_CONTROL2                                                             0x22bd
#define regAFMT2_AFMT_AUDIO_PACKET_CONTROL2_BASE_IDX                                                    2
#define regAFMT2_AFMT_AUDIO_INFO0                                                                       0x22be
#define regAFMT2_AFMT_AUDIO_INFO0_BASE_IDX                                                              2
#define regAFMT2_AFMT_AUDIO_INFO1                                                                       0x22bf
#define regAFMT2_AFMT_AUDIO_INFO1_BASE_IDX                                                              2
#define regAFMT2_AFMT_60958_0                                                                           0x22c0
#define regAFMT2_AFMT_60958_0_BASE_IDX                                                                  2
#define regAFMT2_AFMT_60958_1                                                                           0x22c1
#define regAFMT2_AFMT_60958_1_BASE_IDX                                                                  2
#define regAFMT2_AFMT_AUDIO_CRC_CONTROL                                                                 0x22c2
#define regAFMT2_AFMT_AUDIO_CRC_CONTROL_BASE_IDX                                                        2
#define regAFMT2_AFMT_RAMP_CONTROL0                                                                     0x22c3
#define regAFMT2_AFMT_RAMP_CONTROL0_BASE_IDX                                                            2
#define regAFMT2_AFMT_RAMP_CONTROL1                                                                     0x22c4
#define regAFMT2_AFMT_RAMP_CONTROL1_BASE_IDX                                                            2
#define regAFMT2_AFMT_RAMP_CONTROL2                                                                     0x22c5
#define regAFMT2_AFMT_RAMP_CONTROL2_BASE_IDX                                                            2
#define regAFMT2_AFMT_RAMP_CONTROL3                                                                     0x22c6
#define regAFMT2_AFMT_RAMP_CONTROL3_BASE_IDX                                                            2
#define regAFMT2_AFMT_60958_2                                                                           0x22c7
#define regAFMT2_AFMT_60958_2_BASE_IDX                                                                  2
#define regAFMT2_AFMT_AUDIO_CRC_RESULT                                                                  0x22c8
#define regAFMT2_AFMT_AUDIO_CRC_RESULT_BASE_IDX                                                         2
#define regAFMT2_AFMT_STATUS                                                                            0x22c9
#define regAFMT2_AFMT_STATUS_BASE_IDX                                                                   2
#define regAFMT2_AFMT_AUDIO_PACKET_CONTROL                                                              0x22ca
#define regAFMT2_AFMT_AUDIO_PACKET_CONTROL_BASE_IDX                                                     2
#define regAFMT2_AFMT_INFOFRAME_CONTROL0                                                                0x22cb
#define regAFMT2_AFMT_INFOFRAME_CONTROL0_BASE_IDX                                                       2
#define regAFMT2_AFMT_INTERRUPT_STATUS                                                                  0x22cc
#define regAFMT2_AFMT_INTERRUPT_STATUS_BASE_IDX                                                         2
#define regAFMT2_AFMT_AUDIO_SRC_CONTROL                                                                 0x22cd
#define regAFMT2_AFMT_AUDIO_SRC_CONTROL_BASE_IDX                                                        2
#define regAFMT2_AFMT_MEM_PWR                                                                           0x22cf
#define regAFMT2_AFMT_MEM_PWR_BASE_IDX                                                                  2


// addressBlock: dce_dc_dio_dig2_dme_dme_dispdec
// base address: 0x15e64
#define regDME2_DME_CONTROL                                                                             0x22d9
#define regDME2_DME_CONTROL_BASE_IDX                                                                    2
#define regDME2_DME_MEMORY_CONTROL                                                                      0x22da
#define regDME2_DME_MEMORY_CONTROL_BASE_IDX                                                             2


// addressBlock: dce_dc_dio_dig2_dispdec
// base address: 0x920
#define regDIG2_DIG_FE_CNTL                                                                             0x22db
#define regDIG2_DIG_FE_CNTL_BASE_IDX                                                                    2
#define regDIG2_DIG_FE_CLK_CNTL                                                                         0x22dc
#define regDIG2_DIG_FE_CLK_CNTL_BASE_IDX                                                                2
#define regDIG2_DIG_FE_EN_CNTL                                                                          0x22dd
#define regDIG2_DIG_FE_EN_CNTL_BASE_IDX                                                                 2
#define regDIG2_DIG_OUTPUT_CRC_CNTL                                                                     0x22de
#define regDIG2_DIG_OUTPUT_CRC_CNTL_BASE_IDX                                                            2
#define regDIG2_DIG_OUTPUT_CRC_RESULT                                                                   0x22df
#define regDIG2_DIG_OUTPUT_CRC_RESULT_BASE_IDX                                                          2
#define regDIG2_DIG_CLOCK_PATTERN                                                                       0x22e0
#define regDIG2_DIG_CLOCK_PATTERN_BASE_IDX                                                              2
#define regDIG2_DIG_TEST_PATTERN                                                                        0x22e1
#define regDIG2_DIG_TEST_PATTERN_BASE_IDX                                                               2
#define regDIG2_DIG_RANDOM_PATTERN_SEED                                                                 0x22e2
#define regDIG2_DIG_RANDOM_PATTERN_SEED_BASE_IDX                                                        2
#define regDIG2_DIG_FIFO_CTRL0                                                                          0x22e3
#define regDIG2_DIG_FIFO_CTRL0_BASE_IDX                                                                 2
#define regDIG2_DIG_FIFO_CTRL1                                                                          0x22e4
#define regDIG2_DIG_FIFO_CTRL1_BASE_IDX                                                                 2
#define regDIG2_HDMI_METADATA_PACKET_CONTROL                                                            0x22e5
#define regDIG2_HDMI_METADATA_PACKET_CONTROL_BASE_IDX                                                   2
#define regDIG2_HDMI_CONTROL                                                                            0x22e6
#define regDIG2_HDMI_CONTROL_BASE_IDX                                                                   2
#define regDIG2_HDMI_STATUS                                                                             0x22e7
#define regDIG2_HDMI_STATUS_BASE_IDX                                                                    2
#define regDIG2_HDMI_AUDIO_PACKET_CONTROL                                                               0x22e8
#define regDIG2_HDMI_AUDIO_PACKET_CONTROL_BASE_IDX                                                      2
#define regDIG2_HDMI_ACR_PACKET_CONTROL                                                                 0x22e9
#define regDIG2_HDMI_ACR_PACKET_CONTROL_BASE_IDX                                                        2
#define regDIG2_HDMI_VBI_PACKET_CONTROL                                                                 0x22ea
#define regDIG2_HDMI_VBI_PACKET_CONTROL_BASE_IDX                                                        2
#define regDIG2_HDMI_INFOFRAME_CONTROL0                                                                 0x22eb
#define regDIG2_HDMI_INFOFRAME_CONTROL0_BASE_IDX                                                        2
#define regDIG2_HDMI_INFOFRAME_CONTROL1                                                                 0x22ec
#define regDIG2_HDMI_INFOFRAME_CONTROL1_BASE_IDX                                                        2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL0                                                            0x22ed
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL0_BASE_IDX                                                   2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL6                                                            0x22ee
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL6_BASE_IDX                                                   2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL5                                                            0x22ef
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL5_BASE_IDX                                                   2
#define regDIG2_HDMI_GC                                                                                 0x22f0
#define regDIG2_HDMI_GC_BASE_IDX                                                                        2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL1                                                            0x22f1
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL1_BASE_IDX                                                   2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL2                                                            0x22f2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL2_BASE_IDX                                                   2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL3                                                            0x22f3
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL3_BASE_IDX                                                   2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL4                                                            0x22f4
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL4_BASE_IDX                                                   2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL7                                                            0x22f5
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL7_BASE_IDX                                                   2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL8                                                            0x22f6
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL8_BASE_IDX                                                   2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL9                                                            0x22f7
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL9_BASE_IDX                                                   2
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL10                                                           0x22f8
#define regDIG2_HDMI_GENERIC_PACKET_CONTROL10_BASE_IDX                                                  2
#define regDIG2_HDMI_DB_CONTROL                                                                         0x22f9
#define regDIG2_HDMI_DB_CONTROL_BASE_IDX                                                                2
#define regDIG2_HDMI_ACR_32_0                                                                           0x22fa
#define regDIG2_HDMI_ACR_32_0_BASE_IDX                                                                  2
#define regDIG2_HDMI_ACR_32_1                                                                           0x22fb
#define regDIG2_HDMI_ACR_32_1_BASE_IDX                                                                  2
#define regDIG2_HDMI_ACR_44_0                                                                           0x22fc
#define regDIG2_HDMI_ACR_44_0_BASE_IDX                                                                  2
#define regDIG2_HDMI_ACR_44_1                                                                           0x22fd
#define regDIG2_HDMI_ACR_44_1_BASE_IDX                                                                  2
#define regDIG2_HDMI_ACR_48_0                                                                           0x22fe
#define regDIG2_HDMI_ACR_48_0_BASE_IDX                                                                  2
#define regDIG2_HDMI_ACR_48_1                                                                           0x22ff
#define regDIG2_HDMI_ACR_48_1_BASE_IDX                                                                  2
#define regDIG2_HDMI_ACR_STATUS_0                                                                       0x2300
#define regDIG2_HDMI_ACR_STATUS_0_BASE_IDX                                                              2
#define regDIG2_HDMI_ACR_STATUS_1                                                                       0x2301
#define regDIG2_HDMI_ACR_STATUS_1_BASE_IDX                                                              2
#define regDIG2_AFMT_CNTL                                                                               0x2302
#define regDIG2_AFMT_CNTL_BASE_IDX                                                                      2
#define regDIG2_DIG_BE_CLK_CNTL                                                                         0x2303
#define regDIG2_DIG_BE_CLK_CNTL_BASE_IDX                                                                2
#define regDIG2_DIG_BE_CNTL                                                                             0x2304
#define regDIG2_DIG_BE_CNTL_BASE_IDX                                                                    2
#define regDIG2_DIG_BE_EN_CNTL                                                                          0x2305
#define regDIG2_DIG_BE_EN_CNTL_BASE_IDX                                                                 2
#define regDIG2_TMDS_CNTL                                                                               0x232c
#define regDIG2_TMDS_CNTL_BASE_IDX                                                                      2
#define regDIG2_TMDS_CONTROL_CHAR                                                                       0x232d
#define regDIG2_TMDS_CONTROL_CHAR_BASE_IDX                                                              2
#define regDIG2_TMDS_CONTROL0_FEEDBACK                                                                  0x232e
#define regDIG2_TMDS_CONTROL0_FEEDBACK_BASE_IDX                                                         2
#define regDIG2_TMDS_STEREOSYNC_CTL_SEL                                                                 0x232f
#define regDIG2_TMDS_STEREOSYNC_CTL_SEL_BASE_IDX                                                        2
#define regDIG2_TMDS_SYNC_CHAR_PATTERN_0_1                                                              0x2330
#define regDIG2_TMDS_SYNC_CHAR_PATTERN_0_1_BASE_IDX                                                     2
#define regDIG2_TMDS_SYNC_CHAR_PATTERN_2_3                                                              0x2331
#define regDIG2_TMDS_SYNC_CHAR_PATTERN_2_3_BASE_IDX                                                     2
#define regDIG2_TMDS_CTL_BITS                                                                           0x2333
#define regDIG2_TMDS_CTL_BITS_BASE_IDX                                                                  2
#define regDIG2_TMDS_DCBALANCER_CONTROL                                                                 0x2334
#define regDIG2_TMDS_DCBALANCER_CONTROL_BASE_IDX                                                        2
#define regDIG2_TMDS_SYNC_DCBALANCE_CHAR                                                                0x2335
#define regDIG2_TMDS_SYNC_DCBALANCE_CHAR_BASE_IDX                                                       2
#define regDIG2_TMDS_CTL0_1_GEN_CNTL                                                                    0x2336
#define regDIG2_TMDS_CTL0_1_GEN_CNTL_BASE_IDX                                                           2
#define regDIG2_TMDS_CTL2_3_GEN_CNTL                                                                    0x2337
#define regDIG2_TMDS_CTL2_3_GEN_CNTL_BASE_IDX                                                           2
#define regDIG2_DIG_VERSION                                                                             0x2339
#define regDIG2_DIG_VERSION_BASE_IDX                                                                    2


// addressBlock: dce_dc_dio_dp2_dispdec
// base address: 0x920
#define regDP2_DP_LINK_CNTL                                                                             0x2366
#define regDP2_DP_LINK_CNTL_BASE_IDX                                                                    2
#define regDP2_DP_PIXEL_FORMAT                                                                          0x2367
#define regDP2_DP_PIXEL_FORMAT_BASE_IDX                                                                 2
#define regDP2_DP_MSA_COLORIMETRY                                                                       0x2368
#define regDP2_DP_MSA_COLORIMETRY_BASE_IDX                                                              2
#define regDP2_DP_CONFIG                                                                                0x2369
#define regDP2_DP_CONFIG_BASE_IDX                                                                       2
#define regDP2_DP_VID_STREAM_CNTL                                                                       0x236a
#define regDP2_DP_VID_STREAM_CNTL_BASE_IDX                                                              2
#define regDP2_DP_STEER_FIFO                                                                            0x236b
#define regDP2_DP_STEER_FIFO_BASE_IDX                                                                   2
#define regDP2_DP_MSA_MISC                                                                              0x236c
#define regDP2_DP_MSA_MISC_BASE_IDX                                                                     2
#define regDP2_DP_DPHY_INTERNAL_CTRL                                                                    0x236d
#define regDP2_DP_DPHY_INTERNAL_CTRL_BASE_IDX                                                           2
#define regDP2_DP_VID_TIMING                                                                            0x236e
#define regDP2_DP_VID_TIMING_BASE_IDX                                                                   2
#define regDP2_DP_VID_N                                                                                 0x236f
#define regDP2_DP_VID_N_BASE_IDX                                                                        2
#define regDP2_DP_VID_M                                                                                 0x2370
#define regDP2_DP_VID_M_BASE_IDX                                                                        2
#define regDP2_DP_LINK_FRAMING_CNTL                                                                     0x2371
#define regDP2_DP_LINK_FRAMING_CNTL_BASE_IDX                                                            2
#define regDP2_DP_HBR2_EYE_PATTERN                                                                      0x2372
#define regDP2_DP_HBR2_EYE_PATTERN_BASE_IDX                                                             2
#define regDP2_DP_VID_MSA_VBID                                                                          0x2373
#define regDP2_DP_VID_MSA_VBID_BASE_IDX                                                                 2
#define regDP2_DP_VID_INTERRUPT_CNTL                                                                    0x2374
#define regDP2_DP_VID_INTERRUPT_CNTL_BASE_IDX                                                           2
#define regDP2_DP_DPHY_CNTL                                                                             0x2375
#define regDP2_DP_DPHY_CNTL_BASE_IDX                                                                    2
#define regDP2_DP_DPHY_TRAINING_PATTERN_SEL                                                             0x2376
#define regDP2_DP_DPHY_TRAINING_PATTERN_SEL_BASE_IDX                                                    2
#define regDP2_DP_DPHY_SYM0                                                                             0x2377
#define regDP2_DP_DPHY_SYM0_BASE_IDX                                                                    2
#define regDP2_DP_DPHY_SYM1                                                                             0x2378
#define regDP2_DP_DPHY_SYM1_BASE_IDX                                                                    2
#define regDP2_DP_DPHY_SYM2                                                                             0x2379
#define regDP2_DP_DPHY_SYM2_BASE_IDX                                                                    2
#define regDP2_DP_DPHY_8B10B_CNTL                                                                       0x237a
#define regDP2_DP_DPHY_8B10B_CNTL_BASE_IDX                                                              2
#define regDP2_DP_DPHY_PRBS_CNTL                                                                        0x237b
#define regDP2_DP_DPHY_PRBS_CNTL_BASE_IDX                                                               2
#define regDP2_DP_DPHY_SCRAM_CNTL                                                                       0x237c
#define regDP2_DP_DPHY_SCRAM_CNTL_BASE_IDX                                                              2
#define regDP2_DP_DPHY_CRC_EN                                                                           0x237d
#define regDP2_DP_DPHY_CRC_EN_BASE_IDX                                                                  2
#define regDP2_DP_DPHY_CRC_CNTL                                                                         0x237e
#define regDP2_DP_DPHY_CRC_CNTL_BASE_IDX                                                                2
#define regDP2_DP_DPHY_CRC_RESULT                                                                       0x237f
#define regDP2_DP_DPHY_CRC_RESULT_BASE_IDX                                                              2
#define regDP2_DP_DPHY_CRC_MST_CNTL                                                                     0x2380
#define regDP2_DP_DPHY_CRC_MST_CNTL_BASE_IDX                                                            2
#define regDP2_DP_DPHY_CRC_MST_STATUS                                                                   0x2381
#define regDP2_DP_DPHY_CRC_MST_STATUS_BASE_IDX                                                          2
#define regDP2_DP_DPHY_FAST_TRAINING                                                                    0x2382
#define regDP2_DP_DPHY_FAST_TRAINING_BASE_IDX                                                           2
#define regDP2_DP_DPHY_FAST_TRAINING_STATUS                                                             0x2383
#define regDP2_DP_DPHY_FAST_TRAINING_STATUS_BASE_IDX                                                    2
#define regDP2_DP_SEC_CNTL                                                                              0x2389
#define regDP2_DP_SEC_CNTL_BASE_IDX                                                                     2
#define regDP2_DP_SEC_CNTL1                                                                             0x238a
#define regDP2_DP_SEC_CNTL1_BASE_IDX                                                                    2
#define regDP2_DP_SEC_FRAMING1                                                                          0x238b
#define regDP2_DP_SEC_FRAMING1_BASE_IDX                                                                 2
#define regDP2_DP_SEC_FRAMING2                                                                          0x238c
#define regDP2_DP_SEC_FRAMING2_BASE_IDX                                                                 2
#define regDP2_DP_SEC_FRAMING3                                                                          0x238d
#define regDP2_DP_SEC_FRAMING3_BASE_IDX                                                                 2
#define regDP2_DP_SEC_FRAMING4                                                                          0x238e
#define regDP2_DP_SEC_FRAMING4_BASE_IDX                                                                 2
#define regDP2_DP_SEC_AUD_N                                                                             0x238f
#define regDP2_DP_SEC_AUD_N_BASE_IDX                                                                    2
#define regDP2_DP_SEC_AUD_N_READBACK                                                                    0x2390
#define regDP2_DP_SEC_AUD_N_READBACK_BASE_IDX                                                           2
#define regDP2_DP_SEC_AUD_M                                                                             0x2391
#define regDP2_DP_SEC_AUD_M_BASE_IDX                                                                    2
#define regDP2_DP_SEC_AUD_M_READBACK                                                                    0x2392
#define regDP2_DP_SEC_AUD_M_READBACK_BASE_IDX                                                           2
#define regDP2_DP_SEC_TIMESTAMP                                                                         0x2393
#define regDP2_DP_SEC_TIMESTAMP_BASE_IDX                                                                2
#define regDP2_DP_SEC_PACKET_CNTL                                                                       0x2394
#define regDP2_DP_SEC_PACKET_CNTL_BASE_IDX                                                              2
#define regDP2_DP_MSE_RATE_CNTL                                                                         0x2395
#define regDP2_DP_MSE_RATE_CNTL_BASE_IDX                                                                2
#define regDP2_DP_MSE_RATE_UPDATE                                                                       0x2397
#define regDP2_DP_MSE_RATE_UPDATE_BASE_IDX                                                              2
#define regDP2_DP_MSE_SAT0                                                                              0x2398
#define regDP2_DP_MSE_SAT0_BASE_IDX                                                                     2
#define regDP2_DP_MSE_SAT1                                                                              0x2399
#define regDP2_DP_MSE_SAT1_BASE_IDX                                                                     2
#define regDP2_DP_MSE_SAT2                                                                              0x239a
#define regDP2_DP_MSE_SAT2_BASE_IDX                                                                     2
#define regDP2_DP_MSE_SAT_UPDATE                                                                        0x239b
#define regDP2_DP_MSE_SAT_UPDATE_BASE_IDX                                                               2
#define regDP2_DP_MSE_LINK_TIMING                                                                       0x239c
#define regDP2_DP_MSE_LINK_TIMING_BASE_IDX                                                              2
#define regDP2_DP_MSE_MISC_CNTL                                                                         0x239d
#define regDP2_DP_MSE_MISC_CNTL_BASE_IDX                                                                2
#define regDP2_DP_DPHY_BS_SR_SWAP_CNTL                                                                  0x23a2
#define regDP2_DP_DPHY_BS_SR_SWAP_CNTL_BASE_IDX                                                         2
#define regDP2_DP_DPHY_HBR2_PATTERN_CONTROL                                                             0x23a3
#define regDP2_DP_DPHY_HBR2_PATTERN_CONTROL_BASE_IDX                                                    2
#define regDP2_DP_MSE_SAT0_STATUS                                                                       0x23a5
#define regDP2_DP_MSE_SAT0_STATUS_BASE_IDX                                                              2
#define regDP2_DP_MSE_SAT1_STATUS                                                                       0x23a6
#define regDP2_DP_MSE_SAT1_STATUS_BASE_IDX                                                              2
#define regDP2_DP_MSE_SAT2_STATUS                                                                       0x23a7
#define regDP2_DP_MSE_SAT2_STATUS_BASE_IDX                                                              2
#define regDP2_DP_DPIA_SPARE                                                                            0x23a8
#define regDP2_DP_DPIA_SPARE_BASE_IDX                                                                   2
#define regDP2_DP_MSA_TIMING_PARAM1                                                                     0x23aa
#define regDP2_DP_MSA_TIMING_PARAM1_BASE_IDX                                                            2
#define regDP2_DP_MSA_TIMING_PARAM2                                                                     0x23ab
#define regDP2_DP_MSA_TIMING_PARAM2_BASE_IDX                                                            2
#define regDP2_DP_MSA_TIMING_PARAM3                                                                     0x23ac
#define regDP2_DP_MSA_TIMING_PARAM3_BASE_IDX                                                            2
#define regDP2_DP_MSA_TIMING_PARAM4                                                                     0x23ad
#define regDP2_DP_MSA_TIMING_PARAM4_BASE_IDX                                                            2
#define regDP2_DP_MSO_CNTL                                                                              0x23ae
#define regDP2_DP_MSO_CNTL_BASE_IDX                                                                     2
#define regDP2_DP_MSO_CNTL1                                                                             0x23af
#define regDP2_DP_MSO_CNTL1_BASE_IDX                                                                    2
#define regDP2_DP_DSC_CNTL                                                                              0x23b0
#define regDP2_DP_DSC_CNTL_BASE_IDX                                                                     2
#define regDP2_DP_SEC_CNTL2                                                                             0x23b1
#define regDP2_DP_SEC_CNTL2_BASE_IDX                                                                    2
#define regDP2_DP_SEC_CNTL3                                                                             0x23b2
#define regDP2_DP_SEC_CNTL3_BASE_IDX                                                                    2
#define regDP2_DP_SEC_CNTL4                                                                             0x23b3
#define regDP2_DP_SEC_CNTL4_BASE_IDX                                                                    2
#define regDP2_DP_SEC_CNTL5                                                                             0x23b4
#define regDP2_DP_SEC_CNTL5_BASE_IDX                                                                    2
#define regDP2_DP_SEC_CNTL6                                                                             0x23b5
#define regDP2_DP_SEC_CNTL6_BASE_IDX                                                                    2
#define regDP2_DP_SEC_CNTL7                                                                             0x23b6
#define regDP2_DP_SEC_CNTL7_BASE_IDX                                                                    2
#define regDP2_DP_DB_CNTL                                                                               0x23b7
#define regDP2_DP_DB_CNTL_BASE_IDX                                                                      2
#define regDP2_DP_MSA_VBID_MISC                                                                         0x23b8
#define regDP2_DP_MSA_VBID_MISC_BASE_IDX                                                                2
#define regDP2_DP_SEC_METADATA_TRANSMISSION                                                             0x23b9
#define regDP2_DP_SEC_METADATA_TRANSMISSION_BASE_IDX                                                    2
#define regDP2_DP_ALPM_CNTL                                                                             0x23bb
#define regDP2_DP_ALPM_CNTL_BASE_IDX                                                                    2
#define regDP2_DP_GSP8_CNTL                                                                             0x23bc
#define regDP2_DP_GSP8_CNTL_BASE_IDX                                                                    2
#define regDP2_DP_GSP9_CNTL                                                                             0x23bd
#define regDP2_DP_GSP9_CNTL_BASE_IDX                                                                    2
#define regDP2_DP_GSP10_CNTL                                                                            0x23be
#define regDP2_DP_GSP10_CNTL_BASE_IDX                                                                   2
#define regDP2_DP_GSP11_CNTL                                                                            0x23bf
#define regDP2_DP_GSP11_CNTL_BASE_IDX                                                                   2
#define regDP2_DP_GSP_EN_DB_STATUS                                                                      0x23c0
#define regDP2_DP_GSP_EN_DB_STATUS_BASE_IDX                                                             2
#define regDP2_DP_AUXLESS_ALPM_CNTL1                                                                    0x23c1
#define regDP2_DP_AUXLESS_ALPM_CNTL1_BASE_IDX                                                           2
#define regDP2_DP_AUXLESS_ALPM_CNTL2                                                                    0x23c2
#define regDP2_DP_AUXLESS_ALPM_CNTL2_BASE_IDX                                                           2
#define regDP2_DP_AUXLESS_ALPM_CNTL3                                                                    0x23c3
#define regDP2_DP_AUXLESS_ALPM_CNTL3_BASE_IDX                                                           2
#define regDP2_DP_AUXLESS_ALPM_CNTL4                                                                    0x23c4
#define regDP2_DP_AUXLESS_ALPM_CNTL4_BASE_IDX                                                           2
#define regDP2_DP_AUXLESS_ALPM_CNTL5                                                                    0x23c5
#define regDP2_DP_AUXLESS_ALPM_CNTL5_BASE_IDX                                                           2
#define regDP2_DP_STREAM_SYMBOL_COUNT_STATUS                                                            0x23c6
#define regDP2_DP_STREAM_SYMBOL_COUNT_STATUS_BASE_IDX                                                   2
#define regDP2_DP_STREAM_SYMBOL_COUNT_CONTROL                                                           0x23c7
#define regDP2_DP_STREAM_SYMBOL_COUNT_CONTROL_BASE_IDX                                                  2
#define regDP2_DP_LINK_SYMBOL_COUNT_STATUS0                                                             0x23c8
#define regDP2_DP_LINK_SYMBOL_COUNT_STATUS0_BASE_IDX                                                    2
#define regDP2_DP_LINK_SYMBOL_COUNT_STATUS1                                                             0x23c9
#define regDP2_DP_LINK_SYMBOL_COUNT_STATUS1_BASE_IDX                                                    2
#define regDP2_DP_LINK_SYMBOL_COUNT_CONTROL                                                             0x23ca
#define regDP2_DP_LINK_SYMBOL_COUNT_CONTROL_BASE_IDX                                                    2


// addressBlock: dce_dc_dio_dig3_vpg_vpg_dispdec
// base address: 0x16250
#define regVPG3_VPG_GENERIC_PACKET_ACCESS_CTRL                                                          0x23d4
#define regVPG3_VPG_GENERIC_PACKET_ACCESS_CTRL_BASE_IDX                                                 2
#define regVPG3_VPG_GENERIC_PACKET_DATA                                                                 0x23d5
#define regVPG3_VPG_GENERIC_PACKET_DATA_BASE_IDX                                                        2
#define regVPG3_VPG_GSP_FRAME_UPDATE_CTRL                                                               0x23d6
#define regVPG3_VPG_GSP_FRAME_UPDATE_CTRL_BASE_IDX                                                      2
#define regVPG3_VPG_GSP_IMMEDIATE_UPDATE_CTRL                                                           0x23d7
#define regVPG3_VPG_GSP_IMMEDIATE_UPDATE_CTRL_BASE_IDX                                                  2
#define regVPG3_VPG_GENERIC_STATUS                                                                      0x23d8
#define regVPG3_VPG_GENERIC_STATUS_BASE_IDX                                                             2
#define regVPG3_VPG_MEM_PWR                                                                             0x23d9
#define regVPG3_VPG_MEM_PWR_BASE_IDX                                                                    2
#define regVPG3_VPG_ISRC1_2_ACCESS_CTRL                                                                 0x23da
#define regVPG3_VPG_ISRC1_2_ACCESS_CTRL_BASE_IDX                                                        2
#define regVPG3_VPG_ISRC1_2_DATA                                                                        0x23db
#define regVPG3_VPG_ISRC1_2_DATA_BASE_IDX                                                               2
#define regVPG3_VPG_MPEG_INFO0                                                                          0x23dc
#define regVPG3_VPG_MPEG_INFO0_BASE_IDX                                                                 2
#define regVPG3_VPG_MPEG_INFO1                                                                          0x23dd
#define regVPG3_VPG_MPEG_INFO1_BASE_IDX                                                                 2


// addressBlock: dce_dc_dio_dig3_afmt_afmt_dispdec
// base address: 0x1627c
#define regAFMT3_AFMT_ACP                                                                               0x23df
#define regAFMT3_AFMT_ACP_BASE_IDX                                                                      2
#define regAFMT3_AFMT_VBI_PACKET_CONTROL                                                                0x23e0
#define regAFMT3_AFMT_VBI_PACKET_CONTROL_BASE_IDX                                                       2
#define regAFMT3_AFMT_AUDIO_PACKET_CONTROL2                                                             0x23e1
#define regAFMT3_AFMT_AUDIO_PACKET_CONTROL2_BASE_IDX                                                    2
#define regAFMT3_AFMT_AUDIO_INFO0                                                                       0x23e2
#define regAFMT3_AFMT_AUDIO_INFO0_BASE_IDX                                                              2
#define regAFMT3_AFMT_AUDIO_INFO1                                                                       0x23e3
#define regAFMT3_AFMT_AUDIO_INFO1_BASE_IDX                                                              2
#define regAFMT3_AFMT_60958_0                                                                           0x23e4
#define regAFMT3_AFMT_60958_0_BASE_IDX                                                                  2
#define regAFMT3_AFMT_60958_1                                                                           0x23e5
#define regAFMT3_AFMT_60958_1_BASE_IDX                                                                  2
#define regAFMT3_AFMT_AUDIO_CRC_CONTROL                                                                 0x23e6
#define regAFMT3_AFMT_AUDIO_CRC_CONTROL_BASE_IDX                                                        2
#define regAFMT3_AFMT_RAMP_CONTROL0                                                                     0x23e7
#define regAFMT3_AFMT_RAMP_CONTROL0_BASE_IDX                                                            2
#define regAFMT3_AFMT_RAMP_CONTROL1                                                                     0x23e8
#define regAFMT3_AFMT_RAMP_CONTROL1_BASE_IDX                                                            2
#define regAFMT3_AFMT_RAMP_CONTROL2                                                                     0x23e9
#define regAFMT3_AFMT_RAMP_CONTROL2_BASE_IDX                                                            2
#define regAFMT3_AFMT_RAMP_CONTROL3                                                                     0x23ea
#define regAFMT3_AFMT_RAMP_CONTROL3_BASE_IDX                                                            2
#define regAFMT3_AFMT_60958_2                                                                           0x23eb
#define regAFMT3_AFMT_60958_2_BASE_IDX                                                                  2
#define regAFMT3_AFMT_AUDIO_CRC_RESULT                                                                  0x23ec
#define regAFMT3_AFMT_AUDIO_CRC_RESULT_BASE_IDX                                                         2
#define regAFMT3_AFMT_STATUS                                                                            0x23ed
#define regAFMT3_AFMT_STATUS_BASE_IDX                                                                   2
#define regAFMT3_AFMT_AUDIO_PACKET_CONTROL                                                              0x23ee
#define regAFMT3_AFMT_AUDIO_PACKET_CONTROL_BASE_IDX                                                     2
#define regAFMT3_AFMT_INFOFRAME_CONTROL0                                                                0x23ef
#define regAFMT3_AFMT_INFOFRAME_CONTROL0_BASE_IDX                                                       2
#define regAFMT3_AFMT_INTERRUPT_STATUS                                                                  0x23f0
#define regAFMT3_AFMT_INTERRUPT_STATUS_BASE_IDX                                                         2
#define regAFMT3_AFMT_AUDIO_SRC_CONTROL                                                                 0x23f1
#define regAFMT3_AFMT_AUDIO_SRC_CONTROL_BASE_IDX                                                        2
#define regAFMT3_AFMT_MEM_PWR                                                                           0x23f3
#define regAFMT3_AFMT_MEM_PWR_BASE_IDX                                                                  2


// addressBlock: dce_dc_dio_dig3_dme_dme_dispdec
// base address: 0x162f4
#define regDME3_DME_CONTROL                                                                             0x23fd
#define regDME3_DME_CONTROL_BASE_IDX                                                                    2
#define regDME3_DME_MEMORY_CONTROL                                                                      0x23fe
#define regDME3_DME_MEMORY_CONTROL_BASE_IDX                                                             2


// addressBlock: dce_dc_dio_dig3_dispdec
// base address: 0xdb0
#define regDIG3_DIG_FE_CNTL                                                                             0x23ff
#define regDIG3_DIG_FE_CNTL_BASE_IDX                                                                    2
#define regDIG3_DIG_FE_CLK_CNTL                                                                         0x2400
#define regDIG3_DIG_FE_CLK_CNTL_BASE_IDX                                                                2
#define regDIG3_DIG_FE_EN_CNTL                                                                          0x2401
#define regDIG3_DIG_FE_EN_CNTL_BASE_IDX                                                                 2
#define regDIG3_DIG_OUTPUT_CRC_CNTL                                                                     0x2402
#define regDIG3_DIG_OUTPUT_CRC_CNTL_BASE_IDX                                                            2
#define regDIG3_DIG_OUTPUT_CRC_RESULT                                                                   0x2403
#define regDIG3_DIG_OUTPUT_CRC_RESULT_BASE_IDX                                                          2
#define regDIG3_DIG_CLOCK_PATTERN                                                                       0x2404
#define regDIG3_DIG_CLOCK_PATTERN_BASE_IDX                                                              2
#define regDIG3_DIG_TEST_PATTERN                                                                        0x2405
#define regDIG3_DIG_TEST_PATTERN_BASE_IDX                                                               2
#define regDIG3_DIG_RANDOM_PATTERN_SEED                                                                 0x2406
#define regDIG3_DIG_RANDOM_PATTERN_SEED_BASE_IDX                                                        2
#define regDIG3_DIG_FIFO_CTRL0                                                                          0x2407
#define regDIG3_DIG_FIFO_CTRL0_BASE_IDX                                                                 2
#define regDIG3_DIG_FIFO_CTRL1                                                                          0x2408
#define regDIG3_DIG_FIFO_CTRL1_BASE_IDX                                                                 2
#define regDIG3_HDMI_METADATA_PACKET_CONTROL                                                            0x2409
#define regDIG3_HDMI_METADATA_PACKET_CONTROL_BASE_IDX                                                   2
#define regDIG3_HDMI_CONTROL                                                                            0x240a
#define regDIG3_HDMI_CONTROL_BASE_IDX                                                                   2
#define regDIG3_HDMI_STATUS                                                                             0x240b
#define regDIG3_HDMI_STATUS_BASE_IDX                                                                    2
#define regDIG3_HDMI_AUDIO_PACKET_CONTROL                                                               0x240c
#define regDIG3_HDMI_AUDIO_PACKET_CONTROL_BASE_IDX                                                      2
#define regDIG3_HDMI_ACR_PACKET_CONTROL                                                                 0x240d
#define regDIG3_HDMI_ACR_PACKET_CONTROL_BASE_IDX                                                        2
#define regDIG3_HDMI_VBI_PACKET_CONTROL                                                                 0x240e
#define regDIG3_HDMI_VBI_PACKET_CONTROL_BASE_IDX                                                        2
#define regDIG3_HDMI_INFOFRAME_CONTROL0                                                                 0x240f
#define regDIG3_HDMI_INFOFRAME_CONTROL0_BASE_IDX                                                        2
#define regDIG3_HDMI_INFOFRAME_CONTROL1                                                                 0x2410
#define regDIG3_HDMI_INFOFRAME_CONTROL1_BASE_IDX                                                        2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL0                                                            0x2411
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL0_BASE_IDX                                                   2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL6                                                            0x2412
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL6_BASE_IDX                                                   2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL5                                                            0x2413
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL5_BASE_IDX                                                   2
#define regDIG3_HDMI_GC                                                                                 0x2414
#define regDIG3_HDMI_GC_BASE_IDX                                                                        2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL1                                                            0x2415
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL1_BASE_IDX                                                   2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL2                                                            0x2416
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL2_BASE_IDX                                                   2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL3                                                            0x2417
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL3_BASE_IDX                                                   2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL4                                                            0x2418
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL4_BASE_IDX                                                   2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL7                                                            0x2419
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL7_BASE_IDX                                                   2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL8                                                            0x241a
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL8_BASE_IDX                                                   2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL9                                                            0x241b
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL9_BASE_IDX                                                   2
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL10                                                           0x241c
#define regDIG3_HDMI_GENERIC_PACKET_CONTROL10_BASE_IDX                                                  2
#define regDIG3_HDMI_DB_CONTROL                                                                         0x241d
#define regDIG3_HDMI_DB_CONTROL_BASE_IDX                                                                2
#define regDIG3_HDMI_ACR_32_0                                                                           0x241e
#define regDIG3_HDMI_ACR_32_0_BASE_IDX                                                                  2
#define regDIG3_HDMI_ACR_32_1                                                                           0x241f
#define regDIG3_HDMI_ACR_32_1_BASE_IDX                                                                  2
#define regDIG3_HDMI_ACR_44_0                                                                           0x2420
#define regDIG3_HDMI_ACR_44_0_BASE_IDX                                                                  2
#define regDIG3_HDMI_ACR_44_1                                                                           0x2421
#define regDIG3_HDMI_ACR_44_1_BASE_IDX                                                                  2
#define regDIG3_HDMI_ACR_48_0                                                                           0x2422
#define regDIG3_HDMI_ACR_48_0_BASE_IDX                                                                  2
#define regDIG3_HDMI_ACR_48_1                                                                           0x2423
#define regDIG3_HDMI_ACR_48_1_BASE_IDX                                                                  2
#define regDIG3_HDMI_ACR_STATUS_0                                                                       0x2424
#define regDIG3_HDMI_ACR_STATUS_0_BASE_IDX                                                              2
#define regDIG3_HDMI_ACR_STATUS_1                                                                       0x2425
#define regDIG3_HDMI_ACR_STATUS_1_BASE_IDX                                                              2
#define regDIG3_AFMT_CNTL                                                                               0x2426
#define regDIG3_AFMT_CNTL_BASE_IDX                                                                      2
#define regDIG3_DIG_BE_CLK_CNTL                                                                         0x2427
#define regDIG3_DIG_BE_CLK_CNTL_BASE_IDX                                                                2
#define regDIG3_DIG_BE_CNTL                                                                             0x2428
#define regDIG3_DIG_BE_CNTL_BASE_IDX                                                                    2
#define regDIG3_DIG_BE_EN_CNTL                                                                          0x2429
#define regDIG3_DIG_BE_EN_CNTL_BASE_IDX                                                                 2
#define regDIG3_TMDS_CNTL                                                                               0x2450
#define regDIG3_TMDS_CNTL_BASE_IDX                                                                      2
#define regDIG3_TMDS_CONTROL_CHAR                                                                       0x2451
#define regDIG3_TMDS_CONTROL_CHAR_BASE_IDX                                                              2
#define regDIG3_TMDS_CONTROL0_FEEDBACK                                                                  0x2452
#define regDIG3_TMDS_CONTROL0_FEEDBACK_BASE_IDX                                                         2
#define regDIG3_TMDS_STEREOSYNC_CTL_SEL                                                                 0x2453
#define regDIG3_TMDS_STEREOSYNC_CTL_SEL_BASE_IDX                                                        2
#define regDIG3_TMDS_SYNC_CHAR_PATTERN_0_1                                                              0x2454
#define regDIG3_TMDS_SYNC_CHAR_PATTERN_0_1_BASE_IDX                                                     2
#define regDIG3_TMDS_SYNC_CHAR_PATTERN_2_3                                                              0x2455
#define regDIG3_TMDS_SYNC_CHAR_PATTERN_2_3_BASE_IDX                                                     2
#define regDIG3_TMDS_CTL_BITS                                                                           0x2457
#define regDIG3_TMDS_CTL_BITS_BASE_IDX                                                                  2
#define regDIG3_TMDS_DCBALANCER_CONTROL                                                                 0x2458
#define regDIG3_TMDS_DCBALANCER_CONTROL_BASE_IDX                                                        2
#define regDIG3_TMDS_SYNC_DCBALANCE_CHAR                                                                0x2459
#define regDIG3_TMDS_SYNC_DCBALANCE_CHAR_BASE_IDX                                                       2
#define regDIG3_TMDS_CTL0_1_GEN_CNTL                                                                    0x245a
#define regDIG3_TMDS_CTL0_1_GEN_CNTL_BASE_IDX                                                           2
#define regDIG3_TMDS_CTL2_3_GEN_CNTL                                                                    0x245b
#define regDIG3_TMDS_CTL2_3_GEN_CNTL_BASE_IDX                                                           2
#define regDIG3_DIG_VERSION                                                                             0x245d
#define regDIG3_DIG_VERSION_BASE_IDX                                                                    2


// addressBlock: dce_dc_dio_dp3_dispdec
// base address: 0xdb0
#define regDP3_DP_LINK_CNTL                                                                             0x248a
#define regDP3_DP_LINK_CNTL_BASE_IDX                                                                    2
#define regDP3_DP_PIXEL_FORMAT                                                                          0x248b
#define regDP3_DP_PIXEL_FORMAT_BASE_IDX                                                                 2
#define regDP3_DP_MSA_COLORIMETRY                                                                       0x248c
#define regDP3_DP_MSA_COLORIMETRY_BASE_IDX                                                              2
#define regDP3_DP_CONFIG                                                                                0x248d
#define regDP3_DP_CONFIG_BASE_IDX                                                                       2
#define regDP3_DP_VID_STREAM_CNTL                                                                       0x248e
#define regDP3_DP_VID_STREAM_CNTL_BASE_IDX                                                              2
#define regDP3_DP_STEER_FIFO                                                                            0x248f
#define regDP3_DP_STEER_FIFO_BASE_IDX                                                                   2
#define regDP3_DP_MSA_MISC                                                                              0x2490
#define regDP3_DP_MSA_MISC_BASE_IDX                                                                     2
#define regDP3_DP_DPHY_INTERNAL_CTRL                                                                    0x2491
#define regDP3_DP_DPHY_INTERNAL_CTRL_BASE_IDX                                                           2
#define regDP3_DP_VID_TIMING                                                                            0x2492
#define regDP3_DP_VID_TIMING_BASE_IDX                                                                   2
#define regDP3_DP_VID_N                                                                                 0x2493
#define regDP3_DP_VID_N_BASE_IDX                                                                        2
#define regDP3_DP_VID_M                                                                                 0x2494
#define regDP3_DP_VID_M_BASE_IDX                                                                        2
#define regDP3_DP_LINK_FRAMING_CNTL                                                                     0x2495
#define regDP3_DP_LINK_FRAMING_CNTL_BASE_IDX                                                            2
#define regDP3_DP_HBR2_EYE_PATTERN                                                                      0x2496
#define regDP3_DP_HBR2_EYE_PATTERN_BASE_IDX                                                             2
#define regDP3_DP_VID_MSA_VBID                                                                          0x2497
#define regDP3_DP_VID_MSA_VBID_BASE_IDX                                                                 2
#define regDP3_DP_VID_INTERRUPT_CNTL                                                                    0x2498
#define regDP3_DP_VID_INTERRUPT_CNTL_BASE_IDX                                                           2
#define regDP3_DP_DPHY_CNTL                                                                             0x2499
#define regDP3_DP_DPHY_CNTL_BASE_IDX                                                                    2
#define regDP3_DP_DPHY_TRAINING_PATTERN_SEL                                                             0x249a
#define regDP3_DP_DPHY_TRAINING_PATTERN_SEL_BASE_IDX                                                    2
#define regDP3_DP_DPHY_SYM0                                                                             0x249b
#define regDP3_DP_DPHY_SYM0_BASE_IDX                                                                    2
#define regDP3_DP_DPHY_SYM1                                                                             0x249c
#define regDP3_DP_DPHY_SYM1_BASE_IDX                                                                    2
#define regDP3_DP_DPHY_SYM2                                                                             0x249d
#define regDP3_DP_DPHY_SYM2_BASE_IDX                                                                    2
#define regDP3_DP_DPHY_8B10B_CNTL                                                                       0x249e
#define regDP3_DP_DPHY_8B10B_CNTL_BASE_IDX                                                              2
#define regDP3_DP_DPHY_PRBS_CNTL                                                                        0x249f
#define regDP3_DP_DPHY_PRBS_CNTL_BASE_IDX                                                               2
#define regDP3_DP_DPHY_SCRAM_CNTL                                                                       0x24a0
#define regDP3_DP_DPHY_SCRAM_CNTL_BASE_IDX                                                              2
#define regDP3_DP_DPHY_CRC_EN                                                                           0x24a1
#define regDP3_DP_DPHY_CRC_EN_BASE_IDX                                                                  2
#define regDP3_DP_DPHY_CRC_CNTL                                                                         0x24a2
#define regDP3_DP_DPHY_CRC_CNTL_BASE_IDX                                                                2
#define regDP3_DP_DPHY_CRC_RESULT                                                                       0x24a3
#define regDP3_DP_DPHY_CRC_RESULT_BASE_IDX                                                              2
#define regDP3_DP_DPHY_CRC_MST_CNTL                                                                     0x24a4
#define regDP3_DP_DPHY_CRC_MST_CNTL_BASE_IDX                                                            2
#define regDP3_DP_DPHY_CRC_MST_STATUS                                                                   0x24a5
#define regDP3_DP_DPHY_CRC_MST_STATUS_BASE_IDX                                                          2
#define regDP3_DP_DPHY_FAST_TRAINING                                                                    0x24a6
#define regDP3_DP_DPHY_FAST_TRAINING_BASE_IDX                                                           2
#define regDP3_DP_DPHY_FAST_TRAINING_STATUS                                                             0x24a7
#define regDP3_DP_DPHY_FAST_TRAINING_STATUS_BASE_IDX                                                    2
#define regDP3_DP_SEC_CNTL                                                                              0x24ad
#define regDP3_DP_SEC_CNTL_BASE_IDX                                                                     2
#define regDP3_DP_SEC_CNTL1                                                                             0x24ae
#define regDP3_DP_SEC_CNTL1_BASE_IDX                                                                    2
#define regDP3_DP_SEC_FRAMING1                                                                          0x24af
#define regDP3_DP_SEC_FRAMING1_BASE_IDX                                                                 2
#define regDP3_DP_SEC_FRAMING2                                                                          0x24b0
#define regDP3_DP_SEC_FRAMING2_BASE_IDX                                                                 2
#define regDP3_DP_SEC_FRAMING3                                                                          0x24b1
#define regDP3_DP_SEC_FRAMING3_BASE_IDX                                                                 2
#define regDP3_DP_SEC_FRAMING4                                                                          0x24b2
#define regDP3_DP_SEC_FRAMING4_BASE_IDX                                                                 2
#define regDP3_DP_SEC_AUD_N                                                                             0x24b3
#define regDP3_DP_SEC_AUD_N_BASE_IDX                                                                    2
#define regDP3_DP_SEC_AUD_N_READBACK                                                                    0x24b4
#define regDP3_DP_SEC_AUD_N_READBACK_BASE_IDX                                                           2
#define regDP3_DP_SEC_AUD_M                                                                             0x24b5
#define regDP3_DP_SEC_AUD_M_BASE_IDX                                                                    2
#define regDP3_DP_SEC_AUD_M_READBACK                                                                    0x24b6
#define regDP3_DP_SEC_AUD_M_READBACK_BASE_IDX                                                           2
#define regDP3_DP_SEC_TIMESTAMP                                                                         0x24b7
#define regDP3_DP_SEC_TIMESTAMP_BASE_IDX                                                                2
#define regDP3_DP_SEC_PACKET_CNTL                                                                       0x24b8
#define regDP3_DP_SEC_PACKET_CNTL_BASE_IDX                                                              2
#define regDP3_DP_MSE_RATE_CNTL                                                                         0x24b9
#define regDP3_DP_MSE_RATE_CNTL_BASE_IDX                                                                2
#define regDP3_DP_MSE_RATE_UPDATE                                                                       0x24bb
#define regDP3_DP_MSE_RATE_UPDATE_BASE_IDX                                                              2
#define regDP3_DP_MSE_SAT0                                                                              0x24bc
#define regDP3_DP_MSE_SAT0_BASE_IDX                                                                     2
#define regDP3_DP_MSE_SAT1                                                                              0x24bd
#define regDP3_DP_MSE_SAT1_BASE_IDX                                                                     2
#define regDP3_DP_MSE_SAT2                                                                              0x24be
#define regDP3_DP_MSE_SAT2_BASE_IDX                                                                     2
#define regDP3_DP_MSE_SAT_UPDATE                                                                        0x24bf
#define regDP3_DP_MSE_SAT_UPDATE_BASE_IDX                                                               2
#define regDP3_DP_MSE_LINK_TIMING                                                                       0x24c0
#define regDP3_DP_MSE_LINK_TIMING_BASE_IDX                                                              2
#define regDP3_DP_MSE_MISC_CNTL                                                                         0x24c1
#define regDP3_DP_MSE_MISC_CNTL_BASE_IDX                                                                2
#define regDP3_DP_DPHY_BS_SR_SWAP_CNTL                                                                  0x24c6
#define regDP3_DP_DPHY_BS_SR_SWAP_CNTL_BASE_IDX                                                         2
#define regDP3_DP_DPHY_HBR2_PATTERN_CONTROL                                                             0x24c7
#define regDP3_DP_DPHY_HBR2_PATTERN_CONTROL_BASE_IDX                                                    2
#define regDP3_DP_MSE_SAT0_STATUS                                                                       0x24c9
#define regDP3_DP_MSE_SAT0_STATUS_BASE_IDX                                                              2
#define regDP3_DP_MSE_SAT1_STATUS                                                                       0x24ca
#define regDP3_DP_MSE_SAT1_STATUS_BASE_IDX                                                              2
#define regDP3_DP_MSE_SAT2_STATUS                                                                       0x24cb
#define regDP3_DP_MSE_SAT2_STATUS_BASE_IDX                                                              2
#define regDP3_DP_DPIA_SPARE                                                                            0x24cc
#define regDP3_DP_DPIA_SPARE_BASE_IDX                                                                   2
#define regDP3_DP_MSA_TIMING_PARAM1                                                                     0x24ce
#define regDP3_DP_MSA_TIMING_PARAM1_BASE_IDX                                                            2
#define regDP3_DP_MSA_TIMING_PARAM2                                                                     0x24cf
#define regDP3_DP_MSA_TIMING_PARAM2_BASE_IDX                                                            2
#define regDP3_DP_MSA_TIMING_PARAM3                                                                     0x24d0
#define regDP3_DP_MSA_TIMING_PARAM3_BASE_IDX                                                            2
#define regDP3_DP_MSA_TIMING_PARAM4                                                                     0x24d1
#define regDP3_DP_MSA_TIMING_PARAM4_BASE_IDX                                                            2
#define regDP3_DP_MSO_CNTL                                                                              0x24d2
#define regDP3_DP_MSO_CNTL_BASE_IDX                                                                     2
#define regDP3_DP_MSO_CNTL1                                                                             0x24d3
#define regDP3_DP_MSO_CNTL1_BASE_IDX                                                                    2
#define regDP3_DP_DSC_CNTL                                                                              0x24d4
#define regDP3_DP_DSC_CNTL_BASE_IDX                                                                     2
#define regDP3_DP_SEC_CNTL2                                                                             0x24d5
#define regDP3_DP_SEC_CNTL2_BASE_IDX                                                                    2
#define regDP3_DP_SEC_CNTL3                                                                             0x24d6
#define regDP3_DP_SEC_CNTL3_BASE_IDX                                                                    2
#define regDP3_DP_SEC_CNTL4                                                                             0x24d7
#define regDP3_DP_SEC_CNTL4_BASE_IDX                                                                    2
#define regDP3_DP_SEC_CNTL5                                                                             0x24d8
#define regDP3_DP_SEC_CNTL5_BASE_IDX                                                                    2
#define regDP3_DP_SEC_CNTL6                                                                             0x24d9
#define regDP3_DP_SEC_CNTL6_BASE_IDX                                                                    2
#define regDP3_DP_SEC_CNTL7                                                                             0x24da
#define regDP3_DP_SEC_CNTL7_BASE_IDX                                                                    2
#define regDP3_DP_DB_CNTL                                                                               0x24db
#define regDP3_DP_DB_CNTL_BASE_IDX                                                                      2
#define regDP3_DP_MSA_VBID_MISC                                                                         0x24dc
#define regDP3_DP_MSA_VBID_MISC_BASE_IDX                                                                2
#define regDP3_DP_SEC_METADATA_TRANSMISSION                                                             0x24dd
#define regDP3_DP_SEC_METADATA_TRANSMISSION_BASE_IDX                                                    2
#define regDP3_DP_ALPM_CNTL                                                                             0x24df
#define regDP3_DP_ALPM_CNTL_BASE_IDX                                                                    2
#define regDP3_DP_GSP8_CNTL                                                                             0x24e0
#define regDP3_DP_GSP8_CNTL_BASE_IDX                                                                    2
#define regDP3_DP_GSP9_CNTL                                                                             0x24e1
#define regDP3_DP_GSP9_CNTL_BASE_IDX                                                                    2
#define regDP3_DP_GSP10_CNTL                                                                            0x24e2
#define regDP3_DP_GSP10_CNTL_BASE_IDX                                                                   2
#define regDP3_DP_GSP11_CNTL                                                                            0x24e3
#define regDP3_DP_GSP11_CNTL_BASE_IDX                                                                   2
#define regDP3_DP_GSP_EN_DB_STATUS                                                                      0x24e4
#define regDP3_DP_GSP_EN_DB_STATUS_BASE_IDX                                                             2
#define regDP3_DP_AUXLESS_ALPM_CNTL1                                                                    0x24e5
#define regDP3_DP_AUXLESS_ALPM_CNTL1_BASE_IDX                                                           2
#define regDP3_DP_AUXLESS_ALPM_CNTL2                                                                    0x24e6
#define regDP3_DP_AUXLESS_ALPM_CNTL2_BASE_IDX                                                           2
#define regDP3_DP_AUXLESS_ALPM_CNTL3                                                                    0x24e7
#define regDP3_DP_AUXLESS_ALPM_CNTL3_BASE_IDX                                                           2
#define regDP3_DP_AUXLESS_ALPM_CNTL4                                                                    0x24e8
#define regDP3_DP_AUXLESS_ALPM_CNTL4_BASE_IDX                                                           2
#define regDP3_DP_AUXLESS_ALPM_CNTL5                                                                    0x24e9
#define regDP3_DP_AUXLESS_ALPM_CNTL5_BASE_IDX                                                           2
#define regDP3_DP_STREAM_SYMBOL_COUNT_STATUS                                                            0x24ea
#define regDP3_DP_STREAM_SYMBOL_COUNT_STATUS_BASE_IDX                                                   2
#define regDP3_DP_STREAM_SYMBOL_COUNT_CONTROL                                                           0x24eb
#define regDP3_DP_STREAM_SYMBOL_COUNT_CONTROL_BASE_IDX                                                  2
#define regDP3_DP_LINK_SYMBOL_COUNT_STATUS0                                                             0x24ec
#define regDP3_DP_LINK_SYMBOL_COUNT_STATUS0_BASE_IDX                                                    2
#define regDP3_DP_LINK_SYMBOL_COUNT_STATUS1                                                             0x24ed
#define regDP3_DP_LINK_SYMBOL_COUNT_STATUS1_BASE_IDX                                                    2
#define regDP3_DP_LINK_SYMBOL_COUNT_CONTROL                                                             0x24ee
#define regDP3_DP_LINK_SYMBOL_COUNT_CONTROL_BASE_IDX                                                    2


// addressBlock: dce_dc_dio_dig4_vpg_vpg_dispdec
// base address: 0x166e0
#define regVPG4_VPG_GENERIC_PACKET_ACCESS_CTRL                                                          0x24f8
#define regVPG4_VPG_GENERIC_PACKET_ACCESS_CTRL_BASE_IDX                                                 2
#define regVPG4_VPG_GENERIC_PACKET_DATA                                                                 0x24f9
#define regVPG4_VPG_GENERIC_PACKET_DATA_BASE_IDX                                                        2
#define regVPG4_VPG_GSP_FRAME_UPDATE_CTRL                                                               0x24fa
#define regVPG4_VPG_GSP_FRAME_UPDATE_CTRL_BASE_IDX                                                      2
#define regVPG4_VPG_GSP_IMMEDIATE_UPDATE_CTRL                                                           0x24fb
#define regVPG4_VPG_GSP_IMMEDIATE_UPDATE_CTRL_BASE_IDX                                                  2
#define regVPG4_VPG_GENERIC_STATUS                                                                      0x24fc
#define regVPG4_VPG_GENERIC_STATUS_BASE_IDX                                                             2
#define regVPG4_VPG_MEM_PWR                                                                             0x24fd
#define regVPG4_VPG_MEM_PWR_BASE_IDX                                                                    2
#define regVPG4_VPG_ISRC1_2_ACCESS_CTRL                                                                 0x24fe
#define regVPG4_VPG_ISRC1_2_ACCESS_CTRL_BASE_IDX                                                        2
#define regVPG4_VPG_ISRC1_2_DATA                                                                        0x24ff
#define regVPG4_VPG_ISRC1_2_DATA_BASE_IDX                                                               2
#define regVPG4_VPG_MPEG_INFO0                                                                          0x2500
#define regVPG4_VPG_MPEG_INFO0_BASE_IDX                                                                 2
#define regVPG4_VPG_MPEG_INFO1                                                                          0x2501
#define regVPG4_VPG_MPEG_INFO1_BASE_IDX                                                                 2


// addressBlock: dce_dc_dio_dig4_afmt_afmt_dispdec
// base address: 0x1670c
#define regAFMT4_AFMT_ACP                                                                               0x2503
#define regAFMT4_AFMT_ACP_BASE_IDX                                                                      2
#define regAFMT4_AFMT_VBI_PACKET_CONTROL                                                                0x2504
#define regAFMT4_AFMT_VBI_PACKET_CONTROL_BASE_IDX                                                       2
#define regAFMT4_AFMT_AUDIO_PACKET_CONTROL2                                                             0x2505
#define regAFMT4_AFMT_AUDIO_PACKET_CONTROL2_BASE_IDX                                                    2
#define regAFMT4_AFMT_AUDIO_INFO0                                                                       0x2506
#define regAFMT4_AFMT_AUDIO_INFO0_BASE_IDX                                                              2
#define regAFMT4_AFMT_AUDIO_INFO1                                                                       0x2507
#define regAFMT4_AFMT_AUDIO_INFO1_BASE_IDX                                                              2
#define regAFMT4_AFMT_60958_0                                                                           0x2508
#define regAFMT4_AFMT_60958_0_BASE_IDX                                                                  2
#define regAFMT4_AFMT_60958_1                                                                           0x2509
#define regAFMT4_AFMT_60958_1_BASE_IDX                                                                  2
#define regAFMT4_AFMT_AUDIO_CRC_CONTROL                                                                 0x250a
#define regAFMT4_AFMT_AUDIO_CRC_CONTROL_BASE_IDX                                                        2
#define regAFMT4_AFMT_RAMP_CONTROL0                                                                     0x250b
#define regAFMT4_AFMT_RAMP_CONTROL0_BASE_IDX                                                            2
#define regAFMT4_AFMT_RAMP_CONTROL1                                                                     0x250c
#define regAFMT4_AFMT_RAMP_CONTROL1_BASE_IDX                                                            2
#define regAFMT4_AFMT_RAMP_CONTROL2                                                                     0x250d
#define regAFMT4_AFMT_RAMP_CONTROL2_BASE_IDX                                                            2
#define regAFMT4_AFMT_RAMP_CONTROL3                                                                     0x250e
#define regAFMT4_AFMT_RAMP_CONTROL3_BASE_IDX                                                            2
#define regAFMT4_AFMT_60958_2                                                                           0x250f
#define regAFMT4_AFMT_60958_2_BASE_IDX                                                                  2
#define regAFMT4_AFMT_AUDIO_CRC_RESULT                                                                  0x2510
#define regAFMT4_AFMT_AUDIO_CRC_RESULT_BASE_IDX                                                         2
#define regAFMT4_AFMT_STATUS                                                                            0x2511
#define regAFMT4_AFMT_STATUS_BASE_IDX                                                                   2
#define regAFMT4_AFMT_AUDIO_PACKET_CONTROL                                                              0x2512
#define regAFMT4_AFMT_AUDIO_PACKET_CONTROL_BASE_IDX                                                     2
#define regAFMT4_AFMT_INFOFRAME_CONTROL0                                                                0x2513
#define regAFMT4_AFMT_INFOFRAME_CONTROL0_BASE_IDX                                                       2
#define regAFMT4_AFMT_INTERRUPT_STATUS                                                                  0x2514
#define regAFMT4_AFMT_INTERRUPT_STATUS_BASE_IDX                                                         2
#define regAFMT4_AFMT_AUDIO_SRC_CONTROL                                                                 0x2515
#define regAFMT4_AFMT_AUDIO_SRC_CONTROL_BASE_IDX                                                        2
#define regAFMT4_AFMT_MEM_PWR                                                                           0x2517
#define regAFMT4_AFMT_MEM_PWR_BASE_IDX                                                                  2


// addressBlock: dce_dc_dio_dig4_dme_dme_dispdec
// base address: 0x16784
#define regDME4_DME_CONTROL                                                                             0x2521
#define regDME4_DME_CONTROL_BASE_IDX                                                                    2
#define regDME4_DME_MEMORY_CONTROL                                                                      0x2522
#define regDME4_DME_MEMORY_CONTROL_BASE_IDX                                                             2


// addressBlock: dce_dc_dio_dig4_dispdec
// base address: 0x1240
#define regDIG4_DIG_FE_CNTL                                                                             0x2523
#define regDIG4_DIG_FE_CNTL_BASE_IDX                                                                    2
#define regDIG4_DIG_FE_CLK_CNTL                                                                         0x2524
#define regDIG4_DIG_FE_CLK_CNTL_BASE_IDX                                                                2
#define regDIG4_DIG_FE_EN_CNTL                                                                          0x2525
#define regDIG4_DIG_FE_EN_CNTL_BASE_IDX                                                                 2
#define regDIG4_DIG_OUTPUT_CRC_CNTL                                                                     0x2526
#define regDIG4_DIG_OUTPUT_CRC_CNTL_BASE_IDX                                                            2
#define regDIG4_DIG_OUTPUT_CRC_RESULT                                                                   0x2527
#define regDIG4_DIG_OUTPUT_CRC_RESULT_BASE_IDX                                                          2
#define regDIG4_DIG_CLOCK_PATTERN                                                                       0x2528
#define regDIG4_DIG_CLOCK_PATTERN_BASE_IDX                                                              2
#define regDIG4_DIG_TEST_PATTERN                                                                        0x2529
#define regDIG4_DIG_TEST_PATTERN_BASE_IDX                                                               2
#define regDIG4_DIG_RANDOM_PATTERN_SEED                                                                 0x252a
#define regDIG4_DIG_RANDOM_PATTERN_SEED_BASE_IDX                                                        2
#define regDIG4_DIG_FIFO_CTRL0                                                                          0x252b
#define regDIG4_DIG_FIFO_CTRL0_BASE_IDX                                                                 2
#define regDIG4_DIG_FIFO_CTRL1                                                                          0x252c
#define regDIG4_DIG_FIFO_CTRL1_BASE_IDX                                                                 2
#define regDIG4_HDMI_METADATA_PACKET_CONTROL                                                            0x252d
#define regDIG4_HDMI_METADATA_PACKET_CONTROL_BASE_IDX                                                   2
#define regDIG4_HDMI_CONTROL                                                                            0x252e
#define regDIG4_HDMI_CONTROL_BASE_IDX                                                                   2
#define regDIG4_HDMI_STATUS                                                                             0x252f
#define regDIG4_HDMI_STATUS_BASE_IDX                                                                    2
#define regDIG4_HDMI_AUDIO_PACKET_CONTROL                                                               0x2530
#define regDIG4_HDMI_AUDIO_PACKET_CONTROL_BASE_IDX                                                      2
#define regDIG4_HDMI_ACR_PACKET_CONTROL                                                                 0x2531
#define regDIG4_HDMI_ACR_PACKET_CONTROL_BASE_IDX                                                        2
#define regDIG4_HDMI_VBI_PACKET_CONTROL                                                                 0x2532
#define regDIG4_HDMI_VBI_PACKET_CONTROL_BASE_IDX                                                        2
#define regDIG4_HDMI_INFOFRAME_CONTROL0                                                                 0x2533
#define regDIG4_HDMI_INFOFRAME_CONTROL0_BASE_IDX                                                        2
#define regDIG4_HDMI_INFOFRAME_CONTROL1                                                                 0x2534
#define regDIG4_HDMI_INFOFRAME_CONTROL1_BASE_IDX                                                        2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL0                                                            0x2535
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL0_BASE_IDX                                                   2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL6                                                            0x2536
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL6_BASE_IDX                                                   2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL5                                                            0x2537
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL5_BASE_IDX                                                   2
#define regDIG4_HDMI_GC                                                                                 0x2538
#define regDIG4_HDMI_GC_BASE_IDX                                                                        2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL1                                                            0x2539
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL1_BASE_IDX                                                   2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL2                                                            0x253a
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL2_BASE_IDX                                                   2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL3                                                            0x253b
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL3_BASE_IDX                                                   2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL4                                                            0x253c
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL4_BASE_IDX                                                   2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL7                                                            0x253d
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL7_BASE_IDX                                                   2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL8                                                            0x253e
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL8_BASE_IDX                                                   2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL9                                                            0x253f
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL9_BASE_IDX                                                   2
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL10                                                           0x2540
#define regDIG4_HDMI_GENERIC_PACKET_CONTROL10_BASE_IDX                                                  2
#define regDIG4_HDMI_DB_CONTROL                                                                         0x2541
#define regDIG4_HDMI_DB_CONTROL_BASE_IDX                                                                2
#define regDIG4_HDMI_ACR_32_0                                                                           0x2542
#define regDIG4_HDMI_ACR_32_0_BASE_IDX                                                                  2
#define regDIG4_HDMI_ACR_32_1                                                                           0x2543
#define regDIG4_HDMI_ACR_32_1_BASE_IDX                                                                  2
#define regDIG4_HDMI_ACR_44_0                                                                           0x2544
#define regDIG4_HDMI_ACR_44_0_BASE_IDX                                                                  2
#define regDIG4_HDMI_ACR_44_1                                                                           0x2545
#define regDIG4_HDMI_ACR_44_1_BASE_IDX                                                                  2
#define regDIG4_HDMI_ACR_48_0                                                                           0x2546
#define regDIG4_HDMI_ACR_48_0_BASE_IDX                                                                  2
#define regDIG4_HDMI_ACR_48_1                                                                           0x2547
#define regDIG4_HDMI_ACR_48_1_BASE_IDX                                                                  2
#define regDIG4_HDMI_ACR_STATUS_0                                                                       0x2548
#define regDIG4_HDMI_ACR_STATUS_0_BASE_IDX                                                              2
#define regDIG4_HDMI_ACR_STATUS_1                                                                       0x2549
#define regDIG4_HDMI_ACR_STATUS_1_BASE_IDX                                                              2
#define regDIG4_AFMT_CNTL                                                                               0x254a
#define regDIG4_AFMT_CNTL_BASE_IDX                                                                      2
#define regDIG4_DIG_BE_CLK_CNTL                                                                         0x254b
#define regDIG4_DIG_BE_CLK_CNTL_BASE_IDX                                                                2
#define regDIG4_DIG_BE_CNTL                                                                             0x254c
#define regDIG4_DIG_BE_CNTL_BASE_IDX                                                                    2
#define regDIG4_DIG_BE_EN_CNTL                                                                          0x254d
#define regDIG4_DIG_BE_EN_CNTL_BASE_IDX                                                                 2
#define regDIG4_TMDS_CNTL                                                                               0x2574
#define regDIG4_TMDS_CNTL_BASE_IDX                                                                      2
#define regDIG4_TMDS_CONTROL_CHAR                                                                       0x2575
#define regDIG4_TMDS_CONTROL_CHAR_BASE_IDX                                                              2
#define regDIG4_TMDS_CONTROL0_FEEDBACK                                                                  0x2576
#define regDIG4_TMDS_CONTROL0_FEEDBACK_BASE_IDX                                                         2
#define regDIG4_TMDS_STEREOSYNC_CTL_SEL                                                                 0x2577
#define regDIG4_TMDS_STEREOSYNC_CTL_SEL_BASE_IDX                                                        2
#define regDIG4_TMDS_SYNC_CHAR_PATTERN_0_1                                                              0x2578
#define regDIG4_TMDS_SYNC_CHAR_PATTERN_0_1_BASE_IDX                                                     2
#define regDIG4_TMDS_SYNC_CHAR_PATTERN_2_3                                                              0x2579
#define regDIG4_TMDS_SYNC_CHAR_PATTERN_2_3_BASE_IDX                                                     2
#define regDIG4_TMDS_CTL_BITS                                                                           0x257b
#define regDIG4_TMDS_CTL_BITS_BASE_IDX                                                                  2
#define regDIG4_TMDS_DCBALANCER_CONTROL                                                                 0x257c
#define regDIG4_TMDS_DCBALANCER_CONTROL_BASE_IDX                                                        2
#define regDIG4_TMDS_SYNC_DCBALANCE_CHAR                                                                0x257d
#define regDIG4_TMDS_SYNC_DCBALANCE_CHAR_BASE_IDX                                                       2
#define regDIG4_TMDS_CTL0_1_GEN_CNTL                                                                    0x257e
#define regDIG4_TMDS_CTL0_1_GEN_CNTL_BASE_IDX                                                           2
#define regDIG4_TMDS_CTL2_3_GEN_CNTL                                                                    0x257f
#define regDIG4_TMDS_CTL2_3_GEN_CNTL_BASE_IDX                                                           2
#define regDIG4_DIG_VERSION                                                                             0x2581
#define regDIG4_DIG_VERSION_BASE_IDX                                                                    2


// addressBlock: dce_dc_dio_dp4_dispdec
// base address: 0x1240
#define regDP4_DP_LINK_CNTL                                                                             0x25ae
#define regDP4_DP_LINK_CNTL_BASE_IDX                                                                    2
#define regDP4_DP_PIXEL_FORMAT                                                                          0x25af
#define regDP4_DP_PIXEL_FORMAT_BASE_IDX                                                                 2
#define regDP4_DP_MSA_COLORIMETRY                                                                       0x25b0
#define regDP4_DP_MSA_COLORIMETRY_BASE_IDX                                                              2
#define regDP4_DP_CONFIG                                                                                0x25b1
#define regDP4_DP_CONFIG_BASE_IDX                                                                       2
#define regDP4_DP_VID_STREAM_CNTL                                                                       0x25b2
#define regDP4_DP_VID_STREAM_CNTL_BASE_IDX                                                              2
#define regDP4_DP_STEER_FIFO                                                                            0x25b3
#define regDP4_DP_STEER_FIFO_BASE_IDX                                                                   2
#define regDP4_DP_MSA_MISC                                                                              0x25b4
#define regDP4_DP_MSA_MISC_BASE_IDX                                                                     2
#define regDP4_DP_DPHY_INTERNAL_CTRL                                                                    0x25b5
#define regDP4_DP_DPHY_INTERNAL_CTRL_BASE_IDX                                                           2
#define regDP4_DP_VID_TIMING                                                                            0x25b6
#define regDP4_DP_VID_TIMING_BASE_IDX                                                                   2
#define regDP4_DP_VID_N                                                                                 0x25b7
#define regDP4_DP_VID_N_BASE_IDX                                                                        2
#define regDP4_DP_VID_M                                                                                 0x25b8
#define regDP4_DP_VID_M_BASE_IDX                                                                        2
#define regDP4_DP_LINK_FRAMING_CNTL                                                                     0x25b9
#define regDP4_DP_LINK_FRAMING_CNTL_BASE_IDX                                                            2
#define regDP4_DP_HBR2_EYE_PATTERN                                                                      0x25ba
#define regDP4_DP_HBR2_EYE_PATTERN_BASE_IDX                                                             2
#define regDP4_DP_VID_MSA_VBID                                                                          0x25bb
#define regDP4_DP_VID_MSA_VBID_BASE_IDX                                                                 2
#define regDP4_DP_VID_INTERRUPT_CNTL                                                                    0x25bc
#define regDP4_DP_VID_INTERRUPT_CNTL_BASE_IDX                                                           2
#define regDP4_DP_DPHY_CNTL                                                                             0x25bd
#define regDP4_DP_DPHY_CNTL_BASE_IDX                                                                    2
#define regDP4_DP_DPHY_TRAINING_PATTERN_SEL                                                             0x25be
#define regDP4_DP_DPHY_TRAINING_PATTERN_SEL_BASE_IDX                                                    2
#define regDP4_DP_DPHY_SYM0                                                                             0x25bf
#define regDP4_DP_DPHY_SYM0_BASE_IDX                                                                    2
#define regDP4_DP_DPHY_SYM1                                                                             0x25c0
#define regDP4_DP_DPHY_SYM1_BASE_IDX                                                                    2
#define regDP4_DP_DPHY_SYM2                                                                             0x25c1
#define regDP4_DP_DPHY_SYM2_BASE_IDX                                                                    2
#define regDP4_DP_DPHY_8B10B_CNTL                                                                       0x25c2
#define regDP4_DP_DPHY_8B10B_CNTL_BASE_IDX                                                              2
#define regDP4_DP_DPHY_PRBS_CNTL                                                                        0x25c3
#define regDP4_DP_DPHY_PRBS_CNTL_BASE_IDX                                                               2
#define regDP4_DP_DPHY_SCRAM_CNTL                                                                       0x25c4
#define regDP4_DP_DPHY_SCRAM_CNTL_BASE_IDX                                                              2
#define regDP4_DP_DPHY_CRC_EN                                                                           0x25c5
#define regDP4_DP_DPHY_CRC_EN_BASE_IDX                                                                  2
#define regDP4_DP_DPHY_CRC_CNTL                                                                         0x25c6
#define regDP4_DP_DPHY_CRC_CNTL_BASE_IDX                                                                2
#define regDP4_DP_DPHY_CRC_RESULT                                                                       0x25c7
#define regDP4_DP_DPHY_CRC_RESULT_BASE_IDX                                                              2
#define regDP4_DP_DPHY_CRC_MST_CNTL                                                                     0x25c8
#define regDP4_DP_DPHY_CRC_MST_CNTL_BASE_IDX                                                            2
#define regDP4_DP_DPHY_CRC_MST_STATUS                                                                   0x25c9
#define regDP4_DP_DPHY_CRC_MST_STATUS_BASE_IDX                                                          2
#define regDP4_DP_DPHY_FAST_TRAINING                                                                    0x25ca
#define regDP4_DP_DPHY_FAST_TRAINING_BASE_IDX                                                           2
#define regDP4_DP_DPHY_FAST_TRAINING_STATUS                                                             0x25cb
#define regDP4_DP_DPHY_FAST_TRAINING_STATUS_BASE_IDX                                                    2
#define regDP4_DP_SEC_CNTL                                                                              0x25d1
#define regDP4_DP_SEC_CNTL_BASE_IDX                                                                     2
#define regDP4_DP_SEC_CNTL1                                                                             0x25d2
#define regDP4_DP_SEC_CNTL1_BASE_IDX                                                                    2
#define regDP4_DP_SEC_FRAMING1                                                                          0x25d3
#define regDP4_DP_SEC_FRAMING1_BASE_IDX                                                                 2
#define regDP4_DP_SEC_FRAMING2                                                                          0x25d4
#define regDP4_DP_SEC_FRAMING2_BASE_IDX                                                                 2
#define regDP4_DP_SEC_FRAMING3                                                                          0x25d5
#define regDP4_DP_SEC_FRAMING3_BASE_IDX                                                                 2
#define regDP4_DP_SEC_FRAMING4                                                                          0x25d6
#define regDP4_DP_SEC_FRAMING4_BASE_IDX                                                                 2
#define regDP4_DP_SEC_AUD_N                                                                             0x25d7
#define regDP4_DP_SEC_AUD_N_BASE_IDX                                                                    2
#define regDP4_DP_SEC_AUD_N_READBACK                                                                    0x25d8
#define regDP4_DP_SEC_AUD_N_READBACK_BASE_IDX                                                           2
#define regDP4_DP_SEC_AUD_M                                                                             0x25d9
#define regDP4_DP_SEC_AUD_M_BASE_IDX                                                                    2
#define regDP4_DP_SEC_AUD_M_READBACK                                                                    0x25da
#define regDP4_DP_SEC_AUD_M_READBACK_BASE_IDX                                                           2
#define regDP4_DP_SEC_TIMESTAMP                                                                         0x25db
#define regDP4_DP_SEC_TIMESTAMP_BASE_IDX                                                                2
#define regDP4_DP_SEC_PACKET_CNTL                                                                       0x25dc
#define regDP4_DP_SEC_PACKET_CNTL_BASE_IDX                                                              2
#define regDP4_DP_MSE_RATE_CNTL                                                                         0x25dd
#define regDP4_DP_MSE_RATE_CNTL_BASE_IDX                                                                2
#define regDP4_DP_MSE_RATE_UPDATE                                                                       0x25df
#define regDP4_DP_MSE_RATE_UPDATE_BASE_IDX                                                              2
#define regDP4_DP_MSE_SAT0                                                                              0x25e0
#define regDP4_DP_MSE_SAT0_BASE_IDX                                                                     2
#define regDP4_DP_MSE_SAT1                                                                              0x25e1
#define regDP4_DP_MSE_SAT1_BASE_IDX                                                                     2
#define regDP4_DP_MSE_SAT2                                                                              0x25e2
#define regDP4_DP_MSE_SAT2_BASE_IDX                                                                     2
#define regDP4_DP_MSE_SAT_UPDATE                                                                        0x25e3
#define regDP4_DP_MSE_SAT_UPDATE_BASE_IDX                                                               2
#define regDP4_DP_MSE_LINK_TIMING                                                                       0x25e4
#define regDP4_DP_MSE_LINK_TIMING_BASE_IDX                                                              2
#define regDP4_DP_MSE_MISC_CNTL                                                                         0x25e5
#define regDP4_DP_MSE_MISC_CNTL_BASE_IDX                                                                2
#define regDP4_DP_DPHY_BS_SR_SWAP_CNTL                                                                  0x25ea
#define regDP4_DP_DPHY_BS_SR_SWAP_CNTL_BASE_IDX                                                         2
#define regDP4_DP_DPHY_HBR2_PATTERN_CONTROL                                                             0x25eb
#define regDP4_DP_DPHY_HBR2_PATTERN_CONTROL_BASE_IDX                                                    2
#define regDP4_DP_MSE_SAT0_STATUS                                                                       0x25ed
#define regDP4_DP_MSE_SAT0_STATUS_BASE_IDX                                                              2
#define regDP4_DP_MSE_SAT1_STATUS                                                                       0x25ee
#define regDP4_DP_MSE_SAT1_STATUS_BASE_IDX                                                              2
#define regDP4_DP_MSE_SAT2_STATUS                                                                       0x25ef
#define regDP4_DP_MSE_SAT2_STATUS_BASE_IDX                                                              2
#define regDP4_DP_DPIA_SPARE                                                                            0x25f0
#define regDP4_DP_DPIA_SPARE_BASE_IDX                                                                   2
#define regDP4_DP_MSA_TIMING_PARAM1                                                                     0x25f2
#define regDP4_DP_MSA_TIMING_PARAM1_BASE_IDX                                                            2
#define regDP4_DP_MSA_TIMING_PARAM2                                                                     0x25f3
#define regDP4_DP_MSA_TIMING_PARAM2_BASE_IDX                                                            2
#define regDP4_DP_MSA_TIMING_PARAM3                                                                     0x25f4
#define regDP4_DP_MSA_TIMING_PARAM3_BASE_IDX                                                            2
#define regDP4_DP_MSA_TIMING_PARAM4                                                                     0x25f5
#define regDP4_DP_MSA_TIMING_PARAM4_BASE_IDX                                                            2
#define regDP4_DP_MSO_CNTL                                                                              0x25f6
#define regDP4_DP_MSO_CNTL_BASE_IDX                                                                     2
#define regDP4_DP_MSO_CNTL1                                                                             0x25f7
#define regDP4_DP_MSO_CNTL1_BASE_IDX                                                                    2
#define regDP4_DP_DSC_CNTL                                                                              0x25f8
#define regDP4_DP_DSC_CNTL_BASE_IDX                                                                     2
#define regDP4_DP_SEC_CNTL2                                                                             0x25f9
#define regDP4_DP_SEC_CNTL2_BASE_IDX                                                                    2
#define regDP4_DP_SEC_CNTL3                                                                             0x25fa
#define regDP4_DP_SEC_CNTL3_BASE_IDX                                                                    2
#define regDP4_DP_SEC_CNTL4                                                                             0x25fb
#define regDP4_DP_SEC_CNTL4_BASE_IDX                                                                    2
#define regDP4_DP_SEC_CNTL5                                                                             0x25fc
#define regDP4_DP_SEC_CNTL5_BASE_IDX                                                                    2
#define regDP4_DP_SEC_CNTL6                                                                             0x25fd
#define regDP4_DP_SEC_CNTL6_BASE_IDX                                                                    2
#define regDP4_DP_SEC_CNTL7                                                                             0x25fe
#define regDP4_DP_SEC_CNTL7_BASE_IDX                                                                    2
#define regDP4_DP_DB_CNTL                                                                               0x25ff
#define regDP4_DP_DB_CNTL_BASE_IDX                                                                      2
#define regDP4_DP_MSA_VBID_MISC                                                                         0x2600
#define regDP4_DP_MSA_VBID_MISC_BASE_IDX                                                                2
#define regDP4_DP_SEC_METADATA_TRANSMISSION                                                             0x2601
#define regDP4_DP_SEC_METADATA_TRANSMISSION_BASE_IDX                                                    2
#define regDP4_DP_ALPM_CNTL                                                                             0x2603
#define regDP4_DP_ALPM_CNTL_BASE_IDX                                                                    2
#define regDP4_DP_GSP8_CNTL                                                                             0x2604
#define regDP4_DP_GSP8_CNTL_BASE_IDX                                                                    2
#define regDP4_DP_GSP9_CNTL                                                                             0x2605
#define regDP4_DP_GSP9_CNTL_BASE_IDX                                                                    2
#define regDP4_DP_GSP10_CNTL                                                                            0x2606
#define regDP4_DP_GSP10_CNTL_BASE_IDX                                                                   2
#define regDP4_DP_GSP11_CNTL                                                                            0x2607
#define regDP4_DP_GSP11_CNTL_BASE_IDX                                                                   2
#define regDP4_DP_GSP_EN_DB_STATUS                                                                      0x2608
#define regDP4_DP_GSP_EN_DB_STATUS_BASE_IDX                                                             2
#define regDP4_DP_AUXLESS_ALPM_CNTL1                                                                    0x2609
#define regDP4_DP_AUXLESS_ALPM_CNTL1_BASE_IDX                                                           2
#define regDP4_DP_AUXLESS_ALPM_CNTL2                                                                    0x260a
#define regDP4_DP_AUXLESS_ALPM_CNTL2_BASE_IDX                                                           2
#define regDP4_DP_AUXLESS_ALPM_CNTL3                                                                    0x260b
#define regDP4_DP_AUXLESS_ALPM_CNTL3_BASE_IDX                                                           2
#define regDP4_DP_AUXLESS_ALPM_CNTL4                                                                    0x260c
#define regDP4_DP_AUXLESS_ALPM_CNTL4_BASE_IDX                                                           2
#define regDP4_DP_AUXLESS_ALPM_CNTL5                                                                    0x260d
#define regDP4_DP_AUXLESS_ALPM_CNTL5_BASE_IDX                                                           2
#define regDP4_DP_STREAM_SYMBOL_COUNT_STATUS                                                            0x260e
#define regDP4_DP_STREAM_SYMBOL_COUNT_STATUS_BASE_IDX                                                   2
#define regDP4_DP_STREAM_SYMBOL_COUNT_CONTROL                                                           0x260f
#define regDP4_DP_STREAM_SYMBOL_COUNT_CONTROL_BASE_IDX                                                  2
#define regDP4_DP_LINK_SYMBOL_COUNT_STATUS0                                                             0x2610
#define regDP4_DP_LINK_SYMBOL_COUNT_STATUS0_BASE_IDX                                                    2
#define regDP4_DP_LINK_SYMBOL_COUNT_STATUS1                                                             0x2611
#define regDP4_DP_LINK_SYMBOL_COUNT_STATUS1_BASE_IDX                                                    2
#define regDP4_DP_LINK_SYMBOL_COUNT_CONTROL                                                             0x2612
#define regDP4_DP_LINK_SYMBOL_COUNT_CONTROL_BASE_IDX                                                    2


// addressBlock: dce_dc_dcio_dcio_dispdec
// base address: 0x0
#define regDC_GENERICA                                                                                  0x2868
#define regDC_GENERICA_BASE_IDX                                                                         2
#define regDC_GENERICB                                                                                  0x2869
#define regDC_GENERICB_BASE_IDX                                                                         2
#define regDCIO_CLOCK_CNTL                                                                              0x286a
#define regDCIO_CLOCK_CNTL_BASE_IDX                                                                     2
#define regDC_REF_CLK_CNTL                                                                              0x286b
#define regDC_REF_CLK_CNTL_BASE_IDX                                                                     2
#define regUNIPHYA_LINK_CNTL                                                                            0x286d
#define regUNIPHYA_LINK_CNTL_BASE_IDX                                                                   2
#define regUNIPHYA_CHANNEL_XBAR_CNTL                                                                    0x286e
#define regUNIPHYA_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define regUNIPHYB_LINK_CNTL                                                                            0x286f
#define regUNIPHYB_LINK_CNTL_BASE_IDX                                                                   2
#define regUNIPHYB_CHANNEL_XBAR_CNTL                                                                    0x2870
#define regUNIPHYB_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define regUNIPHYC_LINK_CNTL                                                                            0x2871
#define regUNIPHYC_LINK_CNTL_BASE_IDX                                                                   2
#define regUNIPHYC_CHANNEL_XBAR_CNTL                                                                    0x2872
#define regUNIPHYC_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define regUNIPHYD_CHANNEL_XBAR_CNTL                                                                    0x2874
#define regUNIPHYD_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define regUNIPHYE_CHANNEL_XBAR_CNTL                                                                    0x2876
#define regUNIPHYE_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define regDCIO_WRCMD_DELAY                                                                             0x287e
#define regDCIO_WRCMD_DELAY_BASE_IDX                                                                    2
#define regDC_PINSTRAPS                                                                                 0x2880
#define regDC_PINSTRAPS_BASE_IDX                                                                        2
#define regDCIO_SPARE                                                                                   0x2882
#define regDCIO_SPARE_BASE_IDX                                                                          2
#define regINTERCEPT_STATE                                                                              0x2884
#define regINTERCEPT_STATE_BASE_IDX                                                                     2
#define regDCIO_PATTERN_GEN_PAT                                                                         0x2886
#define regDCIO_PATTERN_GEN_PAT_BASE_IDX                                                                2
#define regDCIO_PATTERN_GEN_EN                                                                          0x2887
#define regDCIO_PATTERN_GEN_EN_BASE_IDX                                                                 2
#define regDCIO_BL_PWM_FRAME_START_DISP_SEL                                                             0x288b
#define regDCIO_BL_PWM_FRAME_START_DISP_SEL_BASE_IDX                                                    2
#define regDCIO_GSL_GENLK_PAD_CNTL                                                                      0x288c
#define regDCIO_GSL_GENLK_PAD_CNTL_BASE_IDX                                                             2
#define regDCIO_GSL_SWAPLOCK_PAD_CNTL                                                                   0x288d
#define regDCIO_GSL_SWAPLOCK_PAD_CNTL_BASE_IDX                                                          2
#define regDCIO_SOFT_RESET                                                                              0x289e
#define regDCIO_SOFT_RESET_BASE_IDX                                                                     2


// addressBlock: dce_dc_dcio_dcio_chip_dispdec
// base address: 0x0
#define regDC_GPIO_GENERIC_MASK                                                                         0x28c8
#define regDC_GPIO_GENERIC_MASK_BASE_IDX                                                                2
#define regDC_GPIO_GENERIC_A                                                                            0x28c9
#define regDC_GPIO_GENERIC_A_BASE_IDX                                                                   2
#define regDC_GPIO_GENERIC_EN                                                                           0x28ca
#define regDC_GPIO_GENERIC_EN_BASE_IDX                                                                  2
#define regDC_GPIO_GENERIC_Y                                                                            0x28cb
#define regDC_GPIO_GENERIC_Y_BASE_IDX                                                                   2
#define regDC_GPIO_DDC1_MASK                                                                            0x28d0
#define regDC_GPIO_DDC1_MASK_BASE_IDX                                                                   2
#define regDC_GPIO_DDC1_A                                                                               0x28d1
#define regDC_GPIO_DDC1_A_BASE_IDX                                                                      2
#define regDC_GPIO_DDC1_EN                                                                              0x28d2
#define regDC_GPIO_DDC1_EN_BASE_IDX                                                                     2
#define regDC_GPIO_DDC1_Y                                                                               0x28d3
#define regDC_GPIO_DDC1_Y_BASE_IDX                                                                      2
#define regDC_GPIO_DDC2_MASK                                                                            0x28d4
#define regDC_GPIO_DDC2_MASK_BASE_IDX                                                                   2
#define regDC_GPIO_DDC2_A                                                                               0x28d5
#define regDC_GPIO_DDC2_A_BASE_IDX                                                                      2
#define regDC_GPIO_DDC2_EN                                                                              0x28d6
#define regDC_GPIO_DDC2_EN_BASE_IDX                                                                     2
#define regDC_GPIO_DDC2_Y                                                                               0x28d7
#define regDC_GPIO_DDC2_Y_BASE_IDX                                                                      2
#define regDC_GPIO_DDC3_MASK                                                                            0x28d8
#define regDC_GPIO_DDC3_MASK_BASE_IDX                                                                   2
#define regDC_GPIO_DDC3_A                                                                               0x28d9
#define regDC_GPIO_DDC3_A_BASE_IDX                                                                      2
#define regDC_GPIO_DDC3_EN                                                                              0x28da
#define regDC_GPIO_DDC3_EN_BASE_IDX                                                                     2
#define regDC_GPIO_DDC3_Y                                                                               0x28db
#define regDC_GPIO_DDC3_Y_BASE_IDX                                                                      2
#define regDC_GPIO_DDC4_MASK                                                                            0x28dc
#define regDC_GPIO_DDC4_MASK_BASE_IDX                                                                   2
#define regDC_GPIO_DDC4_A                                                                               0x28dd
#define regDC_GPIO_DDC4_A_BASE_IDX                                                                      2
#define regDC_GPIO_DDC4_EN                                                                              0x28de
#define regDC_GPIO_DDC4_EN_BASE_IDX                                                                     2
#define regDC_GPIO_DDC4_Y                                                                               0x28df
#define regDC_GPIO_DDC4_Y_BASE_IDX                                                                      2
#define regDC_GPIO_DDC5_MASK                                                                            0x28e0
#define regDC_GPIO_DDC5_MASK_BASE_IDX                                                                   2
#define regDC_GPIO_DDC5_A                                                                               0x28e1
#define regDC_GPIO_DDC5_A_BASE_IDX                                                                      2
#define regDC_GPIO_DDC5_EN                                                                              0x28e2
#define regDC_GPIO_DDC5_EN_BASE_IDX                                                                     2
#define regDC_GPIO_DDC5_Y                                                                               0x28e3
#define regDC_GPIO_DDC5_Y_BASE_IDX                                                                      2
#define regDC_GPIO_DDCVGA_MASK                                                                          0x28e8
#define regDC_GPIO_DDCVGA_MASK_BASE_IDX                                                                 2
#define regDC_GPIO_DDCVGA_A                                                                             0x28e9
#define regDC_GPIO_DDCVGA_A_BASE_IDX                                                                    2
#define regDC_GPIO_DDCVGA_EN                                                                            0x28ea
#define regDC_GPIO_DDCVGA_EN_BASE_IDX                                                                   2
#define regDC_GPIO_DDCVGA_Y                                                                             0x28eb
#define regDC_GPIO_DDCVGA_Y_BASE_IDX                                                                    2
#define regDC_GPIO_GENLK_MASK                                                                           0x28f0
#define regDC_GPIO_GENLK_MASK_BASE_IDX                                                                  2
#define regDC_GPIO_GENLK_A                                                                              0x28f1
#define regDC_GPIO_GENLK_A_BASE_IDX                                                                     2
#define regDC_GPIO_GENLK_EN                                                                             0x28f2
#define regDC_GPIO_GENLK_EN_BASE_IDX                                                                    2
#define regDC_GPIO_GENLK_Y                                                                              0x28f3
#define regDC_GPIO_GENLK_Y_BASE_IDX                                                                     2
#define regDC_GPIO_HPD_MASK                                                                             0x28f4
#define regDC_GPIO_HPD_MASK_BASE_IDX                                                                    2
#define regDC_GPIO_HPD_A                                                                                0x28f5
#define regDC_GPIO_HPD_A_BASE_IDX                                                                       2
#define regDC_GPIO_HPD_EN                                                                               0x28f6
#define regDC_GPIO_HPD_EN_BASE_IDX                                                                      2
#define regDC_GPIO_HPD_Y                                                                                0x28f7
#define regDC_GPIO_HPD_Y_BASE_IDX                                                                       2
#define regDC_GPIO_DRIVE_STRENGTH_S0                                                                    0x28f8
#define regDC_GPIO_DRIVE_STRENGTH_S0_BASE_IDX                                                           2
#define regDC_GPIO_DRIVE_STRENGTH_S1                                                                    0x28f9
#define regDC_GPIO_DRIVE_STRENGTH_S1_BASE_IDX                                                           2
#define regDC_GPIO_PWRSEQ0_EN                                                                           0x28fa
#define regDC_GPIO_PWRSEQ0_EN_BASE_IDX                                                                  2
#define regDC_GPIO_PAD_STRENGTH_1                                                                       0x28fc
#define regDC_GPIO_PAD_STRENGTH_1_BASE_IDX                                                              2
#define regDC_GPIO_PAD_STRENGTH_2                                                                       0x28fd
#define regDC_GPIO_PAD_STRENGTH_2_BASE_IDX                                                              2
#define regPHY_AUX_CNTL                                                                                 0x28ff
#define regPHY_AUX_CNTL_BASE_IDX                                                                        2
#define regDC_GPIO_DRIVE_TXIMPSEL                                                                       0x2900
#define regDC_GPIO_DRIVE_TXIMPSEL_BASE_IDX                                                              2
#define regDC_GPIO_PWRSEQ1_EN                                                                           0x2902
#define regDC_GPIO_PWRSEQ1_EN_BASE_IDX                                                                  2
#define regDC_GPIO_TX12_EN                                                                              0x2915
#define regDC_GPIO_TX12_EN_BASE_IDX                                                                     2
#define regDC_GPIO_AUX_CTRL_0                                                                           0x2916
#define regDC_GPIO_AUX_CTRL_0_BASE_IDX                                                                  2
#define regDC_GPIO_AUX_CTRL_1                                                                           0x2917
#define regDC_GPIO_AUX_CTRL_1_BASE_IDX                                                                  2
#define regDC_GPIO_AUX_CTRL_2                                                                           0x2918
#define regDC_GPIO_AUX_CTRL_2_BASE_IDX                                                                  2
#define regDC_GPIO_RXEN                                                                                 0x2919
#define regDC_GPIO_RXEN_BASE_IDX                                                                        2
#define regDC_GPIO_PULLUPEN                                                                             0x291a
#define regDC_GPIO_PULLUPEN_BASE_IDX                                                                    2
#define regDC_GPIO_AUX_CTRL_3                                                                           0x291b
#define regDC_GPIO_AUX_CTRL_3_BASE_IDX                                                                  2
#define regDC_GPIO_AUX_CTRL_4                                                                           0x291c
#define regDC_GPIO_AUX_CTRL_4_BASE_IDX                                                                  2
#define regDC_GPIO_AUX_CTRL_5                                                                           0x291d
#define regDC_GPIO_AUX_CTRL_5_BASE_IDX                                                                  2
#define regAUXI2C_PAD_ALL_PWR_OK                                                                        0x291e
#define regAUXI2C_PAD_ALL_PWR_OK_BASE_IDX                                                               2


// addressBlock: dce_dc_dcio_dcio_uniphy0_dispdec
// base address: 0x0


// addressBlock: dce_dc_dcio_dcio_uniphy1_dispdec
// base address: 0x360
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED0                                                     0x2a00
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED0_BASE_IDX                                            2
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED1                                                     0x2a01
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED1_BASE_IDX                                            2
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED2                                                     0x2a02
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED2_BASE_IDX                                            2
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED3                                                     0x2a03
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED3_BASE_IDX                                            2
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED4                                                     0x2a04
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED4_BASE_IDX                                            2
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED5                                                     0x2a05
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED5_BASE_IDX                                            2
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED6                                                     0x2a06
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED6_BASE_IDX                                            2
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED7                                                     0x2a07
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED7_BASE_IDX                                            2
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED8                                                     0x2a08
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED8_BASE_IDX                                            2
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED9                                                     0x2a09
#define regDCIO_UNIPHY1_UNIPHY_MACRO_CNTL_RESERVED9_BASE_IDX      