/*
 * Copyright 2018 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

static const uint32_t cwsr_trap_gfx8_hex[] = {
	0xbf820001, 0xbf820121,
	0xb8f4f802, 0x89748674,
	0xb8f5f803, 0x8675ff75,
	0x00000400, 0xbf850017,
	0xc00a1e37, 0x00000000,
	0xbf8c007f, 0x87777978,
	0xbf840005, 0x8f728374,
	0xb972e0c2, 0xbf800002,
	0xb9740002, 0xbe801d78,
	0xb8f5f803, 0x8675ff75,
	0x000001ff, 0xbf850002,
	0x80708470, 0x82718071,
	0x8671ff71, 0x0000ffff,
	0x8f728374, 0xb972e0c2,
	0xbf800002, 0xb9740002,
	0xbe801f70, 0xbefa0080,
	0xb97a0283, 0xbef60068,
	0xbef70069, 0xb8fa1c07,
	0x8e7a9c7a, 0x87717a71,
	0xb8fa03c7, 0x8e7a9b7a,
	0x87717a71, 0xb8faf807,
	0x867aff7a, 0x00007fff,
	0xb97af807, 0xbef2007e,
	0xbef3007f, 0xbefe0180,
	0xbf900004, 0x877a8474,
	0xb97af802, 0xbf8e0002,
	0xbf88fffe, 0xbef8007e,
	0x8679ff7f, 0x0000ffff,
	0x8779ff79, 0x00040000,
	0xbefa0080, 0xbefb00ff,
	0x00807fac, 0x867aff7f,
	0x08000000, 0x8f7a837a,
	0x877b7a7b, 0x867aff7f,
	0x70000000, 0x8f7a817a,
	0x877b7a7b, 0xbeef007c,
	0xbeee0080, 0xb8ee2a05,
	0x806e816e, 0x8e6e8a6e,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x806e7a6e,
	0xbefa0084, 0xbefa00ff,
	0x01000000, 0xbefe007c,
	0xbefc006e, 0xc0611bfc,
	0x0000007c, 0x806e846e,
	0xbefc007e, 0xbefe007c,
	0xbefc006e, 0xc0611c3c,
	0x0000007c, 0x806e846e,
	0xbefc007e, 0xbefe007c,
	0xbefc006e, 0xc0611c7c,
	0x0000007c, 0x806e846e,
	0xbefc007e, 0xbefe007c,
	0xbefc006e, 0xc0611cbc,
	0x0000007c, 0x806e846e,
	0xbefc007e, 0xbefe007c,
	0xbefc006e, 0xc0611cfc,
	0x0000007c, 0x806e846e,
	0xbefc007e, 0xbefe007c,
	0xbefc006e, 0xc0611d3c,
	0x0000007c, 0x806e846e,
	0xbefc007e, 0xb8f5f803,
	0xbefe007c, 0xbefc006e,
	0xc0611d7c, 0x0000007c,
	0x806e846e, 0xbefc007e,
	0xbefe007c, 0xbefc006e,
	0xc0611dbc, 0x0000007c,
	0x806e846e, 0xbefc007e,
	0xbefe007c, 0xbefc006e,
	0xc0611dfc, 0x0000007c,
	0x806e846e, 0xbefc007e,
	0xb8eff801, 0xbefe007c,
	0xbefc006e, 0xc0611bfc,
	0x0000007c, 0x806e846e,
	0xbefc007e, 0xbefe007c,
	0xbefc006e, 0xc0611b3c,
	0x0000007c, 0x806e846e,
	0xbefc007e, 0xbefe007c,
	0xbefc006e, 0xc0611b7c,
	0x0000007c, 0x806e846e,
	0xbefc007e, 0x867aff7f,
	0x04000000, 0xbef30080,
	0x8773737a, 0xb8ee2a05,
	0x806e816e, 0x8e6e8a6e,
	0xb8f51605, 0x80758175,
	0x8e758475, 0x8e7a8275,
	0xbefa00ff, 0x01000000,
	0xbef60178, 0x80786e78,
	0x82798079, 0xbefc0080,
	0xbe802b00, 0xbe822b02,
	0xbe842b04, 0xbe862b06,
	0xbe882b08, 0xbe8a2b0a,
	0xbe8c2b0c, 0xbe8e2b0e,
	0xc06b003c, 0x00000000,
	0xc06b013c, 0x00000010,
	0xc06b023c, 0x00000020,
	0xc06b033c, 0x00000030,
	0x8078c078, 0x82798079,
	0x807c907c, 0xbf0a757c,
	0xbf85ffeb, 0xbef80176,
	0xbeee0080, 0xbefe00c1,
	0xbeff00c1, 0xbefa00ff,
	0x01000000, 0xe0724000,
	0x6e1e0000, 0xe0724100,
	0x6e1e0100, 0xe0724200,
	0x6e1e0200, 0xe0724300,
	0x6e1e0300, 0xbefe00c1,
	0xbeff00c1, 0xb8f54306,
	0x8675c175, 0xbf84002c,
	0xbf8a0000, 0x867aff73,
	0x04000000, 0xbf840028,
	0x8e758675, 0x8e758275,
	0xbefa0075, 0xb8ee2a05,
	0x806e816e, 0x8e6e8a6e,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x806e7a6e,
	0x806eff6e, 0x00000080,
	0xbefa00ff, 0x01000000,
	0xbefc0080, 0xd28c0002,
	0x000100c1, 0xd28d0003,
	0x000204c1, 0xd1060002,
	0x00011103, 0x7e0602ff,
	0x00000200, 0xbefc00ff,
	0x00010000, 0xbe80007b,
	0x867bff7b, 0xff7fffff,
	0x877bff7b, 0x00058000,
	0xd8ec0000, 0x00000002,
	0xbf8c007f, 0xe0765000,
	0x6e1e0002, 0x32040702,
	0xd0c9006a, 0x0000eb02,
	0xbf87fff7, 0xbefb0000,
	0xbeee00ff, 0x00000400,
	0xbefe00c1, 0xbeff00c1,
	0xb8f52a05, 0x80758175,
	0x8e758275, 0x8e7a8875,
	0xbefa00ff, 0x01000000,
	0xbefc0084, 0xbf0a757c,
	0xbf840015, 0xbf11017c,
	0x8075ff75, 0x00001000,
	0x7e000300, 0x7e020301,
	0x7e040302, 0x7e060303,
	0xe0724000, 0x6e1e0000,
	0xe0724100, 0x6e1e0100,
	0xe0724200, 0x6e1e0200,
	0xe0724300, 0x6e1e0300,
	0x807c847c, 0x806eff6e,
	0x00000400, 0xbf0a757c,
	0xbf85ffef, 0xbf9c0000,
	0xbf8200ce, 0xbef8007e,
	0x8679ff7f, 0x0000ffff,
	0x8779ff79, 0x00040000,
	0xbefa0080, 0xbefb00ff,
	0x00807fac, 0x8676ff7f,
	0x08000000, 0x8f768376,
	0x877b767b, 0x8676ff7f,
	0x70000000, 0x8f768176,
	0x877b767b, 0x8676ff7f,
	0x04000000, 0xbf84001e,
	0xbefe00c1, 0xbeff00c1,
	0xb8f34306, 0x8673c173,
	0xbf840019, 0x8e738673,
	0x8e738273, 0xbefa0073,
	0xb8f22a05, 0x80728172,
	0x8e728a72, 0xb8f61605,
	0x80768176, 0x8e768676,
	0x80727672, 0x8072ff72,
	0x00000080, 0xbefa00ff,
	0x01000000, 0xbefc0080,
	0xe0510000, 0x721e0000,
	0xe0510100, 0x721e0000,
	0x807cff7c, 0x00000200,
	0x8072ff72, 0x00000200,
	0xbf0a737c, 0xbf85fff6,
	0xbef20080, 0xbefe00c1,
	0xbeff00c1, 0xb8f32a05,
	0x80738173, 0x8e738273,
	0x8e7a8873, 0xbefa00ff,
	0x01000000, 0xbef60072,
	0x8072ff72, 0x00000400,
	0xbefc0084, 0xbf11087c,
	0x8073ff73, 0x00008000,
	0xe0524000, 0x721e0000,
	0xe0524100, 0x721e0100,
	0xe0524200, 0x721e0200,
	0xe0524300, 0x721e0300,
	0xbf8c0f70, 0x7e000300,
	0x7e020301, 0x7e040302,
	0x7e060303, 0x807c847c,
	0x8072ff72, 0x00000400,
	0xbf0a737c, 0xbf85ffee,
	0xbf9c0000, 0xe0524000,
	0x761e0000, 0xe0524100,
	0x761e0100, 0xe0524200,
	0x761e0200, 0xe0524300,
	0x761e0300, 0xbf8c0f70,
	0xb8f22a05, 0x80728172,
	0x8e728a72, 0xb8f61605,
	0x80768176, 0x8e768676,
	0x80727672, 0x80f2c072,
	0xb8f31605, 0x80738173,
	0x8e738473, 0x8e7a8273,
	0xbefa00ff, 0x01000000,
	0xbefc0073, 0xc031003c,
	0x00000072, 0x80f2c072,
	0xbf8c007f, 0x80fc907c,
	0xbe802d00, 0xbe822d02,
	0xbe842d04, 0xbe862d06,
	0xbe882d08, 0xbe8a2d0a,
	0xbe8c2d0c, 0xbe8e2d0e,
	0xbf06807c, 0xbf84fff1,
	0xb8f22a05, 0x80728172,
	0x8e728a72, 0xb8f61605,
	0x80768176, 0x8e768676,
	0x80727672, 0xbefa0084,
	0xbefa00ff, 0x01000000,
	0xc0211cfc, 0x00000072,
	0x80728472, 0xc0211c3c,
	0x00000072, 0x80728472,
	0xc0211c7c, 0x00000072,
	0x80728472, 0xc0211bbc,
	0x00000072, 0x80728472,
	0xc0211bfc, 0x00000072,
	0x80728472, 0xc0211d3c,
	0x00000072, 0x80728472,
	0xc0211d7c, 0x00000072,
	0x80728472, 0xc0211a3c,
	0x00000072, 0x80728472,
	0xc0211a7c, 0x00000072,
	0x80728472, 0xc0211dfc,
	0x00000072, 0x80728472,
	0xc0211b3c, 0x00000072,
	0x80728472, 0xc0211b7c,
	0x00000072, 0x80728472,
	0xbf8c007f, 0xbefc0073,
	0xbefe006e, 0xbeff006f,
	0x867375ff, 0x000003ff,
	0xb9734803, 0x867375ff,
	0xfffff800, 0x8f738b73,
	0xb973a2c3, 0xb977f801,
	0x8673ff71, 0xf0000000,
	0x8f739c73, 0x8e739073,
	0xbef60080, 0x87767376,
	0x8673ff71, 0x08000000,
	0x8f739b73, 0x8e738f73,
	0x87767376, 0x8673ff74,
	0x00800000, 0x8f739773,
	0xb976f807, 0x8671ff71,
	0x0000ffff, 0x86fe7e7e,
	0x86ea6a6a, 0x8f768374,
	0xb976e0c2, 0xbf800002,
	0xb9740002, 0xbf8a0000,
	0x95807370, 0xbf810000,
};


static const uint32_t cwsr_trap_gfx9_hex[] = {
	0xbf820001, 0xbf820259,
	0xb8f8f802, 0x8978ff78,
	0x00020006, 0xb8fbf803,
	0x866eff78, 0x00002000,
	0xbf840009, 0x866eff6d,
	0x00ff0000, 0xbf85001e,
	0x866eff7b, 0x00000400,
	0xbf850055, 0xbf8e0010,
	0xb8fbf803, 0xbf82fffa,
	0x866eff7b, 0x03c00900,
	0xbf850015, 0x866eff7b,
	0x000071ff, 0xbf840008,
	0x866fff7b, 0x00007080,
	0xbf840001, 0xbeee1a87,
	0xb8eff801, 0x8e6e8c6e,
	0x866e6f6e, 0xbf85000a,
	0x866eff6d, 0x00ff0000,
	0xbf850007, 0xb8eef801,
	0x866eff6e, 0x00000800,
	0xbf850003, 0x866eff7b,
	0x00000400, 0xbf85003a,
	0xb8faf807, 0x867aff7a,
	0x001f8000, 0x8e7a8b7a,
	0x8977ff77, 0xfc000000,
	0x87777a77, 0xba7ff807,
	0x00000000, 0xb8faf812,
	0xb8fbf813, 0x8efa887a,
	0xbf0d8f7b, 0xbf840002,
	0x877bff7b, 0xffff0000,
	0xc0031bbd, 0x00000010,
	0xbf8cc07f, 0x8e6e976e,
	0x8977ff77, 0x00800000,
	0x87776e77, 0xc0071bbd,
	0x00000000, 0xbf8cc07f,
	0xc0071ebd, 0x00000008,
	0xbf8cc07f, 0x86ee6e6e,
	0xbf840001, 0xbe801d6e,
	0x866eff6d, 0x01ff0000,
	0xbf850005, 0x8778ff78,
	0x00002000, 0x80ec886c,
	0x82ed806d, 0xbf820005,
	0x866eff6d, 0x01000000,
	0xbf850002, 0x806c846c,
	0x826d806d, 0x866dff6d,
	0x0000ffff, 0x8f7a8b77,
	0x867aff7a, 0x001f8000,
	0xb97af807, 0x86fe7e7e,
	0x86ea6a6a, 0x8f6e8378,
	0xb96ee0c2, 0xbf800002,
	0xb9780002, 0xbe801f6c,
	0x866dff6d, 0x0000ffff,
	0xbefa0080, 0xb97a0283,
	0xb8faf807, 0x867aff7a,
	0x001f8000, 0x8e7a8b7a,
	0x8977ff77, 0xfc000000,
	0x87777a77, 0xba7ff807,
	0x00000000, 0xbeee007e,
	0xbeef007f, 0xbefe0180,
	0xbf900004, 0x877a8478,
	0xb97af802, 0xbf8e0002,
	0xbf88fffe, 0xb8fa2a05,
	0x807a817a, 0x8e7a8a7a,
	0xb8fb1605, 0x807b817b,
	0x8e7b867b, 0x807a7b7a,
	0x807a7e7a, 0x827b807f,
	0x867bff7b, 0x0000ffff,
	0xc04b1c3d, 0x00000050,
	0xbf8cc07f, 0xc04b1d3d,
	0x00000060, 0xbf8cc07f,
	0xc0431e7d, 0x00000074,
	0xbf8cc07f, 0xbef4007e,
	0x8675ff7f, 0x0000ffff,
	0x8775ff75, 0x00040000,
	0xbef60080, 0xbef700ff,
	0x00807fac, 0xbef1007c,
	0xbef00080, 0xb8f02a05,
	0x80708170, 0x8e708a70,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x80707a70,
	0xbef60084, 0xbef600ff,
	0x01000000, 0xbefe007c,
	0xbefc0070, 0xc0611c7a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611b3a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611b7a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611bba, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611bfa,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611e3a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xb8fbf803,
	0xbefe007c, 0xbefc0070,
	0xc0611efa, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611a3a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611a7a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xb8f1f801,
	0xbefe007c, 0xbefc0070,
	0xc0611c7a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbf108080,
	0x867aff7f, 0x04000000,
	0xbeef0080, 0x876f6f7a,
	0xb8f02a05, 0x80708170,
	0x8e708a70, 0xb8fb1605,
	0x807b817b, 0x8e7b847b,
	0x8e76827b, 0xbef600ff,
	0x01000000, 0xbef20174,
	0x80747074, 0x82758075,
	0xbefc0080, 0xbf800000,
	0xbe802b00, 0xbe822b02,
	0xbe842b04, 0xbe862b06,
	0xbe882b08, 0xbe8a2b0a,
	0xbe8c2b0c, 0xbe8e2b0e,
	0xc06b003a, 0x00000000,
	0xbf8cc07f, 0xc06b013a,
	0x00000010, 0xbf8cc07f,
	0xc06b023a, 0x00000020,
	0xbf8cc07f, 0xc06b033a,
	0x00000030, 0xbf8cc07f,
	0x8074c074, 0x82758075,
	0x807c907c, 0xbf0a7b7c,
	0xbf85ffe7, 0xbef40172,
	0xbef00080, 0xbefe00c1,
	0xbeff00c1, 0xbee80080,
	0xbee90080, 0xbef600ff,
	0x01000000, 0x867aff78,
	0x00400000, 0xbf850003,
	0xb8faf803, 0x897a7aff,
	0x10000000, 0xbf85004d,
	0xbe840080, 0xd2890000,
	0x00000900, 0x80048104,
	0xd2890001, 0x00000900,
	0x80048104, 0xd2890002,
	0x00000900, 0x80048104,
	0xd2890003, 0x00000900,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000901,
	0x80048104, 0xd2890001,
	0x00000901, 0x80048104,
	0xd2890002, 0x00000901,
	0x80048104, 0xd2890003,
	0x00000901, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000902, 0x80048104,
	0xd2890001, 0x00000902,
	0x80048104, 0xd2890002,
	0x00000902, 0x80048104,
	0xd2890003, 0x00000902,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000903,
	0x80048104, 0xd2890001,
	0x00000903, 0x80048104,
	0xd2890002, 0x00000903,
	0x80048104, 0xd2890003,
	0x00000903, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbf820008, 0xe0724000,
	0x701d0000, 0xe0724100,
	0x701d0100, 0xe0724200,
	0x701d0200, 0xe0724300,
	0x701d0300, 0xbefe00c1,
	0xbeff00c1, 0xb8fb4306,
	0x867bc17b, 0xbf840063,
	0xbf8a0000, 0x867aff6f,
	0x04000000, 0xbf84005f,
	0x8e7b867b, 0x8e7b827b,
	0xbef6007b, 0xb8f02a05,
	0x80708170, 0x8e708a70,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x80707a70,
	0x8070ff70, 0x00000080,
	0xbef600ff, 0x01000000,
	0xbefc0080, 0xd28c0002,
	0x000100c1, 0xd28d0003,
	0x000204c1, 0x867aff78,
	0x00400000, 0xbf850003,
	0xb8faf803, 0x897a7aff,
	0x10000000, 0xbf850030,
	0x24040682, 0xd86e4000,
	0x00000002, 0xbf8cc07f,
	0xbe840080, 0xd2890000,
	0x00000900, 0x80048104,
	0xd2890001, 0x00000900,
	0x80048104, 0xd2890002,
	0x00000900, 0x80048104,
	0xd2890003, 0x00000900,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000901,
	0x80048104, 0xd2890001,
	0x00000901, 0x80048104,
	0xd2890002, 0x00000901,
	0x80048104, 0xd2890003,
	0x00000901, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0x680404ff, 0x00000200,
	0xd0c9006a, 0x0000f702,
	0xbf87ffd2, 0xbf820015,
	0xd1060002, 0x00011103,
	0x7e0602ff, 0x00000200,
	0xbefc00ff, 0x00010000,
	0xbe800077, 0x8677ff77,
	0xff7fffff, 0x8777ff77,
	0x00058000, 0xd8ec0000,
	0x00000002, 0xbf8cc07f,
	0xe0765000, 0x701d0002,
	0x68040702, 0xd0c9006a,
	0x0000f702, 0xbf87fff7,
	0xbef70000, 0xbef000ff,
	0x00000400, 0xbefe00c1,
	0xbeff00c1, 0xb8fb2a05,
	0x807b817b, 0x8e7b827b,
	0xbef600ff, 0x01000000,
	0xbefc0084, 0xbf0a7b7c,
	0xbf84006d, 0xbf11017c,
	0x807bff7b, 0x00001000,
	0x867aff78, 0x00400000,
	0xbf850003, 0xb8faf803,
	0x897a7aff, 0x10000000,
	0xbf850051, 0xbe840080,
	0xd2890000, 0x00000900,
	0x80048104, 0xd2890001,
	0x00000900, 0x80048104,
	0xd2890002, 0x00000900,
	0x80048104, 0xd2890003,
	0x00000900, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000901, 0x80048104,
	0xd2890001, 0x00000901,
	0x80048104, 0xd2890002,
	0x00000901, 0x80048104,
	0xd2890003, 0x00000901,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000902,
	0x80048104, 0xd2890001,
	0x00000902, 0x80048104,
	0xd2890002, 0x00000902,
	0x80048104, 0xd2890003,
	0x00000902, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000903, 0x80048104,
	0xd2890001, 0x00000903,
	0x80048104, 0xd2890002,
	0x00000903, 0x80048104,
	0xd2890003, 0x00000903,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0x807c847c,
	0xbf0a7b7c, 0xbf85ffb1,
	0xbf9c0000, 0xbf820012,
	0x7e000300, 0x7e020301,
	0x7e040302, 0x7e060303,
	0xe0724000, 0x701d0000,
	0xe0724100, 0x701d0100,
	0xe0724200, 0x701d0200,
	0xe0724300, 0x701d0300,
	0x807c847c, 0x8070ff70,
	0x00000400, 0xbf0a7b7c,
	0xbf85ffef, 0xbf9c0000,
	0xbf8200c7, 0xbef4007e,
	0x8675ff7f, 0x0000ffff,
	0x8775ff75, 0x00040000,
	0xbef60080, 0xbef700ff,
	0x00807fac, 0x866eff7f,
	0x04000000, 0xbf84001e,
	0xbefe00c1, 0xbeff00c1,
	0xb8ef4306, 0x866fc16f,
	0xbf840019, 0x8e6f866f,
	0x8e6f826f, 0xbef6006f,
	0xb8f82a05, 0x80788178,
	0x8e788a78, 0xb8ee1605,
	0x806e816e, 0x8e6e866e,
	0x80786e78, 0x8078ff78,
	0x00000080, 0xbef600ff,
	0x01000000, 0xbefc0080,
	0xe0510000, 0x781d0000,
	0xe0510100, 0x781d0000,
	0x807cff7c, 0x00000200,
	0x8078ff78, 0x00000200,
	0xbf0a6f7c, 0xbf85fff6,
	0xbefe00c1, 0xbeff00c1,
	0xbef600ff, 0x01000000,
	0xb8ef2a05, 0x806f816f,
	0x8e6f826f, 0x806fff6f,
	0x00008000, 0xbef80080,
	0xbeee0078, 0x8078ff78,
	0x00000400, 0xbefc0084,
	0xbf11087c, 0xe0524000,
	0x781d0000, 0xe0524100,
	0x781d0100, 0xe0524200,
	0x781d0200, 0xe0524300,
	0x781d0300, 0xbf8c0f70,
	0x7e000300, 0x7e020301,
	0x7e040302, 0x7e060303,
	0x807c847c, 0x8078ff78,
	0x00000400, 0xbf0a6f7c,
	0xbf85ffee, 0xbf9c0000,
	0xe0524000, 0x6e1d0000,
	0xe0524100, 0x6e1d0100,
	0xe0524200, 0x6e1d0200,
	0xe0524300, 0x6e1d0300,
	0xbf8c0f70, 0xb8f82a05,
	0x80788178, 0x8e788a78,
	0xb8ee1605, 0x806e816e,
	0x8e6e866e, 0x80786e78,
	0x80f8c078, 0xb8ef1605,
	0x806f816f, 0x8e6f846f,
	0x8e76826f, 0xbef600ff,
	0x01000000, 0xbefc006f,
	0xc031003a, 0x00000078,
	0x80f8c078, 0xbf8cc07f,
	0x80fc907c, 0xbf800000,
	0xbe802d00, 0xbe822d02,
	0xbe842d04, 0xbe862d06,
	0xbe882d08, 0xbe8a2d0a,
	0xbe8c2d0c, 0xbe8e2d0e,
	0xbf06807c, 0xbf84fff0,
	0xb8f82a05, 0x80788178,
	0x8e788a78, 0xb8ee1605,
	0x806e816e, 0x8e6e866e,
	0x80786e78, 0xbef60084,
	0xbef600ff, 0x01000000,
	0xc0211bfa, 0x00000078,
	0x80788478, 0xc0211b3a,
	0x00000078, 0x80788478,
	0xc0211b7a, 0x00000078,
	0x80788478, 0xc0211c3a,
	0x00000078, 0x80788478,
	0xc0211c7a, 0x00000078,
	0x80788478, 0xc0211eba,
	0x00000078, 0x80788478,
	0xc0211efa, 0x00000078,
	0x80788478, 0xc0211a3a,
	0x00000078, 0x80788478,
	0xc0211a7a, 0x00000078,
	0x80788478, 0xc0211cfa,
	0x00000078, 0x80788478,
	0xbf8cc07f, 0xbefc006f,
	0xbefe0070, 0xbeff0071,
	0x866f7bff, 0x000003ff,
	0xb96f4803, 0x866f7bff,
	0xfffff800, 0x8f6f8b6f,
	0xb96fa2c3, 0xb973f801,
	0xb8ee2a05, 0x806e816e,
	0x8e6e8a6e, 0xb8ef1605,
	0x806f816f, 0x8e6f866f,
	0x806e6f6e, 0x806e746e,
	0x826f8075, 0x866fff6f,
	0x0000ffff, 0xc00b1c37,
	0x00000050, 0xc00b1d37,
	0x00000060, 0xc0031e77,
	0x00000074, 0xbf8cc07f,
	0x8f6e8b77, 0x866eff6e,
	0x001f8000, 0xb96ef807,
	0x866dff6d, 0x0000ffff,
	0x86fe7e7e, 0x86ea6a6a,
	0x8f6e837a, 0xb96ee0c2,
	0xbf800002, 0xb97a0002,
	0xbf8a0000, 0xbe801f6c,
	0xbf9b0000, 0x00000000,
};

static const uint32_t cwsr_trap_nv1x_hex[] = {
	0xbf820001, 0xbf820393,
	0xb0804004, 0xb978f802,
	0x8a78ff78, 0x00020006,
	0xb97bf803, 0x876eff78,
	0x00002000, 0xbf840009,
	0x876eff6d, 0x00ff0000,
	0xbf85001e, 0x876eff7b,
	0x00000400, 0xbf85005b,
	0xbf8e0010, 0xb97bf803,
	0xbf82fffa, 0x876eff7b,
	0x00000900, 0xbf850015,
	0x876eff7b, 0x000071ff,
	0xbf840008, 0x876fff7b,
	0x00007080, 0xbf840001,
	0xbeee1d87, 0xb96ff801,
	0x8f6e8c6e, 0x876e6f6e,
	0xbf85000a, 0x876eff6d,
	0x00ff0000, 0xbf850007,
	0xb96ef801, 0x876eff6e,
	0x00000800, 0xbf850003,
	0x876eff7b, 0x00000400,
	0xbf850040, 0x8a77ff77,
	0xff000000, 0xb97af807,
	0x877bff7a, 0x02000000,
	0x8f7b867b, 0x88777b77,
	0x877bff7a, 0x003f8000,
	0x8f7b897b, 0x88777b77,
	0x8a7aff7a, 0x023f8000,
	0xb9faf807, 0xb97af812,
	0xb97bf813, 0x8ffa887a,
	0xbf0d8f7b, 0xbf840002,
	0x887bff7b, 0xffff0000,
	0xf4011bbd, 0xfa000010,
	0xbf8c0000, 0x8f6e976e,
	0x8a77ff77, 0x00800000,
	0x88776e77, 0xf4051bbd,
	0xfa000000, 0xbf8c0000,
	0xf4051ebd, 0xfa000008,
	0xbf8c0000, 0x87ee6e6e,
	0xbf840001, 0xbe80206e,
	0x876eff6d, 0x00ff0000,
	0xbf850008, 0x876eff6d,
	0x01000000, 0xbf850007,
	0x8878ff78, 0x00002000,
	0x80ec886c, 0x82ed806d,
	0xbf820002, 0x806c846c,
	0x826d806d, 0x876dff6d,
	0x0000ffff, 0x907a8977,
	0x877bff7a, 0x003f8000,
	0x907a8677, 0x877aff7a,
	0x02000000, 0x887a7b7a,
	0xb9faf807, 0x87fe7e7e,
	0x87ea6a6a, 0xb9f8f802,
	0xbe80226c, 0x876dff6d,
	0x0000ffff, 0xbefa0380,
	0xb9fa0283, 0x8a77ff77,
	0xff000000, 0xb97af807,
	0x877bff7a, 0x02000000,
	0x8f7b867b, 0x88777b77,
	0x877bff7a, 0x003f8000,
	0x8f7b897b, 0x88777b77,
	0x8a7aff7a, 0x023f8000,
	0xb9faf807, 0xbeee037e,
	0xbeef037f, 0xbefe0480,
	0xbf900004, 0xbf8e0002,
	0xbf88fffe, 0x877aff7f,
	0x04000000, 0x8f7a857a,
	0x886d7a6d, 0xb97b02dc,
	0x8f7b997b, 0xb97a3a05,
	0x807a817a, 0xbf0d997b,
	0xbf850002, 0x8f7a897a,
	0xbf820001, 0x8f7a8a7a,
	0xb97b1e06, 0x8f7b8a7b,
	0x807a7b7a, 0x877bff7f,
	0x0000ffff, 0x807aff7a,
	0x00000200, 0x807a7e7a,
	0x827b807b, 0xf4491c3d,
	0xfa000050, 0xf4491d3d,
	0xfa000060, 0xf4411e7d,
	0xfa000074, 0xbef4037e,
	0x8775ff7f, 0x0000ffff,
	0x8875ff75, 0x00040000,
	0xbef60380, 0xbef703ff,
	0x10807fac, 0xbef1037c,
	0xbef00380, 0xb97302dc,
	0x8f739973, 0xb97bf816,
	0xba80f816, 0x00000000,
	0xbefe03c1, 0x907c9973,
	0x877c817c, 0xbf06817c,
	0xbf850002, 0xbeff0380,
	0xbf820002, 0xbeff03c1,
	0xbf820058, 0xbef603ff,
	0x01000000, 0xb97af803,
	0x8a7a7aff, 0x10000000,
	0xbf850049, 0xbe840380,
	0xd7600000, 0x00000900,
	0x80048104, 0xd7600001,
	0x00000900, 0x80048104,
	0xd7600002, 0x00000900,
	0x80048104, 0xd7600003,
	0x00000900, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06a004,
	0xbf84ffef, 0xbe840380,
	0xd7600000, 0x00000901,
	0x80048104, 0xd7600001,
	0x00000901, 0x80048104,
	0xd7600002, 0x00000901,
	0x80048104, 0xd7600003,
	0x00000901, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06a004,
	0xbf84ffef, 0xbe840380,
	0xd7600000, 0x00000902,
	0x80048104, 0xd7600001,
	0x00000902, 0x80048104,
	0xd7600002, 0x00000902,
	0x80048104, 0xd7600003,
	0x00000902, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06a004,
	0xbf84ffef, 0xbe840380,
	0xd7600000, 0x00000903,
	0x80048104, 0xd7600001,
	0x00000903, 0x80048104,
	0xd7600002, 0x00000903,
	0x80048104, 0xd7600003,
	0x00000903, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06a004,
	0xbf84ffef, 0xbf820060,
	0xe0704000, 0x705d0000,
	0xe0704080, 0x705d0100,
	0xe0704100, 0x705d0200,
	0xe0704180, 0x705d0300,
	0xbf820057, 0xbef603ff,
	0x01000000, 0xb97af803,
	0x8a7a7aff, 0x10000000,
	0xbf850049, 0xbe840380,
	0xd7600000, 0x00000900,
	0x80048104, 0xd7600001,
	0x00000900, 0x80048104,
	0xd7600002, 0x00000900,
	0x80048104, 0xd7600003,
	0x00000900, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06c004,
	0xbf84ffef, 0xbe840380,
	0xd7600000, 0x00000901,
	0x80048104, 0xd7600001,
	0x00000901, 0x80048104,
	0xd7600002, 0x00000901,
	0x80048104, 0xd7600003,
	0x00000901, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06c004,
	0xbf84ffef, 0xbe840380,
	0xd7600000, 0x00000902,
	0x80048104, 0xd7600001,
	0x00000902, 0x80048104,
	0xd7600002, 0x00000902,
	0x80048104, 0xd7600003,
	0x00000902, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06c004,
	0xbf84ffef, 0xbe840380,
	0xd7600000, 0x00000903,
	0x80048104, 0xd7600001,
	0x00000903, 0x80048104,
	0xd7600002, 0x00000903,
	0x80048104, 0xd7600003,
	0x00000903, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06c004,
	0xbf84ffef, 0xbf820008,
	0xe0704000, 0x705d0000,
	0xe0704100, 0x705d0100,
	0xe0704200, 0x705d0200,
	0xe0704300, 0x705d0300,
	0xb9703a05, 0x80708170,
	0xbf0d9973, 0xbf850002,
	0x8f708970, 0xbf820001,
	0x8f708a70, 0xb97a1e06,
	0x8f7a8a7a, 0x80707a70,
	0x8070ff70, 0x00000200,
	0xbef603ff, 0x01000000,
	0xbefe037c, 0xbefc0370,
	0xf4611c7a, 0xf8000000,
	0x80708470, 0xbefc037e,
	0xbefe037c, 0xbefc0370,
	0xf4611b3a, 0xf8000000,
	0x80708470, 0xbefc037e,
	0x8a7aff6d, 0x80000000,
	0xbefe037c, 0xbefc0370,
	0xf4611eba, 0xf8000000,
	0x80708470, 0xbefc037e,
	0xbefe037c, 0xbefc0370,
	0xf4611bba, 0xf8000000,
	0x80708470, 0xbefc037e,
	0xbefe037c, 0xbefc0370,
	0xf4611bfa, 0xf8000000,
	0x80708470, 0xbefc037e,
	0xbefe037c, 0xbefc0370,
	0xf4611e3a, 0xf8000000,
	0x80708470, 0xbefc037e,
	0xb97af803, 0xbefe037c,
	0xbefc0370, 0xf4611eba,
	0xf8000000, 0x80708470,
	0xbefc037e, 0xbefe037c,
	0xbefc0370, 0xf4611efa,
	0xf8000000, 0x80708470,
	0xbefc037e, 0xb971f801,
	0xbefe037c, 0xbefc0370,
	0xf4611c7a, 0xf8000000,
	0x80708470, 0xbefc037e,
	0xb971f814, 0xbefe037c,
	0xbefc0370, 0xf4611c7a,
	0xf8000000, 0x80708470,
	0xbefc037e, 0xb971f815,
	0xbefe037c, 0xbefc0370,
	0xf4611c7a, 0xf8000000,
	0x80708470, 0xbefc037e,
	0xb9703a05, 0x80708170,
	0xbf0d9973, 0xbf850002,
	0x8f708970, 0xbf820001,
	0x8f708a70, 0xb97a1e06,
	0x8f7a8a7a, 0x80707a70,
	0xbef603ff, 0x01000000,
	0xbefb0374, 0x80747074,
	0x82758075, 0xbefc0380,
	0xbf800000, 0xbe802f00,
	0xbe822f02, 0xbe842f04,
	0xbe862f06, 0xbe882f08,
	0xbe8a2f0a, 0xbe8c2f0c,
	0xbe8e2f0e, 0xf469003a,
	0xfa000000, 0xf469013a,
	0xfa000010, 0xf469023a,
	0xfa000020, 0xf469033a,
	0xfa000030, 0x8074c074,
	0x82758075, 0x807c907c,
	0xbf0aff7c, 0x00000060,
	0xbf85ffea, 0xbe802f00,
	0xbe822f02, 0xbe842f04,
	0xbe862f06, 0xbe882f08,
	0xbe8a2f0a, 0xf469003a,
	0xfa000000, 0xf469013a,
	0xfa000010, 0xf469023a,
	0xfa000020, 0x8074b074,
	0x82758075, 0xbef4037b,
	0xbefe03c1, 0x907c9973,
	0x877c817c, 0xbf06817c,
	0xbf850002, 0xbeff0380,
	0xbf820001, 0xbeff03c1,
	0xb97b4306, 0x877bc17b,
	0xbf840085, 0xbf8a0000,
	0x877aff6d, 0x80000000,
	0xbf840081, 0x8f7b887b,
	0xbef6037b, 0xb9703a05,
	0x80708170, 0xbf0d9973,
	0xbf850002, 0x8f708970,
	0xbf820001, 0x8f708a70,
	0xb97a1e06, 0x8f7a8a7a,
	0x80707a70, 0x8070ff70,
	0x00000200, 0x8070ff70,
	0x00000080, 0xbef603ff,
	0x01000000, 0xd7650000,
	0x000100c1, 0xd7660000,
	0x000200c1, 0x16000084,
	0x907c9973, 0x877c817c,
	0xbf06817c, 0xbefc0380,
	0xbf850033, 0xb97af803,
	0x8a7a7aff, 0x10000000,
	0xbf85001d, 0xd8d80000,
	0x01000000, 0xbf8c0000,
	0xbe840380, 0xd7600000,
	0x00000901, 0x80048104,
	0xd7600001, 0x00000901,
	0x80048104, 0xd7600002,
	0x00000901, 0x80048104,
	0xd7600003, 0x00000901,
	0x80048104, 0xf469003a,
	0xe0000000, 0x80709070,
	0xbf06a004, 0xbf84ffef,
	0x807cff7c, 0x00000080,
	0xd5250000, 0x0001ff00,
	0x00000080, 0xbf0a7b7c,
	0xbf85ffe4, 0xbf820044,
	0xbe8303ff, 0x00000080,
	0xbf800000, 0xbf800000,
	0xbf800000, 0xd8d80000,
	0x01000000, 0xbf8c0000,
	0xe0704000, 0x705d0100,
	0x807c037c, 0x80700370,
	0xd5250000, 0x0001ff00,
	0x00000080, 0xbf0a7b7c,
	0xbf85fff4, 0xbf820032,
	0xb97af803, 0x8a7a7aff,
	0x10000000, 0xbf85001d,
	0xd8d80000, 0x01000000,
	0xbf8c0000, 0xbe840380,
	0xd7600000, 0x00000901,
	0x80048104, 0xd7600001,
	0x00000901, 0x80048104,
	0xd7600002, 0x00000901,
	0x80048104, 0xd7600003,
	0x00000901, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06c004,
	0xbf84ffef, 0x807cff7c,
	0x00000100, 0xd5250000,
	0x0001ff00, 0x00000100,
	0xbf0a7b7c, 0xbf85ffe4,
	0xbf820011, 0xbe8303ff,
	0x00000100, 0xbf800000,
	0xbf800000, 0xbf800000,
	0xd8d80000, 0x01000000,
	0xbf8c0000, 0xe0704000,
	0x705d0100, 0x807c037c,
	0x80700370, 0xd5250000,
	0x0001ff00, 0x00000100,
	0xbf0a7b7c, 0xbf85fff4,
	0xbefe03c1, 0x907c9973,
	0x877c817c, 0xbf06817c,
	0xbf850004, 0xbef003ff,
	0x00000200, 0xbeff0380,
	0xbf820003, 0xbef003ff,
	0x00000400, 0xbeff03c1,
	0xb97b3a05, 0x807b817b,
	0x8f7b827b, 0x907c9973,
	0x877c817c, 0xbf06817c,
	0xbf85006b, 0xbef603ff,
	0x01000000, 0xbefc0384,
	0xbf0a7b7c, 0xbf8400fa,
	0xb97af803, 0x8a7a7aff,
	0x10000000, 0xbf850050,
	0x7e008700, 0x7e028701,
	0x7e048702, 0x7e068703,
	0xbe840380, 0xd7600000,
	0x00000900, 0x80048104,
	0xd7600001, 0x00000900,
	0x80048104, 0xd7600002,
	0x00000900, 0x80048104,
	0xd7600003, 0x00000900,
	0x80048104, 0xf469003a,
	0xe0000000, 0x80709070,
	0xbf06a004, 0xbf84ffef,
	0xbe840380, 0xd7600000,
	0x00000901, 0x80048104,
	0xd7600001, 0x00000901,
	0x80048104, 0xd7600002,
	0x00000901, 0x80048104,
	0xd7600003, 0x00000901,
	0x80048104, 0xf469003a,
	0xe0000000, 0x80709070,
	0xbf06a004, 0xbf84ffef,
	0xbe840380, 0xd7600000,
	0x00000902, 0x80048104,
	0xd7600001, 0x00000902,
	0x80048104, 0xd7600002,
	0x00000902, 0x80048104,
	0xd7600003, 0x00000902,
	0x80048104, 0xf469003a,
	0xe0000000, 0x80709070,
	0xbf06a004, 0xbf84ffef,
	0xbe840380, 0xd7600000,
	0x00000903, 0x80048104,
	0xd7600001, 0x00000903,
	0x80048104, 0xd7600002,
	0x00000903, 0x80048104,
	0xd7600003, 0x00000903,
	0x80048104, 0xf469003a,
	0xe0000000, 0x80709070,
	0xbf06a004, 0xbf84ffef,
	0x807c847c, 0xbf0a7b7c,
	0xbf85ffb1, 0xbf8200a6,
	0x7e008700, 0x7e028701,
	0x7e048702, 0x7e068703,
	0xe0704000, 0x705d0000,
	0xe0704080, 0x705d0100,
	0xe0704100, 0x705d0200,
	0xe0704180, 0x705d0300,
	0x807c847c, 0x8070ff70,
	0x00000200, 0xbf0a7b7c,
	0xbf85ffef, 0xbf820094,
	0xbef603ff, 0x01000000,
	0xbefc0384, 0xbf0a7b7c,
	0xbf840065, 0xb97af803,
	0x8a7a7aff, 0x10000000,
	0xbf850050, 0x7e008700,
	0x7e028701, 0x7e048702,
	0x7e068703, 0xbe840380,
	0xd7600000, 0x00000900,
	0x80048104, 0xd7600001,
	0x00000900, 0x80048104,
	0xd7600002, 0x00000900,
	0x80048104, 0xd7600003,
	0x00000900, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06c004,
	0xbf84ffef, 0xbe840380,
	0xd7600000, 0x00000901,
	0x80048104, 0xd7600001,
	0x00000901, 0x80048104,
	0xd7600002, 0x00000901,
	0x80048104, 0xd7600003,
	0x00000901, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06c004,
	0xbf84ffef, 0xbe840380,
	0xd7600000, 0x00000902,
	0x80048104, 0xd7600001,
	0x00000902, 0x80048104,
	0xd7600002, 0x00000902,
	0x80048104, 0xd7600003,
	0x00000902, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06c004,
	0xbf84ffef, 0xbe840380,
	0xd7600000, 0x00000903,
	0x80048104, 0xd7600001,
	0x00000903, 0x80048104,
	0xd7600002, 0x00000903,
	0x80048104, 0xd7600003,
	0x00000903, 0x80048104,
	0xf469003a, 0xe0000000,
	0x80709070, 0xbf06c004,
	0xbf84ffef, 0x807c847c,
	0xbf0a7b7c, 0xbf85ffb1,
	0xbf82003b, 0x7e008700,
	0x7e028701, 0x7e048702,
	0x7e068703, 0xe0704000,
	0x705d0000, 0xe0704100,
	0x705d0100, 0xe0704200,
	0x705d0200, 0xe0704300,
	0x705d0300, 0x807c847c,
	0x8070ff70, 0x00000400,
	0xbf0a7b7c, 0xbf85ffef,
	0xb97b1e06, 0x877bc17b,
	0xbf840027, 0x8f7b837b,
	0x807b7c7b, 0xbefe03c1,
	0xbeff0380, 0xb97af803,
	0x8a7a7aff, 0x10000000,
	0xbf850017, 0x7e008700,
	0xbe840380, 0xd7600000,
	0x00000900, 0x80048104,
	0xd7600001, 0x00000900,
	0x80048104, 0xd7600002,
	0x00000900, 0x80048104,
	0xd7600003, 0x00000900,
	0x80048104, 0xf469003a,
	0xe0000000, 0x80709070,
	0xbf06c004, 0xbf84ffef,
	0x807c817c, 0xbf0a7b7c,
	0xbf85ffea, 0xbf820008,
	0x7e008700, 0xe0704000,
	0x705d0000, 0x807c817c,
	0x8070ff70, 0x00000080,
	0xbf0a7b7c, 0xbf85fff8,
	0xbf82013f, 0xbef4037e,
	0x8775ff7f, 0x0000ffff,
	0x8875ff75, 0x00040000,
	0xbef60380, 0xbef703ff,
	0x10807fac, 0xb97202dc,
	0x8f729972, 0x876eff7f,
	0x04000000, 0xbf840033,
	0xbefe03c1, 0x907c9972,
	0x877c817c, 0xbf06817c,
	0xbf850002, 0xbeff0380,
	0xbf820001, 0xbeff03c1,
	0xb96f4306, 0x876fc16f,
	0xbf840028, 0x8f6f886f,
	0xbef6036f, 0xb9783a05,
	0x80788178, 0xbf0d9972,
	0xbf850002, 0x8f788978,
	0xbf820001, 0x8f788a78,
	0xb96e1e06, 0x8f6e8a6e,
	0x80786e78, 0x8078ff78,
	0x00000200, 0x8078ff78,
	0x00000080, 0xbef603ff,
	0x01000000, 0x907c9972,
	0x877c817c, 0xbf06817c,
	0xbefc0380, 0xbf850009,
	0xe0310000, 0x781d0000,
	0x807cff7c, 0x00000080,
	0x8078ff78, 0x00000080,
	0xbf0a6f7c, 0xbf85fff8,
	0xbf820008, 0xe0310000,
	0x781d0000, 0x807cff7c,
	0x00000100, 0x8078ff78,
	0x00000100, 0xbf0a6f7c,
	0xbf85fff8, 0xbef80380,
	0xbefe03c1, 0x907c9972,
	0x877c817c, 0xbf06817c,
	0xbf850002, 0xbeff0380,
	0xbf820001, 0xbeff03c1,
	0xb96f3a05, 0x806f816f,
	0x8f6f826f, 0x907c9972,
	0x877c817c, 0xbf06817c,
	0xbf850024, 0xbef603ff,
	0x01000000, 0xbeee0378,
	0x8078ff78, 0x00000200,
	0xbefc0384, 0xbf0a6f7c,
	0xbf840050, 0xe0304000,
	0x785d0000, 0xe0304080,
	0x785d0100, 0xe0304100,
	0x785d0200, 0xe0304180,
	0x785d0300, 0xbf8c0000,
	0x7e008500, 0x7e028501,
	0x7e048502, 0x7e068503,
	0x807c847c, 0x8078ff78,
	0x00000200, 0xbf0a6f7c,
	0xbf85ffee, 0xe0304000,
	0x6e5d0000, 0xe0304080,
	0x6e5d0100, 0xe0304100,
	0x6e5d0200, 0xe0304180,
	0x6e5d0300, 0xbf8c0000,
	0xbf820034, 0xbef603ff,
	0x01000000, 0xbeee0378,
	0x8078ff78, 0x00000400,
	0xbefc0384, 0xbf0a6f7c,
	0xbf840012, 0xe0304000,
	0x785d0000, 0xe0304100,
	0x785d0100, 0xe0304200,
	0x785d0200, 0xe0304300,
	0x785d0300, 0xbf8c0000,
	0x7e008500, 0x7e028501,
	0x7e048502, 0x7e068503,
	0x807c847c, 0x8078ff78,
	0x00000400, 0xbf0a6f7c,
	0xbf85ffee, 0xb96f1e06,
	0x876fc16f, 0xbf84000e,
	0x8f6f836f, 0x806f7c6f,
	0xbefe03c1, 0xbeff0380,
	0xe0304000, 0x785d0000,
	0xbf8c0000, 0x7e008500,
	0x807c817c, 0x8078ff78,
	0x00000080, 0xbf0a6f7c,
	0xbf85fff7, 0xbeff03c1,
	0xe0304000, 0x6e5d0000,
	0xe0304100, 0x6e5d0100,
	0xe0304200, 0x6e5d0200,
	0xe0304300, 0x6e5d0300,
	0xbf8c0000, 0xb9783a05,
	0x80788178, 0xbf0d9972,
	0xbf850002, 0x8f788978,
	0xbf820001, 0x8f788a78,
	0xb96e1e06, 0x8f6e8a6e,
	0x80786e78, 0x8078ff78,
	0x00000200, 0x80f8ff78,
	0x00000050, 0xbef603ff,
	0x01000000, 0xbefc03ff,
	0x0000006c, 0x80f89078,
	0xf429003a, 0xf0000000,
	0xbf8c0000, 0x80fc847c,
	0xbf800000, 0xbe803100,
	0xbe823102, 0x80f8a078,
	0xf42d003a, 0xf0000000,
	0xbf8c0000, 0x80fc887c,
	0xbf800000, 0xbe803100,
	0xbe823102, 0xbe843104,
	0xbe863106, 0x80f8c078,
	0xf431003a, 0xf0000000,
	0xbf8c0000, 0x80fc907c,
	0xbf800000, 0xbe803100,
	0xbe823102, 0xbe843104,
	0xbe863106, 0xbe883108,
	0xbe8a310a, 0xbe8c310c,
	0xbe8e310e, 0xbf06807c,
	0xbf84fff0, 0xba80f801,
	0x00000000, 0xbf8a0000,
	0xb9783a05, 0x80788178,
	0xbf0d9972, 0xbf850002,
	0x8f788978, 0xbf820001,
	0x8f788a78, 0xb96e1e06,
	0x8f6e8a6e, 0x80786e78,
	0x8078ff78, 0x00000200,
	0xbef603ff, 0x01000000,
	0xf4211bfa, 0xf0000000,
	0x80788478, 0xf4211b3a,
	0xf0000000, 0x80788478,
	0xf4211b7a, 0xf0000000,
	0x80788478, 0xf4211c3a,
	0xf0000000, 0x80788478,
	0xf4211c7a, 0xf0000000,
	0x80788478, 0xf4211eba,
	0xf0000000, 0x80788478,
	0xf4211efa, 0xf0000000,
	0x80788478, 0xf4211e7a,
	0xf0000000, 0x80788478,
	0xf4211cfa, 0xf0000000,
	0x80788478, 0xf4211bba,
	0xf0000000, 0x80788478,
	0xbf8c0000, 0xb9eef814,
	0xf4211bba, 0xf0000000,
	0x80788478, 0xbf8c0000,
	0xb9eef815, 0xbefc036f,
	0xbefe0370, 0xbeff0371,
	0xb9f9f816, 0xb9fb4803,
	0x907b8b7b, 0xb9fba2c3,
	0xb9f3f801, 0xb96e3a05,
	0x806e816e, 0xbf0d9972,
	0xbf850002, 0x8f6e896e,
	0xbf820001, 0x8f6e8a6e,
	0xb96f1e06, 0x8f6f8a6f,
	0x806e6f6e, 0x806eff6e,
	0x00000200, 0x806e746e,
	0x826f8075, 0x876fff6f,
	0x0000ffff, 0xf4091c37,
	0xfa000050, 0xf4091d37,
	0xfa000060, 0xf4011e77,
	0xfa000074, 0xbf8c0000,
	0x906e8977, 0x876fff6e,
	0x003f8000, 0x906e8677,
	0x876eff6e, 0x02000000,
	0x886e6f6e, 0xb9eef807,
	0x876dff6d, 0x0000ffff,
	0x87fe7e7e, 0x87ea6a6a,
	0xb9faf802, 0xbe80226c,
	0xbf9b0000, 0xbf9f0000,
	0xbf9f0000, 0xbf9f0000,
	0xbf9f0000, 0xbf9f0000,
};

static const uint32_t cwsr_trap_arcturus_hex[] = {
	0xbf820001, 0xbf8202d5,
	0xb8f8f802, 0x8978ff78,
	0x00020006, 0xb8fbf803,
	0x866eff78, 0x00002000,
	0xbf840009, 0x866eff6d,
	0x00ff0000, 0xbf85001e,
	0x866eff7b, 0x00000400,
	0xbf850055, 0xbf8e0010,
	0xb8fbf803, 0xbf82fffa,
	0x866eff7b, 0x03c00900,
	0xbf850015, 0x866eff7b,
	0x000071ff, 0xbf840008,
	0x866fff7b, 0x00007080,
	0xbf840001, 0xbeee1a87,
	0xb8eff801, 0x8e6e8c6e,
	0x866e6f6e, 0xbf85000a,
	0x866eff6d, 0x00ff0000,
	0xbf850007, 0xb8eef801,
	0x866eff6e, 0x00000800,
	0xbf850003, 0x866eff7b,
	0x00000400, 0xbf85003a,
	0xb8faf807, 0x867aff7a,
	0x001f8000, 0x8e7a8b7a,
	0x8977ff77, 0xfc000000,
	0x87777a77, 0xba7ff807,
	0x00000000, 0xb8faf812,
	0xb8fbf813, 0x8efa887a,
	0xbf0d8f7b, 0xbf840002,
	0x877bff7b, 0xffff0000,
	0xc0031bbd, 0x00000010,
	0xbf8cc07f, 0x8e6e976e,
	0x8977ff77, 0x00800000,
	0x87776e77, 0xc0071bbd,
	0x00000000, 0xbf8cc07f,
	0xc0071ebd, 0x00000008,
	0xbf8cc07f, 0x86ee6e6e,
	0xbf840001, 0xbe801d6e,
	0x866eff6d, 0x01ff0000,
	0xbf850005, 0x8778ff78,
	0x00002000, 0x80ec886c,
	0x82ed806d, 0xbf820005,
	0x866eff6d, 0x01000000,
	0xbf850002, 0x806c846c,
	0x826d806d, 0x866dff6d,
	0x0000ffff, 0x8f7a8b77,
	0x867aff7a, 0x001f8000,
	0xb97af807, 0x86fe7e7e,
	0x86ea6a6a, 0x8f6e8378,
	0xb96ee0c2, 0xbf800002,
	0xb9780002, 0xbe801f6c,
	0x866dff6d, 0x0000ffff,
	0xbefa0080, 0xb97a0283,
	0xb8faf807, 0x867aff7a,
	0x001f8000, 0x8e7a8b7a,
	0x8977ff77, 0xfc000000,
	0x87777a77, 0xba7ff807,
	0x00000000, 0xbeee007e,
	0xbeef007f, 0xbefe0180,
	0xbf900004, 0x877a8478,
	0xb97af802, 0xbf8e0002,
	0xbf88fffe, 0xb8fa2a05,
	0x807a817a, 0x8e7a8a7a,
	0x8e7a817a, 0xb8fb1605,
	0x807b817b, 0x8e7b867b,
	0x807a7b7a, 0x807a7e7a,
	0x827b807f, 0x867bff7b,
	0x0000ffff, 0xc04b1c3d,
	0x00000050, 0xbf8cc07f,
	0xc04b1d3d, 0x00000060,
	0xbf8cc07f, 0xc0431e7d,
	0x00000074, 0xbf8cc07f,
	0xbef4007e, 0x8675ff7f,
	0x0000ffff, 0x8775ff75,
	0x00040000, 0xbef60080,
	0xbef700ff, 0x00807fac,
	0xbef1007c, 0xbef00080,
	0xb8f02a05, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x80707a70,
	0xbef60084, 0xbef600ff,
	0x01000000, 0xbefe007c,
	0xbefc0070, 0xc0611c7a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611b3a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611b7a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611bba, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611bfa,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611e3a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xb8fbf803,
	0xbefe007c, 0xbefc0070,
	0xc0611efa, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611a3a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611a7a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xb8f1f801,
	0xbefe007c, 0xbefc0070,
	0xc0611c7a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbf108080,
	0x867aff7f, 0x04000000,
	0xbeef0080, 0x876f6f7a,
	0xb8f02a05, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fb1605, 0x807b817b,
	0x8e7b847b, 0x8e76827b,
	0xbef600ff, 0x01000000,
	0xbef20174, 0x80747074,
	0x82758075, 0xbefc0080,
	0xbf800000, 0xbe802b00,
	0xbe822b02, 0xbe842b04,
	0xbe862b06, 0xbe882b08,
	0xbe8a2b0a, 0xbe8c2b0c,
	0xbe8e2b0e, 0xc06b003a,
	0x00000000, 0xbf8cc07f,
	0xc06b013a, 0x00000010,
	0xbf8cc07f, 0xc06b023a,
	0x00000020, 0xbf8cc07f,
	0xc06b033a, 0x00000030,
	0xbf8cc07f, 0x8074c074,
	0x82758075, 0x807c907c,
	0xbf0a7b7c, 0xbf85ffe7,
	0xbef40172, 0xbef00080,
	0xbefe00c1, 0xbeff00c1,
	0xbee80080, 0xbee90080,
	0xbef600ff, 0x01000000,
	0x867aff78, 0x00400000,
	0xbf850003, 0xb8faf803,
	0x897a7aff, 0x10000000,
	0xbf85004d, 0xbe840080,
	0xd2890000, 0x00000900,
	0x80048104, 0xd2890001,
	0x00000900, 0x80048104,
	0xd2890002, 0x00000900,
	0x80048104, 0xd2890003,
	0x00000900, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000901, 0x80048104,
	0xd2890001, 0x00000901,
	0x80048104, 0xd2890002,
	0x00000901, 0x80048104,
	0xd2890003, 0x00000901,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000902,
	0x80048104, 0xd2890001,
	0x00000902, 0x80048104,
	0xd2890002, 0x00000902,
	0x80048104, 0xd2890003,
	0x00000902, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000903, 0x80048104,
	0xd2890001, 0x00000903,
	0x80048104, 0xd2890002,
	0x00000903, 0x80048104,
	0xd2890003, 0x00000903,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbf820008,
	0xe0724000, 0x701d0000,
	0xe0724100, 0x701d0100,
	0xe0724200, 0x701d0200,
	0xe0724300, 0x701d0300,
	0xbefe00c1, 0xbeff00c1,
	0xb8fb4306, 0x867bc17b,
	0xbf840064, 0xbf8a0000,
	0x867aff6f, 0x04000000,
	0xbf840060, 0x8e7b867b,
	0x8e7b827b, 0xbef6007b,
	0xb8f02a05, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x80707a70,
	0x8070ff70, 0x00000080,
	0xbef600ff, 0x01000000,
	0xbefc0080, 0xd28c0002,
	0x000100c1, 0xd28d0003,
	0x000204c1, 0x867aff78,
	0x00400000, 0xbf850003,
	0xb8faf803, 0x897a7aff,
	0x10000000, 0xbf850030,
	0x24040682, 0xd86e4000,
	0x00000002, 0xbf8cc07f,
	0xbe840080, 0xd2890000,
	0x00000900, 0x80048104,
	0xd2890001, 0x00000900,
	0x80048104, 0xd2890002,
	0x00000900, 0x80048104,
	0xd2890003, 0x00000900,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000901,
	0x80048104, 0xd2890001,
	0x00000901, 0x80048104,
	0xd2890002, 0x00000901,
	0x80048104, 0xd2890003,
	0x00000901, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0x680404ff, 0x00000200,
	0xd0c9006a, 0x0000f702,
	0xbf87ffd2, 0xbf820015,
	0xd1060002, 0x00011103,
	0x7e0602ff, 0x00000200,
	0xbefc00ff, 0x00010000,
	0xbe800077, 0x8677ff77,
	0xff7fffff, 0x8777ff77,
	0x00058000, 0xd8ec0000,
	0x00000002, 0xbf8cc07f,
	0xe0765000, 0x701d0002,
	0x68040702, 0xd0c9006a,
	0x0000f702, 0xbf87fff7,
	0xbef70000, 0xbef000ff,
	0x00000400, 0xbefe00c1,
	0xbeff00c1, 0xb8fb2a05,
	0x807b817b, 0x8e7b827b,
	0xbef600ff, 0x01000000,
	0xbefc0084, 0xbf0a7b7c,
	0xbf84006d, 0xbf11017c,
	0x807bff7b, 0x00001000,
	0x867aff78, 0x00400000,
	0xbf850003, 0xb8faf803,
	0x897a7aff, 0x10000000,
	0xbf850051, 0xbe840080,
	0xd2890000, 0x00000900,
	0x80048104, 0xd2890001,
	0x00000900, 0x80048104,
	0xd2890002, 0x00000900,
	0x80048104, 0xd2890003,
	0x00000900, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000901, 0x80048104,
	0xd2890001, 0x00000901,
	0x80048104, 0xd2890002,
	0x00000901, 0x80048104,
	0xd2890003, 0x00000901,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000902,
	0x80048104, 0xd2890001,
	0x00000902, 0x80048104,
	0xd2890002, 0x00000902,
	0x80048104, 0xd2890003,
	0x00000902, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000903, 0x80048104,
	0xd2890001, 0x00000903,
	0x80048104, 0xd2890002,
	0x00000903, 0x80048104,
	0xd2890003, 0x00000903,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0x807c847c,
	0xbf0a7b7c, 0xbf85ffb1,
	0xbf9c0000, 0xbf820012,
	0x7e000300, 0x7e020301,
	0x7e040302, 0x7e060303,
	0xe0724000, 0x701d0000,
	0xe0724100, 0x701d0100,
	0xe0724200, 0x701d0200,
	0xe0724300, 0x701d0300,
	0x807c847c, 0x8070ff70,
	0x00000400, 0xbf0a7b7c,
	0xbf85ffef, 0xbf9c0000,
	0xbefc0080, 0xbf11017c,
	0x867aff78, 0x00400000,
	0xbf850003, 0xb8faf803,
	0x897a7aff, 0x10000000,
	0xbf850059, 0xd3d84000,
	0x18000100, 0xd3d84001,
	0x18000101, 0xd3d84002,
	0x18000102, 0xd3d84003,
	0x18000103, 0xbe840080,
	0xd2890000, 0x00000900,
	0x80048104, 0xd2890001,
	0x00000900, 0x80048104,
	0xd2890002, 0x00000900,
	0x80048104, 0xd2890003,
	0x00000900, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000901, 0x80048104,
	0xd2890001, 0x00000901,
	0x80048104, 0xd2890002,
	0x00000901, 0x80048104,
	0xd2890003, 0x00000901,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000902,
	0x80048104, 0xd2890001,
	0x00000902, 0x80048104,
	0xd2890002, 0x00000902,
	0x80048104, 0xd2890003,
	0x00000902, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000903, 0x80048104,
	0xd2890001, 0x00000903,
	0x80048104, 0xd2890002,
	0x00000903, 0x80048104,
	0xd2890003, 0x00000903,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0x807c847c,
	0xbf0a7b7c, 0xbf85ffa9,
	0xbf9c0000, 0xbf820016,
	0xd3d84000, 0x18000100,
	0xd3d84001, 0x18000101,
	0xd3d84002, 0x18000102,
	0xd3d84003, 0x18000103,
	0xe0724000, 0x701d0000,
	0xe0724100, 0x701d0100,
	0xe0724200, 0x701d0200,
	0xe0724300, 0x701d0300,
	0x807c847c, 0x8070ff70,
	0x00000400, 0xbf0a7b7c,
	0xbf85ffeb, 0xbf9c0000,
	0xbf8200e3, 0xbef4007e,
	0x8675ff7f, 0x0000ffff,
	0x8775ff75, 0x00040000,
	0xbef60080, 0xbef700ff,
	0x00807fac, 0x866eff7f,
	0x04000000, 0xbf84001f,
	0xbefe00c1, 0xbeff00c1,
	0xb8ef4306, 0x866fc16f,
	0xbf84001a, 0x8e6f866f,
	0x8e6f826f, 0xbef6006f,
	0xb8f82a05, 0x80788178,
	0x8e788a78, 0x8e788178,
	0xb8ee1605, 0x806e816e,
	0x8e6e866e, 0x80786e78,
	0x8078ff78, 0x00000080,
	0xbef600ff, 0x01000000,
	0xbefc0080, 0xe0510000,
	0x781d0000, 0xe0510100,
	0x781d0000, 0x807cff7c,
	0x00000200, 0x8078ff78,
	0x00000200, 0xbf0a6f7c,
	0xbf85fff6, 0xbefe00c1,
	0xbeff00c1, 0xbef600ff,
	0x01000000, 0xb8ef2a05,
	0x806f816f, 0x8e6f826f,
	0x806fff6f, 0x00008000,
	0xbef80080, 0xbeee0078,
	0x8078ff78, 0x00000400,
	0xbefc0084, 0xbf11087c,
	0xe0524000, 0x781d0000,
	0xe0524100, 0x781d0100,
	0xe0524200, 0x781d0200,
	0xe0524300, 0x781d0300,
	0xbf8c0f70, 0x7e000300,
	0x7e020301, 0x7e040302,
	0x7e060303, 0x807c847c,
	0x8078ff78, 0x00000400,
	0xbf0a6f7c, 0xbf85ffee,
	0xbefc0080, 0xbf11087c,
	0xe0524000, 0x781d0000,
	0xe0524100, 0x781d0100,
	0xe0524200, 0x781d0200,
	0xe0524300, 0x781d0300,
	0xbf8c0f70, 0xd3d94000,
	0x18000100, 0xd3d94001,
	0x18000101, 0xd3d94002,
	0x18000102, 0xd3d94003,
	0x18000103, 0x807c847c,
	0x8078ff78, 0x00000400,
	0xbf0a6f7c, 0xbf85ffea,
	0xbf9c0000, 0xe0524000,
	0x6e1d0000, 0xe0524100,
	0x6e1d0100, 0xe0524200,
	0x6e1d0200, 0xe0524300,
	0x6e1d0300, 0xbf8c0f70,
	0xb8f82a05, 0x80788178,
	0x8e788a78, 0x8e788178,
	0xb8ee1605, 0x806e816e,
	0x8e6e866e, 0x80786e78,
	0x80f8c078, 0xb8ef1605,
	0x806f816f, 0x8e6f846f,
	0x8e76826f, 0xbef600ff,
	0x01000000, 0xbefc006f,
	0xc031003a, 0x00000078,
	0x80f8c078, 0xbf8cc07f,
	0x80fc907c, 0xbf800000,
	0xbe802d00, 0xbe822d02,
	0xbe842d04, 0xbe862d06,
	0xbe882d08, 0xbe8a2d0a,
	0xbe8c2d0c, 0xbe8e2d0e,
	0xbf06807c, 0xbf84fff0,
	0xb8f82a05, 0x80788178,
	0x8e788a78, 0x8e788178,
	0xb8ee1605, 0x806e816e,
	0x8e6e866e, 0x80786e78,
	0xbef60084, 0xbef600ff,
	0x01000000, 0xc0211bfa,
	0x00000078, 0x80788478,
	0xc0211b3a, 0x00000078,
	0x80788478, 0xc0211b7a,
	0x00000078, 0x80788478,
	0xc0211c3a, 0x00000078,
	0x80788478, 0xc0211c7a,
	0x00000078, 0x80788478,
	0xc0211eba, 0x00000078,
	0x80788478, 0xc0211efa,
	0x00000078, 0x80788478,
	0xc0211a3a, 0x00000078,
	0x80788478, 0xc0211a7a,
	0x00000078, 0x80788478,
	0xc0211cfa, 0x00000078,
	0x80788478, 0xbf8cc07f,
	0xbefc006f, 0xbefe0070,
	0xbeff0071, 0x866f7bff,
	0x000003ff, 0xb96f4803,
	0x866f7bff, 0xfffff800,
	0x8f6f8b6f, 0xb96fa2c3,
	0xb973f801, 0xb8ee2a05,
	0x806e816e, 0x8e6e8a6e,
	0x8e6e816e, 0xb8ef1605,
	0x806f816f, 0x8e6f866f,
	0x806e6f6e, 0x806e746e,
	0x826f8075, 0x866fff6f,
	0x0000ffff, 0xc00b1c37,
	0x00000050, 0xc00b1d37,
	0x00000060, 0xc0031e77,
	0x00000074, 0xbf8cc07f,
	0x8f6e8b77, 0x866eff6e,
	0x001f8000, 0xb96ef807,
	0x866dff6d, 0x0000ffff,
	0x86fe7e7e, 0x86ea6a6a,
	0x8f6e837a, 0xb96ee0c2,
	0xbf800002, 0xb97a0002,
	0xbf8a0000, 0xbe801f6c,
	0xbf9b0000, 0x00000000,
};

static const uint32_t cwsr_trap_aldebaran_hex[] = {
	0xbf820001, 0xbf8202e0,
	0xb8f8f802, 0x8978ff78,
	0x00020006, 0xb8fbf803,
	0x866eff78, 0x00002000,
	0xbf840009, 0x866eff6d,
	0x00ff0000, 0xbf85001e,
	0x866eff7b, 0x00000400,
	0xbf850055, 0xbf8e0010,
	0xb8fbf803, 0xbf82fffa,
	0x866eff7b, 0x03c00900,
	0xbf850015, 0x866eff7b,
	0x000071ff, 0xbf840008,
	0x866fff7b, 0x00007080,
	0xbf840001, 0xbeee1a87,
	0xb8eff801, 0x8e6e8c6e,
	0x866e6f6e, 0xbf85000a,
	0x866eff6d, 0x00ff0000,
	0xbf850007, 0xb8eef801,
	0x866eff6e, 0x00000800,
	0xbf850003, 0x866eff7b,
	0x00000400, 0xbf85003a,
	0xb8faf807, 0x867aff7a,
	0x001f8000, 0x8e7a8b7a,
	0x8977ff77, 0xfc000000,
	0x87777a77, 0xba7ff807,
	0x00000000, 0xb8faf812,
	0xb8fbf813, 0x8efa887a,
	0xbf0d8f7b, 0xbf840002,
	0x877bff7b, 0xffff0000,
	0xc0031bbd, 0x00000010,
	0xbf8cc07f, 0x8e6e976e,
	0x8977ff77, 0x00800000,
	0x87776e77, 0xc0071bbd,
	0x00000000, 0xbf8cc07f,
	0xc0071ebd, 0x00000008,
	0xbf8cc07f, 0x86ee6e6e,
	0xbf840001, 0xbe801d6e,
	0x866eff6d, 0x01ff0000,
	0xbf850005, 0x8778ff78,
	0x00002000, 0x80ec886c,
	0x82ed806d, 0xbf820005,
	0x866eff6d, 0x01000000,
	0xbf850002, 0x806c846c,
	0x826d806d, 0x866dff6d,
	0x0000ffff, 0x8f7a8b77,
	0x867aff7a, 0x001f8000,
	0xb97af807, 0x86fe7e7e,
	0x86ea6a6a, 0x8f6e8378,
	0xb96ee0c2, 0xbf800002,
	0xb9780002, 0xbe801f6c,
	0x866dff6d, 0x0000ffff,
	0xbefa0080, 0xb97a0283,
	0xb8faf807, 0x867aff7a,
	0x001f8000, 0x8e7a8b7a,
	0x8977ff77, 0xfc000000,
	0x87777a77, 0xba7ff807,
	0x00000000, 0xbeee007e,
	0xbeef007f, 0xbefe0180,
	0xbf900004, 0x877a8478,
	0xb97af802, 0xbf8e0002,
	0xbf88fffe, 0xb8fa2985,
	0x807a817a, 0x8e7a8a7a,
	0x8e7a817a, 0xb8fb1605,
	0x807b817b, 0x8e7b867b,
	0x807a7b7a, 0x807a7e7a,
	0x827b807f, 0x867bff7b,
	0x0000ffff, 0xc04b1c3d,
	0x00000050, 0xbf8cc07f,
	0xc04b1d3d, 0x00000060,
	0xbf8cc07f, 0xc0431e7d,
	0x00000074, 0xbf8cc07f,
	0xbef4007e, 0x8675ff7f,
	0x0000ffff, 0x8775ff75,
	0x00040000, 0xbef60080,
	0xbef700ff, 0x00807fac,
	0xbef1007c, 0xbef00080,
	0xb8f02985, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x80707a70,
	0xbef60084, 0xbef600ff,
	0x01000000, 0xbefe007c,
	0xbefc0070, 0xc0611c7a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611b3a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611b7a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611bba, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611bfa,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611e3a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xb8fbf803,
	0xbefe007c, 0xbefc0070,
	0xc0611efa, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611a3a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611a7a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xb8f1f801,
	0xbefe007c, 0xbefc0070,
	0xc0611c7a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbf108080,
	0x867aff7f, 0x04000000,
	0xbeef0080, 0x876f6f7a,
	0xb8f02985, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fb1605, 0x807b817b,
	0x8e7b847b, 0x8e76827b,
	0xbef600ff, 0x01000000,
	0xbef20174, 0x80747074,
	0x82758075, 0xbefc0080,
	0xbf800000, 0xbe802b00,
	0xbe822b02, 0xbe842b04,
	0xbe862b06, 0xbe882b08,
	0xbe8a2b0a, 0xbe8c2b0c,
	0xbe8e2b0e, 0xc06b003a,
	0x00000000, 0xbf8cc07f,
	0xc06b013a, 0x00000010,
	0xbf8cc07f, 0xc06b023a,
	0x00000020, 0xbf8cc07f,
	0xc06b033a, 0x00000030,
	0xbf8cc07f, 0x8074c074,
	0x82758075, 0x807c907c,
	0xbf0a7b7c, 0xbf85ffe7,
	0xbef40172, 0xbef00080,
	0xbefe00c1, 0xbeff00c1,
	0xbee80080, 0xbee90080,
	0xbef600ff, 0x01000000,
	0x867aff78, 0x00400000,
	0xbf850003, 0xb8faf803,
	0x897a7aff, 0x10000000,
	0xbf85004d, 0xbe840080,
	0xd2890000, 0x00000900,
	0x80048104, 0xd2890001,
	0x00000900, 0x80048104,
	0xd2890002, 0x00000900,
	0x80048104, 0xd2890003,
	0x00000900, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000901, 0x80048104,
	0xd2890001, 0x00000901,
	0x80048104, 0xd2890002,
	0x00000901, 0x80048104,
	0xd2890003, 0x00000901,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000902,
	0x80048104, 0xd2890001,
	0x00000902, 0x80048104,
	0xd2890002, 0x00000902,
	0x80048104, 0xd2890003,
	0x00000902, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000903, 0x80048104,
	0xd2890001, 0x00000903,
	0x80048104, 0xd2890002,
	0x00000903, 0x80048104,
	0xd2890003, 0x00000903,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbf820008,
	0xe0724000, 0x701d0000,
	0xe0724100, 0x701d0100,
	0xe0724200, 0x701d0200,
	0xe0724300, 0x701d0300,
	0xbefe00c1, 0xbeff00c1,
	0xb8fb4306, 0x867bc17b,
	0xbf840064, 0xbf8a0000,
	0x867aff6f, 0x04000000,
	0xbf840060, 0x8e7b867b,
	0x8e7b827b, 0xbef6007b,
	0xb8f02985, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x80707a70,
	0x8070ff70, 0x00000080,
	0xbef600ff, 0x01000000,
	0xbefc0080, 0xd28c0002,
	0x000100c1, 0xd28d0003,
	0x000204c1, 0x867aff78,
	0x00400000, 0xbf850003,
	0xb8faf803, 0x897a7aff,
	0x10000000, 0xbf850030,
	0x24040682, 0xd86e4000,
	0x00000002, 0xbf8cc07f,
	0xbe840080, 0xd2890000,
	0x00000900, 0x80048104,
	0xd2890001, 0x00000900,
	0x80048104, 0xd2890002,
	0x00000900, 0x80048104,
	0xd2890003, 0x00000900,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000901,
	0x80048104, 0xd2890001,
	0x00000901, 0x80048104,
	0xd2890002, 0x00000901,
	0x80048104, 0xd2890003,
	0x00000901, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0x680404ff, 0x00000200,
	0xd0c9006a, 0x0000f702,
	0xbf87ffd2, 0xbf820015,
	0xd1060002, 0x00011103,
	0x7e0602ff, 0x00000200,
	0xbefc00ff, 0x00010000,
	0xbe800077, 0x8677ff77,
	0xff7fffff, 0x8777ff77,
	0x00058000, 0xd8ec0000,
	0x00000002, 0xbf8cc07f,
	0xe0765000, 0x701d0002,
	0x68040702, 0xd0c9006a,
	0x0000f702, 0xbf87fff7,
	0xbef70000, 0xbef000ff,
	0x00000400, 0xbefe00c1,
	0xbeff00c1, 0xb8fb2b05,
	0x807b817b, 0x8e7b827b,
	0xbef600ff, 0x01000000,
	0xbefc0084, 0xbf0a7b7c,
	0xbf84006d, 0xbf11017c,
	0x807bff7b, 0x00001000,
	0x867aff78, 0x00400000,
	0xbf850003, 0xb8faf803,
	0x897a7aff, 0x10000000,
	0xbf850051, 0xbe840080,
	0xd2890000, 0x00000900,
	0x80048104, 0xd2890001,
	0x00000900, 0x80048104,
	0xd2890002, 0x00000900,
	0x80048104, 0xd2890003,
	0x00000900, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000901, 0x80048104,
	0xd2890001, 0x00000901,
	0x80048104, 0xd2890002,
	0x00000901, 0x80048104,
	0xd2890003, 0x00000901,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000902,
	0x80048104, 0xd2890001,
	0x00000902, 0x80048104,
	0xd2890002, 0x00000902,
	0x80048104, 0xd2890003,
	0x00000902, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000903, 0x80048104,
	0xd2890001, 0x00000903,
	0x80048104, 0xd2890002,
	0x00000903, 0x80048104,
	0xd2890003, 0x00000903,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0x807c847c,
	0xbf0a7b7c, 0xbf85ffb1,
	0xbf9c0000, 0xbf820012,
	0x7e000300, 0x7e020301,
	0x7e040302, 0x7e060303,
	0xe0724000, 0x701d0000,
	0xe0724100, 0x701d0100,
	0xe0724200, 0x701d0200,
	0xe0724300, 0x701d0300,
	0x807c847c, 0x8070ff70,
	0x00000400, 0xbf0a7b7c,
	0xbf85ffef, 0xbf9c0000,
	0xb8fb2985, 0x807b817b,
	0x8e7b837b, 0xb8fa2b05,
	0x807a817a, 0x8e7a827a,
	0x80fb7a7b, 0x867b7b7b,
	0xbf84007a, 0x807bff7b,
	0x00001000, 0xbefc0080,
	0xbf11017c, 0x867aff78,
	0x00400000, 0xbf850003,
	0xb8faf803, 0x897a7aff,
	0x10000000, 0xbf850059,
	0xd3d84000, 0x18000100,
	0xd3d84001, 0x18000101,
	0xd3d84002, 0x18000102,
	0xd3d84003, 0x18000103,
	0xbe840080, 0xd2890000,
	0x00000900, 0x80048104,
	0xd2890001, 0x00000900,
	0x80048104, 0xd2890002,
	0x00000900, 0x80048104,
	0xd2890003, 0x00000900,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000901,
	0x80048104, 0xd2890001,
	0x00000901, 0x80048104,
	0xd2890002, 0x00000901,
	0x80048104, 0xd2890003,
	0x00000901, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000902, 0x80048104,
	0xd2890001, 0x00000902,
	0x80048104, 0xd2890002,
	0x00000902, 0x80048104,
	0xd2890003, 0x00000902,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000903,
	0x80048104, 0xd2890001,
	0x00000903, 0x80048104,
	0xd2890002, 0x00000903,
	0x80048104, 0xd2890003,
	0x00000903, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0x807c847c, 0xbf0a7b7c,
	0xbf85ffa9, 0xbf9c0000,
	0xbf820016, 0xd3d84000,
	0x18000100, 0xd3d84001,
	0x18000101, 0xd3d84002,
	0x18000102, 0xd3d84003,
	0x18000103, 0xe0724000,
	0x701d0000, 0xe0724100,
	0x701d0100, 0xe0724200,
	0x701d0200, 0xe0724300,
	0x701d0300, 0x807c847c,
	0x8070ff70, 0x00000400,
	0xbf0a7b7c, 0xbf85ffeb,
	0xbf9c0000, 0xbf8200ee,
	0xbef4007e, 0x8675ff7f,
	0x0000ffff, 0x8775ff75,
	0x00040000, 0xbef60080,
	0xbef700ff, 0x00807fac,
	0x866eff7f, 0x04000000,
	0xbf84001f, 0xbefe00c1,
	0xbeff00c1, 0xb8ef4306,
	0x866fc16f, 0xbf84001a,
	0x8e6f866f, 0x8e6f826f,
	0xbef6006f, 0xb8f82985,
	0x80788178, 0x8e788a78,
	0x8e788178, 0xb8ee1605,
	0x806e816e, 0x8e6e866e,
	0x80786e78, 0x8078ff78,
	0x00000080, 0xbef600ff,
	0x01000000, 0xbefc0080,
	0xe0510000, 0x781d0000,
	0xe0510100, 0x781d0000,
	0x807cff7c, 0x00000200,
	0x8078ff78, 0x00000200,
	0xbf0a6f7c, 0xbf85fff6,
	0xbefe00c1, 0xbeff00c1,
	0xbef600ff, 0x01000000,
	0xb8ef2b05, 0x806f816f,
	0x8e6f826f, 0x806fff6f,
	0x00008000, 0xbef80080,
	0xbeee0078, 0x8078ff78,
	0x00000400, 0xbefc0084,
	0xbf11087c, 0xe0524000,
	0x781d0000, 0xe0524100,
	0x781d0100, 0xe0524200,
	0x781d0200, 0xe0524300,
	0x781d0300, 0xbf8c0f70,
	0x7e000300, 0x7e020301,
	0x7e040302, 0x7e060303,
	0x807c847c, 0x8078ff78,
	0x00000400, 0xbf0a6f7c,
	0xbf85ffee, 0xb8ef2985,
	0x806f816f, 0x8e6f836f,
	0xb8f92b05, 0x80798179,
	0x8e798279, 0x80ef796f,
	0x866f6f6f, 0xbf84001a,
	0x806fff6f, 0x00008000,
	0xbefc0080, 0xbf11087c,
	0xe0524000, 0x781d0000,
	0xe0524100, 0x781d0100,
	0xe0524200, 0x781d0200,
	0xe0524300, 0x781d0300,
	0xbf8c0f70, 0xd3d94000,
	0x18000100, 0xd3d94001,
	0x18000101, 0xd3d94002,
	0x18000102, 0xd3d94003,
	0x18000103, 0x807c847c,
	0x8078ff78, 0x00000400,
	0xbf0a6f7c, 0xbf85ffea,
	0xbf9c0000, 0xe0524000,
	0x6e1d0000, 0xe0524100,
	0x6e1d0100, 0xe0524200,
	0x6e1d0200, 0xe0524300,
	0x6e1d0300, 0xbf8c0f70,
	0xb8f82985, 0x80788178,
	0x8e788a78, 0x8e788178,
	0xb8ee1605, 0x806e816e,
	0x8e6e866e, 0x80786e78,
	0x80f8c078, 0xb8ef1605,
	0x806f816f, 0x8e6f846f,
	0x8e76826f, 0xbef600ff,
	0x01000000, 0xbefc006f,
	0xc031003a, 0x00000078,
	0x80f8c078, 0xbf8cc07f,
	0x80fc907c, 0xbf800000,
	0xbe802d00, 0xbe822d02,
	0xbe842d04, 0xbe862d06,
	0xbe882d08, 0xbe8a2d0a,
	0xbe8c2d0c, 0xbe8e2d0e,
	0xbf06807c, 0xbf84fff0,
	0xb8f82985, 0x80788178,
	0x8e788a78, 0x8e788178,
	0xb8ee1605, 0x806e816e,
	0x8e6e866e, 0x80786e78,
	0xbef60084, 0xbef600ff,
	0x01000000, 0xc0211bfa,
	0x00000078, 0x80788478,
	0xc0211b3a, 0x00000078,
	0x80788478, 0xc0211b7a,
	0x00000078, 0x80788478,
	0xc0211c3a, 0x00000078,
	0x80788478, 0xc0211c7a,
	0x00000078, 0x80788478,
	0xc0211eba, 0x00000078,
	0x80788478, 0xc0211efa,
	0x00000078, 0x80788478,
	0xc0211a3a, 0x00000078,
	0x80788478, 0xc0211a7a,
	0x00000078, 0x80788478,
	0xc0211cfa, 0x00000078,
	0x80788478, 0xbf8cc07f,
	0xbefc006f, 0xbefe0070,
	0xbeff0071, 0x866f7bff,
	0x000003ff, 0xb96f4803,
	0x866f7bff, 0xfffff800,
	0x8f6f8b6f, 0xb96fa2c3,
	0xb973f801, 0xb8ee2985,
	0x806e816e, 0x8e6e8a6e,
	0x8e6e816e, 0xb8ef1605,
	0x806f816f, 0x8e6f866f,
	0x806e6f6e, 0x806e746e,
	0x826f8075, 0x866fff6f,
	0x0000ffff, 0xc00b1c37,
	0x00000050, 0xc00b1d37,
	0x00000060, 0xc0031e77,
	0x00000074, 0xbf8cc07f,
	0x8f6e8b77, 0x866eff6e,
	0x001f8000, 0xb96ef807,
	0x866dff6d, 0x0000ffff,
	0x86fe7e7e, 0x86ea6a6a,
	0x8f6e837a, 0xb96ee0c2,
	0xbf800002, 0xb97a0002,
	0xbf8a0000, 0xbe801f6c,
	0xbf9b0000, 0x00000000,
};

static const uint32_t cwsr_trap_gfx10_hex[] = {
	0xbf820001, 0xbf820220,
	0xb0804004, 0xb978f802,
	0x8a78ff78, 0x00020006,
	0xb97bf803, 0x876eff78,
	0x00002000, 0xbf840009,
	0x876eff6d, 0x00ff0000,
	0xbf85001e, 0x876eff7b,
	0x00000400, 0xbf850045,
	0xbf8e0010, 0xb97bf803,
	0xbf82fffa, 0x876eff7b,
	0x00000900, 0xbf850015,
	0x876eff7b, 0x000071ff,
	0xbf840008, 0x876fff7b,
	0x00007080, 0xbf840001,
	0xbeee1d87, 0xb96ff801,
	0x8f6e8c6e, 0x876e6f6e,
	0xbf85000a, 0x876eff6d,
	0x00ff0000, 0xbf850007,
	0xb96ef801, 0x876eff6e,
	0x00000800, 0xbf850003,
	0x876eff7b, 0x00000400,
	0xbf85002a, 0xb97af812,
	0xb97bf813, 0x8ffa887a,
	0xbf0d8f7b, 0xbf840002,
	0x887bff7b, 0xffff0000,
	0xf4011bbd, 0xfa000010,
	0xbf8c0000, 0x8f6e976e,
	0x8a77ff77, 0x00800000,
	0x88776e77, 0xf4051bbd,
	0xfa000000, 0xbf8c0000,
	0xf4051ebd, 0xfa000008,
	0xbf8c0000, 0x87ee6e6e,
	0xbf840001, 0xbe80206e,
	0x876eff6d, 0x00ff0000,
	0xbf850008, 0x876eff6d,
	0x01000000, 0xbf850007,
	0x8878ff78, 0x00002000,
	0x80ec886c, 0x82ed806d,
	0xbf820002, 0x806c846c,
	0x826d806d, 0x876dff6d,
	0x0000ffff, 0x87fe7e7e,
	0x87ea6a6a, 0xb9f8f802,
	0xbe80226c, 0x876dff6d,
	0x0000ffff, 0xbefa0380,
	0xb9fa0283, 0xbeee037e,
	0xbeef037f, 0xbefe0480,
	0xbf900004, 0xbf8c0000,
	0x877aff7f, 0x04000000,
	0x8f7a857a, 0x886d7a6d,
	0x7e008200, 0xbefa037e,
	0x877bff7f, 0x0000ffff,
	0xbefe03c1, 0xbeff03c1,
	0xdc5f8000, 0x007a0000,
	0x7e000280, 0xbefe037a,
	0xbeff037b, 0xb97b02dc,
	0x8f7b997b, 0xb97a3a05,
	0x807a817a, 0xbf0d997b,
	0xbf850002, 0x8f7a897a,
	0xbf820001, 0x8f7a8a7a,
	0xb97b1e06, 0x8f7b8a7b,
	0x807a7b7a, 0x877bff7f,
	0x0000ffff, 0x807aff7a,
	0x00000200, 0x807a7e7a,
	0x827b807b, 0xd7610000,
	0x00010870, 0xd7610000,
	0x00010a71, 0xd7610000,
	0x00010c72, 0xd7610000,
	0x00010e73, 0xd7610000,
	0x00011074, 0xd7610000,
	0x00011275, 0xd7610000,
	0x00011476, 0xd7610000,
	0x00011677, 0xd7610000,
	0x00011a79, 0xd7610000,
	0x00011c7e, 0xd7610000,
	0x00011e7f, 0xbefe03ff,
	0x00003fff, 0xbeff0380,
	0xdc5f8040, 0x007a0000,
	0xd760007a, 0x00011d00,
	0xd760007b, 0x00011f00,
	0xbefe037a, 0xbeff037b,
	0xbef4037e, 0x8775ff7f,
	0x0000ffff, 0x8875ff75,
	0x00040000, 0xbef60380,
	0xbef703ff, 0x10807fac,
	0xbef1037c, 0xbef00380,
	0xb97302dc, 0x8f739973,
	0xbefe03c1, 0x907c9973,
	0x877c817c, 0xbf06817c,
	0xbf850002, 0xbeff0380,
	0xbf820002, 0xbeff03c1,
	0xbf820009, 0xbef603ff,
	0x01000000, 0xe0704080,
	0x705d0100, 0xe0704100,
	0x705d0200, 0xe0704180,
	0x705d0300, 0xbf820008,
	0xbef603ff, 0x01000000,
	0xe0704100, 0x705d0100,
	0xe0704200, 0x705d0200,
	0xe0704300, 0x705d0300,
	0xb9703a05, 0x80708170,
	0xbf0d9973, 0xbf850002,
	0x8f708970, 0xbf820001,
	0x8f708a70, 0xb97a1e06,
	0x8f7a8a7a, 0x80707a70,
	0x8070ff70, 0x00000200,
	0xbef603ff, 0x01000000,
	0x7e000280, 0x7e020280,
	0x7e040280, 0xbefc0380,
	0xd7610002, 0x0000f871,
	0x807c817c, 0xd7610002,
	0x0000f86c, 0x807c817c,
	0x8a7aff6d, 0x80000000,
	0xd7610002, 0x0000f87a,
	0x807c817c, 0xd7610002,
	0x0000f86e, 0x807c817c,
	0xd7610002, 0x0000f86f,
	0x807c817c, 0xd7610002,
	0x0000f878, 0x807c817c,
	0xb97af803, 0xd7610002,
	0x0000f87a, 0x807c817c,
	0xd7610002, 0x0000f87b,
	0x807c817c, 0xb971f801,
	0xd7610002, 0x0000f871,
	0x807c817c, 0xb971f814,
	0xd7610002, 0x0000f871,
	0x807c817c, 0xb971f815,
	0xd7610002, 0x0000f871,
	0x807c817c, 0xbefe03ff,
	0x0000ffff, 0xbeff0380,
	0xe0704000, 0x705d0200,
	0xbefe03c1, 0xb9703a05,
	0x80708170, 0xbf0d9973,
	0xbf850002, 0x8f708970,
	0xbf820001, 0x8f708a70,
	0xb97a1e06, 0x8f7a8a7a,
	0x80707a70, 0xbef603ff,
	0x01000000, 0xbef90380,
	0xbefc0380, 0xbf800000,
	0xbe802f00, 0xbe822f02,
	0xbe842f04, 0xbe862f06,
	0xbe882f08, 0xbe8a2f0a,
	0xbe8c2f0c, 0xbe8e2f0e,
	0xd7610002, 0x0000f200,
	0x80798179, 0xd7610002,
	0x0000f201, 0x80798179,
	0xd7610002, 0x0000f202,
	0x80798179, 0xd7610002,
	0x0000f203, 0x80798179,
	0xd7610002, 0x0000f204,
	0x80798179, 0xd7610002,
	0x0000f205, 0x80798179,
	0xd7610002, 0x0000f206,
	0x80798179, 0xd7610002,
	0x0000f207, 0x80798179,
	0xd7610002, 0x0000f208,
	0x80798179, 0xd7610002,
	0x0000f209, 0x80798179,
	0xd7610002, 0x0000f20a,
	0x80798179, 0xd7610002,
	0x0000f20b, 0x80798179,
	0xd7610002, 0x0000f20c,
	0x80798179, 0xd7610002,
	0x0000f20d, 0x80798179,
	0xd7610002, 0x0000f20e,
	0x80798179, 0xd7610002,
	0x0000f20f, 0x80798179,
	0xbf06a079, 0xbf840006,
	0xe0704000, 0x705d0200,
	0x8070ff70, 0x00000080,
	0xbef90380, 0x7e040280,
	0x807c907c, 0xbf0aff7c,
	0x00000060, 0xbf85ffbc,
	0xbe802f00, 0xbe822f02,
	0xbe842f04, 0xbe862f06,
	0xbe882f08, 0xbe8a2f0a,
	0xd7610002, 0x0000f200,
	0x80798179, 0xd7610002,
	0x0000f201, 0x80798179,
	0xd7610002, 0x0000f202,
	0x80798179, 0xd7610002,
	0x0000f203, 0x80798179,
	0xd7610002, 0x0000f204,
	0x80798179, 0xd7610002,
	0x0000f205, 0x80798179,
	0xd7610002, 0x0000f206,
	0x80798179, 0xd7610002,
	0x0000f207, 0x80798179,
	0xd7610002, 0x0000f208,
	0x80798179, 0xd7610002,
	0x0000f209, 0x80798179,
	0xd7610002, 0x0000f20a,
	0x80798179, 0xd7610002,
	0x0000f20b, 0x80798179,
	0xe0704000, 0x705d0200,
	0xbefe03c1, 0x907c9973,
	0x877c817c, 0xbf06817c,
	0xbf850002, 0xbeff0380,
	0xbf820001, 0xbeff03c1,
	0xb97b4306, 0x877bc17b,
	0xbf840043, 0xbf8a0000,
	0x877aff6d, 0x80000000,
	0xbf84003f, 0x8f7b887b,
	0xbef6037b, 0xb9703a05,
	0x80708170, 0xbf0d9973,
	0xbf850002, 0x8f708970,
	0xbf820001, 0x8f708a70,
	0xb97a1e06, 0x8f7a8a7a,
	0x80707a70, 0x8070ff70,
	0x00000200, 0x8070ff70,
	0x00000080, 0xbef603ff,
	0x01000000, 0xd7650000,
	0x000100c1, 0xd7660000,
	0x000200c1, 0x16000084,
	0x907c9973, 0x877c817c,
	0xbf06817c, 0xbefc0380,
	0xbf850012, 0xbe8303ff,
	0x00000080, 0xbf800000,
	0xbf800000, 0xbf800000,
	0xd8d80000, 0x01000000,
	0xbf8c0000, 0xe0704000,
	0x705d0100, 0x807c037c,
	0x80700370, 0xd5250000,
	0x0001ff00, 0x00000080,
	0xbf0a7b7c, 0xbf85fff4,
	0xbf820011, 0xbe8303ff,
	0x00000100, 0xbf800000,
	0xbf800000, 0xbf800000,
	0xd8d80000, 0x01000000,
	0xbf8c0000, 0xe0704000,
	0x705d0100, 0x807c037c,
	0x80700370, 0xd5250000,
	0x0001ff00, 0x00000100,
	0xbf0a7b7c, 0xbf85fff4,
	0xbefe03c1, 0x907c9973,
	0x877c817c, 0xbf06817c,
	0xbf850004, 0xbef003ff,
	0x00000200, 0xbeff0380,
	0xbf820003, 0xbef003ff,
	0x00000400, 0xbeff03c1,
	0xb97b3a05, 0x807b817b,
	0x8f7b827b, 0x907c9973,
	0x877c817c, 0xbf06817c,
	0xbf850017, 0xbef603ff,
	0x01000000, 0xbefc0384,
	0xbf0a7b7c, 0xbf840037,
	0x7e008700, 0x7e028701,
	0x7e048702, 0x7e068703,
	0xe0704000, 0x705d0000,
	0xe0704080, 0x705d0100,
	0xe0704100, 0x705d0200,
	0xe0704180, 0x705d0300,
	0x807c847c, 0x8070ff70,
	0x00000200, 0xbf0a7b7c,
	0xbf85ffef, 0xbf820025,
	0xbef603ff, 0x01000000,
	0xbefc0384, 0xbf0a7b7c,
	0xbf840011, 0x7e008700,
	0x7e028701, 0x7e048702,
	0x7e068703, 0xe0704000,
	0x705d0000, 0xe0704100,
	0x705d0100, 0xe0704200,
	0x705d0200, 0xe0704300,
	0x705d0300, 0x807c847c,
	0x8070ff70, 0x00000400,
	0xbf0a7b7c, 0xbf85ffef,
	0xb97b1e06, 0x877bc17b,
	0xbf84000c, 0x8f7b837b,
	0x807b7c7b, 0xbefe03c1,
	0xbeff0380, 0x7e008700,
	0xe0704000, 0x705d0000,
	0x807c817c, 0x8070ff70,
	0x00000080, 0xbf0a7b7c,
	0xbf85fff8, 0xbf820136,
	0xbef4037e, 0x8775ff7f,
	0x0000ffff, 0x8875ff75,
	0x00040000, 0xbef60380,
	0xbef703ff, 0x10807fac,
	0xb97202dc, 0x8f729972,
	0x876eff7f, 0x04000000,
	0xbf840033, 0xbefe03c1,
	0x907c9972, 0x877c817c,
	0xbf06817c, 0xbf850002,
	0xbeff0380, 0xbf820001,
	0xbeff03c1, 0xb96f4306,
	0x876fc16f, 0xbf840028,
	0x8f6f886f, 0xbef6036f,
	0xb9783a05, 0x80788178,
	0xbf0d9972, 0xbf850002,
	0x8f788978, 0xbf820001,
	0x8f788a78, 0xb96e1e06,
	0x8f6e8a6e, 0x80786e78,
	0x8078ff78, 0x00000200,
	0x8078ff78, 0x00000080,
	0xbef603ff, 0x01000000,
	0x907c9972, 0x877c817c,
	0xbf06817c, 0xbefc0380,
	0xbf850009, 0xe0310000,
	0x781d0000, 0x807cff7c,
	0x00000080, 0x8078ff78,
	0x00000080, 0xbf0a6f7c,
	0xbf85fff8, 0xbf820008,
	0xe0310000, 0x781d0000,
	0x807cff7c, 0x00000100,
	0x8078ff78, 0x00000100,
	0xbf0a6f7c, 0xbf85fff8,
	0xbef80380, 0xbefe03c1,
	0x907c9972, 0x877c817c,
	0xbf06817c, 0xbf850002,
	0xbeff0380, 0xbf820001,
	0xbeff03c1, 0xb96f3a05,
	0x806f816f, 0x8f6f826f,
	0x907c9972, 0x877c817c,
	0xbf06817c, 0xbf850024,
	0xbef603ff, 0x01000000,
	0xbeee0378, 0x8078ff78,
	0x00000200, 0xbefc0384,
	0xbf0a6f7c, 0xbf840050,
	0xe0304000, 0x785d0000,
	0xe0304080, 0x785d0100,
	0xe0304100, 0x785d0200,
	0xe0304180, 0x785d0300,
	0xbf8c0000, 0x7e008500,
	0x7e028501, 0x7e048502,
	0x7e068503, 0x807c847c,
	0x8078ff78, 0x00000200,
	0xbf0a6f7c, 0xbf85ffee,
	0xe0304000, 0x6e5d0000,
	0xe0304080, 0x6e5d0100,
	0xe0304100, 0x6e5d0200,
	0xe0304180, 0x6e5d0300,
	0xbf8c0000, 0xbf820034,
	0xbef603ff, 0x01000000,
	0xbeee0378, 0x8078ff78,
	0x00000400, 0xbefc0384,
	0xbf0a6f7c, 0xbf840012,
	0xe0304000, 0x785d0000,
	0xe0304100, 0x785d0100,
	0xe0304200, 0x785d0200,
	0xe0304300, 0x785d0300,
	0xbf8c0000, 0x7e008500,
	0x7e028501, 0x7e048502,
	0x7e068503, 0x807c847c,
	0x8078ff78, 0x00000400,
	0xbf0a6f7c, 0xbf85ffee,
	0xb96f1e06, 0x876fc16f,
	0xbf84000e, 0x8f6f836f,
	0x806f7c6f, 0xbefe03c1,
	0xbeff0380, 0xe0304000,
	0x785d0000, 0xbf8c0000,
	0x7e008500, 0x807c817c,
	0x8078ff78, 0x00000080,
	0xbf0a6f7c, 0xbf85fff7,
	0xbeff03c1, 0xe0304000,
	0x6e5d0000, 0xe0304100,
	0x6e5d0100, 0xe0304200,
	0x6e5d0200, 0xe0304300,
	0x6e5d0300, 0xbf8c0000,
	0xb9783a05, 0x80788178,
	0xbf0d9972, 0xbf850002,
	0x8f788978, 0xbf820001,
	0x8f788a78, 0xb96e1e06,
	0x8f6e8a6e, 0x80786e78,
	0x8078ff78, 0x00000200,
	0x80f8ff78, 0x00000050,
	0xbef603ff, 0x01000000,
	0xbefc03ff, 0x0000006c,
	0x80f89078, 0xf429003a,
	0xf0000000, 0xbf8c0000,
	0x80fc847c, 0xbf800000,
	0xbe803100, 0xbe823102,
	0x80f8a078, 0xf42d003a,
	0xf0000000, 0xbf8c0000,
	0x80fc887c, 0xbf800000,
	0xbe803100, 0xbe823102,
	0xbe843104, 0xbe863106,
	0x80f8c078, 0xf431003a,
	0xf0000000, 0xbf8c0000,
	0x80fc907c, 0xbf800000,
	0xbe803100, 0xbe823102,
	0xbe843104, 0xbe863106,
	0xbe883108, 0xbe8a310a,
	0xbe8c310c, 0xbe8e310e,
	0xbf06807c, 0xbf84fff0,
	0xba80f801, 0x00000000,
	0xbf8a0000, 0xb9783a05,
	0x80788178, 0xbf0d9972,
	0xbf850002, 0x8f788978,
	0xbf820001, 0x8f788a78,
	0xb96e1e06, 0x8f6e8a6e,
	0x80786e78, 0x8078ff78,
	0x00000200, 0xbef603ff,
	0x01000000, 0xf4211bfa,
	0xf0000000, 0x80788478,
	0xf4211b3a, 0xf0000000,
	0x80788478, 0xf4211b7a,
	0xf0000000, 0x80788478,
	0xf4211c3a, 0xf0000000,
	0x80788478, 0xf4211c7a,
	0xf0000000, 0x80788478,
	0xf4211eba, 0xf0000000,
	0x80788478, 0xf4211efa,
	0xf0000000, 0x80788478,
	0xf4211e7a, 0xf0000000,
	0x80788478, 0xf4211cfa,
	0xf0000000, 0x80788478,
	0xf4211bba, 0xf0000000,
	0x80788478, 0xbf8c0000,
	0xb9eef814, 0xf4211bba,
	0xf0000000, 0x80788478,
	0xbf8c0000, 0xb9eef815,
	0xbefc036f, 0xbefe0370,
	0xbeff0371, 0xb9fb4803,
	0x907b8b7b, 0xb9fba2c3,
	0xb9f3f801, 0xb96e3a05,
	0x806e816e, 0xbf0d9972,
	0xbf850002, 0x8f6e896e,
	0xbf820001, 0x8f6e8a6e,
	0xb96f1e06, 0x8f6f8a6f,
	0x806e6f6e, 0x806eff6e,
	0x00000200, 0x806e746e,
	0x826f8075, 0x876fff6f,
	0x0000ffff, 0xf4091c37,
	0xfa000050, 0xf4091d37,
	0xfa000060, 0xf4011e77,
	0xfa000074, 0xbf8c0000,
	0x876dff6d, 0x0000ffff,
	0x87fe7e7e, 0x87ea6a6a,
	0xb9faf802, 0xbe80226c,
	0xbf9b0000, 0xbf9f0000,
	0xbf9f0000, 0xbf9f0000,
	0xbf9f0000, 0xbf9f0000,
};

static const uint32_t cwsr_trap_gfx11_hex[] = {
	0xbfa00001, 0xbfa00227,
	0xb0804006, 0xb8f8f802,
	0x9178ff78, 0x00020006,
	0xb8fbf803, 0xbf0d9e6d,
	0xbfa10001, 0xbfbd0000,
	0xbf0d9f6d, 0xbfa20006,
	0x8b6eff78, 0x00002000,
	0xbfa10009, 0x8b6eff6d,
	0x00ff0000, 0xbfa2001e,
	0x8b6eff7b, 0x00000400,
	0xbfa20045, 0xbf830010,
	0xb8fbf803, 0xbfa0fffa,
	0x8b6eff7b, 0x00160900,
	0xbfa20015, 0x8b6eff7b,
	0x000071ff, 0xbfa10008,
	0x8b6fff7b, 0x00007080,
	0xbfa10001, 0xbeee1287,
	0xb8eff801, 0x846e8c6e,
	0x8b6e6f6e, 0xbfa2000a,
	0x8b6eff6d, 0x00ff0000,
	0xbfa20007, 0xb8eef801,
	0x8b6eff6e, 0x00000800,
	0xbfa20003, 0x8b6eff7b,
	0x00000400, 0xbfa2002a,
	0xbefa4d82, 0xbf890000,
	0x84fa887a, 0xbf0d8f7b,
	0xbfa10002, 0x8c7bff7b,
	0xffff0000, 0xf4005bbd,
	0xf8000010, 0xbf890000,
	0x846e976e, 0x9177ff77,
	0x00800000, 0x8c776e77,
	0xf4045bbd, 0xf8000000,
	0xbf890000, 0xf4045ebd,
	0xf8000008, 0xbf890000,
	0x8bee6e6e, 0xbfa10001,
	0xbe80486e, 0x8b6eff6d,
	0x00ff0000, 0xbfa20008,
	0x8b6eff6d, 0x01000000,
	0xbfa20007, 0x8c78ff78,
	0x00002000, 0x80ec886c,
	0x82ed806d, 0xbfa00002,
	0x806c846c, 0x826d806d,
	0x8b6dff6d, 0x0000ffff,
	0x8bfe7e7e, 0x8bea6a6a,
	0xb978f802, 0xbe804a6c,
	0xbf0d9878, 0xbfa10001,
	0xbfb00000, 0x8b6dff6d,
	0x0000ffff, 0xbefa0080,
	0xb97a0283, 0xbeee007e,
	0xbeef007f, 0xbefe0180,
	0xbefe4d84, 0xbf890000,
	0x8b7aff7f, 0x04000000,
	0x847a857a, 0x8c6d7a6d,
	0xbefa007e, 0x8b7bff7f,
	0x0000ffff, 0xbefe00c1,
	0xbeff00c1, 0xdca6c000,
	0x007a0000, 0x7e000280,
	0xbefe007a, 0xbeff007b,
	0xb8fb02dc, 0x847b997b,
	0xb8fa3b05, 0x807a817a,
	0xbf0d997b, 0xbfa20002,
	0x847a897a, 0xbfa00001,
	0x847a8a7a, 0xb8fb1e06,
	0x847b8a7b, 0x807a7b7a,
	0x8b7bff7f, 0x0000ffff,
	0x807aff7a, 0x00000200,
	0x807a7e7a, 0x827b807b,
	0xd7610000, 0x00010870,
	0xd7610000, 0x00010a71,
	0xd7610000, 0x00010c72,
	0xd7610000, 0x00010e73,
	0xd7610000, 0x00011074,
	0xd7610000, 0x00011275,
	0xd7610000, 0x00011476,
	0xd7610000, 0x00011677,
	0xd7610000, 0x00011a79,
	0xd7610000, 0x00011c7e,
	0xd7610000, 0x00011e7f,
	0xbefe00ff, 0x00003fff,
	0xbeff0080, 0xdca6c040,
	0x007a0000, 0xd760007a,
	0x00011d00, 0xd760007b,
	0x00011f00, 0xbefe007a,
	0xbeff007b, 0xbef4007e,
	0x8b75ff7f, 0x0000ffff,
	0x8c75ff75, 0x00040000,
	0xbef60080, 0xbef700ff,
	0x10807fac, 0xbef1007d,
	0xbef00080, 0xb8f302dc,
	0x84739973, 0xbefe00c1,
	0x857d9973, 0x8b7d817d,
	0xbf06817d, 0xbfa20002,
	0xbeff0080, 0xbfa00002,
	0xbeff00c1, 0xbfa00009,
	0xbef600ff, 0x01000000,
	0xe0685080, 0x701d0100,
	0xe0685100, 0x701d0200,
	0xe0685180, 0x701d0300,
	0xbfa00008, 0xbef600ff,
	0x01000000, 0xe0685100,
	0x701d0100, 0xe0685200,
	0x701d0200, 0xe0685300,
	0x701d0300, 0xb8f03b05,
	0x80708170, 0xbf0d9973,
	0xbfa20002, 0x84708970,
	0xbfa00001, 0x84708a70,
	0xb8fa1e06, 0x847a8a7a,
	0x80707a70, 0x8070ff70,
	0x00000200, 0xbef600ff,
	0x01000000, 0x7e000280,
	0x7e020280, 0x7e040280,
	0xbefd0080, 0xd7610002,
	0x0000fa71, 0x807d817d,
	0xd7610002, 0x0000fa6c,
	0x807d817d, 0x917aff6d,
	0x80000000, 0xd7610002,
	0x0000fa7a, 0x807d817d,
	0xd7610002, 0x0000fa6e,
	0x807d817d, 0xd7610002,
	0x0000fa6f, 0x807d817d,
	0xd7610002, 0x0000fa78,
	0x807d817d, 0xb8faf803,
	0xd7610002, 0x0000fa7a,
	0x807d817d, 0xd7610002,
	0x0000fa7b, 0x807d817d,
	0xb8f1f801, 0xd7610002,
	0x0000fa71, 0x807d817d,
	0xb8f1f814, 0xd7610002,
	0x0000fa71, 0x807d817d,
	0xb8f1f815, 0xd7610002,
	0x0000fa71, 0x807d817d,
	0xbefe00ff, 0x0000ffff,
	0xbeff0080, 0xe0685000,
	0x701d0200, 0xbefe00c1,
	0xb8f03b05, 0x80708170,
	0xbf0d9973, 0xbfa20002,
	0x84708970, 0xbfa00001,
	0x84708a70, 0xb8fa1e06,
	0x847a8a7a, 0x80707a70,
	0xbef600ff, 0x01000000,
	0xbef90080, 0xbefd0080,
	0xbf800000, 0xbe804100,
	0xbe824102, 0xbe844104,
	0xbe864106, 0xbe884108,
	0xbe8a410a, 0xbe8c410c,
	0xbe8e410e, 0xd7610002,
	0x0000f200, 0x80798179,
	0xd7610002, 0x0000f201,
	0x80798179, 0xd7610002,
	0x0000f202, 0x80798179,
	0xd7610002, 0x0000f203,
	0x80798179, 0xd7610002,
	0x0000f204, 0x80798179,
	0xd7610002, 0x0000f205,
	0x80798179, 0xd7610002,
	0x0000f206, 0x80798179,
	0xd7610002, 0x0000f207,
	0x80798179, 0xd7610002,
	0x0000f208, 0x80798179,
	0xd7610002, 0x0000f209,
	0x80798179, 0xd7610002,
	0x0000f20a, 0x80798179,
	0xd7610002, 0x0000f20b,
	0x80798179, 0xd7610002,
	0x0000f20c, 0x80798179,
	0xd7610002, 0x0000f20d,
	0x80798179, 0xd7610002,
	0x0000f20e, 0x80798179,
	0xd7610002, 0x0000f20f,
	0x80798179, 0xbf06a079,
	0xbfa10006, 0xe0685000,
	0x701d0200, 0x8070ff70,
	0x00000080, 0xbef90080,
	0x7e040280, 0x807d907d,
	0xbf0aff7d, 0x00000060,
	0xbfa2ffbc, 0xbe804100,
	0xbe824102, 0xbe844104,
	0xbe864106, 0xbe884108,
	0xbe8a410a, 0xd7610002,
	0x0000f200, 0x80798179,
	0xd7610002, 0x0000f201,
	0x80798179, 0xd7610002,
	0x0000f202, 0x80798179,
	0xd7610002, 0x0000f203,
	0x80798179, 0xd7610002,
	0x0000f204, 0x80798179,
	0xd7610002, 0x0000f205,
	0x80798179, 0xd7610002,
	0x0000f206, 0x80798179,
	0xd7610002, 0x0000f207,
	0x80798179, 0xd7610002,
	0x0000f208, 0x80798179,
	0xd7610002, 0x0000f209,
	0x80798179, 0xd7610002,
	0x0000f20a, 0x80798179,
	0xd7610002, 0x0000f20b,
	0x80798179, 0xe0685000,
	0x701d0200, 0xbefe00c1,
	0x857d9973, 0x8b7d817d,
	0xbf06817d, 0xbfa20002,
	0xbeff0080, 0xbfa00001,
	0xbeff00c1, 0xb8fb4306,
	0x8b7bc17b, 0xbfa10043,
	0xbfbd0000, 0x8b7aff6d,
	0x80000000, 0xbfa1003f,
	0x847b887b, 0xbef6007b,
	0xb8f03b05, 0x80708170,
	0xbf0d9973, 0xbfa20002,
	0x84708970, 0xbfa00001,
	0x84708a70, 0xb8fa1e06,
	0x847a8a7a, 0x80707a70,
	0x8070ff70, 0x00000200,
	0x8070ff70, 0x00000080,
	0xbef600ff, 0x01000000,
	0xd71f0000, 0x000100c1,
	0xd7200000, 0x000200c1,
	0x16000084, 0x857d9973,
	0x8b7d817d, 0xbf06817d,
	0xbefd0080, 0xbfa20012,
	0xbe8300ff, 0x00000080,
	0xbf800000, 0xbf800000,
	0xbf800000, 0xd8d80000,
	0x01000000, 0xbf890000,
	0xe0685000, 0x701d0100,
	0x807d037d, 0x80700370,
	0xd5250000, 0x0001ff00,
	0x00000080, 0xbf0a7b7d,
	0xbfa2fff4, 0xbfa00011,
	0xbe8300ff, 0x00000100,
	0xbf800000, 0xbf800000,
	0xbf800000, 0xd8d80000,
	0x01000000, 0xbf890000,
	0xe0685000, 0x701d0100,
	0x807d037d, 0x80700370,
	0xd5250000, 0x0001ff00,
	0x00000100, 0xbf0a7b7d,
	0xbfa2fff4, 0xbefe00c1,
	0x857d9973, 0x8b7d817d,
	0xbf06817d, 0xbfa20004,
	0xbef000ff, 0x00000200,
	0xbeff0080, 0xbfa00003,
	0xbef000ff, 0x00000400,
	0xbeff00c1, 0xb8fb3b05,
	0x807b817b, 0x847b827b,
	0x857d9973, 0x8b7d817d,
	0xbf06817d, 0xbfa20017,
	0xbef600ff, 0x01000000,
	0xbefd0084, 0xbf0a7b7d,
	0xbfa10037, 0x7e008700,
	0x7e028701, 0x7e048702,
	0x7e068703, 0xe0685000,
	0x701d0000, 0xe0685080,
	0x701d0100, 0xe0685100,
	0x701d0200, 0xe0685180,
	0x701d0300, 0x807d847d,
	0x8070ff70, 0x00000200,
	0xbf0a7b7d, 0xbfa2ffef,
	0xbfa00025, 0xbef600ff,
	0x01000000, 0xbefd0084,
	0xbf0a7b7d, 0xbfa10011,
	0x7e008700, 0x7e028701,
	0x7e048702, 0x7e068703,
	0xe0685000, 0x701d0000,
	0xe0685100, 0x701d0100,
	0xe0685200, 0x701d0200,
	0xe0685300, 0x701d0300,
	0x807d847d, 0x8070ff70,
	0x00000400, 0xbf0a7b7d,
	0xbfa2ffef, 0xb8fb1e06,
	0x8b7bc17b, 0xbfa1000c,
	0x847b837b, 0x807b7d7b,
	0xbefe00c1, 0xbeff0080,
	0x7e008700, 0xe0685000,
	0x701d0000, 0x807d817d,
	0x8070ff70, 0x00000080,
	0xbf0a7b7d, 0xbfa2fff8,
	0xbfa00143, 0xbef4007e,
	0x8b75ff7f, 0x0000ffff,
	0x8c75ff75, 0x00040000,
	0xbef60080, 0xbef700ff,
	0x10807fac, 0xb8f202dc,
	0x84729972, 0x8b6eff7f,
	0x04000000, 0xbfa10039,
	0xbefe00c1, 0x857d9972,
	0x8b7d817d, 0xbf06817d,
	0xbfa20002, 0xbeff0080,
	0xbfa00001, 0xbeff00c1,
	0xb8ef4306, 0x8b6fc16f,
	0xbfa1002e, 0x846f886f,
	0xbef6006f, 0xb8f83b05,
	0x80788178, 0xbf0d9972,
	0xbfa20002, 0x84788978,
	0xbfa00001, 0x84788a78,
	0xb8ee1e06, 0x846e8a6e,
	0x80786e78, 0x8078ff78,
	0x00000200, 0x8078ff78,
	0x00000080, 0xbef600ff,
	0x01000000, 0x857d9972,
	0x8b7d817d, 0xbf06817d,
	0xbefd0080, 0xbfa2000c,
	0xe0500000, 0x781d0000,
	0xbf890000, 0xdac00000,
	0x00000000, 0x807dff7d,
	0x00000080, 0x8078ff78,
	0x00000080, 0xbf0a6f7d,
	0xbfa2fff5, 0xbfa0000b,
	0xe0500000, 0x781d0000,
	0xbf890000, 0xdac00000,
	0x00000000, 0x807dff7d,
	0x00000100, 0x8078ff78,
	0x00000100, 0xbf0a6f7d,
	0xbfa2fff5, 0xbef80080,
	0xbefe00c1, 0x857d9972,
	0x8b7d817d, 0xbf06817d,
	0xbfa20002, 0xbeff0080,
	0xbfa00001, 0xbeff00c1,
	0xb8ef3b05, 0x806f816f,
	0x846f826f, 0x857d9972,
	0x8b7d817d, 0xbf06817d,
	0xbfa20024, 0xbef600ff,
	0x01000000, 0xbeee0078,
	0x8078ff78, 0x00000200,
	0xbefd0084, 0xbf0a6f7d,
	0xbfa10050, 0xe0505000,
	0x781d0000, 0xe0505080,
	0x781d0100, 0xe0505100,
	0x781d0200, 0xe0505180,
	0x781d0300, 0xbf890000,
	0x7e008500, 0x7e028501,
	0x7e048502, 0x7e068503,
	0x807d847d, 0x8078ff78,
	0x00000200, 0xbf0a6f7d,
	0xbfa2ffee, 0xe0505000,
	0x6e1d0000, 0xe0505080,
	0x6e1d0100, 0xe0505100,
	0x6e1d0200, 0xe0505180,
	0x6e1d0300, 0xbf890000,
	0xbfa00034, 0xbef600ff,
	0x01000000, 0xbeee0078,
	0x8078ff78, 0x00000400,
	0xbefd0084, 0xbf0a6f7d,
	0xbfa10012, 0xe0505000,
	0x781d0000, 0xe0505100,
	0x781d0100, 0xe0505200,
	0x781d0200, 0xe0505300,
	0x781d0300, 0xbf890000,
	0x7e008500, 0x7e028501,
	0x7e048502, 0x7e068503,
	0x807d847d, 0x8078ff78,
	0x00000400, 0xbf0a6f7d,
	0xbfa2ffee, 0xb8ef1e06,
	0x8b6fc16f, 0xbfa1000e,
	0x846f836f, 0x806f7d6f,
	0xbefe00c1, 0xbeff0080,
	0xe0505000, 0x781d0000,
	0xbf890000, 0x7e008500,
	0x807d817d, 0x8078ff78,
	0x00000080, 0xbf0a6f7d,
	0xbfa2fff7, 0xbeff00c1,
	0xe0505000, 0x6e1d0000,
	0xe0505100, 0x6e1d0100,
	0xe0505200, 0x6e1d0200,
	0xe0505300, 0x6e1d0300,
	0xbf890000, 0xb8f83b05,
	0x80788178, 0xbf0d9972,
	0xbfa20002, 0x84788978,
	0xbfa00001, 0x84788a78,
	0xb8ee1e06, 0x846e8a6e,
	0x80786e78, 0x8078ff78,
	0x00000200, 0x80f8ff78,
	0x00000050, 0xbef600ff,
	0x01000000, 0xbefd00ff,
	0x0000006c, 0x80f89078,
	0xf428403a, 0xf0000000,
	0xbf890000, 0x80fd847d,
	0xbf800000, 0xbe804300,
	0xbe824302, 0x80f8a078,
	0xf42c403a, 0xf0000000,
	0xbf890000, 0x80fd887d,
	0xbf800000, 0xbe804300,
	0xbe824302, 0xbe844304,
	0xbe864306, 0x80f8c078,
	0xf430403a, 0xf0000000,
	0xbf890000, 0x80fd907d,
	0xbf800000, 0xbe804300,
	0xbe824302, 0xbe844304,
	0xbe864306, 0xbe884308,
	0xbe8a430a, 0xbe8c430c,
	0xbe8e430e, 0xbf06807d,
	0xbfa1fff0, 0xb980f801,
	0x00000000, 0xbfbd0000,
	0xb8f83b05, 0x80788178,
	0xbf0d9972, 0xbfa20002,
	0x84788978, 0xbfa00001,
	0x84788a78, 0xb8ee1e06,
	0x846e8a6e, 0x80786e78,
	0x8078ff78, 0x00000200,
	0xbef600ff, 0x01000000,
	0xf4205bfa, 0xf0000000,
	0x80788478, 0xf4205b3a,
	0xf0000000, 0x80788478,
	0xf4205b7a, 0xf0000000,
	0x80788478, 0xf4205c3a,
	0xf0000000, 0x80788478,
	0xf4205c7a, 0xf0000000,
	0x80788478, 0xf4205eba,
	0xf0000000, 0x80788478,
	0xf4205efa, 0xf0000000,
	0x80788478, 0xf4205e7a,
	0xf0000000, 0x80788478,
	0xf4205cfa, 0xf0000000,
	0x80788478, 0xf4205bba,
	0xf0000000, 0x80788478,
	0xbf890000, 0xb96ef814,
	0xf4205bba, 0xf0000000,
	0x80788478, 0xbf890000,
	0xb96ef815, 0xbefd006f,
	0xbefe0070, 0xbeff0071,
	0xb97b4803, 0x857b8b7b,
	0xb97b22c3, 0x857b867b,
	0xb97b7443, 0xb973f801,
	0xb8ee3b05, 0x806e816e,
	0xbf0d9972, 0xbfa20002,
	0x846e896e, 0xbfa00001,
	0x846e8a6e, 0xb8ef1e06,
	0x846f8a6f, 0x806e6f6e,
	0x806eff6e, 0x00000200,
	0x806e746e, 0x826f8075,
	0x8b6fff6f, 0x0000ffff,
	0xf4085c37, 0xf8000050,
	0xf4085d37, 0xf8000060,
	0xf4005e77, 0xf8000074,
	0xbf890000, 0x8b6dff6d,
	0x0000ffff, 0x8bfe7e7e,
	0x8bea6a6a, 0xb8eef802,
	0xbf0d866e, 0xbfa20002,
	0xb97af802, 0xbe80486c,
	0xb97af802, 0xbe804a6c,
	0xbfb10000, 0xbf9f0000,
	0xbf9f0000, 0xbf9f0000,
	0xbf9f0000, 0xbf9f0000,
};

static const uint32_t cwsr_trap_gfx9_4_3_hex[] = {
	0xbf820001, 0xbf8202dc,
	0xb8f8f802, 0x8978ff78,
	0x00020006, 0xb8fbf803,
	0x866eff78, 0x00002000,
	0xbf840009, 0x866eff6d,
	0x00ff0000, 0xbf85001a,
	0x866eff7b, 0x00000400,
	0xbf850051, 0xbf8e0010,
	0xb8fbf803, 0xbf82fffa,
	0x866eff7b, 0x03c00900,
	0xbf850011, 0x866eff7b,
	0x000071ff, 0xbf840008,
	0x866fff7b, 0x00007080,
	0xbf840001, 0xbeee1a87,
	0xb8eff801, 0x8e6e8c6e,
	0x866e6f6e, 0xbf850006,
	0x866eff6d, 0x00ff0000,
	0xbf850003, 0x866eff7b,
	0x00000400, 0xbf85003a,
	0xb8faf807, 0x867aff7a,
	0x001f8000, 0x8e7a8b7a,
	0x8979ff79, 0xfc000000,
	0x87797a79, 0xba7ff807,
	0x00000000, 0xb8faf812,
	0xb8fbf813, 0x8efa887a,
	0xbf0d8f7b, 0xbf840002,
	0x877bff7b, 0xffff0000,
	0xc0031bbd, 0x00000010,
	0xbf8cc07f, 0x8e6e976e,
	0x8979ff79, 0x00800000,
	0x87796e79, 0xc0071bbd,
	0x00000000, 0xbf8cc07f,
	0xc0071ebd, 0x00000008,
	0xbf8cc07f, 0x86ee6e6e,
	0xbf840001, 0xbe801d6e,
	0x866eff6d, 0x01ff0000,
	0xbf850005, 0x8778ff78,
	0x00002000, 0x80ec886c,
	0x82ed806d, 0xbf820005,
	0x866eff6d, 0x01000000,
	0xbf850002, 0x806c846c,
	0x826d806d, 0x866dff6d,
	0x0000ffff, 0x8f7a8b79,
	0x867aff7a, 0x001f8000,
	0xb97af807, 0x86fe7e7e,
	0x86ea6a6a, 0x8f6e8378,
	0xb96ee0c2, 0xbf800002,
	0xb9780002, 0xbe801f6c,
	0x866dff6d, 0x0000ffff,
	0xbefa0080, 0xb97a0283,
	0xb8faf807, 0x867aff7a,
	0x001f8000, 0x8e7a8b7a,
	0x8979ff79, 0xfc000000,
	0x87797a79, 0xba7ff807,
	0x00000000, 0xbeee007e,
	0xbeef007f, 0xbefe0180,
	0xbf900004, 0x877a8478,
	0xb97af802, 0xbf8e0002,
	0xbf88fffe, 0xb8fa2985,
	0x807a817a, 0x8e7a8a7a,
	0x8e7a817a, 0xb8fb1605,
	0x807b817b, 0x8e7b867b,
	0x807a7b7a, 0x807a7e7a,
	0x827b807f, 0x867bff7b,
	0x0000ffff, 0xc04b1c3d,
	0x00000050, 0xbf8cc07f,
	0xc04b1d3d, 0x00000060,
	0xbf8cc07f, 0xc0431e7d,
	0x00000074, 0xbf8cc07f,
	0xbef4007e, 0x8675ff7f,
	0x0000ffff, 0x8775ff75,
	0x00040000, 0xbef60080,
	0xbef700ff, 0x00807fac,
	0xbef1007c, 0xbef00080,
	0xb8f02985, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x80707a70,
	0xbef60084, 0xbef600ff,
	0x01000000, 0xbefe007c,
	0xbefc0070, 0xc0611c7a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611b3a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611b7a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611bba, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611bfa,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611e3a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xb8fbf803,
	0xbefe007c, 0xbefc0070,
	0xc0611efa, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611a3a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611a7a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xb8f1f801,
	0xbefe007c, 0xbefc0070,
	0xc0611c7a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbf108080,
	0x867aff7f, 0x04000000,
	0xbeef0080, 0x876f6f7a,
	0xb8f02985, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fb1605, 0x807b817b,
	0x8e7b847b, 0x8e76827b,
	0xbef600ff, 0x01000000,
	0xbef20174, 0x80747074,
	0x82758075, 0xbefc0080,
	0xbf800000, 0xbe802b00,
	0xbe822b02, 0xbe842b04,
	0xbe862b06, 0xbe882b08,
	0xbe8a2b0a, 0xbe8c2b0c,
	0xbe8e2b0e, 0xc06b003a,
	0x00000000, 0xbf8cc07f,
	0xc06b013a, 0x00000010,
	0xbf8cc07f, 0xc06b023a,
	0x00000020, 0xbf8cc07f,
	0xc06b033a, 0x00000030,
	0xbf8cc07f, 0x8074c074,
	0x82758075, 0x807c907c,
	0xbf0a7b7c, 0xbf85ffe7,
	0xbef40172, 0xbef00080,
	0xbefe00c1, 0xbeff00c1,
	0xbee80080, 0xbee90080,
	0xbef600ff, 0x01000000,
	0x867aff78, 0x00400000,
	0xbf850003, 0xb8faf803,
	0x897a7aff, 0x10000000,
	0xbf85004d, 0xbe840080,
	0xd2890000, 0x00000900,
	0x80048104, 0xd2890001,
	0x00000900, 0x80048104,
	0xd2890002, 0x00000900,
	0x80048104, 0xd2890003,
	0x00000900, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000901, 0x80048104,
	0xd2890001, 0x00000901,
	0x80048104, 0xd2890002,
	0x00000901, 0x80048104,
	0xd2890003, 0x00000901,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000902,
	0x80048104, 0xd2890001,
	0x00000902, 0x80048104,
	0xd2890002, 0x00000902,
	0x80048104, 0xd2890003,
	0x00000902, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000903, 0x80048104,
	0xd2890001, 0x00000903,
	0x80048104, 0xd2890002,
	0x00000903, 0x80048104,
	0xd2890003, 0x00000903,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbf820008,
	0xe0724000, 0x701d0000,
	0xe0724100, 0x701d0100,
	0xe0724200, 0x701d0200,
	0xe0724300, 0x701d0300,
	0xbefe00c1, 0xbeff00c1,
	0xb8fb4306, 0x867bc17b,
	0xbf840064, 0xbf8a0000,
	0x867aff6f, 0x04000000,
	0xbf840060, 0x8e7b867b,
	0x8e7b827b, 0xbef6007b,
	0xb8f02985, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x80707a70,
	0x8070ff70, 0x00000080,
	0xbef600ff, 0x01000000,
	0xbefc0080, 0xd28c0002,
	0x000100c1, 0xd28d0003,
	0x000204c1, 0x867aff78,
	0x00400000, 0xbf850003,
	0xb8faf803, 0x897a7aff,
	0x10000000, 0xbf850030,
	0x24040682, 0xd86e4000,
	0x00000002, 0xbf8cc07f,
	0xbe840080, 0xd2890000,
	0x00000900, 0x80048104,
	0xd2890001, 0x00000900,
	0x80048104, 0xd2890002,
	0x00000900, 0x80048104,
	0xd2890003, 0x00000900,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000901,
	0x80048104, 0xd2890001,
	0x00000901, 0x80048104,
	0xd2890002, 0x00000901,
	0x80048104, 0xd2890003,
	0x00000901, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0x680404ff, 0x00000200,
	0xd0c9006a, 0x0000f702,
	0xbf87ffd2, 0xbf820015,
	0xd1060002, 0x00011103,
	0x7e0602ff, 0x00000200,
	0xbefc00ff, 0x00010000,
	0xbe800077, 0x8677ff77,
	0xff7fffff, 0x8777ff77,
	0x00058000, 0xd8ec0000,
	0x00000002, 0xbf8cc07f,
	0xe0765000, 0x701d0002,
	0x68040702, 0xd0c9006a,
	0x0000f702, 0xbf87fff7,
	0xbef70000, 0xbef000ff,
	0x00000400, 0xbefe00c1,
	0xbeff00c1, 0xb8fb2b05,
	0x807b817b, 0x8e7b827b,
	0xbef600ff, 0x01000000,
	0xbefc0084, 0xbf0a7b7c,
	0xbf84006d, 0xbf11017c,
	0x807bff7b, 0x00001000,
	0x867aff78, 0x00400000,
	0xbf850003, 0xb8faf803,
	0x897a7aff, 0x10000000,
	0xbf850051, 0xbe840080,
	0xd2890000, 0x00000900,
	0x80048104, 0xd2890001,
	0x00000900, 0x80048104,
	0xd2890002, 0x00000900,
	0x80048104, 0xd2890003,
	0x00000900, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000901, 0x80048104,
	0xd2890001, 0x00000901,
	0x80048104, 0xd2890002,
	0x00000901, 0x80048104,
	0xd2890003, 0x00000901,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000902,
	0x80048104, 0xd2890001,
	0x00000902, 0x80048104,
	0xd2890002, 0x00000902,
	0x80048104, 0xd2890003,
	0x00000902, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000903, 0x80048104,
	0xd2890001, 0x00000903,
	0x80048104, 0xd2890002,
	0x00000903, 0x80048104,
	0xd2890003, 0x00000903,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0x807c847c,
	0xbf0a7b7c, 0xbf85ffb1,
	0xbf9c0000, 0xbf820012,
	0x7e000300, 0x7e020301,
	0x7e040302, 0x7e060303,
	0xe0724000, 0x701d0000,
	0xe0724100, 0x701d0100,
	0xe0724200, 0x701d0200,
	0xe0724300, 0x701d0300,
	0x807c847c, 0x8070ff70,
	0x00000400, 0xbf0a7b7c,
	0xbf85ffef, 0xbf9c0000,
	0xb8fb2985, 0x807b817b,
	0x8e7b837b, 0xb8fa2b05,
	0x807a817a, 0x8e7a827a,
	0x80fb7a7b, 0x867b7b7b,
	0xbf84007a, 0x807bff7b,
	0x00001000, 0xbefc0080,
	0xbf11017c, 0x867aff78,
	0x00400000, 0xbf850003,
	0xb8faf803, 0x897a7aff,
	0x10000000, 0xbf850059,
	0xd3d84000, 0x18000100,
	0xd3d84001, 0x18000101,
	0xd3d84002, 0x18000102,
	0xd3d84003, 0x18000103,
	0xbe840080, 0xd2890000,
	0x00000900, 0x80048104,
	0xd2890001, 0x00000900,
	0x80048104, 0xd2890002,
	0x00000900, 0x80048104,
	0xd2890003, 0x00000900,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000901,
	0x80048104, 0xd2890001,
	0x00000901, 0x80048104,
	0xd2890002, 0x00000901,
	0x80048104, 0xd2890003,
	0x00000901, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000902, 0x80048104,
	0xd2890001, 0x00000902,
	0x80048104, 0xd2890002,
	0x00000902, 0x80048104,
	0xd2890003, 0x00000902,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000903,
	0x80048104, 0xd2890001,
	0x00000903, 0x80048104,
	0xd2890002, 0x00000903,
	0x80048104, 0xd2890003,
	0x00000903, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0x807c847c, 0xbf0a7b7c,
	0xbf85ffa9, 0xbf9c0000,
	0xbf820016, 0xd3d84000,
	0x18000100, 0xd3d84001,
	0x18000101, 0xd3d84002,
	0x18000102, 0xd3d84003,
	0x18000103, 0xe0724000,
	0x701d0000, 0xe0724100,
	0x701d0100, 0xe0724200,
	0x701d0200, 0xe0724300,
	0x701d0300, 0x807c847c,
	0x8070ff70, 0x00000400,
	0xbf0a7b7c, 0xbf85ffeb,
	0xbf9c0000, 0xbf8200ee,
	0xbef4007e, 0x8675ff7f,
	0x0000ffff, 0x8775ff75,
	0x00040000, 0xbef60080,
	0xbef700ff, 0x00807fac,
	0x866eff7f, 0x04000000,
	0xbf84001f, 0xbefe00c1,
	0xbeff00c1, 0xb8ef4306,
	0x866fc16f, 0xbf84001a,
	0x8e6f866f, 0x8e6f826f,
	0xbef6006f, 0xb8f82985,
	0x80788178, 0x8e788a78,
	0x8e788178, 0xb8ee1605,
	0x806e816e, 0x8e6e866e,
	0x80786e78, 0x8078ff78,
	0x00000080, 0xbef600ff,
	0x01000000, 0xbefc0080,
	0xe0510000, 0x781d0000,
	0xe0510100, 0x781d0000,
	0x807cff7c, 0x00000200,
	0x8078ff78, 0x00000200,
	0xbf0a6f7c, 0xbf85fff6,
	0xbefe00c1, 0xbeff00c1,
	0xbef600ff, 0x01000000,
	0xb8ef2b05, 0x806f816f,
	0x8e6f826f, 0x806fff6f,
	0x00008000, 0xbef80080,
	0xbeee0078, 0x8078ff78,
	0x00000400, 0xbefc0084,
	0xbf11087c, 0xe0524000,
	0x781d0000, 0xe0524100,
	0x781d0100, 0xe0524200,
	0x781d0200, 0xe0524300,
	0x781d0300, 0xbf8c0f70,
	0x7e000300, 0x7e020301,
	0x7e040302, 0x7e060303,
	0x807c847c, 0x8078ff78,
	0x00000400, 0xbf0a6f7c,
	0xbf85ffee, 0xb8ef2985,
	0x806f816f, 0x8e6f836f,
	0xb8f92b05, 0x80798179,
	0x8e798279, 0x80ef796f,
	0x866f6f6f, 0xbf84001a,
	0x806fff6f, 0x00008000,
	0xbefc0080, 0xbf11087c,
	0xe0524000, 0x781d0000,
	0xe0524100, 0x781d0100,
	0xe0524200, 0x781d0200,
	0xe0524300, 0x781d0300,
	0xbf8c0f70, 0xd3d94000,
	0x18000100, 0xd3d94001,
	0x18000101, 0xd3d94002,
	0x18000102, 0xd3d94003,
	0x18000103, 0x807c847c,
	0x8078ff78, 0x00000400,
	0xbf0a6f7c, 0xbf85ffea,
	0xbf9c0000, 0xe0524000,
	0x6e1d0000, 0xe0524100,
	0x6e1d0100, 0xe0524200,
	0x6e1d0200, 0xe0524300,
	0x6e1d0300, 0xbf8c0f70,
	0xb8f82985, 0x80788178,
	0x8e788a78, 0x8e788178,
	0xb8ee1605, 0x806e816e,
	0x8e6e866e, 0x80786e78,
	0x80f8c078, 0xb8ef1605,
	0x806f816f, 0x8e6f846f,
	0x8e76826f, 0xbef600ff,
	0x01000000, 0xbefc006f,
	0xc031003a, 0x00000078,
	0x80f8c078, 0xbf8cc07f,
	0x80fc907c, 0xbf800000,
	0xbe802d00, 0xbe822d02,
	0xbe842d04, 0xbe862d06,
	0xbe882d08, 0xbe8a2d0a,
	0xbe8c2d0c, 0xbe8e2d0e,
	0xbf06807c, 0xbf84fff0,
	0xb8f82985, 0x80788178,
	0x8e788a78, 0x8e788178,
	0xb8ee1605, 0x806e816e,
	0x8e6e866e, 0x80786e78,
	0xbef60084, 0xbef600ff,
	0x01000000, 0xc0211bfa,
	0x00000078, 0x80788478,
	0xc0211b3a, 0x00000078,
	0x80788478, 0xc0211b7a,
	0x00000078, 0x80788478,
	0xc0211c3a, 0x00000078,
	0x80788478, 0xc0211c7a,
	0x00000078, 0x80788478,
	0xc0211eba, 0x00000078,
	0x80788478, 0xc0211efa,
	0x00000078, 0x80788478,
	0xc0211a3a, 0x00000078,
	0x80788478, 0xc0211a7a,
	0x00000078, 0x80788478,
	0xc0211cfa, 0x00000078,
	0x80788478, 0xbf8cc07f,
	0xbefc006f, 0xbefe0070,
	0xbeff0071, 0x866f7bff,
	0x000003ff, 0xb96f4803,
	0x866f7bff, 0xfffff800,
	0x8f6f8b6f, 0xb96fa2c3,
	0xb973f801, 0xb8ee2985,
	0x806e816e, 0x8e6e8a6e,
	0x8e6e816e, 0xb8ef1605,
	0x806f816f, 0x8e6f866f,
	0x806e6f6e, 0x806e746e,
	0x826f8075, 0x866fff6f,
	0x0000ffff, 0xc00b1c37,
	0x00000050, 0xc00b1d37,
	0x00000060, 0xc0031e77,
	0x00000074, 0xbf8cc07f,
	0x8f6e8b79, 0x866eff6e,
	0x001f8000, 0xb96ef807,
	0x866dff6d, 0x0000ffff,
	0x86fe7e7e, 0x86ea6a6a,
	0x8f6e837a, 0xb96ee0c2,
	0xbf800002, 0xb97a0002,
	0xbf8a0000, 0xbe801f6c,
	0xbf9b0000, 0x00000000,
};

static const uint32_t cwsr_trap_gfx12_hex[] = {
	0xbfa00001, 0xbfa002a2,
	0xb0804009, 0xb8f8f804,
	0x9178ff78, 0x00008c00,
	0xb8fbf811, 0x8b6eff78,
	0x00004000, 0xbfa10008,
	0x8b6eff7b, 0x00000080,
	0xbfa20018, 0x8b6ea07b,
	0xbfa20042, 0xbf830010,
	0xb8fbf811, 0xbfa0fffb,
	0x8b6eff7b, 0x00000bd0,
	0xbfa20010, 0xb8eef812,
	0x8b6f8f7b, 0xbfa10002,
	0x8c6eff6e, 0x00000080,
	0xb8eff813, 0x8b6e6e6f,
	0xbfa20008, 0x8b6eff6d,
	0xf0000000, 0xbfa20005,
	0x8b6fff6f, 0x00000200,
	0xbfa20002, 0x8b6ea07b,
	0xbfa2002c, 0xbefa4d82,
	0xbf8a0000, 0x84fa887a,
	0xbf0d8f7b, 0xbfa10002,
	0x8c7bff7b, 0xffff0000,
	0xf4601bbd, 0xf8000010,
	0xbf8a0000, 0x846e976e,
	0x9177ff77, 0x00800000,
	0x8c776e77, 0xf4603bbd,
	0xf8000000, 0xbf8a0000,
	0xf4603ebd, 0xf8000008,
	0xbf8a0000, 0x8bee6e6e,
	0xbfa10001, 0xbe80486e,
	0x8b6eff6d, 0xf0000000,
	0xbfa20009, 0xb8eef811,
	0x8b6eff6e, 0x00000080,
	0xbfa20007, 0x8c78ff78,
	0x00004000, 0x80ec886c,
	0x82ed806d, 0xbfa00002,
	0x806c846c, 0x826d806d,
	0x8b6dff6d, 0x0000ffff,
	0x8bfe7e7e, 0x8bea6a6a,
	0x85788978, 0xb9783244,
	0xbe804a6c, 0xb8faf802,
	0xbf0d987a, 0xbfa10001,
	0xbfb00000, 0x8b6dff6d,
	0x0000ffff, 0xbefa0080,
	0xb97a0151, 0xbeee007e,
	0xbeef007f, 0xbefe0180,
	0xbefe4d84, 0xbf8a0000,
	0x8b7aff7f, 0x04000000,
	0x847a857a, 0x8c6d7a6d,
	0xbefa007e, 0x8b7bff7f,
	0x0000ffff, 0xbefe00c1,
	0xbeff00c1, 0xee0a407a,
	0x000c0000, 0x00000000,
	0x7e000280, 0xbefe007a,
	0xbeff007b, 0xb8fb0742,
	0x847b997b, 0xb8fa3b05,
	0x807a817a, 0xbf0d997b,
	0xbfa20002, 0x847a897a,
	0xbfa00001, 0x847a8a7a,
	0xb8fb1e06, 0x847b8a7b,
	0x807a7b7a, 0x8b7bff7f,
	0x0000ffff, 0x807aff7a,
	0x00000200, 0x807a7e7a,
	0x827b807b, 0xd7610000,
	0x00010870, 0xd7610000,
	0x00010a71, 0xd7610000,
	0x00010c72, 0xd7610000,
	0x00010e73, 0xd7610000,
	0x00011074, 0xd7610000,
	0x00011275, 0xd7610000,
	0x00011476, 0xd7610000,
	0x00011677, 0xd7610000,
	0x00011a79, 0xd7610000,
	0x00011c7e, 0xd7610000,
	0x00011e7f, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xbefe00ff,
	0x00003fff, 0xbeff0080,
	0xee0a407a, 0x000c0000,
	0x00004000, 0xd760007a,
	0x00011d00, 0xd760007b,
	0x00011f00, 0xbefe007a,
	0xbeff007b, 0xbef4007e,
	0x8b75ff7f, 0x0000ffff,
	0x8c75ff75, 0x00040000,
	0xbef60080, 0xbef700ff,
	0x10807fac, 0xbef1007d,
	0xbef00080, 0xb8f30742,
	0x84739973, 0xbefe00c1,
	0x857d9973, 0x8b7d817d,
	0xbf06817d, 0xbfa20002,
	0xbeff0080, 0xbfa00002,
	0xbeff00c1, 0xbfa0000c,
	0xbef600ff, 0x01000000,
	0xc4068070, 0x008ce801,
	0x00008000, 0xc4068070,
	0x008ce802, 0x00010000,
	0xc4068070, 0x008ce803,
	0x00018000, 0xbfa0000b,
	0xbef600ff, 0x01000000,
	0xc4068070, 0x008ce801,
	0x00010000, 0xc4068070,
	0x008ce802, 0x00020000,
	0xc4068070, 0x008ce803,
	0x00030000, 0xb8f03b05,
	0x80708170, 0xbf0d9973,
	0xbfa20002, 0x84708970,
	0xbfa00001, 0x84708a70,
	0xb8fa1e06, 0x847a8a7a,
	0x80707a70, 0x8070ff70,
	0x00000200, 0xbef600ff,
	0x01000000, 0x7e000280,
	0x7e020280, 0x7e040280,
	0xbe804ec2, 0xbf94fffe,
	0xb8faf804, 0x8b7a847a,
	0x91788478, 0x8c787a78,
	0x917aff6d, 0x80000000,
	0xd7610002, 0x00010071,
	0xd7610002, 0x0001026c,
	0xd7610002, 0x0001047a,
	0xd7610002, 0x0001066e,
	0xd7610002, 0x0001086f,
	0xd7610002, 0x00010a78,
	0xd7610002, 0x00010e7b,
	0xd8500000, 0x00000000,
	0xd8500000, 0x00000000,
	0xd8500000, 0x00000000,
	0xd8500000, 0x00000000,
	0xd8500000, 0x00000000,
	0xd8500000, 0x00000000,
	0xd8500000, 0x00000000,
	0xd8500000, 0x00000000,
	0xb8faf811, 0xd7610002,
	0x00010c7a, 0xb8faf801,
	0xd7610002, 0x0001107a,
	0xb8faf814, 0xd7610002,
	0x0001127a, 0xb8faf815,
	0xd7610002, 0x0001147a,
	0xb8faf812, 0xd7610002,
	0x0001167a, 0xb8faf813,
	0xd7610002, 0x0001187a,
	0xb8faf802, 0xd7610002,
	0x00011a7a, 0xbefa50c1,
	0xbfc70000, 0xd7610002,
	0x00011c7a, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xbefe00ff,
	0x0000ffff, 0xbeff0080,
	0xc4068070, 0x008ce802,
	0x00000000, 0xbefe00c1,
	0xb8f03b05, 0x80708170,
	0xbf0d9973, 0xbfa20002,
	0x84708970, 0xbfa00001,
	0x84708a70, 0xb8fa1e06,
	0x847a8a7a, 0x80707a70,
	0xbef600ff, 0x01000000,
	0xbef90080, 0xbefd0080,
	0xbf800000, 0xbe804100,
	0xbe824102, 0xbe844104,
	0xbe864106, 0xbe884108,
	0xbe8a410a, 0xbe8c410c,
	0xbe8e410e, 0xbf068079,
	0xbfa10032, 0xd7610002,
	0x00010000, 0xd7610002,
	0x00010201, 0xd7610002,
	0x00010402, 0xd7610002,
	0x00010603, 0xd7610002,
	0x00010804, 0xd7610002,
	0x00010a05, 0xd7610002,
	0x00010c06, 0xd7610002,
	0x00010e07, 0xd7610002,
	0x00011008, 0xd7610002,
	0x00011209, 0xd7610002,
	0x0001140a, 0xd7610002,
	0x0001160b, 0xd7610002,
	0x0001180c, 0xd7610002,
	0x00011a0d, 0xd7610002,
	0x00011c0e, 0xd7610002,
	0x00011e0f, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0x80799079,
	0xbfa00038, 0xd7610002,
	0x00012000, 0xd7610002,
	0x00012201, 0xd7610002,
	0x00012402, 0xd7610002,
	0x00012603, 0xd7610002,
	0x00012804, 0xd7610002,
	0x00012a05, 0xd7610002,
	0x00012c06, 0xd7610002,
	0x00012e07, 0xd7610002,
	0x00013008, 0xd7610002,
	0x00013209, 0xd7610002,
	0x0001340a, 0xd7610002,
	0x0001360b, 0xd7610002,
	0x0001380c, 0xd7610002,
	0x00013a0d, 0xd7610002,
	0x00013c0e, 0xd7610002,
	0x00013e0f, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0x80799079,
	0xc4068070, 0x008ce802,
	0x00000000, 0x8070ff70,
	0x00000080, 0xbef90080,
	0x7e040280, 0x807d907d,
	0xbf0aff7d, 0x00000060,
	0xbfa2ff88, 0xbe804100,
	0xbe824102, 0xbe844104,
	0xbe864106, 0xbe884108,
	0xbe8a410a, 0xd7610002,
	0x00010000, 0xd7610002,
	0x00010201, 0xd7610002,
	0x00010402, 0xd7610002,
	0x00010603, 0xd7610002,
	0x00010804, 0xd7610002,
	0x00010a05, 0xd7610002,
	0x00010c06, 0xd7610002,
	0x00010e07, 0xd7610002,
	0x00011008, 0xd7610002,
	0x00011209, 0xd7610002,
	0x0001140a, 0xd7610002,
	0x0001160b, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xd8500000,
	0x00000000, 0xc4068070,
	0x008ce802, 0x00000000,
	0xbefe00c1, 0x857d9973,
	0x8b7d817d, 0xbf06817d,
	0xbfa20002, 0xbeff0080,
	0xbfa00001, 0xbeff00c1,
	0xb8fb4306, 0x8b7bc17b,
	0xbfa10044, 0x8b7aff6d,
	0x80000000, 0xbfa10041,
	0x847b897b, 0xbef6007b,
	0xb8f03b05, 0x80708170,
	0xbf0d9973, 0xbfa20002,
	0x84708970, 0xbfa00001,
	0x84708a70, 0xb8fa1e06,
	0x847a8a7a, 0x80707a70,
	0x8070ff70, 0x00000200,
	0x8070ff70, 0x00000080,
	0xbef600ff, 0x01000000,
	0xd71f0000, 0x000100c1,
	0xd7200000, 0x000200c1,
	0x16000084, 0x857d9973,
	0x8b7d817d, 0xbf06817d,
	0xbefd0080, 0xbfa20013,
	0xbe8300ff, 0x00000080,
	0xbf800000, 0xbf800000,
	0xbf800000, 0xd8d80000,
	0x01000000, 0xbf8a0000,
	0xc4068070, 0x008ce801,
	0x00000000, 0x807d037d,
	0x80700370, 0xd5250000,
	0x0001ff00, 0x00000080,
	0xbf0a7b7d, 0xbfa2fff3,
	0xbfa00012, 0xbe8300ff,
	0x00000100, 0xbf800000,
	0xbf800000, 0xbf800000,
	0xd8d80000, 0x01000000,
	0xbf8a0000, 0xc4068070,
	0x008ce801, 0x00000000,
	0x807d037d, 0x80700370,
	0xd5250000, 0x0001ff00,
	0x00000100, 0xbf0a7b7d,
	0xbfa2fff3, 0xbefe00c1,
	0x857d9973, 0x8b7d817d,
	0xbf06817d, 0xbfa20004,
	0xbef000ff, 0x00000200,
	0xbeff0080, 0xbfa00003,
	0xbef000ff, 0x00000400,
	0xbeff00c1, 0xb8fb3b05,
	0x807b817b, 0x847b827b,
	0x857d9973, 0x8b7d817d,
	0xbf06817d, 0xbfa2001b,
	0xbef600ff, 0x01000000,
	0xbefd0084, 0xbf0a7b7d,
	0xbfa10040, 0x7e008700,
	0x7e028701, 0x7e048702,
	0x7e068703, 0xc4068070,
	0x008ce800, 0x00000000,
	0xc4068070, 0x008ce801,
	0x00008000, 0xc4068070,
	0x008ce802, 0x00010000,
	0xc4068070, 0x008ce803,
	0x00018000, 0x807d847d,
	0x8070ff70, 0x00000200,
	0xbf0a7b7d, 0xbfa2ffeb,
	0xbfa0002a, 0xbef600ff,
	0x01000000, 0xbefd0084,
	0xbf0a7b7d, 0xbfa10015,
	0x7e008700, 0x7e028701,
	0x7e048702, 0x7e068703,
	0xc4068070, 0x008ce800,
	0x00000000, 0xc4068070,
	0x008ce801, 0x00010000,
	0xc4068070, 0x008ce802,
	0x00020000, 0xc4068070,
	0x008ce803, 0x00030000,
	0x807d847d, 0x8070ff70,
	0x00000400, 0xbf0a7b7d,
	0xbfa2ffeb, 0xb8fb1e06,
	0x8b7bc17b, 0xbfa1000d,
	0x847b837b, 0x807b7d7b,
	0xbefe00c1, 0xbeff0080,
	0x7e008700, 0xc4068070,
	0x008ce800, 0x00000000,
	0x807d817d, 0x8070ff70,
	0x00000080, 0xbf0a7b7d,
	0xbfa2fff7, 0xbfa0016e,
	0xbef4007e, 0x8b75ff7f,
	0x0000ffff, 0x8c75ff75,
	0x00040000, 0xbef60080,
	0xbef700ff, 0x10807fac,
	0xbef1007f, 0xb8f20742,
	0x84729972, 0x8b6eff7f,
	0x04000000, 0xbfa1003b,
	0xbefe00c1, 0x857d9972,
	0x8b7d817d, 0xbf06817d,
	0xbfa20002, 0xbeff0080,
	0xbfa00001, 0xbeff00c1,
	0xb8ef4306, 0x8b6fc16f,
	0xbfa10030, 0x846f896f,
	0xbef6006f, 0xb8f83b05,
	0x80788178, 0xbf0d9972,
	0xbfa20002, 0x84788978,
	0xbfa00001, 0x84788a78,
	0xb8ee1e06, 0x846e8a6e,
	0x80786e78, 0x8078ff78,
	0x00000200, 0x8078ff78,
	0x00000080, 0xbef600ff,
	0x01000000, 0x857d9972,
	0x8b7d817d, 0xbf06817d,
	0xbefd0080, 0xbfa2000d,
	0xc4050078, 0x0080e800,
	0x00000000, 0xbf8a0000,
	0xdac00000, 0x00000000,
	0x807dff7d, 0x00000080,
	0x8078ff78, 0x00000080,
	0xbf0a6f7d, 0xbfa2fff4,
	0xbfa0000c, 0xc4050078,
	0x0080e800, 0x00000000,
	0xbf8a0000, 0xdac00000,
	0x00000000, 0x807dff7d,
	0x00000100, 0x8078ff78,
	0x00000100, 0xbf0a6f7d,
	0xbfa2fff4, 0xbef80080,
	0xbefe00c1, 0x857d9972,
	0x8b7d817d, 0xbf06817d,
	0xbfa20002, 0xbeff0080,
	0xbfa00001, 0xbeff00c1,
	0xb8ef3b05, 0x806f816f,
	0x846f826f, 0x857d9972,
	0x8b7d817d, 0xbf06817d,
	0xbfa2002c, 0xbef600ff,
	0x01000000, 0xbeee0078,
	0x8078ff78, 0x00000200,
	0xbefd0084, 0xbf0a6f7d,
	0xbfa10061, 0xc4050078,
	0x008ce800, 0x00000000,
	0xc4050078, 0x008ce801,
	0x00008000, 0xc4050078,
	0x008ce802, 0x00010000,
	0xc4050078, 0x008ce803,
	0x00018000, 0xbf8a0000,
	0x7e008500, 0x7e028501,
	0x7e048502, 0x7e068503,
	0x807d847d, 0x8078ff78,
	0x00000200, 0xbf0a6f7d,
	0xbfa2ffea, 0xc405006e,
	0x008ce800, 0x00000000,
	0xc405006e, 0x008ce801,
	0x00008000, 0xc405006e,
	0x008ce802, 0x00010000,
	0xc405006e, 0x008ce803,
	0x00018000, 0xbf8a0000,
	0xbfa0003d, 0xbef600ff,
	0x01000000, 0xbeee0078,
	0x8078ff78, 0x00000400,
	0xbefd0084, 0xbf0a6f7d,
	0xbfa10016, 0xc4050078,
	0x008ce800, 0x00000000,
	0xc4050078, 0x008ce801,
	0x00010000, 0xc4050078,
	0x008ce802, 0x00020000,
	0xc4050078, 0x008ce803,
	0x00030000, 0xbf8a0000,
	0x7e008500, 0x7e028501,
	0x7e048502, 0x7e068503,
	0x807d847d, 0x8078ff78,
	0x00000400, 0xbf0a6f7d,
	0xbfa2ffea, 0xb8ef1e06,
	0x8b6fc16f, 0xbfa1000f,
	0x846f836f, 0x806f7d6f,
	0xbefe00c1, 0xbeff0080,
	0xc4050078, 0x008ce800,
	0x00000000, 0xbf8a0000,
	0x7e008500, 0x807d817d,
	0x8078ff78, 0x00000080,
	0xbf0a6f7d, 0xbfa2fff6,
	0xbeff00c1, 0xc405006e,
	0x008ce800, 0x00000000,
	0xc405006e, 0x008ce801,
	0x00010000, 0xc405006e,
	0x008ce802, 0x00020000,
	0xc405006e, 0x008ce803,
	0x00030000, 0xbf8a0000,
	0xb8f83b05, 0x80788178,
	0xbf0d9972, 0xbfa20002,
	0x84788978, 0xbfa00001,
	0x84788a78, 0xb8ee1e06,
	0x846e8a6e, 0x80786e78,
	0x8078ff78, 0x00000200,
	0x80f8ff78, 0x00000050,
	0xbef600ff, 0x01000000,
	0xbefd00ff, 0x0000006c,
	0x80f89078, 0xf462403a,
	0xf0000000, 0xbf8a0000,
	0x80fd847d, 0xbf800000,
	0xbe804300, 0xbe824302,
	0x80f8a078, 0xf462603a,
	0xf0000000, 0xbf8a0000,
	0x80fd887d, 0xbf800000,
	0xbe804300, 0xbe824302,
	0xbe844304, 0xbe864306,
	0x80f8c078, 0xf462803a,
	0xf0000000, 0xbf8a0000,
	0x80fd907d, 0xbf800000,
	0xbe804300, 0xbe824302,
	0xbe844304, 0xbe864306,
	0xbe884308, 0xbe8a430a,
	0xbe8c430c, 0xbe8e430e,
	0xbf06807d, 0xbfa1fff0,
	0xb980f801, 0x00000000,
	0xb8f83b05, 0x80788178,
	0xbf0d9972, 0xbfa20002,
	0x84788978, 0xbfa00001,
	0x84788a78, 0xb8ee1e06,
	0x846e8a6e, 0x80786e78,
	0x8078ff78, 0x00000200,
	0xbef600ff, 0x01000000,
	0xbeff0071, 0xf4621bfa,
	0xf0000000, 0x80788478,
	0xf4621b3a, 0xf0000000,
	0x80788478, 0xf4621b7a,
	0xf0000000, 0x80788478,
	0xf4621c3a, 0xf0000000,
	0x80788478, 0xf4621c7a,
	0xf0000000, 0x80788478,
	0xf4621eba, 0xf0000000,
	0x80788478, 0xf4621efa,
	0xf0000000, 0x80788478,
	0xf4621e7a, 0xf0000000,
	0x80788478, 0xf4621cfa,
	0xf0000000, 0x80788478,
	0xf4621bba, 0xf0000000,
	0x80788478, 0xbf8a0000,
	0xb96ef814, 0xf4621bba,
	0xf0000000, 0x80788478,
	0xbf8a0000, 0xb96ef815,
	0xf4621bba, 0xf0000000,
	0x80788478, 0xbf8a0000,
	0xb96ef812, 0xf4621bba,
	0xf0000000, 0x80788478,
	0xbf8a0000, 0xb96ef813,
	0x8b6eff7f, 0x04000000,
	0xbfa1000d, 0x80788478,
	0xf4621bba, 0xf0000000,
	0x80788478, 0xbf8a0000,
	0xbf0d806e, 0xbfa10006,
	0x856e906e, 0x8b6e6e6e,
	0xbfa10003, 0xbe804ec1,
	0x816ec16e, 0xbfa0fffb,
	0xbefd006f, 0xbefe0070,
	0xbeff0071, 0xb97b2011,
	0x857b867b, 0xb97b0191,
	0x857b827b, 0xb97bba11,
	0xb973f801, 0xb8ee3b05,
	0x806e816e, 0xbf0d9972,
	0xbfa20002, 0x846e896e,
	0xbfa00001, 0x846e8a6e,
	0xb8ef1e06, 0x846f8a6f,
	0x806e6f6e, 0x806eff6e,
	0x00000200, 0x806e746e,
	0x826f8075, 0x8b6fff6f,
	0x0000ffff, 0xf4605c37,
	0xf8000050, 0xf4605d37,
	0xf8000060, 0xf4601e77,
	0xf8000074, 0xbf8a0000,
	0x8b6dff6d, 0x0000ffff,
	0x8bfe7e7e, 0x8bea6a6a,
	0xb97af804, 0xbe804ec2,
	0xbf94fffe, 0xbe804a6c,
	0xbe804ec2, 0xbf94fffe,
	0xbfb10000, 0xbf9f0000,
	0xbf9f0000, 0xbf9f0000,
	0xbf9f0000, 0xbf9f0000,
};

static const uint32_t cwsr_trap_gfx9_5_0_hex[] = {
	0xbf820001, 0xbf8202ca,
	0xb8f8f802, 0x8978ff78,
	0x00020006, 0xb8fbf803,
	0x866eff78, 0x00002000,
	0xbf840009, 0x866eff6d,
	0x00ff0000, 0xbf85001a,
	0x866eff7b, 0x00000400,
	0xbf850051, 0xbf8e0010,
	0xb8fbf803, 0xbf82fffa,
	0x866eff7b, 0x03c00900,
	0xbf850011, 0x866eff7b,
	0x000071ff, 0xbf840008,
	0x866fff7b, 0x00007080,
	0xbf840001, 0xbeee1a87,
	0xb8eff801, 0x8e6e8c6e,
	0x866e6f6e, 0xbf850006,
	0x866eff6d, 0x00ff0000,
	0xbf850003, 0x866eff7b,
	0x00000400, 0xbf85003a,
	0xb8faf807, 0x867aff7a,
	0x001f8000, 0x8e7a8b7a,
	0x8979ff79, 0xfc000000,
	0x87797a79, 0xba7ff807,
	0x00000000, 0xb8faf812,
	0xb8fbf813, 0x8efa887a,
	0xbf0d8f7b, 0xbf840002,
	0x877bff7b, 0xffff0000,
	0xc0031bbd, 0x00000010,
	0xbf8cc07f, 0x8e6e976e,
	0x8979ff79, 0x00800000,
	0x87796e79, 0xc0071bbd,
	0x00000000, 0xbf8cc07f,
	0xc0071ebd, 0x00000008,
	0xbf8cc07f, 0x86ee6e6e,
	0xbf840001, 0xbe801d6e,
	0x866eff6d, 0x01ff0000,
	0xbf850005, 0x8778ff78,
	0x00002000, 0x80ec886c,
	0x82ed806d, 0xbf820005,
	0x866eff6d, 0x01000000,
	0xbf850002, 0x806c846c,
	0x826d806d, 0x866dff6d,
	0x0000ffff, 0x8f7a8b79,
	0x867aff7a, 0x001f8000,
	0xb97af807, 0x86fe7e7e,
	0x86ea6a6a, 0x8f6e8378,
	0xb96ee0c2, 0xbf800002,
	0xb9780002, 0xbe801f6c,
	0x866dff6d, 0x0000ffff,
	0xbefa0080, 0xb97a0283,
	0xb8faf807, 0x867aff7a,
	0x001f8000, 0x8e7a8b7a,
	0x8979ff79, 0xfc000000,
	0x87797a79, 0xba7ff807,
	0x00000000, 0xbeee007e,
	0xbeef007f, 0xbefe0180,
	0xbf900004, 0x877a8478,
	0xb97af802, 0xbf8e0002,
	0xbf88fffe, 0xb8fa2985,
	0x807a817a, 0x8e7a8a7a,
	0x8e7a817a, 0xb8fb1605,
	0x807b817b, 0x8e7b867b,
	0x807a7b7a, 0x807a7e7a,
	0x827b807f, 0x867bff7b,
	0x0000ffff, 0xc04b1c3d,
	0x00000050, 0xbf8cc07f,
	0xc04b1d3d, 0x00000060,
	0xbf8cc07f, 0xc0431e7d,
	0x00000074, 0xbf8cc07f,
	0xbef4007e, 0x8675ff7f,
	0x0000ffff, 0x8775ff75,
	0x00040000, 0xbef60080,
	0xbef700ff, 0x00807fac,
	0xbef1007c, 0xbef00080,
	0xb8f02985, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x80707a70,
	0xbef60084, 0xbef600ff,
	0x01000000, 0xbefe007c,
	0xbefc0070, 0xc0611c7a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611b3a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611b7a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611bba, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611bfa,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611e3a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xb8fbf803,
	0xbefe007c, 0xbefc0070,
	0xc0611efa, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbefe007c,
	0xbefc0070, 0xc0611a3a,
	0x0000007c, 0xbf8cc07f,
	0x80708470, 0xbefc007e,
	0xbefe007c, 0xbefc0070,
	0xc0611a7a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xb8f1f801,
	0xbefe007c, 0xbefc0070,
	0xc0611c7a, 0x0000007c,
	0xbf8cc07f, 0x80708470,
	0xbefc007e, 0xbf108080,
	0x867aff7f, 0x04000000,
	0xbeef0080, 0x876f6f7a,
	0xb8f02985, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fb1605, 0x807b817b,
	0x8e7b847b, 0x8e76827b,
	0xbef600ff, 0x01000000,
	0xbef20174, 0x80747074,
	0x82758075, 0xbefc0080,
	0xbf800000, 0xbe802b00,
	0xbe822b02, 0xbe842b04,
	0xbe862b06, 0xbe882b08,
	0xbe8a2b0a, 0xbe8c2b0c,
	0xbe8e2b0e, 0xc06b003a,
	0x00000000, 0xbf8cc07f,
	0xc06b013a, 0x00000010,
	0xbf8cc07f, 0xc06b023a,
	0x00000020, 0xbf8cc07f,
	0xc06b033a, 0x00000030,
	0xbf8cc07f, 0x8074c074,
	0x82758075, 0x807c907c,
	0xbf0a7b7c, 0xbf85ffe7,
	0xbef40172, 0xbef00080,
	0xbefe00c1, 0xbeff00c1,
	0xbee80080, 0xbee90080,
	0xbef600ff, 0x01000000,
	0x867aff78, 0x00400000,
	0xbf850003, 0xb8faf803,
	0x897a7aff, 0x10000000,
	0xbf85004d, 0xbe840080,
	0xd2890000, 0x00000900,
	0x80048104, 0xd2890001,
	0x00000900, 0x80048104,
	0xd2890002, 0x00000900,
	0x80048104, 0xd2890003,
	0x00000900, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000901, 0x80048104,
	0xd2890001, 0x00000901,
	0x80048104, 0xd2890002,
	0x00000901, 0x80048104,
	0xd2890003, 0x00000901,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000902,
	0x80048104, 0xd2890001,
	0x00000902, 0x80048104,
	0xd2890002, 0x00000902,
	0x80048104, 0xd2890003,
	0x00000902, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000903, 0x80048104,
	0xd2890001, 0x00000903,
	0x80048104, 0xd2890002,
	0x00000903, 0x80048104,
	0xd2890003, 0x00000903,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbf820008,
	0xe0724000, 0x701d0000,
	0xe0724100, 0x701d0100,
	0xe0724200, 0x701d0200,
	0xe0724300, 0x701d0300,
	0xbefe00c1, 0xbeff00c1,
	0xb8fb5306, 0x867bc17b,
	0xbf840052, 0xbf8a0000,
	0x867aff6f, 0x04000000,
	0xbf84004e, 0x8e7b867b,
	0x8e7b827b, 0xbef6007b,
	0xb8f02985, 0x80708170,
	0x8e708a70, 0x8e708170,
	0xb8fa1605, 0x807a817a,
	0x8e7a867a, 0x80707a70,
	0x8070ff70, 0x00000080,
	0xbef600ff, 0x01000000,
	0xbefc0080, 0xd28c0002,
	0x000100c1, 0xd28d0003,
	0x000204c1, 0x867aff78,
	0x00400000, 0xbf850003,
	0xb8faf803, 0x897a7aff,
	0x10000000, 0xbf85001d,
	0x24040682, 0xd86c0000,
	0x00000002, 0xbf8cc07f,
	0xbe840080, 0xd2890000,
	0x00000900, 0x80048104,
	0xd2890001, 0x00000900,
	0x80048104, 0xd2890002,
	0x00000900, 0x80048104,
	0xd2890003, 0x00000900,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0x680404ff,
	0x00000100, 0xd0c9006a,
	0x0000f702, 0xbf87ffe5,
	0xbf820016, 0xd1060002,
	0x00011103, 0x7e0602ff,
	0x00000200, 0xbefc00ff,
	0x00010000, 0xbe800077,
	0x8677ff77, 0xff7fffff,
	0x8777ff77, 0x00058000,
	0xd8ec0000, 0x00000002,
	0xbf8cc07f, 0xe0765000,
	0x701d0002, 0x68040702,
	0xd0c9006a, 0x0000f702,
	0xbefe016a, 0xbf87fff6,
	0xbef70000, 0xbef000ff,
	0x00000400, 0xbefe00c1,
	0xbeff00c1, 0xb8fb2b05,
	0x807b817b, 0x8e7b827b,
	0xbef600ff, 0x01000000,
	0xbefc0084, 0xbf0a7b7c,
	0xbf84006d, 0xbf11017c,
	0x807bff7b, 0x00001000,
	0x867aff78, 0x00400000,
	0xbf850003, 0xb8faf803,
	0x897a7aff, 0x10000000,
	0xbf850051, 0xbe840080,
	0xd2890000, 0x00000900,
	0x80048104, 0xd2890001,
	0x00000900, 0x80048104,
	0xd2890002, 0x00000900,
	0x80048104, 0xd2890003,
	0x00000900, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000901, 0x80048104,
	0xd2890001, 0x00000901,
	0x80048104, 0xd2890002,
	0x00000901, 0x80048104,
	0xd2890003, 0x00000901,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000902,
	0x80048104, 0xd2890001,
	0x00000902, 0x80048104,
	0xd2890002, 0x00000902,
	0x80048104, 0xd2890003,
	0x00000902, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000903, 0x80048104,
	0xd2890001, 0x00000903,
	0x80048104, 0xd2890002,
	0x00000903, 0x80048104,
	0xd2890003, 0x00000903,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0x807c847c,
	0xbf0a7b7c, 0xbf85ffb1,
	0xbf9c0000, 0xbf820012,
	0x7e000300, 0x7e020301,
	0x7e040302, 0x7e060303,
	0xe0724000, 0x701d0000,
	0xe0724100, 0x701d0100,
	0xe0724200, 0x701d0200,
	0xe0724300, 0x701d0300,
	0x807c847c, 0x8070ff70,
	0x00000400, 0xbf0a7b7c,
	0xbf85ffef, 0xbf9c0000,
	0xb8fb2985, 0x807b817b,
	0x8e7b837b, 0xb8fa2b05,
	0x807a817a, 0x8e7a827a,
	0x80fb7a7b, 0x867b7b7b,
	0xbf84007a, 0x807bff7b,
	0x00001000, 0xbefc0080,
	0xbf11017c, 0x867aff78,
	0x00400000, 0xbf850003,
	0xb8faf803, 0x897a7aff,
	0x10000000, 0xbf850059,
	0xd3d84000, 0x18000100,
	0xd3d84001, 0x18000101,
	0xd3d84002, 0x18000102,
	0xd3d84003, 0x18000103,
	0xbe840080, 0xd2890000,
	0x00000900, 0x80048104,
	0xd2890001, 0x00000900,
	0x80048104, 0xd2890002,
	0x00000900, 0x80048104,
	0xd2890003, 0x00000900,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000901,
	0x80048104, 0xd2890001,
	0x00000901, 0x80048104,
	0xd2890002, 0x00000901,
	0x80048104, 0xd2890003,
	0x00000901, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0xbe840080, 0xd2890000,
	0x00000902, 0x80048104,
	0xd2890001, 0x00000902,
	0x80048104, 0xd2890002,
	0x00000902, 0x80048104,
	0xd2890003, 0x00000902,
	0x80048104, 0xc069003a,
	0x00000070, 0xbf8cc07f,
	0x80709070, 0xbf06c004,
	0xbf84ffee, 0xbe840080,
	0xd2890000, 0x00000903,
	0x80048104, 0xd2890001,
	0x00000903, 0x80048104,
	0xd2890002, 0x00000903,
	0x80048104, 0xd2890003,
	0x00000903, 0x80048104,
	0xc069003a, 0x00000070,
	0xbf8cc07f, 0x80709070,
	0xbf06c004, 0xbf84ffee,
	0x807c847c, 0xbf0a7b7c,
	0xbf85ffa9, 0xbf9c0000,
	0xbf820016, 0xd3d84000,
	0x18000100, 0xd3d84001,
	0x18000101, 0xd3d84002,
	0x18000102, 0xd3d84003,
	0x18000103, 0xe0724000,
	0x701d0000, 0xe0724100,
	0x701d0100, 0xe0724200,
	0x701d0200, 0xe0724300,
	0x701d0300, 0x807c847c,
	0x8070ff70, 0x00000400,
	0xbf0a7b7c, 0xbf85ffeb,
	0xbf9c0000, 0xbf8200f4,
	0xbef4007e, 0x8675ff7f,
	0x0000ffff, 0x8775ff75,
	0x00040000, 0xbef60080,
	0xbef700ff, 0x00807fac,
	0x866eff7f, 0x04000000,
	0xbf840025, 0xbefe00c1,
	0xbeff00c1, 0xb8ef5306,
	0x866fc16f, 0xbf840020,
	0x8e6f866f, 0x8e6f826f,
	0xbef6006f, 0xb8f82985,
	0x80788178, 0x8e788a78,
	0x8e788178, 0xb8ee1605,
	0x806e816e, 0x8e6e866e,
	0x80786e78, 0x8078ff78,
	0x00000080, 0xbef600ff,
	0x01000000, 0xbefc0080,
	0xe0510000, 0x781d0000,
	0xe0510100, 0x781d0000,
	0xe0510200, 0x781d0000,
	0xe0510300, 0x781d0000,
	0xe0510400, 0x781d0000,
	0x807cff7c, 0x00000500,
	0x8078ff78, 0x00000500,
	0xbf0a6f7c, 0xbf85fff0,
	0xbefe00c1, 0xbeff00c1,
	0xbef600ff, 0x01000000,
	0xb8ef2b05, 0x806f816f,
	0x8e6f826f, 0x806fff6f,
	0x00008000, 0xbef80080,
	0xbeee0078, 0x8078ff78,
	0x00000400, 0xbefc0084,
	0xbf11087c, 0xe0524000,
	0x781d0000, 0xe0524100,
	0x781d0100, 0xe0524200,
	0x781d0200, 0xe0524300,
	0x781d0300, 0xbf8c0f70,
	0x7e000300, 0x7e020301,
	0x7e040302, 0x7e060303,
	0x807c847c, 0x8078ff78,
	0x00000400, 0xbf0a6f7c,
	0xbf85ffee, 0xb8ef2985,
	0x806f816f, 0x8e6f836f,
	0xb8f92b05, 0x80798179,
	0x8e798279, 0x80ef796f,
	0x866f6f6f, 0xbf84001a,
	0x806fff6f, 0x00008000,
	0xbefc0080, 0xbf11087c,
	0xe0524000, 0x781d0000,
	0xe0524100, 0x781d0100,
	0xe0524200, 0x781d0200,
	0xe0524300, 0x781d0300,
	0xbf8c0f70, 0xd3d94000,
	0x18000100, 0xd3d94001,
	0x18000101, 0xd3d94002,
	0x18000102, 0xd3d94003,
	0x18000103, 0x807c847c,
	0x8078ff78, 0x00000400,
	0xbf0a6f7c, 0xbf85ffea,
	0xbf9c0000, 0xe0524000,
	0x6e1d0000, 0xe0524100,
	0x6e1d0100, 0xe0524200,
	0x6e1d0200, 0xe0524300,
	0x6e1d0300, 0xbf8c0f70,
	0xb8f82985, 0x80788178,
	0x8e788a78, 0x8e788178,
	0xb8ee1605, 0x806e816e,
	0x8e6e866e, 0x80786e78,
	0x80f8c078, 0xb8ef1605,
	0x806f816f, 0x8e6f846f,
	0x8e76826f, 0xbef600ff,
	0x01000000, 0xbefc006f,
	0xc031003a, 0x00000078,
	0x80f8c078, 0xbf8cc07f,
	0x80fc907c, 0xbf800000,
	0xbe802d00, 0xbe822d02,
	0xbe842d04, 0xbe862d06,
	0xbe882d08, 0xbe8a2d0a,
	0xbe8c2d0c, 0xbe8e2d0e,
	0xbf06807c, 0xbf84fff0,
	0xb8f82985, 0x80788178,
	0x8e788a78, 0x8e788178,
	0xb8ee1605, 0x806e816e,
	0x8e6e866e, 0x80786e78,
	0xbef60084, 0xbef600ff,
	0x01000000, 0xc0211bfa,
	0x00000078, 0x80788478,
	0xc0211b3a, 0x00000078,
	0x80788478, 0xc0211b7a,
	0x00000078, 0x80788478,
	0xc0211c3a, 0x00000078,
	0x80788478, 0xc0211c7a,
	0x00000078, 0x80788478,
	0xc0211eba, 0x00000078,
	0x80788478, 0xc0211efa,
	0x00000078, 0x80788478,
	0xc0211a3a, 0x00000078,
	0x80788478, 0xc0211a7a,
	0x00000078, 0x80788478,
	0xc0211cfa, 0x00000078,
	0x80788478, 0xbf8cc07f,
	0xbefc006f, 0xbefe0070,
	0xbeff0071, 0x866f7bff,
	0x000003ff, 0xb96f4803,
	0x866f7bff, 0xfffff800,
	0x8f6f8b6f, 0xb96fa2c3,
	0xb973f801, 0xb8ee2985,
	0x806e816e, 0x8e6e8a6e,
	0x8e6e816e, 0xb8ef1605,
	0x806f816f, 0x8e6f866f,
	0x806e6f6e, 0x806e746e,
	0x826f8075, 0x866fff6f,
	0x0000ffff, 0xc00b1c37,
	0x00000050, 0xc00b1d37,
	0x00000060, 0xc0031e77,
	0x00000074, 0xbf8cc07f,
	0x8f6e8b79, 0x866eff6e,
	0x001f8000, 0xb96ef807,
	0x866dff6d, 0x0000ffff,
	0x86fe7e7e, 0x86ea6a6a,
	0x8f6e837a, 0xb96ee0c2,
	0xbf800002, 0xb97a0002,
	0xbf8a0000, 0xbe801f6c,
	0xbf9b0000, 0x00000000,
};
