/*
 * arch/arm/mach-spear3xx/include/mach/irqs.h
 *
 * IRQ helper macros for SPEAr3xx machine family
 *
 * Copyright (C) 2009 ST Microelectronics
 * Viresh Kumar<viresh.kumar@st.com>
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2. This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */

#ifndef __MACH_IRQS_H
#define __MACH_IRQS_H

/* SPEAr3xx IRQ definitions */
#define SPEAR3XX_IRQ_HW_ACCEL_MOD_0		0
#define SPEAR3XX_IRQ_INTRCOMM_RAS_ARM		1
#define SPEAR3XX_IRQ_CPU_GPT1_1			2
#define SPEAR3XX_IRQ_CPU_GPT1_2			3
#define SPEAR3XX_IRQ_BASIC_GPT1_1		4
#define SPEAR3XX_IRQ_BASIC_GPT1_2		5
#define SPEAR3XX_IRQ_BASIC_GPT2_1		6
#define SPEAR3XX_IRQ_BASIC_GPT2_2		7
#define SPEAR3XX_IRQ_BASIC_DMA			8
#define SPEAR3XX_IRQ_BASIC_SMI			9
#define SPEAR3XX_IRQ_BASIC_RTC			10
#define SPEAR3XX_IRQ_BASIC_GPIO			11
#define SPEAR3XX_IRQ_BASIC_WDT			12
#define SPEAR3XX_IRQ_DDR_CONTROLLER		13
#define SPEAR3XX_IRQ_SYS_ERROR			14
#define SPEAR3XX_IRQ_WAKEUP_RCV			15
#define SPEAR3XX_IRQ_JPEG			16
#define SPEAR3XX_IRQ_IRDA			17
#define SPEAR3XX_IRQ_ADC			18
#define SPEAR3XX_IRQ_UART			19
#define SPEAR3XX_IRQ_SSP			20
#define SPEAR3XX_IRQ_I2C			21
#define SPEAR3XX_IRQ_MAC_1			22
#define SPEAR3XX_IRQ_MAC_2			23
#define SPEAR3XX_IRQ_USB_DEV			24
#define SPEAR3XX_IRQ_USB_H_OHCI_0		25
#define SPEAR3XX_IRQ_USB_H_EHCI_0		26
#define SPEAR3XX_IRQ_USB_H_EHCI_1		SPEAR3XX_IRQ_USB_H_EHCI_0
#define SPEAR3XX_IRQ_USB_H_OHCI_1		27
#define SPEAR3XX_IRQ_GEN_RAS_1			28
#define SPEAR3XX_IRQ_GEN_RAS_2			29
#define SPEAR3XX_IRQ_GEN_RAS_3			30
#define SPEAR3XX_IRQ_HW_ACCEL_MOD_1		31
#define SPEAR3XX_IRQ_VIC_END			32

#define SPEAR3XX_VIRQ_START			SPEAR3XX_IRQ_VIC_END

/* SPEAr300 Virtual irq definitions */
/* IRQs sharing IRQ_GEN_RAS_1 */
#define SPEAR300_VIRQ_IT_PERS_S			(SPEAR3XX_VIRQ_START + 0)
#define SPEAR300_VIRQ_IT_CHANGE_S		(SPEAR3XX_VIRQ_START + 1)
#define SPEAR300_VIRQ_I2S			(SPEAR3XX_VIRQ_START + 2)
#define SPEAR300_VIRQ_TDM			(SPEAR3XX_VIRQ_START + 3)
#define SPEAR300_VIRQ_CAMERA_L			(SPEAR3XX_VIRQ_START + 4)
#define SPEAR300_VIRQ_CAMERA_F			(SPEAR3XX_VIRQ_START + 5)
#define SPEAR300_VIRQ_CAMERA_V			(SPEAR3XX_VIRQ_START + 6)
#define SPEAR300_VIRQ_KEYBOARD			(SPEAR3XX_VIRQ_START + 7)
#define SPEAR300_VIRQ_GPIO1			(SPEAR3XX_VIRQ_START + 8)

/* IRQs sharing IRQ_GEN_RAS_3 */
#define SPEAR300_IRQ_CLCD			SPEAR3XX_IRQ_GEN_RAS_3

/* IRQs sharing IRQ_INTRCOMM_RAS_ARM */
#define SPEAR300_IRQ_SDHCI			SPEAR3XX_IRQ_INTRCOMM_RAS_ARM

/* SPEAr310 Virtual irq definitions */
/* IRQs sharing IRQ_GEN_RAS_1 */
#define SPEAR310_VIRQ_SMII0			(SPEAR3XX_VIRQ_START + 0)
#define SPEAR310_VIRQ_SMII1			(SPEAR3XX_VIRQ_START + 1)
#define SPEAR310_VIRQ_SMII2			(SPEAR3XX_VIRQ_START + 2)
#define SPEAR310_VIRQ_SMII3			(SPEAR3XX_VIRQ_START + 3)
#define SPEAR310_VIRQ_WAKEUP_SMII0		(SPEAR3XX_VIRQ_START + 4)
#define SPEAR310_VIRQ_WAKEUP_SMII1		(SPEAR3XX_VIRQ_START + 5)
#define SPEAR310_VIRQ_WAKEUP_SMII2		(SPEAR3XX_VIRQ_START + 6)
#define SPEAR310_VIRQ_WAKEUP_SMII3		(SPEAR3XX_VIRQ_START + 7)

/* IRQs sharing IRQ_GEN_RAS_2 */
#define SPEAR310_VIRQ_UART1			(SPEAR3XX_VIRQ_START + 8)
#define SPEAR310_VIRQ_UART2			(SPEAR3XX_VIRQ_START + 9)
#define SPEAR310_VIRQ_UART3			(SPEAR3XX_VIRQ_START + 10)
#define SPEAR310_VIRQ_UART4			(SPEAR3XX_VIRQ_START + 11)
#define SPEAR310_VIRQ_UART5			(SPEAR3XX_VIRQ_START + 12)

/* IRQs sharing IRQ_GEN_RAS_3 */
#define SPEAR310_VIRQ_EMI			(SPEAR3XX_VIRQ_START + 13)
#define SPEAR310_VIRQ_PLGPIO			(SPEAR3XX_VIRQ_START + 14)

/* IRQs sharing IRQ_INTRCOMM_RAS_ARM */
#define SPEAR310_VIRQ_TDM_HDLC			(SPEAR3XX_VIRQ_START + 15)
#define SPEAR310_VIRQ_RS485_0			(SPEAR3XX_VIRQ_START + 16)
#define SPEAR310_VIRQ_RS485_1			(SPEAR3XX_VIRQ_START + 17)

/* SPEAr320 Virtual irq definitions */
/* IRQs sharing IRQ_GEN_RAS_1 */
#define SPEAR320_VIRQ_EMI			(SPEAR3XX_VIRQ_START + 0)
#define SPEAR320_VIRQ_CLCD			(SPEAR3XX_VIRQ_START + 1)
#define SPEAR320_VIRQ_SPP			(SPEAR3XX_VIRQ_START + 2)

/* IRQs sharing IRQ_GEN_RAS_2 */
#define SPEAR320_IRQ_SDHCI			SPEAR3XX_IRQ_GEN_RAS_2

/* IRQs sharing IRQ_GEN_RAS_3 */
#define SPEAR320_VIRQ_PLGPIO			(SPEAR3XX_VIRQ_START + 3)
#define SPEAR320_VIRQ_I2S_PLAY			(SPEAR3XX_VIRQ_START + 4)
#define SPEAR320_VIRQ_I2S_REC			(SPEAR3XX_VIRQ_START + 5)

/* IRQs sharing IRQ_INTRCOMM_RAS_ARM */
#define SPEAR320_VIRQ_CANU			(SPEAR3XX_VIRQ_START + 6)
#define SPEAR320_VIRQ_CANL			(SPEAR3XX_VIRQ_START + 7)
#define SPEAR320_VIRQ_UART1			(SPEAR3XX_VIRQ_START + 8)
#define SPEAR320_VIRQ_UART2			(SPEAR3XX_VIRQ_START + 9)
#define SPEAR320_VIRQ_SSP1			(SPEAR3XX_VIRQ_START + 10)
#define SPEAR320_VIRQ_SSP2			(SPEAR3XX_VIRQ_START + 11)
#define SPEAR320_VIRQ_SMII0			(SPEAR3XX_VIRQ_START + 12)
#define SPEAR320_VIRQ_MII1_SMII1		(SPEAR3XX_VIRQ_START + 13)
#define SPEAR320_VIRQ_WAKEUP_SMII0		(SPEAR3XX_VIRQ_START + 14)
#define SPEAR320_VIRQ_WAKEUP_MII1_SMII1		(SPEAR3XX_VIRQ_START + 15)
#define SPEAR320_VIRQ_I2C1			(SPEAR3XX_VIRQ_START + 16)

/*
 * GPIO pins virtual irqs
 * Use the lowest number for the GPIO virtual IRQs base on which subarchs
 * we have compiled in
 */
#if defined(CONFIG_MACH_SPEAR310)
#define SPEAR3XX_GPIO_INT_BASE			(SPEAR3XX_VIRQ_START + 18)
#elif defined(CONFIG_MACH_SPEAR320)
#define SPEAR3XX_GPIO_INT_BASE			(SPEAR3XX_VIRQ_START + 17)
#else
#define SPEAR3XX_GPIO_INT_BASE			(SPEAR3XX_VIRQ_START + 9)
#endif

#define SPEAR300_GPIO1_INT_BASE			(SPEAR3XX_GPIO_INT_BASE + 8)
#define SPEAR3XX_PLGPIO_COUNT	102

#if defined(CONFIG_MACH_SPEAR310) || defined(CONFIG_MACH_SPEAR320)
#define SPEAR3XX_PLGPIO_INT_BASE		(SPEAR3XX_GPIO_INT_BASE + 8)
#define SPEAR3XX_GPIO_INT_END			(SPEAR3XX_PLGPIO_INT_BASE + \
							SPEAR3XX_PLGPIO_COUNT)
#else
#define SPEAR3XX_GPIO_INT_END	(SPEAR300_GPIO1_INT_BASE + 8)
#endif

#define SPEAR3XX_VIRQ_END	SPEAR3XX_GPIO_INT_END
#define NR_IRQS			SPEAR3XX_VIRQ_END

#endif /* __MACH_IRQS_H */
