#ifndef _TAS_H
#define _TAS_H

typedef struct {
	u32	val;
} __aligned(4) arch_spinlock_t;

#define __ARCH_SPIN_LOCK_UNLOCKED	{ 0 }

static void arch_spin_lock(arch_spinlock_t *l)
{
	u32 old;

	do {
		old = __sync_lock_test_and_set(&l->val, 1);
	} while (old);
}

static void arch_spin_unlock(arch_spinlock_t *l)
{
	__sync_lock_release(&l->val);
}

#endif	/* _TAS_H */
