/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2006-2010  Nokia Corporation
 *  Copyright (C) 2004-2010  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

struct audio_device;
struct source;
struct control;
struct sink;
struct dev_priv;

typedef void (*audio_device_cb) (struct audio_device *dev, int err, void *data);

struct audio_device {
	struct btd_device *btd_dev;

	struct sink *sink;
	struct source *source;
	struct control *control;

	struct dev_priv *priv;
};

struct audio_device *audio_device_register(struct btd_device *device);

void audio_device_unregister(struct audio_device *device);

gboolean audio_device_is_active(struct audio_device *dev,
						const char *interface);
